<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'chat', language 'sr_lt', branch 'MOODLE_26_STABLE'
 *
 * @package   chat
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Sledi sesija u pričaonici';
$string['ajax'] = 'Verzija koja koristi Ajax';
$string['autoscroll'] = 'Automatsko pomeranje';
$string['beep'] = 'Zvučni signal';
$string['bubble'] = 'Oblačić';
$string['cantlogin'] = 'Nije bilo moguće prijaviti se u pričaonicu!!';
$string['chat:addinstance'] = 'Dodaj novi razgovor';
$string['chat:chat'] = 'Učestvuj u razgovoru';
$string['chat:deletelog'] = 'Obriši zapise razgovora';
$string['chat:exportparticipatedsession'] = 'Izvezite sesiju u kojoj ste učestvovali';
$string['chat:exportsession'] = 'Izvezite sve sesije';
$string['chatintro'] = 'Opis';
$string['chatname'] = 'Naziv ove pričaonice';
$string['chat:readlog'] = 'Pročitaj zapise razgovora';
$string['chatreport'] = 'Razgovori';
$string['chat:talk'] = 'Razgovarajte u pričaonici';
$string['chattime'] = 'Vreme narednog razgovora';
$string['compact'] = 'Kompaktno';
$string['composemessage'] = 'Kreiraj poruku';
$string['configmethod'] = 'Ajax režim pričaonice pruža interfejs koji je baziran na Ajax tehnologiji, i koji redovno komunicira sa serverom zbog ažuriranja sadržaja. Normalan režim rada pričaonice podrazumeva da korisnici konstantno komuniciraju sa serverom zbog ažuriranja sadržaja. Ovaj režim ne zahteva posebnu konfiguraciju i funkcioniše u svim okruženjima, ali može jako da optereti server ako je broj korisnika veliki. Sa druge strane, korišćenje IRC servera zahteva tzv. <i>shell</i> pristup Unix-u, ali zato pruža brzo i lako podesivo <i>chat</i> okruženje.';
$string['confignormalupdatemode'] = 'Ažuriranje pričaonice se najčešće efikasno izvodi pomoću <em>Keep-Alive</em> opcije HTTP-a 1.1, ali to još uvek prilično opterećuje server. Napredniji način je korišćenje <em>Stream</em> strategije za prikaz promena korisnicima. Korišćenje <em>Stream</em> ažuriranja se pokazalo kao mnogo bolje rešenje (slično chatd metodu) ali je moguće da ga Vaš server ne podržava.';
$string['configoldping'] = 'Koje je maksimalno vreme (u sekundama) nakon kojeg će biti detektovano da je korisnik izašao iz pričaonice. To je samo gornje ograničenje pošto se diskonekcije korisnika obično otkrivaju vrlo brzo. Niže vrednosti će dodatno opteretiti Vaš server. Ukoliko koristite normalan režim rada za pričaonicu <strong>nikad</strong> nemojte ovu vrednost postaviti na manje od 2 * chat_refresh_room.';
$string['configrefreshroom'] = 'Koliko često bi trebalo da se osvežava pričaonica? (u sekundama) Postavljanje niskih vrednosti omogućava da pričaonica izgleda brže, ali može predstavljati veće opterećenje za Vaš Web server kad je u pričaonicama prisutan veći broj ljudi. Ako koristite <em>Stream</em> ažuriranje, možete izabrati češće osvežavanje -- probajte sa 2 sekunde.';
$string['configrefreshuserlist'] = 'Koliko često bi spisak korisnika trebalo da bude osvežavan? (u sekundama)';
$string['configserverhost'] = 'Ime glavnog računara na kojem se nalazi IRC server';
$string['configserverip'] = 'Numerička IP adresa koja odgovara navedenom računaru';
$string['configservermax'] = 'Maksimalan broj dozvoljenih klijenata';
$string['configserverport'] = 'Port na serveru za IRC daemon';
$string['coursetheme'] = 'Tema kursa';
$string['currentchats'] = 'Aktivni razgovori';
$string['currentusers'] = 'Trenutni korisnici';
$string['deletesession'] = 'Obriši ovu sesije';
$string['deletesessionsure'] = 'Da li ste sigurni da želite da obrišete ovu sesiju?';
$string['donotusechattime'] = 'Ne objavljivati vreme sledećeg razgovora (sesije)';
$string['enterchat'] = 'Kliknite ovde za ulazak u pričaonicu';
$string['entermessage'] = 'Unesite vašu poruku';
$string['errornousers'] = 'Nije pronađen nijedan korisnik!';
$string['event_instances_list_viewed'] = 'Spisak instanci prikazan';
$string['event_message_sent'] = 'Poruka poslata';
$string['event_sessions_viewed'] = 'Sesija prikazana';
$string['explaingeneralconfig'] = 'Ova podešavanja se <strong>uvek</strong> koriste';
$string['explainmethoddaemon'] = 'Ova podešavanja su aktivna <strong>samo</strong> ako ste izabrali opciju "IRC server daemon"';
$string['explainmethodnormal'] = 'Ova podešavanja su aktivna <strong>samo</strong> ako ste izabrali opciju "Normalan režim"';
$string['generalconfig'] = 'Opšta konfiguracija';
$string['idle'] = 'Neaktivan';
$string['inputarea'] = 'Područje za unos teksta';
$string['invalidid'] = 'Nije bilo moguće pronaći tu pričaonicu!';
$string['list_all_sessions'] = 'Prikaži sve sesije';
$string['list_complete_sessions'] = 'Prikaži samo završene sesije';
$string['listing_all_sessions'] = 'Spisak svih sesija';
$string['messagebeepseveryone'] = 'Učesnik {$a} signalizira svima!';
$string['messagebeepsyou'] = 'Učesnik {$a} Vam upravo šalje zvučni signal!';
$string['messageenter'] = 'Učesnik {$a} upravo ulazi u pričaonicu';
$string['messageexit'] = 'Učesnik {$a} upravo napušta pričaonicu';
$string['messages'] = 'Poruke';
$string['messageyoubeep'] = 'Poslat Vam je zvučni signal {$a}';
$string['method'] = 'Chat režim';
$string['methodajax'] = 'Ajax metod';
$string['methoddaemon'] = 'IRC server daemon';
$string['methodnormal'] = 'Normalan režim';
$string['modulename'] = 'Pričaonica';
$string['modulename_help'] = 'Modul aktivnosti \'Pričaonica\' omogućava učesnicima da vode sinhrone tekstualne diskusije u realnom vremenu.

Pričaonica može biti jednokratna aktivnost ili se može ponavljati u isto vreme svakoga dana ili svake nedelje. Sesije u pričaonici se čuvaju i mogu biti dostupne svakome da ih pogleda, ili ograničene na one korisnike koji imaju mogućnost da vide zapise sesija.

Pričanica je naročito korisna za rad u grupi, kada članovi grupe nemaju prilike da se sretnu uživo, kao na primer:

* regularni  susreti polaznika koji učestvuju na onlajn kursu, kako bi im se omogućili da svoja svoja iskustva podele sa drugima koji su učesnici istog kursa ali žive u različitim mestima
* polaznici koji su iz bilo kog razloga sprečeni da prisustvuju tradiocionalnoj nastavi, pričaonica omogućava da razgovaraju sa svojim predavačima i na taj način ne zaostaju sa gradivom.
* mlađa deca koja koriste pričaonicu kod kuće u večernjim časovima kao kontrolisani (nadgledani) uvod u svet socijalnih mreža.
* sesija pitanja i odgovora sa pozvanim predavačem koji živi u drugom mestu.
* kao pomoć polaznicima da se pripreme za test gde predavač ili drugi polaznici mogu da postavljaju primere pitanja sličnih onim koji će polaznici imati na testu.';
$string['modulenameplural'] = 'Pričaonice';
$string['neverdeletemessages'] = 'Nikada ne briši poruke';
$string['nextsession'] = 'Naredna planirana sesija';
$string['nochat'] = 'Nije pronađena nijedna pričaonica';
$string['no_complete_sessions_found'] = 'Nema završenih sesija';
$string['noguests'] = 'Ova pričaonica nije otvorena za goste';
$string['nomessages'] = 'Još nema poruka';
$string['nopermissiontoseethechatlog'] = 'Nemate pravo da vidite zapise razgovora';
$string['normalkeepalive'] = 'KeepAlive';
$string['normalstream'] = 'Tok (Stream)';
$string['noscheduledsession'] = 'Nema zakazanih sesija';
$string['notallowenter'] = 'Nije vam dozvoljen ulazak u pričaonicu';
$string['notlogged'] = 'Niste prijavljeni!';
$string['oldping'] = 'Vreme čekanja na raskid konekcije';
$string['page-mod-chat-x'] = 'Bilo koja stranica modula \'Pričaonica\'';
$string['pastchats'] = 'Prethodne sesije';
$string['pluginadministration'] = 'Administracija pričaonice (chata)';
$string['pluginname'] = 'Pričaonica';
$string['refreshroom'] = 'Osveži sobu';
$string['refreshuserlist'] = 'Osveži listu korisnika';
$string['removemessages'] = 'Ukloni sve poruke';
$string['repeatdaily'] = 'Svaki dan u isto vreme';
$string['repeatnone'] = 'Nema ponavljanja - objaviti samo određeno vreme';
$string['repeattimes'] = 'Ponovite/objavite vreme sesija';
$string['repeatweekly'] = 'Svake sedmice u isto vreme';
$string['saidto'] = '<b>rečeno učesniku</b>';
$string['savemessages'] = 'Sačuvaj prethodne sesije';
$string['seesession'] = 'Pogledaj ovu sesiju';
$string['send'] = 'Pošalji';
$string['sending'] = 'Šalje se';
$string['serverhost'] = 'Ime servera';
$string['serverip'] = 'IP adresa servera';
$string['servermax'] = 'Maksimalan broj korisnika';
$string['serverport'] = 'Port na serveru';
$string['sessions'] = 'Razgovori';
$string['sessionstart'] = 'Sledeća sesija će početi za: {$a}';
$string['strftimemessage'] = '%H:%M';
$string['studentseereports'] = 'Svako može videti prethodne sesije';
$string['studentseereports_help'] = 'Ako je postavljeno na Ne, samo korisnici koji imaju sposobnost mod/chat:readlog mogu da vide zapise prethodnih razgovora';
$string['talk'] = 'Govori';
$string['updatemethod'] = 'Način ažuriranja';
$string['updaterate'] = 'Brzina ažuriranja:';
$string['userlist'] = 'Spisak korisnika';
$string['usingchat'] = 'Korišćenje pričaonice';
$string['usingchat_help'] = '<p align="center"><b>Korišćenje ČETA (Using Chat)


<p>Čet -element&nbsp; sadrži neke odlike koji četovanje čini malo lepšim.</p>

<dl>
<dt><b>Osmesi</b></dt>
<dd>Svako nasmejano lice (ikonice emocija) koje možete ukucati  bilo gde,
    i u Moodle-u se takođe može korektno predstaviti. Na primer :-) = <img alt="smiley" src="pix/s/smiley.gif" />  </dd>
</dd>

<dt><b>Linkovi</b></dt>
<dd>Internet adrese biće automatski pretvorene u linkove </dd>

<dt><b>Iskazivanje emocija</b></dt>
<dd>Liniju možete započeti sa &quot;/ja&quot; ili &quot;:&quot; za emocije. Na primer, ako je vaše
ime Kim, i ukucate &quot;:smejati se!&quot; ili &quot;/ja se smejem!&quot; tada će&nbsp; to svi
posmatrati kao&nbsp;: &quot;Kim se smeje!&quot; </dd>

<dt><b>Bipovanje-Beeps</b></dt>
<dd>Možete poslati zvuke drugim ljudima navodeći link &quot;beep&quot; pored njihovog imena.
Korisna prečica do beep-a, je ako svi ljudi sa četa odaberu opciju &quot;beep&nbsp;all&quot;, da
kod svih istovremeno funkcioniše bipovanje. </dd>

<dt><b>HTML</b></dt>
<dd>Ako poznajete HTML k<span lang="en"><font face="Times New Roman">ô</font></span>d, možete ga koristiti u tekstu,&nbsp; da bi ubacivali
slike, puštali zvuke, ili kreirali tekst raznih boja i veličina. </dd>

</dl>';
$string['viewreport'] = 'Pogledaj prethodne sesije';
