<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_db', language 'sr_lt', branch 'MOODLE_26_STABLE'
 *
 * @package   auth_db
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_dbcantconnect'] = 'Nije bilo moguće povetati se navedenom bazom podataka za proveru identiteta...';
$string['auth_dbchangepasswordurl_key'] = 'URL za promenu lozinke';
$string['auth_dbdebugauthdb'] = 'Otklonite ADOdb grešku';
$string['auth_dbdebugauthdbhelp'] = 'Otklonite grešku u ADOdb konekciji sa eksternom bazom podataka - upotrebite u situaciji kada tokom prijave na sistem dobijate praznu stranicu. Nije pogodno za sajtove na kojima ima aktivnih kurseva.';
$string['auth_dbdeleteuser'] = 'Obrisani korisnik {$a->name} id {$a->id}';
$string['auth_dbdeleteusererror'] = 'Greška prilikom brisanja korisnika {$a}';
$string['auth_dbdescription'] = 'Ovaj metod koristi eksterne tabele baze podtaka ѕa proveru da li su dato korisničko ime i lozinka ispravni. Ukoliko je nalog nov, onda informacija iz drugih ponja mogu biti prekopirane u Moodleu.';
$string['auth_dbextencoding'] = 'Kordni raspored eksterne baze podataka';
$string['auth_dbextencodinghelp'] = 'Kodni raspored korišćen u eksternoj bazi podataka';
$string['auth_dbextrafields'] = 'Ova ponja su opciona. Možete da izaberete da prethodno popunite neka Moodle korisnička polja sa informacijam iz <b>polja eksterne baza podataka</b> koja ovde navedete.<p>Ukoliko ova polja ostavite prazna, biće korišćene podrazumevane vrednosti.</p><p>U svakom slučaju korisni će moći da uređuju sva ova ponja nakon što se prijave na sistem.</p>';
$string['auth_dbfieldpass'] = 'Ime polja koje sadrži lozinke';
$string['auth_dbfieldpass_key'] = 'Polje lozinke';
$string['auth_dbfielduser'] = 'Ime polja koje sadrži korisnička imena';
$string['auth_dbfielduser_key'] = 'Polje korisničkog imena';
$string['auth_dbhost'] = 'Ovaj računar je domaćin servera baze podataka. Koristite sistemski DSN unos ako koristite ODBC.';
$string['auth_dbhost_key'] = 'Računar domaćin';
$string['auth_dbinsertuser'] = 'Umetnuti korisnik {$a->name} id {$a->id}';
$string['auth_dbinsertuserduplicate'] = 'Greška prilikom ubacivanja korisnika  {$a->username} - korisnik sa ovim korisničkim imenom već je kreiran pomoću dodatka za proveru identiteta \'{$a->auth}\' .';
$string['auth_dbinsertusererror'] = 'Greška prilikom ubacivanja korisnika {$a}';
$string['auth_dbname'] = 'Ime same baze podataka. Ostavite prazno ako koristite ODBC DSN.';
$string['auth_dbname_key'] = 'Naziv baze podataka';
$string['auth_dbpass'] = 'Lozinka se poklapa sa gornjim korisničkim imenom';
$string['auth_dbpass_key'] = 'Lozinka';
$string['auth_dbpasstype'] = '<p>Odredite format koje koristi polje za lozinku. MD5 "hashing" je koristan ѕa povezivanje sa drugim uobičajenim veb aplikacijama kao što je PostNuke.</p> <p>Upotrebite \'interno\' ukoliko želite da spoljna baza podataka upravlja korisničkim imenima & elektronskim adresama, a Moodle lozinkama. Ako koristite format \'interno\', <i>morate</i> da obezbedite polja popunjena elektronskim adresama u eksternoj bazi podataka. Takođe, morate redovno da pokrećete komande admin/cron.php i auth/db/auth_db_sync_users.php. Moodle će novim korisnicima poslati e-poruku sa privremenom lozinkom.</p>';
$string['auth_dbpasstype_key'] = 'Format lozinke';
$string['auth_dbreviveduser'] = 'Ponovo aktivirani korisnik {$a->name} id {$a->id}';
$string['auth_dbrevivedusererror'] = 'Greška u ponovnom aktiviranju korisnika {$a}';
$string['auth_dbsetupsql'] = 'SQL komanda postavaljanja';
$string['auth_dbsetupsqlhelp'] = 'SQL komanda za posebno podešavanje baza podtaka, često korišćena za podešavanje kodnog raspored - na primer za MySQL i PostgreSQL: <em>SET NAMES \'utf8\'</em>';
$string['auth_dbsuspenduser'] = 'Suspendovani korisnik {$a->name} id {$a->id}';
$string['auth_dbsuspendusererror'] = 'Greška prilikom suspendovanja korisnika {$a}';
$string['auth_dbsybasequoting'] = 'Koristi navodnike Sybase baze podataka';
$string['auth_dbsybasequotinghelp'] = 'Sybase stil izlaza jednostrukim navodnicima - potrebno za Oracle, MS SQL i neke druge baze podataka. Ne koristiti za  MySQL!';
$string['auth_dbtable'] = 'Ime tabele u bazi podataka';
$string['auth_dbtable_key'] = 'Tabela';
$string['auth_dbtype'] = 'Tip baze podataka (Pogledaj <a href="http://phplens.com/adodb/supported.databases.html" target="_blank">ADOdb dokumentacija</a>)';
$string['auth_dbtype_key'] = 'Baza podataka';
$string['auth_dbupdatinguser'] = 'Ažuriranje korisnika {$a->name} id {$a->id}';
$string['auth_dbuser'] = 'Korisničko ime sa pravom čitanja baze podataka';
$string['auth_dbuser_key'] = 'Korisnik baze podataka';
$string['auth_dbusernotexist'] = 'Nije moguće ažurirati nepostojećeg korisnika: {$a}';
$string['auth_dbuserstoadd'] = 'Korisničkih unosa za dodavanje: {$a}';
$string['auth_dbuserstoremove'] = 'Korisničkih unosa za uklanjanje: {$a}';
$string['pluginname'] = 'Eksterna baza podataka';
