<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth', language 'sr_lt', branch 'MOODLE_26_STABLE'
 *
 * @package   auth
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actauthhdr'] = 'Dostupni dodaci za proveru identiteta';
$string['alternatelogin'] = 'Ako ovde unesete URL, biće korišćen kao stranica za prijavu na ovaj sajt. Stranica bi trebala sadržati formu sa akcijskom opcijom podešenom na <strong>\'{$a}\'</strong> i vraćanjem polja <strong>username</strong> i <strong>password</strong>.<br />Budite oprezni da ne biste slučajno uneli pogrešan URL i time sami sebi onemogućili pristup sajtu.<br />Ostavite ovo podešavanje prazno da biste koristili podrazumevanu stranicu za pristup sistemu.';
$string['alternateloginurl'] = 'Alternativna URL adresa za prijavu na sistem';
$string['auth_changepasswordhelp'] = 'Promena pomoći za lozinku';
$string['auth_changepasswordhelp_expl'] = 'Prikaz pomoći za slučaj izgubljene lozinke korisnicima koji su izgubili svoju {$a} lozinku. To će biti prikazano ili isto kao ili umesto <strong>URL-a za promenu lozinke</strong> ili interne promene Moodle lozinke.';
$string['auth_changepasswordurl'] = 'URL za promenu lozinke';
$string['auth_changepasswordurl_expl'] = 'Specificirajte URL koji će se slati korisnicima koji izgube svoje {$a} lozinke. Podesite<strong>Koristiti standardnu stranicu za promenu lozinke</strong> na <strong>Ne</strong>.';
$string['auth_changingemailaddress'] = 'Zatražili ste da staru adrese e-pošte  {$a->oldemail} promenite u novu {$a->newemail}. Iz  razloga bezbednosti, šaljemo vam e-poruku na novu adresu kako bi potvrdili da ona zaista pripada vama. Vaša adresa e-pošte biće ažurirana čim otvorite URL koja vam je poslat u toj poruci.';
$string['auth_common_settings'] = 'Opšta podešavanja';
$string['auth_data_mapping'] = 'Mapiranje podataka';
$string['authenticationoptions'] = 'Opcije za proveru identiteta';
$string['auth_fieldlock'] = 'Zaključavanje vrednosti';
$string['auth_fieldlock_expl'] = '<p><b>Zaključavanje vrednosti:</b> Ako je omogućeno, sprečiće Moodle korisnike i administratore da direktno uređuju polje. Koristite ovu opciju ako održavate ove podatke u eksternom autentikacionom sistemu. </p>';
$string['auth_fieldlocks'] = 'Zaključavanje korisničkih polja';
$string['auth_fieldlocks_help'] = '<p>Možete zaključati polja sa korisničkim podacima. To je korisno za sajtove na kojima korisničke podatke ručno održavaju administratori uređivanjem korisničkih zapisa u bazi podataka ili postavljanjem podataka korišćenjem opcije  \'Postavljanje korisnika\'. Ako zaključavate polja koja su neophodna za rad Moodle sistema, proverite da li ste, prilikom kreiranja korisničkih naloga, popunili ta polja odgovarajućim podacima, jer se u suprotnom nalozi neće moći koristiti.</p><p>Podesite vrednost za zaključavanje na \'Otključano ako je prazno\' da biste izbegli navedeni problem.</p>';
$string['authinstructions'] = 'Ostavite ovo polje prazno ako želite da se korisnicima prikazuju podrazumevane instrukcije za prijavu na sistem na naslovnoj strani. Ako želite da im ponudite neke posebne instrukcije unesite ih ovde.';
$string['auth_invalidnewemailkey'] = 'Greška: ako pokušavate da potvrdite promenu adrese e-pošte, možda ste napravili grešku pri kopiranju URL adrese koju smo Vam poslali putem e-pošte. Molimo, kopirajte adresu i pokušajte ponovo.';
$string['auth_multiplehosts'] = 'Određivanje više domaćina ili adresa (npr. host1.com;host2.com;host3.com) ili (npr. xxx.xxx.xxx.xxx;xxx.xxx.xxx.xxx)';
$string['auth_outofnewemailupdateattempts'] = 'Potrošili ste dozvoljeni broj pokušaja za promenu adrese e-pošte. Vaš zahtev za promenu je odbijen.';
$string['auth_passwordisexpired'] = 'Vaša lozinka je istekla. Da li želite da je promenite sada?';
$string['auth_passwordwillexpire'] = 'Vaša lozinka ističe za {$a} dan/a.  Da li želite da je promenite sada?';
$string['auth_remove_delete'] = 'Potpuno brisanje internih podataka';
$string['auth_remove_keep'] = 'Zadržavanje internih podataka';
$string['auth_remove_suspend'] = 'Obustavljanje internih podataka';
$string['auth_remove_user'] = 'Odredite šta raditi sa unutrašnjim korisničkim nalogom za vreme masovne sinhronizacije kada je korisnik uklonjen od strane spoljnog izvora. Samo obustavljeni korisnici se automatski obnavljaju ako se ponovo pojavljuju u spoljnom izvoru.';
$string['auth_remove_user_key'] = 'Uklonjen spoljni korisnik';
$string['auth_sync_script'] = 'Skripta sinhronizacije krona';
$string['auth_updatelocal'] = 'Ažuriranje lokalnih podataka';
$string['auth_updatelocal_expl'] = '<p><b>Ažuriranje lokalnih podataka:</b> Ako je omogućeno, polje će biti ažurirano (koristi se eksterni auth) svaki put kada korisnik pristupi sistemu ili dođe do korisničke sinhronizacije. Polja za koja je podešeno lokalno ažuriranje bi trebala biti zaključana.</p>';
$string['auth_updateremote'] = 'Ažuriranje eksternih podataka';
$string['auth_updateremote_expl'] = '<p><b>Ažuriranje eksternih podataka:</b> Ako je omogućeno, eksterni auth će biti ažuriran pri ažuriranju zapisa o korisnicima. Polja bi trebala biti otključana da bi se dozvolile promene.</p>';
$string['auth_updateremote_ldap'] = '<p><b>Napomene:</b> Ažuriranje eksternih LDAP podataka zahteva da podesite povezivanje binddn i bindpw za bind-korisnika sa privilegijama korigovanja svih korisničkih zapisa. Ovo trenutno ne čuva viševrednosne atribute i ukloniće dodatne vrednosti nadogradnje.</p>';
$string['auth_user_create'] = 'Omogućiti kreiranje korisnika';
$string['auth_user_creation'] = 'Novi (anonimni) korisnici mogu napraviti korisničke naloge na spoljašnjem izvoru za proveru identiteta i izvršiti potvrdu putem e-pošte. Ako omogućite ovu opciju, konfigurišite i specifične opcije modula koje služe za kreiranje korisnika.';
$string['auth_usernameexists'] = 'Odabrano korisničko ime već postoji. Molimo izaberite drugo korisničko ime.';
$string['auto_add_remote_users'] = 'Automatsko dodavanje udaljenih korisnika';
$string['changepassword'] = 'URL za promenu lozinke';
$string['changepasswordhelp'] = 'Ovde možete navesti lokaciju na kojoj vaši korisnici mogu obnoviti ili promeniti svoje korisničko ime/lozinku, u slučaju da su ih zaboravili.
Ova opcija se može ponuditi korisnicima u vidu dugmeta na stranici za pristup sistemu, kao i na njihovoj korisničkoj stranici. Ako ostavite prazno polje, dugme neće biti prikazano.';
$string['chooseauthmethod'] = 'Izaberite način provere identiteta';
$string['chooseauthmethod_help'] = 'Ovо podešavanje određuje način provere identiteta koji se koristi kada se korisnik prijavljuje na sistem. Treba da odaberete samo dodatke za proveru identitet koji su uključeni, u suprotnom korisnici neće više moći da se prijave. Da biste blokirali buduće prijave nekog korisnika, odaberite \'Nema prijave\'.';
$string['createpassword'] = 'Generiši lozinku i obavesti korisnika';
$string['createpasswordifneeded'] = 'Kreiranje lozinke ako je to potrebno';
$string['emailchangecancel'] = 'Poništi promenu elektronske adrese';
$string['emailchangepending'] = 'Promena na čekanju. Otvorite link koji Vam je poslata na {$a->preference_newemail}.';
$string['emailnowexists'] = 'Adresa e-pošte koju ste pokušali da dodelite Vašem profilu je već dodeljenlj drugom korisniku. Zato je Vaš zahtev za promenu elektornske adrese poništen, ali možete pokušati sa drugom adresom.';
$string['emailupdate'] = 'Ažuriranje elektronske adrese';
$string['emailupdatemessage'] = 'Dragi/a {$a->fullname},

Tražili ste promenu svoje e-adrese za Vaš korisnički nalog na {$a->site}. Molimo Vas da otvorite sledeći URL u svom Web čitaču kako biste potvrdili ovu promenu.

{$a->url}';
$string['emailupdatesuccess'] = 'E-adresa korisnika <em>{$a->fullname}</em> je uspešno promenjena u <em>{$a->email}</em>.';
$string['emailupdatetitle'] = 'Potvrda ažuriranja e-adrese na {$a->site}';
$string['enterthenumbersyouhear'] = 'Unesite broj koji čujete';
$string['enterthewordsabove'] = 'Unesite reč iznad';
$string['errormaxconsecutiveidentchars'] = 'Maksimalan broj istovetnih karaktera za redom koje mora sadržati lozinka je: {$a}';
$string['errorminpassworddigits'] = 'Minimalan broj cifara koji lozinka mora sadržati je: {$a}.';
$string['errorminpasswordlength'] = 'Minimalan broj karaktera koji lozinka mora sadržati je: {$a}.';
$string['errorminpasswordlower'] = 'Minimalan broj malih slova koji lozinka mora sadržati je: {$a}.';
$string['errorminpasswordnonalphanum'] = 'Minimalan broj karaktera koji nisu alfanumerički koji lozinka mora sadržati je: {$a}.';
$string['errorminpasswordupper'] = 'Minimalan broj velikih slova koji lozinka mora sadržati je: {$a}.';
$string['errorpasswordupdate'] = 'Greška u ažuriranju lozinke, lozinka nije promenjena.';
$string['event_user_loggedin'] = 'Korisnik se prijavio';
$string['eventuserloggedinas'] = 'Korisnik prijavljen kao drugi korisnik';
$string['forcechangepassword'] = 'Obavezna promena lozinke';
$string['forcechangepasswordfirst_help'] = 'Obavezna promena lozinke za sve korisnike pri njihovom prvom pristupu Moodle sistemu';
$string['forcechangepassword_help'] = 'Obavezna promena lozinke za sve korisnike pri njihovom sledećem pristupu Moodle sistemu';
$string['forgottenpassword'] = 'Ukoliko ovde unesete URL adresu, ona će biti korišćena za stranicu za obnavljanje zaboravljene lozinke, na ovom sajtu. Ovo je namenjeno sajtovima na kojima se lozinkama, u potpunosti, upravlja izvan Moodlea. Ostavite ovo polje prazno da biste koristili uobičajeni način za obnavljanje lozinke.';
$string['forgottenpasswordurl'] = 'URL adresa za obnavljanje zaboravljene lozinke';
$string['getanaudiocaptcha'] = 'Preuzmite zvučni CAPTCHA';
$string['getanimagecaptcha'] = 'Preuzmite CAPTCHA sliku';
$string['getanothercaptcha'] = 'Preuzmite drugi CAPTCHA';
$string['guestloginbutton'] = 'Dugme za prijavu gostiju';
$string['incorrectpleasetryagain'] = 'Neispravno. Molimo pokušajte ponovo';
$string['infilefield'] = 'Polje zahtevano u datoteci';
$string['informminpassworddigits'] = 'minimalan broj cifara: {$a}';
$string['informminpasswordlength'] = 'minimalan broj znakova: {$a}';
$string['informminpasswordlower'] = 'minimalan broj malih slova: {$a}';
$string['informminpasswordnonalphanum'] = 'minimalan broj nealfanumeričkih znakova: {$a}';
$string['informminpasswordupper'] = 'minimalan broj velikih slova: {$a}';
$string['informpasswordpolicy'] = 'Lozinka mora imati {$a}';
$string['instructions'] = 'Uputstva';
$string['internal'] = 'Interno';
$string['locked'] = 'Zaključano';
$string['md5'] = 'MD5 heš';
$string['nopasswordchange'] = 'Nije moguće promeniti lozinku';
$string['nopasswordchangeforced'] = 'Niste u mogućnosti da nastavite dalje bez promene korisničkog imena, međutim ne postoji raspoloživa stranica za promenu. Molimo kontaktirajte Moodle administratora.';
$string['noprofileedit'] = 'Nije moguće uređivati profil';
$string['ntlmsso_attempting'] = 'Pokušava se SSO (Single Sign On) preko NTLM...';
$string['ntlmsso_failed'] = 'Automatsko prijavljivanje nije uspelo, pokušajte sa običnom stranicom za prijavu...';
$string['ntlmsso_isdisabled'] = 'NTLM SSO (jedinstvena prijava) nije uključenа.';
$string['passwordhandling'] = 'Upravljenje poljem lozinke';
$string['plaintext'] = 'Običan tekst';
$string['pluginnotenabled'] = 'Dodatak za proveru identiteta \'{$a}\' nije osposobljen.';
$string['pluginnotinstalled'] = 'Dodatak za proveru identiteta \'{$a}\' nije instaliran.';
$string['potentialidps'] = 'Prijavite se koristeći svoj nalog na:';
$string['recaptcha'] = 'reCAPTCHA';
$string['recaptcha_help'] = 'CAPTCHA služi za sprečavanje zloupotrebu od strane automatizovanih programa. Samo unesite u okvir reči koje vidite, redom kojim su napisane i odvojite ih razmakom.

Ako niste sigurni koje su to reči, možete da zatražite novi CAPTCHA ili da poslušate zvučni CAPTCHA.';
$string['selfregistration'] = 'Samoregistracija';
$string['selfregistration_help'] = 'Ako je odabran dodatak za proveru identiteta, kao što je samostalna registracija pomoću e-pošte, onda će ovo omogućiti potencijalnim korisnicima da se sami registruju i kreiraju korisničke naloge. Ovo za posledicu ima mogućnost da spameri kreiraju korisničke naloge kako bi koristili forume, blog članke i slično za slanje neželjenih poruka. Kako biste izbegli ovaj rizik, samostalna registracija treba da bude onemogućena ili ograničena pomoću podešavanja <em>Dozvoljeni domeni e-pošte</em>.';
$string['sha1'] = 'SHA-1 heš';
$string['showguestlogin'] = 'Možete sakriti ili prikazati dugme za prijavu gostiju na prijavnoj stranici.';
$string['stdchangepassword'] = 'Koristi standardnu stranicu za promenu lozinke';
$string['stdchangepassword_expl'] = 'Ako spoljašnji sistem za proveru identiteta dozvoljava promenu lozinke iz Moodle sistema, uključite ga. Ovo podešavanje zaobilazi \'URL za promenu lozinke\'.';
$string['stdchangepassword_explldap'] = 'Napomena: Preporučuje se da koristite LDAP pre nego SSL šifrovanje tunela (ldaps://) ako je LDAP server udaljen.';
$string['suspended'] = 'Suspendovani nalog';
$string['suspended_help'] = 'Korisnici kojima je suspendovan nalog ne mogu da se prijave na sistem ili da koriste veb servise, niti im se šalju poruke sa sistema.';
$string['testsettings'] = 'Podešavanja testa';
$string['testsettingsheading'] = 'Podešavanja  testa za proveru  identiteta  - {$a}';
$string['unlocked'] = 'Otključano';
$string['unlockedifempty'] = 'Otključano ako je prazno';
$string['update_never'] = 'Nikad';
$string['update_oncreate'] = 'Pri kreiranju';
$string['update_onlogin'] = 'Pri svakom pristupu sistemu';
$string['update_onupdate'] = 'Pri ažuriranju';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() ne podržava izabrani tip korisnika: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_activate() ne podržava izabrani tip korisnika (...još)';
