angular.module('MonstaFTP').run(['$templateCache', function($templateCache) {$templateCache.put('application/frontend/templates/body-files.html','<div id="files" ng-controller="FileBrowserController as vm" ng-mousedown="vm.handleBodyClick($event)" oncontextmenu="return false">\r\n    <ng-include src="\'application/frontend/templates/body-order-by.html\'"></ng-include>\r\n    <div class="dropdown" ondragstart="return false;">\r\n        <button data-toggle="dropdown" style="display: none" id="extras-dropdown-button"></button>\r\n        <ul class="dropdown-menu" id="extras-dropdown">\r\n            <li ng-click="vm.initiateMakeItem(\'FILE\')" ng-show="vm.allowFileCreation &amp;&amp; !vm.contextMenuItemHidden(\'new-file\')">\r\n                <a href="#">\r\n                    <i class="fa fa-file-o fa-fw"></i> {{ \'NEW_FILE_DEFERRED_ACTION\'|translate }}\r\n                </a>\r\n            </li>\r\n            <li ng-click="vm.initiateMakeItem(\'FOLDER\')" ng-show="!vm.contextMenuItemHidden(\'new-folder\')">\r\n                <a href="#">\r\n                    <i class="fa fa-folder-o fa-fw"></i> {{ \'NEW_FOLDER_DEFERRED_ACTION\'|translate }}\r\n                </a>\r\n            </li>\r\n            <li role="separator" class="divider" ng-show="(!vm.contextMenuItemHidden(\'new-folder\') || (!vm.contextMenuItemHidden(\'new-file\') &amp;&amp; vm.allowFileCreation)) &amp;&amp; !vm.contextMenuItemHidden(\'paste\')"></li>\r\n            <li data-name="paste" ng-click="vm.performPaste()" ng-show="!vm.contextMenuItemHidden(\'paste\')">\r\n                <a href="#" ng-class="{inactive: !hasPasteSource}" >\r\n                    <i class="fa fa-clipboard fa-fw"></i> {{ \'PASTE_ACTION\'|translate }}\r\n                </a>\r\n            </li>\r\n        </ul>\r\n    </div>\r\n    <table>\r\n        <thead class="mobile-hide">\r\n            <tr>\r\n                <td class="spacer"></td>\r\n                <td class="icon" ng-hide="vm.browserColumnHidden(\'icon\')"></td>\r\n                <td class="file" ng-hide="vm.browserColumnHidden(\'name\')">\r\n                    <monsta-reorder vm="vm" sort-name="NAME" sort-identifier="name"></monsta-reorder>\r\n                </td>\r\n                <td class="spacer"></td>\r\n                <td class="size" ng-hide="vm.browserColumnHidden(\'size\')">\r\n                    <monsta-reorder vm="vm" sort-name="SIZE" sort-identifier="size"></monsta-reorder>\r\n                </td>\r\n                <td class="modified" ng-hide="vm.browserColumnHidden(\'modified\')">\r\n                    <monsta-reorder vm="vm" sort-name="CHANGED" sort-identifier="modified"></monsta-reorder>\r\n                </td>\r\n                <td class="spacer"></td>\r\n                <td class="permissions" ng-hide="vm.browserColumnHidden(\'permissions\')">\r\n                    {{ "PERMISSIONS"|translate }}\r\n                </td>\r\n                <td class="other" ng-hide="vm.browserColumnHidden(\'properties\')"></td>\r\n                <td class="spacer"></td>\r\n            </tr>\r\n        </thead>\r\n        <tbody>\r\n            <tr ng-if="vm.uiOperationFactory.currentDirectory != null && vm.uiOperationFactory.currentDirectory != \'\' && vm.uiOperationFactory.currentDirectory != \'/\'">\r\n                <td class="spacer"></td>\r\n                <td class="icon" ng-click="vm.navigateUpOneLevel()" ng-hide="vm.browserColumnHidden(\'icon\')">\r\n                    <i class="fa fa-level-up fa-fw"></i>\r\n                </td>\r\n                <td class="file" ng-hide="vm.browserColumnHidden(\'name\')">\r\n                    <span class="up" ng-click="vm.navigateUpOneLevel()">..</span>\r\n                </td>\r\n                <td class="spacer"></td>\r\n                <td class="size" ng-hide="vm.browserColumnHidden(\'size\')"></td>\r\n                <td class="modified mobile-hide" ng-hide="vm.browserColumnHidden(\'modified\')"></td>\r\n                <td class="spacer mobile-hide"></td>\r\n                <td class="permissions mobile-hide" ng-hide="vm.browserColumnHidden(\'permissions\')"></td>\r\n                <td class="other" ng-hide="vm.browserColumnHidden(\'properties\')"></td>\r\n                <td class="spacer mobile-hide"></td>\r\n            </tr>\r\n            <tr ng-repeat="item in directoryList" ng-class-odd="\'tr-odd\'" ng-class-even="\'tr-even\'"\r\n                ng-class="{\'ui-selected\': selectedItems.indexOf($index) != -1}"\r\n                class="context-catcher-tr"\r\n                ng-mousedown="vm.rowMouseDown($event)"\r\n                ng-mousemove="vm.rowMouseMove($event, $index)"\r\n                ng-mouseup="vm.rowMouseUp($index)"\r\n                ng-mouseleave="vm.rowMouseLeave($event)"\r\n                data-index="{{ $index }}">\r\n                <td class="spacer"></td>\r\n                <td class="icon" ng-hide="vm.browserColumnHidden(\'icon\')">\r\n                    <i class="fa {{ item|icon }} fa-fw"></i>\r\n                </td>\r\n                <td class="file" ng-hide="vm.browserColumnHidden(\'name\')">\r\n                    <div class="dropdown file-toolbar" ondragstart="return false;">\r\n                        <button data-toggle="dropdown" class="context-catcher-button">\r\n                            <i ng-if="!vm.shouldHideContextMenu()" class="fa fa-caret-down"></i>\r\n                        </button>\r\n                        <div class="file-wrapper">\r\n                            <span ng-click="handleClick($event, $index)">{{ item.name|spaces_to_nbsp }}</span>\r\n                        </div>\r\n                        <ul class="dropdown-menu" ng-if="!vm.shouldHideContextMenu()">\r\n                            <li ng-click="handleClick($event, $index)" ng-show="item.isDirectory &amp;&amp; selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'open\')">\r\n                                <a href="#">\r\n                                    <i class="fa fa-fw fa-folder-open-o"></i> {{"OPEN_ACTION"|translate}}\r\n                                </a>\r\n                            </li>\r\n                            <li ng-class="{disabled: !vm.isLicensed}" ng-if="vm.enableFileEdit" ng-click="editItem(item)" ng-show="vm.itemIsEditable(item.isDirectory, item.name) &amp;&amp; selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'edit\')">\r\n                                <a href="#">\r\n                                    <i class="fa fa-fw fa-pencil-square-o"></i> {{"EDIT_ACTION"|translate}}\r\n                                </a>\r\n                            </li>\r\n                            <li ng-if="vm.isArchiveFilename(item.name)" ng-click="vm.initiateArchiveExtract(item)" ng-show="vm.archiveUploadAllowed &amp;&amp; !vm.contextMenuItemHidden(\'extract\')">\r\n                                <a href="#">\r\n                                    <i class="fa fa-fw fa-expand"></i> {{"EXTRACT_ACTION"|translate}}\r\n                                </a>\r\n                            </li>\r\n                            <li ng-if="vm.enableFileView && !vm.enableFileEdit" ng-click="editItem(item)" ng-show="vm.itemIsEditable(item.isDirectory, item.name) &amp;&amp; selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'view\')">\r\n                                <a href="#">\r\n                                    <i class="fa fa-fw fa-eye"></i> {{"VIEW_ACTION"|translate}}\r\n                                </a>\r\n                            </li>\r\n                            <li ng-click="vm.downloadSelectedFiles()" ng-hide="vm.contextMenuItemHidden(\'download\')">\r\n                                <a href="#">\r\n                                    <i class="fa fa-fw fa-download"></i> {{"DOWNLOAD_ACTION"|translate}}\r\n                                </a>\r\n                            </li>\r\n                            <li ng-click="vm.copyItemName(item.name)" ng-show="selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'copy-name\')">\r\n                                <a href="#">\r\n                                    <i class="fa fa-fw fa-clipboard"></i> {{"COPY_NAME_ACTION"|translate}}\r\n                                </a>\r\n                            </li>\r\n                            <li ng-click="vm.createZip()" ng-hide="vm.contextMenuItemHidden(\'create-zip\')">\r\n                                <a href="#">\r\n                                    <i class="fa fa-fw fa-file-archive-o"></i> {{"CREATE_ZIP_ACTION"|translate}}\r\n                                </a>\r\n                            </li>\r\n\r\n                            <li role="separator" class="divider"\r\n                                ng-show="(!vm.contextMenuItemHidden(\'open\') || !vm.contextMenuItemHidden(\'edit\') || !vm.contextMenuItemHidden(\'view\') || !vm.contextMenuItemHidden(\'download\') || !vm.contextMenuItemHidden(\'copy-name\') || !vm.contextMenuItemHidden(\'create-zip\'))"></li>\r\n                            <li ng-click="vm.initiateCutOfSelectedPaths()" ng-hide="vm.contextMenuItemHidden(\'cut\')">\r\n                                <a href="#">\r\n                                    <i class="fa fa-fw fa-scissors"></i> {{"CUT_ACTION"|translate}}\r\n                                </a>\r\n                            </li>\r\n                            <li ng-click="vm.initiateCopyOfSelectedPaths()" ng-hide="vm.contextMenuItemHidden(\'cut\')">\r\n                                <a href="#">\r\n                                    <i class="fa fa-fw fa-clone"></i> {{"COPY_ACTION"|translate}}\r\n                                </a>\r\n                            </li>\r\n                            <li ng-click="initiateRenameOfItem(item)" ng-show="selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'rename\')">\r\n                                <a href="#">\r\n                                       <i class="fa fa-fw fa-i-cursor">_</i> {{"RENAME_DEFERRED_ACTION"|translate}}\r\n                                </a>\r\n                            </li>\r\n                            <li ng-click="vm.initiateDeleteOfSelectedPaths()" ng-hide="vm.contextMenuItemHidden(\'delete\')">\r\n                                <a href="#">\r\n                                    <i class="fa fa-fw fa-trash-o"></i> {{"DELETE_DEFERRED_ACTION"|translate}}\r\n                                </a>\r\n                            </li>\r\n                            <li ng-if="vm.enableChmod" ng-click="vm.initiateChmodOfSelectedItems()" ng-hide="vm.contextMenuItemHidden(\'chmod\')">\r\n                                <a href="#">\r\n                                    <i class="fa fa-fw fa-key"></i> {{"CHMOD_ACTION"|translate}}\r\n                                </a>\r\n                            </li>\r\n                            <li role="separator" class="divider" ng-show="selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'properties\')"></li>\r\n                            <li ng-click="vm.showProperties(item)" ng-show="selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'properties\')">\r\n                                <a href="#">\r\n                                    <i class="fa fa-info-circle fa-fw"></i> {{ \'PROPERTIES\'|translate }}\r\n                                </a>\r\n                            </li>\r\n                        </ul>\r\n                    </div>\r\n                </td>\r\n                <td class="spacer"></td>\r\n                <td class="size" ng-hide="vm.browserColumnHidden(\'size\')">\r\n                    <span ng-show="!item.isDirectory">{{ item.size|file_size }}</span>\r\n                </td>\r\n                <td class="modified mobile-hide" ng-hide="vm.browserColumnHidden(\'modified\')">\r\n                    {{ item.modificationDate|file_last_modified }}\r\n                </td>\r\n                <td class="spacer mobile-hide"></td>\r\n                <td class="permissions mobile-hide" ng-hide="vm.browserColumnHidden(\'permissions\')">\r\n                    <span ng-click="vm.initiateChmodOfItem(item)">{{ item|item_permission_description }}</span>\r\n                </td>\r\n                <td class="other" ng-click="vm.showProperties(item)" title="{{ \'PROPERTIES\'|translate }}" ng-hide="vm.browserColumnHidden(\'properties\')">\r\n                    <i class="fa fa-ellipsis-v"></i>\r\n                </td>\r\n                <td class="spacer mobile-hide"></td>\r\n            </tr>\r\n        </tbody>\r\n    </table>\r\n</div>');
$templateCache.put('application/frontend/templates/body-footer.html','<div id="footer" class="toolbar" ng-controller="FooterController as vm">\r\n    <div class="float-left">\r\n        <input type="file" id="upload-placeholder" style="display: none" multiple>\r\n        <input type="file" id="upload-folder-placeholder" style="display: none" directory mozdirectory webkitdirectory odirectory msdirectory>\r\n        <div class="dropup mobile-show float-left">\r\n            <button class="fa fa-bars fa-fw active" data-toggle="dropdown" aria-haspopup="true"\r\n                    aria-expanded="false"></button>\r\n            <ul class="dropdown-menu">\r\n                <monsta-footer-menu-item\r\n                        ng-if="vm.enableChmod"\r\n                        vm="vm" active-condition="selectedItemsCount > 0"\r\n                        item-title="CHMOD_ACTION" identifier="chmod" icon-class="fa-key"></monsta-footer-menu-item>\r\n                <monsta-footer-menu-item\r\n                        vm="vm" active-condition="selectedItemsCount > 0"\r\n                        item-title="CUT_ACTION" identifier="cut" icon-class="fa-cut">\r\n                </monsta-footer-menu-item>\r\n                <monsta-footer-menu-item\r\n                        vm="vm" active-condition="selectedItemsCount > 0"\r\n                        item-title="COPY_ACTION" identifier="copy" icon-class="fa-copy">\r\n                </monsta-footer-menu-item>\r\n\r\n                <monsta-footer-menu-item\r\n                        vm="vm" active-condition="hasPasteSource == true"\r\n                        item-title="PASTE_ACTION" identifier="paste" icon-class="fa-clipboard">\r\n                </monsta-footer-menu-item>\r\n\r\n                <monsta-footer-menu-item\r\n                        vm="vm" active-condition="selectedItemsCount > 0"\r\n                        item-title="DELETE_DEFERRED_ACTION" identifier="delete" icon-class="fa-trash">\r\n                </monsta-footer-menu-item>\r\n\r\n                <li role="separator" class="divider" ng-hide="vm.itemHidden(\'fetch-file\')"></li>\r\n\r\n                <monsta-footer-menu-item\r\n                        vm="vm" item-title="FETCH_FILE_DEFERRED_ACTION" identifier="fetch-file"\r\n                        icon-class="fa-cloud-download" active-condition="vm.isLicensed"\r\n                        disabled-condition="!vm.isLicensed">\r\n                </monsta-footer-menu-item>\r\n            </ul>\r\n        </div>\r\n        <div class="dropup float-left">\r\n            <button class="fa fa-upload fa-fw active" title="{{ \'UPLOAD_DEFERRED_ACTION\'|translate }}" data-toggle="dropdown" aria-haspopup="true"\r\n                    aria-expanded="false" ng-hide="vm.itemHidden(\'upload\')"></button>\r\n            <ul class="dropdown-menu">\r\n                <monsta-footer-menu-item\r\n                        vm="vm" item-title="UPLOAD_FILE_DEFERRED_ACTION" identifier="upload-file"\r\n                        icon-class="fa-file-text-o">\r\n                </monsta-footer-menu-item>\r\n\r\n                <monsta-footer-menu-item\r\n                        vm="vm" item-title="UPLOAD_FOLDER_DEFERRED_ACTION" identifier="upload-folder"\r\n                        icon-class="fa-folder-o">\r\n                </monsta-footer-menu-item>\r\n\r\n                <monsta-footer-menu-item\r\n                        active-condition="vm.isLicensed"\r\n                        vm="vm" item-title="UPLOAD_ARCHIVE_DEFERRED_ACTION" identifier="upload-archive"\r\n                        disabled-condition="!vm.isLicensed"\r\n                        icon-class="fa-file-archive-o">\r\n                </monsta-footer-menu-item>\r\n            </ul>\r\n        </div>\r\n        <div class="float-left">\r\n            <monsta-footer-button\r\n                    vm="vm" active-condition="selectedItemsCount > 0" item-title="DOWNLOAD_ACTION" identifier="download"\r\n                    icon-class="fa-download">\r\n            </monsta-footer-button>\r\n        </div>\r\n        <div class="mobile-hide float-left">\r\n            <monsta-footer-button\r\n                    vm="vm" active-condition="vm.isLicensed" item-title="FETCH_FILE_DEFERRED_ACTION" identifier="fetch-file"\r\n                    disabled-condition="!vm.isLicensed" icon-class="fa-cloud-download">\r\n            </monsta-footer-button>\r\n        </div>\r\n        <div class="dropup float-left">\r\n            <button class="fa fa-plus-square-o fa-fw active" title="{{ \'NEW_FILE_FOLDER_DEFERRED_ACTION\'|translate }}" data-toggle="dropdown" aria-haspopup="true"\r\n                    aria-expanded="false" ng-hide="vm.itemHidden(\'new-item\')"></button>\r\n            <ul class="dropdown-menu">\r\n                <monsta-footer-menu-item\r\n                        ng-if="vm.enableFileEdit"\r\n                        active-condition="vm.isLicensed"\r\n                        disabled-condition="!vm.isLicensed"\r\n                        vm="vm" item-title="NEW_FILE_DEFERRED_ACTION" identifier="new-file"\r\n                        icon-class="fa-file-o">\r\n                </monsta-footer-menu-item>\r\n\r\n                <monsta-footer-menu-item\r\n                        vm="vm" item-title="NEW_FOLDER_DEFERRED_ACTION" identifier="new-folder"\r\n                        icon-class="fa-folder-o">\r\n                </monsta-footer-menu-item>\r\n            </ul>\r\n        </div>\r\n\r\n        <div class="float-left">\r\n            <monsta-footer-button\r\n                    ng-if="vm.enableFileEdit"\r\n                    vm="vm" active-condition="editorActive == true" item-title="SHOW_EDITOR_ACTION" identifier="show-editor"\r\n                    disabled-condition="!vm.isLicensed"\r\n                    icon-class="fa-pencil-square-o">\r\n            </monsta-footer-button>\r\n            <monsta-footer-button\r\n                    ng-if="!vm.enableFileEdit &amp;&amp; vm.enableFileView"\r\n                    vm="vm" active-condition="editorActive == true" item-title="SHOW_EDITOR_ACTION" identifier="show-editor"\r\n                    icon-class="fa-eye">\r\n            </monsta-footer-button>\r\n        </div>\r\n\r\n        <div class="mobile-hide float-left">\r\n            <monsta-footer-button\r\n                    vm="vm" active-condition="selectedItemsCount > 0" item-title="CUT_ACTION" identifier="cut"\r\n                    icon-class="fa-cut">\r\n            </monsta-footer-button>\r\n\r\n            <monsta-footer-button\r\n                    vm="vm" active-condition="selectedItemsCount > 0" item-title="COPY_ACTION" identifier="copy"\r\n                    icon-class="fa-copy">\r\n            </monsta-footer-button>\r\n\r\n            <monsta-footer-button\r\n                    vm="vm" active-condition="hasPasteSource == true" item-title="PASTE_ACTION" identifier="paste"\r\n                    icon-class="fa-clipboard">\r\n            </monsta-footer-button>\r\n\r\n            <monsta-footer-button\r\n                    vm="vm" active-condition="selectedItemsCount > 0" item-title="DELETE_DEFERRED_ACTION" identifier="delete"\r\n                    icon-class="fa-trash">\r\n            </monsta-footer-button>\r\n            \r\n            <monsta-footer-button\r\n                    ng-if="vm.enableChmod"\r\n                    vm="vm" active-condition="selectedItemsCount > 0" item-title="CHMOD_ACTION" identifier="chmod"\r\n                    icon-class="fa-key">\r\n            </monsta-footer-button>\r\n        </div>\r\n    </div>\r\n    <div class="float-right">\r\n        <div id="session" class="dropup" ng-class="{\'open\': vm.sessionDisplayForce}">\r\n            <button class="fa fa-info-circle fa-fw" title="{{ \'SESSION_INFORMATION\'|translate }}" data-toggle="dropdown"\r\n                    aria-haspopup="true" aria-expanded="false" ng-class="{active: vm.isLoggedIn, inactive: !vm.isLoggedIn}"\r\n                    ng-hide="vm.itemHidden(\'session-information\')"></button>\r\n            <ul class="dropdown-menu dropdown-menu-right">\r\n                <li title="{{ \'CURRENT_HOST\'|translate }}" ng-if="vm.showRemoteServerAddress"\r\n                    ng-hide="currentHost == null || vm.itemHidden(\'remote-server\')">\r\n                    <i class="fa fa-server fa-fw"></i> {{ currentHost }}\r\n                </li>\r\n                <li title="{{ \'CURRENT_USER\'|translate }}" ng-hide="currentUsername == null || vm.itemHidden(\'username\')">\r\n                    <i class="fa fa-user fa-fw"></i> {{ currentUsername }}\r\n                </li>\r\n                <li title="{{ \'FILE_UPLOAD_LIMIT\'|translate }}" ng-hide="maxUploadBytes == -1 || vm.itemHidden(\'upload-limit\')">\r\n                    <i class="fa fa-upload fa-fw"></i> {{ maxUploadBytes|file_size }}\r\n                </li>\r\n                <li title="{{ \'CURRENT_VERSION\'|translate }}" ng-hide="vm.itemHidden(\'version\')">\r\n                    <i class="fa fa-info-circle fa-fw"></i> {{ "VERSION"|translate }} {{ currentVersion }}\r\n                </li>\r\n            </ul>\r\n        </div>\r\n    </div>\r\n    <div class="version-alerter float-right" ng-show="newVersionAvailable && !vm.itemHidden(\'new-version-alert\')">\r\n    \t<a href="#" ng-click="vm.showUpdateModal()"><i class="fa fa-exclamation-triangle fa-fw fa-2x active version-alert" title="{{ NEW_VERSION_AVAILABLE|translate }}"></i></a>\r\n    </div>\r\n</div>');
$templateCache.put('application/frontend/templates/body-header.html','<div id="header" class="toolbar" ng-controller="HeaderController as vm">\r\n    <div class="float-left">\r\n        <button class="fa fa-chevron-left fa-fw" ng-class="{active: vm.canGoBack, inactive: !vm.canGoBack}"\r\n                ng-click="vm.navigateBack()" title="{{ \'BACK_ACTION\'|translate }}"\r\n                ng-hide="vm.itemHidden(\'back\')"></button>\r\n        <button class="fa fa-chevron-right fa-fw" ng-class="{active: vm.canGoForward, inactive: !vm.canGoForward}"\r\n                ng-click="vm.navigateForward()" title="{{ \'FORWARD_ACTION\'|translate }}"\r\n                ng-hide="vm.itemHidden(\'forward\')"></button>\r\n        <button ng-click="vm.refresh()" class="fa fa-refresh fa-fw active" title="{{ \'REFRESH_ACTION\'|translate }}"\r\n            ng-hide="vm.itemHidden(\'refresh\')"></button>\r\n        <!--button class="fa fa-search fa-fw active" title="{{ \'SEARCH_DEFERRED_ACTION\'|translate }}"></button-->\r\n    </div>\r\n    <div class="float-right">\r\n        <span class="spacer"></span>\r\n        <span class="logo"></span>\r\n        <span class="spacer"></span>\r\n        <button class="fa fa-bars fa-fw active" id="slidebar-toggle" title="{{ \'MENU_ACTION\'|translate }}"></button>\r\n    </div>\r\n</div>');
$templateCache.put('application/frontend/templates/body-history.html','<div id="history" class="dropdown" ng-controller="HistoryController as vm">\r\n    <button class="fa fa-history fa-fw" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true" title="{{ \'HISTORY\'|translate }}">\r\n        <span class="caret"></span>\r\n    </button>\r\n    <ul id="history-ul" class="dropdown-menu .pull-down" aria-labelledby="history-toggle" >\r\n        <li title="{{ path }}" ng-repeat="path in vm.sortedHistory" ng-click="historyClick(path)">\r\n            <span>{{ path }}</span>\r\n        </li>\r\n\r\n    \t<li class="title" ng-show="vm.recentHistory.length == 0 &amp;&amp; vm.sortedHistory.length == 0" translate>\r\n            HISTORY_EMPTY_MESSAGE\r\n        </li>\r\n    </ul>\r\n    <div id="breadcrumb" ng-controller="BreadcrumbController as bc" ondragstart="return false;">\r\n        <ol id="breadcrumb-ol" class="breadcrumb">\r\n            <li ng-click="bc.changeDirectoryToItem(0)" id="breadcrumb__home_link">\r\n                <a href="#">\r\n                    <i class="fa fa-home fa-fw"></i>\r\n    \t\t\t</a>\r\n            </li>\r\n        </ol>\r\n    </div>\r\n</div>');
$templateCache.put('application/frontend/templates/body-order-by.html','<div id="order-by" class="mobile-show">\r\n    <div class="dropdown">\r\n        <button data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\r\n            {{ vm.sortName|sort_description|translate }}\r\n            <i class="fa" ng-class="{\'fa-caret-up\': !vm.sortReversed, \'fa-caret-down\': vm.sortReversed}" aria-hidden="true"></i>\r\n        </button>\r\n        <ul class="dropdown-menu">\r\n            <monsta-reorder-mobile vm="vm" sort-name="NAME" sort-identifier="name"></monsta-reorder-mobile>\r\n            <monsta-reorder-mobile vm="vm" sort-name="SIZE" sort-identifier="size"></monsta-reorder-mobile>\r\n            <monsta-reorder-mobile vm="vm" sort-name="CHANGED" sort-identifier="modified"></monsta-reorder-mobile>\r\n            <monsta-reorder-mobile vm="vm" sort-name="TYPE" sort-identifier="type"></monsta-reorder-mobile>\r\n        </ul>\r\n    </div>    \r\n</div>    ');
$templateCache.put('application/frontend/templates/body-slidebar.html','<div id="slidebar" off-canvas="slidebar right overlay" ng-controller="SlidebarController as vm">\r\n    <i class="fa fa-sign-in fa-fw" title="{{ \'LOG_OUT_DEFERRED_ACTION\'|translate }}" ng-click="vm.initiateLogout()" ng-hide="vm.itemHidden(\'logout\')"></i>\r\n    <i ng-if="vm.showChangeServerButton" ng-hide="vm.itemHidden(\'change-server\')" class="fa fa-server fa-fw" title="{{ \'CHANGE_SERVER_ACTION\'|translate }}" ng-click="vm.showLoginPanel()"></i>\r\n    <i class="fa fa-cog fa-fw" title="{{ \'SETTINGS\'|translate }}" ng-click="vm.showSettingsModal()" ng-hide="vm.itemHidden(\'settings\')"></i>\r\n    <i ng-if="vm.showAddOnsButton" class="fa fa-puzzle-piece fa-fw" title="{{ \'ADD_ONS\'|translate }}" ng-click="vm.showAddonsModal()" ng-hide="vm.itemHidden(\'addons\')"></i>\r\n    <a ng-if="vm.showHelpButton" href="{{ vm.customHelpUrl == null ? \'http://redirect.monstaftp.com/support\' : vm.customHelpUrl }}" ng-hide="vm.itemHidden(\'help\')"\r\n       target="mftp-new" rel="noopener noreferrer">\r\n        <i class="fa fa-life-ring fa-fw" title="{{ \'HELP_ACTION\'|translate }}"></i>\r\n    </a>\r\n</div>');
$templateCache.put('application/frontend/templates/modal-addons.html','<div class="modal fade" id="modal-addons" tabindex="-1" role="dialog" aria-labelledby="modal-addons-label"\r\n     ng-controller="ModalAddonsController as vm">\r\n    <div class="modal-dialog" role="document">\r\n        <div class="modal-content">\r\n            <div class="modal-header label-warning">\r\n                <button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}"><span\r\n                        aria-hidden="true">&times;</span></button>\r\n                <h4 class="modal-title" id="modal-addons-label">{{\'ADD_ONS\'|translate}}</h4>\r\n            </div>\r\n            <div class="modal-body">\r\n                <div class="alert alert-danger" role="alert" ng-if="!vm.openSslAvailable">\r\n                    <p>Your PHP install does not have the OpenSSL library enabled, without it your license key can not be read.\r\n                        Please see the\r\n                        <a href="http://php.net/manual/en/book.openssl.php" target="mftp-new" rel="nofollow noreferrer">PHP OpenSSL Documentation</a>\r\n                        for installation instructions and more information.\r\n                    </p>\r\n                </div>\r\n\r\n                <div class="license-type">{{ vm.productEditionShortName|translate }}</div>\r\n                <span ng-show="vm.isLicensed">\r\n                    {{ \'LICENSE_VALID_UNTIL_MESSAGE\'|translate:{ expiry_date:vm.formattedExpiryDate } }}\r\n                </span>\r\n                <div>\r\n                    <p class="alert alert-danger" ng-show="vm.licenseExpired">\r\n                    {{ \'LICENSE_EXPIRED_ON_MESSAGE\'|translate:{ expiry_date:vm.formattedExpiryDate } }}\r\n                    <br/>\r\n                    <a href="http://redirect.monstaftp.com/renew" target="mftp-new" rel="noopener noreferrer" translate>RENEW_NOW_MESSAGE</a>\r\n                    </p>\r\n                </div>\r\n                <span ng-show="!vm.isLicensed && !vm.licenseExpired">\r\n                    <a href="http://redirect.monstaftp.com/upgrade" target="mftp-new" rel="noopener noreferrer" translate>UPGRADE_MESSAGE_GENERAL</a>\r\n                </span>\r\n                <textarea ng-model="vm.models.license" placeholder="{{ (vm.isLicensed ? \'LICENSE_UPDATE_PLACEHOLDER\' : \'LICENSE_NEW_PLACEHOLDER\')|translate }}"> </textarea>\r\n                <div class="alert alert-danger" role="alert"\r\n                     ng-hide="vm.licenseUpdateError == null || vm.licenseUpdateError == \'\'">\r\n                    <strong class="error--attention" translate>ERROR_ATTENTION</strong> {{ vm.licenseUpdateError }}\r\n                </div>\r\n                <button class="btn btn-primary" ng-click="vm.updateLicense()" translate>SAVE_LICENSE_ACTION</button>\r\n            </div>\r\n            <div class="modal-footer">\r\n                <button type="button" class="btn btn-default" data-dismiss="modal">{{ \'DISMISS_OK_ACTION\'|translate }}</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>');
$templateCache.put('application/frontend/templates/modal-chmod.html','<div class="modal fade" id="modal-chmod" tabindex="-1" role="dialog" aria-labelledby="modal-chmod-label" ng-controller="ModalPermissionsController">\r\n\t<div class="modal-dialog" role="document">\r\n\t\t<div class="modal-content">\r\n\t\t\t<div class="modal-header label-warning">\r\n\t\t\t\t<button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}"><span aria-hidden="true">&times;</span></button>\r\n\t\t\t\t<h4 class="modal-title" id="modal-chmod-label">{{ \'CHANGE_FILE_PERMISSIONS\'|translate }}</h4>\r\n\t\t\t</div>\r\n\t\t\t<div class="modal-body">\r\n        \t\t<fieldset>\r\n                    <legend translate>PERMISSIONS_OWNER</legend>\r\n                    <div>\r\n                        <input type="checkbox" ng-model="permissions.ownerRead" id="modal-permissions-owner-read"> \r\n                        \t<label for="modal-permissions-owner-read" translate>PERMISSIONS_READ</label>\r\n                    </div>\r\n                    <div>\r\n                        <input type="checkbox" ng-model="permissions.ownerWrite" id="modal-permissions-owner-write"> \r\n                        \t<label for="modal-permissions-owner-write" translate>PERMISSIONS_WRITE</label>\r\n                    </div>\r\n                    <div>\r\n                        <input type="checkbox" ng-model="permissions.ownerExecute" id="modal-permissions-owner-execute"> \r\n                        \t<label for="modal-permissions-owner-execute" translate>PERMISSIONS_EXECUTE</label>\r\n                    </div>\r\n                </fieldset>\r\n                <fieldset>\r\n                    <legend translate>PERMISSIONS_GROUP</legend>\r\n                    <div>\r\n                        <input type="checkbox" ng-model="permissions.groupRead" id="modal-permissions-group-read"> \r\n                        \t<label for="modal-permissions-group-read" translate>PERMISSIONS_READ</label>\r\n                    </div>\r\n                    <div>\r\n                        <input type="checkbox" ng-model="permissions.groupWrite" id="modal-permissions-group-write"> \r\n                        \t<label for="modal-permissions-group-write" translate>PERMISSIONS_WRITE</label>\r\n                    </div>\r\n                    <div>\r\n                        <input type="checkbox" ng-model="permissions.groupExecute" id="modal-permissions-group-execute"> \r\n                        \t<label for="modal-permissions-group-execute" translate>PERMISSIONS_EXECUTE</label>\r\n                    </div>\r\n                </fieldset>\r\n                <fieldset>\r\n                    <legend translate>PERMISSIONS_OTHER</legend>\r\n                    <div>\r\n                        <input type="checkbox" ng-model="permissions.otherRead" id="modal-permissions-other-read"> \r\n                        \t<label for="modal-permissions-other-read" translate>PERMISSIONS_READ</label>\r\n                    </div>\r\n                    <div>\r\n                        <input type="checkbox" ng-model="permissions.otherWrite" id="modal-permissions-other-write"> \r\n                        \t<label for="modal-permissions-other-write" translate>PERMISSIONS_WRITE</label>\r\n                    </div>\r\n                    <div>\r\n                        <input type="checkbox" ng-model="permissions.otherExecute" id="modal-permissions-other-execute"> \r\n                        \t<label for="modal-permissions-other-execute" translate>PERMISSIONS_EXECUTE</label>\r\n                    </div>\r\n                </fieldset>\r\n                <fieldset>\r\n                    <legend translate>PERMISSIONS_MANUAL</legend>\r\n                     <input type="text" ng-model="formattedPermissions" ng-model-options="{ updateOn: \'blur\' }" \r\n                     \tng-focus="manualFocus()" ng-keyup="keyUp($event)" maxlength="3">\r\n                     <span class="alert alert-danger" role="alert" ng-show="invalidRange" translate>PERMISSIONS_INVALID_NUMBER_MESSAGE</span>\r\n                </fieldset>\r\n\t\t\t</div>\r\n            <div class="modal-footer">\r\n                <button type="button" class="btn btn-default" ng-click="cancelClick()" ng-disabled="saving">{{ \'DISMISS_CANCEL_ACTION\'|translate }}</button>\r\n                <button type="button" class="btn btn-default" ng-click="okClick()" ng-disabled="saving">{{ (saving ? "SAVING_ACTIVITY_STATUS" : \'DISMISS_OK_ACTION\')|translate }}</button>\r\n            </div>\r\n\t\t</div>\r\n\t</div>\r\n</div>');
$templateCache.put('application/frontend/templates/modal-choice.html','<div class="modal fade" id="modal-choice" tabindex="-1" role="dialog" aria-labelledby="modal-choice-label"\r\n     ng-controller="ModalChoiceController as vm" data-backdrop="static" data-keyboard="false">\r\n    <div class="modal-dialog" role="document">\r\n        <div class="modal-content">\r\n            <div class="modal-header label-warning">\r\n                <button type="button" class="close" ng-click="vm.handleCancel()"\r\n                        aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}">\r\n                    <span aria-hidden="true">&times;</span>\r\n                </button>\r\n                <h4 class="modal-title" id="modal-confirm-label" translate>{{ vm.title }}</h4>\r\n            </div>\r\n            <div class="modal-body">\r\n                <div translate>{{ vm.message }}</div>\r\n                <div ng-if="vm.checkboxText !== null" class="checkbox">\r\n                    <label for="id_choice_checkbox">\r\n                        <input type="checkbox" ng-model="vm.checkboxChecked" id="id_choice_checkbox">\r\n                        {{ vm.checkboxText|translate }}\r\n                    </label>\r\n                </div>\r\n            </div>\r\n            <div class="modal-footer">\r\n                <button class="btn btn-default pull-left" ng-click="vm.handleCancel()" translate>DISMISS_CANCEL_ACTION</button>\r\n                <button ng-repeat="callback in vm.callbacks track by $index" type="button" class="btn btn-default"\r\n                        ng-click="vm.handleCallback($index)" translate>{{ callback[0] }}</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>');
$templateCache.put('application/frontend/templates/modal-confirm.html','<div class="modal fade" id="modal-confirm" tabindex="-1" role="dialog" aria-labelledby="modal-confirm-label"\r\n     ng-controller="ModalConfirmController as modalConfirmController">\r\n    <div class="modal-dialog" role="document">\r\n        <div class="modal-content">\r\n            <div class="modal-header label-warning">\r\n                <button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}">\r\n                    <span aria-hidden="true">&times;</span>\r\n                </button>\r\n                <h4 class="modal-title" id="modal-confirm-label" translate>WARNING_ATTENTION</h4>\r\n            </div>\r\n            <div class="modal-body">\r\n                {{ modalConfirmController.message }}\r\n            </div>\r\n            <div class="modal-footer">\r\n                <button type="button" class="btn btn-default" ng-click="modalConfirmController.cancel()" translate>DISMISS_CANCEL_ACTION</button>\r\n                <button type="button" class="btn btn-danger" ng-click="modalConfirmController.ok()" translate>DISMISS_CONFIRM_ACTION</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>');
$templateCache.put('application/frontend/templates/modal-editor.html','<div class="modal fade" id="modal-editor" tabindex="-1" role="dialog" aria-labelledby="modal-file-editor-label"\r\n     ng-controller="FileEditorController as fileEditorController">\r\n    <div class="modal-dialog" role="document">\r\n        <div class="modal-content">\r\n            <div class="modal-body">\r\n                <div class="tab-content">\r\n                    <div ng-repeat="editorFile in editorFiles track by editorFile.path" role="tabpanel" class="tab-pane"\r\n                         ng-class="{active: editorFile.path == activeFile.path, in: editorFile.path == activeFile.path}">\r\n                        <div class="file-editor-display" id="editor_display_{{ editorFile.path }}" ng-show="licenseFactory.isLicensed()"></div>\r\n                        <textarea id="editor_ta_{{ editorFile.path }}" class="file-editor-textarea"\r\n                                  ng-hide="licenseFactory.isLicensed()"\r\n                                  ng-model="editorFile.contents" ng-change="textChange(editorFile.path)"\r\n                                  ng-readonly="!fileEditorController.allowEdit"></textarea>\r\n                    </div>\r\n                </div>\r\n                <div class="dropup">\r\n                    <div class="file-path" aria-haspopup="true" aria-expanded="false" ng-class="{ \'cursor-pointer\': licenseFactory.isLicensed() }"\r\n                         ng-click="fileEditorController.fileListClick($event)">\r\n                        <i class="fa fa-caret-up" ng-show="licenseFactory.isLicensed()"></i>\r\n                        <span ng-class="{\'unsaved-file\': activeFile.dirty }"></span>{{ activeFile.path }}\r\n                    </div>\r\n                    <ul class="dropdown-menu" role="tablist" ng-show="licenseFactory.isLicensed()">\r\n                        <li ng-repeat="editorFile in editorFiles track by $index" role="presentation"\r\n                            ng-class="{active: editorFile.path == activeFile.path, in: editorFile.path == activeFile.path}"\r\n                            ng-click="activateTab(editorFile.path, $event)"\r\n                            ondragstart="return false;">\r\n                            <div>\r\n                                <a href="#" aria-controls="fel" role="tab">\r\n                                    <button class="close" type="button"\r\n                                            ng-click="closeTabForFile(editorFile.name, editorFile.path)">&times;\r\n                                    </button>\r\n                                    <span data-placement="top" title="{{ editorFile.path }}"\r\n                                          ng-class="{\'unsaved-file\': editorFile.dirty }">\r\n                                        {{ editorFile.path }}\r\n                                    </span>\r\n                                </a>\r\n                            </div>\r\n                        </li>\r\n                    </ul>\r\n                </div>\r\n            </div>\r\n            <div class="modal-footer">\r\n                <div class="logo"></div>\r\n                <span class="autosave" ng-show="licenseFactory.isLicensed() && fileEditorController.allowEdit">\r\n\t\t\t\t\t<input type="checkbox" ng-model="settings.autoSave" id="id_auto_save">\r\n                    <label for="id_auto_save" translate>AUTO_SAVE_ACTION</label>\r\n\t\t\t\t</span>\r\n                <button type="button" class="btn btn-default" ng-if="fileEditorController.allowEdit"\r\n                        ng-click="saveActiveFile(false, false)"\r\n                        ng-disabled="activeFile.saving">\r\n                    <span ng-show="!activeFile.saving" translate>SAVE_ACTION</span>\r\n                    <i ng-show="activeFile.saving" class="fa fa-spinner fa-spin fa-fw"></i>\r\n                </button>\r\n                <button type="button" class="btn btn-default" ng-click="fileEditorController.hide()" translate>DISMISS_CLOSE_ACTION</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>');
$templateCache.put('application/frontend/templates/modal-error.html','<div class="modal fade" id="modal-error" tabindex="-1" role="dialog" aria-labelledby="modal-error-label"\r\n     ng-controller="ModalErrorController as vm">\r\n    <div class="modal-dialog" role="document">\r\n        <div class="modal-content">\r\n            <div class="modal-header label-danger">\r\n                <button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}">\r\n                    <span aria-hidden="true">&times;</span>\r\n                </button>\r\n                <h4 class="modal-title" id="modal-error-label" translate>ERROR_ATTENTION</h4>\r\n            </div>\r\n            <div class="modal-body" ng-bind-html="vm.message|html_safe"></div>\r\n            <div class="modal-footer">\r\n                <button type="button" class="btn btn-default" ng-click="vm.hide()" translate>DISMISS_OK_ACTION</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>');
$templateCache.put('application/frontend/templates/modal-login-ftp.html','<form>\r\n    <div class="alert alert-danger" role="alert" ng-if="!vm.ftpConnectionAvailable">\r\n        <p>Your PHP install does not have the Sockets or FTP PHP libraries enabled, and will not be able to connect to\r\n            FTP servers. For information on how to activate them please see\r\n            <a href="http://redirect.monstaftp.com/enable-ftp-php" target="mftp-new" rel="noopener noreferrer">this article</a>.\r\n        </p>\r\n    </div>\r\n\r\n    <div class="input-wrapper float-fix" ng-if="vm.configurationSettable(\'ftp\', \'host\')">\r\n        <div class="float-left width-host">\r\n            {{ \'HOST\'|translate }}:\r\n            <br>\r\n            <input type="text" ng-model="configuration.ftp.host" required ng-keypress="handleLoginKeyPress($event)" ng-if="vm.hostEntryIsText(\'ftp\')">\r\n            <select ng-if="!vm.hostEntryIsText(\'ftp\')" ng-model="configuration.ftp.host" class="form-control">\r\n                <option ng-repeat="host in vm.getHostOptions(\'ftp\')" ng-value="host">{{ host }}</option>\r\n            </select>\r\n        </div>\r\n        <div class="spacer"></div>\r\n        <div class="float-right width-port" ng-if="vm.configurationSettable(\'ftp\', \'port\')">\r\n            {{ \'PORT\'|translate }}:\r\n            <br><input type="text" ng-model="configuration.ftp.port" placeholder="{{ defaults.ftp.port }}" required ng-keypress="handleLoginKeyPress($event)">\r\n        </div>\r\n    </div>\r\n              \r\n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'ftp\', \'username\')">\r\n        {{ \'USERNAME\'|translate }}:\r\n        <br><input type="text" ng-model="configuration.ftp.username" required ng-keypress="handleLoginKeyPress($event)">\r\n    </div>\r\n          \r\n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'ftp\', \'password\')">\r\n        {{ \'PASSWORD\'|translate }}:\r\n        <br><input type="password" ng-model="configuration.ftp.password" required ng-keypress="handleLoginKeyPress($event)">\r\n    </div>\r\n\r\n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'ftp\', \'initialDirectory\')">\r\n        {{ \'INITIAL_DIRECTORY\'|translate }}:\r\n        <br><input type="text" ng-model="configuration.ftp.initialDirectory" required ng-keypress="handleLoginKeyPress($event)">\r\n    </div>\r\n\r\n    <div class="input-wrapper">\r\n        <span ng-if="vm.configurationSettable(\'ftp\', \'passive\')">\r\n            <input type="checkbox" ng-model="configuration.ftp.passive" value="1" checked tabindex="-1" id="id_configuration.ftp.passive">\r\n            <label class="login-cb-label" for="id_configuration.ftp.passive">{{ \'PASSIVE_MODE\'|translate }}</label>\r\n            <br>\r\n        </span>\r\n        <span ng-if="vm.configurationSettable(\'ftp\', \'ssl\')">\r\n            <input type="checkbox" ng-model="configuration.ftp.ssl" value="1" checked tabindex="-1" id="id_configuration.ftp.ssl">\r\n            <label class="login-cb-label" for="id_configuration.ftp.ssl">{{ \'USE_SSL\'|translate }}</label>\r\n            <br>\r\n        </span>\r\n        <span ng-hide="vm.loginItemHidden(\'remember-login\')">\r\n        <input type="checkbox" ng-model="metaConfiguration.rememberLogin" name="login_save" value="1" tabindex="-1" id="id_ftp_login_save" ng-click="vm.rememberLoginToggle()">\r\n            <label class="login-cb-label" for="id_ftp_login_save">{{ \'KEEP_ME_LOGGED_IN\'|translate }}</label>\r\n        </span>\r\n    </div>\r\n</form>');
$templateCache.put('application/frontend/templates/modal-login-link.html','<div class="modal fade" id="modal-login-link" tabindex="-1" role="dialog" aria-labelledby="modal-login-link-label"\r\n     ng-controller="ModalLoginLinkController as vm" data-backdrop="static" data-keyboard="false">\r\n    <div class="modal-dialog" role="document">\r\n        <div class="modal-content">\r\n            <div class="modal-header label-warning">\r\n                <h4 class="modal-title" id="modal-login-link-label" translate>GENERATE_LOGIN_LINK_TITLE</h4>\r\n            </div>\r\n            <div class="modal-body text-center">\r\n                <div class="alert alert-danger" role="alert" ng-show="vm.configURL == null" translate>LOGIN_LINK_BAD_CONFIGURATION_MESSAGE</div>\r\n                <div ng-hide="vm.configURL == null">\r\n                    <textarea>{{ vm.configURL }}</textarea>\r\n                    <br/>\r\n                    <span translate>LOGIN_LINK_HINT</span>\r\n                    <br/>\r\n                    <a href="#" ng-show="vm.supportsCopy" ng-click="vm.copy()" translate>COPY_LOGIN_LINK_PROMPT</a>\r\n                </div>\r\n            </div>\r\n\r\n            <div class="modal-footer">\r\n                <button type="button" class="btn btn-default" ng-click="vm.hide()" translate>DISMISS_CLOSE_ACTION</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>');
$templateCache.put('application/frontend/templates/modal-login-mock.html','<form>\r\n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'mock\', \'username\')">\r\n        {{ \'USERNAME\'|translate }}:\r\n        <br><input type="text" ng-model="configuration.mock.username" required ng-keypress="handleLoginKeyPress($event)">\r\n    </div>\r\n          \r\n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'mock\', \'password\')">\r\n        {{ \'PASSWORD\'|translate }}:\r\n        <br><input type="password" ng-model="configuration.mock.password" required ng-keypress="handleLoginKeyPress($event)">\r\n    </div>\r\n    \r\n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'mock\', \'initialDirectory\')">\r\n        {{ \'INITIAL_DIRECTORY\'|translate }}:\r\n        <br><input type="text" ng-model="configuration.mock.initialDirectory" required ng-keypress="handleLoginKeyPress($event)">\r\n    </div>\r\n        \r\n    <div class="input-wrapper" ng-hide="vm.loginItemHidden(\'remember-login\')">\r\n        <input type="checkbox" ng-model="metaConfiguration.rememberLogin" name="login_save" value="1" tabindex="-1"> {{ \'KEEP_ME_LOGGED_IN\'|translate }}\r\n    </div>\r\n</form>');
$templateCache.put('application/frontend/templates/modal-login-sftp.html','<form>\r\n    <div class="input-wrapper float-fix" ng-if="vm.configurationSettable(\'sftp\', \'host\')">\r\n        <div class="float-left width-host">\r\n            {{ \'HOST\'|translate }}:\r\n            <br>\r\n            <input type="text" ng-model="configuration.sftp.host" required ng-keypress="handleLoginKeyPress($event)" ng-if="vm.hostEntryIsText(\'sftp\')">\r\n            <select ng-if="!vm.hostEntryIsText(\'sftp\')" ng-model="configuration.sftp.host" class="form-control">\r\n                <option ng-repeat="host in vm.getHostOptions(\'sftp\')" ng-value="host">{{ host }}</option>\r\n            </select>\r\n        </div>\r\n        <div class="spacer"></div>\r\n        <div class="float-right width-port" ng-if="vm.configurationSettable(\'sftp\', \'port\')">\r\n            {{ \'PORT\'|translate }}:\r\n            <br><input type="text" ng-model="configuration.sftp.port" placeholder="{{ defaults.sftp.port }}" ng-keypress="handleLoginKeyPress($event)">\r\n        </div>\r\n    </div>\r\n\r\n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'sftp\', \'remoteUsername\')">\r\n        {{ \'USERNAME\'|translate }}:\r\n        <br><input type="text" ng-model="configuration.sftp.remoteUsername" required ng-keypress="handleLoginKeyPress($event)">\r\n    </div>\r\n\r\n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'sftp\', \'initialDirectory\')">\r\n        {{ \'INITIAL_DIRECTORY\'|translate }}:\r\n        <br><input type="text" ng-model="configuration.sftp.initialDirectory" required ng-keypress="handleLoginKeyPress($event)">\r\n    </div>\r\n\r\n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'sftp\', \'authenticationModeName\')">\r\n        {{ \'AUTHENTICATION_TYPE\'|translate }}:\r\n        <br>\r\n        <select ng-model="configuration.sftp.authenticationModeName" class="form-control">\r\n            <option value="Password" translate>PASSWORD</option>\r\n            <option value="PublicKeyFile" translate>SSH_AUTH_MODE_PUBLIC_KEY_FILE</option>\r\n            <option value="Agent" translate>SSH_AUTH_MODE_AGENT</option>\r\n        </select>\r\n    </div>\r\n    <div ng-show="vm.showDisabledSFTPAuthMessage()">\r\n        <span translate>SFTP_AUTHENTICATION_DISABLED_MESSAGE</span>\r\n        <a href="http://redirect.monstaftp.com/enable-ssh-auth"\r\n           target="mftp-new" rel="noopener noreferrer" translate>SFTP_AUTHENTICATION_ENABLED_INSTRUCTIONS_MESSAGE</a>\r\n    </div>\r\n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'sftp\', \'password\')"\r\n         ng-show="configuration.sftp.authenticationModeName == \'Password\' || configuration.sftp.authenticationModeName == \'PublicKeyFile\'">\r\n        <span ng-show="configuration.sftp.authenticationModeName == \'PublicKeyFile\'">{{ \'PRIVATE_KEY\'|translate }} </span>\r\n        {{ \'PASSWORD\'|translate }}<span ng-show="configuration.sftp.authenticationModeName == \'PublicKeyFile\'"> {{ \'OPTIONAL_OPTIONAL\'|translate }}</span>:\r\n        <br><input type="password" ng-model="configuration.sftp.password" ng-keypress="handleLoginKeyPress($event)">\r\n    </div>\r\n\r\n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'sftp\', \'privateKeyFilePath\')"\r\n         ng-show="configuration.sftp.authenticationModeName == \'PublicKeyFile\' || configuration.sftp.authenticationModeName == \'HostKeyFile\'">\r\n        {{ \'PRIVATE_KEY\'|translate }}:\r\n        <br><input type="text" ng-model="configuration.sftp.privateKeyFilePath" ng-keypress="handleLoginKeyPress($event)">\r\n    </div>\r\n\r\n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'sftp\', \'publicKeyFilePath\')"\r\n         ng-show="configuration.sftp.authenticationModeName == \'PublicKeyFile\' || configuration.sftp.authenticationModeName == \'HostKeyFile\'">\r\n        {{ \'PUBLIC_KEY\'|translate }}:\r\n        <br><input type="text" ng-model="configuration.sftp.publicKeyFilePath" ng-keypress="handleLoginKeyPress($event)">\r\n    </div>\r\n\r\n    <div class="input-wrapper" ng-hide="vm.loginItemHidden(\'remember-login\')">\r\n        <input type="checkbox" ng-model="metaConfiguration.rememberLogin" name="login_save" value="1" tabindex="-1" id="id_sftp_login_save" ng-click="vm.rememberLoginToggle()">\r\n        <label class="login-cb-label" for="id_sftp_login_save">{{ \'KEEP_ME_LOGGED_IN\'|translate }}</label>\r\n    </div>\r\n</form>');
$templateCache.put('application/frontend/templates/modal-login.html','<div class="modal fade" id="modal-login" tabindex="-1" role="dialog" aria-labelledby="modal-login-label"\r\n     ng-controller="LoginPanelController as vm">\r\n    <div class="modal-dialog" role="document">\r\n        <div class="modal-content">\r\n            <div class="modal-header label-warning">\r\n                <button ng-show="vm.isAuthenticated" type="button" class="close" data-dismiss="modal"\r\n                        aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}">\r\n                    <span aria-hidden="true">&times;</span>\r\n                </button>\r\n                <h4 class="modal-title" id="modal-login-label" translate>LOGIN</h4>\r\n            </div>\r\n            <div class="modal-body">\r\n\r\n                <ul class="nav nav-tabs" id="login-tab-links" ng-if="connectionTypes.length > 1">\r\n                    <li ng-repeat="connectionTypeIterator in connectionTypes" role="presentation"\r\n                        ng-class="{active: connectionTypeIterator[0] == connectionType }">\r\n                        <a href="" aria-controls="login-{{ connectionTypeIterator[0]}}"\r\n                           role="tab" ng-click="vm.selectTab(connectionTypeIterator[0])">\r\n                            {{ connectionTypeIterator[1]}}\r\n                        </a>\r\n                    </li>\r\n                </ul>\r\n\r\n                <div class="alert alert-warning" role="alert" ng-if="vm.showMissingLanguageMessage">\r\n                    <p>The language file could not be loaded. If you\'re running PHP under IIS, you will need to enable\r\n                        the JSON\r\n                        MIME type. Please see <a href="http://redirect.monstaftp.com/iis-enable-json" target="mftp-new"\r\n                                                 rel="noopener noreferrer">this article</a>.\r\n                    </p>\r\n                </div>\r\n\r\n                <div class="alert alert-danger" role="alert"\r\n                     ng-hide="storedAuthenticationErrorMessage == null || storedAuthenticationErrorMessage == \'\'">\r\n                    <strong class="error--attention" translate>ERROR_ATTENTION</strong> {{\r\n                    storedAuthenticationErrorMessage }}\r\n                </div>\r\n\r\n                <div class="input-wrapper float-fix" ng-show="vm.shouldShowProfiles() && !masterPasswordValid">\r\n                    <div class="float-left width-passwd">\r\n                        <input type="password" name="" ng-model="metaConfiguration.masterPassword"\r\n                               ng-keypress="masterPasswordKeypress($event)"\r\n                               placeholder="{{ (hasServerSavedAuthentication ? \'MASTER_PASSWORD_ENTER_PLACEHOLDER\' : \'MASTER_PASSWORD_SET_PLACEHOLDER\')|translate }}">\r\n                    </div>\r\n                    <div class="spacer"></div>\r\n                    <div class="float-right width-login">\r\n                        <i class="fa fa-sign-in fa-2x fa-fw" ng-click="handleAuthGo()"></i>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="input-wrapper" ng-show="masterPasswordValid && licenseFactory.isLicensed()">\r\n                    <select ng-model="metaConfiguration.savedProfileIndex" class="form-control"\r\n                            ng-change="handleProfileChange()">\r\n                        <option value="" translate>LOAD_PROFILE_DEFERRED_ACTION</option>\r\n                        <option ng-repeat="profile in savedAuthentication[connectionType] track by $index"\r\n                                value="{{ $index }}">\r\n                            {{ vm.getProfileName(profile, false) }}\r\n                        </option>\r\n                        <option value="new" translate>NEW_DEFERRED_ACTION</option>\r\n                    </select>\r\n                </div>\r\n\r\n                <div class="input-wrapper"\r\n                     ng-show="masterPasswordValid && licenseFactory.isLicensed() && vm.profileIsSelected()">\r\n                    {{ \'PROFILE_NAME_LABEL\'|translate }}:\r\n                    <br><input type="text" ng-model="metaConfiguration.enteredProfileName"\r\n                               placeholder="{{ vm.getDefaultProfileName() }}">\r\n                </div>\r\n\r\n                <div class="alert alert-danger" role="alert"\r\n                     ng-hide="connectionErrorMessage == null || connectionErrorMessage == \'\'">\r\n                    <strong class="error--attention" translate>ERROR_ATTENTION</strong> {{ connectionErrorMessage }}\r\n                    <!--TODO: get connectionErrorCode from API -->\r\n                </div>\r\n\r\n                <!-- Tab content -->\r\n                <div class="tab-content">\r\n                    <div ng-repeat="connectionTypeIterator in connectionTypes" role="tabpanel"\r\n                         class="tab-pane fade" ng-class="{\'active in\': connectionTypeIterator[0] == connectionType}"\r\n                         id="login-{{ connectionTypeIterator[0] }}">\r\n                        <ng-include\r\n                                src="\'application/frontend/templates/modal-login-\' + connectionTypeIterator[0] + \'.html\'"></ng-include>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <div class="modal-footer">\r\n                <a class="float-left ng-cloak" ng-show="vm.shouldShowPoweredBy" translate\r\n                   href="https://www.monstaftp.com" target="mftp-new" rel="noopener noreferrer">POWERED_BY_MONSTA_FTP</a>\r\n\r\n                <button type="button" class="btn btn-default float-left ng-cloak" ng-click="vm.showPasswordManager()"\r\n                        ng-show="vm.showPasswordManagementButton" translate>\r\n                    SHOW_PASSWORD_MANAGEMENT\r\n                </button>\r\n\r\n                <button type="button" class="btn btn-danger float-left" ng-click="initiateProfileDelete()"\r\n                        ng-hide="shouldHideDeleteButton()" translate>\r\n                    DELETE_DEFERRED_ACTION\r\n                </button>\r\n\r\n                <button type="button" class="btn btn-default float-left"\r\n                        ng-if="vm.showLoginLinkButton &amp;&amp; licenseFactory.isLicensed()"\r\n                        ng-hide="vm.loginItemHidden(\'login-link\')"\r\n                        ng-click="vm.showLoginLink()" title="{{ \'GENERATE_LOGIN_LINK_ACTION\'|translate }}"><i\r\n                        class="fa fa-link icon-rotate-135"></i></button>\r\n                <button type="button" class="btn btn-primary" ng-click="connect()" translate data-mf="connect-button">\r\n                    CONNECT\r\n                </button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>');
$templateCache.put('application/frontend/templates/modal-password-management.html','<div class="modal fade" id="modal-password-management" tabindex="-1" role="dialog" aria-labelledby="modal-addons-label"\r\n     ng-controller="ModalPasswordManagementController as vm" data-keyboard="false" data-backdrop="static">\r\n    <div class="modal-dialog" role="document">\r\n        <div class="modal-content">\r\n            <div class="modal-header label-warning">\r\n                <h4 class="modal-title" id="modal-password-management-label">{{\'PASSWORD_MANAGEMENT\'|translate}}</h4>\r\n            </div>\r\n            <div class="modal-body">\r\n                <ul class="nav nav-tabs" role="tablist" ng-if="vm.resetPasswordAvailable == vm.forgotPasswordAvailable">\r\n                    <li role="presentation" ng-class="{\'active\': vm.currentTab == \'forgot\'}">\r\n                        <a href="#" ng-click="vm.currentTab = \'forgot\'" aria-controls="form-forgot-password" role="tab" data-toggle="tab" translate>FORGOT_PASSWORD</a>\r\n                    </li>\r\n                    <li role="presentation" ng-click="vm.currentTab = \'reset\'" ng-class="{\'active\': vm.currentTab == \'reset\'}">\r\n                        <a href="#" aria-controls="form-reset-password" role="tab" data-toggle="tab" translate>RESET_PASSWORD</a>\r\n                    </li>\r\n                </ul>\r\n\r\n                <div class="tab-content">\r\n                    <div role="tabpanel" class="tab-pane" ng-class="{\'active\': vm.currentTab == \'forgot\'}" id="form-forgot-password" ng-if="vm.forgotPasswordAvailable" ng-show="vm.currentTab == \'forgot\'">\r\n                        <h4 ng-if="vm.resetPasswordAvailable != vm.forgotPasswordAvailable" translate>FORGOT_PASSWORD</h4>\r\n                        <div class="input-wrapper instructions">\r\n                            <p translate>FORGOT_PASSWORD_INSTRUCTIONS</p>\r\n                        </div>\r\n                        <div class="input-wrapper float-fix">\r\n                            {{ \'PASSWORD_MANAGEMENT_USERNAME_LABEL\'|translate }}:\r\n                            <br><input type="text" ng-model="vm.model.forgotPasswordUsername" placeholder="{{ \'PASSWORD_MANAGEMENT_USERNAME_LABEL\'|translate }}">\r\n                        </div>\r\n\r\n                        <div class="alert alert-danger" role="alert" ng-show="vm.forgotPasswordFailed">\r\n                            {{ vm.forgotPasswordFailedMessage|translate }}\r\n                        </div>\r\n\r\n                        <div class="alert alert-success" role="alert" ng-show="vm.forgotPasswordSucceeded">\r\n                            {{ vm.forgotPasswordSucceededMessage|translate }}\r\n                        </div>\r\n\r\n                        <div class="input-wrapper float-fix">\r\n                            <button type="button" class="btn btn-primary float-right" ng-click="vm.initiateForgotPassword()">\r\n                                {{ \'INITIATE_FORGOT_PASSWORD\'|translate }}\r\n                            </button>\r\n                        </div>\r\n                    </div>\r\n\r\n                    <div role="tabpanel" class="tab-pane" ng-class="{\'active\': vm.currentTab == \'reset\'}"  id="form-reset-password" ng-if="vm.resetPasswordAvailable" ng-show="vm.currentTab == \'reset\'">\r\n                        <h4 ng-if="vm.resetPasswordAvailable != vm.forgotPasswordAvailable" translate>RESET_PASSWORD</h4>\r\n                        <div class="input-wrapper instructions">\r\n                            <p translate>RESET_PASSWORD_INSTRUCTIONS</p>\r\n                        </div>\r\n                        <div class="input-wrapper float-fix">\r\n                            {{ \'PASSWORD_MANAGEMENT_USERNAME_LABEL\'|translate }}:\r\n                            <br><input type="text" ng-model="vm.model.resetPasswordUsername" placeholder="{{ \'PASSWORD_MANAGEMENT_USERNAME_LABEL\'|translate }}">\r\n                        </div>\r\n\r\n                        <div class="input-wrapper float-fix">\r\n                            {{ \'CURRENT_PASSWORD_LABEL\'|translate }}:\r\n                            <br><input type="password" ng-model="vm.model.currentPassword" placeholder="{{ \'CURRENT_PASSWORD_LABEL\'|translate }}">\r\n                        </div>\r\n\r\n                        <div class="input-wrapper float-fix">\r\n                            {{ \'NEW_PASSWORD_LABEL\'|translate }}:\r\n                            <br><input type="password" ng-model="vm.model.resetPassword" placeholder="{{ \'NEW_PASSWORD_LABEL\'|translate }}">\r\n                        </div>\r\n\r\n                        <div class="input-wrapper float-fix">\r\n                            {{ \'CONFIRM_PASSWORD_LABEL\'|translate }}:\r\n                            <br><input type="password" ng-model="vm.model.confirmPassword" placeholder="{{ \'CONFIRM_PASSWORD_LABEL\'|translate }}">\r\n                        </div>\r\n\r\n                        <div class="alert alert-danger" role="alert" ng-show="vm.resetPasswordFailed">\r\n                            {{ vm.resetPasswordFailedMessage|translate }}\r\n                        </div>\r\n\r\n                        <div class="alert alert-success" role="alert" ng-show="vm.resetPasswordSucceeded">\r\n                            {{ vm.resetPasswordSucceededMessage|translate }}\r\n                        </div>\r\n\r\n                        <div class="input-wrapper float-fix">\r\n                            <button type="button" class="btn btn-primary float-right" ng-click="vm.initiateResetPassword()">\r\n                                {{ \'INITIATE_RESET_PASSWORD\'|translate }}\r\n                            </button>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class="modal-footer">\r\n                <button type="button" class="btn btn-default" ng-click="vm.showLoginPanel()">\r\n                    {{ \'SHOW_LOGIN_FORM\'|translate }}\r\n                </button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>');
$templateCache.put('application/frontend/templates/modal-prompt.html','<div class="modal fade" id="modal-prompt" tabindex="-1" role="dialog" aria-labelledby="modal-prompt-label" \r\n\tng-controller="ModalPromptController as modalPromptController">\r\n    <div class="modal-dialog" role="document">\r\n        <div class="modal-content">\r\n            <div class="modal-header label-warning">\r\n                <button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}">\r\n                    <span aria-hidden="true">&times;</span>\r\n                </button>\r\n                <h4 class="modal-title" id="modal-prompt-label">{{ title }}</h4>\r\n            </div>\r\n            <div class="modal-body">\r\n            \t<div class="alert alert-danger" role="alert" ng-show="errorSet"><strong class="error--attention" translate>ERROR_ATTENTION</strong> {{ errorMessage }}</div>\r\n                <input type="text" name="" ng-model="final" placeholder="{{ placeHolder|translate }}" ng-keypress="handlePromptKeypress($event)">\r\n            </div>\r\n            <div class="modal-footer">\r\n                <button type="button" class="btn btn-default" data-dismiss="modal" ng-disabled="isBusy" translate>DISMISS_CANCEL_ACTION</button>\r\n                <button type="button" class="btn btn-default" ng-click="successClose()" ng-disabled="isBusy">{{ dismissMessage }}</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>');
$templateCache.put('application/frontend/templates/modal-properties.html','<div class="modal fade" id="modal-properties" tabindex="-1" role="dialog" aria-labelledby="modal-properties-label"\r\n\t ng-controller="ModalPropertiesController as vm">\r\n    <div class="modal-dialog" role="document">\r\n        <div class="modal-content">\r\n            <div class="modal-header label-warning">\r\n                <button type="button" class="close" data-dismiss="modal"\r\n                        aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate}}">\r\n                    <span aria-hidden="true">&times;</span>\r\n                </button>\r\n                <h4 class="modal-title" id="modal-properties-label" translate>PROPERTIES</h4>\r\n            </div>\r\n            <div class="modal-body">\r\n                <table ng-if="vm.item != null">\r\n                \t<tr title="{{ \'NAME\'|translate }}">\r\n                \t\t<td class="icon"><i class="fa fa-info-circle fa-fw"></i></td>\r\n                \t\t<td><div class="property">{{ vm.item.name }}</div></td>\r\n                \t</tr>\r\n                \t<tr title="{{ \'MODIFICATION_DATE\'|translate }}">\r\n                \t\t<td class="icon"><i class="fa fa-history fa-fw"></td>\r\n                \t\t<td><div class="property">{{ (vm.item.modificationDate * 1000)|date:"medium" }}</div></td>\r\n                \t</tr>\r\n                \t<tr title="{{ \'SIZE\'|translate }}">\r\n                \t\t<td class="icon"><i class="fa fa-hdd-o fa-fw"></td>\r\n                \t\t<td><div class="property">{{ vm.item.size|number }} {{ "BYTE"|translate:{size:vm.item.size} }}\r\n                            <span ng-show="vm.item.size >= 1024">({{ vm.item.size|file_size }})</span></div>\r\n                        </td>\r\n                \t</tr>\r\n                \t<tr title="{{ \'OWNER\'|translate }}">\r\n                \t\t<td class="icon"><i class="fa fa-user fa-fw"></td>\r\n                \t\t<td><div class="property">{{ vm.item.ownerUserName }}</div></td>\r\n                \t</tr>\r\n                \t<tr title="{{ \'GROUP\'|translate }}">\r\n                \t\t<td class="icon"><i class="fa fa-users fa-fw"></td>\r\n                \t\t<td><div class="property">{{ vm.item.ownerGroupName }}</div></td>\r\n                \t</tr>\r\n                \t<tr title="{{ \'PERMISSIONS\'|translate }}">\r\n                \t\t<td class="icon"><i class="fa fa-key fa-fw"></td>\r\n                \t\t<td><div class="property">{{ vm.item|item_permission_description }} (0{{ vm.item.numericPermissions.toString(8) }})</div></td>\r\n                \t</tr>\r\n                </table>\r\n            </div>\r\n            <div class="modal-footer">\r\n                <button type="button" class="btn btn-default" data-dismiss="modal" translate>DISMISS_CLOSE_ACTION</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>');
$templateCache.put('application/frontend/templates/modal-search.html','<div class="modal fade" id="modal-search" tabindex="-1" role="dialog" aria-labelledby="modal-search-label">\r\n\t<div class="modal-dialog" role="document">\r\n\t\t<div class="modal-content">\r\n\t\t\t<div class="modal-header label-warning">\r\n\t\t\t\t<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>\r\n\t\t\t\t<h4 class="modal-title" id="modal-search-label">Search</h4>\r\n\t\t\t</div>\r\n\t\t\t<div class="modal-body">\r\n\t\t\t\t<input type="text" name="" placeholder="Enter new folder name...">\r\n\t\t\t</div>\r\n\t\t\t<div class="modal-footer">\r\n\t\t\t\t<button type="button" class="btn btn-default">OK</button>\r\n\t\t\t\t<button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t</div>\r\n</div>');
$templateCache.put('application/frontend/templates/modal-settings.html','<div class="modal fade" id="modal-settings" tabindex="-1" role="dialog" aria-labelledby="modal-settings-label"\r\n     ng-controller="ModalSettingsController as vm">\r\n    <div class="modal-dialog" role="document">\r\n        <div class="modal-content">\r\n            <div class="modal-header label-warning">\r\n                <button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}">\r\n                    <span aria-hidden="true">&times;</span></button>\r\n                <h4 class="modal-title" id="modal-settings-label" translate>SETTINGS</h4>\r\n            </div>\r\n            <div class="modal-body">\r\n                <fieldset>\r\n                    <legend translate>LANGUAGE_LABEL</legend>\r\n                    <select ng-model="vm.applicationSettings.language">\r\n                        <option ng-repeat="languageCodeAndName in vm.languageFiles track by $index" value="{{ languageCodeAndName[0] }}">{{ languageCodeAndName[1] }}</option>\r\n                    </select>\r\n                </fieldset>\r\n            </div>\r\n            <div class="modal-footer">\r\n                <button type="button" class="btn btn-default" data-dismiss="modal" translate>DISMISS_CANCEL_ACTION</button>\r\n                <button type="button" class="btn btn-primary" ng-click="vm.saveSettings()" translate>SAVE_ACTION</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>');
$templateCache.put('application/frontend/templates/modal-transfers.html','<div class="modal fade" id="modal-transfers" tabindex="-1" role="dialog" aria-labelledby="modal-transfers-label"\r\n     ng-controller="ModalTransferController as vm" data-backdrop="static" data-keyboard="false">\r\n    <div class="modal-dialog" role="document">\r\n        <div class="modal-content">\r\n            <div class="modal-header label-warning">\r\n                <div class="float-right">{{ uploadPos + 1 }} {{\r\n                    \'COMPLETED_OF_TOTAL_JOINER\'|translate }} {{ vm.completedUploadTotal }}</div>\r\n                <h4 class="modal-title" id="modal-transfers-label">{{ \'FILE_TRANSFER\'|translate }}</h4>\r\n            </div>\r\n            <div class="modal-body">\r\n                <div class="file" ng-repeat="upload in vm.uploads | limitTo:1:0">\r\n                    <div class="status">\r\n                        <div class="icon">\r\n                            <i class="fa {{ upload|icon }} fa-fw"></i>\r\n                        </div>\r\n                        <div class="name" ng-if="itemPath == null">\r\n                            {{ itemName }}\r\n                        </div>\r\n                        <div class="name" ng-if="itemPath != null">\r\n                            {{ vm.remotePathToRelative(itemPath) }}\r\n                        </div>\r\n                        <button class="close" type="button" ng-click="vm.abortItem(upload)">\xD7</button>\r\n                    </div>\r\n                    <div class="progress">\r\n                        <upload-progress-bar transfer="upload" stage="1"></upload-progress-bar>\r\n\t\t\t\t\t</div>\r\n                    <div class="status">\r\n                        <div class="transferred" ng-show="upload.archiveExtractMax == 0">\r\n                            {{ vm.fsFilter(partsCompleted) }} {{ \'COMPLETED_OF_TOTAL_JOINER\'|translate }}\r\n                            {{ vm.fsFilter(itemTotal) }}\r\n                        </div>\r\n                        <div class="transferred" ng-show="upload.archiveExtractMax != 0">\r\n                            {{ upload.archiveExtractCurrent }} {{ \'COMPLETED_OF_TOTAL_JOINER\'|translate }} {{ upload.archiveExtractMax }}\r\n                        </div>\r\n                        <div class="rate">\r\n\t\t\t\t\t\t\t<span ng-hide="upload.stats.completedItems == upload.stats.totalItems || !upload.stats.hasBeenStarted()">\r\n                                {{ upload|transfer_rate}}\r\n                            </span>\r\n                            <span ng-show="upload.stats.completedItems == upload.stats.totalItems && !upload.isArchive && !upload.hasError">\r\n                                <span ng-show="$root.completedUploadTotal != $root.currentUploadNumber" translate>UPLOAD_TRANSFERRING_TO_SERVER_MESSAGE</span>\r\n                                <span ng-show="$root.completedUploadTotal == $root.currentUploadNumber" translate>UPLOAD_PROCESSING_SERVER_MESSAGE</span>\r\n                            </span>\r\n                            <span ng-show="upload.hasError">\r\n                                {{ \'UPLOAD_FAILED_MESSAGE\'|translate }}\r\n                                <span ng-if="upload.errorText == null">{{ upload.statusCode }} / {{ upload.statusText }}</span>\r\n                                <span ng-if="upload.errorText != null">{{ upload.errorText }}</span>\r\n                            </span>\r\n                            <span ng-show="upload.stats.transferType == \'extract\' &amp;&amp; upload.isArchive" translate>\r\n                                UPLOAD_ARCHIVE_TRANSFERRING_MESSAGE\r\n                            </span>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class="modal-footer">\r\n                <button type="button" class="btn btn-danger" ng-click="vm.abortAll()" translate>DISMISS_CANCEL_ALL_ACTION</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>');
$templateCache.put('application/frontend/templates/modal-update.html','<div class="modal fade" id="modal-update" tabindex="-1" role="dialog" aria-labelledby="modal-update-label" ng-controller="UpdateController as vm">\r\n    <div class="modal-dialog" role="document">\r\n        <div class="modal-content">\r\n            <div class="modal-header label-warning">\r\n                <button type="button" class="close" data-dismiss="modal"\r\n                        aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate}}">\r\n                    <span aria-hidden="true">&times;</span>\r\n                </button>\r\n                <h4 class="modal-title" id="modal-update-label">{{ vm.modalTitle|translate }}</h4>\r\n            </div>\r\n            <div class="modal-body">\r\n                <div ng-if="!vm.downloadInProgress &amp;&amp; !vm.installInProgress &amp;&amp; !vm.upgradeComplete">\r\n                    <p ng-bind-html="vm.latestVersionMessage|html_safe"></p>\r\n                    \r\n                    <div class="alert alert-danger" ng-if="!vm.automaticUpgradeAvailable" role="alert">\r\n                        <p ng-bind-html="vm.licensedOnlyMessage|html_safe" ng-if="!vm.isLicensed"></p>\r\n                        <p ng-if="vm.automaticUpgradeUnavailableReason != \'\'" translate>{{vm.automaticUpgradeUnavailableReason}}</p>\r\n                    </div>\r\n                    \r\n                    <p ng-bind-html="vm.releaseNotesMessage|html_safe"></p>\r\n\r\n                    <p ng-if="!vm.automaticUpgradeAvailable">\r\n                        <a href="http://redirect.monstaftp.com/download" target="mftp-new" rel="noopener noreferrer">{{ \'DOWNLOAD_UPDATE_DEFERRED_ACTION\'|translate }}</a>\r\n                    </p>\r\n\r\n                    <div class="alert alert-danger" role="alert"\r\n                         ng-hide="vm.storedAuthenticationErrorMessage == null || vm.storedAuthenticationErrorMessage == \'\'">\r\n                        <strong class="error--attention" translate>ERROR_ATTENTION</strong> {{ vm.storedAuthenticationErrorMessage|translate }}\r\n                    </div>\r\n\r\n                    <div ng-if="vm.isLicensed &amp;&amp; vm.hasServerSavedAuthentication && !vm.startUpgradeEnabled" class="input-wrapper float-fix">\r\n                        <div class="float-left width-passwd">\r\n                            <input type="password" name="" ng-model="vm.model.masterPassword"\r\n                                   ng-keypress="vm.handlePasswordKeypress($event)"\r\n                                   placeholder="{{ \'MASTER_PASSWORD_ENTER_PLACEHOLDER\'|translate }}">\r\n                        </div>\r\n                        <div class="spacer"></div>\r\n                        <div class="float-right width-login">\r\n                            <i class="fa fa-sign-in fa-2x fa-fw" ng-click="vm.validatePassword()"></i>\r\n                        </div>\r\n                    </div>\r\n                    <div class="alert alert-success" ng-if="vm.startUpgradeEnabled" role="alert" translate>\r\n                        USER_UI_AUTHORISED_MESSAGE\r\n                    </div>\r\n                </div>\r\n                <div ng-if="vm.downloadInProgress || vm.installInProgress">\r\n                    <div class="file">\r\n                        <div class="status">\r\n                            <div class="icon">\r\n                                <i class="fa fa-file-archive-o fa-fw"></i>\r\n                            </div>\r\n                            <div class="name">\r\n                                Version {{ vm.latestVersion }} Install Package\r\n                            </div>\r\n                        </div>\r\n                        <div class="progress">\r\n                            <div class="progress-bar progress-bar-success progress-bar-striped active" role="progressbar" style="width: 100%;"></div>\r\n                        </div>\r\n                        <div class="status">\r\n                            <span>\r\n                                Downloading&hellip;\r\n                            </span>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n                <div ng-if="vm.upgradeComplete">\r\n                    {{ vm.upgradeCompleteMessage }}\r\n                </div>\r\n            </div>\r\n            <div class="modal-footer">\r\n                <div ng-if="!vm.downloadInProgress &amp;&amp; !vm.installInProgress &amp;&amp; !vm.upgradeComplete">\r\n                    <button ng-if="!vm.isLicensed" type="button" class="btn btn-default" data-dismiss="modal" translate>DISMISS_CLOSE_ACTION</button>\r\n                    <button ng-if="vm.isLicensed" type="button" class="btn btn-default float-left" data-dismiss="modal" translate>DISMISS_CANCEL_ACTION</button>\r\n                    <button ng-if="vm.isLicensed" type="button" class="btn btn-primary right" ng-class="{\'disabled\': !vm.startUpgradeEnabled}" ng-click="vm.startUpgrade()" translate>START_UPGRADE_ACTION</button>\r\n                </div>\r\n                <button ng-if="vm.upgradeComplete" type="button" class="btn btn-primary right" ng-click="vm.refresh()" translate>REFRESH</button>\r\n                <div ng-if="vm.downloadInProgress || vm.installInProgress">\r\n                    <p class="text-center" translate>DO_NOT_CLOSE_DURING_UPGRADE_BROWSER_MESSAGE</p>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>');
$templateCache.put('application/frontend/templates/modal-upgrade-required.html','<div class="modal fade" id="modal-upgrade-required" tabindex="-1" role="dialog" aria-labelledby="modal-upgrade-required-label"\r\n     ng-controller="ModalUpgradeRequiredController as vm">\r\n    <div class="modal-dialog" role="document">\r\n        <div class="modal-content">\r\n            <div class="modal-header label-warning">\r\n                <button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}">\r\n                    <span aria-hidden="true">&times;</span>\r\n                </button>\r\n                <h4 class="modal-title" id="modal-upgrade-required-label" translate>UPGRADE_REQUIRED</h4>\r\n            </div>\r\n            <div class="modal-body">\r\n                <p translate>{{ vm.upgradeRequiredMessage }}</p>\r\n            </div>\r\n            <div class="modal-footer">\r\n                <button type="button" class="btn btn-default" data-dismiss="modal" translate>DISMISS_CLOSE_ACTION</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>');}]);