/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * monaco-css version: 2.2.0(ce1fb4aab797eaa8f5071c77302f7bb72bcb22ea)
 * Released under the MIT license
 * https://github.com/Microsoft/monaco-css/blob/master/LICENSE.md
 *-----------------------------------------------------------------------------*/
define("vs/language/css/workerManager",["require","exports"],function(e,n){"use strict";Object.defineProperty(n,"__esModule",{value:!0});var s=monaco.Promise,t=function(){function e(e){var n=this;this._defaults=e,this._worker=null,this._idleCheckInterval=setInterval(function(){return n._checkIfIdle()},3e4),this._lastUsedTime=0,this._configChangeListener=this._defaults.onDidChange(function(){return n._stopWorker()})}return e.prototype._stopWorker=function(){this._worker&&(this._worker.dispose(),this._worker=null),this._client=null},e.prototype.dispose=function(){clearInterval(this._idleCheckInterval),this._configChangeListener.dispose(),this._stopWorker()},e.prototype._checkIfIdle=function(){this._worker&&(12e4<Date.now()-this._lastUsedTime&&this._stopWorker())},e.prototype._getClient=function(){return this._lastUsedTime=Date.now(),this._client||(this._worker=monaco.editor.createWebWorker({moduleId:"vs/language/css/cssWorker",label:this._defaults.languageId,createData:{languageSettings:this._defaults.diagnosticsOptions,languageId:this._defaults.languageId}}),this._client=this._worker.getProxy()),this._client},e.prototype.getLanguageServiceWorker=function(){for(var n,e,t,r,i,o=this,a=[],u=0;u<arguments.length;u++)a[u]=arguments[u];return e=this._getClient().then(function(e){n=e}).then(function(e){return o._worker.withSyncedResources(a)}).then(function(e){return n}),i=new s(function(e,n){t=e,r=n},function(){}),e.then(t,r),i},e}();n.WorkerManager=t}),function(e){if("object"==typeof module&&"object"==typeof module.exports){var n=e(require,exports);void 0!==n&&(module.exports=n)}else"function"==typeof define&&define.amd&&define("vscode-languageserver-types/main",["require","exports"],e)}(function(e,n){"use strict";var a,t,r,i,o,u,s,c,d,l,g,f,m,p,h,v,y,b,C,_,k,x,I,w;Object.defineProperty(n,"__esModule",{value:!0}),(t=a=n.Position||(n.Position={})).create=function(e,n){return{line:e,character:n}},t.is=function(e){var n=e;return Z.objectLiteral(n)&&Z.number(n.line)&&Z.number(n.character)},(i=r=n.Range||(n.Range={})).create=function(e,n,t,r){if(Z.number(e)&&Z.number(n)&&Z.number(t)&&Z.number(r))return{start:a.create(e,n),end:a.create(t,r)};if(a.is(e)&&a.is(n))return{start:e,end:n};throw new Error("Range#create called with invalid arguments["+e+", "+n+", "+t+", "+r+"]")},i.is=function(e){var n=e;return Z.objectLiteral(n)&&a.is(n.start)&&a.is(n.end)},(u=o=n.Location||(n.Location={})).create=function(e,n){return{uri:e,range:n}},u.is=function(e){var n=e;return Z.defined(n)&&r.is(n.range)&&(Z.string(n.uri)||Z.undefined(n.uri))},(c=s=n.Color||(n.Color={})).create=function(e,n,t,r){return{red:e,green:n,blue:t,alpha:r}},c.is=function(e){var n=e;return Z.number(n.red)&&Z.number(n.green)&&Z.number(n.blue)&&Z.number(n.alpha)},(d=n.ColorInformation||(n.ColorInformation={})).create=function(e,n){return{range:e,color:n}},d.is=function(e){var n=e;return r.is(n.range)&&s.is(n.color)},(l=n.ColorPresentation||(n.ColorPresentation={})).create=function(e,n,t){return{label:e,textEdit:n,additionalTextEdits:t}},l.is=function(e){var n=e;return Z.string(n.label)&&(Z.undefined(n.textEdit)||_.is(n))&&(Z.undefined(n.additionalTextEdits)||Z.typedArray(n.additionalTextEdits,_.is))},(g=n.FoldingRangeKind||(n.FoldingRangeKind={})).Comment="comment",g.Imports="imports",g.Region="region",(f=n.FoldingRange||(n.FoldingRange={})).create=function(e,n,t,r,i){var o={startLine:e,endLine:n};return Z.defined(t)&&(o.startCharacter=t),Z.defined(r)&&(o.endCharacter=r),Z.defined(i)&&(o.kind=i),o},f.is=function(e){var n=e;return Z.number(n.startLine)&&Z.number(n.startLine)&&(Z.undefined(n.startCharacter)||Z.number(n.startCharacter))&&(Z.undefined(n.endCharacter)||Z.number(n.endCharacter))&&(Z.undefined(n.kind)||Z.string(n.kind))},(p=m=n.DiagnosticRelatedInformation||(n.DiagnosticRelatedInformation={})).create=function(e,n){return{location:e,message:n}},p.is=function(e){var n=e;return Z.defined(n)&&o.is(n.location)&&Z.string(n.message)},(h=n.DiagnosticSeverity||(n.DiagnosticSeverity={})).Error=1,h.Warning=2,h.Information=3,h.Hint=4,(y=v=n.Diagnostic||(n.Diagnostic={})).create=function(e,n,t,r,i,o){var a={range:e,message:n};return Z.defined(t)&&(a.severity=t),Z.defined(r)&&(a.code=r),Z.defined(i)&&(a.source=i),Z.defined(o)&&(a.relatedInformation=o),a},y.is=function(e){var n=e;return Z.defined(n)&&r.is(n.range)&&Z.string(n.message)&&(Z.number(n.severity)||Z.undefined(n.severity))&&(Z.number(n.code)||Z.string(n.code)||Z.undefined(n.code))&&(Z.string(n.source)||Z.undefined(n.source))&&(Z.undefined(n.relatedInformation)||Z.typedArray(n.relatedInformation,m.is))},(C=b=n.Command||(n.Command={})).create=function(e,n){for(var t=[],r=2;r<arguments.length;r++)t[r-2]=arguments[r];var i={title:e,command:n};return Z.defined(t)&&0<t.length&&(i.arguments=t),i},C.is=function(e){var n=e;return Z.defined(n)&&Z.string(n.title)&&Z.string(n.command)},(k=_=n.TextEdit||(n.TextEdit={})).replace=function(e,n){return{range:e,newText:n}},k.insert=function(e,n){return{range:{start:e,end:e},newText:n}},k.del=function(e){return{range:e,newText:""}},k.is=function(e){var n=e;return Z.objectLiteral(n)&&Z.string(n.newText)&&r.is(n.range)},(I=x=n.TextDocumentEdit||(n.TextDocumentEdit={})).create=function(e,n){return{textDocument:e,edits:n}},I.is=function(e){var n=e;return Z.defined(n)&&D.is(n.textDocument)&&Array.isArray(n.edits)},(w=n.WorkspaceEdit||(n.WorkspaceEdit={})).is=function(e){var n=e;return n&&(void 0!==n.changes||void 0!==n.documentChanges)&&(void 0===n.documentChanges||Z.typedArray(n.documentChanges,x.is))};var S,D,K,E,T,M,A,R,P,F,L,O,j,H,W=function(){function e(e){this.edits=e}return e.prototype.insert=function(e,n){this.edits.push(_.insert(e,n))},e.prototype.replace=function(e,n){this.edits.push(_.replace(e,n))},e.prototype.delete=function(e){this.edits.push(_.del(e))},e.prototype.add=function(e){this.edits.push(e)},e.prototype.all=function(){return this.edits},e.prototype.clear=function(){this.edits.splice(0,this.edits.length)},e}(),N=function(){function e(t){var r=this;this._textEditChanges=Object.create(null),t&&((this._workspaceEdit=t).documentChanges?t.documentChanges.forEach(function(e){var n=new W(e.edits);r._textEditChanges[e.textDocument.uri]=n}):t.changes&&Object.keys(t.changes).forEach(function(e){var n=new W(t.changes[e]);r._textEditChanges[e]=n}))}return Object.defineProperty(e.prototype,"edit",{get:function(){return this._workspaceEdit},enumerable:!0,configurable:!0}),e.prototype.getTextEditChange=function(e){if(D.is(e)){if(this._workspaceEdit||(this._workspaceEdit={documentChanges:[]}),!this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for versioned document changes.");var n=e;if(!(r=this._textEditChanges[n.uri])){var t={textDocument:n,edits:i=[]};this._workspaceEdit.documentChanges.push(t),r=new W(i),this._textEditChanges[n.uri]=r}return r}if(this._workspaceEdit||(this._workspaceEdit={changes:Object.create(null)}),!this._workspaceEdit.changes)throw new Error("Workspace edit is not configured for normal text edit changes.");var r;if(!(r=this._textEditChanges[e])){var i=[];this._workspaceEdit.changes[e]=i,r=new W(i),this._textEditChanges[e]=r}return r},e}();n.WorkspaceChange=N,(S=n.TextDocumentIdentifier||(n.TextDocumentIdentifier={})).create=function(e){return{uri:e}},S.is=function(e){var n=e;return Z.defined(n)&&Z.string(n.uri)},(K=D=n.VersionedTextDocumentIdentifier||(n.VersionedTextDocumentIdentifier={})).create=function(e,n){return{uri:e,version:n}},K.is=function(e){var n=e;return Z.defined(n)&&Z.string(n.uri)&&Z.number(n.version)},(E=n.TextDocumentItem||(n.TextDocumentItem={})).create=function(e,n,t,r){return{uri:e,languageId:n,version:t,text:r}},E.is=function(e){var n=e;return Z.defined(n)&&Z.string(n.uri)&&Z.string(n.languageId)&&Z.number(n.version)&&Z.string(n.text)},(M=T=n.MarkupKind||(n.MarkupKind={})).PlainText="plaintext",M.Markdown="markdown",(A=T=n.MarkupKind||(n.MarkupKind={})).is=function(e){var n=e;return n===A.PlainText||n===A.Markdown},(R=n.MarkupContent||(n.MarkupContent={})).is=function(e){var n=e;return Z.objectLiteral(e)&&T.is(n.kind)&&Z.string(n.value)},(P=n.CompletionItemKind||(n.CompletionItemKind={})).Text=1,P.Method=2,P.Function=3,P.Constructor=4,P.Field=5,P.Variable=6,P.Class=7,P.Interface=8,P.Module=9,P.Property=10,P.Unit=11,P.Value=12,P.Enum=13,P.Keyword=14,P.Snippet=15,P.Color=16,P.File=17,P.Reference=18,P.Folder=19,P.EnumMember=20,P.Constant=21,P.Struct=22,P.Event=23,P.Operator=24,P.TypeParameter=25,(F=n.InsertTextFormat||(n.InsertTextFormat={})).PlainText=1,F.Snippet=2,(n.CompletionItem||(n.CompletionItem={})).create=function(e){return{label:e}},(n.CompletionList||(n.CompletionList={})).create=function(e,n){return{items:e||[],isIncomplete:!!n}},(O=L=n.MarkedString||(n.MarkedString={})).fromPlainText=function(e){return e.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")},O.is=function(e){var n=e;return Z.string(n)||Z.objectLiteral(n)&&Z.string(n.language)&&Z.string(n.value)},(n.Hover||(n.Hover={})).is=function(e){var n=e;return Z.objectLiteral(n)&&(R.is(n.contents)||L.is(n.contents)||Z.typedArray(n.contents,L.is))&&(void 0===e.range||r.is(e.range))},(n.ParameterInformation||(n.ParameterInformation={})).create=function(e,n){return n?{label:e,documentation:n}:{label:e}},(n.SignatureInformation||(n.SignatureInformation={})).create=function(e,n){for(var t=[],r=2;r<arguments.length;r++)t[r-2]=arguments[r];var i={label:e};return Z.defined(n)&&(i.documentation=n),Z.defined(t)?i.parameters=t:i.parameters=[],i},(j=n.DocumentHighlightKind||(n.DocumentHighlightKind={})).Text=1,j.Read=2,j.Write=3,(n.DocumentHighlight||(n.DocumentHighlight={})).create=function(e,n){var t={range:e};return Z.number(n)&&(t.kind=n),t},(H=n.SymbolKind||(n.SymbolKind={})).File=1,H.Module=2,H.Namespace=3,H.Package=4,H.Class=5,H.Method=6,H.Property=7,H.Field=8,H.Constructor=9,H.Enum=10,H.Interface=11,H.Function=12,H.Variable=13,H.Constant=14,H.String=15,H.Number=16,H.Boolean=17,H.Array=18,H.Object=19,H.Key=20,H.Null=21,H.EnumMember=22,H.Struct=23,H.Event=24,H.Operator=25,H.TypeParameter=26,(n.SymbolInformation||(n.SymbolInformation={})).create=function(e,n,t,r,i){var o={name:e,kind:n,location:{uri:r,range:t}};return i&&(o.containerName=i),o};var V,U,q,z,B,$,Q=function(){};n.DocumentSymbol=Q,(V=Q=n.DocumentSymbol||(n.DocumentSymbol={})).create=function(e,n,t,r,i,o){var a={name:e,detail:n,kind:t,range:r,selectionRange:i};return void 0!==o&&(a.children=o),a},V.is=function(e){var n=e;return n&&Z.string(n.name)&&Z.string(n.detail)&&Z.number(n.kind)&&r.is(n.range)&&r.is(n.selectionRange)&&(void 0===n.deprecated||Z.boolean(n.deprecated))&&(void 0===n.children||Array.isArray(n.children))},n.DocumentSymbol=Q,(U=n.CodeActionKind||(n.CodeActionKind={})).QuickFix="quickfix",U.Refactor="refactor",U.RefactorExtract="refactor.extract",U.RefactorInline="refactor.inline",U.RefactorRewrite="refactor.rewrite",U.Source="source",U.SourceOrganizeImports="source.organizeImports",(q=n.CodeActionContext||(n.CodeActionContext={})).create=function(e,n){var t={diagnostics:e};return null!=n&&(t.only=n),t},q.is=function(e){var n=e;return Z.defined(n)&&Z.typedArray(n.diagnostics,v.is)&&(void 0===n.only||Z.typedArray(n.only,Z.string))},(z=n.CodeAction||(n.CodeAction={})).create=function(e,n,t){var r={title:e};return b.is(n)?r.command=n:r.edit=n,void 0!==t&&(r.kind=t),r},z.is=function(e){var n=e;return n&&Z.string(n.title)&&(void 0===n.diagnostics||Z.typedArray(n.diagnostics,v.is))&&(void 0===n.kind||Z.string(n.kind))&&(void 0!==n.edit||void 0!==n.command)&&(void 0===n.command||b.is(n.command))&&(void 0===n.edit||w.is(n.edit))},(B=n.CodeLens||(n.CodeLens={})).create=function(e,n){var t={range:e};return Z.defined(n)&&(t.data=n),t},B.is=function(e){var n=e;return Z.defined(n)&&r.is(n.range)&&(Z.undefined(n.command)||b.is(n.command))},($=n.FormattingOptions||(n.FormattingOptions={})).create=function(e,n){return{tabSize:e,insertSpaces:n}},$.is=function(e){var n=e;return Z.defined(n)&&Z.number(n.tabSize)&&Z.boolean(n.insertSpaces)};var G,J,X,Y=function(){};n.DocumentLink=Y,(G=Y=n.DocumentLink||(n.DocumentLink={})).create=function(e,n,t){return{range:e,target:n,data:t}},G.is=function(e){var n=e;return Z.defined(n)&&r.is(n.range)&&(Z.undefined(n.target)||Z.string(n.target))},n.DocumentLink=Y,n.EOL=["\n","\r\n","\r"],(J=n.TextDocument||(n.TextDocument={})).create=function(e,n,t,r){return new te(e,n,t,r)},J.is=function(e){var n=e;return!!(Z.defined(n)&&Z.string(n.uri)&&(Z.undefined(n.languageId)||Z.string(n.languageId))&&Z.number(n.lineCount)&&Z.func(n.getText)&&Z.func(n.positionAt)&&Z.func(n.offsetAt))},J.applyEdits=function(e,n){for(var t=e.getText(),r=function e(n,t){if(n.length<=1)return n;var r=n.length/2|0,i=n.slice(0,r),o=n.slice(r);e(i,t),e(o,t);for(var a=0,u=0,s=0;a<i.length&&u<o.length;){var c=t(i[a],o[u]);n[s++]=c<=0?i[a++]:o[u++]}for(;a<i.length;)n[s++]=i[a++];for(;u<o.length;)n[s++]=o[u++];return n}(n,function(e,n){var t=e.range.start.line-n.range.start.line;return 0===t?e.range.start.character-n.range.start.character:t}),i=t.length,o=r.length-1;0<=o;o--){var a=r[o],u=e.offsetAt(a.range.start),s=e.offsetAt(a.range.end);if(!(s<=i))throw new Error("Ovelapping edit");t=t.substring(0,u)+a.newText+t.substring(s,t.length),i=u}return t},(X=n.TextDocumentSaveReason||(n.TextDocumentSaveReason={})).Manual=1,X.AfterDelay=2,X.FocusOut=3;var Z,ee,ne,te=function(){function e(e,n,t,r){this._uri=e,this._languageId=n,this._version=t,this._content=r,this._lineOffsets=null}return Object.defineProperty(e.prototype,"uri",{get:function(){return this._uri},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"languageId",{get:function(){return this._languageId},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"version",{get:function(){return this._version},enumerable:!0,configurable:!0}),e.prototype.getText=function(e){if(e){var n=this.offsetAt(e.start),t=this.offsetAt(e.end);return this._content.substring(n,t)}return this._content},e.prototype.update=function(e,n){this._content=e.text,this._version=n,this._lineOffsets=null},e.prototype.getLineOffsets=function(){if(null===this._lineOffsets){for(var e=[],n=this._content,t=!0,r=0;r<n.length;r++){t&&(e.push(r),t=!1);var i=n.charAt(r);t="\r"===i||"\n"===i,"\r"===i&&r+1<n.length&&"\n"===n.charAt(r+1)&&r++}t&&0<n.length&&e.push(n.length),this._lineOffsets=e}return this._lineOffsets},e.prototype.positionAt=function(e){e=Math.max(Math.min(e,this._content.length),0);var n=this.getLineOffsets(),t=0,r=n.length;if(0===r)return a.create(0,e);for(;t<r;){var i=Math.floor((t+r)/2);n[i]>e?r=i:t=i+1}var o=t-1;return a.create(o,e-n[o])},e.prototype.offsetAt=function(e){var n=this.getLineOffsets();if(e.line>=n.length)return this._content.length;if(e.line<0)return 0;var t=n[e.line],r=e.line+1<n.length?n[e.line+1]:this._content.length;return Math.max(Math.min(t+e.character,r),t)},Object.defineProperty(e.prototype,"lineCount",{get:function(){return this.getLineOffsets().length},enumerable:!0,configurable:!0}),e}();ee=Z||(Z={}),ne=Object.prototype.toString,ee.defined=function(e){return void 0!==e},ee.undefined=function(e){return void 0===e},ee.boolean=function(e){return!0===e||!1===e},ee.string=function(e){return"[object String]"===ne.call(e)},ee.number=function(e){return"[object Number]"===ne.call(e)},ee.func=function(e){return"[object Function]"===ne.call(e)},ee.objectLiteral=function(e){return null!==e&&"object"==typeof e},ee.typedArray=function(e,n){return Array.isArray(e)&&e.every(n)}}),define("vscode-languageserver-types",["vscode-languageserver-types/main"],function(e){return e}),define("vs/language/css/languageFeatures",["require","exports","vscode-languageserver-types"],function(e,n,o){"use strict";Object.defineProperty(n,"__esModule",{value:!0});var u=monaco.Uri,t=function(){function e(e,n,t){var r=this;this._languageId=e,this._worker=n,this._disposables=[],this._listener=Object.create(null);var i=function(e){var n,t=e.getModeId();t===r._languageId&&(r._listener[e.uri.toString()]=e.onDidChangeContent(function(){clearTimeout(n),n=setTimeout(function(){return r._doValidate(e.uri,t)},500)}),r._doValidate(e.uri,t))},o=function(e){monaco.editor.setModelMarkers(e,r._languageId,[]);var n=e.uri.toString(),t=r._listener[n];t&&(t.dispose(),delete r._listener[n])};this._disposables.push(monaco.editor.onDidCreateModel(i)),this._disposables.push(monaco.editor.onWillDisposeModel(o)),this._disposables.push(monaco.editor.onDidChangeModelLanguage(function(e){o(e.model),i(e.model)})),t.onDidChange(function(e){monaco.editor.getModels().forEach(function(e){e.getModeId()===r._languageId&&(o(e),i(e))})}),this._disposables.push({dispose:function(){for(var e in r._listener)r._listener[e].dispose()}}),monaco.editor.getModels().forEach(i)}return e.prototype.dispose=function(){this._disposables.forEach(function(e){return e&&e.dispose()}),this._disposables=[]},e.prototype._doValidate=function(r,i){this._worker(r).then(function(e){return e.doValidation(r.toString())}).then(function(e){var n=e.map(function(e){return t="number"==typeof(n=e).code?String(n.code):n.code,{severity:function(e){switch(e){case o.DiagnosticSeverity.Error:return monaco.MarkerSeverity.Error;case o.DiagnosticSeverity.Warning:return monaco.MarkerSeverity.Warning;case o.DiagnosticSeverity.Information:return monaco.MarkerSeverity.Info;case o.DiagnosticSeverity.Hint:return monaco.MarkerSeverity.Hint;default:return monaco.MarkerSeverity.Info}}(n.severity),startLineNumber:n.range.start.line+1,startColumn:n.range.start.character+1,endLineNumber:n.range.end.line+1,endColumn:n.range.end.character+1,message:n.message,code:t,source:n.source};var n,t}),t=monaco.editor.getModel(r);t.getModeId()===i&&monaco.editor.setModelMarkers(t,i,n)}).done(void 0,function(e){console.error(e)})},e}();function a(e){if(e)return{character:e.column-1,line:e.lineNumber-1}}function s(e){if(e)return new monaco.Range(e.start.line+1,e.start.character+1,e.end.line+1,e.end.character+1)}function i(e){if(e)return{range:s(e.range),text:e.newText}}n.DiagnosticsAdapter=t;var r=function(){function e(e){this._worker=e}return Object.defineProperty(e.prototype,"triggerCharacters",{get:function(){return[" ",":"]},enumerable:!0,configurable:!0}),e.prototype.provideCompletionItems=function(e,n,t){e.getWordUntilPosition(n);var r=e.uri;return b(t,this._worker(r).then(function(e){return e.doComplete(r.toString(),a(n))}).then(function(e){if(e){var n=e.items.map(function(e){var n={label:e.label,insertText:e.insertText,sortText:e.sortText,filterText:e.filterText,documentation:e.documentation,detail:e.detail,kind:function(e){var n=monaco.languages.CompletionItemKind;switch(e){case o.CompletionItemKind.Text:return n.Text;case o.CompletionItemKind.Method:return n.Method;case o.CompletionItemKind.Function:return n.Function;case o.CompletionItemKind.Constructor:return n.Constructor;case o.CompletionItemKind.Field:return n.Field;case o.CompletionItemKind.Variable:return n.Variable;case o.CompletionItemKind.Class:return n.Class;case o.CompletionItemKind.Interface:return n.Interface;case o.CompletionItemKind.Module:return n.Module;case o.CompletionItemKind.Property:return n.Property;case o.CompletionItemKind.Unit:return n.Unit;case o.CompletionItemKind.Value:return n.Value;case o.CompletionItemKind.Enum:return n.Enum;case o.CompletionItemKind.Keyword:return n.Keyword;case o.CompletionItemKind.Snippet:return n.Snippet;case o.CompletionItemKind.Color:return n.Color;case o.CompletionItemKind.File:return n.File;case o.CompletionItemKind.Reference:return n.Reference}return n.Property}(e.kind)};return e.textEdit&&(n.range=s(e.textEdit.range),n.insertText=e.textEdit.newText),e.additionalTextEdits&&(n.additionalTextEdits=e.additionalTextEdits.map(i)),e.insertTextFormat===o.InsertTextFormat.Snippet&&(n.insertText={value:n.insertText}),n});return{isIncomplete:e.isIncomplete,items:n}}}))},e}();function c(e){return"string"==typeof e?{value:e}:(n=e)&&"object"==typeof n&&"string"==typeof n.kind?"plaintext"===e.kind?{value:e.value.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")}:{value:e.value}:{value:"```"+e.language+"\n"+e.value+"\n```\n"};var n}n.CompletionAdapter=r;var d=function(){function e(e){this._worker=e}return e.prototype.provideHover=function(e,n,t){var r=e.uri;return b(t,this._worker(r).then(function(e){return e.doHover(r.toString(),a(n))}).then(function(e){if(e)return{range:s(e.range),contents:function(e){if(e)return Array.isArray(e)?e.map(c):[c(e)]}(e.contents)}}))},e}();n.HoverAdapter=d;var l=function(){function e(e){this._worker=e}return e.prototype.provideDocumentHighlights=function(e,n,t){var r=e.uri;return b(t,this._worker(r).then(function(e){return e.findDocumentHighlights(r.toString(),a(n))}).then(function(e){if(e)return e.map(function(e){return{range:s(e.range),kind:function(e){switch(e){case o.DocumentHighlightKind.Read:return monaco.languages.DocumentHighlightKind.Read;case o.DocumentHighlightKind.Write:return monaco.languages.DocumentHighlightKind.Write;case o.DocumentHighlightKind.Text:return monaco.languages.DocumentHighlightKind.Text}return monaco.languages.DocumentHighlightKind.Text}(e.kind)}})}))},e}();function g(e){return{uri:u.parse(e.uri),range:s(e.range)}}n.DocumentHighlightAdapter=l;var f=function(){function e(e){this._worker=e}return e.prototype.provideDefinition=function(e,n,t){var r=e.uri;return b(t,this._worker(r).then(function(e){return e.findDefinition(r.toString(),a(n))}).then(function(e){if(e)return[g(e)]}))},e}();n.DefinitionAdapter=f;var m=function(){function e(e){this._worker=e}return e.prototype.provideReferences=function(e,n,t,r){var i=e.uri;return b(r,this._worker(i).then(function(e){return e.findReferences(i.toString(),a(n))}).then(function(e){if(e)return e.map(g)}))},e}();n.ReferenceAdapter=m;var p=function(){function e(e){this._worker=e}return e.prototype.provideRenameEdits=function(e,n,t,r){var i=e.uri;return b(r,this._worker(i).then(function(e){return e.doRename(i.toString(),a(n),t)}).then(function(e){return function(e){if(e&&e.changes){var n=[];for(var t in e.changes){for(var r=[],i=0,o=e.changes[t];i<o.length;i++){var a=o[i];r.push({range:s(a.range),text:a.newText})}n.push({resource:u.parse(t),edits:r})}return{edits:n}}}(e)}))},e}();n.RenameAdapter=p;var h=function(){function e(e){this._worker=e}return e.prototype.provideDocumentSymbols=function(e,n){var t=e.uri;return b(n,this._worker(t).then(function(e){return e.findDocumentSymbols(t.toString())}).then(function(e){if(e)return e.map(function(e){return{name:e.name,detail:"",containerName:e.containerName,kind:function(e){var n=monaco.languages.SymbolKind;switch(e){case o.SymbolKind.File:return n.Array;case o.SymbolKind.Module:return n.Module;case o.SymbolKind.Namespace:return n.Namespace;case o.SymbolKind.Package:return n.Package;case o.SymbolKind.Class:return n.Class;case o.SymbolKind.Method:return n.Method;case o.SymbolKind.Property:return n.Property;case o.SymbolKind.Field:return n.Field;case o.SymbolKind.Constructor:return n.Constructor;case o.SymbolKind.Enum:return n.Enum;case o.SymbolKind.Interface:return n.Interface;case o.SymbolKind.Function:return n.Function;case o.SymbolKind.Variable:return n.Variable;case o.SymbolKind.Constant:return n.Constant;case o.SymbolKind.String:return n.String;case o.SymbolKind.Number:return n.Number;case o.SymbolKind.Boolean:return n.Boolean;case o.SymbolKind.Array:return n.Array}return n.Function}(e.kind),range:s(e.location.range),selectionRange:s(e.location.range)}})}))},e}();n.DocumentSymbolAdapter=h;var v=function(){function e(e){this._worker=e}return e.prototype.provideDocumentColors=function(e,n){var t=e.uri;return b(n,this._worker(t).then(function(e){return e.findDocumentColors(t.toString())}).then(function(e){if(e)return e.map(function(e){return{color:e.color,range:s(e.range)}})}))},e.prototype.provideColorPresentations=function(e,n,t){var r=e.uri;return b(t,this._worker(r).then(function(e){return e.getColorPresentations(r.toString(),n.color,function(e){if(e)return{start:{line:e.startLineNumber-1,character:e.startColumn-1},end:{line:e.endLineNumber-1,character:e.endColumn-1}}}(n.range))}).then(function(e){if(e)return e.map(function(e){var n={label:e.label};return e.textEdit&&(n.textEdit=i(e.textEdit)),e.additionalTextEdits&&(n.additionalTextEdits=e.additionalTextEdits.map(i)),n})}))},e}();n.DocumentColorAdapter=v;var y=function(){function e(e){this._worker=e}return e.prototype.provideFoldingRanges=function(e,n,t){var r=e.uri;return b(t,this._worker(r).then(function(e){return e.provideFoldingRanges(r.toString(),n)}).then(function(e){if(e)return e.map(function(e){var n={start:e.startLine+1,end:e.endLine+1};return void 0!==e.kind&&(n.kind=function(e){switch(e){case o.FoldingRangeKind.Comment:return monaco.languages.FoldingRangeKind.Comment;case o.FoldingRangeKind.Imports:return monaco.languages.FoldingRangeKind.Imports;case o.FoldingRangeKind.Region:return monaco.languages.FoldingRangeKind.Region}return}(e.kind)),n})}))},e}();function b(e,n){return e.onCancellationRequested(function(){return n.cancel()}),n}n.FoldingRangeAdapter=y}),define("vs/language/css/cssMode",["require","exports","./workerManager","./languageFeatures"],function(e,n,i,o){"use strict";Object.defineProperty(n,"__esModule",{value:!0}),n.setupMode=function(e){var r=new i.WorkerManager(e),n=function(e){for(var n=[],t=1;t<arguments.length;t++)n[t-1]=arguments[t];return r.getLanguageServiceWorker.apply(r,[e].concat(n))},t=e.languageId;monaco.languages.registerCompletionItemProvider(t,new o.CompletionAdapter(n)),monaco.languages.registerHoverProvider(t,new o.HoverAdapter(n)),monaco.languages.registerDocumentHighlightProvider(t,new o.DocumentHighlightAdapter(n)),monaco.languages.registerDefinitionProvider(t,new o.DefinitionAdapter(n)),monaco.languages.registerReferenceProvider(t,new o.ReferenceAdapter(n)),monaco.languages.registerDocumentSymbolProvider(t,new o.DocumentSymbolAdapter(n)),monaco.languages.registerRenameProvider(t,new o.RenameAdapter(n)),monaco.languages.registerColorProvider(t,new o.DocumentColorAdapter(n)),monaco.languages.registerFoldingRangeProvider(t,new o.FoldingRangeAdapter(n)),new o.DiagnosticsAdapter(t,n,e)}});