/***

MochiKit.Visual 1.4.2

See <http://mochikit.com/> for documentation, downloads, license, etc.

(c) 2005 Bob Ippolito and others.  All rights Reserved.

***/

MochiKit.Base._deps('Visual', ['Base', 'DOM', 'Style', 'Color', 'Position']);

MochiKit.Visual.NAME = "MochiKit.Visual";
MochiKit.Visual.VERSION = "1.4.2";

MochiKit.Visual.__repr__ = function () {
    return "[" + this.NAME + " " + this.VERSION + "]";
};

MochiKit.Visual.toString = function () {
    return this.__repr__();
};

MochiKit.Visual._RoundCorners = function (e, options) {
    e = MochiKit.DOM.getElement(e);
    this._setOptions(options);
    if (this.options.__unstable__wrapElement) {
        e = this._doWrap(e);
    }

    var color = this.options.color;
    var C = MochiKit.Color.Color;
    if (this.options.color === "fromElement") {
        color = C.fromBackground(e);
    } else if (!(color instanceof C)) {
        color = C.fromString(color);
    }
    this.isTransparent = (color.asRGB().a <= 0);

    var bgColor = this.options.bgColor;
    if (this.options.bgColor === "fromParent") {
        bgColor = C.fromBackground(e.offsetParent);
    } else if (!(bgColor instanceof C)) {
        bgColor = C.fromString(bgColor);
    }

    this._roundCornersImpl(e, color, bgColor);
};

MochiKit.Visual._RoundCorners.prototype = {
    _doWrap: function (e) {
        var parent = e.parentNode;
        var doc = MochiKit.DOM.currentDocument();
        if (typeof(doc.defaultView) === "undefined"
            || doc.defaultView === null) {
            return e;
        }
        var style = doc.defaultView.getComputedStyle(e, null);
        if (typeof(style) === "undefined" || style === null) {
            return e;
        }
        var wrapper = MochiKit.DOM.DIV({"style": {
            display: "block",
            // convert padding to margin
            marginTop: style.getPropertyValue("padding-top"),
            marginRight: style.getPropertyValue("padding-right"),
            marginBottom: style.getPropertyValue("padding-bottom"),
            marginLeft: style.getPropertyValue("padding-left"),
            // remove padding so the rounding looks right
            padding: "0px"
            /*
            paddingRight: "0px",
            paddingLeft: "0px"
            */
        }});
        wrapper.innerHTML = e.innerHTML;
        e.innerHTML = "";
        e.appendChild(wrapper);
        return e;
    },

    _roundCornersImpl: function (e, color, bgColor) {
        if (this.options.border) {
            this._renderBorder(e, bgColor);
        }
        if (this._isTopRounded()) {
            this._roundTopCorners(e, color, bgColor);
        }
        if (this._isBottomRounded()) {
            this._roundBottomCorners(e, color, bgColor);
        }
    },

    _renderBorder: function (el, bgColor) {
        var borderValue = "1px solid " + this._borderColor(bgColor);
        var borderL = "border-left: "  + borderValue;
        var borderR = "border-right: " + borderValue;
        var style = "style='" + borderL + ";" + borderR +  "'";
        el.innerHTML = "<div " + style + ">" + el.innerHTML + "</div>";
    },

    _roundTopCorners: function (el, color, bgColor) {
        var corner = this._createCorner(bgColor);
        for (var i = 0; i < this.options.numSlices; i++) {
            corner.appendChild(
                this._createCornerSlice(color, bgColor, i, "top")
            );
        }
        el.style.paddingTop = 0;
        el.insertBefore(corner, el.firstChild);
    },

    _roundBottomCorners: function (el, color, bgColor) {
        var corner = this._createCorner(bgColor);
        for (var i = (this.options.numSlices - 1); i >= 0; i--) {
            corner.appendChild(
                this._createCornerSlice(color, bgColor, i, "bottom")
            );
        }
        el.style.paddingBottom = 0;
        el.appendChild(corner);
    },

    _createCorner: function (bgColor) {
        var dom = MochiKit.DOM;
        return dom.DIV({style: {backgroundColor: bgColor.toString()}});
    },

    _createCornerSlice: function (color, bgColor, n, position) {
        var slice = MochiKit.DOM.SPAN();

        var inStyle = slice.style;
        inStyle.backgroundColor = color.toString();
        inStyle.display = "block";
        inStyle.height = "1px";
        inStyle.overflow = "hidden";
        inStyle.fontSize = "1px";

        var borderColor = this._borderColor(color, bgColor);
        if (this.options.border && n === 0) {
            inStyle.borderTopStyle = "solid";
            inStyle.borderTopWidth = "1px";
            inStyle.borderLeftWidth = "0px";
            inStyle.borderRightWidth = "0px";
            inStyle.borderBottomWidth = "0px";
            // assumes css compliant box model
            inStyle.height = "0px";
            inStyle.borderColor = borderColor.toString();
        } else if (borderColor) {
            inStyle.borderColor = borderColor.toString();
            inStyle.borderStyle = "solid";
            inStyle.borderWidth = "0px 1px";
        }

        if (!this.options.compact && (n == (this.options.numSlices - 1))) {
            inStyle.height = "2px";
        }

        this._setMargin(slice, n, position);
        this._setBorder(slice, n, position);

        return slice;
    },

    _setOptions: function (options) {
        this.options = {
            corners: "all",
            color: "fromElement",
            bgColor: "fromParent",
            blend: true,
            border: false,
            compact: false,
            __unstable__wrapElement: false
        };
        MochiKit.Base.update(this.options, options);

        this.options.numSlices = (this.options.compact ? 2 : 4);
    },

    _whichSideTop: function () {
        var corners = this.options.corners;
        if (this._hasString(corners, "all", "top")) {
            return "";
        }

        var has_tl = (corners.indexOf("tl") != -1);
        var has_tr = (corners.indexOf("tr") != -1);
        if (has_tl && has_tr) {
            return "";
        }
        if (has_tl) {
            return "left";
        }
        if (has_tr) {
            return "right";
        }
        return "";
    },

    _whichSideBottom: function () {
        var corners = this.options.corners;
        if (this._hasString(corners, "all", "bottom")) {
            return "";
        }

        var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var has_b    var has_bl = (corners.indexOf('bl') != -1);
        var                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           