#! /usr/lib/rads/venv/bin/python3
"""Subclass for MediaWiki CMS"""
# Author: Daniel K

import os
import logging
from typing import TYPE_CHECKING
from ..cms import CMS
from ..cms import VariableData

if TYPE_CHECKING:
    from ..cms import CMSFind

LOGGER = logging.getLogger(__name__)


class MediaWiki(CMS):
    '''
    Class for MediaWiki installations
    '''

    def setup(self):

        self.type = 'MediaWiki'

        self.config = os.path.join(self.directory_root, 'LocalSettings.php')

        self.db_name_data = VariableData(
            'php_variable', 'wgDBname', self.config
        )
        self.db_user_data = VariableData(
            'php_variable', 'wgDBuser', self.config
        )
        self.db_pass_data = VariableData(
            'php_variable', 'wgDBpassword', self.config
        )
        self.db_pref_data = VariableData(
            'php_variable', 'wgDBprefix', self.config
        )
        self.db_host_data = VariableData(
            'php_variable', 'wgDBserver', self.config
        )

        self.cms_directories = [
            "mw-config",
            "skins",
            "serialized",
            "resources",
            "includes",
            "docs",
            "languages",
            "extensions",
            "images",
            "maintenance",
        ]

        self.siteurl = VariableData(
            'php_variable', 'wgServer', self.config
        ).get_value()

        return True


def register_cms(cms_find_instance: 'CMSFind'):
    '''
    Register self with current cms_find_instance
    '''

    cms_find_instance.add_quick("MediaWiki", MediaWiki)
