#
# Table structure for table `[[db_prefix]]banner`
#

CREATE TABLE `[[db_prefix]]banner` (
  `bid` int(11) NOT NULL auto_increment,
  `cid` int(11) NOT NULL default '0',
  `type` varchar(10) NOT NULL default 'banner',
  `name` varchar(50) NOT NULL default '',
  `imptotal` int(11) NOT NULL default '0',
  `impmade` int(11) NOT NULL default '0',
  `clicks` int(11) NOT NULL default '0',
  `imageurl` varchar(100) NOT NULL default '',
  `clickurl` varchar(200) NOT NULL default '',
  `date` datetime default NULL,
  `showBanner` tinyint(1) NOT NULL default '0',
  `checked_out` tinyint(1) NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `editor` varchar(50) default NULL,
  `custombannercode` text,
  PRIMARY KEY  (`bid`),
  KEY `viewbanner` (`showBanner`)
) ENGINE=MyISAM AUTO_INCREMENT=1 ;

#
# Table structure for table `[[db_prefix]]bannerclient`
#

CREATE TABLE `[[db_prefix]]bannerclient` (
  `cid` int(11) NOT NULL auto_increment,
  `name` varchar(60) NOT NULL default '',
  `contact` varchar(60) NOT NULL default '',
  `email` varchar(60) NOT NULL default '',
  `extrainfo` text NOT NULL,
  `checked_out` tinyint(1) NOT NULL default '0',
  `checked_out_time` time default NULL,
  `editor` varchar(50) default NULL,
  PRIMARY KEY  (`cid`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]bannerfinish`
#

CREATE TABLE `[[db_prefix]]bannerfinish` (
  `bid` int(11) NOT NULL auto_increment,
  `cid` int(11) NOT NULL default '0',
  `type` varchar(10) NOT NULL default '',
  `name` varchar(50) NOT NULL default '',
  `impressions` int(11) NOT NULL default '0',
  `clicks` int(11) NOT NULL default '0',
  `imageurl` varchar(50) NOT NULL default '',
  `datestart` datetime default NULL,
  `dateend` datetime default NULL,
  PRIMARY KEY  (`bid`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]categories`
#

CREATE TABLE `[[db_prefix]]categories` (
  `id` int(11) NOT NULL auto_increment,
  `parent_id` int(11) NOT NULL default 0,
  `title` varchar(50) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  `image` varchar(100) NOT NULL default '',
  `section` varchar(50) NOT NULL default '',
  `image_position` varchar(10) NOT NULL default '',
  `description` text NOT NULL,
  `published` tinyint(1) NOT NULL default '0',
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `editor` varchar(50) default NULL,
  `ordering` int(11) NOT NULL default '0',
  `access` tinyint(3) unsigned NOT NULL default '0',
  `count` int(11) NOT NULL default '0',
  `params` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `cat_idx` (`section`,`published`,`access`),
  KEY `idx_section` (`section`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]comment`
#

CREATE TABLE `[[db_prefix]]comment` (
  `id` int(11) NOT NULL auto_increment,
  `articleid` int(11) NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  `name` varchar(30) NOT NULL default '',
  `comments` text NOT NULL default '',
  `startdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]components`
#

CREATE TABLE `[[db_prefix]]components` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `link` varchar(255) NOT NULL default '',
  `menuid` int(11) unsigned NOT NULL default '0',
  `parent` int(11) unsigned NOT NULL default '0',
  `admin_menu_link` varchar(255) NOT NULL default '',
  `admin_menu_alt` varchar(255) NOT NULL default '',
  `option` varchar(50) NOT NULL default '',
  `ordering` int(11) NOT NULL default '0',
  `admin_menu_img` varchar(255) NOT NULL default '',
  `iscore` tinyint(4) NOT NULL default '0',
  `params` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

#
# Dumping data for table `[[db_prefix]]components`
#

INSERT INTO `[[db_prefix]]components` VALUES (1, 'Banners', '', 0, 0, '', 'Banner Management', 'com_banners', 0, 'js/ThemeOffice/component.png', 0, '');
INSERT INTO `[[db_prefix]]components` VALUES (2, 'Manage Banners', '', 0, 1, 'option=com_banners', 'Manage Banners', 'com_banners', 1, 'js/ThemeOffice/edit.png', 0, '');
INSERT INTO `[[db_prefix]]components` VALUES (3, 'Manage Clients', '', 0, 1, 'option=com_banners&task=listclients', 'Manage Clients', 'com_banners', 2, 'js/ThemeOffice/categories.png', 0, '');
INSERT INTO `[[db_prefix]]components` VALUES (4, 'Web Links', 'option=com_weblinks', 0, 0, '', 'Manage Web Links', 'com_weblinks', 0, 'js/ThemeOffice/globe2.png', 0, '');
INSERT INTO `[[db_prefix]]components` VALUES (5, 'Manage Items', '', 0, 4, 'option=com_weblinks', 'Manage Web Links', 'com_weblinks', 1, 'js/ThemeOffice/edit.png', 0, '');
INSERT INTO `[[db_prefix]]components` VALUES (6, 'Manage Categories', '', 0, 4, 'option=com_categories&section=com_weblinks', 'Manage Web Link Categories', '', 2, 'js/ThemeOffice/categories.png', 0, '');
INSERT INTO `[[db_prefix]]components` VALUES (7, 'Contacts', 'option=com_contact', 0, 0, '', 'Manage Contacts', 'com_contact', 0, 'js/ThemeOffice/user.png', 1, '');
INSERT INTO `[[db_prefix]]components` VALUES (8, 'Manage Items', '', 0, 7, 'option=com_contact', 'Manage Contacts', 'com_contact', 0, 'js/ThemeOffice/edit.png', 1, '');
INSERT INTO `[[db_prefix]]components` VALUES (9, 'Manage Categories', '', 0, 7, 'option=categories&section=com_contact_details', 'Manage Contact Categories', '', 2, 'js/ThemeOffice/categories.png', 1, '');
INSERT INTO `[[db_prefix]]components` VALUES (10, 'FrontPage', 'option=com_frontpage', 0, 0, '', 'Manage Front Page Items', 'com_frontpage', 0, 'js/ThemeOffice/component.png', 1, '');
INSERT INTO `[[db_prefix]]components` VALUES (11, 'Polls', 'option=com_poll', 0, 0, 'option=com_poll', 'Manage Polls', 'com_poll', 0, 'js/ThemeOffice/component.png', 0, '');
INSERT INTO `[[db_prefix]]components` VALUES (12, 'News Feeds', 'option=com_newsfeeds', 0, 0, '', 'Manage News Feeds', 'com_newsfeeds', 0, 'js/ThemeOffice/component.png', 0, '');
INSERT INTO `[[db_prefix]]components` VALUES (13, 'Manage Items', '', 0, 12, 'option=com_newsfeeds', 'Manage News Feeds', 'com_newsfeeds', 1, 'js/ThemeOffice/edit.png', 0, '');
INSERT INTO `[[db_prefix]]components` VALUES (14, 'Manage Categories', '', 0, 12, 'option=com_categories&section=com_newsfeeds', 'Manage News Feeds Categories', '', 2, 'js/ThemeOffice/categories.png', 0, '');
INSERT INTO `[[db_prefix]]components` VALUES (15, 'Login', 'option=com_login', 0, 0, '', '', 'com_login', 0, '', 1, '');
INSERT INTO `[[db_prefix]]components` VALUES (16, 'Search', 'option=com_search', 0, 0, '', '', 'com_search', 0, '', 1, '');
INSERT INTO `[[db_prefix]]components` VALUES (17, 'Syndicate','',0,0,'option=com_syndicate&hidemainmenu=1','Manage Syndication Settings','com_syndicate',0,'js/ThemeOffice/component.png',0,'');
INSERT INTO `[[db_prefix]]components` VALUES (18, 'Mass Mail', '', 0, 0, 'option=com_massmail&hidemainmenu=1', 'Send Mass Mail', 'com_massmail', 0, 'js/ThemeOffice/mass_email.png', 0, '');
INSERT INTO `[[db_prefix]]components` VALUES (19, 'MOStlyCE Admin', 'option=com_mostlyce', 0, 0, 'option=com_mostlyce', 'MOStlyCE Admin', 'com_mostlyce', 0, 'js/ThemeOffice/component.png', 0, '');
#INSERT INTO `[[db_prefix]]components` VALUES (20, 'Mambo Containers', 'option=com_containers', 0, 0, 'option=com_containers', 'Mambo Containers', 'com_containers', 0, 'js/ThemeOffice/component.png', 0, '');
INSERT INTO `[[db_prefix]]components` VALUES (21, 'MOStlyDBAdmin DB Tools', 'option=com_mostlydbadmin', 0, 0, 'option=com_mostlydbadmin', 'MOStlyDBAdmin DB Tools', 'com_mostlydbadmin', 0, 'js/ThemeOffice/component.png', 0, '');
INSERT INTO `[[db_prefix]]components` VALUES (22, 'Backup Database', '', 0, 21, 'option=com_mostlydbadmin&act=option=com_mostlydbadmin&task=dbBackup', 'Backup Database', 'com_mostlydbadmin', 0, 'js/ThemeOffice/component.png', 0, '');
INSERT INTO `[[db_prefix]]components` VALUES (23, 'Restore Database', '', 0, 21, 'option=com_mostlydbadmin&act=option=com_mostlydbadmin&task=dbRestore', 'Restore Database', 'com_mostlydbadmin', 1, 'js/ThemeOffice/component.png', 0, '');
INSERT INTO `[[db_prefix]]components` VALUES (24, 'Query Database', '', 0, 21, 'option=com_mostlydbadmin&act=option=com_mostlydbadmin&task=xquery', 'Query Database', 'com_mostlydbadmin', 2, 'js/ThemeOffice/component.png', 0, '');
INSERT INTO `[[db_prefix]]components` VALUES (25,'Comment','option=com_comment',0,0,'option=com_comment','Comment','com_comment',0,'js/ThemeOffice/mainmenu.png',0,'');
INSERT INTO `[[db_prefix]]components` VALUES (26,'View Comments','',0,25,'option=com_comment&task=comments','View Comments','com_comment',0,'js/ThemeOffice/edit.png',0,'');
INSERT INTO `[[db_prefix]]components` VALUES (27,'Edit Settings','',0,25,'option=com_comment&task=settings','Edit Settings','com_comment',1,'js/ThemeOffice/config.png',0,'');
INSERT INTO `[[db_prefix]]components` VALUES (28,'mostlyce_frontend','',0,0,'','','com_mostlyce_frontend',0,'',0,'');




# --------------------------------------------------------

#
# Table structure for table `[[db_prefix]]contact_details`
#

CREATE TABLE `[[db_prefix]]contact_details` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `con_position` varchar(50) default NULL,
  `address` text,
  `suburb` varchar(50) default NULL,
  `state` varchar(50) default NULL,
  `country` varchar(50) default NULL,
  `postcode` varchar(10) default NULL,
  `telephone` varchar(25) default NULL,
  `fax` varchar(25) default NULL,
  `misc` mediumtext,
  `image` varchar(100) default NULL,
  `imagepos` varchar(20) default NULL,
  `email_to` varchar(100) default NULL,
  `default_con` tinyint(1) unsigned NOT NULL default '0',
  `published` tinyint(1) unsigned NOT NULL default '0',
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL default '0',
  `params` text NOT NULL,
  `user_id` int(11) NOT NULL default '0',
  `catid` int(11) NOT NULL default '0',
  `access` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]containers`
#

CREATE TABLE `[[db_prefix]]containers` (
  `id` int(11) NOT NULL auto_increment,
  `parentid` int(11) NOT NULL default '0',
  `ordering` int(11) NOT NULL default '0',
  `published` smallint(6) NOT NULL default '0',
  `childcount` int(11) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `title` varchar(100) NOT NULL default '',
  `windowtitle` varchar(50) NOT NULL default '',
  `keywords` varchar(255) NOT NULL default '',
  `icon` varchar(25) NOT NULL default '',
  `description` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;


#
# Table structure for table `[[db_prefix]]content`
#

CREATE TABLE `[[db_prefix]]content` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `title_alias` varchar(100) NOT NULL default '',
  `introtext` mediumtext NOT NULL,
  `fulltext` mediumtext NOT NULL,
  `state` tinyint(3) NOT NULL default '0',
  `sectionid` int(11) unsigned NOT NULL default '0',
  `mask` int(11) unsigned NOT NULL default '0',
  `catid` int(11) unsigned NOT NULL default '0',
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  `created_by` int(11) unsigned NOT NULL default '0',
  `created_by_alias` varchar(100) NOT NULL default '',
  `modified` datetime NOT NULL default '0000-00-00 00:00:00',
  `modified_by` int(11) unsigned NOT NULL default '0',
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL default '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL default '0000-00-00 00:00:00',
  `images` text NOT NULL,
  `urls` text NOT NULL,
  `attribs` text NOT NULL,
  `version` int(11) unsigned NOT NULL default '1',
  `parentid` int(11) unsigned NOT NULL default '0',
  `ordering` int(11) NOT NULL default '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `access` int(11) unsigned NOT NULL default '0',
  `hits` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `idx_section` (`sectionid`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_mask` (`mask`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]content_frontpage`
#

CREATE TABLE `[[db_prefix]]content_frontpage` (
  `content_id` int(11) NOT NULL default '0',
  `ordering` int(11) NOT NULL default '0',
  PRIMARY KEY  (`content_id`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]content_rating`
#

CREATE TABLE `[[db_prefix]]content_rating` (
  `content_id` int(11) NOT NULL default '0',
  `rating_sum` int(11) unsigned NOT NULL default '0',
  `rating_count` int(11) unsigned NOT NULL default '0',
  `lastip` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`content_id`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]core_log_items`
#
# To be implemented in Version 4.6

CREATE TABLE `[[db_prefix]]core_log_items` (
  `time_stamp` date NOT NULL default '0000-00-00',
  `item_table` varchar(50) NOT NULL default '',
  `item_id` int(11) unsigned NOT NULL default '0',
  `hits` int(11) unsigned NOT NULL default '0'
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]core_log_searches`
#
# To be implemented in Version 4.6

CREATE TABLE `[[db_prefix]]core_log_searches` (
  `search_term` varchar(128) NOT NULL default '',
  `hits` int(11) unsigned NOT NULL default '0'
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]groups`
#

CREATE TABLE `[[db_prefix]]groups` (
  `id` tinyint(3) unsigned NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

#
# Dumping data for table `[[db_prefix]]groups`
#

INSERT INTO `[[db_prefix]]groups` VALUES (0, 'Public');
INSERT INTO `[[db_prefix]]groups` VALUES (1, 'Registered');
INSERT INTO `[[db_prefix]]groups` VALUES (2, 'Special');
# --------------------------------------------------------

#
# Table structure for table `[[db_prefix]]mambots`
#

CREATE TABLE `[[db_prefix]]mambots` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `element` varchar(100) NOT NULL default '',
  `folder` varchar(100) NOT NULL default '',
  `access` tinyint(3) unsigned NOT NULL default '0',
  `ordering` int(11) NOT NULL default '0',
  `published` tinyint(3) NOT NULL default '0',
  `iscore` tinyint(3) NOT NULL default '0',
  `client_id` tinyint(3) NOT NULL default '0',
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `params` text,
  PRIMARY KEY  (`id`),
  KEY `idx_folder` (`published`,`client_id`,`access`,`folder`)
) ENGINE=MyISAM;

INSERT INTO `[[db_prefix]]mambots` VALUES (1,'MOS Image','mosimage','content',0,-10000,1,1,0,0,'0000-00-00 00:00:00','');
INSERT INTO `[[db_prefix]]mambots` VALUES (2,'MOS Pagination','mospaging','content',0,10000,1,1,0,0,'0000-00-00 00:00:00','');
INSERT INTO `[[db_prefix]]mambots` VALUES (3,'Legacy Mambot Includer','legacybots','content',0,1,0,1,0,0,'0000-00-00 00:00:00','');
INSERT INTO `[[db_prefix]]mambots` VALUES (4,'SEF','mossef','content',0,3,1,0,0,0,'0000-00-00 00:00:00','');
INSERT INTO `[[db_prefix]]mambots` VALUES (5,'MOS Rating','mosvote','content',0,4,1,1,0,0,'0000-00-00 00:00:00','');
INSERT INTO `[[db_prefix]]mambots` VALUES (6,'Search Content','content.searchbot','search',0,1,1,1,0,0,'0000-00-00 00:00:00','');
INSERT INTO `[[db_prefix]]mambots` VALUES (7,'Search Web Links','weblinks.searchbot','search',0,2,1,1,0,0,'0000-00-00 00:00:00','');
INSERT INTO `[[db_prefix]]mambots` VALUES (8,'Code support','moscode','content',0,2,0,0,0,0,'0000-00-00 00:00:00','');
INSERT INTO `[[db_prefix]]mambots` VALUES (9,'No WYSIWYG Editor','none','editors',0,0,0,1,0,0,'0000-00-00 00:00:00','');
INSERT INTO `[[db_prefix]]mambots` VALUES (11,'MOS Image Editor Button','mosimage.btn','editors-xtd',0,0,1,0,0,0,'0000-00-00 00:00:00','');
INSERT INTO `[[db_prefix]]mambots` VALUES (12,'MOS Pagebreak Editor Button','mospage.btn','editors-xtd',0,0,1,0,0,0,'0000-00-00 00:00:00','');
INSERT INTO `[[db_prefix]]mambots` VALUES (13,'Search Contacts','contacts.searchbot','search',0,3,1,1,0,0,'0000-00-00 00:00:00','');
INSERT INTO `[[db_prefix]]mambots` VALUES (14, 'Search Categories', 'categories.searchbot', 'search', 0, 4, 1, 0, 0, 0, '0000-00-00 00:00:00', '');
INSERT INTO `[[db_prefix]]mambots` VALUES (15, 'Search Sections', 'sections.searchbot', 'search', 0, 5, 1, 0, 0, 0, '0000-00-00 00:00:00', '');
INSERT INTO `[[db_prefix]]mambots` VALUES (16, 'Email Cloaking', 'mosemailcloak', 'content', 0, 5, 1, 0, 0, 0, '0000-00-00 00:00:00', '');
INSERT INTO `[[db_prefix]]mambots` VALUES (17, 'GeSHi', 'geshi', 'content', 0, 5, 0, 0, 0, 0, '0000-00-00 00:00:00', '');
INSERT INTO `[[db_prefix]]mambots` VALUES (18, 'Search Newsfeeds', 'newsfeeds.searchbot', 'search', 0, 6, 1, 0, 0, 0, '0000-00-00 00:00:00', '');
INSERT INTO `[[db_prefix]]mambots` VALUES (19, 'Load Module Positions', 'mosloadposition', 'content', 0, 6, 1, 0, 0, 0, '0000-00-00 00:00:00', '');
INSERT INTO `[[db_prefix]]mambots` VALUES (20, 'MOStlyCE', 'mostlyce', 'editors', 0, 0, 1, 0, 0, 0, '0000-00-00 00:00:00', '');
INSERT INTO `[[db_prefix]]mambots` VALUES (21, 'User Authenticator', 'mosvaliduserbot', 'authenticator', 0, 0, 1, 0, 0, 0, '0000-00-00 00:00:00', '');
INSERT INTO `[[db_prefix]]mambots` VALUES (22, 'MOS Comment','moscomment','content',0,0,1,0,0,0,'0000-00-00 00:00:00','');
# --------------------------------------------------------

#
# Table structure for table `[[db_prefix]]menu`
#

CREATE TABLE `[[db_prefix]]menu` (
  `id` int(11) NOT NULL auto_increment,
  `menutype` varchar(25) default NULL,
  `name` varchar(100) default NULL,
  `link` text,
  `type` varchar(50) NOT NULL default '',
  `published` tinyint(1) NOT NULL default '0',
  `parent` int(11) unsigned NOT NULL default '0',
  `componentid` int(11) unsigned NOT NULL default '0',
  `sublevel` int(11) default '0',
  `ordering` int(11) default '0',
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `pollid` int(11) NOT NULL default '0',
  `browserNav` tinyint(4) default '0',
  `access` tinyint(3) unsigned NOT NULL default '0',
  `utaccess` tinyint(3) unsigned NOT NULL default '0',
  `params` text,
  PRIMARY KEY  (`id`),
  KEY `componentid` (`componentid`,`menutype`,`published`,`access`),
  KEY `menutype` (`menutype`)
) ENGINE=MyISAM;

INSERT INTO `[[db_prefix]]menu` VALUES (1, 'mainmenu', 'Home', 'index.php?option=com_frontpage', 'components', 1, 0, 10, 0, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 3, 'menu_image=-1\npageclass_sfx=\nheader=\npage_title=0\nback_button=\nleading=1\nintro=2\ncolumns=2\nlink=3\norderby_pri=\norderby_sec=front\npagination=2\npagination_results=0\nimage=1\nsection=0\nsection_link=0\ncategory=0\ncategory_link=0\nitem_title=1\nlink_titles=\nreadmore=\nrating=\nauthor=\ncreatedate=\nmodifydate=\npdf=0\nprint=0\nemail=0');
# --------------------------------------------------------

#
# Table structure for table `[[db_prefix]]messages`
#

CREATE TABLE `[[db_prefix]]messages` (
  `message_id` int(10) unsigned NOT NULL auto_increment,
  `user_id_from` int(10) unsigned NOT NULL default '0',
  `user_id_to` int(10) unsigned NOT NULL default '0',
  `folder_id` int(10) unsigned NOT NULL default '0',
  `date_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `state` int(11) NOT NULL default '0',
  `priority` int(1) unsigned NOT NULL default '0',
  `subject` varchar(230) NOT NULL default '',
  `message` text NOT NULL,
  PRIMARY KEY  (`message_id`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]messages_cfg`
#

CREATE TABLE `[[db_prefix]]messages_cfg` (
  `user_id` int(10) unsigned NOT NULL default '0',
  `cfg_name` varchar(100) NOT NULL default '',
  `cfg_value` varchar(255) NOT NULL default '',
  UNIQUE `idx_user_var_name` (`user_id`,`cfg_name`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]modules`
#

CREATE TABLE `[[db_prefix]]modules` (
  `id` int(11) NOT NULL auto_increment,
  `title` text NOT NULL,
  `content` text NOT NULL,
  `ordering` int(11) NOT NULL default '0',
  `position` varchar(10) default NULL,
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL default '0',
  `module` varchar(50) default NULL,
  `numnews` int(11) NOT NULL default '0',
  `access` tinyint(3) unsigned NOT NULL default '0',
  `showtitle` tinyint(3) unsigned NOT NULL default '1',
  `params` text,
  `iscore` tinyint(4) NOT NULL default '0',
  `client_id` tinyint(4) NOT NULL default '0',
  `groups` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`)
) ENGINE=MyISAM;

#
# Dumping data for table `[[db_prefix]]modules`
#

INSERT INTO `[[db_prefix]]modules` VALUES (1, 'Polls', '', 1, 'right', 0, '0000-00-00 00:00:00', 1, 'mod_poll', 0, 0, 1, '', 0, 0, '');
INSERT INTO `[[db_prefix]]modules` VALUES (2, 'User Menu', '', 2, 'left', 0, '0000-00-00 00:00:00', 1, 'mod_mainmenu', 0, 1, 1, 'menutype=usermenu', 1, 0, '');
INSERT INTO `[[db_prefix]]modules` VALUES (3, 'Main Menu', '', 1, 'left', 0, '0000-00-00 00:00:00', 1, 'mod_mainmenu', 0, 0, 0, 'class_sfx=\nmoduleclass_sfx=\nmenutype=mainmenu\nmenu_style=vert_indent\ncache=0\nmenu_images=0\nmenu_images_align=0\nexpand_menu=0\nindent_image=0\nindent_image1=\nindent_image2=\nindent_image3=\nindent_image4=\nindent_image5=\nindent_image6=\nspacer=\nend_spacer=', 1, 0, '');
INSERT INTO `[[db_prefix]]modules` VALUES (4, 'Login Form', '', 4, 'left', 0, '0000-00-00 00:00:00', 1, 'mod_login', 0, 0, 1, '', 1, 0, '');
INSERT INTO `[[db_prefix]]modules` VALUES (5, 'Syndicate', '', 5, 'left', 0, '0000-00-00 00:00:00', 1, 'mod_rssfeed', 0, 0, 1, 'text=\ncache=0\nmoduleclass_sfx=\nrss091=1\nrss10=1\nrss20=1\natom=1\nopml=1\nrss091_image=\nrss10_image=\nrss20_image=\natom_image=\nopml_image=', 1, 0, '');
INSERT INTO `[[db_prefix]]modules` VALUES (6, 'Latest News', '', 1, 'user2', 0, '0000-00-00 00:00:00', 1, 'mod_latestnews', 0, 0, 1, 'moduleclass_sfx=\ncache=0\ntype=1\nshow_front=1\ncount=5\ncatid=\nsecid=', 1, 0, '');
INSERT INTO `[[db_prefix]]modules` VALUES (7, 'Statistics', '', 6, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_stats', 0, 0, 1, 'serverinfo=1\nsiteinfo=1\ncounter=1\nincrease=0\nmoduleclass_sfx=', 0, 0, '');
INSERT INTO `[[db_prefix]]modules` VALUES (8, 'Who''s Online', '', 1, 'right', 0, '0000-00-00 00:00:00', 1, 'mod_whosonline', 0, 0, 1, 'online=1\nusers=1\nmoduleclass_sfx=', 0, 0, '');
INSERT INTO `[[db_prefix]]modules` VALUES (9, 'Popular', '', 1, 'user3', 0, '0000-00-00 00:00:00', 1, 'mod_mostread', 0, 0, 1, 'moduleclass_sfx=\ncache=0\ntype=1\nshow_front=1\ncount=5\ncatid=\nsecid=\nhits=1', 0, 0, '');
INSERT INTO `[[db_prefix]]modules` VALUES (10, 'Template Chooser', '', 7, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_templatechooser', 0, 0, 1, 'show_preview=1', 0, 0, '');
INSERT INTO `[[db_prefix]]modules` VALUES (11, 'Archive', '', 8, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_archive', 0, 0, 1, '', 1, 0, '');
INSERT INTO `[[db_prefix]]modules` VALUES (12, 'Sections', '', 9, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_sections', 0, 0, 1, '', 1, 0, '');
INSERT INTO `[[db_prefix]]modules` VALUES (13, 'Newsflash', '', 1, 'newsflash', 0, '0000-00-00 00:00:00', 1, 'mod_newsflash', 0, 0, 0, 'catid=3\nstyle=random\nimage=0\nlink_titles=\nreadmore=0\nitem_title=0\nitems=\ncache=0\nmoduleclass_sfx=', 0, 0, '');
INSERT INTO `[[db_prefix]]modules` VALUES (14, 'Related Items', '', 10, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_related_items', 0, 0, 1, '', 0, 0, '');
INSERT INTO `[[db_prefix]]modules` VALUES (15, 'Search', '', 1, 'header', 0, '0000-00-00 00:00:00', 1, 'mod_search', 0, 0, 0, 'moduleclass_sfx=\ncache=0\nwidth=20\ntext=\nbutton=\nbutton_pos=right\nbutton_text=', 0, 0, '');
INSERT INTO `[[db_prefix]]modules` VALUES (16, 'Random Image', '', 9, 'right', 0, '0000-00-00 00:00:00', 0, 'mod_random_image', 0, 0, 1, 'type=jpg\nfolder=images/stories\n\nlink=\nwidth=\nheight=\nmoduleclass_sfx=', 0, 0, '');
INSERT INTO `[[db_prefix]]modules` VALUES (17, 'Top Menu', '', 1, 'top', 0, '0000-00-00 00:00:00', 1, 'mod_mainmenu', 0, 0, 0, 'class_sfx=-nav\nmoduleclass_sfx=\nmenutype=topmenu\nmenu_style=list_flat\ncache=0\nindent_image=0\nindent_image1=\nindent_image2=\nindent_image3=\nindent_image4=\nindent_image5=\nindent_image6=\nspacer=\nend_spacer=', 1, 0, '');
INSERT INTO `[[db_prefix]]modules` VALUES (18, 'Banners', '', 1, 'banner', 0, '0000-00-00 00:00:00', 1, 'mod_banners', 0, 0, 0, 'banner_cids=\nmoduleclass_sfx=\n', 1, 0, '');
INSERT INTO `[[db_prefix]]modules` VALUES (19, 'Components', '', 2, 'cpanel', 0, '0000-00-00 00:00:00', 1, 'mod_components', 0, 99, 1, '', 1, 1, '');
INSERT INTO `[[db_prefix]]modules` VALUES (20, 'Popular', '', 3, 'cpanel', 0, '0000-00-00 00:00:00', 1, 'mod_popular', 0, 99, 1, '', 0, 1, '');
INSERT INTO `[[db_prefix]]modules` VALUES (21, 'Latest Items', '', 4, 'cpanel', 0, '0000-00-00 00:00:00', 1, 'mod_latest', 0, 99, 1, '', 0, 1, '');
INSERT INTO `[[db_prefix]]modules` VALUES (22, 'Menu Stats', '', 5, 'cpanel', 0, '0000-00-00 00:00:00', 1, 'mod_stats', 0, 99, 1, '', 0, 1, '');
INSERT INTO `[[db_prefix]]modules` VALUES (23, 'Unread Messages', '', 1, 'header', 0, '0000-00-00 00:00:00', 1, 'mod_unread', 0, 99, 1, '', 1, 1, '');
INSERT INTO `[[db_prefix]]modules` VALUES (24, 'Online Users', '', 2, 'header', 0, '0000-00-00 00:00:00', 1, 'mod_online', 0, 99, 1, '', 1, 1, '');
INSERT INTO `[[db_prefix]]modules` VALUES (25, 'Full Menu', '', 1, 'top', 0, '0000-00-00 00:00:00', 1, 'mod_fullmenu', 0, 99, 1, '', 1, 1, '');
INSERT INTO `[[db_prefix]]modules` VALUES (26, 'Pathway', '', 1, 'pathway', 0, '0000-00-00 00:00:00', 1, 'mod_pathway', 0, 99, 1, '', 1, 1, '');
INSERT INTO `[[db_prefix]]modules` VALUES (27, 'Toolbar', '', 1, 'toolbar', 0, '0000-00-00 00:00:00', 1, 'mod_toolbar', 0, 99, 1, '', 1, 1, '');
INSERT INTO `[[db_prefix]]modules` VALUES (28, 'System Message', '', 1, 'inset', 0, '0000-00-00 00:00:00', 1, 'mod_mosmsg', 0, 99, 1, '', 1, 1, '');
INSERT INTO `[[db_prefix]]modules` VALUES (29, 'Quick Icons', '', 1, 'icon', 0, '0000-00-00 00:00:00', 1, 'mod_quickicon', 0, 99, 1, '', 1, 1, '');
INSERT INTO `[[db_prefix]]modules` VALUES (31, 'Other Menu', '', 3, 'left', 0, '0000-00-00 00:00:00', 1, 'mod_mainmenu', 0, 0, 1, 'menutype=othermenu\nmenu_style=vert_indent\ncache=0\nmenu_images=0\nmenu_images_align=0\nexpand_menu=0\nclass_sfx=\nmoduleclass_sfx=\nindent_image=0\nindent_image1=\nindent_image2=\nindent_image3=\nindent_image4=\nindent_image5=\nindent_image6=', 0, 0, '');
INSERT INTO `[[db_prefix]]modules` VALUES (32, 'Wrapper', '', 11, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_wrapper', 0, 0, 1, '', 0, 0, '');
INSERT INTO `[[db_prefix]]modules` VALUES (33, 'Logged', '', 0, 'cpanel', 0, '0000-00-00 00:00:00', 1, 'mod_logged', 0, 99, 1, '', 0, 1, '');
INSERT INTO `[[db_prefix]]modules` VALUES (34, 'Latest Content', '', 12, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_latestcontent', 0, 0, 1, '', 0, 0, '');


# --------------------------------------------------------

#
# Table structure for table `[[db_prefix]]modules_menu`
#

CREATE TABLE `[[db_prefix]]modules_menu` (
  `moduleid` int(11) NOT NULL default '0',
  `menuid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`moduleid`,`menuid`)
) ENGINE=MyISAM;

#
# Dumping data for table `[[db_prefix]]modules_menu`
#

INSERT INTO `[[db_prefix]]modules_menu` VALUES (1, 1);
INSERT INTO `[[db_prefix]]modules_menu` VALUES (2, 0);
INSERT INTO `[[db_prefix]]modules_menu` VALUES (3, 0);
INSERT INTO `[[db_prefix]]modules_menu` VALUES (4, 1);
INSERT INTO `[[db_prefix]]modules_menu` VALUES (5, 1);
INSERT INTO `[[db_prefix]]modules_menu` VALUES (6, 1);
INSERT INTO `[[db_prefix]]modules_menu` VALUES (6, 27);
INSERT INTO `[[db_prefix]]modules_menu` VALUES (8, 1);
INSERT INTO `[[db_prefix]]modules_menu` VALUES (9, 1);
INSERT INTO `[[db_prefix]]modules_menu` VALUES (9, 27);
INSERT INTO `[[db_prefix]]modules_menu` VALUES (10, 1);
INSERT INTO `[[db_prefix]]modules_menu` VALUES (13, 0);
INSERT INTO `[[db_prefix]]modules_menu` VALUES (15, 0);
INSERT INTO `[[db_prefix]]modules_menu` VALUES (17, 0);
INSERT INTO `[[db_prefix]]modules_menu` VALUES (18, 0);
INSERT INTO `[[db_prefix]]modules_menu` VALUES (31, 0);

# --------------------------------------------------------

#
# Table structure for table `[[db_prefix]]newsfeeds`
#

CREATE TABLE `[[db_prefix]]newsfeeds` (
  `catid` int(11) NOT NULL default '0',
  `id` int(11) NOT NULL auto_increment,
  `name` text NOT NULL,
  `link` text NOT NULL,
  `filename` varchar(200) default NULL,
  `published` tinyint(1) NOT NULL default '0',
  `numarticles` int(11) unsigned NOT NULL default '1',
  `cache_time` int(11) unsigned NOT NULL default '3600',
  `checked_out` tinyint(3) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `published` (`published`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]poll_data`
#

CREATE TABLE `[[db_prefix]]poll_data` (
  `id` int(11) NOT NULL auto_increment,
  `pollid` int(4) NOT NULL default '0',
  `text` text NOT NULL default '',
  `hits` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `pollid` (`pollid`,`text`(1))
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]poll_date`
#

CREATE TABLE `[[db_prefix]]poll_date` (
  `id` bigint(20) NOT NULL auto_increment,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `vote_id` int(11) NOT NULL default '0',
  `poll_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `poll_id` (`poll_id`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]polls`
#

CREATE TABLE `[[db_prefix]]polls` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `voters` int(9) NOT NULL default '0',
  `checked_out` int(11) NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL default '0',
  `access` int(11) NOT NULL default '0',
  `lag` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]poll_menu`
#

CREATE TABLE `[[db_prefix]]poll_menu` (
  `pollid` int(11) NOT NULL default '0',
  `menuid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`pollid`,`menuid`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]sections`
#

CREATE TABLE `[[db_prefix]]sections` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(50) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  `image` varchar(100) NOT NULL default '',
  `scope` varchar(50) NOT NULL default '',
  `image_position` varchar(10) NOT NULL default '',
  `description` text NOT NULL,
  `published` tinyint(1) NOT NULL default '0',
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL default '0',
  `access` tinyint(3) unsigned NOT NULL default '0',
  `count` int(11) NOT NULL default '0',
  `params` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `idx_scope` (`scope`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]session`
#

CREATE TABLE `[[db_prefix]]session` (
  `username` varchar(50) default '',
  `time` varchar(14) default '',
  `session_id` varchar(200) NOT NULL default '0',
  `guest` tinyint(4) default '1',
  `userid` int(11) default '0',
  `usertype` varchar(50) default '',
  `gid` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`session_id`),
  KEY `whosonline` (`guest`,`usertype`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]stats_agents`
#

CREATE TABLE `[[db_prefix]]stats_agents` (
  `agent` varchar(255) NOT NULL default '',
  `type` tinyint(1) unsigned NOT NULL default '0',
  `hits` int(11) unsigned NOT NULL default '1'
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]templates_menu`
#

CREATE TABLE `[[db_prefix]]templates_menu` (
  `template` varchar(50) NOT NULL default '',
  `menuid` int(11) NOT NULL default '0',
  `client_id` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`template`,`menuid`)
) ENGINE=MyISAM;

# Dumping data for table `[[db_prefix]]templates_menu`

INSERT INTO `[[db_prefix]]templates_menu` VALUES ('waterandstone', 0, 0);
INSERT INTO `[[db_prefix]]templates_menu` VALUES ('mambo_admin_blue', 0, 1);

# --------------------------------------------------------

#
# Table structure for table `[[db_prefix]]template_positions`
#

CREATE TABLE `[[db_prefix]]template_positions` (
  `id` int(11) NOT NULL auto_increment,
  `position` varchar(10) NOT NULL default '',
  `description` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

#
# Dumping data for table `[[db_prefix]]template_positions`
#

INSERT INTO `[[db_prefix]]template_positions` VALUES (1, 'left', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (2, 'right', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (3, 'top', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (4, 'bottom', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (5, 'inset', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (6, 'banner', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (7, 'header', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (8, 'footer', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (9, 'newsflash', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (10, 'legals', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (11, 'pathway', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (12, 'toolbar', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (13, 'cpanel', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (14, 'user1', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (15, 'user2', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (16, 'user3', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (17, 'user4', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (18, 'user5', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (19, 'user6', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (20, 'user7', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (21, 'user8', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (22, 'user9', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (23, 'advert1', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (24, 'advert2', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (25, 'advert3', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (26, 'icon', '');
INSERT INTO `[[db_prefix]]template_positions` VALUES (27, 'debug', '');

# --------------------------------------------------------

#
# Table structure for table `[[db_prefix]]users`
#

CREATE TABLE `[[db_prefix]]users` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `username` varchar(25) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  `password` varchar(100) NOT NULL default '',
  `usertype` varchar(25) NOT NULL default '',
  `block` tinyint(4) NOT NULL default '0',
  `sendEmail` tinyint(4) default '0',
  `gid` tinyint(3) unsigned NOT NULL default '1',
  `registerDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `lastvisitDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `activation` varchar(100) NOT NULL default '',
  `params` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `usertype` (`usertype`),
  KEY `idx_name` (`name`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]usertypes`
#

CREATE TABLE `[[db_prefix]]usertypes` (
  `id` tinyint(3) unsigned NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `mask` varchar(11) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

#
# Dumping data for table `[[db_prefix]]usertypes`
#

INSERT INTO `[[db_prefix]]usertypes` VALUES (0, 'superadministrator', '');
INSERT INTO `[[db_prefix]]usertypes` VALUES (1, 'administrator', '');
INSERT INTO `[[db_prefix]]usertypes` VALUES (2, 'editor', '');
INSERT INTO `[[db_prefix]]usertypes` VALUES (3, 'user', '');
INSERT INTO `[[db_prefix]]usertypes` VALUES (4, 'author', '');
INSERT INTO `[[db_prefix]]usertypes` VALUES (5, 'publisher', '');
INSERT INTO `[[db_prefix]]usertypes` VALUES (6, 'manager', '');
# --------------------------------------------------------

#
# Table structure for table `[[db_prefix]]weblinks`
#

CREATE TABLE `[[db_prefix]]weblinks` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `catid` int(11) NOT NULL default '0',
  `sid` int(11) NOT NULL default '0',
  `title` varchar(250) NOT NULL default '',
  `url` varchar(250) NOT NULL default '',
  `description` varchar(250) NOT NULL default '',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `hits` int(11) NOT NULL default '0',
  `published` tinyint(1) NOT NULL default '0',
  `checked_out` int(11) NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL default '0',
  `archived` tinyint(1) NOT NULL default '0',
  `approved` tinyint(1) NOT NULL default '1',
  `params` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `catid` (`catid`,`published`,`archived`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]parameters`
#

CREATE TABLE `[[db_prefix]]parameters` (
  `id` int(11) NOT NULL auto_increment,
  `param_name` varchar(50) NOT NULL default '',
  `param_file` varchar(50) NOT NULL default '',
  `param_version` varchar(50) NOT NULL default '',
  `params` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `names` (`param_name`, `param_version`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]core_acl_aro`
#

CREATE TABLE `[[db_prefix]]core_acl_aro` (
`aro_id` int(11) NOT NULL auto_increment,
`section_value` varchar(240) NOT NULL default '0',
`value` varchar(240) NOT NULL default '',
`order_value` int(11) NOT NULL default '0',
`name` varchar(255) NOT NULL default '',
`hidden` int(11) NOT NULL default '0',
PRIMARY KEY (`aro_id`),
UNIQUE KEY `[[db_prefix]]gacl_section_value_value_aro` (`section_value`(100),`value`(100)),
KEY `[[db_prefix]]gacl_hidden_aro` (`hidden`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]core_acl_aro_groups`
#
CREATE TABLE `[[db_prefix]]core_acl_aro_groups` (
  `group_id` int(11) NOT NULL auto_increment,
  `parent_id` int(11) NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  `lft` int(11) NOT NULL default '0',
  `rgt` int(11) NOT NULL default '0',
  PRIMARY KEY  (`group_id`),
  KEY `parent_id_aro_groups` (`parent_id`),
  KEY `[[db_prefix]]gacl_parent_id_aro_groups` (`parent_id`),
  KEY `[[db_prefix]]gacl_lft_rgt_aro_groups` (`lft`,`rgt`)
) ENGINE=MyISAM;

#
# Dumping data for table `[[db_prefix]]core_acl_aro_groups`
#
INSERT INTO `[[db_prefix]]core_acl_aro_groups` VALUES (17,0,'ROOT',1,22);
INSERT INTO `[[db_prefix]]core_acl_aro_groups` VALUES (28,17,'USERS',2,21);
INSERT INTO `[[db_prefix]]core_acl_aro_groups` VALUES (29,28,'Public Frontend',3,12);
INSERT INTO `[[db_prefix]]core_acl_aro_groups` VALUES (18,29,'Registered',4,11);
INSERT INTO `[[db_prefix]]core_acl_aro_groups` VALUES (19,18,'Author',5,10);
INSERT INTO `[[db_prefix]]core_acl_aro_groups` VALUES (20,19,'Editor',6,9);
INSERT INTO `[[db_prefix]]core_acl_aro_groups` VALUES (21,20,'Publisher',7,8);
INSERT INTO `[[db_prefix]]core_acl_aro_groups` VALUES (30,28,'Public Backend',13,20);
INSERT INTO `[[db_prefix]]core_acl_aro_groups` VALUES (23,30,'Manager',14,19);
INSERT INTO `[[db_prefix]]core_acl_aro_groups` VALUES (24,23,'Administrator',15,18);
INSERT INTO `[[db_prefix]]core_acl_aro_groups` VALUES (25,24,'Super Administrator',16,17);

#
# Table structure for table `[[db_prefix]]core_acl_groups_aro_map`
#
CREATE TABLE `[[db_prefix]]core_acl_groups_aro_map` (
  `group_id` int(11) NOT NULL default '0',
  `section_value` varchar(240) NOT NULL default '',
  `aro_id` int(11) NOT NULL default '0',
  UNIQUE KEY `group_id_aro_id_groups_aro_map` (`group_id`,`section_value`,`aro_id`)
) ENGINE=MyISAM;

#
# Table structure for table `[[db_prefix]]core_acl_aro_sections`
#
CREATE TABLE `[[db_prefix]]core_acl_aro_sections` (
  `section_id` int(11) NOT NULL auto_increment,
  `value` varchar(230) NOT NULL default '',
  `order_value` int(11) NOT NULL default '0',
  `name` varchar(230) NOT NULL default '',
  `hidden` int(11) NOT NULL default '0',
  PRIMARY KEY  (`section_id`),
  UNIQUE KEY `value_aro_sections` (`value`),
  UNIQUE KEY `[[db_prefix]]gacl_value_aro_sections` (`value`),
  KEY `hidden_aro_sections` (`hidden`),
  KEY `[[db_prefix]]gacl_hidden_aro_sections` (`hidden`)
) ENGINE=MyISAM;

INSERT INTO `[[db_prefix]]core_acl_aro_sections` VALUES (10,'users',1,'Users',0);

INSERT INTO `[[db_prefix]]users` VALUES (62, '[[admin_realname]]', '[[admin_username]]', '[[admin_email]]', '[[admin_pass]]', 'Super Administrator', 0, 1, 25, '[[regtime]]', '[[regtime]]', '', '');

INSERT INTO `[[db_prefix]]core_acl_aro` VALUES (10,'users','62',0,'Administrator',0);

INSERT INTO `[[db_prefix]]core_acl_groups_aro_map` VALUES (25,'',10);
