<?php
/**
* @package Mambo
* @subpackage Installer
* @author Mambo Foundation Inc see README.php
* @copyright Mambo Foundation Inc.
* See COPYRIGHT.php for copyright notices and details.
* @license GNU/GPL Version 2, see LICENSE.php
* Mambo is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; version 2 of the License.
*/


/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

// ensure user has access to this function
if ( !$acl->acl_check( 'administration', 'install', 'users', $my->usertype, $element . 's', 'all' ) ) {
	mosRedirect( 'index2.php', T_('You are not authorized to view this resource.') );
}

require_once( $mainframe->getPath( 'installer_html', 'module' ) );

showInstalledModules( $option );

/**
* @param string The URL option
*/
function showInstalledModules( $_option ) {
	global $database, $mosConfig_absolute_path;

	$filter = mosGetParam( $_POST, 'filter', '' );
	$select[] = mosHTML::makeOption( '', T_('All') );
	$select[] = mosHTML::makeOption( '0', T_('Site Modules') );
	$select[] = mosHTML::makeOption( '1', T_('Admin Modules') );
	$lists['filter'] = mosHTML::selectList( $select, 'filter', 'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'value', 'text', $filter );
	if ( $filter == NULL ) {
		$_and = '';
	} else if ( !$filter ) {
		$_and = "\n AND client_id = '0'";
	} else if ( $filter ) {
		$_and = "\n AND client_id = '1'";
	}

	$database->setQuery( "SELECT id, module, client_id"
		. "\n FROM #__modules"
		. "\n WHERE module LIKE 'mod_%' AND iscore='0'"
		. $_and
		. "\n GROUP BY module, client_id"
		. "\n ORDER BY client_id, module"
	);
	$rows = $database->loadObjectList();

	$n = count( $rows );
	for ($i = 0; $i < $n; $i++) {
	    $row =& $rows[$i];

		// path to module directory
		if ($row->client_id == "1"){
			$moduleBaseDir	= mosPathName($mosConfig_absolute_path.'/administrator/modules');
		} else {
			$moduleBaseDir	= mosPathName($mosConfig_absolute_path.'/modules');
		}

		// xml file for module
		$xmlfile = $moduleBaseDir.$row->module.".xml";

		if (file_exists( $xmlfile )) {
			$parser =& new mosXMLDescription($xmlfile);
			if ($parser->getType() != 'module') continue;
			$row->creationdate = $parser->getCreationDate('module');
			$row->author = $parser->getAuthor('module');
			$row->copyright = $parser->getCopyright('module');
			$row->authorEmail = $parser->getAuthorEmail('module');
			$row->authorUrl = $parser->getAuthorUrl('module');
			$row->version = $parser->getVersion('module');
/*
			$xmlDoc =& new DOMIT_Lite_Document();
			$xmlDoc->resolveErrors( true );
			if (!$xmlDoc->loadXML( $xmlfile, false, true )) {
				continue;
			}

			$element = &$xmlDoc->documentElement;

			if ($element->getTagName() != 'mosinstall') {
				continue;
			}
			if ($element->getAttribute( "type" ) != "module") {
				continue;
			}

			$element = &$xmlDoc->getElementsByPath( 'creationDate', 1 );
			$row->creationdate = $element ? $element->getText() : '';

			$element = &$xmlDoc->getElementsByPath( 'author', 1 );
			$row->author = $element ? $element->getText() : '';

			$element = &$xmlDoc->getElementsByPath( 'copyright', 1 );
			$row->copyright = $element ? $element->getText() : '';

			$element = &$xmlDoc->getElementsByPath( 'authorEmail', 1 );
			$row->authorEmail = $element ? $element->getText() : '';

			$element = &$xmlDoc->getElementsByPath( 'authorUrl', 1 );
			$row->authorUrl = $element ? $element->getText() : '';

			$element = &$xmlDoc->getElementsByPath( 'version', 1 );
			$row->version = $element ? $element->getText() : '';
*/
    	}
	}

	HTML_module::showInstalledModules( $rows, $_option, $xmlfile, $lists );
}
?>
