<?php
/**
* @package Mambo
* @subpackage Content
* @author Mambo Foundation Inc see README.php
* @copyright Mambo Foundation Inc.
* See COPYRIGHT.php for copyright notices and details.
* @license GNU/GPL Version 2, see LICENSE.php
* Mambo is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; version 2 of the License.
*/

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

require_once( $mainframe->getPath( 'front_html', 'com_content' ) );
require_once($mainframe->getPath('class'));

$id			= intval( mosGetParam( $_REQUEST, 'id', 0 ) );
$sectionid 	= intval( mosGetParam( $_REQUEST, 'sectionid', 0 ) );
$pop 		= intval( mosGetParam( $_REQUEST, 'pop', 0 ) );
$task 		= trim( mosGetParam( $_REQUEST, 'task', '' ) );
$limit 		= intval( mosGetParam( $_REQUEST, 'limit', '' ) );
$limitstart = intval( mosGetParam( $_REQUEST, 'limitstart', 0 ) );

$now = date( 'Y-m-d H:i:s', time() + $mosConfig_offset * 60 * 60 );

// Editor usertype check
$access = new stdClass();
$access->canEdit 	= $acl->acl_check( 'action', 'edit', 'users', $my->usertype, 'content', 'all' );
$access->canEditOwn = $acl->acl_check( 'action', 'edit', 'users', $my->usertype, 'content', 'own' );
$access->canPublish = $acl->acl_check( 'action', 'publish', 'users', $my->usertype, 'content', 'all' );

// cache activation
$cache =& mosCache::getCache( 'com_content' );

// loads function for frontpage component
if ( $option == 'com_frontpage' ) {
	//frontpage( $option, $gid, $pop, $now );
	$cache->call( 'frontpage', $gid, $access, $pop, $limit, $limitstart);
	return;
}

switch ( strtolower( $task ) ) {
	case 'findkey':
		findKeyItem( $gid, $access, $pop, $option, $now );
		break;

	case 'view':
		showItem( $id, $gid, $access, $pop, $option, $now );
		break;

	case 'section':
		$cache->call( 'showSection', $id, $gid, $access );
		break;

	case 'category':
		$cache->call( 'showCategory', $id, $gid, $access, $sectionid, $limit, $limitstart );
		break;

	case 'blogsection':
		$cache->call('showBlogSection', $id, $gid, $access, $pop, $limit, $limitstart );
		break;

	case 'blogcategorymulti':
	case 'blogcategory':
		$cache->call( 'showBlogCategory', $id, $gid, $access, $pop, $limit, $limitstart );
		break;

	case 'archivesection':
		showArchiveSection( $id, $gid, $access, $pop, $option );
		break;

	case 'archivecategory':
		showArchiveCategory( $id, $gid, $access, $pop, $option, $now );
		break;

	case 'edit':
		editItem( $id, $gid, $access, 0, $task, $Itemid );
		break;

	case 'new':
		editItem( 0, $gid, $access, $sectionid, $task, $Itemid );
		break;

	case 'save':
		mosCache::cleanCache( 'com_content' );
		saveContent( $access );
		break;

	case 'cancel':
		cancelContent( $access );
		break;

	case 'emailform':
		emailContentForm( $id );
		break;

	case 'emailsend':
		emailContentSend( $id );
		break;

	case 'vote':
		recordVote (  $user_rating , $cid , $database);
		break;

	default:
		$cache->call('showBlogSection', 0, $gid, $access, $pop, $limit, $limitstart );
		break;
}

/**
 * Searches for an item by a key parameter
 * @param int The user access level
 * @param object Actions this user can perform
 * @param int
 * @param string The url option
 * @param string A timestamp
 */
function findKeyItem( $gid, $access, $pop, $option, $now ) {
	global $database;
	$keyref = mosGetParam( $_REQUEST, 'keyref', '' );
	$keyref = $database->getEscaped( $keyref );

	$query = 'SELECT id
		FROM #__content
		WHERE attribs LIKE \'%keyref=' . $keyref . '%\'
		';
	$database->setQuery( $query );
	$id = $database->loadResult();
	if ($id > 0) {
		showItem( $id, $gid, $access, $pop, $option, $now );
	} else {
		echo 'Key not found '. $keyref;
	}
}

function frontpage( $gid, &$access, $pop, $limit, $limitstart) {
	global $database, $mainframe, $my, $Itemid;
	global $mosConfig_offset;

	$noauth = !$mainframe->getCfg( 'shownoauth' );

	// Parameters
	$menu =& new mosMenu( $database );
	$menu->load( $Itemid );
	$params =& new mosParameters( $menu->params );
	$orderby_sec = $params->def( 'orderby_sec', '' );
	$orderby_pri = $params->def( 'orderby_pri', '' );
	$header = $params->def( 'header', $menu->name );
	$page_title = $params->def( 'page_title', 0 );
	// Ordering control
	$order_sec = _orderby_sec( $orderby_sec );
	$order_pri = _orderby_pri( $orderby_pri );

	$now = date( "Y-m-d H:i:s", time()+$mosConfig_offset*60*60 );

	global $acl;
	$viewAccess = ($gid >= $acl->get_group_id( 'Registered', 'ARO' ) ? 1 : 0) + ($gid >= $acl->get_group_id( 'Author', 'ARO' ) ? 1 : 0);
	// query records
	$query = "SELECT a.*, ROUND( v.rating_sum / v.rating_count ) AS rating, v.rating_count, u.name AS author, u.usertype, s.name AS section, cc.name AS category, g.name AS groups"
	. "\n FROM #__content AS a"
	. "\n INNER JOIN #__content_frontpage AS f ON f.content_id = a.id"
	. "\n LEFT JOIN #__categories AS cc ON cc.id = a.catid"
	. "\n LEFT JOIN #__sections AS s ON s.id = a.sectionid"
	. "\n LEFT JOIN #__users AS u ON u.id = a.created_by"
	. "\n LEFT JOIN #__content_rating AS v ON a.id = v.content_id"
	. "\n LEFT JOIN #__groups AS g ON a.access = g.id"
	. "\n WHERE a.state = '1'"
	. ( $noauth ? "\n AND a.access <= '". $my->gid ."'" : '' )
	. "\n AND ( publish_up = '0000-00-00 00:00:00' OR publish_up <= '$now'  )"
	. "\n AND ( publish_down = '0000-00-00 00:00:00' OR publish_down >= '$now' )"
	. "\n AND a.access <= ". $viewAccess
	. "\n ORDER BY ". $order_pri . $order_sec
	;
	$rows = $database->doSQLget($query, 'mosExtendedContent');

	// Dynamic Page Title
	$mainframe->SetPageTitle( $header );

	BlogOutput( $rows, $params, $gid, $access, $pop, $menu, null, $limit, $limitstart );
}


function showSection( $id, $gid, &$access ) {
	global $database, $mainframe, $mosConfig_offset, $Itemid;

	$noauth = !$mainframe->getCfg( 'shownoauth' );
    $now = date( 'Y-m-d H:i:s', time() + $mosConfig_offset * 60 * 60 );
	// Paramters
	$params = new stdClass();
	if ( $Itemid ) {
		$menu = new mosMenu( $database );
		$menu->load( $Itemid );
		$params =& new mosParameters( $menu->params );
	} else {
		$menu = "";
		$params =& new mosParameters( $menu->params );

	}
	$orderby = $params->get( 'orderby', '' );

	$params->set( 'type', 'section' );

	$params->def( 'page_title', 1 );
	$params->def( 'pageclass_sfx', '' );
	$params->def( 'other_cat_section', 1 );
	$params->def( 'other_cat', 1 );
	$params->def( 'empty_cat', 0 );
	$params->def( 'cat_items', 1 );
	$params->def( 'cat_description', 1 );
	$params->def( 'description', 1 );
	$params->def( 'description-image', 1 );
	$params->def( 'back_button', $mainframe->getCfg( 'back_button' ) );
	$params->def( 'pageclass_sfx', '' );

	// Ordering control
	$orderby = _orderby_sec( $orderby );

	$section = new mosSection( $database );
	$section->load( $id );

	if ( $access->canEdit ) {
		$xwhere = '';
		$xwhere2 = "\n AND b.state >= '0'";
	} else {
		$xwhere = "\n AND a.published = '1'";
		$xwhere2 = "\n AND b.state = '1'"
		. "\n AND ( publish_up = '0000-00-00 00:00:00' OR publish_up <= '". $now ."' )"
		. "\n AND ( publish_down = '0000-00-00 00:00:00' OR publish_down >= '". $now ."' )"
		;
	}

	// show/hide empty categories
	if ( $params->get( 'empty_cat' ) ) {
		$empty = '';
	} else {
		$empty = "\n HAVING COUNT( b.id ) > 0";
	}

	// Main Query
	$query = '
		SELECT a.*, COUNT( b.id ) AS numitems
		FROM #__categories AS a
		LEFT JOIN #__content AS b ON b.catid = a.id '. $xwhere2 .'
		WHERE a.section = \'' . $section->id .'\' '. $xwhere;
	if ($noauth) {
		$query .= '
		AND a.access <= '. $gid;
	}
	$query .= '
		GROUP BY a.id
		' . $empty . '
		ORDER BY ' . $orderby;

	$database->setQuery( $query );
	$other_categories = $database->loadObjectList();

	// Dynamic Page Title
	$mainframe->SetPageTitle( $menu->name );

	HTML_content::showContentList( $section, NULL, $access, $id, NULL,  $gid, $params, NULL, $other_categories, NULL );
}


/**
* @param int The category id
* @param int The group id of the user
* @param int The access level of the user
* @param int The section id
* @param int The number of items to dislpay
* @param int The offset for pagination
*/
function showCategory( $id, $gid, &$access, $sectionid, $limit, $limitstart ) {
	global $database, $mainframe, $Itemid, $mosConfig_offset, $mosConfig_list_limit;

	$noauth = !$mainframe->getCfg( 'shownoauth' );
	$selected = mosGetParam( $_POST, 'order', '' );
    $now = date( 'Y-m-d H:i:s', time() + $mosConfig_offset * 60 * 60 );
	// Paramters
	$params = new stdClass();
	if ( $Itemid ) {
		$menu = new mosMenu( $database );
		$menu->load( $Itemid );
		$params =& new mosParameters( $menu->params );
	} else {
		$menu = "";
		$params =& new mosParameters( '' );
	}

	if ( $selected ) {
		$orderby = $selected;
	} else {
		$orderby = $params->get( 'orderby', 'rdate' );
		$selected = $orderby;
	}

	$params->set( 'type', 'category' );

	$params->def( 'page_title', 1 );
	$params->def( 'title', 1 );
	$params->def( 'hits', $mainframe->getCfg( 'hits' ) );
	$params->def( 'author', !$mainframe->getCfg( 'hideAuthor' ) );
	$params->def( 'date', !$mainframe->getCfg( 'hideCreateDate' ) );
	$params->def( 'date_format', _DATE_FORMAT_LC );
	$params->def( 'navigation', 2 );
	$params->def( 'display', 1 );
	$params->def( 'display_num', $mosConfig_list_limit );
	$params->def( 'other_cat', 1 );
	$params->def( 'empty_cat', 0 );
	$params->def( 'cat_items', 1 );
	$params->def( 'cat_description', 0 );
	$params->def( 'description', 1 );
	$params->def( 'description-image', 1 );
	$params->def( 'back_button', $mainframe->getCfg( 'back_button' ) );
	$params->def( 'pageclass_sfx', '' );
	$params->def( 'headings', 1 );
	$params->def( 'order_select', 1 );
	$params->def( 'filter', 1 );
	$params->def( 'filter_type', 'title' );

	// Ordering control
	$orderby = _orderby_sec( $orderby );

	$category = new mosCategory( $database );
	$category->load( $id );

	if ( $sectionid == 0 ) {
		$sectionid = $category->section;
	}

	$pathway =& mosPathway::getInstance();
	$pathway->addItem($category->title, categoryURL($sectionid, $id));

	if ( $access->canEdit ) {
		$xwhere = '';
		$xwhere2 = "\n AND b.state >= '0'";
	} else {
		$xwhere = "\n AND c.published='1'";
		$xwhere2 = "\n AND b.state='1'"
		. "\n AND ( publish_up = '0000-00-00 00:00:00' OR publish_up <= '". $now ."' )"
		. "\n AND ( publish_down = '0000-00-00 00:00:00' OR publish_down >= '". $now ."' )"
		;
	}

	$pagetitle = '';
	if ( $Itemid ) {
		$menu = new mosMenu( $database );
		$menu->load( $Itemid );
		$pagetitle = $menu->name;
	} // if

	// show/hide empty categories
	$empty = '';
	if ( !$params->get( 'empty_cat' ) )
		$empty = "\n HAVING COUNT( b.id ) > 0";

	// get the list of other categories
	$query = "SELECT c.*, COUNT( b.id ) AS numitems"
	. "\n FROM #__categories AS c"
	. "\n LEFT JOIN #__content AS b ON b.catid = c.id "
	. $xwhere2
	. ( $noauth ? "\n AND b.access <= '". $gid ."'" : '' )
	. "\n WHERE c.section = '". $category->section. "'"
	. $xwhere
	. ( $noauth ? "\n AND c.access <= '". $gid ."'" : '' )
	. "\n GROUP BY c.id"
	. $empty
	. "\n ORDER BY c.ordering"
	;
	$database->setQuery( $query );
	$other_categories = $database->loadObjectList();

	// get the total number of published items in the category
	// filter functionality
	$_and = '';
	if ($filter = mosGetParam($_POST, 'filter', '')) {
		$filter = strtolower( $filter );
		$filter = $database->getEscaped($filter);
		if ( $params->get( 'filter' ) ) {
			switch ( $params->get( 'filter_type' ) ) {
				case 'title':
					$_and = "\n AND LOWER( a.title ) LIKE '%". $filter ."%'";
					break;
				case 'author':
					$_and = "\n AND ( ( LOWER( u.name ) LIKE '%". $filter ."%' ) OR ( LOWER( a.created_by_alias ) LIKE '%". $filter ."%' ) )";
					break;
				case 'hits':
					$_and = "\n AND a.hits LIKE '%". $filter ."%'";
					break;
			}
		}

	}

	if ( $access->canEdit ) {
		$xwhere = "\n AND a.state >= '0'";
	} else {
		$xwhere = "\n AND a.state='1'"
		. "\n AND ( publish_up = '0000-00-00 00:00:00' OR publish_up <= '$now' )"
		. "\n AND ( publish_down = '0000-00-00 00:00:00' OR publish_down >= '$now' )"
		;
	}

	$query = "SELECT COUNT(a.id) as numitems"
	. "\n FROM #__content AS a"
	. "\n LEFT JOIN #__users AS u ON u.id = a.created_by"
	. "\n LEFT JOIN #__groups AS g ON a.access = g.id"
	. "\n WHERE a.catid='". $category->id ."' ". $xwhere
	. ( $noauth ? "\n AND a.access<='". $gid ."'" : '' )
	. "\n AND '". $category->access ."'<='". $gid ."'"
	. $_and
	. "\n ORDER BY ". $orderby .""
	;
	$database->setQuery( $query );
	$counter = $database->loadObjectList();
	$total = $counter[0]->numitems;
	$limit = $limit ? $limit : $params->get( 'display_num' ) ;
	if ( $total <= $limit ) $limitstart = 0;

	require_once( $GLOBALS['mosConfig_absolute_path'] . '/includes/pageNavigation.php' );
	$pageNav = new mosPageNav( $total, $limitstart, $limit );

	// get the list of items for this category
	$query = "SELECT a.id, a.title, a.hits, a.created_by, a.created_by_alias, a.created AS created, a.access, u.name AS author, a.state, g.name AS groups"
	. "\n FROM #__content AS a"
	. "\n LEFT JOIN #__users AS u ON u.id = a.created_by"
	. "\n LEFT JOIN #__groups AS g ON a.access = g.id"
	. "\n WHERE a.catid='". $category->id ."' ". $xwhere
	. ( $noauth ? "\n AND a.access<='". $gid ."'" : '' )
	. "\n AND '". $category->access ."'<='". $gid ."'"
	. $_and
	. "\n ORDER BY ". $orderby .""
	. "\n LIMIT ". $limitstart .", ". $limit
	;
	$database->setQuery( $query );
	$items = $database->loadObjectList();

	$check = 0;
	if ( $params->get( 'date' ) ) {
		$order[] = mosHTML::makeOption( 'date', T_('Date Asc') );
		$order[] = mosHTML::makeOption( 'rdate', T_('Date Desc'));
		$check .= 1;
	}
	if ( $params->get( 'title' ) ) {
		$order[] = mosHTML::makeOption( 'alpha', T_('Title Asc') );
		$order[] = mosHTML::makeOption( 'ralpha', T_('Title Desc') );
		$check .= 1;
	}
	if ( $params->get( 'hits' ) ) {
		$order[] = mosHTML::makeOption( 'hits', T_('Hits Asc') );
		$order[] = mosHTML::makeOption( 'rhits', T_('Hits Desc') );
		$check .= 1;
	}
	if ( $params->get( 'author' ) ) {
		$order[] = mosHTML::makeOption( 'author', T_('Author Asc') );
		$order[] = mosHTML::makeOption( 'rauthor', T_('Author Desc') );
		$check .= 1;
	}
	$order[] = mosHTML::makeOption( 'order', T_('Ordering') );
	$lists['order'] = mosHTML::selectList( $order, 'order', 'class="inputbox" size="1"  onchange="document.adminForm.submit();"', 'value', 'text', $selected );
	if ( $check < 1 ) {
		$lists['order'] = '';
		$params->set( 'order_select', 0 );
	}

	$lists['task'] = 'category';
	$lists['filter'] = $filter;

	// Dynamic Page Title
	$mainframe->SetPageTitle( $pagetitle );

	HTML_content::showContentList( $category, $items, $access, $id, $sectionid, $gid, $params, $pageNav, $other_categories, $lists );
} // showCategory


function showBlogSection( $id=0, $gid, &$access, $pop, $limit, $limitstart  ) {
	global $database, $mainframe, $mosConfig_offset, $Itemid, $option, $task;

	$noauth = !$mainframe->getCfg( 'shownoauth' );
    $now = date( 'Y-m-d H:i:s', time() + $mosConfig_offset * 60 * 60 );
	// Parameters
	$pageTitle = '';
	if ( $Itemid ) {
		$menu = new mosMenu( $database );
		$menu->load( $Itemid );
		if ( strpos(strtolower($menu->link), 'blogsection') === false ) {
			$menu = '';
		} else {
			// only load params and set title if the menu item loaded is a blog section
			$pageTitle = $menu->name;
		$params =& new mosParameters( $menu->params );
	}
	}

	// no Itemid OR menu item loaded is not a blog section
	// try to find a blog entry in the menu database
	if (!$menu) {
		$database->setQuery("SELECT * FROM #__menu WHERE link LIKE '%blogsection%'");
		$rows = $database->loadObjectList();
		if (count($rows)) {
			$params =& new mosParameters( $rows[0]->params );
		}
	}

	// no menu item found and no params loaded so create a default params object
	if (!$params) $params =& new mosParameters( $menu->params );

	// new blog multiple section handling
	if ( !$id ) {
		$id		= $params->def( 'sectionid', 0 );
	}

	$where 		= _where( 1, $access, $noauth, $gid, $id, $now );

	// Ordering control
	$orderby_sec 	= $params->def( 'orderby_sec', 'rdate' );
	$orderby_pri 	= $params->def( 'orderby_pri', '' );
	$order_sec 	= _orderby_sec( $orderby_sec );
	$order_pri 	= _orderby_pri( $orderby_pri );

	// Main data query
	$query = "SELECT a.*, ROUND( v.rating_sum / v.rating_count ) AS rating, v.rating_count, u.name AS author, u.usertype, cc.name AS category, g.name AS groups, s.title AS section"
	. "\n FROM #__content AS a"
	. "\n INNER JOIN #__categories AS cc ON cc.id = a.catid"
	. "\n LEFT JOIN #__users AS u ON u.id = a.created_by"
	. "\n LEFT JOIN #__content_rating AS v ON a.id = v.content_id"
	. "\n LEFT JOIN #__sections AS s ON a.sectionid = s.id"
	. "\n LEFT JOIN #__groups AS g ON a.access = g.id"
	. ( count( $where ) ? "\n WHERE ".implode( "\n AND ", $where ) : '' )
	. "\n AND s.access<=$gid"
	. "\n ORDER BY ". $order_pri . $order_sec
	;
//	$database->setQuery( $query );
//	$rows = $database->loadObjectList();
	$rows = $database->doSQLget($query, 'mosExtendedContent');

	// Dynamic Page Title
	// do we have multiple sections?
	$multiple_sections = false;
	if (count($rows)) {
		$temp = array();
		foreach($rows as $row) {
			$temp[$row->section] = '';
		}
		if (count($temp) > 1) {
			$multiple_sections = true;
		}
		unset($temp);
	}
	if (!$pageTitle) {
		// set the page title
		if ($rows[0]->section && !$multiple_sections){
			$pageTitle = $rows[0]->section;
		} else {
			$pageTitle = T_('Blog');
		}
		// fudge the pathway
		$mainframe->appendPathway($pageTitle);
	}
	$mainframe->setPageTitle( $pageTitle );

	// restore borrowed $row->section to null - IMPORTANT
	if (count($rows)) {
		for($i=0; $i<count($rows); $i++) $rows[$i]->section = '';
	}

	BlogOutput( $rows, $params, $gid, $access, $pop, $menu, null, $limit, $limitstart  );
}

function showBlogCategory( $id=0, $gid, &$access, $pop, $limit, $limitstart ) {
	global $database, $mainframe, $mosConfig_offset, $Itemid;

	$noauth = !$mainframe->getCfg( 'shownoauth' );
    $now = date( 'Y-m-d H:i:s', time() + $mosConfig_offset * 60 * 60 );
	// Paramters
	$params = new stdClass();
	if ( $Itemid ) {
		$menu = new mosMenu( $database );
		$menu->load( $Itemid );
		$params =& new mosParameters( $menu->params );
	} else {
		$menu = "";
		$params =& new mosParameters( '' );
	}

	// new blog multiple section handling
	if ( !$id ) {
		$id 		= $params->def( 'categoryid', 0 );
	}

	$where		= _where( 2, $access, $noauth, $gid, $id, $now );

	// Ordering control
	$orderby_sec 	= $params->def( 'orderby_sec', 'rdate' );
	$orderby_pri 	= $params->def( 'orderby_pri', '' );
	$order_sec 	= _orderby_sec( $orderby_sec );
	$order_pri 	= _orderby_pri( $orderby_pri );

	// Main data query
	$query = "SELECT a.*, ROUND( v.rating_sum / v.rating_count ) AS rating, v.rating_count, u.name AS author, u.usertype, s.name AS section, g.name AS groups, cc.name AS category"
	. "\n FROM #__content AS a"
	. "\n LEFT JOIN #__categories AS cc ON cc.id = a.catid"
	. "\n LEFT JOIN #__users AS u ON u.id = a.created_by"
	. "\n LEFT JOIN #__content_rating AS v ON a.id = v.content_id"
	. "\n LEFT JOIN #__sections AS s ON a.sectionid = s.id"
	. "\n LEFT JOIN #__groups AS g ON a.access = g.id"
	. ( count( $where ) ? "\n WHERE ".implode( "\n AND ", $where ) : '' )
	. "\n AND s.access <= ". $gid
	. "\n ORDER BY ". $order_pri . $order_sec;
	;
//	$database->setQuery( $query );
//	$rows = $database->loadObjectList();
	$rows = $database->doSQLget($query, 'mosExtendedContent');

	// Dynamic Page Title
	$mainframe->SetPageTitle( $menu->name );

	BlogOutput( $rows, $params, $gid, $access, $pop, $menu, null, $limit, $limitstart );
}

function showArchiveSection( $id=NULL, $gid, &$access, $pop, $option ) {
	global $database, $mainframe, $mosConfig_offset;
	global $Itemid;

	$noauth = !$mainframe->getCfg( 'shownoauth' );

	// Parameters
	$year 	= mosGetParam( $_REQUEST, 'year', date( 'Y' ) );
	$month 	= mosGetParam( $_REQUEST, 'month', date( 'm' ) );

	$params = new stdClass();
	if ( $Itemid ) {
		$menu = new mosMenu( $database );
		$menu->load( $Itemid );
		$params =& new mosParameters( $menu->params );
	} else {
		$menu = "";
		$params =& new mosParameters( '' );
	}

	$params->set( 'intro_only', 1 );
	$params->set( 'year', $year );
	$params->set( 'month', $month );

	// Ordering control
	$orderby_sec = $params->def( 'orderby_sec', 'rdate' );
	$orderby_pri = $params->def( 'orderby_pri', '' );
	$order_sec = _orderby_sec( $orderby_sec );
	$order_pri = _orderby_pri( $orderby_pri );

	// used in query
	$where = _where( -1, $access, $noauth, $gid, $id, NULL, $year, $month );

	// checks to see if 'All Sections' options used
	if ( $id == 0 ) {
		$check = '';
	} else {
		$check = 'AND a.sectionid = '. $id ;
	}
	// query to determine if there are any archived entries for the section
	$query = 	"SELECT a.id"
	. "\n FROM #__content as a"
	. "\n WHERE a.state = '-1'"
	. $check
	;
	$database->setQuery( $query );
	$items = $database->loadObjectList();
	$archives = count( $items );

	// Main Query
	$query = "SELECT a.*, ROUND(v.rating_sum/v.rating_count) AS rating, v.rating_count, u.name AS author, u.usertype, cc.name AS category, g.name AS groups"
	. "\n FROM #__content AS a"
	. "\n INNER JOIN #__categories AS cc ON cc.id = a.catid"
	. "\n LEFT JOIN #__users AS u ON u.id = a.created_by"
	. "\n LEFT JOIN #__content_rating AS v ON a.id = v.content_id"
	. "\n LEFT JOIN #__sections AS s ON a.sectionid = s.id"
	. "\n LEFT JOIN #__groups AS g ON a.access = g.id"
	. ( count( $where ) ? "\n WHERE ". implode( "\n AND ", $where ) : '')
	. "\n AND s.access <= ". $gid
	. "\n ORDER BY ". $order_pri . $order_sec
	;
//	$database->setQuery( $query );
//	$rows = $database->loadObjectList();
	$rows = $database->doSQLget($query, 'mosExtendedContent');

	// initiate form
 	echo '<form action="'.sefRelToAbs( 'index.php').'" method="post">';

	// Dynamic Page Title
	$mainframe->SetPageTitle( $menu->name );

	if ( !$archives ) {
		// if no archives for category, hides search and outputs empty message
		echo '<br /><div align="center">'. T_('There are currently no Archived Entries for this Category') .'</div>';
	} else {
		BlogOutput( $rows, $params, $gid, $access, $pop, $menu, 1 );
	}

 	echo '<input type="hidden" name="id" value="'. $id .'" />';
	echo '<input type="hidden" name="Itemid" value="'. $Itemid .'" />';
 	echo '<input type="hidden" name="task" value="archivesection" />';
 	echo '<input type="hidden" name="option" value="com_content" />';
 	echo '<input type="hidden" name="module" value="1" />';
 	echo '</form>';
}


function showArchiveCategory( $id=0, $gid, &$access, $pop, $option, $now ) {
	global $database, $mainframe, $mosConfig_offset;
	global $Itemid;

	// Parameters
	$noauth = !$mainframe->getCfg( 'shownoauth' );
	$year 	= mosGetParam( $_REQUEST, 'year', date( 'Y' ) );
	$month 	= mosGetParam( $_REQUEST, 'month', date( 'm' ) );
	$module = trim( mosGetParam( $_REQUEST, 'module', '' ) );

	// used by archive module
	if ( $module ) {
		$check = '';
	} else {
		$check = 'AND a.catid = '. $id;
	}

	if ( $Itemid ) {
		$menu = new mosMenu( $database );
		$menu->load( $Itemid );
		$params =& new mosParameters( $menu->params );
	} else {
		$menu = "";
		$params =& new mosParameters( '' );
	}

	$params->set( 'year', $year );
	$params->set( 'month', $month );

	// Ordering control
	$orderby_sec = $params->def( 'orderby', 'rdate' );
	$order_sec = _orderby_sec( $orderby_sec );

	// used in query
	$where = _where( -2, $access, $noauth, $gid, $id, NULL, $year, $month );

	// query to determine if there are any archived entries for the category
	$query = 	"SELECT a.id"
	. "\n FROM #__content as a"
	. "\n WHERE a.state = '-1'"
	. "\n ". $check
	;
	$database->setQuery( $query );
	$items = $database->loadObjectList();
	$archives = count( $items );

	$query = "SELECT a.*, ROUND( v.rating_sum / v.rating_count ) AS rating, v.rating_count, u.name AS author, u.usertype, s.name AS section, g.name AS groups"
	. "\n FROM #__content AS a"
	. "\n LEFT JOIN #__users AS u ON u.id = a.created_by"
	. "\n LEFT JOIN #__content_rating AS v ON a.id = v.content_id"
	. "\n LEFT JOIN #__sections AS s ON a.sectionid = s.id"
	. "\n LEFT JOIN #__groups AS g ON a.access = g.id"
	. ( count( $where ) ? "\n WHERE ". implode( "\n AND ", $where ) : '' )
	. "\n AND s.access <= ". $gid
	. "\n ORDER BY ". $order_sec
	;
//	$database->setQuery( $query );
//	$rows = $database->loadObjectList();
	$rows = $database->doSQLget($query, 'mosExtendedContent');

	// initiate form
 	echo '<form action="'.sefRelToAbs( 'index.php').'" method="post">';

	// Page Title
	$mainframe->SetPageTitle( $menu->name );

	if ( !$archives ) {
		// if no archives for category, hides search and outputs empty message
		echo '<br /><div align="center">'. T_('There are currently no Archived Entries for this Category') .'</div>';
	} else {
		BlogOutput( $rows, $params, $gid, $access, $pop, $menu, 1 );
	}

 	echo '<input type="hidden" name="id" value="'. $id .'" />';
	echo '<input type="hidden" name="Itemid" value="'. $Itemid .'" />';
 	echo '<input type="hidden" name="task" value="archivecategory" />';
 	echo '<input type="hidden" name="option" value="com_content" />';
 	echo '<input type="hidden" name="module" value="1" />';
 	echo '</form>';
}


function BlogOutput ( &$rows, &$params, $gid, &$access, $pop, &$menu, $archive=NULL, $limit = 0, $limitstart = 0  ) {
	global $mainframe, $Itemid, $task, $id, $option, $database, $mosConfig_live_site;

	// parameters
	if ( $params->get( 'page_title', 1 ) && $menu) {
		$header = $params->def( 'header', $menu->name );
	} else {
		$header = '';
	}
	$columns = $params->def( 'columns', 2 );
	if ( $columns == 0 ) {
		$columns = 1;
	}
	$intro 				= $params->def( 'intro', 4 );
	$leading 				= $params->def( 'leading', 1 );
	$links 				= $params->def( 'link', 4 );
	$pagination 			= $params->def( 'pagination', 2 );
	$pagination_results 	= $params->def( 'pagination_results', 1 );
	$pagination_results 	= $params->def( 'pagination_results', 1 );
	$descrip		 		= $params->def( 'description', 1 );
	$descrip_image	 		= $params->def( 'description_image', 1 );
	// needed for back button for page
	$back 				= $params->get( 'back_button', $mainframe->getCfg( 'back_button' ) );
	// needed to disable back button for item
	$params->set( 'back_button', 0 );
	$params->def( 'pageclass_sfx', '' );
	$params->set( 'intro_only', 1 );

	$total = count( $rows );

	// pagination support
	if (!$limitstart){
	$limitstart = intval( mosGetParam( $_REQUEST, 'limitstart', 0 ) );
    }
	$limit = $intro + $leading + $links;
	if ( $total <= $limit ) {
		$limitstart = 0;
	}
	$i = $limitstart;

	// needed to reduce queries used by getItemid
	require_once(mamboCore::get('mosConfig_absolute_path').'/components/com_content/content.class.php');
	$handler =& new contentHandler();
	$ItemidCount['bs'] 		= $handler->getBlogSectionCount();
	$ItemidCount['bc'] 		= $handler->getBlogCategoryCount();
	$ItemidCount['gbs'] 	= $handler->getGlobalBlogSectionCount();

	// used to display section/catagory description text and images
	// currently not supported in Archives
	if ( $menu && $menu->componentid && ( $descrip || $descrip_image ) ) {
		switch ( $menu->type ) {
			case 'content_blog_section':
				$description = new mosSection( $database );
				$description->load( $menu->componentid );
				break;

			case 'content_blog_category':
				$description = new mosCategory( $database );
				$description->load( $menu->componentid );
				break;

			default:
				$menu->componentid = 0;
				break;
		}
	}

	// Page Output
	// page header
	if ( $header ) {
		echo '<div class="componentheading'. $params->get( 'pageclass_sfx' ) .'">'. $header .'</div>';
	}

	if ( $archive ) {
		echo '<br />';
		echo mosHTML::monthSelectList( 'month', 'size="1" class="inputbox"', $params->get( 'month' ) );
		echo mosHTML::integerSelectList( 2000, 2010, 1, 'year', 'size="1" class="inputbox"', $params->get( 'year' ), "%04d" );
		echo '<input type="submit" class="button" />';
	}

	// checks to see if there are there any items to display
	if ( $total ) {
		$col_with = 100 / $columns;			// width of each column
		$width = 'width="'. $col_with .'%"';

		if ( $archive ) {
			// Search Success message
			$msg = sprintf( T_('Here are the Archived entries for %s %s'), $params->get( 'month' ), $params->get( 'year' ) );
			echo "<br /><br /><div align='center'>". $msg ."</div><br /><br />";
		}
		echo '<table class="blog' . $params->get( 'pageclass_sfx' ) . '" cellpadding="0" cellspacing="0">';

		// Secrion/Category Description & Image
		if ( $menu && $menu->componentid && ( $descrip || $descrip_image ) ) {
			$link = $mosConfig_live_site .'/images/stories/'. $description->image;
			echo '<tr>';
			echo '<td valign="top">';
			if ( $descrip_image && $description->image ) {
				echo '<img src="'. $link .'" align="'. $description->image_position .'" hspace="6" alt="" />';
			}
			if ( $descrip && $description->description ) {
				echo $description->description;
			}
			echo '<br /><br />';
			echo '</td>';
			echo '</tr>';
		}

		// Leading story output
		if ( $leading ) {
			echo '<tr>';
			echo '<td valign="top">';
			for ( $z = 0; $z < $leading; $z++ ) {
				if ( $i >= $total ) {
					// stops loop if total number of items is less than the number set to display as leading
					break;
				}
				echo '<div>';
				show( $rows[$i], $params, $gid, $access, $pop, $option, $ItemidCount );
				echo '</div>';
				$i++;
			}
			echo '</td>';
			echo '</tr>';
		}

		if ( $intro && ( $i < $total ) ) {
			echo '<tr>';
			echo '<td valign="top">';
			echo '<table width="100%"  cellpadding="0" cellspacing="0">';
			// intro story output
			for ( $z = 0; $z < $intro; $z++ ) {
				if ( $i >= $total ) {
					// stops loop if total number of items is less than the number set to display as intro + leading
					break;
				}

				if ( !( $z % $columns ) || $columns == 1 ) {
					echo '<tr>';
				}

				echo '<td valign="top" '. $width .'>';

				// outputs either intro or only a link
				if ( $z < $intro ) {
					show( $rows[$i], $params, $gid, $access, $pop, $option, $ItemidCount );
				} else {
					echo '</td>';
					echo '</tr>';
					break;
				}

				echo '</td>';

				if ( !( ( $z + 1 ) % $columns ) || $columns == 1 ) {
					echo '</tr>';
				}

				$i++;
			}

			// this is required to output a final closing </tr> tag when the number of items does not fully
			// fill the last row of output - a blank column is left
			if ( $intro % $columns ) {
				echo '</tr>';
			}

			echo '</table>';
			echo '</td>';
			echo '</tr>';
		}

		// Links output
		if ( $links && ( $i < $total )  ) {
			echo '<tr>';
			echo '<td valign="top">';
			echo '<div class="blog_more'. $params->get( 'pageclass_sfx' ) .'">';
			HTML_content::showLinks( $rows, $links, $total, $i, 1, $ItemidCount );
			echo '</div>';
			echo '</td>';
			echo '</tr>';
		}

		// Pagination output
		if ( $pagination ) {
			if ( ( $pagination == 2 ) && ( $total <= $limit ) ) {
				// not visible when they is no 'other' pages to display
			} else {
				// get the total number of records
				$limitstart = $limitstart ? $limitstart : 0;
				require_once( $GLOBALS['mosConfig_absolute_path'] . '/includes/pageNavigation.php' );
				$pageNav = new mosPageNav( $total, $limitstart, $limit );
				if ( $option == 'com_frontpage' ) {
					$link = 'index.php?option=com_frontpage&amp;Itemid='. $Itemid;
				} else if ( $archive ) {
					$year = $params->get( 'year' );
					$month = $params->get( 'month' );
					$link = 'index.php?option=com_content&amp;task='. $task .'&amp;id='. $id .'&amp;Itemid='. $Itemid.'&amp;year='. $year .'&amp;month='. $month;
				} else {
					$link = 'index.php?option=com_content&amp;task='. $task .'&amp;id='. $id .'&amp;Itemid='. $Itemid;
				}
				echo '<tr>';
				echo '<td valign="top" align="center">';
				echo $pageNav->writePagesLinks( $link );
				echo '<br /><br />';
				echo '</td>';
				echo '</tr>';
				if ( $pagination_results ) {
					echo '<tr>';
					echo '<td valign="top" align="center">';
					echo $pageNav->writePagesCounter();
					echo '</td>';
					echo '</tr>';
				}
			}
		}

		echo '</table>';

	} else if ( $archive && !$total ) {
		// Search Failure message for Archives
		$msg = sprintf( T_('There are no Archived entries for %s %s'), $params->get( 'month' ), $params->get( 'year' ) );
		echo '<br /><br /><div align="center">'. $msg .'</div><br />';
	} else {
		// Generic blog empty display
		echo T_('There are no items to display');
	}

	// Back Button
	$params->set( 'back_button', $back );
	mosHTML::BackButton ( $params );
}


function showItem( $uid, $gid, &$access, $pop, $option, $now ) {
	global $database, $mainframe;
	global $mosConfig_offset, $mosConfig_live_site, $mosConfig_MetaTitle, $mosConfig_MetaAuthor;

	if ( $access->canEdit ) {
		$xwhere='';
	} else {
		$xwhere = "AND (a.state = '1' OR a.state = '-1')"
		. "\n	AND (publish_up = '0000-00-00 00:00:00' OR publish_up <= '$now')"
		. "\n	AND (publish_down = '0000-00-00 00:00:00' OR publish_down >= '$now')"
		;
	}

	global $acl;
	$viewAccess = ($gid >= $acl->get_group_id( 'Registered', 'ARO' ) ? 1 : 0) + ($gid >= $acl->get_group_id( 'Author', 'ARO' ) ? 1 : 0);
	$query = "SELECT a.*, ROUND(v.rating_sum/v.rating_count) AS rating, v.rating_count, u.name AS author, u.usertype, cc.name AS category, s.name AS section, g.name AS groups"
	. "\n FROM #__content AS a"
	. "\n LEFT JOIN #__categories AS cc ON cc.id = a.catid"
	. "\n LEFT JOIN #__sections AS s ON s.id = cc.section AND s.scope='content'"
	. "\n LEFT JOIN #__users AS u ON u.id = a.created_by"
	. "\n LEFT JOIN #__content_rating AS v ON a.id = v.content_id"
	. "\n LEFT JOIN #__groups AS g ON a.access = g.id"
	. "\n WHERE a.id='". $uid ."' ". $xwhere
	. "\n AND a.access <= ". $viewAccess
	;
	$database->setQuery( $query );
	$row = new mosExtendedContent();

	if ( $database->loadObject( $row ) ) {
		$pathway =& mosPathway::getInstance();
		$pathway->addItem($row->category, categoryURL($row->sectionid, $row->catid));
		$pathway->addItem($row->title, '');
		$params =& new mosParameters( $row->attribs );
		$params->set( 'intro_only', 0 );
		$params->def( 'back_button', $mainframe->getCfg( 'back_button' ) );
		if ( $row->sectionid == 0) {
			$params->set( 'item_navigation', 0 );
		} else {
			$params->set( 'item_navigation', $mainframe->getCfg( 'item_navigation' ) );
		}
		// loads the links for Next & Previous Button
		if ( $params->get( 'item_navigation' ) ) {
			$query = "SELECT a.id"
			. "\n FROM #__content AS a"
			. "\n WHERE a.catid = ". $row->catid.""
			. "\n AND a.state = $row->state AND ordering < $row->ordering"
			. ($access->canEdit ? "" : "\n AND a.access <= '". $gid ."'" )
			. "\n AND ( a.publish_up = '0000-00-00 00:00:00' OR a.publish_up <= '". $now ."' )"
			. "\n AND ( a.publish_down = '0000-00-00 00:00:00' OR a.publish_down >= '". $now ."' )"
			. "\n ORDER BY a.ordering DESC"
			. "\n LIMIT 1"
			;
			$database->setQuery( $query );
			$row->prev = $database->loadResult();

			$query = "SELECT a.id"
			. "\n FROM #__content AS a"
			. "\n WHERE a.catid = ". $row->catid.""
			. "\n AND a.state = $row->state AND ordering > $row->ordering"
			. ($access->canEdit ? "" : "\n AND a.access <= '". $gid ."'" )
			. "\n AND ( a.publish_up = '0000-00-00 00:00:00' OR a.publish_up <= '". $now ."' )"
			. "\n AND ( a.publish_down = '0000-00-00 00:00:00' OR a.publish_down >= '". $now ."' )"
			. "\n ORDER BY a.ordering"
			. "\n LIMIT 1"
			;
			$database->setQuery( $query );
			$row->next = $database->loadResult();
		}
		// page title
		$mainframe->setPageTitle( $row->title );
		if ($mosConfig_MetaTitle=='1') {
			$mainframe->addMetaTag( 'title' , $row->title );
		}
		if ($mosConfig_MetaAuthor=='1') {
			$mainframe->addMetaTag( 'author' , $row->author );
		}

		show( $row, $params, $gid, $access, $pop, $option );
	} else {
		mosNotAuth();
		return;
	}
}


function show( $row, $params, $gid, &$access, $pop, $option, $ItemidCount=NULL ) {
	global $database, $mainframe, $Itemid;
	global $mosConfig_live_site, $mosConfig_absolute_path;
	global $options, $task;

	//$cache = mosCache::getCache('com_content','Output');

	$noauth = !$mainframe->getCfg( 'shownoauth' );

	if ( $access->canEdit ) {
		if ( $row->id === null || $row->access > $gid ) {
			mosNotAuth();
			return;
		}
	} else {
		if ( $row->id === null || $row->state == 0 ) {
			mosNotAuth();
			return;
		}
		if ( $row->access > $gid ) {
			if ( $noauth ) {
				mosNotAuth();
				return;
			} else {
				if ( !( $params->get( 'intro_only' ) ) ) {
					mosNotAuth();
					return;
				}
			}
		}
	}

	// GC Parameters
	$params->def( 'link_titles', $mainframe->getCfg( 'link_titles' ) );
	$params->def( 'author', !$mainframe->getCfg( 'hideAuthor' ) );
	$params->def( 'createdate', !$mainframe->getCfg( 'hideCreateDate' ) );
	$params->def( 'modifydate', !$mainframe->getCfg( 'hideModifyDate' ) );
	$params->def( 'print', !$mainframe->getCfg( 'hidePrint' ) );
	$params->def( 'pdf', !$mainframe->getCfg( 'hidePdf' ) );
	$params->def( 'email', !$mainframe->getCfg( 'hideEmail' ) );
	$params->def( 'rating', $mainframe->getCfg( 'vote' ) );
	$params->def( 'icons', $mainframe->getCfg( 'icons' ) );
	$params->def( 'readmore', $mainframe->getCfg( 'readmore' ) );
	// Other Params
	$params->def( 'image', 1 );
	$params->def( 'section', 0 );
	$params->def( 'section_link', 0 );
	$params->def( 'category', 0 );
	$params->def( 'category_link', 0 );
	$params->def( 'introtext', 1 );
	$params->def( 'pageclass_sfx', '' );
	$params->def( 'item_title', 1 );
	$params->def( 'url', 1 );

	// loads the link for Section name
	if ( $params->get( 'section_link' ) ) {
		$query =     "SELECT a.id"
		. "\n FROM #__menu AS a"
		. "\n WHERE a.componentid = '". $row->sectionid."'"
		. "\n AND a.type = 'content_section'"
		. "\n AND a.published = 1"
		;
		$database->setQuery( $query );
		$_Itemid = $database->loadResult();
		if (!intval($_Itemid))
            	$_Itemid = intval($Itemid) ? intval($Itemid) : 1;
		$link = sefRelToAbs( 'index.php?option=com_content&amp;task=section&amp;id='. $row->sectionid .'&amp;Itemid='.$_Itemid );
		$row->section = '<a href="'. $link .'">'. $row->section .'</a>';
	}

	// loads the link for Category name
	if ( $params->get( 'category_link' ) ) {
		$query = 	"SELECT a.id"
		. "\n FROM #__menu AS a"
		. "\n WHERE a.componentid = ". $row->catid.""
		. "\n AND a.type = 'content_category'"
		. "\n AND a.published = 1"
		;
		$database->setQuery( $query );
		$_Itemid = $database->loadResult();
		if (!intval($_Itemid))
            	$_Itemid = intval($Itemid) ? intval($Itemid) : 1;
		$link = sefRelToAbs( 'index.php?option=com_content&amp;task=section&amp;id='. $row->sectionid .'&amp;Itemid='.$_Itemid );
		$link = sefRelToAbs( 'index.php?option=com_content&amp;task=category&amp;sectionid='. $row->sectionid .'&amp;id='. $row->catid .'&amp;Itemid='.$_Itemid );
		$row->category = '<a href="'. $link .'">'. $row->category .'</a>';
	}

	// loads current template for the pop-up window
	$template = '';
	if ( $pop ) {
		$params->set( 'popup', 1 );
		$database->setQuery( "SELECT template FROM #__templates_menu WHERE client_id='0' AND menuid='0'" );
		$template = $database->loadResult();
	}

	// show/hides the intro text
	if ( $params->get( 'introtext'  ) ) {
		$row->text = $row->introtext. ( $params->get( 'intro_only' ) ? '' : chr(13) . chr(13) . $row->fulltext);
	} else {
		$row->text = $row->fulltext;
	}

	// deal with the {mospagebreak} mambots
	// only permitted in the full text area
    $page = intval( mosGetParam( $_REQUEST, 'limitstart', 0 ) );

	// record the hit
	if ( !$params->get( 'intro_only' ) ) {
		$obj = new mosContent( $database );
		$obj->hit( $row->id );
	}
    //if(!($cache->start($task.$row->id.$page,'com_content'))){
        HTML_content::show( $row, $params, $access, $page, $option, $ItemidCount );
    //    $cache->end();
    //}
}


function editItem( $uid, $gid, &$access, $sectionid=0, $task, $Itemid ){
	global $database, $mainframe, $my;
	global $mosConfig_absolute_path, $mosConfig_live_site;

	$row = new mosContent( $database );
	// load the row from the db table
	$row->load( $uid );

	// fail if checked out not by 'me'
	if ( $row->checked_out && $row->checked_out <> $my->id ) {
		echo"<script>alert('".sprintf(T_('The module [ %s ] is currently being edited by another person.'), $row->title)."'); window.history.go(-1); </script>";
		exit;
	}

	if ( $uid ) {
		// existing record
		if ( !( $access->canEdit || ( $access->canEditOwn && $row->created_by == $my->id ) ) ) {
			mosNotAuth();
			return;
		}
	} else {
		// new record
		if (!($access->canEdit || $access->canEditOwn)) {
			mosNotAuth();
			return;
		}
	}

	if ( $uid ) {
		$sectionid = $row->sectionid;
	}

	$lists = array();

	// get the type name - which is a special category
	$query = "SELECT name FROM #__sections WHERE id='$sectionid'";
	$database->setQuery( $query );
	$section = $database->loadResult();

	if ( $uid == 0 ) {
		$row->catid = 0;
	}

	if ( $uid ) {
		$row->checkout( $my->id );
		if (trim( $row->publish_down ) == "0000-00-00 00:00:00") {
			$row->publish_down = 'Never';
		}
		if (trim( $row->images )) {
			$row->images = explode( "\n", $row->images );
		} else {
			$row->images = array();
		}
		$query = "SELECT name from #__users"
		. "\n WHERE id = ". $row->created_by
		;
		$database->setQuery( $query	);
		$row->creator = $database->loadResult();

		$query = "SELECT name from #__users"
		. "\n WHERE id = ". $row->modified_by
		;
		$database->setQuery( $query );
		$row->modifier = $database->loadResult();

		$query = "SELECT content_id from #__content_frontpage"
		."\n WHERE content_id = ". $row->id
		;
		$database->setQuery( $query );
		$row->frontpage = $database->loadResult();
	} else {
		$row->sectionid 	= $sectionid;
		$row->version 		= 0;
		$row->state 		= 0;
		$row->ordering 		= 0;
		$row->images 		= array();
		$row->publish_up 	= date( 'Y-m-d', time() );
		$row->publish_down 	= 'Never';
		$row->creator 		= 0;
		$row->modifier 		= 0;
		$row->frontpage 	= 0;
	}

	// calls function to read image from directory
	$pathA 		= $mosConfig_absolute_path .'/images/stories';
	$pathL 		= $mosConfig_live_site .'/images/stories';
	$images 	= array();
	$folders 	= array();
	$folders[] 	= mosHTML::makeOption( '/' );
	require_once($mosConfig_absolute_path.'/administrator/includes/mosAdminMenus.php');
	mosAdminMenus::ReadImages( $pathA, '/', $folders, $images );
	// list of folders in images/stories/
	$lists['folders'] 		= mosAdminMenus::GetImageFolders( $folders, $pathL );
	// list of images in specfic folder in images/stories/
	$lists['imagefiles']	= mosAdminMenus::GetImages( $images, $pathL );
	// list of saved images
	$lists['imagelist'] 	= mosAdminMenus::GetSavedImages( $row, $pathL );

	// make the select list for the states
	$states[] = mosHTML::makeOption( 0, T_('Unpublished') );
	$states[] = mosHTML::makeOption( 1, T_('Published') );
	$lists['state'] = mosHTML::selectList( $states, 'state', 'class="inputbox" size="1"', 'value', 'text', intval( $row->state ) );

	// build the html select list for ordering
	$query = "SELECT ordering AS value, title AS text"
	. "\n FROM #__content"
	. "\n WHERE catid = '$row->catid'"
	. "\n ORDER BY ordering"
	;
	$lists['ordering'] 		= mosAdminMenus::SpecificOrdering( $row, $uid, $query, 1 );
	// build list of categories
	$lists['catid'] 		= mosAdminMenus::ComponentCategory( 'catid', $sectionid, intval( $row->catid ) );
	// build the select list for the image positions
	$lists['_align'] 		= mosAdminMenus::Positions( '_align' );
    // build the select list for the image caption alignment
    $lists['_caption_align']     = mosAdminMenus::Positions( '_caption_align' );	
	// build the html select list for the group access
	$lists['access'] 		= mosAdminMenus::Access( $row );
	
	// build the select list for the image caption position
	$pos[] = mosHTML::makeOption( 'bottom', _CMN_BOTTOM );
	$pos[] = mosHTML::makeOption( 'top', _CMN_TOP );
	$lists['_caption_position'] = mosHTML::selectList( $pos, '_caption_position', 'class="inputbox" size="1"', 'value', 'text' );
	
	HTML_content::editContent( $row, $section, $lists, $images, $access, $my->id, $sectionid, $task, $Itemid );
}


/**
* Saves the content item an edit form submit
*/
function saveContent( &$access ) {
	global $database, $mainframe, $my;
	global $mosConfig_absolute_path;

	$row = new mosContent( $database );
	if ( !$row->bind( $_POST ) ) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	// sanitize
	$row->id = intval($row->id);
	$row->catid = intval($row->catid);
	$row->sectionid = intval($row->sectionid);
	$isNew = $row->id < 1;
	if ( $isNew ) {
		// new record
		if ( !( $access->canEdit || $access->canEditOwn ) ) {
			mosNotAuth();
			return;
		}
		$row->created = date( 'Y-m-d H:i:s' );
		$row->created_by = $my->id;
	} else {
		// existing record
		if ( !( $access->canEdit || ( $access->canEditOwn && $row->created_by == $my->id ) ) ) {
			mosNotAuth();
			return;
		}
		$row->modified = date( 'Y-m-d H:i:s' );
		$row->modified_by = $my->id;
	}
	if ( trim( $row->publish_down ) == 'Never' ) {
		$row->publish_down = '0000-00-00 00:00:00';
	}

	if (!$row->check()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	$row->version++;
	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}

	// manage frontpage items
	require_once( $mainframe->getPath( 'class', 'com_frontpage' ) );
	$fp = new mosFrontPage( $database );

	if ( mosGetParam( $_REQUEST, 'frontpage', 0 ) ) {

		// toggles go to first place
		if (!$fp->load( $row->id )) {
			// new entry
			$database->setQuery( "INSERT INTO #__content_frontpage VALUES ('$row->id','1')" );
			if (!$database->query()) {
				echo "<script> alert('".$database->stderr()."');</script>\n";
				exit();
			}
			$fp->ordering = 1;
		}
	} else {
		// no frontpage mask
		if ( !$fp->delete( $row->id ) ) {
			$msg .= $fp->stderr();
		}
		$fp->ordering = 0;
	}
	$fp->updateOrder();

	$row->checkin();
	$row->updateOrder( "catid='$row->catid'" );

	// gets section name of item
	$database->setQuery( "SELECT s.title"
	. "\n FROM #__sections AS s"
	. "\n WHERE s.scope = 'content'"
	. "\n AND s.id = '". $row->sectionid ."'"
	);
	// gets category name of item
	$section = $database->loadResult();
	$database->setQuery( "SELECT c.title"
	. "\n FROM #__categories AS c"
	. "\n WHERE c.id = '". $row->catid ."'"
	);
	$category = $database->loadResult();

	if ( $isNew ) {
		// messaging for new items
		require_once( $mosConfig_absolute_path .'/components/com_messages/messages.class.php' );
		$database->setQuery( "SELECT id FROM #__users WHERE sendEmail = '1'" );
		$users = $database->loadResultArray();
		if ($users) {
			foreach ($users as $user_id) {
				$msg = new mosMessage( $database );
				$msg->send( $my->id, $user_id, T_("New Item"), sprintf( T_('A new content item has been submitted by [ %s ]  titled [ %s ]  from section [ %s ]  and category  [ %s ]'), $my->username, $row->title, $section, $category ) );
			}
		}
	}
 	$Itemid 	= mosGetParam( $_POST, 'Returnid', '0' );
 	$msg 	= $isNew ? T_('Thanks for your submission; it will be reviewed before being posted to the site.') : T_('Item saved successfully.');
	
	$link = $isNew ? 'index.php' : sefRelToAbs( 'index.php?option=com_content&task=view&id='.$row->id.'&Itemid='.$Itemid );
	mosRedirect( $link, $msg);
}


/**
* Cancels an edit operation
* @param database A database connector object
*/
function cancelContent( &$access ) {
	global $database, $mainframe, $my;

	$row = new mosContent( $database );
	$row->bind( $_POST );
	// sanitize
	$row->id = intval($row->id);

	if ( $access->canEdit || ( $access->canEditOwn && $row->created_by == $my->id ) ) {
		$row->checkin();
	}

	$Itemid = mosGetParam( $_POST, 'Returnid', '0' );

	$link = sefRelToAbs( 'index.php?option=com_content&task=view&id='.$row->id.'&Itemid='.$Itemid );
	mosRedirect( $link );
}

/**
* Shows the email form for a given content item.
*/
function emailContentForm( $uid ) {
	global $database, $mainframe, $my;
	$row = new mosContent( $database );
	$row->load( $uid );

	if ( $row->id === null || $row->access > $my->gid ) {
		mosNotAuth();
		return;
	} else {
		$template='';
		$database->setQuery( "SELECT template FROM #__templates_menu WHERE client_id = '0' AND menuid = '0'" );
		$template = $database->loadResult();
		HTML_content::emailForm( $row->id, $row->title, $template );
	}

}


/**
* Shows the email form for a given content item.
*/
function emailContentSend( $uid ) {
	global $database, $mainframe;
	global $mosConfig_live_site, $mosConfig_sitename;
	global $mosConfig_mailfrom, $mosConfig_fromname;

	$_Itemid = $mainframe->getItemid( $uid, 0, 0  );

	$email = trim( mosGetParam( $_POST, 'email', '' ) );
	$yourname = trim( mosGetParam( $_POST, 'yourname', '' ) );
	$youremail = trim( mosGetParam( $_POST, 'youremail', '' ) );
	$subject_default = sprintf(T_('Item sent by %s'), $yourname);
	$subject = trim( mosGetParam( $_POST, 'subject', $subject_default ) );
	
	mos_session_start();
	$form_check = mosGetParam( $_POST, 'form_check', '' );
    if (empty($_SESSION['_form_check_']['com_content']) || $form_check != $_SESSION['_form_check_']['com_content']) {
      // the form hasn't been generated by the server on this session
       exit;
    }
	if ( !$email || !$youremail || ( is_email( $email ) == false ) || ( is_email( $youremail ) == false ) ) {
		echo "<script>alert (\"".T_('You must enter valid e-mail addresses for both yourself and your recipient.')."\"); window.history.go(-1);</script>";
		exit(0);
	}

	$template='';
	$database->setQuery( "SELECT template FROM #__templates_menu WHERE client_id='0' AND menuid='0'" );
	$template = $database->loadResult();

	// link sent in email
	$link = sefRelToAbs( $mosConfig_live_site .'/index.php?option=com_content&task=view&id='. $uid .'&Itemid='. $_Itemid );
	// message text
	$msg = sprintf( T_(' The following page from the \"%s\" website has been sent to you by %s ( %s ).\n\nYou can access it at the following url:\n%s'), $mosConfig_sitename, $yourname, $youremail, $link );

	// mail function
	mosMail( $mosConfig_mailfrom, $mosConfig_fromname, $email, $subject, $msg );

	HTML_content::emailSent( $email, $template );
}

function is_email( $email ){
	$rBool = false;

	if ( preg_match( "/[\w\.\-]+@\w+[\w\.\-]*?\.\w{1,4}/", $email ) ) {
		$rBool = true;
	}
	return $rBool;
}

function recordVote() {
    global $database, $mosConfig_live_site, $mosConfig_offset, $acl, $gid;

    $user_rating = mosGetParam( $_REQUEST, 'user_rating', 0 );
    $cid = mosGetParam( $_REQUEST, 'cid', 0 );
    $cid = intval( $cid );
    $Itemid = mosGetParam( $_REQUEST, 'Itemid', 0 );
    $Itemid = intval( $Itemid );
    $user_rating = intval( $user_rating );
    $now = date( 'Y-m-d H:i:s', time() + $mosConfig_offset * 60 * 60 );
    $viewAccess = ($gid >= $acl->get_group_id( 'Registered', 'ARO' ) ? 1 : 0) + ($gid >= $acl->get_group_id( 'Author', 'ARO' ) ? 1 : 0);

    $url = sefReltoAbs("index.php?option=com_content&task=view&id={$cid}&Itemid={$Itemid}");
    if ( ( $user_rating >= 1 ) and ( $user_rating <= 5 ) ) {
        $currip = getenv( 'REMOTE_ADDR' );

        $query = "SELECT * FROM #__content as c WHERE id = $cid AND (c.state = '1' OR c.state = '-1')"
        . "\n   AND (c.publish_up = '0000-00-00 00:00:00' OR c.publish_up <= '$now')"
        . "\n   AND (c.publish_down = '0000-00-00 00:00:00' OR c.publish_down >= '$now')"
        . "\n AND access <= ". $viewAccess;
        ;
        $database->setQuery( $query );
        $database->loadObject( $row );
        if ( $row != NULL){
            $query = "SELECT * FROM #__content_rating WHERE content_id = $cid";
            $database->setQuery( $query );
            $votesdb = NULL;
            if ( !( $database->loadObject( $votesdb ) ) ) {
                $query = "INSERT INTO #__content_rating ( content_id, lastip, rating_sum, rating_count )"
                . "\n VALUES ( '$cid', '$currip', '$user_rating', '1' )";
                $database->setQuery( $query );
                $database->query() or die( $database->stderr() );;
            } else {
                if ($currip <> ($votesdb->lastip)) {
                    $query = "UPDATE #__content_rating"
                    . "\n SET rating_count = rating_count + 1,"
                    . "\n rating_sum = rating_sum + $user_rating,"
                    . "\n lastip = '$currip'"
                    . "\n WHERE content_id = ". $cid
                    ;
                    $database->setQuery( $query );
                    $database->query() or die( $database->stderr() );
                } else {
                    mosRedirect ( $url, T_('You already voted for this poll today!') );
                }
            }
            mosRedirect ( $url, T_('Thanks for your vote!') );
        } else {
            mosRedirect ( $url, T_('The rating for this item is not allowed!') );
        }
    }
}


function _orderby_pri( $orderby ) {
	switch ( $orderby ) {
		case 'alpha':
			$orderby = 'cc.title, ';
			break;
		case 'ralpha':
			$orderby = 'cc.title DESC, ';
			break;
		case 'order':
			$orderby = 'cc.ordering, ';
			break;
		default:
			$orderby = '';
			break;
	}

	return $orderby;
}


function _orderby_sec( $orderby ) {
	switch ( $orderby ) {
		case 'date':
			$orderby = 'a.created';
			break;
		case 'rdate':
			$orderby = 'a.created DESC';
			break;
		case 'alpha':
			$orderby = 'a.title';
			break;
		case 'ralpha':
			$orderby = 'a.title DESC';
			break;
		case 'hits':
			$orderby = 'a.hits DESC';
			break;
		case 'rhits':
			$orderby = 'a.hits ASC';
			break;
		case 'order':
			$orderby = 'a.ordering';
			break;
		case 'author':
			$orderby = 'a.created_by, u.name';
			break;
		case 'rauthor':
			$orderby = 'a.created_by DESC, u.name DESC';
			break;
		case 'front':
			$orderby = 'f.ordering';
			break;
		default:
			$orderby = 'a.ordering';
			break;
	}

	return $orderby;
}

/*
* @param int 0 = Archives, 1 = Section, 2 = Category
*/
function _where( $type=1, &$access, &$noauth, $gid, $id, $now=NULL, $year=NULL, $month=NULL ) {
	$where = array();

	// normal
	if ( $type > 0) {
		$where[] = "a.state = '1'";
		if ( !$access->canEdit ) {
			$where[] = "( a.publish_up = '0000-00-00 00:00:00' OR a.publish_up <= '". $now ."' )";
			$where[] = "( a.publish_down = '0000-00-00 00:00:00' OR a.publish_down >= '". $now ."' )";
		}
		if ( $noauth ) {
			$where[] = "a.access <= '". $gid ."'";
		}
		if ( $id > 0 ) {
			if ( $type == 1 ) {
				$where[] = "a.sectionid IN ( ". $id ." ) ";
			} else if ( $type == 2 ) {
				$where[] = "a.catid IN ( ". $id ." ) ";
			}
		}
	}

	// archive
	if ( $type < 0 ) {
		$where[] = "a.state='-1'";
		if ( $year ) {
			$where[] = "YEAR( a.created ) = '". $year ."'";
		}
		if ( $month ) {
			$where[] = "MONTH( a.created ) = '". $month ."'";
		}
		if ( $noauth ) {
			$where[] = "a.access <= '". $gid ."'";
		}
		if ( $id > 0 ) {
			if ( $type == -1 ) {
				$where[] = "a.sectionid = '". $id ."'";
			} else if ( $type == -2) {
				$where[] = "a.catid = '". $id ."'";
			}
		}
	}

	return $where;
}

function sectionURL ($sectionid) {
    $menuHandler = mosMenuHandler::getInstance();
	$Itemid = $menuHandler->getSectionItemId($sectionid);
	return "index.php?option=com_content&task=section&id=$sectionid&Itemid=$Itemid";
}

function categoryURL ($sectionid, $catid) {
    $menuHandler = mosMenuHandler::getInstance();
	$Itemid = $menuHandler->getCategoryItemId($catid);
	return "index.php?option=com_content&task=category&sectionid=$sectionid&id=$catid&Itemid=$Itemid";
}

?>
