<?php
/**
* @package Mambo
* @author Mambo Foundation Inc see README.php
* @copyright Mambo Foundation Inc.
* See COPYRIGHT.php for copyright notices and details.
* @license GNU/GPL Version 2, see LICENSE.php
* Mambo is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; version 2 of the License.
*/

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

global $mosConfig_absolute_path, $mosConfig_usecaptcha, $task, $acl, $mainframe, $mosConfig_offset;
// work-around for validating config.comment.php
require_once($mosConfig_absolute_path."/administrator/components/com_comment/class.comment.php");
$config = new mosCommentConfig();
$auto_publish_comments = $config->auto_publish_comments;
$allow_anonymous_entries = $config->allow_anonymous_entries;
$notify_new_entries = $config->notify_new_entries;
$allow_comments_in_sections = $config->allow_comments_in_sections;
$comments_per_page = $config->comments_per_page;
$admin_comments_length = $config->admin_comments_length;
unset($config);

$option = mosGetParam($_POST, 'option', 'com_comment');
$mcitemid = intval(mosGetParam($_POST, 'mcitemid', 0));
$articleid = intval(mosGetParam($_POST, 'articleid', 0));
$func = mosGetParam($_POST, 'func', '');
$limit = intval(mosGetParam($_POST, 'limit', ''));
$limitstart = intval(mosGetParam($_POST, 'limitstart', ''));
$mcname = mosGetParam($_POST, 'mcname', '');
$comments = mosGetParam($_POST, 'comments', '');
$spamstop = mosGetParam($_POST, 'spamstop', '');

# valid user check
$is_user   = (strtolower($my->usertype) <> '');
$captcha_success = 0; // captcha not required

if ($task == "captcha-audio"){
   @ob_end_clean();
   ob_start();
   include ($mosConfig_absolute_path."/includes/captcha-audio.php");
   ob_end_flush();
   exit(0);
   
}

if ($mosConfig_usecaptcha == '1') {
	# spam protection
	mos_session_start();

	if(isset($_SESSION['captcha_code']) && ($_SESSION['captcha_code'] != "") && ($_SESSION['captcha_code'] == $spamstop)) {
		$captcha_success = 1; // success
	} else {
		$captcha_success = 2; // fail
	}
}

if ($captcha_success != '2') {

	# if registered users only
	if (!$allow_anonymous_entries AND !$is_user) {

		$link = sefRelToAbs("index.php?option=content&task=view&id=$articleid");
		echo "<SCRIPT>alert('".T_('Please register to add comments')."'); document.location.href='".$link."';</SCRIPT>";

	} else {
        $noauth = !$mainframe->getCfg( 'shownoauth' );
        $viewAccess = ($gid >= $acl->get_group_id( 'Registered', 'ARO' ) ? 1 : 0) + ($gid >= $acl->get_group_id( 'Author', 'ARO' ) ? 1 : 0);
        $now = date( "Y-m-d H:i:s", time()+$mosConfig_offset*60*60 );
        $query = "SELECT id, sectionid FROM #__content WHERE id = $articleid ".
                 "\n AND sectionid IN ($allow_comments_in_sections) ".
                 "\n AND (state = '1' OR state = '-1')".
                 "\n AND ( publish_up = '0000-00-00 00:00:00' OR publish_up <= '$now'  )".
                 "\n AND ( publish_down = '0000-00-00 00:00:00' OR publish_down >= '$now' )".
                 "\n AND access <= ". $viewAccess;

        $database->setQuery( $query );
        $database->loadObject( $row );
        if ( $row != NULL){
            $comments  = strip_tags($comments);
            $comments  = mysql_escape_string(strip_tags($comments));
            $startdate = date( "Y-m-d H:i:s" );
            $ip        = getenv('REMOTE_ADDR');
    
            $query = "INSERT INTO #__comment SET articleid='$articleid', ip='$ip', name='$mcname', comments='$comments', startdate='$startdate', published='$auto_publish_comments';";
            $database->setQuery($query);
            $database->query();
    
    
            if ($notify_new_entries == "1") {
                // messaging for new items
                require_once($mosConfig_absolute_path."/includes/mambofunc.php");
                $message = T_("A new comment has been added")."\n\n".$comments;
    
                if ($auto_publish_comments == "0") {
                    $message = $message . "\n\n".T_("You have chosen not to auto publish new comments. Therefore you need to log in and publish new posts to make them visible.");
                }
    
                mosMail ( $mosConfig_mailfrom, $mosConfig_mailfrom, $mosConfig_mailfrom, T_("A new comment has been submitted"), $message);
            }
    
            $msg = T_('Thanks. Your comment has been successfully saved.');
            if ($auto_publish_comments == "0") {
                $msg = $msg. T_("The Administrator will review and publish your comment shortly.");
            }		
            
            mosRedirect( "index.php?option=com_content&task=view&id=".$articleid."&Itemid=".$mcitemid."&limit=".$limit."&limitstart=".$limitstart, $msg );
		}else{
            echo "<SCRIPT> alert('".T_("You are not allowed to leave comments on this item.")."');			document.location='index.php?option=com_content&task=view&id=$articleid&Itemid=$mcitemid&limit=$limit&limitstart=$limitstart&comments=$comments';</SCRIPT>";
		}
	}

} else {
	echo "<SCRIPT> alert('".T_("Incorrect Security Code")."');			document.location='index.php?option=com_content&task=view&id=$articleid&Itemid=$mcitemid&limit=$limit&limitstart=$limitstart&comments=$comments';</SCRIPT>";
}
?>