<?php
/**
* @package Mambo
* @subpackage Comment
* @author Mambo Foundation Inc see README.php
* @copyright Mambo Foundation Inc.
* See COPYRIGHT.php for copyright notices and details.
* @license GNU/GPL Version 2, see LICENSE.php
* Mambo is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; version 2 of the License.
*/

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

class moscomment extends mosDBTable {
	/** @var int Primary key */
	var $id=null;
	/** @var int */
	var $articleid=null;
	/** @var varchar */
	var $ip=null;
	/** @var varchar */
	var $name=null;
	/** @var text */
	var $comments=null;
	/** @var datetime */
	var $startdate=null;
	/** @var tinyint */
	var $published=null;

	/**
	* @param database
	* A database connector object
	*/
  function moscomment( &$db ) {
    $this->mosDBTable( '#__comment', 'id', $db );
  }
}
class mosCommentConfig {
	var $auto_publish_comments = 1;
	var $allow_anonymous_entries = 1;
	var $notify_new_entries = 0;
	var $allow_comments_in_sections = "0,4";
	var $comments_per_page = 10;
	var $admin_comments_length = 100;
	function __construct() {
		global $mosConfig_absolute_path;
		require($mosConfig_absolute_path."/administrator/components/com_comment/config.comment.php");

		$auto_publish_comments = isset($auto_publish_comments) ? abs(intval($auto_publish_comments)) : $this->auto_publish_comments;
		$this->auto_publish_comments = $auto_publish_comments > 1 ? $this->auto_publish_comments : $auto_publish_comments;

		$allow_anonymous_entries = isset($allow_anonymous_entries) ? abs(intval($allow_anonymous_entries)) : $this->allow_anonymous_entries;
		$this->allow_anonymous_entries = $allow_anonymous_entries > 1 ? $this->allow_anonymous_entries : $allow_anonymous_entries;

		$notify_new_entries = isset($notify_new_entries) ? abs(intval($notify_new_entries)) : $this->notify_new_entries;
		$this->notify_new_entries = $notify_new_entries > 1 ? $this->notify_new_entries : $notify_new_entries;

		$allow_comments_in_sections = isset($allow_comments_in_sections) ? $allow_comments_in_sections : $this->allow_comments_in_sections;
		$this->allow_comments_in_sections = trim(str_replace(' ', '', $allow_comments_in_sections));

		$comments_per_page = isset($comments_per_page) ? abs(intval($comments_per_page)) : $this->comments_per_page;
		$this->comments_per_page = $comments_per_page < 1 ? $this->comments_per_page : $comments_per_page;

		$admin_comments_length = isset($admin_comments_length) ? abs(intval($admin_comments_length)) : $this->admin_comments_length;
		$this->admin_comments_length = $admin_comments_length < 1 ? $this->admin_comments_length : $admin_comments_length;
	}
	function mosCommentConfig() {
		$this->__construct();
	}
}
?>