#!/bin/bash

# create a temp file to hold our working queue
queue=$(mktemp)

# clean up lastrun files that shouldn't exist
for user in $(/bin/ls -A /var/cpanel/lastrun/); do
    if [ ! -f "/var/cpanel/users/$user" ]; then
        rm -rf "/var/cpanel/lastrun/$user"
    fi
done

# get the number of cores on this box
numcores=$(grep -c 'processor' /proc/cpuinfo)

# while there are out of date logs
while [ "$(find /var/cpanel/lastrun -type f -mmin +1440|wc -l)" -gt 0 ]; do
    # build a queue file
    find /var/cpanel/lastrun -type f -mmin +1440 | awk -F/ '{print $5}' | sort -u > "$queue"

    # while load's under $numcores and there are still users queued
    while [ "$(awk -F. '{print $1}' /proc/loadavg)" -lt "$numcores" ] && [ "$(wc -l "$queue" |awk '{print $1}')" -gt "0" ]; do
        # grab the first user in the queue
        user=$(head -1 "$queue")
        # remove said line from the queue
        sed -i '1d' "$queue"

        # prepare a temp file for tracking
        userlog=$(mktemp)
        # run logs
        /scripts/runweblogs "$user" > "$userlog"

        # grab output to make sure they processed
        bandwidthdone=$(grep -E -c "\.\.\.Done" "$userlog")
        statsdone=$(grep -E -c "^Complete" "$userlog")

        # if they processed, update lastrun files
        if [ "$bandwidthdone" -gt "0" ]; then
            mkdir -p "/var/cpanel/lastrun/$user/"
            touch "/var/cpanel/lastrun/$user/bandwidth"
        fi
        if [ "$statsdone" -gt "0" ]; then
            mkdir -p "/var/cpanel/lastrun/$user/"
            touch "/var/cpanel/lastrun/$user/stats"
        fi
        if [ "$bandwidthdone" -gt "0" ] && [ "$statsdone" -gt "0" ]; then
            echo "Successfully processed logs for $user"
        else
            echo "Log processing for $user failed"
        fi

        # clear our temp file for this user
        rm -f "$userlog"
    done
    # go to sleep if load's high
    echo "Load's too high, pausing for 60 seconds."
    sleep 60
done

rm -f "$queue"
