<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
$reports["_PAGE_LOAD_TIME"] = Array(
	"ClassName" => "PageLoadTime", 
	"Category" => "_POPULAR_CONTENT", 	
	"Options" => "daterangeField,profileselector,columnSelector,trafficsource,displaymode,limit",
	"Filename" => "page_load_time",
	"Distribution" => "Premium",
	"Order" => 6,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false
	//"Update" => false
);


class PageLoadTime extends Report {
	
	function Settings(){
		
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table,linechart,barchart";
		$this->columnDefinitions[] = array("Label" => "_PAGE","actionmenu" => 'page');
		$this->columnDefinitions[] = array("Label" => "_PAGEVIEWS");
		$this->columnDefinitions[] = array("Label" => "_AVERAGE_LOAD_TIME", "bchart" => true, "decimals" => 2);
		$this->sort_key = 1;
		$this->sort_order = SORT_DESC;

		global $profile;
		include "includes/codespace.php";
		$this->help = _PAGE_LOAD_TIME_DESC.'<br><br>'._GIFDATA_REPORT_DESC."<br><br>"._REPORT_NEEDS_GIFDATA." "._TAG_LOGFILES."<br><br>".$codespace2;

		// get logaholic.gif id
		$this->gifid = getID("/logaholic.gif","urls");
		if ($this->gifid == false) { $this->gifid = 'false'; return false; }		

	}

	function DefineQuery() {
		global $db;
		if ($this->gifid == 'false') { return false; }
		
		$q = subsetDataToSourceID("select a.referrer, CONVERT(lg_getparam('loadtime',u.params), SIGNED INTEGER) as loadtime from {$this->profile->tablename_gifdata} as a, {$this->profile->tablename_urlparams} as u where a.params=u.id and a.url={$this->gifid} and a.timestamp >= ". $db->quote($this->from) ." AND a.timestamp <= ". $db->quote($this->to)."", $this->trafficsource)."";

		$q = "select r.referrer, count(*) hits, SUM(loadtime) from ($q) as a, {$this->profile->tablename_referrers} as r where a.referrer=r.id and loadtime > 0 group by r.referrer order by hits desc";

		$this->applytrafficsource = false;
		return $q;
	}	
	
	function GetReportData() {
		
		$data = parent::GetReportData();
		//dump($data);
		foreach($data as $k => $v) {
			$url = parse_url($v[0]);
			$data[$k][0] = $url['path'];
			if (empty($data[$k][0])) { $data[$k][0] = $v[0]; }
			$data[$k][2] = ($v[2] / $v[1])/1000;
		}
		return $data;
	}
	
	
	function UpdateStats($from = '', $to = '',$print = 2){
		return false;
	}
}
?>