<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report displays the used operating systems 
*/
$reports["_OPERATING_SYSTEMS"] = Array(
	"ClassName" => "OperatingSystems", 
	"Category" => "_CLIENT_SYSTEM", 
	"icon" => "images/icons/32x32/operatingsystems.png",
	"Options" => "daterangeField,profileselector,displaymode,trafficsource",
	"Filename" => "operating_systems",
	"Distribution" => "Standard",
	"Order" => 5,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true,
	"Update" => false
);

class OperatingSystems extends Report {
	
	function Settings() {
		$this->DefaultDisplay = "pie";
		$this->DisplayModes = "table,pie";
		$this->columnDefinitions[] = array("Label" => "_OPERATING_SYSTEM");
		$this->columnDefinitions[] = array("Label" => "_VISITS");
		$this->help = _DEFINITIONS_FOR_THIS_REPORT.':<ul><li>'._OS_DEFINITION.'</li><li>'._VISITS_DEFINITION.'</li></ul><div class=\'indentbody\'>'._OS_TIP_PART1._OS_TIP_PART2.'</div>';
		$this->sort_order = SORT_DESC;
		$this->sort_key = 1;
		

	}
	
	function GetReportData() {
		global $reports;
		$r = new $reports["_OS_VERSIONS"]["ClassName"]();
		$r->sort_order = SORT_DESC;
		$r->sort_key = 1;
		$r->key_col = 3;
		$data = $r->GetReportData();
		
		$newdata = array();		
		$newdata = $this->DataGroupBy($data,3);
		
		$data = array();
		$i = 0;
		
		foreach($newdata as $dat){
			if(empty($dat[3])){ continue; }
			$data[$i][0] = $dat[3];
			$data[$i][1] = $dat[1];
			$i ++;
		}		
		return $data;
	}
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		return false;		
	}
}
?>
