<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report displays all traffic by hour
*/
$reports["_ALL_TRAFFIC_BY_HOUR"] = Array(
	"ClassName" => "AllTrafficByHour", 
	"Category" => "_TRAFFIC", 
	"icon" => "images/icons/32x32/alltrafficbyhour.png",
	"Options" => "daterangeField,profileselector,trafficsource,columnSelector",
	"Filename" => "all_traffic_by_hour",
	"Distribution" => "Premium",
	"Order" => 3,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class AllTrafficByHour extends Report {
	
	function Settings() {
		$this->columnDefinitions[] = array("Label" => "_HOUR", "dataType" => "String");
		$this->columnDefinitions[] = array("Label" => "_UNIQUE_VISITORS");
		$this->columnDefinitions[] = array("Label" => "_TOTAL_PAGES");
		$this->columnDefinitions[] = array("Label" => "_VIEWED_PAGES", "bchart" => false);
		$this->columnDefinitions[] = array("Label" => "_CRAWLED_PERC");
		$this->columnDefinitions[] = array("Label" => "_VISITS", "bchart" => false);
		$this->columnDefinitions[] = array("Label" => "_PAGES_PER_VISIT");
	}
	function GetReportData(){
		global $db, $get_constant;
		$this->createDataFiles($this->from,$this->to);
		$d = $this->getDataFromFiles($this->dataFiles($this->from,$this->to));	
		$data = array();
		$i = 0;

		foreach($d as $val){
			$data[$i][0]  = $val[0];
			$data[$i][1]  = $val[5];
			$data[$i][2]  = $val[2];
			$data[$i][3]  = $val[3];
			if($val[2] == 0){
				$data[$i][4]  = 0;
			} else {
				$data[$i][4]  = ($val[4] / $val[2]) * 100;
			}
			
			$data[$i][5]  = $val[1];

			if($val[1] == 0){ 
				$data[$i][6]  = 0;
			}else {
				$data[$i][6]  = $val[2] / $val[1];
			}			
			$i ++;
		}		
		return $data;
	}
	function DefineQuery() {
		global $db;
		$table = $this->profile->tablename_merge;
		$query  = "SELECT FROM_UNIXTIME(timestamp, '%H') AS days, COUNT(DISTINCT sessionid) AS visits, COUNT(*) as requests, (COUNT(*) - SUM(IF(crawl='0','0',1))) AS viewed, SUM(IF(crawl='0','0',1)) as crawled, COUNT(DISTINCT visitorid) AS visitors FROM ".$table." WHERE timestamp >= ". $db->quote($this->from) ." AND timestamp <= ". $db->quote($this->to) ." GROUP BY days ORDER BY timestamp";

		return $query;
	}
	
	function UpdateStats($from = '', $to = '',$print = 2){	
		# this report has a low priority
		return false;
	}
}
?>