<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/
use GeoIp2\Database\Reader;

Class editVisitor{
	function EditIpnumber($ip){
		$data = $this->getData("ipnumber",$ip);
		if(!empty($data)){
			$this->CreateForm($data);
		}
	}
	function EditVisitorId($id){
		$data = $this->getData("visitorid",$id);
		if(!empty($data)){
			// $this->CreateForm($data);
			return $data;
		}
		return array();
	}
	
	function getData($where,$value){
		global $db, $profile, $gi;
		$data = array();
		
		$query = "select * from  {$profile->tablename_visitorids} where $where =". $db->Quote($value) ."";
		$result = $db->Execute($query);
		$i = 0;
		while($row = $result->FetchRow()){
			$info = $this->getInfo($row["id"]);
			$data[$i]["id"] = $row["id"];
			$data[$i]["visitor"] = $row["visitorid"];
			$data[$i]["ip"] = $row["ipnumber"];
			$data[$i]["label"] = $row["customlabel"];
			$data[$i]["created"] = $row["created"];
			$data[$i]["crawl"] = $row['crawl'];
			// $data[$i]["agent"] = $info['useragent'];
			// $data[$i]["country"] = $info['country'];

			try {
				$area = $gi->city($row["ipnumber"]);
			} catch (Exception $e) {
				$area = array();
			}

			$loc_string = "";

			if(!empty($area->city)) { $city = $area->city->name; $loc_string .= $area->city->name . ", "; }
			if(!empty($area->region)) { $loc_string .= $area->region .", "; }
			if(!empty($area->country)) { $loc_string .= $area->country->name; }

			$data[$i]["location"] = $loc_string;
			$i ++;
		}
		return $data;
	}	
	
	function getInfo($id) {
		global $db, $profile;
		$query = "select * from {$profile->tablename} as a, {$profile->tablename_useragents} as u where a.visitorid=". $db->Quote($id) ." and a.useragentid=u.id order by timestamp desc limit 1";	
		$result = $db->Execute($query);
		if ($row = $result->FetchRow()) {
			return $row;
		}
		return array();
		
	}
	
	function CreateForm($data){		
		foreach($data as $k => $v){				
			echo "<div class='visitor-info-field'>";				
				echo "<form action='' method='POST'>";
					echo "<input type='hidden' name='visid' value='{$v["id"]}' />";
					echo "<b>Visitor info:</b> (ID: {$v["visitor"]}) ";
					
					echo "<table>";
						echo "<tr><td>"._IP_NUMBER.":</td><td>{$v["ip"]}</td></tr>";
						echo "<tr><td>"._LOCATION.":</td><td>{$v["location"]} ";
						if(!empty($v["country"])){	
							echo "<img src='images/flags/".strtolower($v["country"]).".png' width='16px' />";
						}
						echo "</td></tr>";
						echo "<tr><td>"._IDENTIFY.":</td>";
						echo "<td><select name='setting'>";
						if($v["crawl"] == 1){
							echo "<option value='bot'>"._BOTS."</option><option value='human'>"._HUMAN."</option>";
						}else{
							echo "<option value='human'>"._HUMAN."</option><option value='bot'>"._BOTS."</option>";				
						}
						echo "</select></td></tr>";
						echo "<tr><td>"._LABELNAME.":</td><td><input type='text' name='label' value='{$v["label"]}' /><input type='submit' value='"._SAVE."' style='margin-left:10px;'/></td></tr>";
					echo "</table>";
				echo "</form>";
			echo "</div>";
		}
	}
	
	function updateLabel($id, $label){
		global $db, $profile;
		$query = "UPDATE {$profile->tablename_visitorids} SET customlabel=".$db->Quote($label)." where id = ". $db->Quote($id) ."";
		$db->Execute($query);
	}
	
	function updateSetting($crawl,$id){
		global $db, $profile;
		if (!empty($id)) {
			$db->Execute("UPDATE {$profile->tablename_visitorids} SET crawl=".$db->Quote($crawl)."  where id = ". $db->Quote($id) ."");	
			
			if($crawl !== 0){		
				# Set human to crawler
				$db->Execute("UPDATE {$profile->tablename} SET crawl=".$db->Quote($crawl)."  where visitorid = ". $db->Quote($id) ."");	
				
				# Rearrange crawler from table to table_crawl
				$db->Execute("create table if not exists $profile->tablename_crawl like $profile->tablename");
				$db->Execute("insert into $profile->tablename_crawl select * from $profile->tablename where crawl != 0");
				$db->Execute("delete from $profile->tablename where crawl!=0");
			} else {
				# Set crawler to human
				$db->Execute("UPDATE {$profile->tablename_crawl} SET crawl=".$db->Quote($crawl)."  where visitorid = ". $db->Quote($id) ."");
				
				# Rearrange crawler from table_crawl to table
				$db->Execute("insert into $profile->tablename select * from $profile->tablename_crawl where crawl = 0");
				$db->Execute("delete from $profile->tablename_crawl where crawl =0");
			}
			
		}
	}
}
?>