/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 

var signup = {};
var host = location.protocol + "//" + location.hostname + location.pathname;

$(document).ready( function(){
	$(".submit-register").on("click", function(e){
		e.preventDefault();
		$(".callout").hide();

		var errors = 0;
		var msg = "";

		if( $('[name="email"]').val() == ""){
			signup.Shake('[name="email"]');
			msg = "Empty Email";
			signup.Callout({ Status : "Error", Message : "Empty Email" });
			errors ++;
		} else if( !ValidateEmail( $('[name="email"]').val() ) ){
			signup.Shake('[name="email"]');
			msg = "Invalid Email";
			signup.Callout({ Status : "Error", Message : "Invalid Email" });
			errors ++;

		} else if( $('[name="password"]').val() == ""){
			signup.Shake('[name="password"]');
			msg = "Empty Password";
			signup.Callout({ Status : "Error", Message : "Empty Password" });
			errors ++;

		} else if(!checkPassword($('[name="password"]').val())){
			signup.Shake('[name="password"]');
			msg = "Password should contain:";
			signup.Callout({ Status : "Error", Message : "Password should contain: <br/>- at least one number<br/>- one lowercase letter<br/>- one uppercase letter<br/> - at least six characters" });
			errors ++;

		} else if( $('[name="password2"]').val() == ""){
			signup.Shake('[name="password2"]');
			msg = "Empty Password2";
			signup.Callout({ Status : "Error", Message : "Empty Password2" });
			errors ++;

		} else if( $('[name="password2"]').val() != $('[name="password"]').val() ){
			signup.Shake('[name="password2"]');
			msg = "The Password fields do not match each other";
			signup.Callout({ Status : "Error", Message : "The Password fields do not match each other" });
			errors ++;

		}

		if(errors == 0){
			var name = $('[name="name"]').val();
			var mail = $('[name="email"]').val();
			var pass = $('[name="password"]').val();

			signup.GetModal({ 'username' : name, 'email' : mail, 'password' : pass, 'action' : 'register'}, function(r){
				if(r.Status == undefined){
					// error during register
					signup.Callout({ Status : "Error", Message : "Error during registration please contact your administrator." });
				} else if(r.Status != "Success"){
					
					if (r.Message.indexOf("uplicate entry") > 0) {
						r.Message = "That email address is already registered.";	
					}
					signup.Callout(r);
					
				} else {
					$.ajax({
						url: "//software.logaholic.com/signupmail.php",
						type : 'POST',
						data : { 'email' : mail ,'host' : host, 'from' : 'sales@logaholic.com' },
						success: function(result) {
							var r = $.parseJSON(result);
							if(r.Status != undefined && r.Status == "Success"){
								signup.Callout(r);
								console.log('up');
								if (typeof trackSignup == 'function') { 
  									trackSignup(mail);
								}
							}
						}
					});					
				}
			});
		} else {
			console.log('try');
			if (typeof trackSignuptry == 'function') { 
  				trackSignuptry($('[name="email"]').val(), msg);
			}
		}
	});
});

signup.Shake = function(select){
	var duration = 80;
    var offset = 40;

	$(select).animate({marginLeft:('-='+ offset)}, duration,function(){
		$(this).animate({marginLeft:('+=' + offset*2)}, duration, function(){
			$(this).animate({marginLeft:('-=' + offset*2)}, duration, function(){
				$(this).animate({marginLeft:('+='+ offset)}, duration);
			});
		});
	});  
}

signup.Callout = function(res) {

	if (res.Status=="Success") {
		$(".callout-danger-template").hide();
		$(".callout-success-template").hide();
		$(".callout-success-template h4").html(res.Message); 
		$(".callout-success-template").fadeIn();
	} else {        		
		$(".callout-danger-template").hide();
		$(".callout-success-template").hide();
		$(".callout-danger-template h4").html(res.Message);
		$(".callout-danger-template").fadeIn();
	}
	return res;
}

signup.GetModal = function(post_data, callback){
	$.ajax({
		url: "app/model/Authentication.php",
		type : 'POST',
		data : post_data,
		success: function(result) {
			var r = $.parseJSON(result);
			callback(r);
		}
	});
}