<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc Definitions for this report:

    Time Spent: How long do your visitors stay on your site in one session/visit.
    Visit Share: The percentage of visitors that fall into this visit time range.
    Average Duration in minutes: The average duration for this visit time range.
*/
$reports["_VISIT_DURATION"] = Array(
	"ClassName" => "VisitDuration", 
	"Category" => "_VISITOR_DETAILS", 
	"icon" => "images/icons/32x32/visitduration.png",
	"Options" => "daterangeField,profileselector,displaymode,trafficsource,columnSelector,human",
	"Filename" => "visit_duration",
	"Distribution" => "Premium",
	"Order" => 2,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class VisitDuration extends Report {

	function Settings() {
		global $db;
		$this->DefaultDisplay = "pie";
		$this->DisplayModes = "table,pie";
		$this->columnDefinitions[] = array("Label" => "_TIME_SPENT");
		$this->columnDefinitions[] = array("Label" => "_VISITS");
		$this->columnDefinitions[] = array("Label" => "_AVERAGE_DURATION_IN_MINUTES", "totalRow" => "weighted-avg", "weight-row" => 1);
		$this->columnDefinitions[] = array("Label" => "_VISIT_SHARE", "dataType" => "String" );

		$this->help = _DEFINITIONS_FOR_THIS_REPORT.':<ul><li>'._TIME_SPENT_SESSION_DEFINITION .'</li><li>'._VISITS_DEFINITION.'</li><li>'._AVERAGE_DURATION_DEFINITION.'</li><li>'._VISITS_SHARE_DEFINITION.'</li></ul>';
		
		$this->key_col = 4;
		$this->sort_key = 4;
		
		$ServerInfo = $db->ServerInfo(); 
        if ($ServerInfo["version"] < 4 && $databasedriver!="sqlite") {
            echo _ONLY_WORKS_WITH_MYSQL_4_PLUS.":" .$ServerInfo["description"].$ServerInfo["version"];
            return false;  
        } else {
			//we can't do a temporary table in mysql 5, so truncate what we already have 
			$prequery = "truncate table ".$this->profile->tablename_vlength;
			@$db->Execute($prequery);
		}
	}
	function GetReportData() {
		$d = parent::GetReportData();
		$data = array();
		$tot = 0;
		foreach($d as $val){
			$tot = $tot + $val[1];
		}
		$i = 0;

		foreach($d as $val){
			$data[$i][0]  = (defined( trim($val[0])) ) ? constant(trim($val[0])) : $val[0];
			$data[$i][1]  = $val[1];
			$data[$i][2]  = ($val[1] == 0) ? 0 : ($val[2] / $val[1]) / 60;
			$data[$i][3]  = ($tot == 0) ? 0 : ($val[1] / $tot) * 100;
			$data[$i][4]  = $val[4];
			$i ++;
		}		
		return $data;
	}
	function DefineQuery() {
		global $db;
		if (isset($this->human) && $this->human==1) {
			$tablename = $this->profile->tablename_merge;			
		} else {
			$tablename = $this->profile->tablename;
		}

		$query = subsetDataToSourceID("insert into ".$this->profile->tablename_vlength." select (max(timestamp)-min(timestamp)), visitorid from {$tablename} force index (timestamp) where timestamp >= ". $db->quote($this->from) ." and timestamp <= ". $db->quote($this->to) ." and status=200 group by sessionid",$this->trafficsource);
		 
		$db->Execute("truncate table {$this->profile->tablename_vlength}");
		$db->Execute($query);
		
		$range = @$db->Execute("select min(length), max(length),count(*) from ".$this->profile->tablename_vlength);
		if($range == false) { return false; }
		
		$range_data = $range->FetchRow();
		//$min = $range_data[0];
		//$max = $range_data[1];
		$total_visitors=$range_data[2];
		//$blocksize=($max-$min)/8;
		$query  = "select \"_0_TO_10_SECONDS           \",count(*), sum(length), ((count(*)*1.0)/{$total_visitors}*100), \"1\" as ord from ".$this->profile->tablename_vlength." where length >=0 and length <=10 union ";
		$query  .= "select \"_10_TO_60_SECONDS            \",count(*), sum(length), ((count(*)*1.0)/{$total_visitors}*100), \"2\" as ord from ".$this->profile->tablename_vlength." where length >=10 and length <=60 union ";
		$query  .= "select \"_1_TO_5_MINUTES            \",count(*), sum(length), ((count(*)*1.0)/{$total_visitors}*100), \"3\" as ord from ".$this->profile->tablename_vlength." where length >=60 and length <=300 union ";
		$query  .= "select \"_5_TO_15_MINUTES           \",count(*), sum(length), ((count(*)*1.0)/{$total_visitors}*100), \"4\" as ord from ".$this->profile->tablename_vlength." where length >=300 and length <=900 union ";
		$query  .= "select \"_15_TO_30_MINUTES           \",count(*), sum(length), ((count(*)*1.0)/{$total_visitors}*100), \"5\" as ord from ".$this->profile->tablename_vlength." where length >=900 and length <=1800 union ";
		$query  .= "select \"_30_TO_1_HOUR            \",count(*), sum(length), ((count(*)*1.0)/{$total_visitors}*100), \"6\" as ord from ".$this->profile->tablename_vlength." where length >=1800 and length <=3600 union ";
		$query  .= "select \"_MORE_THAN_1_HOUR            \",count(*), sum(length), ((count(*)*1.0)/{$total_visitors}*100), \"7\" as ord from ".$this->profile->tablename_vlength." where length >=3600";
		
		$query .= " order by ord";
		
		$this->applytrafficsource = false;        

		return $query;
	}

	function AggregateFixData($data, $num_profiles) {
		$tot = 0;
		foreach($data as $val){
			$tot = $tot + $val[1];
		}		
		foreach($data as $k => $val){
			$data[$k][2]  = $val[2] / $num_profiles;
			$data[$k][3]  = ($tot == 0) ? 0 : ($val[1] / $tot) * 100;			
		}
		return $data;
	}
}
?>
