<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report displays the most crawled pages
*/
$reports["_MOST_CRAWLED_PAGES"] = Array(
	"ClassName" => "MostCrawledPages", 
	"Category" => "_POPULAR_CONTENT", 
	"icon" => "images/icons/32x32/mostcrawledpages.png",
	"Options" => "daterangeField,profileselector,displaymode,trafficsource,search,limit,columnSelector",
	"Filename" => "most_crawled_pages",
	"Distribution" => "Premium",
	"Order" => 7,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true,
	"canAggregate" => false
);

class MostCrawledPages extends Report {

	function Settings() {
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table,pie";
		$this->columnDefinitions[] = array("Label" => "_PAGE","actionmenu" => 'page');
		$this->columnDefinitions[] = array("Label" => "_BOTS");
		$this->columnDefinitions[] = array("Label" => "_REQUESTS");
		$this->actionmenu_type = 'page';
		$this->sort_order = SORT_DESC;
		$this->sort_key = 1;
		if (empty($this->searchmode)) {
			$this->searchmode = "like";
		}
		$this->help = _DEFINITIONS_FOR_THIS_REPORT.':<ul>'.'<li>'._PAGE_DEFINITION.'<li>'._BOTS_DEFINITION.'<li>'._REQUESTS_BOTS_DEFINITION.'</ul>';
	}
	
	function DefineQuery() {
		global $db;
        
        $query  = "SELECT u.url, COUNT(DISTINCT sessionid) AS visits, count(*) AS hits, COUNT(DISTINCT visitorid) AS visitors FROM {$this->profile->tablename_crawl} AS a, {$this->profile->tablename_urls} AS u WHERE timestamp >= ". $db->quote($this->from) ." and timestamp <= ". $db->quote($this->to) ." AND a.url = u.id AND a.crawl = 1 GROUP BY a.url ORDER BY visits DESC";

		return $query;
	}
}
?>
