<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report displays a overview of search engines
*/
$reports["_DETAILED_SEARCH_ENGINES"] = Array(
	"ClassName" => "DetailedSearchEngines", 
	"Category" => "_TRAFFIC_SOURCES", 
	"icon" => "images/icons/32x32/detailed_search_engines.png",
	"Options" => "daterangeField,profileselector,displaymode,trafficsource,limit,columnSelector",
	"Filename" => "detailed_search_engines",
	"Distribution" => "Premium",
	"hidden" => 1,
	"Order" => 11,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.1,
	"EmailAlerts" => true
);

class DetailedSearchEngines extends Report {

	function Settings() {
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table,pie";
		$this->columnDefinitions[] = array("Label" => "_KEYWORDS");
		$this->columnDefinitions[] = array("Label" => "_UNIQUE_VISITORS");
		$this->columnDefinitions[] = array("Label" => "_HITS");
		$this->columnDefinitions[] = array("Label" => "_SEARCHES_PER_USER");
		if(!empty($this->se)) { $this->addlabel .= "<span>". _SEARCH_ENGINE .": {$this->se}</span>"; }
	}
	
	function DefineQuery() {
		global $db;
		$convert = array(
			"Google (Natural Search)" => "(r.referrer LIKE \"http://www.google.%\" AND up.params NOT LIKE \"?gclid=%\")",
			"Google (Paid Search)" => "(r.referrer LIKE \"http://www.google.%\" AND up.params LIKE \"?gclid=%\")",
			"MSN Search" => "(r.referrer LIKE \"%search.msn.%\" OR r.referrer LIKE \"%.live.com%\")",
			"Yahoo" => "r.referrer like \"%search.yahoo.%\"",
			"Bing" => "r.referrer = \"http://www.bing.com/search\"",
			"AOL Search" => "r.referrer like \"%search.aol.%\"",
			"Ask.com" => "r.referrer like \"%.ask.com%\"",
			"Dogpile.com" => "r.referrer like \"http://www.dogpile.com%\""
		);
		
		if(isset($convert[$this->se])) {
			$se_query = $convert[$this->se];
		} else {
			$se_query = "r.referrer like \"{$this->se}\"";
		}
		
		$query = subsetDataToSourceID("SELECT k.keywords, COUNT(DISTINCT visitorid) AS visitors, COUNT(*) AS hits, (COUNT(*) / (COUNT(DISTINCT visitorid) * 1.00)) AS ppu FROM {$this->profile->tablename} AS a, {$this->profile->tablename_referrers} AS r, {$this->profile->tablename_urls} AS u, {$this->profile->tablename_urlparams} AS up, {$this->profile->tablename_keywords} AS k WHERE a.keywords = k.id AND a.url = u.id AND a.params = up.id AND a.referrer = r.id AND `timestamp` BETWEEN ". $db->quote($this->from) ." AND ". $db->quote($this->to) ." AND {$se_query} AND k.keywords != '' GROUP BY k.keywords ORDER BY visitors DESC LIMIT ". $this->limit, $this->trafficsource);
        
        $this->applytrafficsource = false;
		
		return $query;
	}
	
	function DisplayCustomForm() {
		echo "<input type='hidden' id='se' name='se' value='{$this->se}' />";
	}
	function UpdateStats($from = '', $to = '',$print = 2) {
		return false;
	}
}
?>
