<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report displays a detailed crawler report
*/
$reports["_DETAILED_CRAWLER_REPORT"] = Array(
	"ClassName" => "DetailedCrawlerReport", 
	"Category" => "_TRAFFIC",
	"icon" => "images/icons/32x32/detailed_crawler_report.png",
	"Options" => "daterangeField,profileselector,trafficsource,limit,columnSelector",
	"Filename" => "detailed_crawler_report",
	"Distribution" => "Premium",
	"hidden" => true,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false
);

class DetailedCrawlerReport extends Report {
	
	function Settings() {
		$this->columnDefinitions[] = array("Label" => "_PAGE","actionmenu" => 'page');
		$this->columnDefinitions[] = array("Label" => "_PARAMETERS","dataType" => "String");
		$this->columnDefinitions[] = array("Label" => "_REQUESTS");
		$this->help = "";
		$this->datafiles=false;
		if(empty($this->agent)){
			$this->agent = "";
		} else {
			$this->fileNameExpension = ".".$this->agent;
			$this->addlabel.=$this->agent;
		}
		//$this->limit=100;
	}
	
	function DefineQuery() {
		global $db;
		
		
		$query  = "select u.url, p.params, count(*) AS hits FROM {$this->profile->tablename_crawl} AS a, {$this->profile->tablename_urls} AS u, {$this->profile->tablename_urlparams} AS p, {$this->profile->tablename_useragents} AS ua WHERE ua.name=". $db->quote($this->agent) ." AND timestamp BETWEEN ". $db->quote($this->from) ." AND ". $db->quote($this->to) ." AND a.url = u.id AND a.params = p.id AND a.useragentid = ua.id GROUP BY u.url, p.params ORDER BY hits DESC LIMIT $this->limit";
		
		return $query;
	}

	function DisplayCustomForm(){
		echo "<div class='form-group'>";
		echo "<label for='agent'>"._CRAWLER.":</label>";
		echo "<input class='report_option_field form-control' type='text' name='agent' id='agent' value='".@$this->agent."' onkeyup=\"popupActionMenu(event, this.value+'@'+this.id+'@'+'useragent', 'forminput');\" onclick=\"popupActionMenu(event, this.value+'@'+this.id+'@'+'useragent', 'forminput');\">";
		echo "</div>";
	
	}
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		return false;
	}
}
?>
