<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
class ProfileImportExport {

	var $exportLocation;
	var $importLocation;
	var $profile;
	var $exportedfile;
	
	function exportProfileSettings() {
		global $db;
		
		$file = $this->exportLocation 
              . 'logaholic_'
              . $this->profile 
              . '_' 
              . 'settings.json';
        
        $fh = fopen($file, 'w');
		
        if($fh === false){
            echo("Fatal error: no filehandle for '$file'\n");
            exit();
        }
		
		$db->SetFetchMode(ADODB_FETCH_ASSOC);
		$q = $db->Execute("select * from ".TBL_PROFILES." where profilename=".$db->Quote($this->profile));
		$data = $q->FetchRow();
		fwrite($fh, json_encode($data) . "\n");
		fclose($fh);
		
		$this->exportedfile = $file;
		// echo "Profile settings saved in file: $file";
		
        return true;		
	}
	
	function importProfileSettings() {
		global $db;
		
		$file = $this->importLocation; 

        $fh = fopen($file, 'r');
		
        if($fh === false){
            echo json_encode(array("Status" => "Error", "Message" => "no filehandle for '$file'"));
            exit();
        }
		
		while ($line=fgets($fh)) {
			//dump($line);
			$line = json_decode($line, true);
			if ($line ==false) {
				echo json_encode(array("Status" => "Error", "Message" => "Can't decode json file. This is not a valid Logaholic settings file."));
            	exit();			
			}

			if (isset($line["profilename"])) {
				$this->profile = $line["profilename"];
			} 
			if (isset($line["profileid"])) {
				# handle the profile table entry
				if (empty($this->profile)) {
					echo json_encode(array("Status" => "Error", "Message" => "no profile name in file"));
					exit();
				}
				if ($this->profileExists($this->profile)==true) {					
					echo json_encode(array("Status" => "Error", "Message" => "Profile '$this->profile' already exists in this database"));
					exit();    
				}
								
				# ok, now create the new profile based on this info
				$profile = new SiteProfile();

				foreach($line as $k => $v) {
					if ($k=="profileid" || $k=="tablename" || $k=="filehistory" || $key=="stats") {
						# skip this to avoid conflicts on this new server
						continue;					
					}
					$profile->$k = $v;
				}
				
				//dump($profile);
				$profile->dashboards = json_decode($profile->dashboards, true);
				$profile->other_settings = json_decode($profile->other_settings, true);
				$profile->Save();
				createDataTable($profile);
				
				$dir_1 = "{$profile->datamanagerDir}{$profile->profilename}";
				$dir_2 = $dir_1."/log/";
				if(!file_exists($dir_1)) {
					mkdir($dir_1);
					set_permissions($dir_1);
				}
				if(!file_exists($dir_2)) {
					mkdir($dir_2);
					set_permissions($dir_2);
				}
				
			} else {
				echoWarning("Error Invalid data in settings file $file \n");
			}
		}
		echo json_encode(array("Status" => "Success", "Message" => "Imported profile settings for $profile->profilename"));
		//echoNotice("Success: Imported profile settings for $profile->profilename \n"); 
		if ($profile->trackermode==1) {
			echoWarning("You will need to update the Javascript tracking code on {$profile->confdomain}. Go to: Edit Profile > Data collection tab. Copy the new code and replace the old code in the website.");
		}
		
		fclose($fh);
        return true;		
	}
	
	function profileExists($name) {
        global $db;
        
        $q = $db->Execute("select profileid from ".TBL_PROFILES." where profilename=".$db->Quote($name));
        if ($q->NumRows() > 0) {
            return true;    
        } else {
            return false;    
        }            
    }


}

?>