<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
$dont_close_session = true;
$accessControl = array(
	"NoLoginRequired" => true
);
require_once "../../AccessControl.php";

# Default signup settings
$default_signup_settings = json_encode(array(
	"profileLimit" => 1,
	"trackermode_0" => false,
	"trackermode_1" => true,
	"trackermode_2" => false,
	"trackermode_3" => false,
	"accessUpdateLogs" => false,
	"accessAddProfile" => false,
	"accessEditProfile" => false,
	"changeAccountInfo" => true
));
$signup_settings = json_decode( getGlobalSetting("SignupPageSettings", $default_signup_settings ), true );

$message = "";

$form->clearErrors();

if(empty($_POST['action'])){
	die('{ "Status" : "Error", "Message" : "Invalid Action" }');
	
} else if($_POST['action'] == "logout"){
	if(empty($process)){
		die('{ "Status" : "Error", "Message" : "'. _LOGAHOLIC_WITH_NO_LOGIN .'" }');
	}
	$process->procLogout();
	if (isset($cm->logout_redirect_url)) {
		die('{ "Status" : "Success", "redirect": "'.$cm->logout_redirect_url.'" }');
	} else {
		die('{ "Status" : "Success" }');
	}

} else if($_POST['action'] == "forgot_pass"){
	if(empty($process)){
		die('{ "Status" : "Error", "Message" : "'. _LOGAHOLIC_WITH_NO_LOGIN .'" }');
	}

	$process->procForgotPass();
	$errors = $form->getErrorArray();

	$message = "We have sent you a new password. Please check your email.";

} else if($_POST['action'] == "login"){
	if(empty($process)){
		die('{ "Status" : "Error", "Message" : "'. _LOGAHOLIC_WITH_NO_LOGIN .'" }');
	}
	$process->procLogin();
	$errors = $form->getErrorArray();

# lets register a new user
} else if($_POST['action'] == "register"){
	$signup = getGlobalSetting("SignupPage", 0 );
	# is signup enabled ??
	if($signup == 1){
		# Ok so we do need to register a new user but hey it's going to be inactive!
		# Now also add default options for the new user
		$dbdata = array(
			"name" => $_POST['username'],
			"username" => $_POST['email'],
			"email" => $_POST['email'],
			"password" => md5($_POST['password']),
			"created" => time(),
			"active" => 0,
			"isAdmin" => 0,
			"accessUpdateLogs" => ($signup_settings['accessUpdateLogs']) ? 1 : 0,
			"accessAddProfile" => ($signup_settings['accessAddProfile']) ? 1 : 0,
			"accessEditProfile" => ($signup_settings['accessEditProfile']) ? 1 : 0,
			"metadata" => json_encode(array(  
				"changeAccountInfo" => ($signup_settings['changeAccountInfo']) ? 1 : 0,
				"profileLimit" => $signup_settings['profileLimit'],
				"trackermode_0" => ($signup_settings['trackermode_0']) ? 1 : 0,
				"trackermode_1" => ($signup_settings['trackermode_1']) ? 1 : 0,
				"trackermode_2" => ($signup_settings['trackermode_2']) ? 1 : 0,
				"trackermode_3" => ($signup_settings['trackermode_3']) ? 1 : 0,
			))
		);
		@$db->AutoExecute(TBL_USERS, $dbdata, "INSERT") or die( json_encode(array("Status" => "Error", "Message" => $db->ErrorMsg() ) ) );
	}
}

if(empty($errors)){
	die('{ "Status" : "Success", "Message" : "'. $message .'" }');
} else if(!empty($errors['login_user'])) {
	die('{ "Status" : "Error" , "Target" : "login_user", "Message" : "'. $errors['login_user'] .'" }');
} else if(!empty($errors['login_pass'])) {
	die('{ "Status" : "Error" , "Target" : "login_pass", "Message" : "'. $errors['login_pass'] .'" }');
}
?>