<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc Definitions for this report:

    Visitors: Unique Visitors that accessed your site (excluding any bots and crawlers).
    Pageviews: The total number of pages requested (excluding any bots and crawlers).
    Average Pages per user: The total number of pages devided by the number of visitors.

Tip: Make sure you set a proper date range (e.g. start from the first day of a month).
*/
$reports["_VISITORS_PER_MONTH"] = Array(
	"ClassName" => "VisitorsPerMonth", 
	"Category" => "_VISITOR_TRENDS", 
	"icon" => "images/icons/32x32/visitorspermonth.png",
	"Options" => "daterangeField,profileselector,displaymode,trafficsource,columnSelector,human",
	"Filename" => "visitors_per_month",
	"Distribution" => "Standard",
	"Order" => 2,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class VisitorsPerMonth extends Report {
	
	function Settings() {	
		$this->DisplayModes = "table,linechart,barchart";
		$this->DefaultDisplay = "table";
		if(empty($this->displaymode)){
			$this->displaymode = $this->DefaultDisplay;
		}
		
		$this->from = mktime(0,0,0,date("m",$this->from),1,date("Y",$this->from));
		
		$this->columnDefinitions[] = array("Label" => "_DATE");
		$this->columnDefinitions[] = array("Label" => "_UNIQUE_VISITORS");
		$this->columnDefinitions[] = array("Label" => "_PAGEVIEWS");
		$this->columnDefinitions[] = array("Label" => "_PAGES_PER_USER", "totalRow" => "avg");
		$this->columnDefinitions[] = array("Label" => "_VISITS", "bchart" => false);

		$this->help = _DEFINITIONS_FOR_THIS_REPORT.':<ul>'.'<li>'._VISITORS_DEFINITION.'<li>'._PAGEVIEWS_DEFINITION.'<li>'._AVERAGE_PAGES_PER_USER_DEFINITION.'<li>'._VISITS_DEFINITION.'</ul><div class=\'indentbody\'>'._VISITORS_PER_MONTH_TIP.'</div>';
		
		$this->allowDateFormat = false;
		$this->ignoreDayFileCreation = true;
		$this->dataCollectType = "months";
		$this->sort = false;

		$this->barcolors = array("#9ecae1","#c6dbef");

	}

	function GetReportData(){
		$data = parent::GetReportData();
		for ($i=0; $i < count($data); $i++) { 
			$data[$i][0] = LogaDate(array("format1" => "F", "seperator1" => " ", "format2" => "Y"),$data[$i][0],"STRING");
		}
		return $data;
	}

	function DefineQuery() {
		global $db;
		if (isset($this->human) && $this->human==1) {
			$tablename = $this->profile->tablename_merge;			
		} else {
			$tablename = $this->profile->tablename;
		}
		$this_month = date("F Y",$this->to);
		$query = "SELECT FROM_UNIXTIME(timestamp, '%M %Y') AS month, COUNT(DISTINCT visitorid) as visitors, COUNT(*) as pages, (COUNT(*) / COUNT(DISTINCT visitorid)) AS ppu, COUNT(DISTINCT sessionid) as visits FROM {$tablename} WHERE timestamp >= ". $db->quote($this->from) ." AND timestamp <= ". $db->quote($this->to) ." and FROM_UNIXTIME(timestamp, '%M %Y') = ". $db->quote($this_month) ." GROUP BY month ORDER BY timestamp";

		return $query;
	}
}
?>
