<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/
$reports["_UTM_MEDIUM"] = Array(
	"ClassName" => "UtmMedium", 
	"Category" => "_ADVERTISING", 	
	"Options" => "daterangeField,profileselector,displaymode,search,limit,columnSelector,human",
	"Filename" => "utm_medium",
	"Distribution" => "Premium",
	"Order" => 5,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class UtmMedium extends Report {

	function Settings() {		
		//$this->datafiles=false;
		
		$this->help=_UTM_DESC;
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "sunburst,drilldown,table";
		if(empty($this->displaymode)) {
  			$this->displaymode = $this->DefaultDisplay;
  		}
		$this->columnDefinitions[] = array("Label" => "Medium", "actionmenu" => "utm_medium");
		$this->columnDefinitions[] = array("Label" => "_PAGEVIEWS");		
		$this->columnDefinitions[] = array("Label" => "_VISITS");
		$this->sort_key = 1;
		$this->sort_order = SORT_DESC;

	}

	function DefineQuery() {
		global $db;
		
		if (isset($this->human) && $this->human==1) {
			$tablename = $this->profile->tablename_merge;			
		} else {
			$tablename = $this->profile->tablename;
		}

		$query  = "select lg_getparam('utm_medium',u.params) as medium, count(*) as hits, count(distinct sessionid) as visits from {$tablename} as a, {$this->profile->tablename_urlparams} as u where timestamp >= ". $db->quote($this->from) ." and timestamp <= ". $db->quote($this->to) ." and a.params=u.id and u.params like '%utm_medium=%' group by medium order by hits desc";
		
		return $query;
	}

	function UpdateStats($from = '', $to = '',$print = 2) {
		# because the query takes too long
		return false;		
	}
}
?>
