<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report displays the age of your facebook friends 
*/
$reports["_FACEBOOK_STORIES"] = Array(
    "ClassName" => "FacebookPageStories", 
    "Category" => "_FACEBOOK", 
    "icon" => "images/icons/32x32/fb_wall.png",
	"Options" => "daterangeField,displaymode",
	"Filename" => "facebook_page_stories",
	"Distribution" => "Premium",
	"Order" => 13,
	"ReportVersion" => 4.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false,
	"Update" => false
);

class FacebookPageStories extends FacebookCore {
	
	function Settings() {
		parent::Settings();
		$this->DisplayModes = "table,barchart";
		$this->DefaultDisplay = "barchart";
		if(empty($this->displaymode)){
			$this->displaymode = $this->DefaultDisplay;
		}
		$this->addlabel = _FACEBOOK_STORIES_ADDLABEL;
		$this->help = str_replace("-", "<br/>-", _FACEBOOK_STORIES_HELP);

		$this->metric = "stories";
	}	
    
	function DisplayGraph(){
		?><script type="text/javascript">
		function lg_fb_<?php echo $this->graphID; ?>(container_id,result){
			if(result.Status == undefined || result.Status != "Success"){
				return;
			}

			var data = result.data;
			if(!data || data.values === undefined){
				console.log("No data");
				return;
			}	

			var xticks = [];
			var lg_gr_data = [
				{ key: "checkin", values : [] }, 
				{ key: "coupon", values : [] },
				{ key: "event", values : [] },
				{ key: "fan", values : [] },
				{ key: "mention", values : [] },
				{ key: "page post", values : [] },
				{ key: "question", values : [] },
				{ key: "user post", values : [] },
				{ key: "other", values : [] }
			];

			for (var i = 0; i < data.values.length; i++) {
				var row = data.values[i];

				xticks.push(d3.time.format('<?php echo GetCustomDateFormat("D3"); ?>')(new Date(row.end_time)));

				$.each(lg_gr_data, function(k,v){
					if(row.value[v.key] != undefined){
						lg_gr_data[k].values.push({ 
							x: i, 
							y : parseInt(row.value[v.key]) 
						});
					}
				});
			}

			$("#"+container_id).attr("data-ticks", JSON.stringify(xticks) );
			$("#"+container_id).attr("data-chart", JSON.stringify(lg_gr_data) );
			
			lg.BarChart(container_id,true);
		}
		</script><?php
	}

	function DisplayTable(){
		?><script type="text/javascript">
		function lg_fb_<?php echo $this->graphID; ?>(container_id,result){
			if(result.Status == undefined || result.Status != "Success"){
				return;
			}

			var data = result.data;
			if(!data || data === undefined){
				console.log("No data");
				return;
			}		

			var dataSet = [];

			columnsSet = [
				{ title: "Date" },
				{ title: "checkin" }, 
				{ title: "coupon" },
				{ title: "event" },
				{ title: "fan" },
				{ title: "mention" },
				{ title: "page post" },
				{ title: "question" },
				{ title: "user post" },
				{ title: "other" }
			];

			for (var i = 0; i < data.values.length; i++) {
				var row = data.values[i];

				var time = d3.time.format('<?php echo GetCustomDateFormat("D3"); ?>')(new Date(row.end_time));

				dataSet[i] = [time,'0','0','0','0','0','0','0','0','0'];

				for (var c = 0; c < columnsSet.length; c++) {
					var col = columnsSet[c].title;
					if(row.value[col] != undefined && row.value[col] > 0){
						console.log(col);
						dataSet[i][c] = row.value[col];
					}
				}
			}

			$("#" + container_id ).dataTable({
				data: dataSet,
		        columns: columnsSet,	
		        "iDisplayLength": dataSet.length,	        
				"aaSorting": [],		
				"sDom": "t"
			});

		}
		</script><?php
	}
}
?>