<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report displays the browser versions
*/

$reports["_BROWSER_VERSIONS"] = Array(
	"ClassName" => "BrowserVersions", 
	"Category" => "_CLIENT_SYSTEM", 
	"icon" => "images/icons/32x32/browser_versions.png",
	"Options" => "daterangeField,profileselector,search,country,trafficsource,limit,columnSelector",
	"Filename" => "browser_versions",
	"Distribution" => "Premium",
	"Order" => 3,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class BrowserVersions extends Report {
	
	function Settings() {
		global $cnames;
		$this->columnDefinitions[] = array("Label" => "_BROWSER");
		$this->columnDefinitions[] = array("Label" => "_BROWSER_VERSION","dataType" => "String");
		$this->columnDefinitions[] = array("Label" => "_VISITS");
		$this->columnDefinitions[] = array("Label" => "_UNIQUE_VISITORS", "display" => false);
		$this->columnDefinitions[] = array("Label" => "key", "display" => false);
		$this->sort_order = SORT_DESC;
		$this->sort_key = 2;
		$this->key_col = 4;

		if(!empty($_REQUEST["country"])) {
			$this->country = $_REQUEST["country"];
		}
		if (!empty($this->country)) {
			$this->fileNameExpension = ".".$this->country;
			$this->addlabel = $cnames[$this->country];
		}

	}
	
	function DefineQuery() {
		global $db;
		
		$ingnore = "AND ua.name != '-' ";
		$ingnore .= "AND ua.name != '0' ";
		$ingnore .= "AND ua.name != '()' ";

		if (!empty($this->country)) {
			$country = " and country=". $db->quote($this->country);
		} else {
			$country = "";
		}
		
		$query = subsetDataToSourceID("SELECT ua.name AS useragent, ua.version, COUNT(distinct a.sessionid) AS visits, COUNT(distinct a.visitorid) AS visitors, MD5(CONCAT(ua.name,ua.version)) AS bv FROM {$this->profile->tablename} as a,{$this->profile->tablename_useragents} as ua where a.useragentid = ua.id and a.timestamp >= ". $db->quote($this->from) ." AND a.timestamp <=". $db->quote($this->to) ." {$ingnore} AND ua.is_mobile = 0 $country GROUP BY bv UNION ", $this->trafficsource);
    	$query .= subsetDataToSourceID("SELECT 'Mobile Browsers' AS useragent, '' as userversion, COUNT(distinct a.sessionid) AS visits, COUNT(distinct a.visitorid) AS visitors, MD5('Mobile Browser') AS bv FROM {$this->profile->tablename} as a,{$this->profile->tablename_useragents} as ua where a.useragentid = ua.id and a.timestamp >= ". $db->quote($this->from) ." AND a.timestamp <=". $db->quote($this->to) ." AND  ua.is_mobile = 1 $country GROUP BY bv ", $this->trafficsource);
		$query .= "ORDER BY visits DESC";
		
		$this->applytrafficsource = false;
		
		return $query;
	}
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		# because the query takes too long
		return false;		
	}
}
?>
