<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 

$reports["_BOUNCE_RATE_PER_DAY"] = Array(
	"ClassName" => "BounceRatePerDay", 
	"Category" => "_PROBLEMS", 
	"icon" => "images/icons/32x32/bouncerate.png",
	"Options" => "daterangeField,profileselector,displaymode,trafficsource",
	"Filename" => "bounce_rate_per_day",
	"Distribution" => "Premium",
	"Order" => 4,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.1,
	"EmailAlerts" => true,
	"Update" => false,
	"canAggregate" => false
);

class BounceRatePerDay extends Report {
	
	function Settings() {
		$this->DefaultDisplay = "barchart";
		$this->DisplayModes = "table,barchart";
		$this->columnDefinitions[] = array( "Label" => _DESCRIPTION);		
		$this->columnDefinitions[] = array( "Label" => _BOUNCE_RATE . " %" , "totalRow" => "avg");		
		
		$this->help = _BOUNCE_RATE_DESC;
		$this->dataCollectType = "days";
	}
	
	function GetDataFromDb() {
		global $db, $reports;

		$data = array();		
		
		# first get total number of visitors to page
		$vpd = new $reports["_VISITORS_PER_DAY"]["ClassName"]();
		$vpd->from = $this->from;
		$vpd->to = $this->to;
		$vpd->trafficsource = $this->trafficsource;
		$total_visitors = $vpd->GetReportData();			

		# Get the bounce visitors 
		$query =subsetDataToSourceID("SELECT count(visitorid) from (SELECT visitorid, count(*) as hits from {$this->profile->tablename} WHERE timestamp >=". $db->Quote($this->from) ." and timestamp <=". $db->Quote($this->to) ." GROUP BY visitorid ORDER by NULL) as ht where hits=1", $this->trafficsource);
		$result = $db->Execute($query);
		$this->applytrafficsource = false; 
		$i = 0;
		while($bounce_visitors = $result->FetchRow()){
			$data[$i][0] = $this->to;
			$data[$i][1] = @($total_visitors[$i][1] == 0) ? 0.00 : ($bounce_visitors[0] / $total_visitors[$i][1]) * 100;
			$data[$i][2] = $bounce_visitors[0];
			$i ++;
		}

		return $data;		     
	}
	
	function GetReportData() {
		global $db, $get_constant;
		
		$data = parent::GetReportData();
		$dat = array();	
		
		$i = 0;	
		foreach($data as $br){
			if(is_numeric($br[0])){
				$dat[$i][0] = date(implode($this->profile->dateFormat),$br[0]);	
			} else {
				$dat[$i][0] = $br[0];
			}

			
			$dat[$i][1] = number_format($br[1],2);
			

			$i ++;
		}
				
		return $dat;		
	}	
	
	function UpdateStats($from = '', $to = '',$print = 2){
		return false;
	}
}
?>
