<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report displays all traffic by day
*/
define("_ALL_TRAFFIC_BY_TYPE",'All Traffic by Type');
$reports["_ALL_TRAFFIC_BY_TYPE"] = Array(
	"ClassName" => "AllTrafficByType", 
	"Category" => "_TRAFFIC", 
	"icon" => "images/icons/32x32/alltrafficbyday.png",
	"Options" => "daterangeField,displaymode,profileselector,trafficsource,columnSelector",
	"Filename" => "all_traffic_by_type",
	"Distribution" => "Premuim",
	"Order" => 5,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class AllTrafficByType extends Report {
	
	function Settings() {
		$this->DisplayModes = "table,linechart,areachart";
		$this->DefaultDisplay = "linechart";
		$this->columnDefinitions[] = array("Label" => "_DATE");
		$this->columnDefinitions[] = array("Label" => "Human");
		$this->columnDefinitions[] = array("Label" => "Bots");
		$this->columnDefinitions[] = array("Label" => "Feeds");
		$this->columnDefinitions[] = array("Label" => "Suspicious");
		$this->columnDefinitions[] = array("Label" => "Spam");
		$this->columnDefinitions[] = array("Label" => "Total", "disable_line" => true);

		
		$this->help = "This report shows the number of requests for each type of traffic";
		$this->sort = false;
		
	}
	
	function DefineQuery() {
		global $db;
		$query = "SELECT FROM_UNIXTIME(timestamp, '%d-%b-%Y %a') AS days, SUM(IF(crawl='0',1,'0')) AS human, SUM(IF(crawl='1',1,'0')) AS crawled,SUM(IF(crawl='2',1,'0')) AS feeds, SUM(IF(crawl='3',1,'0')) AS susp, SUM(IF(crawl='4',1,'0')) AS spam, count(*) as total FROM ".$this->profile->tablename_merge." WHERE timestamp >= ". $db->quote($this->from) ." AND timestamp <= ". $db->quote($this->to) ." GROUP BY days ORDER BY timestamp";

		return $query;
	}
}
?>