<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
/**
* @desc This report displays all traffic by month
*/
$reports["_ALL_TRAFFIC_BY_MONTH"] = Array(
	"ClassName" => "AllTrafficByMonth", 
	"Category" => "_TRAFFIC", 
	"icon" => "images/icons/32x32/alltrafficbymonth.png",
	"Options" => "daterangeField,displaymode,profileselector,trafficsource,columnSelector",
	"Filename" => "all_traffic_by_month",
	"Distribution" => "Standard",
	"Order" => 1,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class AllTrafficByMonth extends Report {
	
	function Settings() {
		$this->DisplayModes = "table,linechart";
		$this->DefaultDisplay = "table";
		$this->columnDefinitions[] = array("Label" => _DATE);
		$this->columnDefinitions[] = array("Label" => _UNIQUE_VISITORS);
		$this->columnDefinitions[] = array("Label" => _TOTAL_PAGES);
		$this->columnDefinitions[] = array("Label" => _VIEWED_PAGES, "bchart" => false);
		$this->columnDefinitions[] = array("Label" => _CRAWLED_PERC);
		$this->columnDefinitions[] = array("Label" => _VISITS, "bchart" => false);
		$this->columnDefinitions[] = array("Label" => _PAGES_PER_VISIT, "totalRow" => "avg");		
		
		$this->help = _DEFINITIONS_FOR_THIS_REPORT.':<ul>'.'<li>'._UNIQUE_VISITORS_DEFINITION.'<li>'._TOTAL_PAGES_DEFINITION.'<li>'._VIEWED_PAGES_DEFINITION.'<li>'._CRAWLED_PERC_DEFINITION.'<li>'._VISITS_DEFINITION.'<li>'._AVERAGE_PAGES_PER_VISIT_DEFINITION.'</ul><div class=\'indentbody\'>'._ALL_TRAFFIC_BY_MONTH_NOTE.'</div>';
		
		$this->ignoreDayFileCreation = true;
		$this->allowDateFormat = false;
		$this->sort = false;
		$this->dataCollectType = "months";	
	}
	
	function GetReportData(){
		global $db, $get_constant;
		$d = parent::GetReportData();	
		$data = array();
		$i = 0;
		foreach($d as $val){
			$data[$i][0] = LogaDate(array("format1" => "F", "seperator1" => " ", "format2" => "Y"),$val[0],"STRING");
			$data[$i][1]  = $val[5];
			$data[$i][2]  = $val[2];
			$data[$i][3]  = $val[3];
			$data[$i][4]  = ($val[4] / $val[2]) * 100;
			$data[$i][5]  = $val[1];
			$data[$i][6]  = $val[2] / $val[1];
			$i ++;
		}		
		return $data;
	}

	function DefineQuery() {
		global $db;
		$query  = "SELECT FROM_UNIXTIME(timestamp, '%M %Y') AS month, COUNT(DISTINCT sessionid) AS visits, COUNT(*) AS requests, (COUNT(*) - SUM(IF(crawl='0','0',1))) AS viewed, SUM(IF(crawl='0','0',1)) AS crawled, COUNT(DISTINCT visitorid) AS visitors FROM ".$this->profile->tablename_merge." WHERE timestamp >= ". $db->quote($this->from) ." AND timestamp <= ". $db->quote($this->to) ." GROUP BY month ORDER BY timestamp";

		return $query;
	}
}
?>
