<?php
/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
require_once '../../AccessControl.php';
include "index.php";

$menu_items = array();
$menu_cat = array();

# define the menu categories
$menu_cat["_PROFILES"] = array("text" => _PROFILES, "icon" => "fa-folder-open");

# define the menu items
$menu_items["_MANAGE_PROFILES"] = array("text" => _MANAGE_PROFILES, "action" => "cp.ProfileTable()", "cat" => "_PROFILES");

if($session->canAddProfiles()){
	$menu_items["_CREATE_NEW_PROFILE"] = array("text" => _CREATE_NEW_PROFILE, "action" => "cp.CreateNewProfiles()", "cat" => "_PROFILES");	
}

# Admin only menu items 
if($session->isAdmin()){
	$menu_items["_IMPORT_PROFILES"] = array("text" => _IMPORT_PROFILES, "action" => "cp.ImportProfiles()", "cat" => "_PROFILES");
	$menu_cat["_USERS"] = array("text" => _USERS, "icon" => "fa-user");
	$menu_cat["_LOCALIZATION"] = array("text" => _LOCALIZATION, "icon" => "fa-globe");
	$menu_cat["_PRIVACY"] = array("text" => _PRIVACY, "icon" => "fa-eye");
	$menu_cat["_DATA_STORAGE"] = array("text" => _DATA_STORAGE, "icon" => "fa-archive");

	$menu_items["_ACTIVATE_PROFILES"] = array("text" => _ACTIVATE_PROFILES, "action" => "cp.ActivateAllProfiles()", "cat" => "_PROFILES");

	$menu_items["_EDIT_USER"] = array("text" => _EDIT_USER, "action" => "cp.CreateEditUser()", "cat" => "_USERS");
	$menu_items["_USER_ADMINISTRATION"] = array("text" => _USER_ADMINISTRATION, "action" => "cp.UserAdministration()", "cat" => "_USERS");
	$menu_items["_CREATE_NEW_USER"] = array("text" => _CREATE_NEW_USER, "action" => "cp.CreateEditUser()", "cat" => "_USERS");
	$menu_items["_AUTHENTICATION_METHOD"] = array("text" => _AUTHENTICATION_METHOD, "action" => "cp.AuthenticationMethod()", "cat" => "_USERS");


	$menu_items["_LANGUAGES"] = array("text" => _LANGUAGES, "action" => "cp.ChangeDefaultLang()", "cat" => "_LOCALIZATION");
	$menu_items["_DATE_FORMAT"] = array("text" => _DATE_FORMAT, "action" => "cp.ChangeDefaultDateFormat()", "cat" => "_LOCALIZATION");

	$menu_items["_IP_MASKING"] = array("text" => _IP_MASKING, "action" => "cp.IPmasking()", "cat" => "_PRIVACY");
	$menu_items["_EMAIL_ALERTS"] = array("text" => _EMAIL_ALERTS, "action" => "cp.EmailAlerts()", "cat" => "_PRIVACY");
	$menu_items["_USAGE_TRACKING"] = array("text" => _USAGE_TRACKING, "action" => "cp.UsageTracking()", "cat" => "_PRIVACY");

	$menu_items["_DATABASE_INFO"] = array("text" => _DATABASE_INFO, "action" => "cp.DatabaseInfo()", "cat" => "_DATA_STORAGE");
	$menu_items["_DATAMANAGER_SETTINGS"] = array("text" => _DATAMANAGER_SETTINGS, "action" => "cp.DataManager()", "cat" => "_DATA_STORAGE");
	$menu_items["_CHANGE_UPLOAD_DIR"] = array("text" => _CHANGE_UPLOAD_DIR, "action" => "cp.ChangeUploadDirectory()", "cat" => "_DATA_STORAGE");
	$menu_items["_URL_SENSITIVE"] = array("text" => _URL_SENSITIVE, "action" => "cp.UrlCaseSensitivity()", "cat" => "_DATA_STORAGE");
	
} else if($session->canEditUserInfo()){
	# only when not admin
	$menu_cat["_USER"] = array("text" => _USER, "icon" => "fa-user");
	$menu_items["_EDIT_USER"] = array("text" => _EDIT_USER, "action" => "cp.CreateEditUser()", "cat" => "_USER");
}

if($session->isAdmin()){
	$menu_cat["_SYSTEM"] = array("text" => _SYSTEM, "icon" => "fa-gears");		
	$menu_cat["_SOFTWARE"] = array("text" => _SOFTWARE, "icon" => "fa-cloud");

	if(@_LOGAHOLIC_EDITION == 5){
		$menu_items["_SETUP_REPORT_SUBSCRIPTIONS"] = array("text" => _SETUP_REPORT_SUBSCRIPTIONS, "action" => "cp.SetupSubscriptions()", "cat" => "_SYSTEM");
	}
	// $menu_items["_REPORT_STORE"] = array("text" => _REPORT_STORE, "action" => "cp.ChangeAffiliateID()", "cat" => "_SYSTEM");
	$menu_items["_CLUSTER_MANAGER"] = array("text" => _CLUSTER_MANAGER, "action" => "cp.ClusterManager()", "cat" => "_SYSTEM");

	$menu_items["_SIGNUP"] = array("text" => _ALLOW_SIGNUP, "action" => "cp.Signup()", "cat" => "_SYSTEM");

	$menu_items["_INSTALLATION_SETUP"] = array("text" => _INSTALLATION_SETUP, "action" => "cp.Installation()", "cat" => "_SOFTWARE");
	$menu_items["_GET_LICENSE"] = array("text" => _GET_LICENSE, "action" => "cp.GetLicense()", "cat" => "_SOFTWARE");
	$menu_items["_CHECK_FOR_UPDATES"] = array("text" => _CHECK_FOR_UPDATES, "action" => "cp.UpdateLogaholic()", "cat" => "_SOFTWARE");
	$menu_items["_UNINSTALL_LOGAHOLIC"] = array("text" => _UNINSTALL_LOGAHOLIC, "action" => "cp.UninstallLogaholic()", "cat" => "_SOFTWARE");
}


# merge menu items into cat array so js can easily loop thru it to make the menu
foreach($menu_items as $key => $val) {
	$menu_cat[$val['cat']]['data'][$key] = $menu_items[$key];
}

//has license?
$hl = false;
if (_LOGAHOLIC_EDITION != 0) {
	$hl = true;
} 
if ($ss) {
	$hl = true;
}
$str = json_encode(array(
	'Status' => 'Success',
	'languages' => $lang_labels,
	'profiles' => $plist,
	'pcount' => $pcount,
	'available_langs' => $available_langs,
	'lang' => $lang,
	'getdatafromstore' => $getdatafromstore,
	'session' => $session,
	'usage_tracking' => $usage_tracking,
	'hl' => $hl,
	'ss' => $ss,
	'menu_items' => $menu_items,
	'menu_cat' => $menu_cat,
	'version_check' => $must_load_version_check
));
ob_start();
echo $str;
print_gzipped_output();
?>