/* Logaholic Web Analytics software             Copyright(c) 2005-2016 Logaholic B.V.
 *                                                               All rights Reserved.
 * This code is subject to the Logaholic license. Unauthorized copying is prohibited.
 * support@logaholic.com                         http://www.logaholic.com/License.txt
*/ 
var userlist = {};
userlist.data = {};

userlist.GetModel = function(post_data, callback){
	$.ajax({
		url: "app/model/UserAdministration.php",
		type: "POST",
		data: post_data,
		success: function(result) {
			var data = ui.ParseJSON(result);
			// is there already a system response ? then cancel the model handling
			if( !$(".system-response .callout").is(":hidden") ){
				return;
			}

			if(data.Status == undefined){
				ui.SystemError({ Status : "Error", Message : ui.data.languages["_SOMETHING_WRONG_W_COLLECTING"] });
				return;
			}

			if(data.Message != undefined){
				ui.Callout(data);
			}
			
			callback(data);			
		}
	});
}

$(document).ready(function(){	
	userlist.GetModel({} , function(data){ userlist.FillTable(data.Users); });
});

userlist.FillTable = function(data){
	/* -- Get the template elements we need -- */

	userlist.data.users = {};

	table = $("#manage_users");
		
	table_row = table.find("tbody tr").clone(true);
	table.find("tbody").empty();

	/* -- fill the table -- */
	//console.log(data);
	$.each(data, function( key, value ) {
		userlist.data.users[ value.username ] = value;

		tr = table_row.clone(true);
		
		tr.find(".btn-group").show();

		if(parseInt(value.active) != 1) {			
			tr.find(".user-disabled").show();
			tr.find(".user-active").remove();
		} else {
			tr.find(".user-active").show();
			tr.find(".user-disabled").remove();
		}	

		tr.find(".table-username span").html(value.username);
		if(parseInt(value.isAdmin) > 0) {
			tr.find(".table-username").append('<span class="label admin-label label-primary" title="'+ ui.data.languages['_ADMIN_USERNAME'] +'">A</span>');			
		}	


		tr.find(".table-name").html(value.name);
		tr.find(".table-email").html(value.email);
		tr.find(".table-profiles").html(value.profiles);
		//console.log(value.metadata);
		if (value.subscriptionid!==null) {
			tr.find(".table-subs").html(value.subscriptionid);
		} else if (value.metadata.user_ss!==undefined) {			
			
			var d = new Date( parseInt(value.metadata.user_ss.current_period_end * 1000) );		
			var n = d.getFullYear() +"/"+ (parseInt(d.getMonth())+1) +"/"+ d.getDate();
			tr.find(".table-subs").html(value.metadata.user_ss.plan + ' ('+n+')');
		} else {
			tr.find(".table-subs").html(ui.data.languages['_NONE']);
		}		
		

		var d = new Date( parseInt(value.created * 1000) );		
		var n = d.getFullYear() +"/"+ (parseInt(d.getMonth())+1) +"/"+ d.getDate();
		tr.find(".table-created").html("<span style='display:none'>"+value.created+"</span>"+n);

		if(parseInt(value.lastlogin) > 0){
			d = new Date( value.lastlogin * 1000 );
			var n = d.getFullYear() +"/"+ (parseInt(d.getMonth())+1) +"/"+ d.getDate();

			tr.find(".table-login").html("<span style='display:none'>"+value.lastlogin+"</span>"+n);

		} else {
			tr.find(".table-login").html( ui.data.languages['_NEVER'] );
		}

		tr.find(".user-edit,.user-delete").attr("data-user", value.username);
		tr.find(".user-login").attr("data-login", value.lgpkey);


		table.find("tbody").append(tr);

	});		

	$(".user-content").html(table);
	table.find("tr").show();

	/* -- set up the data table for profiles -- */
	$('#manage_users table').dataTable({
	    "bPaginate": true,
	    "bLengthChange": true,
	    "bFilter": true,
	    "bSort": true,
	    "bInfo": true
	});
	ReplaceDataTablesSearch('#manage_users' , ui.data.languages["_SEARCH_USER_OR_PROFILES"] );

	$("#manage_users").on("click",".user-edit", function(e){
		cp.LoadView('app/views/CreateEditUser.php');

		var udata = $(this).attr("data-user");

		$.getScript( "app/controller/CreateEditUser.min.js" , function(){
			user.DisplayUser( userlist.data.users[ udata ] );
		});		
	});
	
	$("#manage_users").on("click",".user-login", function(e){
		e.preventDefault();

		ui.SetCookie('last_cp_action','_MANAGE_PROFILES');

		$.ajax({
			url: "app/model/Authentication.php",
			type: "POST",
			data: { action : "login", lgpkey : $(this).attr("data-login") },
			success: function(result) {
				var data = ui.ParseJSON(result);
				if(data.Status == "Success"){
					window.location.href = window.location.href;
				}	
			}
		});
	});

	
	$("#manage_users").on("click",".user-delete", function(){
		var c = confirm( ui.data.languages['_SURE_TO_DELETE_USER'] + ": "+ $(this).attr("data-user") +" ?" );
		if(c){
			userlist.GetModel({
				"deleteUser" : $(this).attr("data-user")
			} , function(data){ cp.UserAdministration(); ui.Callout(data); });
		}
	});
}