
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `Loaded66`
--

-- --------------------------------------------------------

--
-- Table structure for table `address_book`
--

CREATE TABLE `address_book` (
  `address_book_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `entry_gender` char(1) NOT NULL DEFAULT '',
  `entry_company` varchar(255) DEFAULT NULL,
  `entry_company_tax_id` varchar(255) DEFAULT NULL,
  `entry_firstname` varchar(100) NOT NULL DEFAULT '',
  `entry_lastname` varchar(100) NOT NULL DEFAULT '',
  `entry_street_address` varchar(255) NOT NULL DEFAULT '',
  `entry_suburb` varchar(100) DEFAULT NULL,
  `entry_postcode` varchar(10) NOT NULL DEFAULT '',
  `entry_city` varchar(100) NOT NULL DEFAULT '',
  `entry_state` varchar(100) DEFAULT NULL,
  `entry_country_id` int(11) NOT NULL DEFAULT '0',
  `entry_zone_id` int(11) NOT NULL DEFAULT '0',
  `entry_telephone` varchar(100) NOT NULL DEFAULT '',
  `entry_fax` varchar(100) NOT NULL DEFAULT '',
  `entry_email_address` varchar(96) NOT NULL DEFAULT '',
  PRIMARY KEY (`address_book_id`),
  KEY `idx_address_book_customers_id` (`customers_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `address_book`
--

INSERT INTO `address_book` VALUES
(1, 1, 'm', 'Loaded Commerce, LLC', '', 'Sal', 'Iozzia', '1211 CR 436', '', '33538', 'Panasoffkee', '', 223, 18, '800.609.2141', '', 'sal@loadedcommerce.com');

-- --------------------------------------------------------

--
-- Table structure for table `address_format`
--

CREATE TABLE `address_format` (
  `address_format_id` int(11) NOT NULL AUTO_INCREMENT,
  `address_format` varchar(128) NOT NULL DEFAULT '',
  `address_summary` varchar(48) NOT NULL DEFAULT '',
  PRIMARY KEY (`address_format_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

--
-- Dumping data for table `address_format`
--

INSERT INTO `address_format` VALUES
(1, '$firstname $lastname$cr$streets$cr$city, $postcode$cr$statecomma$country', '$city / $country'),
(2, '$firstname $lastname$cr$streets$cr$city, $state    $postcode$cr$country', '$city, $state / $country'),
(3, '$firstname $lastname$cr$streets$cr$city$cr$postcode - $statecomma$country', '$state / $country'),
(4, '$firstname $lastname$cr$streets$cr$city ($postcode)$cr$country', '$postcode / $country'),
(5, '$firstname $lastname$cr$streets$cr$postcode $city$cr$country', '$city / $country'),
(6, '$firstname $lastname$cr$streets$cr$city$cr$postcode$cr$country', '$city / $country'),
(7, '$firstname $lastname$cr$streets$cr$city$cr$state$cr$country', '$city / $country'),
(8, '$firstname $lastname$cr$streets$cr$city $postcode$cr$country', '$city / $country'),
(9, '$firstname $lastname$cr$streets$cr$postcode $city $state$cr$country', '$city / $country'),
(10, '$firstname $lastname$cr$streets$cr$city$cr$postcode $country', '$city / $country'),
(11, '$firstname $lastname$cr$streets$cr$city$cr$state$cr$postcode$cr$country', '$city / $country'),
(12, '$firstname $lastname$cr$streets$cr$city$cr$country $postcode', '$city / $country');

-- --------------------------------------------------------

--
-- Table structure for table `admin`
--

CREATE TABLE `admin` (
  `admin_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_groups_id` int(11) DEFAULT NULL,
  `admin_firstname` varchar(100) NOT NULL DEFAULT '',
  `admin_lastname` varchar(100) DEFAULT NULL,
  `admin_email_address` varchar(96) NOT NULL DEFAULT '',
  `admin_password` varchar(40) NOT NULL DEFAULT '',
  `admin_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `admin_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `admin_logdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `admin_lognum` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`admin_id`),
  UNIQUE KEY `admin_email_address` (`admin_email_address`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `admin`
--

INSERT INTO `admin` VALUES
(1, 1, '[[admin_fname]]', '[[admin_lname]]', '[[admin_email]]', '[[admin_pass]]', '[[regtime]]', '[[regtime]]', '0000-00-00 00:00:00', 0);

-- --------------------------------------------------------

--
-- Table structure for table `admin_files`
--

CREATE TABLE `admin_files` (
  `admin_files_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_files_name` varchar(255) NOT NULL DEFAULT '',
  `admin_files_is_boxes` tinyint(5) NOT NULL DEFAULT '0',
  `admin_files_to_boxes` int(11) NOT NULL DEFAULT '0',
  `admin_groups_id` set('1') NOT NULL DEFAULT '1',
  `query_string` varchar(255) NOT NULL DEFAULT '',
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `visible` tinyint(4) NOT NULL DEFAULT '1',
  `sort` int(11) NOT NULL DEFAULT '0',
  `sub_section` tinyint(4) NOT NULL DEFAULT '0',
  `fa_icon_name` varchar(100) NOT NULL DEFAULT '',
  `constant_name` varchar(100) NOT NULL DEFAULT '',
  `function_name` varchar(100) NOT NULL DEFAULT '',
  `admin_related_files` text NOT NULL,
  `addon_name` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`admin_files_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2111 ;

--
-- Dumping data for table `admin_files`
--

INSERT INTO `admin_files` VALUES
(1, 'administrator.php', 1, 0, '1', '', 1, 1, 0, 0, 'fa-user', 'BOX_HEADING_ADMINISTRATOR', '', '', ''),
(3, 'catalog.php', 1, 0, '1', '', 1, 1, 2, 0, 'fa-tasks', 'BOX_HEADING_CATALOG', '', '', ''),
(4, 'modules.php', 1, 0, '1', '', 1, 1, 12, 0, 'fa-cubes', 'BOX_HEADING_MODULES', '', '', ''),
(5, 'customers.php', 1, 0, '1', '', 1, 1, 3, 0, 'fa-users', 'BOX_HEADING_CUSTOMERS', '', '', ''),
(6, 'taxes.php', 1, 0, '1', '', 1, 1, 13, 0, 'fa-bank', 'BOX_HEADING_LOCATION_AND_TAXES', '', '', ''),
(7, 'localization.php', 1, 0, '1', '', 1, 1, 14, 0, 'fa-language', 'BOX_HEADING_LOCALIZATION', '', '', ''),
(8, 'reports.php', 1, 0, '1', '', 1, 1, 6, 0, 'fa-bar-chart-o', 'BOX_HEADING_REPORTS', '', '', ''),
(9, 'tools.php', 1, 0, '1', '', 1, 1, 15, 0, 'fa-wrench', 'BOX_HEADING_TOOLS', '', '', ''),
(10, 'design_controls.php', 1, 0, '1', '', 1, 1, 10, 0, 'fa-archive', 'BOX_HEADING_DESIGN_CONTROLS', '', '', ''),
(11, 'gv_admin.php', 1, 0, '1', '', 1, 1, 5, 0, 'fa-gift', 'BOX_HEADING_GV_ADMIN', '', '', ''),
(12, 'links.php', 1, 0, '1', '', 1, 1, 11, 0, 'fa-external-link-square', 'BOX_HEADING_LINKS', '', '', ''),
(15, 'data.php', 1, 0, '1', '', 1, 1, 7, 0, 'fa-database', 'BOX_HEADING_DATA', '', '', ''),
(16, 'articles.php', 1, 0, '1', '', 1, 1, 9, 0, 'fa-book', 'BOX_CDS_ARTICLES', '', '', ''),
(19, 'marketing.php', 1, 0, '1', '', 1, 1, 4, 0, 'fa-signal', 'BOX_HEADING_MARKETING', '', '', ''),
(20, 'information.php', 1, 0, '1', '', 1, 1, 8, 0, 'fa-info', 'BOX_CDS_HEADING', '', '', ''),
(100, 'admin_members.php', 0, 1, '1', 'selected_box=administrator&section=admin_members', 1, 1, 0, 0, '', 'BOX_ADMINISTRATOR_MEMBERS', '', '', ''),
(101, 'admin_files.php', 0, 1, '1', 'cID=1&selected_box=administrator&section=menu_file_access', 1, 1, 3, 0, '', 'BOX_ADMINISTRATOR_BOXES', '', '', ''),
(102, 'admin_account.php', 0, 1, '1', 'selected_box=administrator&section=update_account', 1, 1, 2, 0, '', 'BOX_ADMINISTRATOR_ACCOUNT_UPDATE', '', '', ''),
(103, 'admin_members.php', 0, 1, '1', 'gID=groups&selected_box=administrator&section=admin_groups', 1, 1, 1, 0, '', 'BOX_ADMINISTRATOR_GROUPS', '', '', ''),
(2002, 'configuration.php', 1, 0, '1', '', 1, 1, 1, 0, 'fa-gear', 'BOX_HEADING_CONFIGURATION', 'tep_configuration_menu', '', ''),
(300, 'categories.php', 0, 3, '1', 'selected_box=catalog&section=categories', 1, 1, 4, 0, '', 'BOX_CATALOG_CATEGORIES_PRODUCTS', '', '', ''),
(301, 'products_attributes.php', 0, 3, '1', 'selected_box=catalog&section=products_attributes', 1, 1, 5, 0, '', 'BOX_CATALOG_CATEGORIES_PRODUCTS_ATTRIBUTES', '', '', ''),
(302, 'manufacturers.php', 0, 3, '1', 'selected_box=catalog&section=manufacturers', 1, 1, 6, 0, '', 'BOX_CATALOG_MANUFACTURERS', '', '', ''),
(304, 'reviews.php', 0, 3, '1', 'selected_box=catalog&section=reviews', 1, 1, 7, 0, '', 'BOX_CATALOG_REVIEWS', '', '', ''),
(305, 'shopbyprice.php', 0, 3, '1', 'selected_box=catalog&section=shopbyprice', 1, 1, 8, 0, '', 'BOX_CATALOG_SHOP_BY_PRICE', '', '', ''),
(306, 'products_expected.php', 0, 3, '1', 'selected_box=catalog&section=products_expected', 1, 1, 11, 0, '', 'BOX_CATALOG_PRODUCTS_EXPECTED', '', '', ''),
(307, 'xsell_products.php', 0, 3, '1', 'selected_box=catalog&section=xsell_products', 1, 1, 9, 0, '', 'BOX_CATALOG_XSELL_PRODUCTS', '', '', ''),
(308, 'define_mainpage.php', 0, 20, '1', 'selected_box=information', 1, 1, 56, 0, '', 'BOX_CATALOG_DEFINE_MAINPAGE', '', '', ''),
(309, 'salemaker.php', 0, 2003, '1', '', 1, 1, 97, 0, '', '', '', '', ''),
(310, 'listcategories.php', 0, 2003, '1', '', 1, 1, 114, 0, '', '', '', '', ''),
(313, 'featured.php', 0, 3, '1', 'selected_box=catalog&section=featured', 1, 1, 10, 0, '', 'BOX_CATALOG_FEATURED', '', '', ''),
(314, 'salemaker_info.php', 0, 2003, '1', '', 1, 1, 115, 0, '', '', '', '', ''),
(315, 'epconfigure.php', 0, 2003, '1', '', 1, 1, 116, 0, '', '', '', '', ''),
(316, 'products_multi.php', 0, 2003, '1', '', 1, 1, 117, 0, '', '', '', '', ''),
(400, 'modules.php', 0, 4, '1', 'set=payment', 1, 1, 76, 0, '', 'BOX_MODULES_PAYMENT', '', '', ''),
(500, 'orders.php', 0, 5, '1', 'selected_box=customers&section=order', 1, 1, 12, 0, '', 'BOX_CUSTOMERS_ORDERS', '', '', ''),
(501, 'cre_marketplace.php', 0, 5, '1', 'selected_box=customers&section=marketplace', 1, 1, 20, 1, '', 'BOX_CRE_MARKETPLACE', '', '', ''),
(502, 'paypal.php', 0, 5, '1', '', 1, 1, 16, 0, '', 'BOX_CUSTOMERS_PAYPAL', '', '', ''),
(503, 'edit_orders.php', 0, 2003, '1', '', 1, 1, 118, 0, '', '', '', '', ''),
(504, 'create_account_success.php', 0, 2003, '1', '', 1, 1, 119, 0, '', '', '', '', ''),
(505, 'create_account_process.php', 0, 2003, '1', '', 1, 1, 120, 0, '', '', '', '', ''),
(506, 'create_order_admin.php', 0, 5, '1', 'selected_box=customers&section=orders_admin', 1, 1, 15, 0, '', 'BOX_CREATE_ORDERS_ADMIN', '', '', ''),
(507, 'create_account.php', 0, 5, '1', 'selected_box=customers&section=create_account', 1, 1, 19, 1, '', 'BOX_MANUAL_ORDER_CREATE_ACCOUNT', '', '', ''),
(508, 'create_order_process.php', 0, 2003, '1', '', 1, 1, 121, 0, '', '', '', '', ''),
(509, 'account_details.php', 0, 2003, '1', '', 1, 1, 122, 0, '', '', '', '', ''),
(510, 'ipn_test_panel.php', 0, 2003, '1', '', 1, 1, 123, 0, '', '', '', '', ''),
(511, '', 0, 5, '1', '', 1, 1, 17, 1, '', 'BOX_CUSTOMERS_MENU', '', '', ''),
(512, 'members.php', 0, 2003, '1', '', 1, 1, 124, 0, '', '', '', '', ''),
(513, 'create_order.php', 0, 5, '1', 'selected_box=customers&section=create_order', 1, 1, 14, 0, '', 'BOX_MANUAL_ORDER_CREATE_ORDER', '', '', ''),
(514, 'create_order_payment.php', 0, 2003, '1', '', 1, 1, 125, 0, '', '', '', '', ''),
(515, 'create_order_shipping.php', 0, 2003, '1', '', 1, 1, 126, 0, '', '', '', '', ''),
(517, 'customers.php', 0, 5, '1', 'selected_box=customers&section=customer', 1, 1, 18, 1, '', 'BOX_CUSTOMERS_CUSTOMERS', '', '', ''),
(600, 'countries.php', 0, 6, '1', '', 1, 1, 81, 0, '', 'BOX_TAXES_COUNTRIES', '', '', ''),
(601, 'zones.php', 0, 6, '1', '', 1, 1, 82, 0, '', 'BOX_TAXES_ZONES', '', '', ''),
(602, 'geo_zones.php', 0, 6, '1', '', 1, 1, 83, 0, '', 'BOX_TAXES_GEO_ZONES', '', '', ''),
(603, 'tax_classes.php', 0, 6, '1', '', 1, 1, 84, 0, '', 'BOX_TAXES_TAX_CLASSES', '', '', ''),
(604, 'tax_rates.php', 0, 6, '1', '', 1, 1, 85, 0, '', 'BOX_TAXES_TAX_RATES', '', '', ''),
(700, 'currencies.php', 0, 7, '1', '', 1, 1, 86, 0, '', 'BOX_LOCALIZATION_CURRENCIES', '', '', ''),
(701, 'languages.php', 0, 7, '1', '', 1, 1, 87, 0, '', 'BOX_LOCALIZATION_LANGUAGES', '', '', ''),
(702, 'orders_status.php', 0, 7, '1', '', 1, 1, 88, 0, '', 'BOX_LOCALIZATION_ORDERS_STATUS', '', '', ''),
(800, 'stats_products_viewed.php', 0, 8, '1', 'selected_box=reports&section=reports_products_viewed', 1, 1, 29, 0, '', 'BOX_REPORTS_PRODUCTS_VIEWED', '', '', ''),
(801, 'stats_products_purchased.php', 0, 8, '1', 'selected_box=reports&section=reports_products_purchased', 1, 1, 30, 0, '', 'BOX_REPORTS_PRODUCTS_PURCHASED', '', '', ''),
(802, 'stats_customers.php', 0, 8, '1', 'selected_box=reports&section=reports_orders_total', 1, 1, 34, 0, '', 'BOX_REPORTS_ORDERS_TOTAL', '', '', ''),
(803, 'stats_monthly_sales.php', 0, 8, '1', 'selected_box=reports&section=reports_monthly_sales', 1, 1, 41, 0, '', 'BOX_REPORTS_MONTHLY_SALES', '', '', ''),
(804, 'orderlist.php', 0, 2003, '1', '', 1, 1, 113, 0, '', '', '', '', ''),
(805, 'stats_sales_report2.php', 0, 8, '1', 'selected_box=reports&section=reports_sales_report', 1, 1, 36, 0, '', 'BOX_REPORTS_SALES_REPORT2', '', '', ''),
(806, 'stats_customers_orders.php', 0, 8, '1', 'selected_box=reports&section=reports_orders', 1, 1, 33, 0, '', 'BOX_REPORTS_CUSTOMERS_ORDERS', '', '', ''),
(807, 'stats_daily_products_sales_report.php', 0, 8, '1', 'selected_box=reports&section=reports_daily_orders', 1, 1, 37, 0, '', 'BOX_REPORTS_DAILY_PRODUCTS_ORDERS', '', '', ''),
(808, 'stats_wishlist.php', 0, 8, '1', 'selected_box=reports&section=reports_wishlist', 1, 1, 32, 0, '', 'BOX_REPORTS_CUSTOMER_WISHLIST', '', '', ''),
(809, 'stats_articles_viewed.php', 0, 8, '1', 'selected_box=reports&section=reports_articles_viewed', 1, 1, 31, 0, '', 'BOX_REPORTS_ARTICLES_VIEWED', '', '', ''),
(810, 'stats_products_notifications.php', 0, 8, '1', 'selected_box=reports&section=reports_product_notifications', 1, 1, 39, 0, '', 'BOX_REPORTS_PRODUCTS_NOTIFICATIONS', '', '', ''),
(811, 'stats_not_valid_users.php', 0, 8, '1', 'selected_box=reports&section=reports_invalid_user', 1, 1, 35, 0, '', 'BOX_REPORTS_NOT_VALID_USER', '', '', ''),
(812, 'stats_low_stock.php', 0, 8, '1', 'selected_box=reports&section=reports_low_stock', 1, 1, 40, 0, '', 'BOX_LOW_STOCK_REPORT', '', '', ''),
(900, 'backup.php', 0, 9, '1', '', 1, 1, 90, 0, '', 'BOX_TOOLS_BACKUP', '', '', ''),
(901, 'cache.php', 0, 9, '1', '', 1, 1, 91, 0, '', 'BOX_TOOLS_CACHE', '', '', ''),
(902, 'define_language.php', 0, 9, '1', '', 1, 1, 92, 0, '', 'BOX_TOOLS_DEFINE_LANGUAGE', '', '', ''),
(903, 'mail.php', 0, 9, '1', '', 1, 1, 94, 0, '', 'BOX_TOOLS_MAIL', '', '', ''),
(905, 'server_info.php', 0, 9, '1', '', 1, 1, 95, 0, '', 'BOX_TOOLS_SERVER_INFO', '', '', ''),
(906, 'whos_online.php', 0, 9, '1', '', 1, 1, 96, 0, '', 'BOX_TOOLS_WHOS_ONLINE', '', '', ''),
(907, 'backup_mysql.php', 0, 9, '1', '', 1, 1, 89, 0, '', 'BOX_TOOLS_MYSQL_BACKUP', '', '', ''),
(909, 'edit_textdata.php', 0, 2003, '1', '', 1, 1, 112, 0, '', '', '', '', ''),
(910, 'edit_textdata_help.php', 0, 2003, '1', '', 1, 1, 111, 0, '', '', '', '', ''),
(911, 'email_subjects.php', 0, 9, '1', '', 1, 1, 93, 0, '', 'BOX_TOOLS_EMAIL_SUBJECTS', '', '', ''),
(912, 'check_lang.php', 0, 2003, '1', '', 1, 1, 98, 0, '', '', '', '', ''),
(1000, 'infobox_configuration.php', 0, 10, '1', 'gID={template_id}', 1, 1, 72, 0, '', 'BOX_HEADING_BOXES_ADMIN', '', '', ''),
(1001, 'template_configuration.php', 0, 10, '1', 'cID={template_id}', 1, 1, 70, 0, '', 'BOX_HEADING_TEMPLATE_CONFIGURATION', '', '', ''),
(1002, 'header_tags_fill_tags.php', 0, 10, '1', '', 1, 1, 65, 0, '', 'BOX_HEADER_TAGS_FILL_TAGS', '', '', ''),
(1003, 'header_tags_english.php', 0, 10, '1', '', 1, 1, 64, 0, '', 'BOX_HEADER_TAGS_ENGLISH', '', '', ''),
(1004, 'header_tags_controller.php', 0, 10, '1', '', 1, 1, 63, 0, '', 'BOX_HEADER_TAGS_ADD_A_PAGE', '', '', ''),
(1005, 'template_admin.php', 0, 10, '1', '', 1, 1, 69, 0, '', 'BOX_HEADING_TEMPLATE_MANAGEMENT', '', '', ''),
(1006, 'header_tags_popup_help.php', 0, 2003, '1', '', 1, 1, 99, 0, '', '', '', '', ''),
(1007, 'branding_manager.php', 0, 10, '1', '', 1, 1, 67, 0, '', 'BOX_HEADING_BRANDING_MANAGER', '', '', ''),
(1100, 'coupon_admin.php', 0, 11, '1', 'selected_box=gv_admin&section=coupon_admin', 1, 1, 24, 0, '', 'BOX_COUPON_ADMIN', '', '', ''),
(1101, 'gv_queue.php', 0, 11, '1', 'selected_box=gv_admin&section=gv_queue', 1, 1, 26, 0, '', 'BOX_GV_ADMIN_QUEUE', '', '', ''),
(1102, 'gv_mail.php', 0, 11, '1', 'selected_box=gv_admin&section=gv_email', 1, 1, 27, 0, '', 'BOX_GV_ADMIN_MAIL', '', '', ''),
(1103, 'gv_sent.php', 0, 11, '1', 'selected_box=gv_admin&section=gv_sent', 1, 1, 28, 0, '', 'BOX_GV_ADMIN_SENT', '', '', ''),
(1104, 'coupon_restrict.php', 0, 2003, '1', '', 1, 1, 100, 0, '', '', '', '', ''),
(1105, 'validcategories.php', 0, 2003, '1', '', 1, 1, 101, 0, '', '', '', '', ''),
(1106, 'validproducts.php', 0, 2003, '1', '', 1, 1, 102, 0, '', '', '', '', ''),
(1107, 'listproducts.php', 0, 2003, '1', '', 1, 1, 103, 0, '', '', '', '', ''),
(1108, 'gv_report.php', 0, 11, '1', 'selected_box=gv_admin&section=gv_report', 1, 1, 25, 0, '', 'BOX_GV_REPORT', '', '', ''),
(1109, 'treeview.php', 0, 2003, '1', '', 1, 1, 104, 0, '', '', '', '', ''),
(1200, 'links.php', 0, 12, '1', '', 1, 1, 73, 0, '', 'BOX_LINKS_LINKS', '', '', ''),
(1201, 'link_categories.php', 0, 12, '1', '', 1, 1, 74, 0, '', 'BOX_LINKS_LINK_CATEGORIES', '', '', ''),
(1202, 'links_contact.php', 0, 12, '1', '', 1, 1, 75, 0, '', 'BOX_LINKS_LINKS_CONTACT', '', '', ''),
(1400, 'faq_manager.php', 0, 20, '1', 'selected_box=information', 1, 1, 54, 0, '', 'BOX_FAQ_MANAGER', '', '', ''),
(1405, 'faq_categories.php', 0, 20, '1', 'selected_box=information', 1, 1, 55, 0, '', 'BOX_FAQ_CATEGORIES', '', '', ''),
(1500, 'data.php', 0, 2003, '1', '', 1, 1, 105, 0, '', '', '', '', ''),
(1501, 'data_admin.php', 0, 2003, '1', '', 1, 1, 106, 0, '', '', '', '', ''),
(1502, 'data_help.php', 0, 15, '1', '', 1, 1, 49, 2, '', 'BOX_DATA_HELP', '', '', ''),
(1503, 'easypopulate_basic_export.php', 0, 15, '1', '', 1, 1, 46, 1, '', 'BOX_DATA_EASYPOPULATE_BASIC_EXPORT', '', '', ''),
(1504, 'easypopulate_basic_import.php', 0, 15, '1', '', 1, 1, 47, 1, '', 'BOX_DATA_EASYPOPULATE_BASIC_IMPORT', '', '', ''),
(1505, 'easypopulate_export.php', 0, 15, '1', '', 1, 1, 43, 0, '', 'BOX_DATA_EASYPOPULATE_EXPORT', '', '', ''),
(1506, 'easypopulate_import.php', 0, 15, '1', '', 1, 1, 44, 0, '', 'BOX_DATA_EASYPOPULATE_IMPORT', '', '', ''),
(1507, 'popup_data_help.php', 0, 2003, '1', '', 1, 1, 107, 0, '', '', '', '', ''),
(1508, 'popup_ep_help.php', 0, 2003, '1', '', 1, 1, 108, 0, '', '', '', '', ''),
(1509, 'google.php', 0, 2003, '1', '', 1, 1, 109, 0, '', '', '', '', ''),
(1510, '', 0, 15, '1', '', 1, 1, 48, 0, '', 'BOX_DATA', '', '', ''),
(1511, '', 0, 15, '1', '', 1, 1, 45, 0, '', 'BOX_DATA_EASYPOPULATE_BASIC', '', '', ''),
(1512, '', 0, 15, '1', '', 1, 1, 42, 0, '', 'BOX_DATA_EASYPOPULATE', '', '', ''),
(1513, 'google_pre1.php', 0, 2003, '1', '', 1, 1, 110, 0, '', '', '', '', ''),
(1600, 'authors.php', 0, 16, '1', '', 1, 1, 59, 0, '', 'BOX_ARTICLES_AUTHORS', '', '', ''),
(1601, 'articles_xsell.php', 0, 16, '1', '', 1, 1, 61, 0, '', 'BOX_ARTICLES_XSELL', '', '', ''),
(1602, 'articles_config.php', 0, 16, '1', '', 1, 1, 58, 0, '', 'BOX_ARTICLES_CONFIG', '', '', ''),
(1603, 'articles.php', 0, 16, '1', '', 1, 1, 57, 0, '', 'BOX_TOPICS_ARTICLES', '', '', ''),
(1604, 'article_reviews.php', 0, 16, '1', '', 1, 1, 60, 0, '', 'BOX_ARTICLES_REVIEWS', '', '', ''),
(1900, 'banner_statistics.php', 0, 2003, '1', '', 1, 1, 127, 0, '', '', '', '', ''),
(1901, 'banner_manager.php', 0, 19, '1', 'selected_box=marketing&section=banner_manager', 1, 1, 21, 0, '', 'BOX_MARKETING_BANNER_MANAGER', '', '', ''),
(1902, 'specials.php', 0, 19, '1', 'selected_box=marketing&section=specials', 1, 1, 22, 0, '', 'BOX_MARKETING_SPECIALS', '', '', ''),
(1903, 'newsletters.php', 0, 19, '1', 'selected_box=marketing&section=newsletter_manager', 1, 1, 23, 0, '', 'BOX_TOOLS_NEWSLETTER_MANAGER', '', '', ''),
(2000, 'pages.php', 0, 20, '1', 'selected_box=information', 1, 1, 50, 0, '', 'BOX_CDS_PAGE_MANAGER', '', '', ''),
(2001, 'cds_configuration.php', 0, 20, '1', 'selected_box=information&gID=480', 1, 1, 51, 0, '', 'BOX_CDS_CONFIGUARION', '', '', ''),
(2003, 'hidden.php', 1, 0, '1', '', 0, 1, 17, 0, '', 'BOX_HEADING_HIDDEN', '', '', ''),
(2005, 'stats_manufacturers_sales.php', 0, 8, '1', 'selected_box=reports&section=reports_manufacturer_sales', 1, 1, 38, 0, '', 'BOX_REPORTS_SALES_MANUFACTURERS', '', '', ''),
(2006, 'cds_backup_restore.php', 0, 20, '1', 'selected_box=information', 1, 1, 52, 0, '', 'BOX_CDS_BACKUP_RESTORE', '', '', ''),
(2007, '', 0, 20, '1', 'selected_box=information', 1, 1, 53, 0, '', 'BOX_CDS_FAQ', '', '', ''),
(2008, '', 0, 10, '1', '', 1, 1, 62, 0, '', 'BOX_HEADING_TEMPLATE_HEADER_TAGS', '', '', ''),
(2009, '', 0, 10, '1', '', 1, 1, 66, 0, '', 'BOX_HEADING_BRANDING_MANAGER', '', '', ''),
(2010, '', 0, 10, '1', '', 1, 1, 68, 0, '', 'BOX_HEADING_DESIGN_TEMPLATE', '', '', ''),
(2011, '', 0, 10, '1', '', 1, 1, 71, 0, '', 'BOX_HEADING_DESIGN_INFOBOX', '', '', ''),
(2012, 'modules.php', 0, 4, '1', 'set=shipping', 1, 1, 77, 0, '', 'BOX_MODULES_SHIPPING', '', '', ''),
(2013, 'modules.php', 0, 4, '1', 'set=ordertotal', 1, 1, 78, 0, '', 'BOX_MODULES_ORDER_TOTAL', '', '', ''),
(2014, 'modules.php', 0, 4, '1', 'set=checkout_success', 1, 1, 79, 0, '', 'BOX_MODULES_CHECKOUT_SUCCESS', '', '', ''),
(2015, 'modules.php', 0, 4, '1', 'set=addons', 1, 1, 80, 0, '', 'BOX_MODULES_ADDONS', '', '', ''),
(2110, 'edit_orders.php', 0, 5, '1', '', 1, 1, 13, 0, '', 'BOX_CUSTOMERS_EDIT_ORDERS', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `admin_groups`
--

CREATE TABLE `admin_groups` (
  `admin_groups_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_groups_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`admin_groups_id`),
  UNIQUE KEY `admin_groups_name` (`admin_groups_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `admin_groups`
--

INSERT INTO `admin_groups` VALUES
(1, 'Top Administrator');

-- --------------------------------------------------------

--
-- Table structure for table `algozone_fraud_queries`
--

CREATE TABLE `algozone_fraud_queries` (
  `order_id` varchar(6) NOT NULL DEFAULT '',
  `ip_address` varchar(30) NOT NULL DEFAULT '',
  `last_date_queried` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `fraud_level` varchar(5) DEFAULT NULL,
  `err_message` varchar(150) DEFAULT NULL,
  `distance_m` varchar(10) DEFAULT NULL,
  `distance_k` varchar(10) DEFAULT NULL,
  `country_code` varchar(21) DEFAULT NULL,
  `is_country_match` char(3) DEFAULT NULL,
  `is_free_email` char(3) DEFAULT NULL,
  `is_customer_phone_inloc` char(3) DEFAULT NULL,
  `proxy_level` varchar(5) DEFAULT NULL,
  `spam_level` varchar(5) DEFAULT NULL,
  `is_high_risk_country` varchar(5) DEFAULT NULL,
  `is_anonymous_proxy` char(3) DEFAULT NULL,
  `ip_city` varchar(21) DEFAULT NULL,
  `ip_region` varchar(21) DEFAULT NULL,
  `ip_isp` varchar(30) DEFAULT NULL,
  `ip_org` varchar(30) DEFAULT NULL,
  `ip_latitude` varchar(21) DEFAULT NULL,
  `ip_longitude` varchar(21) DEFAULT NULL,
  `bin_country_code` varchar(5) DEFAULT NULL,
  `is_bin_match` varchar(5) DEFAULT NULL,
  `is_bank_name_match` varchar(5) DEFAULT NULL,
  `bank_name` varchar(20) DEFAULT NULL,
  `is_bank_phone_match` varchar(5) DEFAULT NULL,
  `bank_phone` varchar(15) DEFAULT NULL,
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `articles`
--

CREATE TABLE `articles` (
  `articles_id` int(11) NOT NULL AUTO_INCREMENT,
  `articles_date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `articles_last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `articles_date_available` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `articles_status` tinyint(1) NOT NULL DEFAULT '0',
  `authors_id` int(11) NOT NULL DEFAULT '0',
  `articles_image` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`articles_id`),
  KEY `idx_articles_date_added` (`articles_date_added`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `articles`
--

INSERT INTO `articles` VALUES
(1, '0000-00-00 00:00:00', '2011-09-11 02:08:58', '2011-09-04 00:00:00', 1, 5, ''),
(2, '0000-00-00 00:00:00', '2011-09-11 02:11:06', '2011-09-07 00:00:00', 1, 1, ''),
(3, '0000-00-00 00:00:00', '2011-09-11 02:14:01', '2011-09-09 00:00:00', 1, 3, ''),
(4, '0000-00-00 00:00:00', '2011-09-11 02:16:49', '2011-09-07 00:00:00', 1, 2, ''),
(5, '0000-00-00 00:00:00', '2011-09-11 02:19:10', '2011-09-01 00:00:00', 1, 4, ''),
(6, '0000-00-00 00:00:00', '2011-09-11 02:22:27', '2011-09-02 00:00:00', 1, 1, ''),
(7, '0000-00-00 00:00:00', '2011-09-11 02:24:04', '2011-09-10 00:00:00', 1, 2, ''),
(8, '0000-00-00 00:00:00', '2011-09-11 02:25:42', '2011-09-11 00:00:00', 1, 4, ''),
(9, '0000-00-00 00:00:00', '2011-09-11 02:27:25', '2011-09-04 00:00:00', 1, 3, '');

-- --------------------------------------------------------

--
-- Table structure for table `articles_description`
--

CREATE TABLE `articles_description` (
  `articles_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `articles_name` varchar(255) NOT NULL DEFAULT '',
  `articles_description` text,
  `articles_url` varchar(255) DEFAULT NULL,
  `articles_viewed` int(5) DEFAULT '0',
  `articles_head_title_tag` varchar(80) DEFAULT NULL,
  `articles_head_desc_tag` text,
  `articles_head_keywords_tag` text,
  PRIMARY KEY (`articles_id`,`language_id`),
  KEY `articles_name` (`articles_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `articles_description`
--

INSERT INTO `articles_description` VALUES
(1, 1, 'Euismod mauris eu elit', 'Quisque libero cursus et, eros. Proin ultrices. Duis volutpat nunc sit amet metus. Aliquam erat volutpat. Nulla facilisis. Suspendisse commodo tincidunt nibh. Phasellus nulla. Integer vulputate, risus a ultricies adipiscing, enim mi tempor lorem, eget mollis lectus pede et risus.', '', 8, 'Nullam velit dui, ac libero nec ligula consectetuer rhoncus.', 'Integer tincidunt aliquam fames ac turpis egestas. Fusce aliquet magna a neque. Nullam ut nisi a odio semper cursus. Integer mollis.', 'tortor, dictum, eu, placerat, eget, venenatis'),
(2, 1, 'Maecenas iaculis ullamcorper viverra', 'Sed malesuada ac, eleifend vitae, erat. Vivamus nisi. Mauris nulla. Integer urna. Vivamus molestie dapibus ligula. Aliquam erat volutpat. Nulla dignissim. Maecenas ornare egestas ligula. Nullam feugiat placerat velit. Quisque varius. Nam porttitor scelerisque neque. Nullam nisl. Maecenas malesuada fringilla est. Mauris eu turpis. Nulla aliquet. Proin velit.', '', 1, 'Cras dolor dolor tempus non sapien', 'Cras eget nisi dictum augue malesuada malesuada egestas nunc sed libero. Proin sed turpis nec mauris blandit mattis.', 'mi, tempor, lorem, eget, mollis, lectus, pede, et'),
(3, 1, 'Curabitur consectetuer ipsum nunc id enim', '<p>Mauris sapien, cursus in, hendrerit consectetuer, cursus et, magna. Praesent interdum ligula eu enim. Etiam imperdiet dictum magna. Ut tincidunt orci quis lectus. Nullam suscipit, est ac facilisis facilisis, magna tellus faucibus leo, in lobortis tellus justo.</p>\r\n\r\n<p>Sed malesuada ac, eleifend vitae, erat. Vivamus nisi. Mauris nulla. Integer urna. Vivamus molestie dapibus ligula. Aliquam erat volutpat. Nulla dignissim. Maecenas ornare egestas ligula. Nullam feugiat placerat velit. Quisque varius. Nam porttitor scelerisque neque. Nullam nisl. Maecenas malesuada fringilla est. Mauris eu turpis. Nulla aliquet. Proin velit.</p>', '', 2, 'Ultricies adipiscing, enim mi'' tempor lorem eget', 'Aliquam auctor, velit eget laoreet posuere, enim imperdiet non, vestibulum nec, euismod in, dolor. Fusce feugiat. Lorem ipsum dolor sit amet, consectetuer adipiscing elit.', 'sagittis, duis, gravida, praesent, eu, nulla'),
(4, 1, 'Auctor ullamcorper nisl arcu iaculis enim', '<p>Dignissim lacus aliquam rutrum lorem ac risus. Morbi metus. Vivamus euismod urna. Nullam lobortis quam a felis ullamcorper viverra. Maecenas iaculis aliquet diam. Sed diam lorem, auctor quis, tristique ac, eleifend.</p>\r\n\r\n<p>Quisque nonummy ipsum non arcu. Vivamus sit amet risus. Donec egestas. Aliquam nec enim. Nunc ut erat. Sed nunc est, mollis non, cursus non, egestas a, dui. Cras pellentesque. Sed dictum. Proin!</p>', '', 8, 'Tempor erat neque non quam pellentesque habitant morbi tristique', 'Phasellus dolor elit, pellentesque a, facilisis non, eget massa. Suspendisse eleifend. Cras sed leo. Cras vehicula aliquet libero. Integer in magna.', 'interdum, feugiat, sed, nec, metus, facilisis, lorem, tristique, aliquet, phasellus, fermentum, convallis'),
(5, 1, 'Cras dictum mauris sagittis placerat', '<p>Proin a odio semper cursus. Integer mollis. Integer tincidunt aliquam arcu. Aliquam ultrices iaculis odio. Nam interdum enim non nisi. Aenean eget metus. In nec orci. Donec nibh. Quisque nonummy ipsum non arcu. Vivamus sit amet risus. Donec egestas. Aliquam nec enim. Nunc ut erat. Sed nunc est, mollis non, cursus non, egestas a, dui. Cras pellentesque. Sed dictum.</p>\r\n\r\n<p>Vivamus euismod urna. Nullam lobortis quam a felis ullamcorper viverra. Maecenas iaculis aliquet diam. Sed diam lorem, auctor quis, tristique ac, eleifend dignissim lacus. Aliquam rutrum lorem ac risus. Morbi metus. </p>', '', 0, 'Suspendisse commodo metus aliquam erat volutpat', 'Nam interdum a odio semper cursus. Integer mollis. Integer tincidunt aliquam arcu. Aliquam ultrices iaculis odio.', 'sociis, natoque, penatibus, et, magnis, dis, parturient, montes, nascetur'),
(6, 1, 'Blandit congue in scelerisque', '<p>Pellentesque, tellus sem mollis dui, in sodales elit erat vitae risus. Duis a mi fringilla mi lacinia mattis. Integer eu lacus. Quisque imperdiet, erat nonummy ultricies ornare, elit elit fermentum risus, at fringilla purus mauris a nunc. In at pede. Cras vulputate velit eu sem. Pellentesque ut ipsum ac mi eleifend egestas. Sed pharetra, felis eget varius ultrices, mauris.</p>\r\n\r\n<p>Duis a mi fringilla mi lacinia mattis. Integer eu lacus. Quisque imperdiet, erat nonummy ultricies ornare, elit elit fermentum risus, at fringilla purus mauris a nunc. In at pede. Cras vulputate velit eu sem. Pellentesque ut ipsum ac mi eleifend egestas. Suspendisse ac metus vitae velit egestas lacinia. Sed congue, elit sed consequat auctor, nunc nulla vulputate dui, nec tempus mauris erat eget.</p>', '', 4, 'In ornare aliquet molestie tellus aenean egestas hendrerit neque', 'Lacinia mattis. Integer eu lacus. Quisque imperdiet, erat nonummy ultricies ornare, elit elit fermentum risus, at fringilla purus mauris a nunc.', 'ridiculus, mus, aenean, eget, magna, suspendisse, tristique, neque, venenatis'),
(7, 1, 'Nulla facilisis volutpat', 'Et magnis dis parturient montes, nascetur ridiculus mus. Aenean eget magna. Suspendisse tristique neque venenatis lacus. Etiam bibendum fermentum metus. Aenean sed pede nec ante blandit viverra. Donec tempus, lorem fringilla ornare placerat, orci lacus vestibulum lorem, sit amet ultricies sem magna nec.', '', 0, 'Accumsan sed facilisis vita orci', 'Donec vitae erat vel pede blandit congue. In scelerisque scelerisque dui. Suspendisse ac metus vitae velit egestas lacinia. Sed congue, elit sed.', 'donec, consectetuer, mauris, id, sapien, cras, dolor, dolor tempus'),
(8, 1, 'Est congue aliquet vel vulputate', 'Tincidunt congue turpis. In condimentum. Donec at arcu. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Donec tincidunt. Donec vitae erat vel pede blandit congue. In scelerisque scelerisque dui. Suspendisse ac metus vitae velit egestas lacinia. Sed congue, elit sed consequat auctor, nunc nulla vulputate dui, nec tempus mauris erat eget.', '', 2, 'Euismod est arcu ac orci congue aliquet', 'Diam lorem, auctor quis, tristique ac, eleifend vitae, erat. Vivamus nisi. Mauris nulla. Integer urna.', 'lorem, ipsum, sodales, purus, in, molestie, tortor, nibh, sit, amet, orci'),
(9, 1, 'Dolor sit amet consectetuer', 'Auctor non, feugiat nec, diam. Duis mi enim, condimentum eget, volutpat ornare, facilisis eget, ipsum. Donec sollicitudin adipiscing ligula. Aenean gravida nunc sed pede. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Proin vel arcu eu odio tristique pharetra. Quisque ac libero nec ligula consectetuer rhoncus. Nullam velit et tatu.', '', 2, 'Nullam enim sed nulla ante iaculis nec', 'Cras pellentesque. Sed dictum. Proin eget odio. Aliquam vulputate ullamcorper magna. Sed eu eros. Nam consequat.', 'egestas, lacinia, sed, congue, elit, sed, consequat, auctor');

-- --------------------------------------------------------

--
-- Table structure for table `articles_to_topics`
--

CREATE TABLE `articles_to_topics` (
  `articles_id` int(11) NOT NULL DEFAULT '0',
  `topics_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`articles_id`,`topics_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `articles_to_topics`
--

INSERT INTO `articles_to_topics` VALUES
(1, 1),
(2, 1),
(3, 1),
(4, 2),
(5, 2),
(6, 3),
(7, 3),
(8, 3),
(9, 3);

-- --------------------------------------------------------

--
-- Table structure for table `articles_xsell`
--

CREATE TABLE `articles_xsell` (
  `ID` int(10) NOT NULL AUTO_INCREMENT,
  `articles_id` int(11) NOT NULL DEFAULT '0',
  `xsell_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` smallint(3) unsigned NOT NULL DEFAULT '9999',
  PRIMARY KEY (`ID`),
  KEY `idx_articles_id` (`articles_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=31 ;

--
-- Dumping data for table `articles_xsell`
--

INSERT INTO `articles_xsell` VALUES
(1, 4, 226, 1),
(2, 4, 1265, 1),
(3, 4, 1344, 1),
(4, 6, 1317, 1),
(5, 6, 833, 1),
(6, 6, 1498, 1),
(7, 6, 1003, 1),
(8, 6, 979, 1),
(9, 6, 1503, 1),
(10, 5, 1318, 1),
(11, 5, 1319, 1),
(12, 8, 1316, 1),
(13, 8, 1003, 1),
(14, 8, 1208, 1),
(30, 1, 1531, 1),
(29, 1, 763, 1),
(28, 1, 1500, 1),
(27, 1, 1535, 1),
(26, 1, 1134, 1),
(25, 1, 1006, 1),
(24, 7, 1291, 1);

-- --------------------------------------------------------

--
-- Table structure for table `article_reviews`
--

CREATE TABLE `article_reviews` (
  `reviews_id` int(11) NOT NULL AUTO_INCREMENT,
  `articles_id` int(11) NOT NULL DEFAULT '0',
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `customers_name` varchar(255) NOT NULL DEFAULT '',
  `reviews_rating` int(1) DEFAULT NULL,
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reviews_read` int(5) NOT NULL DEFAULT '0',
  `approved` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`reviews_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `article_reviews`
--

INSERT INTO `article_reviews` VALUES
(1, 3, 1157, 'Aubrey Bryant', 4, '2011-09-11 02:33:56', '2011-09-11 02:34:25', 5, 1),
(2, 8, 1133, 'Tad Washington', 3, '2011-09-11 02:37:07', '0000-00-00 00:00:00', 2, 1),
(3, 4, 1100, 'Norman Mcfadden', 5, '2011-09-11 02:37:55', '0000-00-00 00:00:00', 8, 1),
(4, 9, 1121, 'Ursa Maldonado', 4, '2011-09-11 02:38:50', '0000-00-00 00:00:00', 3, 1),
(5, 1, 1058, 'Sophia Hartman', 2, '2011-09-11 02:39:52', '0000-00-00 00:00:00', 0, 0),
(6, 6, 1083, 'Colt Cantrell', 5, '2011-09-11 02:41:02', '0000-00-00 00:00:00', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `article_reviews_description`
--

CREATE TABLE `article_reviews_description` (
  `reviews_id` int(11) NOT NULL DEFAULT '0',
  `languages_id` int(11) NOT NULL DEFAULT '0',
  `reviews_text` text NOT NULL,
  PRIMARY KEY (`reviews_id`,`languages_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `article_reviews_description`
--

INSERT INTO `article_reviews_description` VALUES
(1, 1, 'Consequat nec, mollis vitae, posuere at, velit. Cras lorem lorem, luctus ut, pellentesque eget, dictum placerat, augue. Sed molestie. Sed id risus quis diam luctus lobortis.'),
(2, 1, 'Mauris blandit enim consequat purus. Maecenas libero est, congue a, aliquet vel, vulputate eu, odio. Phasellus at augue id ante dictum cursus. Nunc mauris elit, dictum.'),
(3, 1, 'Dolor dolor, tempus non, lacinia at, iaculis quis, pede. Praesent eu dui. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.'),
(4, 1, 'Duis ac arcu torquent per conubia nostra, per inceptos hymenaeos. Mauris ut quam vel sapien imperdiet ornare. In faucibus. Morbi vehicula. Pellentesque tincidunt tempus risus. Donec egestas.'),
(5, 1, 'Sed id risus quis diam luctus lobortis. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Mauris ut quam vel sapien.'),
(6, 1, 'Proin sed turpis nec mauris blandit mattis. Cras eget nisi dictum augue malesuada malesuada. Integer id magna et ipsum cursus nunc sed libero.');

-- --------------------------------------------------------

--
-- Table structure for table `authors`
--

CREATE TABLE `authors` (
  `authors_id` int(11) NOT NULL AUTO_INCREMENT,
  `authors_name` varchar(255) NOT NULL DEFAULT '',
  `authors_image` varchar(255) DEFAULT NULL,
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`authors_id`),
  KEY `IDX_AUTHORS_NAME` (`authors_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `authors`
--

INSERT INTO `authors` VALUES
(1, 'Jane Thompson', NULL, '2011-09-11 01:53:50', '0000-00-00 00:00:00'),
(2, 'Paki Coley', NULL, '2011-09-11 01:54:23', '0000-00-00 00:00:00'),
(3, 'Joelle Gallagher', NULL, '2011-09-11 01:55:07', '0000-00-00 00:00:00'),
(4, 'Declan de Vazquez', NULL, '2011-09-11 01:55:57', '0000-00-00 00:00:00'),
(5, 'Ashley Fuentes', NULL, '2011-09-11 01:56:37', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `authors_info`
--

CREATE TABLE `authors_info` (
  `authors_id` int(11) NOT NULL DEFAULT '0',
  `languages_id` int(11) NOT NULL DEFAULT '0',
  `authors_description` text,
  `authors_url` varchar(255) NOT NULL DEFAULT '',
  `url_clicked` int(5) NOT NULL DEFAULT '0',
  `date_last_click` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`authors_id`,`languages_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `authors_info`
--

INSERT INTO `authors_info` VALUES
(1, 1, '<p>\r\n  Fermentum convallis ligula. Donec luctus aliquet odio. Etiam ligula tortor, dictum eu, placerat eget, venenatis a, magna. Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Etiam laoreet, libero et tristique pellentesque, tellus sem mollis dui, in sodales elit erat vitae risus.</p>', '', 0, '0000-00-00 00:00:00'),
(2, 1, '<p>\r\n  Fringilla purus mauris a nunc. In at pede. Cras vulputate velit eu sem. Pellentesque ut ipsum ac mi eleifend egestas. Sed pharetra, felis eget varius ultrices, mauris ipsum porta elit, a feugiat tellus lorem eu metus. In lorem. Donec elementum, lorem ut aliquam iaculis, lacus pede sagittis augue, eu atest.</p>', '', 0, '0000-00-00 00:00:00'),
(3, 1, '<p>\r\n  Sed auctor odio a purus. Duis elementum, dui quis accumsan convallis, ante lectus convallis est, vitae sodales nisi magna sed dui. Fusce aliquam, enim nec tempus scelerisque, lorem ipsum sodales purus, in molestie tortor nibh sit amet orci.</p>', '', 0, '0000-00-00 00:00:00'),
(4, 1, '<p>\r\n  Aliquam turpis egestas. Fusce aliquet magna a neque. Nullam ut nisi a odio semper cursus. Integer mollis. Integer tincidunt aliquam arcu. Aliquam ultrices iaculis odio. Nam interdum enim non nisi. Aenean eget metus. In nec orci. Donec nibh. Quisque nonummy ipsum non arcu. Vivamus sit amet risus. Donec egestas.</p>', '', 0, '0000-00-00 00:00:00'),
(5, 1, '<p>\r\n  Suspendisse eleifend porttitor scelerisque neque. Nullam nisl. Maecenas malesuada fringilla est. Mauris eu turpis. Nulla aliquet. Proin velit. Sed malesuada augue ut lacus. Nulla tincidunt, neque vitae semper egestas, urna justo faucibus lectus, a sollicitudin orci sem eget massa. Cras sed leo.</p>', '', 0, '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `banners`
--

CREATE TABLE `banners` (
  `banners_id` int(11) NOT NULL AUTO_INCREMENT,
  `banners_title` varchar(255) NOT NULL DEFAULT '',
  `banners_url` varchar(255) NOT NULL DEFAULT '',
  `banners_image` varchar(255) NOT NULL DEFAULT '',
  `banners_group` varchar(10) NOT NULL DEFAULT '',
  `banners_html_text` text,
  `expires_impressions` int(7) DEFAULT '0',
  `expires_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_scheduled` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_status_change` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`banners_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `banners`
--

INSERT INTO `banners` VALUES
(1, 'Find Everything Right Here', '', 'LC-CE-slider-1.png', 'HOMESLIDER', '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2018-07-24 07:41:30', '2018-08-15 06:07:04', 1),
(2, 'Discover the Amazing Quality', '', 'LC-CE-slider-2.png', 'HOMESLIDER', '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2018-07-24 07:42:43', '2018-08-15 06:07:04', 1),
(3, 'Guaranteed Satisfication', '', 'LC-CE-slider-3.png', 'HOMESLIDER', '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2018-07-24 07:43:41', '2018-08-15 06:07:04', 1);

-- --------------------------------------------------------

--
-- Table structure for table `banners_history`
--

CREATE TABLE `banners_history` (
  `banners_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `banners_id` int(11) NOT NULL DEFAULT '0',
  `banners_shown` int(5) NOT NULL DEFAULT '0',
  `banners_clicked` int(5) NOT NULL DEFAULT '0',
  `banners_history_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`banners_history_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `branding_description`
--

CREATE TABLE `branding_description` (
  `store_brand_image` varchar(255) NOT NULL DEFAULT '',
  `store_brand_favicon` varchar(255) NOT NULL DEFAULT '',
  `store_og_image` varchar(255) NOT NULL DEFAULT '',
  `store_brand_slogan` varchar(96) NOT NULL DEFAULT '',
  `store_brand_telephone` varchar(16) NOT NULL DEFAULT '',
  `store_brand_fax` varchar(16) NOT NULL DEFAULT '',
  `store_brand_homepage` varchar(255) NOT NULL DEFAULT '',
  `store_brand_name` varchar(255) NOT NULL DEFAULT '',
  `store_brand_support_email` varchar(128) NOT NULL DEFAULT '',
  `store_brand_support_phone` varchar(16) NOT NULL DEFAULT '',
  `store_brand_address` text NOT NULL,
  `facebook_link` varchar(255) NOT NULL DEFAULT '',
  `twitter_link` varchar(255) NOT NULL DEFAULT '',
  `pinterest_link` varchar(255) NOT NULL DEFAULT '',
  `google_link` varchar(255) NOT NULL DEFAULT '',
  `youtube_link` varchar(255) NOT NULL DEFAULT '',
  `linkedin_link` varchar(255) NOT NULL DEFAULT '',
  `footer_text` text NOT NULL,
  `custom_css` text NOT NULL,
  `site_settings` longtext NOT NULL,
  `language_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `branding_description`
--

INSERT INTO `branding_description` VALUES
('LoadedCommerceSiteLogo.png', 'loaded-favicon-64.gif', '', '', '216.220.8766', '216.220.8768', 'http://www.loadedcommerce.com/', 'Loaded Commerce Professional CE', 'sales@loadedcommerce.com', '800.609.2141', 'Loaded Commerce, LLC\n1211 CR 436\nLake Panasoffkee, FL 33538\nPhone: 216.220.8766\nToll-Free: 800.609.2141\nFax: 216.220.8768', 'https://www.facebook.com/loadedcommerce', 'https://twitter.com/loadedcommerce', '', '', '', '', '', '', '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `cache_data`
--

CREATE TABLE `cache_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cache_code` varchar(100) NOT NULL,
  `cache_data` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `card_blacklist`
--

CREATE TABLE `card_blacklist` (
  `blacklist_id` int(5) NOT NULL AUTO_INCREMENT,
  `blacklist_card_number` varchar(20) NOT NULL DEFAULT '',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`blacklist_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `categories_id` int(11) NOT NULL AUTO_INCREMENT,
  `categories_image` varchar(255) DEFAULT NULL,
  `categories_banner_image` varchar(255) DEFAULT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` smallint(3) unsigned NOT NULL DEFAULT '9999',
  `products_group_access` varchar(255) NOT NULL DEFAULT 'G,0',
  `products_nav_access` varchar(255) NOT NULL DEFAULT 'G,0',
  `categories_status` tinyint(1) NOT NULL DEFAULT '1',
  `show_in_top_nav` int(1) NOT NULL DEFAULT '0',
  `show_in_side_nav` int(1) NOT NULL DEFAULT '1',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`categories_id`),
  KEY `idx_categories_parent_id` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `categories`
--

INSERT INTO `categories` VALUES
(1, 'cam1.jpg', NULL, 0, 20, '0,G,1', '', 1, 1, 1, '2016-07-11 07:41:06', '2018-07-30 10:18:49'),
(2, '18-200x200.jpg', NULL, 0, 40, '0,G,1', '', 1, 1, 1, '2016-07-11 07:45:12', '2018-07-30 10:20:37'),
(3, 'f8.jpg', NULL, 0, 10, '0,G,1', '', 1, 1, 1, '2016-07-11 07:45:36', '2018-07-30 10:23:45'),
(4, 'fff1234.jpg', NULL, 3, 0, '0,G,1', '', 1, 1, 1, '2016-07-11 07:46:08', '2018-07-30 10:30:29'),
(5, '8-330x330.jpg', NULL, 3, 0, '0,G,1', '', 1, 1, 1, '2016-07-11 07:46:35', '2018-07-30 10:26:29'),
(6, 'fff1234.jpg', NULL, 0, 30, '0,G,1', '', 1, 1, 1, '2016-07-11 07:47:49', '2018-07-30 10:19:41'),
(7, 'p3.jpg', NULL, 0, 50, '0,G,1', '', 1, 1, 1, '2016-07-11 07:48:21', '2018-07-30 10:21:01'),
(8, 'p1.jpg', NULL, 7, 0, '0,G,1', '', 1, 1, 1, '2016-07-11 07:48:51', '2016-07-11 09:56:17'),
(9, 'p6.jpg', NULL, 7, 0, '0,G,1', '', 1, 1, 1, '2016-07-11 07:50:04', '2016-07-11 09:57:17');

-- --------------------------------------------------------

--
-- Table structure for table `categories_description`
--

CREATE TABLE `categories_description` (
  `categories_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `categories_name` varchar(255) NOT NULL DEFAULT '',
  `categories_heading_title` varchar(255) DEFAULT NULL,
  `categories_description` text,
  `categories_head_title_tag` varchar(80) DEFAULT NULL,
  `categories_head_desc_tag` longtext NOT NULL,
  `categories_head_keywords_tag` longtext NOT NULL,
  `categories_htc_title_tag` varchar(80) DEFAULT NULL,
  `categories_htc_desc_tag` longtext,
  `categories_htc_keywords_tag` longtext,
  `categories_htc_description` longtext,
  `permalink_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`categories_id`,`language_id`),
  KEY `idx_categories_name` (`categories_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `categories_description`
--

INSERT INTO `categories_description` VALUES
(1, 1, 'Digital Camera', 'Digital Camera', '<p>Shop for popular Digital Cameras such as Digital SLRs, Point &amp; Shoot Cameras, Mirrorless Cameras, Camera Lenses, Camera Cases &amp; Bags and other Camera Accessories from Brands such as Canon, Nikon, Sony, Olympus, Fujifilm, Lowepro and many more. Buy cameras and other photography equipment and devices such as Camcorders, Binoculars &amp; Telescopes, CCTV Cameras, Surveillance Cameras, Projectors, Action Cameras and Digital Photo Frames</p>', '', '', '', NULL, NULL, NULL, NULL, ''),
(2, 1, 'Mobile Phones', 'Mobile Phones', 'Bestsellers. Add-on the perfect accessory to your mobile. Find Cases & Covers, Screen Protectors, Power banks, Bluetooth headsets, Wired Headsets, Data Cables, Mobile Chargers, Mobile utility/antivirus software and more', '', '', '', NULL, NULL, NULL, NULL, ''),
(3, 1, 'Accessories', 'Accessories', 'a subordinate or supplementary part, object, or the like, used mainly for convenience, attractiveness, safety, etc., as a spotlight on an automobile or a lens cover on a camera.', '', '', '', NULL, NULL, NULL, NULL, ''),
(4, 1, 'Mobile Accessories', 'Mobile Accessories', 'Add-on the perfect accessory to your mobile. Find Cases & Covers, Screen Protectors, Power banks, Bluetooth headsets, Wired Headsets, Data Cables, Mobile Chargers, Mobile utility/antivirus software and more.', '', '', '', NULL, NULL, NULL, NULL, ''),
(5, 1, 'Desktop Accessories', 'Desktop Accessories', '<p>The comprehensive range of desk accessories and storage products make sure your desk is clutter free and you find all the items right when you need it. It reduces the trouble of buying a new item that is possibly laying somewhere in your messy cupboard.</p>', '', '', '', NULL, NULL, NULL, NULL, ''),
(6, 1, 'Laptops', 'Laptops', '<p>Shop for a wide range of Laptops from top brands like HP, Dell, Lenovo, Acer, Apple, Asus, Microsoft, Intel and more. Popular searches:New releases in laptops, Laptop deals, Laptops under Rs.20,000, Touchscreen laptops, Gaming laptops, Windows 10 Laptops, i7 Laptops, i5 Laptops, Refurbished Laptops</p>', '', '', '', NULL, NULL, NULL, NULL, ''),
(7, 1, 'Personal Care', 'Personal Care', 'The Natural Products Association (NPA) recognised BASF for having the largest selection of ingredients for cosmetic manufacturers who want to certify their products according to the NPA Natural Standard.', '', '', '', NULL, NULL, NULL, NULL, ''),
(8, 1, 'Men', '', '', '', '', '', NULL, NULL, NULL, NULL, ''),
(9, 1, 'Women', 'Women', '', '', '', '', NULL, NULL, NULL, NULL, '');

-- --------------------------------------------------------

--
-- Table structure for table `components`
--

CREATE TABLE `components` (
  `components_id` int(11) NOT NULL AUTO_INCREMENT,
  `serial_1` varchar(255) NOT NULL DEFAULT '',
  `serial_2` varchar(255) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `last_validated` date NOT NULL DEFAULT '0000-00-00',
  `validation_product` varchar(255) NOT NULL DEFAULT '',
  `expiration_date` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`components_id`,`validation_product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `configuration`
--

CREATE TABLE `configuration` (
  `configuration_id` int(11) NOT NULL AUTO_INCREMENT,
  `configuration_title` varchar(255) NOT NULL DEFAULT '',
  `configuration_key` varchar(255) NOT NULL DEFAULT '',
  `configuration_value` varchar(255) NOT NULL DEFAULT '',
  `configuration_description` varchar(255) NOT NULL DEFAULT '',
  `configuration_group_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` smallint(3) unsigned NOT NULL DEFAULT '9999',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `use_function` varchar(255) DEFAULT NULL,
  `set_function` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`configuration_id`),
  UNIQUE KEY `idx_configuration_key` (`configuration_key`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3282 ;

--
-- Dumping data for table `configuration`
--

INSERT INTO `configuration` VALUES
(1, 'Store Name', 'STORE_NAME', 'Loaded Commerce Community Edition', 'The name of my store', 1, 1, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2, 'Store Owner', 'STORE_OWNER', 'Sal Iozzia', 'The name of my store owner', 1, 2, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3, 'E-Mail Address', 'STORE_OWNER_EMAIL_ADDRESS', 'me@mail.com', 'The e-mail address of my store owner', 1, 3, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(5, 'Country', 'STORE_COUNTRY', '223', 'The country my store is located in <br><br><b>Note: Please remember to update the store zone.</b>', 1, 5, '0000-00-00 00:00:00', '[[regtime]]', 'tep_get_country_name', 'tep_cfg_pull_down_country_list('),
(6, 'Zone', 'STORE_ZONE', '18', 'The zone my store is located in', 1, 6, '0000-00-00 00:00:00', '[[regtime]]', 'tep_cfg_get_zone_name', 'tep_cfg_pull_down_zone_list('),
(7, 'Time Zone', 'STORE_TIME_ZONE', 'America/New_York', 'The Time Zone my store is located in', 1, 7, '0000-00-00 00:00:00', '[[regtime]]', 'tep_cfg_get_zone_name', 'tep_cfg_pull_down_timezone_list('),
(9, 'Switch To Default Language Currency', 'USE_DEFAULT_LANGUAGE_CURRENCY', 'false', 'Automatically switch to the language''s currency when it is changed', 1, 9, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(10, 'Send Extra Order Emails To', 'SEND_EXTRA_ORDER_EMAILS_TO', '', 'Send extra order emails to the following email addresses, in this format: Name 1 &lt;email@address1&gt;, Name 2 &lt;email@address2&gt;', 1, 10, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(11, 'Allow Guest To Tell A Friend', 'ALLOW_GUEST_TO_TELL_A_FRIEND', 'false', 'Allow guests to tell a friend about a product', 1, 12, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(12, 'Default Search Operator', 'ADVANCED_SEARCH_DEFAULT_OPERATOR', 'and', 'Default search operators', 1, 13, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''and'', ''or''),'),
(13, 'Store Address and Phone', 'STORE_NAME_ADDRESS', 'Loaded Commerce, LLC\r\n1211 CR 436\r\nLake Panasoffkee, FL 33538\r\nPhone: 216.220.8766\r\nToll-Free: 800.609.2141\r\nFax: 216.220.8768', 'This is the Store Name, Address and Phone used on printable documents and displayed online', 1, 14, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_textarea('),
(14, 'Show Category Counts', 'SHOW_COUNTS', 'false', 'Count recursively how many products are in each category', 1, 15, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(15, 'Tax Decimal Places', 'TAX_DECIMAL_PLACES', '0', 'Pad the tax value this amount of decimal places', 1, 16, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(16, 'Display Prices with Tax', 'DISPLAY_PRICE_WITH_TAX', 'false', 'Display prices with tax included (true) or add the tax at the end (false)', 1, 17, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(18, 'Store Logo', 'STORE_LOGO', 'LoadedCommerceSiteLogo.png', 'This is the logo for my store, for receipts', 1, 19, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(19, 'Welcome Gift Voucher Amount', 'NEW_SIGNUP_GIFT_VOUCHER_AMOUNT', '0', 'Welcome Gift Voucher Amount: If you do not wish to send a Gift Voucher in your create account email put 0 for no amount else if you do place the amount here i.e. 10.00 or 50.00 no currency signs', 1, 31, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(20, 'Welcome Discount Coupon Code', 'NEW_SIGNUP_DISCOUNT_COUPON', '', 'Welcome Discount Coupon Code: if you do not want to send a coupon in your create account email leave blank else place the coupon code you wish to use', 1, 20, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(21, 'Allow Category Descriptions', 'ALLOW_CATEGORY_DESCRIPTIONS', 'true', 'Allow use of full text descriptions for categories', 1, 21, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(22, 'Enable Admin Dhtml menu', 'MENU_DHTML', 'False', 'Do you want to display top DHTML menu?', 1, 22, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''True'', ''False''),'),
(23, 'Use US or UK style formats for English language', 'ENGLISH_LANGAUGE_SET', 'us', 'Use US or UK style formats for English language defines, This setting switches between the two formats', 1, 23, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''us'', ''uk''),'),
(24, 'Category/Products Display Order', 'CATEGORIES_SORT_ORDER', 'PRODUCT_LIST_MODEL', '<b>Valid Orders:<br>products_name<br>products name<br>products model<br>manufacturer<br>products price</b>', 1, 24, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''PRODUCT_LIST_MODEL'', ''PRODUCT_LIST_NAME'', ''PRODUCT_LIST_MANUFACTURER'', ''PRODUCT_LIST_PRICE''),'),
(101, 'First Name', 'ENTRY_FIRST_NAME_MIN_LENGTH', '2', 'Minimum length of first name', 2, 1, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(102, 'Last Name', 'ENTRY_LAST_NAME_MIN_LENGTH', '2', 'Minimum length of last name', 2, 2, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(103, 'Date of Birth', 'ENTRY_DOB_MIN_LENGTH', '10', 'Minimum length of date of birth', 2, 3, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(104, 'E-Mail Address', 'ENTRY_EMAIL_ADDRESS_MIN_LENGTH', '6', 'Minimum length of e-mail address', 2, 4, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(105, 'Street Address', 'ENTRY_STREET_ADDRESS_MIN_LENGTH', '5', 'Minimum length of street address', 2, 5, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(106, 'Company', 'ENTRY_COMPANY_MIN_LENGTH', '2', 'Minimum length of company name', 2, 6, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(107, 'Post Code', 'ENTRY_POSTCODE_MIN_LENGTH', '4', 'Minimum length of post code', 2, 7, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(108, 'City', 'ENTRY_CITY_MIN_LENGTH', '3', 'Minimum length of city', 2, 8, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(109, 'State', 'ENTRY_STATE_MIN_LENGTH', '2', 'Minimum length of state', 2, 9, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(110, 'Telephone Number', 'ENTRY_TELEPHONE_MIN_LENGTH', '3', 'Minimum length of telephone number', 2, 10, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(111, 'Password', 'ENTRY_PASSWORD_MIN_LENGTH', '6', 'Minimum length of password. Suggested length = 12', 2, 11, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(112, 'Credit Card Owner Name', 'CC_OWNER_MIN_LENGTH', '3', 'Minimum length of credit card owner name', 2, 12, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(113, 'Credit Card Number', 'CC_NUMBER_MIN_LENGTH', '10', 'Minimum length of credit card number', 2, 13, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(114, 'Review Text', 'REVIEW_TEXT_MIN_LENGTH', '50', 'Minimum length of review text', 2, 14, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(115, 'Best Sellers', 'MIN_DISPLAY_BESTSELLERS', '1', 'Minimum number of best sellers to display', 2, 15, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(116, 'Also Purchased', 'MIN_DISPLAY_ALSO_PURCHASED', '1', 'Minimum number of products to display in the ''This Customer Also Purchased'' box', 2, 16, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(117, 'X-Sell', 'MIN_DISPLAY_XSELL', '1', 'Minimum number of X-sell products to display', 2, 17, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(201, 'Address Book Entries', 'MAX_ADDRESS_BOOK_ENTRIES', '5', 'Maximum address book entries a customer is allowed to have', 3, 1, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(202, 'Search Results', 'MAX_DISPLAY_SEARCH_RESULTS', '6', 'Number of products to list', 3, 2, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(203, 'Page Links', 'MAX_DISPLAY_PAGE_LINKS', '10', 'Number of ''number'' links to use for page-sets', 3, 3, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(204, 'Special Products', 'MAX_DISPLAY_SPECIAL_PRODUCTS', '4', 'Maximum number of products on special to display', 3, 4, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(205, 'New Products Module', 'MAX_DISPLAY_NEW_PRODUCTS', '4', 'Maximum number of new products to display in a category', 3, 5, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(206, 'Products Expected', 'MAX_DISPLAY_UPCOMING_PRODUCTS', '4', 'Maximum number of products expected to display', 3, 6, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(207, 'Manufacturers List', 'MAX_DISPLAY_MANUFACTURERS_IN_A_LIST', '5', 'Used in manufacturers box; when the number of manufacturers exceeds this number, a drop-down list will be displayed instead of the default list', 3, 7, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(208, 'Manufacturers Select Size', 'MAX_MANUFACTURERS_LIST', '1', 'Used in manufacturers box; when this value is ''1'' the classic drop-down list will be used for the manufacturers box. Otherwise, a list-box with the specified number of rows will be displayed.', 3, 8, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(209, 'Length of Manufacturers Name', 'MAX_DISPLAY_MANUFACTURER_NAME_LEN', '15', 'Used in manufacturers box; maximum length of manufacturers name to display', 3, 9, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(210, 'New Reviews', 'MAX_DISPLAY_NEW_REVIEWS', '6', 'Maximum number of new reviews to display', 3, 10, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(211, 'Selection of Random Reviews', 'MAX_RANDOM_SELECT_REVIEWS', '4', 'How many records to select from to choose one random product review', 3, 11, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(212, 'Selection of Random New Products', 'MAX_RANDOM_SELECT_NEW', '4', 'How many records to select from to choose one random new product to display', 3, 12, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(213, 'Selection of Products on Special', 'MAX_RANDOM_SELECT_SPECIALS', '5', 'How many records to select from to choose one random product special to display', 3, 13, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(214, 'Categories To List Per Row', 'MAX_DISPLAY_CATEGORIES_PER_ROW', '2', 'How many categories to list per row', 3, 14, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(215, 'New Products Listing', 'MAX_DISPLAY_PRODUCTS_NEW', '8', 'Maximum number of new products to display in new products page', 3, 15, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(216, 'Best Sellers', 'MAX_DISPLAY_BESTSELLERS', '10', 'Maximum number of best sellers to display', 3, 16, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(217, 'Also Purchased', 'MAX_DISPLAY_ALSO_PURCHASED', '6', 'Maximum number of products to display in the ''This Customer Also Purchased'' box', 3, 17, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(218, 'Customer Order History Box', 'MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX', '6', 'Maximum number of products to display in the customer order history box', 3, 18, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(219, 'Order History', 'MAX_DISPLAY_ORDER_HISTORY', '10', 'Maximum number of orders to display in the order history page', 3, 19, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(220, 'Product Featured Maximum Display', 'MAX_DISPLAY_FEATURED_PRODUCTS', '6', 'Number of products to display on main page', 3, 20, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(221, 'Product Featured Display Results', 'MAX_DISPLAY_FEATURED_PRODUCTS_LISTING', '10', 'Number of products to list per page', 3, 21, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(222, 'Max Wish List', 'MAX_DISPLAY_WISHLIST_PRODUCTS', '12', 'How many wish list items to show per page on the main wishlist.php file', 3, 22, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(223, 'Max Wish List Box', 'MAX_DISPLAY_WISHLIST_BOX', '4', 'How many wish list items to display in the infobox before it changes to a counter', 3, 23, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(224, 'Max Wish List Columns', 'MAX_DISPLAY_WISHLIST_COLS', '1', 'How many columns to display in the wish list', 3, 24, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(301, 'Enable Additional Images?', 'ULTIMATE_ADDITIONAL_IMAGES', 'enable', 'Display Additional Images below Product Description?', 4, 1, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''enable'', ''disable''),'),
(302, 'Calculate Image Size', 'CONFIG_CALCULATE_IMAGE_SIZE', 'true', 'Calculate the size of images?', 4, 2, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(303, 'Image Required', 'IMAGE_REQUIRED', 'false', 'Enable to display broken images. Good for development.', 4, 3, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(304, 'Heading Image Width', 'HEADING_IMAGE_WIDTH', '50', 'The pixel width of heading images', 4, 4, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(305, 'Heading Image Height', 'HEADING_IMAGE_HEIGHT', '', 'The pixel height of heading images', 4, 5, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(306, 'Subcategory Image Width', 'SUBCATEGORY_IMAGE_WIDTH', '200', 'The pixel width of subcategory images', 4, 6, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(307, 'Subcategory Image Height', 'SUBCATEGORY_IMAGE_HEIGHT', '200', 'The pixel height of subcategory images', 4, 7, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(308, 'Small Image Width (used in product list)', 'SMALL_IMAGE_WIDTH', '200', 'The pixel width of small images', 4, 10, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(309, 'Small Image Height (used in product list)', 'SMALL_IMAGE_HEIGHT', '150', 'The pixel height of small images', 4, 11, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(310, 'Additional Thumb Width', 'ULT_THUMB_IMAGE_WIDTH', '85', 'The pixel width of additional thumb images', 4, 8, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(311, 'Additional Thumb Height', 'ULT_THUMB_IMAGE_HEIGHT', '', 'The pixel height of additional thumb images', 4, 9, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(312, 'Medium Image Width (used for product info)', 'MEDIUM_IMAGE_WIDTH', '200', 'The pixel width of medium images', 4, 12, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(313, 'Medium Image Height (used for product info)', 'MEDIUM_IMAGE_HEIGHT', '150', 'The pixel height of medium images', 4, 13, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(314, 'Large Image Width (Pop-up)', 'LARGE_IMAGE_WIDTH', '0', 'The pixel width of large images (Pop-up)<br>(Use 0 for non-specific size)', 4, 14, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(315, 'Large Image Height (Pop-up)', 'LARGE_IMAGE_HEIGHT', '0', 'The pixel height of large images (Pop-up)<br>(Use 0 for non-specific size)', 4, 15, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(401, 'Gender', 'ACCOUNT_GENDER', 'false', 'Display gender in the customers account', 5, 1, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(402, 'Date of Birth', 'ACCOUNT_DOB', 'false', 'Display date of birth in the customers account', 5, 2, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(403, 'Company', 'ACCOUNT_COMPANY', 'true', 'Display company in the customers account', 5, 3, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(404, 'Suburb', 'ACCOUNT_SUBURB', 'true', 'Display suburb in the customers account', 5, 4, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(405, 'State', 'ACCOUNT_STATE', 'true', 'Display state in the customers account', 5, 5, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(406, 'Require E-mail Confirmation', 'ACCOUNT_EMAIL_CONFIRMATION', 'false', 'Require E-mail confirmation on account creation.', 5, 6, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(501, 'Default Currency', 'DEFAULT_CURRENCY', 'USD', 'Default Currency', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(502, 'Default Language', 'DEFAULT_LANGUAGE', 'en', 'Default Language', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(503, 'Default theme', 'DEFAULT_TEMPLATE', 'sevenofsix', 'Default responsive theme, set in Design Controls', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_pull_down_template_list('),
(504, 'Default Order Status For New Orders', 'DEFAULT_ORDERS_STATUS_ID', '1', 'When a new order is created, this order status will be assigned to it.', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(505, 'Last Database Restore', 'DB_LAST_RESTORE', '', 'Last database restore file', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(506, 'Shop By Price Ranges', 'MODULE_SHOPBYPRICE_RANGES', '0', 'How many ranges does the Shop by Price module support?', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(507, 'Shop By Price Over Range', 'MODULE_SHOPBYPRICE_OVER', 'True', 'Add a range to cover everything over the last specified range?', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''True'', ''False''),'),
(508, 'Shop By Price Range', 'MODULE_SHOPBYPRICE_RANGE', '', 'An array of the shop by price ranges.', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(510, 'Installed Modules', 'MODULE_PAYMENT_INSTALLED', 'moneyorder.php', 'List of payment module filenames separated by a semi-colon. This is automatically updated. No need to edit. (Example: cc.php;cod.php;paypal.php)', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(511, 'Installed Modules', 'MODULE_ORDER_TOTAL_INSTALLED', 'ot_shipping.php;ot_subtotal.php;ot_tax.php;ot_total.php', 'List of order_total module filenames separated by a semi-colon. This is automatically updated. No need to edit. (Example: ot_subtotal.php;ot_tax.php;ot_shipping.php;ot_total.php)', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(512, 'Installed Modules', 'MODULE_SHIPPING_INSTALLED', '', 'List of shipping module filenames separated by a semi-colon. This is automatically updated. No need to edit. (Example: ups.php;flat.php;item.php)', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(513, 'Installed Modules', 'MODULE_CHECKOUT_SUCCESS_INSTALLED', '', 'This is automatically updated. No need to edit.', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(514, 'Installed Modules', 'MODULE_ADDONS_INSTALLED', '', 'This is automatically updated. No need to edit.', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(520, 'Display Shipping', 'MODULE_ORDER_TOTAL_SHIPPING_STATUS', 'true', 'Do you want to display the order shipping cost?', 6, 1, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(521, 'Sort Order', 'MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER', '500', 'Sort order of display.', 6, 2, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(522, 'Allow Free Shipping', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING', 'false', 'Do you want to allow free shipping?', 6, 3, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''), '),
(523, 'Free Shipping For Orders Over', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER', '50', 'Provide free shipping for orders over the set amount.', 6, 4, '0000-00-00 00:00:00', '[[regtime]]', 'currencies->format', ''),
(524, 'Provide Free Shipping For Orders Made', 'MODULE_ORDER_TOTAL_SHIPPING_DESTINATION', 'national', 'Provide free shipping for orders sent to the set destination.', 6, 5, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''national'', ''international'', ''both''), '),
(530, 'Display Sub-Total', 'MODULE_ORDER_TOTAL_SUBTOTAL_STATUS', 'true', 'Do you want to display the order sub-total cost?', 6, 6, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(531, 'Sort Order', 'MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER', '700', 'Sort order of display.', 6, 7, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(540, 'Display Tax', 'MODULE_ORDER_TOTAL_TAX_STATUS', 'true', 'Do you want to display the order tax value?', 6, 8, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(541, 'Sort Order', 'MODULE_ORDER_TOTAL_TAX_SORT_ORDER', '800', 'Sort order of display.', 6, 9, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(550, 'Display Total', 'MODULE_ORDER_TOTAL_TOTAL_STATUS', 'true', 'Do you want to display the total order value?', 6, 10, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(551, 'Sort Order', 'MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER', '900', 'Sort order of display.', 6, 11, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(552, 'PayPal Service', 'MODULE_PAYMENT_PAYPAL_SERVICE', 'Express Checkout', 'Choose which PayPal Service to use.', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Website Payments Pro'', ''Express Checkout'', ''Website Payments Standard''), '),
(553, '<hr>WEBSITE PAYMENTS PRO<hr>CRE Secure Account ID', 'MODULE_PAYMENT_PAYPAL_CRESECURE_LOGIN', '', 'The Account ID used for the CRE Secure payment service', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(554, 'CRE Secure API Token', 'MODULE_PAYMENT_PAYPAL_CRESECURE_PASS', '', 'The API Token used for the CRE Secure payment service', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(555, 'Accepted Credit Cards', 'MODULE_PAYMENT_CRESECURE_ACCEPTED_CC', 'American Express, MasterCard, Visa', 'The credit cards you currently accept', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', '_selectCREOptions(array(''American Express'', ''Discover'', ''MasterCard'', ''Visa''), '),
(556, 'Set Completed Order Status', 'MODULE_PAYMENT_CRESECURE_ORDER_STATUS_COMPLETE_ID', '0', 'For Completed orders, set the status of orders made with this payment module to this value', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', 'tep_get_order_status_name', 'tep_cfg_pull_down_order_statuses('),
(557, 'Enable Sandbox Mode', 'MODULE_PAYMENT_CRESECURE_TEST_MODE', 'False', 'Set to ''True'' for sandbox test environment or set to ''False'' for production environment.', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''True'', ''False''), '),
(558, '<hr>EXPRESS CHECKOUT<hr>API Username', 'MODULE_PAYMENT_PAYPAL_XC_API_USERNAME', '', 'Your PayPal EC API Username', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(559, 'API Password', 'MODULE_PAYMENT_PAYPAL_XC_API_PASSWORD', '', 'Your PayPal EC API Password', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(560, 'API Signature', 'MODULE_PAYMENT_PAYPAL_XC_API_SIGNATURE', '', 'Your PayPal EC API Signature', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(561, 'Transaction Type', 'MODULE_PAYMENT_PAYPAL_XC_TRXTYPE', 'Sale', 'Should customers be charged immediately, or should we perform an authorization? If we perform authorizations, capture must be handled manually by the store owner.)', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Sale'', ''Authorization''), '),
(562, 'Merchant Country', 'MODULE_PAYMENT_PAYPAL_XC_MERCHANT_COUNTRY', 'US', 'The country of merchant', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''US'', ''UK''), '),
(563, 'Payment Zone', 'MODULE_PAYMENT_PAYPAL_XC_ZONE', '0', 'If a zone is selected, enable this payment method for that zone only.', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes('),
(564, 'Set Order Status', 'MODULE_PAYMENT_PAYPAL_XC_ORDER_STATUS_ID', '0', 'Set the status of orders made with this payment module to this value', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', 'tep_get_order_status_name', 'tep_cfg_pull_down_order_statuses('),
(565, 'Set Refund Order Status', 'MODULE_PAYMENT_PAYPAL_XC_REFUND_ORDER_STATUS_ID', '0', 'Set the status of refund orders made with this payment module to this value', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', 'tep_get_order_status_name', 'tep_cfg_pull_down_order_statuses('),
(566, 'Live or Sandbox API', 'MODULE_PAYMENT_PAYPAL_XC_SERVER', 'sandbox', 'Live: Live transactions<br>Sandbox: For developers and testing', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''live'', ''sandbox''), '),
(570, 'Enable PayPal Module', 'MODULE_PAYMENT_PAYPAL_STATUS', 'True', 'Do you want to accept PayPal payments?&nbsp;<a style="color: #0033cc;" href="paypal.php?action=help" target="paypalHelp">[Help]</a>', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''True'', ''False''), '),
(571, '<hr>WEBSITE PAYMENTS STANDARD<hr>E-Mail Address', 'MODULE_PAYMENT_PAYPAL_ID', '[[admin_email]]', 'The e-mail address to use for the PayPal service', 6, 1, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(572, 'Business ID', 'MODULE_PAYMENT_PAYPAL_BUSINESS_ID', '[[admin_email]]', 'Email address or account ID of the payment recipient', 6, 2, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(573, 'Default Currency', 'MODULE_PAYMENT_PAYPAL_DEFAULT_CURRENCY', 'USD', 'The <b>default</b> currency to use for when the customer chooses to checkout via the store using a currency not supported by PayPal.<br>(This currency must exist in your store)', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''USD'',''CAD'',''EUR'',''GBP'',''JPY'',''AUD''), '),
(574, 'Transaction Currency', 'MODULE_PAYMENT_PAYPAL_CURRENCY', 'Selected Currency', 'The currency to use for credit card transactions', 6, 3, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Selected Currency'',''Only USD'',''Only CAD'',''Only EUR'',''Only GBP'',''Only JPY''), '),
(575, 'Payment Zone', 'MODULE_PAYMENT_PAYPAL_ZONE', '0', 'If a zone is selected, enable this payment method for that zone only.', 6, 4, '0000-00-00 00:00:00', '[[regtime]]', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes('),
(576, 'Set Pending Notification Status', 'MODULE_PAYMENT_PAYPAL_PROCESSING_STATUS_ID', '1', 'Set the Pending Notification status of orders made with this payment module to this value (''Pending'' recommended)', 6, 5, '0000-00-00 00:00:00', '[[regtime]]', 'tep_get_order_status_name', 'tep_cfg_pull_down_order_statuses('),
(577, 'Set Order Status', 'MODULE_PAYMENT_PAYPAL_ORDER_STATUS_ID', '2', 'Set the status of orders made with this payment module to this value<br>(''Processing'' recommended)', 6, 6, '0000-00-00 00:00:00', '[[regtime]]', 'tep_get_order_status_name', 'tep_cfg_pull_down_order_statuses('),
(578, 'Set On Hold Order Status', 'MODULE_PAYMENT_PAYPAL_ORDER_ONHOLD_STATUS_ID', '5', 'Set the status of <b>On Hold</b> orders made with this payment module to this value', 6, 7, '0000-00-00 00:00:00', '[[regtime]]', 'tep_get_order_status_name', 'tep_cfg_pull_down_order_statuses('),
(579, 'Set Canceled Order Status', 'MODULE_PAYMENT_PAYPAL_ORDER_CANCELED_STATUS_ID', '6', 'Set the status of <b>Canceled</b> orders made with this payment module to this value', 6, 8, '0000-00-00 00:00:00', '[[regtime]]', 'tep_get_order_status_name', 'tep_cfg_pull_down_order_statuses('),
(580, 'Synchronize Invoice', 'MODULE_PAYMENT_PAYPAL_INVOICE_REQUIRED', 'False', 'Do you want to specify the order number as the PayPal invoice number?', 6, 9, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''True'', ''False''), '),
(581, 'Sort order of display.', 'MODULE_PAYMENT_PAYPAL_SORT_ORDER', '100', 'Sort order of display. Lowest is displayed first.', 6, 10, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(582, 'Set Refunded Order Status', 'MODULE_PAYMENT_PAYPAL_ORDER_REFUNDED_STATUS_ID', '1', 'Set the status of <b>Refunded</b> orders made with this payment module to this value', 6, 0, '0000-00-00 00:00:00', '[[regtime]]', 'tep_get_order_status_name', 'tep_cfg_pull_down_order_statuses('),
(583, 'Background Color', 'MODULE_PAYMENT_PAYPAL_CS', 'White', 'Select the background color of PayPal''s payment pages.', 6, 11, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''White'',''Black''), '),
(584, 'Processing logo', 'MODULE_PAYMENT_PAYPAL_PROCESSING_LOGO', 'loaded_header_logo.gif', 'The image file name to display the store''s checkout process', 6, 12, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(585, 'Store logo', 'MODULE_PAYMENT_PAYPAL_STORE_LOGO', '', 'The image file name for PayPal to display (leave empty if your store does not have SSL)', 6, 13, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(586, 'PayPal Page Style Name', 'MODULE_PAYMENT_PAYPAL_PAGE_STYLE', 'default', 'The name of the page style you have configured in your PayPal Account', 6, 14, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(587, 'Include a note with payment', 'MODULE_PAYMENT_PAYPAL_NO_NOTE', 'No', 'Choose whether your customer should be prompted to include a note or not?', 6, 15, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Yes'',''No''), '),
(588, 'Shopping Cart Method', 'MODULE_PAYMENT_PAYPAL_METHOD', 'Aggregate', 'What type of shopping cart do you want to use?', 6, 16, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Aggregate'',''Itemized''), '),
(589, 'Enable PayPal Shipping Address', 'MODULE_PAYMENT_PAYPAL_SHIPPING_ALLOWED', 'No', 'Allow the customer to choose their own PayPal shipping address?', 6, 17, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Yes'',''No''), '),
(590, 'Debug Email Notifications', 'MODULE_PAYMENT_PAYPAL_IPN_DEBUG', 'Yes', 'Enable debug email notifications', 6, 18, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Yes'',''No''), '),
(591, 'Digest Key', 'MODULE_PAYMENT_PAYPAL_IPN_DIGEST_KEY', 'PayPal_Shopping_Cart_IPN', 'Key to use for the digest functionality', 6, 19, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(592, 'Test Mode', 'MODULE_PAYMENT_PAYPAL_IPN_TEST_MODE', 'Off', 'Set test mode <a style="color: #0033cc;" href="paypal.php?action=itp" target="ipn">[IPN Test Panel]</a>', 6, 20, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Off'',''On''), '),
(593, 'Cart Test', 'MODULE_PAYMENT_PAYPAL_IPN_CART_TEST', 'Off', 'Set cart test mode to verify the transaction amounts', 6, 21, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Off'',''On''), '),
(594, 'Debug Email Notification Address', 'MODULE_PAYMENT_PAYPAL_IPN_DEBUG_EMAIL', '', 'The e-mail address to send <b>debug</b> notifications to', 6, 22, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(595, 'PayPal Domain', 'MODULE_PAYMENT_PAYPAL_DOMAIN', 'www.paypal.com', 'Select which PayPal domain to use<br>(for live production select www.paypal.com)', 6, 23, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''www.paypal.com'',''www.sandbox.paypal.com''), '),
(596, 'Return URL behavior', 'MODULE_PAYMENT_PAYPAL_RM', '2', 'How should the customer be sent back from PayPal to the specified URL?<br>0=No IPN, 1=GET, 2=POST', 6, 24, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''0'',''1'',''2''), '),
(601, 'Country of Origin', 'SHIPPING_ORIGIN_COUNTRY', '223', 'Select the country of origin to be used in shipping quotes.', 7, 1, '0000-00-00 00:00:00', '[[regtime]]', 'tep_get_country_name', 'tep_cfg_pull_down_country_list('),
(602, 'Postal Code', 'SHIPPING_ORIGIN_ZIP', '94558', 'Enter the Postal Code (ZIP) of the Store to be used in shipping quotes.', 7, 2, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(603, 'Maximum Package Weight', 'SHIPPING_MAX_WEIGHT', '50', 'Carriers have a max weight limit for a single package. This is a common one for all.', 7, 3, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(604, 'Package Tare Weight', 'SHIPPING_BOX_WEIGHT', '0', 'What is the weight of typical packaging for small to medium packages?', 7, 4, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(605, 'Percentage Increase for Larger Packages', 'SHIPPING_BOX_PADDING', '0', 'For 10% enter 10', 7, 5, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(606, 'Shipping Estimator', 'SHOW_SHIPPING_ESTIMATOR', 'true', 'Show Shipping Estimator on Shopping Cart <br>true= always <br>false= button popup only', 7, 6, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(607, 'Skip Shipping Page', 'SHIPPING_SKIP', 'No', '<ul><li><b>No</b> - do not skip shipping page.<br /><a href="javascript:free_shipping_module_page();"><u>FREE SHIPPING Module</u></a></li><li><b>Always</b> - skip shipping page entirely.</li><li><b>If Weight = 0 </b>- skip shipping page if weight is zero.', 7, 7, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''No'', ''Always'', ''If Weight = 0''),'),
(701, 'Display Product Image', 'PRODUCT_LIST_IMAGE', '1', 'Do you want to display the Product Image?', 8, 1, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(702, 'Display Product Manufacturer Name', 'PRODUCT_LIST_MANUFACTURER', '0', 'Do you want to display the Product Manufacturer Name?', 8, 2, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(703, 'Display Product Model', 'PRODUCT_LIST_MODEL', '0', 'Do you want to display the Product Model?', 8, 3, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(704, 'Display Product Name', 'PRODUCT_LIST_NAME', '2', 'Do you want to display the Product Name?', 8, 4, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(705, 'Display Product Price', 'PRODUCT_LIST_PRICE', '3', 'Do you want to display the Product Price?', 8, 5, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(706, 'Display Product Quantity', 'PRODUCT_LIST_QUANTITY', '0', 'Do you want to display the Product Quantity?', 8, 6, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(707, 'Display Product Weight', 'PRODUCT_LIST_WEIGHT', '0', 'Do you want to display the Product Weight?', 8, 7, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(708, 'Display Buy Now Column', 'PRODUCT_LIST_BUY_NOW', '4', 'Do you want to display the Buy Now column?', 8, 8, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(709, 'Display Category/Manufacturer Filter (0=disable; 1=enable)', 'PRODUCT_LIST_FILTER', '1', 'Do you want to display the Category/Manufacturer Filter?', 8, 9, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(710, 'Product Listing Format', 'PRODUCT_LIST_CONTENT_LISTING', 'column', 'Product list should be in Columns (with one product per row)  or Rows (Multiple products per row)', 8, 10, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''column'', ''row''),'),
(711, 'Location of Prev/Next Navigation Bar (1-top, 2-bottom, 3-both)', 'PREV_NEXT_BAR_LOCATION', '3', 'Sets the location of the Prev/Next Navigation Bar (1-top, 2-bottom, 3-both)', 8, 11, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(712, 'Product Listing Display Order', 'PRODUCTS_SORT_ORDER', 'Name', 'Categories and Products displayed on listing pages are ordered by:', 8, 12, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Name'', ''Model'', ''Price'', ''Manufacturer'', ''Quantity'', ''Weight'', ''Last Added''),'),
(713, 'Product Listing Columns', 'COLUMN_COUNT', '4', 'If Product Listing is Columns, How many Columns to show. (# of products in a row)', 8, 13, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(801, 'Check stock level', 'STOCK_CHECK', 'true', 'Check to see if sufficient stock is available', 9, 1, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(802, 'Subtract stock', 'STOCK_LIMITED', 'true', 'Subtract product in stock by product orders', 9, 2, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(803, 'Allow Checkout', 'STOCK_ALLOW_CHECKOUT', 'true', 'Allow customer to checkout even if there is insufficient stock', 9, 3, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(804, 'Mark product out of stock', 'STOCK_MARK_PRODUCT_OUT_OF_STOCK', '***', 'Display something on screen so customer can see which product has insufficient stock', 9, 4, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(805, 'Stock Re-order level', 'STOCK_REORDER_LEVEL', '5', 'Define when stock needs to be re-ordered', 9, 5, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(901, 'Store Page Parse Time', 'STORE_PAGE_PARSE_TIME', 'false', 'Store the time it takes to parse a page', 10, 1, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(902, 'Log Destination', 'STORE_PAGE_PARSE_TIME_LOG', '[[softpath]]/tmp/page_parse_time.log', 'Catalog directory and filename of the page parse time log', 10, 2, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(903, 'Log Date Format', 'STORE_PARSE_DATE_TIME_FORMAT', '%d/%m/%Y %H:%M:%S', 'The date format', 10, 3, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(904, 'Display The Page Parse Time', 'DISPLAY_PAGE_PARSE_TIME', 'true', 'Display the page parse time (store page parse time must be enabled)', 10, 4, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(905, 'Store Database Queries', 'STORE_DB_TRANSACTIONS', 'false', 'Store the database queries in the page parse time log (PHP4 only)', 10, 5, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(906, 'MySQL Debug Email Notifications', 'DEBUG_EMAIL_MYSQL_ERRORS', 'false', 'Send the database errors in an Email to the store owner email address.', 10, 6, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1001, 'Use Cache', 'USE_CACHE', 'false', 'Use caching features', 11, 1, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1002, 'Cache Directory', 'DIR_FS_CACHE', 'cache/', 'The directory where the cached files are saved', 11, 2, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1101, 'E-Mail Transport Method', 'EMAIL_TRANSPORT', 'sendmail', 'Defines if this server uses a local connection to sendmail or uses an SMTP connection via TCP/IP. Servers running on Windows and MacOS should change this setting to SMTP.', 12, 1, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''sendmail'', ''smtp''),'),
(1102, 'E-Mail Linefeeds', 'EMAIL_LINEFEED', 'CRLF', 'Defines the character sequence used to separate mail headers.', 12, 2, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''LF'', ''CRLF''),'),
(1103, 'Use MIME HTML When Sending Emails', 'EMAIL_USE_HTML', 'false', 'Send e-mails in HTML format', 12, 3, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1104, 'Verify E-Mail Addresses Through DNS', 'ENTRY_EMAIL_ADDRESS_CHECK', 'false', 'Verify e-mail address through a DNS server', 12, 4, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1105, 'Send E-Mails', 'SEND_EMAILS', 'true', 'Send out e-mails', 12, 5, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1106, 'SMTP Server Host Address', 'EMAIL_SMTP_HOST_SERVER', '', 'The fully qualified host name of the SMTP server.', 12, 10, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1107, 'SMTP Server EHLO / HELO Name', 'EMAIL_SMTP_HELO_SERVER', '', 'A name to send as part of the SMTP EHLO / HELO commands. The name is typically the hostname of the machine this web site runs on.', 12, 11, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1108, 'SMTP Server Port Number', 'EMAIL_SMTP_PORT_SERVER', '25', 'The SMTP server port number. Port number 25 is typically used by default.', 12, 12, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1109, 'SMTP Authentication Required', 'EMAIL_SMTP_ACTIVE_PASSWORD', 'true', 'Set to true when the SMTP Server requires password authentication.', 12, 13, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''), '),
(1110, 'SMTP Authentication Username', 'EMAIL_SMTP_USERNAME', '', 'The e-mail username sent to the server when SMTP password authentication is required.', 12, 14, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1111, 'SMTP Authentication Password', 'EMAIL_SMTP_PASSWORD', '', 'The e-mail password sent to the server when SMTP password authentication is required.', 12, 15, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1201, 'Enable download', 'DOWNLOAD_ENABLED', 'true', 'Enable the products download functions.', 13, 1, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1202, 'Download by redirect', 'DOWNLOAD_BY_REDIRECT', 'true', 'Use browser redirection for download. Disable on non-Unix systems.', 13, 2, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1203, 'Expiry delay (days)', 'DOWNLOAD_MAX_DAYS', '7', 'Set number of days before the download link expires. 0 means no limit.', 13, 3, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1204, 'Maximum number of downloads', 'DOWNLOAD_MAX_COUNT', '5', 'Set the maximum number of downloads. 0 means no download authorized.', 13, 4, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1205, 'Downloads Controller Order Status Value', 'DOWNLOADS_CONTROLLER_ORDERS_STATUS', '2', 'Downloads Controller Order Status Value - Default=2', 13, 92, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1206, 'Downloads Controller Download on hold message', 'DOWNLOADS_CONTROLLER_ON_HOLD_MSG', '<BR><font color="FF0000">NOTE: Downloads are not available until payment has been confirmed</font>', 'Downloads Controller Download on hold message', 13, 91, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1207, 'Downloads Controller Update Status Value', 'DOWNLOADS_ORDERS_STATUS_UPDATED_VALUE', '4', 'What orders_status resets the Download days and Max Downloads - Default is 4', 13, 90, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1301, 'Enable GZip Compression in Store', 'GZIP_COMPRESSION', 'false', 'Enable HTTP GZip compression.', 14, 1, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1302, 'Compression Level', 'GZIP_LEVEL', '5', 'Use this compression level 0-9 (0 = minimum, 9 = maximum).', 14, 2, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1401, 'Session Directory', 'SESSION_WRITE_DIRECTORY', '[[softpath]]/tmp', 'If sessions are file based, store them in this directory.', 15, 1, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1402, 'Force Cookie Use', 'SESSION_FORCE_COOKIE_USE', 'False', 'Force the use cookies to handle sessions.', 15, 2, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''True'', ''False''),'),
(1403, 'Check SSL Session ID', 'SESSION_CHECK_SSL_SESSION_ID', 'False', 'Validate the SSL_SESSION_ID on every secure HTTPS page request.', 15, 3, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''True'', ''False''),'),
(1404, 'Check User Agent', 'SESSION_CHECK_USER_AGENT', 'False', 'Validate the client''s browser user agent on every page request.', 15, 4, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''True'', ''False''),'),
(1405, 'Check IP Address', 'SESSION_CHECK_IP_ADDRESS', 'False', 'Validate the client''s IP address on every page request.', 15, 5, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''True'', ''False''),'),
(1406, 'Prevent Spider Sessions', 'SESSION_BLOCK_SPIDERS', 'True', 'Prevent known spiders from starting a session.', 15, 6, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''True'', ''False''),'),
(1407, 'Recreate Session', 'SESSION_RECREATE', 'False', 'Recreate the session to generate a new session ID when the customer logs on or creates an account (PHP >=4.1 needed).', 15, 7, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''True'', ''False''),'),
(1408, 'Admin Session Lifetime', 'MYSESSION_LIFETIME', '3600', 'Length of time you can stay on one page in ADMIN, without a refresh, before you are required to log in. Measured in Seconds. (You may not set this to less than 60 seconds.)', 15, 8, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1501, '<B>Down for Maintenance: ON/OFF</B>', 'DOWN_FOR_MAINTENANCE', 'false', 'Down for Maintenance <br>(true=on false=off)', 16, 1, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1502, 'Down for Maintenance: filename', 'DOWN_FOR_MAINTENANCE_FILENAME', 'down_for_maintenance.php', 'Down for Maintenance filename Default=down_for_maintenance.php', 16, 2, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1503, 'Down for Maintenance: Hide Header', 'DOWN_FOR_MAINTENANCE_HEADER_OFF', 'false', 'Down for Maintenance: Hide Header <br>(true=hide false=show)', 16, 3, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1504, 'Down for Maintenance: Hide Column Left', 'DOWN_FOR_MAINTENANCE_COLUMN_LEFT_OFF', 'true', 'Down for Maintenance: Hide Column Left <br>(true=hide false=show)', 16, 4, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1505, 'Down for Maintenance: Hide Column Right', 'DOWN_FOR_MAINTENANCE_COLUMN_RIGHT_OFF', 'true', 'Down for Maintenance: Hide Column Right <br>(true=hide false=show)r', 16, 5, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1506, 'Down for Maintenance: Hide Footer', 'DOWN_FOR_MAINTENANCE_FOOTER_OFF', 'false', 'Down for Maintenance: Hide Footer <br>(true=hide false=show)', 16, 6, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1507, 'Down for Maintenance: Hide Prices', 'DOWN_FOR_MAINTENANCE_PRICES_OFF', 'false', 'Down for Maintenance: Hide Prices <br>(true=hide false=show)', 16, 7, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1508, 'Down For Maintenance (exclude this IP-Address)', 'EXCLUDE_ADMIN_IP_FOR_MAINTENANCE', 'your IP (ADMIN)', 'This IP Address is able to access the web site while it is Down For Maintenance (like webmaster)', 16, 8, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1509, 'NOTIFY PUBLIC Before going Down for Maintenance: ON/OFF', 'WARN_BEFORE_DOWN_FOR_MAINTENANCE', 'false', 'Give a WARNING some time before you put your web site Down for Maintenance<br>(true=on false=off)<br>If you set the ''Down For Maintenance: ON/OFF'' to true this will automaticly be updated to false', 16, 9, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1510, 'Date and hours for notice before maintenance', 'PERIOD_BEFORE_DOWN_FOR_MAINTENANCE', '19/05/2003  between the hours of 11:00-11:30 PM', 'Date and hours for notice before maintenance web site, enter date and hours for maintenance web site', 16, 10, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1511, 'Display when webmaster has enabled maintenance', 'DISPLAY_MAINTENANCE_TIME', 'true', 'Display when Webmaster has enabled maintenance <br>(true=on false=off)<br>', 16, 11, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1512, 'Display web site maintenance period', 'DISPLAY_MAINTENANCE_PERIOD', 'false', 'Display Website maintenance period <br>(true=on false=off)<br>', 16, 12, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1513, 'Website maintenance period', 'TEXT_MAINTENANCE_PERIOD_TIME', '0h30', 'Enter Website Maintenance period (hh:mm)', 16, 13, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1601, 'Purchase Without Account', 'PWA_ON', 'true', 'Allow customers to purchase without an account.', 20, 1, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1602, 'Continue Button Action', 'RETURN_CART', 'P', 'After checkout, click the Continue button to return to P=Product page, C=Category page, or L=Last page viewed.', 20, 2, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''P'', ''C'', ''L''),'),
(1603, 'Display Cart After Adding Product', 'DISPLAY_CART', 'true', 'Display the shopping cart after adding a product (or return back to their origin)', 20, 3, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1604, 'Require Accepted Conditions of Use', 'ACCOUNT_CONDITIONS_REQUIRED', 'false', 'Select true to require confirmation of acceptance of the terms and conditions at checkout time.', 20, 4, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),');
INSERT INTO `configuration` VALUES
(1701, 'cURL Proxy Host Name', 'CURL_PROXY_HOST', '', 'If you are required to use a cURL proxy, then enter the host name here.', 21, 1, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1702, 'cURL Proxy User Password', 'CURL_PROXY_PASSWORD', '', 'Some cURL proxy require a user name and password. If you have a user password, enter it here.', 21, 3, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1703, 'cURL Proxy Port', 'CURL_PROXY_PORT', '', 'If you are required to use a cURL proxy, then enter the port numberhere.', 21, 4, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1704, 'cURL Proxy User Name', 'CURL_PROXY_USER', '', 'Some cURL proxy require a user name and password. If you have a user name, enter it here.', 21, 2, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(1901, 'Store Info', 'ADMIN_BLOCKS_STORE_INFO_STATUS', 'true', 'Display Store Info Block?', 23, 1, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1902, 'Products', 'ADMIN_BLOCKS_PRODUCTS_STATUS', 'true', 'Display Products Block?', 23, 2, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1903, 'Customers', 'ADMIN_BLOCKS_CUSTOMERS_STATUS', 'true', 'Display Customers Block?', 23, 3, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1904, 'Reports', 'ADMIN_BLOCKS_REPORTS_STATUS', 'true', 'Display Reports Block?', 23, 4, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1905, 'Reviews', 'ADMIN_BLOCKS_REVIEWS_STATUS', 'true', 'Display Reviews Block?', 23, 5, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1906, 'Tax Rates', 'ADMIN_BLOCKS_TAX_RATES_STATUS', 'true', 'Display Tax Rates Block?', 23, 6, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1907, 'Links', 'ADMIN_BLOCKS_LINKS_STATUS_STATUS', 'true', 'Display Links Block?', 23, 7, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1908, 'Order Totals', 'ADMIN_BLOCKS_OT_STATUS', 'true', 'Display Order Totals Block?', 23, 8, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1910, 'Approved Order Statuses for OT Block', 'ADMIN_BLOCKS_OT_APPROVED_ORDER_STATUS_MAP', '3,4', 'Select the <b>Approved</b> Order Statuses to be used in the calculation of totals displayed in parenthesis in the Order Totals Block.', 23, 10, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_get_orders_status_selection('),
(1911, 'Show Last Month Total in OT Block ', 'ADMIN_BLOCKS_OT_SHOW_LAST_MONTH', 'false', 'Display last month''s total in the Order Totals block?', 23, 11, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1912, 'Show Year to Date Total in OT Block ', 'ADMIN_BLOCKS_OT_SHOW_YTD', 'false', 'Display year-to-date total in the Order Totals block?', 23, 12, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1913, 'Whats New', 'ADMIN_BLOCKS_WHATS_NEW', 'true', 'Whats New Block', 23, 13, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(1914, 'Easy Path to PCI', 'ADMIN_BLOCKS_EASY_PATH', 'false', 'Easy Path', 23, 14, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(2001, 'HTML Editor interface Enable/Disable', 'HTML_EDITOR_ENABLE', 'Enable', 'Globally Enable / Disable HTML Editor', 112, 1, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Enable'', ''Disable''),'),
(2002, 'CUSTOMER EMAILS use WYSIWYG Editor?', 'HTML_WYSIWYG_DISABLE_EMAIL', 'Enable', 'Use HTML Editor in Email Customers', 112, 2, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Enable'', ''Disable''),'),
(2003, 'NEWSLETTER EMAILS use WYSIWYG Editor?', 'HTML_WYSIWYG_DISABLE_NEWSLETTER', 'Enable', 'Use Use HTML Editor in Email Newsletter', 112, 3, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Enable'', ''Disable''),'),
(2004, 'Enable tinyMCE Module', 'HTML_EDITOR_TINYMCE_STATUS', 'Enable', 'Select True to Enable tinyMCE.', 112, 4, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Enable'', ''Disable''), '),
(2005, 'tinyMCE Editor Height', 'HTML_EDITOR_TINYMCE_HEIGHT', '400', 'This option gives you the ability to specify the height of the editor in pixels or percent.', 112, 5, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2006, 'tinyMCE Editor Width', 'HTML_EDITOR_TINYMCE_WIDTH', '100%', 'This option gives you the ability to specify the width of the editor in pixels or percent.', 112, 6, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2007, 'tinyMCE Source Editor Height', 'HTML_EDITOR_TINYMCE_SOURCE_HEIGHT', '400', 'This option is used to define the height of the source editor dialog.', 112, 7, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2008, 'tinyMCE Source Editor Width', 'HTML_EDITOR_TINYMCE_SOURCE_WIDTH', '600', 'This option is used to define the width of the source editor dialog.', 112, 8, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2009, 'Template Stylesheet', 'HTML_EDITOR_TINYMCE_STYLESHEET', 'Enable', 'Enable Using Template Stylesheet?<br /><font color="red">Note: Set this option to Disable if your store uses dark background template.</font>', 112, 9, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Enable'', ''Disable''), '),
(2010, 'Toolbar Position', 'HTML_EDITOR_TINYMCE_TOOLBAR_POSITON', 'Top', 'Set Toolbar Position.<br /><em>Default setting is Top.</em>', 112, 10, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Top'', ''Bottom''), '),
(2011, 'Toolbar Alignment', 'HTML_EDITOR_TINYMCE_TOOLBAR_ALIGNMENT', 'Left', 'Set Toolbar Alignment.<br /><em>Default setting is Left.</em>', 112, 11, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Left'', ''Right''), '),
(2012, 'Directionality', 'HTML_EDITOR_TINYMCE_DIRECTIONALITY', 'Left', 'This option specifies the default writing direction, some languages (Like Hebrew, Arabic, Urdu...) write from right to left instead of left to right.<br />The default value of this option is Left but if you want to use from right to left mode specify Righ', 112, 12, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Left'', ''Right''), '),
(2013, 'Force p Newlines', 'HTML_EDITOR_TINYMCE_P_NEWLINES', 'True', 'This option enables you to disable/enable the creation of paragraphs on return/enter in Mozilla/Firefox. The default value of this option is true.', 112, 13, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''True'', ''Center'', ''False''), '),
(2014, 'HTML Source Cleanup', 'HTML_EDITOR_TINYMCE_CLEANUP', 'True', 'This option enables or disables the built-in clean up functionality. TinyMCE is equipped with powerful clean up functionality that enables you to specify what elements and attributes are allowed and how HTML contents should be generated. This option is se', 112, 14, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''True'', ''False''), '),
(2015, 'Preview Window Height', 'HTML_EDITOR_TINYMCE_PREVIEW_HEIGHT', '550', 'tinyMCE Preview Window Height.', 112, 15, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2016, 'Preview Window Width', 'HTML_EDITOR_TINYMCE_PREVIEW_WIDTH', '750', 'tinyMCE Preview Window Width', 112, 16, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2017, 'Gzip Compression', 'HTML_EDITOR_TINYMCE_USE_GZIP', 'Enable', 'Enable / Disable Gzip Compression for tinyMCE.<br /><font color="red">Note: Gzip compression improve loading time for tinyMCE.</font>', 112, 17, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Enable'', ''Disable''), '),
(2201, 'Wishlist button product info', 'DESIGN_BUTTON_WISHLIST', 'true', 'Do you want to display the wishlist button on the product info page', 300, 1, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(2301, 'Global Captcha', 'VVC_SITE_ON_OFF', 'On', 'Turn on/off Captcha for the entire catalog.  This overrides individual Captcha page settings.', 420, 1, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''On'', ''Off''),'),
(2312, 'Pasword Forgotten', 'VVC_PASSWORD_FORGOT_ON_OFF', 'On', 'Turn on/off Captcha for Password Forgotten page.', 420, 12, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''On'', ''Off''),'),
(2313, 'Create Account', 'VVC_CREATE_ACCOUNT_ON_OFF', 'On', 'Turn on/off Captcha for Create Account page.', 420, 13, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''On'', ''Off''),'),
(2314, 'Contact Us', 'VVC_CONTACT_US_ON_OFF', 'On', 'Turn on/off Captcha for Contact Us page.', 420, 14, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''On'', ''Off''),'),
(2315, 'Article Reviews', 'VVC_ARTICLE_REVIEWS_ON_OFF', 'On', 'Turn on/off Captcha for Article Reviews page.', 420, 15, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''On'', ''Off''),'),
(2316, 'Product Reviews', 'VVC_PRODUCT_REVIEWS_ON_OFF', 'On', 'Turn on/off Captcha for Product Reviews page.', 420, 16, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''On'', ''Off''),'),
(2317, 'Link Submit', 'VVC_LINK_SUBMITT_ON_OFF', 'On', 'Turn on/off Captcha for Link Submit page.', 420, 17, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''On'', ''Off''),'),
(2318, 'Tell a Friend Article', 'VVC_TELL_FRIEND_ARTICLE_ON_OFF', 'On', 'Turn on/off Captcha for Tell a Friend About an Article page.', 420, 18, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''On'', ''Off''),'),
(2319, 'Tell a Friend', 'VVC_TELL_FRIEND_ON_OFF', 'On', 'Turn on/off Captcha for Tell a Friend page.', 420, 19, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''On'', ''Off''),'),
(2401, 'Maximum Articles Per Page', 'MAX_ARTICLES_PER_PAGE', '10', 'The maximum number of Articles to display per page<br>(All Articles and Topic/Author pages)', 456, 5, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2402, 'Display All Articles Link', 'DISPLAY_ALL_ARTICLES', 'true', 'Display a link to All Articles in the Articles box?', 456, 4, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(2403, 'Maximum New Articles Per Page', 'MAX_NEW_ARTICLES_PER_PAGE', '10', 'The maximum number of New Articles to display per page<br>(New Articles page)', 456, 3, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2404, 'Number of Days Display New Articles', 'NEW_ARTICLES_DAYS_DISPLAY', '30', 'The number of days to display New Articles?', 456, 2, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2405, 'Display New Articles Link', 'DISPLAY_NEW_ARTICLES', 'true', 'Display a link to New Articles in the Articles box?', 456, 1, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(2406, 'Maximum Display Upcoming Articles', 'MAX_DISPLAY_UPCOMING_ARTICLES', '5', 'Maximum number of articles to display in the Upcoming Articles module', 456, 6, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2407, 'Enable Article Reviews', 'ENABLE_ARTICLE_REVIEWS', 'true', 'Enable registered users to review articles?', 456, 7, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(2408, 'Enable Tell a Friend About Article', 'ENABLE_TELL_A_FRIEND_ARTICLE', 'true', 'Enable Tell a Friend option in the Article Information page?', 456, 8, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(2409, 'Minimum Number Cross-Sell Products', 'MIN_DISPLAY_ARTICLES_XSELL', '1', 'Minimum number of products to display in the articles Cross-Sell listing.', 456, 9, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2410, 'Maximum Number Cross-Sell Products', 'MAX_DISPLAY_ARTICLES_XSELL', '6', 'Maximum number of products to display in the articles Cross-Sell listing.', 456, 10, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2411, 'Show Article Counts', 'SHOW_ARTICLE_COUNTS', 'true', 'Count recursively how many articles are in each topic', 456, 11, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(2412, 'Maximum Length of Author Name', 'MAX_DISPLAY_AUTHOR_NAME_LEN', '20', 'The maximum length of the author''s name for display in the Author box', 456, 12, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2413, 'Authors List Style', 'MAX_DISPLAY_AUTHORS_IN_A_LIST', '1', 'Used in Authors box. When the number of authors exceeds this number, a drop-down list will be displayed instead of the default list', 456, 13, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2414, 'Authors Select Box Size', 'MAX_AUTHORS_LIST', '1', 'Used in Authors box. When this value is 1 the classic drop-down list will be used for the authors box. Otherwise, a list-box with the specified number of rows will be displayed.', 456, 14, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2415, 'Display Author in Article Listing', 'DISPLAY_AUTHOR_ARTICLE_LISTING', 'true', 'Display the Author in the Article Listing?', 456, 15, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(2416, 'Display Topic in Article Listing', 'DISPLAY_TOPIC_ARTICLE_LISTING', 'true', 'Display the Topic in the Article Listing?', 456, 16, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(2417, 'Display Abstract in Article Listing', 'DISPLAY_ABSTRACT_ARTICLE_LISTING', 'true', 'Display the Abstract in the Article Listing?', 456, 17, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(2418, 'Display Date Added in Article Listing', 'DISPLAY_DATE_ADDED_ARTICLE_LISTING', 'true', 'Display the Date Added in the Article Listing?', 456, 18, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(2419, 'Maximum Article Abstract Length', 'MAX_ARTICLE_ABSTRACT_LENGTH', '300', 'Sets the maximum length of the Article Abstract to be displayed<br><br>(No. of characters)', 456, 19, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2420, 'Display Topic/Author Filter', 'ARTICLE_LIST_FILTER', 'true', 'Do you want to display the Topic/Author Filter?', 456, 20, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(2421, 'Location of Prev/Next Navigation Bar', 'ARTICLE_PREV_NEXT_BAR_LOCATION', 'both', 'Sets the location of the Previous/Next Navigation Bar<br><br>(top; bottom; both)', 456, 21, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''top'', ''bottom'', ''both''),'),
(2422, 'Use WYSIWYG HTMLAREA Editor?', 'ARTICLE_WYSIWYG_ENABLE', 'Enable', 'Use WYSIWYG Editor in Articles and Topic/Author Descriptions?', 456, 22, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Enable'', ''Disable''),'),
(2423, 'WYSIWYG Editor Basic/Advanced Version?', 'ARTICLE_MANAGER_WYSIWYG_BASIC', 'Basic', 'Basic Features FASTER<br>Advanced Features SLOWER', 456, 23, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Basic'', ''Advanced''),'),
(2424, 'WYSIWYG Editor Layout Width', 'ARTICLE_MANAGER_WYSIWYG_WIDTH', '605', 'How WIDE should the HTMLAREA be in pixels (default: 605)', 456, 24, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2425, 'WYSIWYG Editor Layout Height', 'ARTICLE_MANAGER_WYSIWYG_HEIGHT', '300', 'How HIGH should the HTMLAREA be in pixels (default: 300)', 456, 25, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2426, 'WYSIWYG Editor Font Type', 'ARTICLE_MANAGER_WYSIWYG_FONT_TYPE', 'Times New Roman', 'User Interface Font Type<br>(not saved to content)', 456, 26, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Arial'', ''Courier New'', ''Georgia'', ''Impact'', ''Tahoma'', ''Times New Roman'', ''Verdana'', ''Wingdings''),'),
(2427, 'WYSIWYG Editor Font Size', 'ARTICLE_MANAGER_WYSIWYG_FONT_SIZE', '12', 'User Interface Font Size<br>(not saved to content)<p><b>10 Equals 10 pt', 456, 27, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(\\''8\\'', \\''10\\'', \\''12\\'', \\''14\\'', \\''18\\'', \\''24\\'', \\''36\\''),'),
(2428, 'WYSIWYG Editor Font Colour', 'ARTICLE_MANAGER_WYSIWYG_FONT_COLOUR', 'Black', 'White, Black, C0C0C0, Red, FFFFFF, Yellow, Pink, Blue, Gray, 000000, etc...<br>basically any colour or HTML colour code!<br>(not saved to content)', 456, 28, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2429, 'WYSIWYG Editor Background Colour', 'ARTICLE_MANAGER_WYSIWYG_BG_COLOUR', 'White', 'White, Black, C0C0C0, Red, FFFFFF, Yellow, Pink, Blue, Gray, 000000, etc...<br>basically any colour or html colour code!<br>(not saved to content)', 456, 29, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2430, 'WYSIWYG Editor Allow Debug Mode?', 'ARTICLE_MANAGER_WYSIWYG_DEBUG', '0', 'Moniter Live-html, It updates as you type in a 2nd field above it.<p>Disable Debug = 0<br>Enable Debug = 1<br>Default = 0 OFF', 456, 30, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''0'', ''1''),'),
(2431, 'Home Page Module: Show Number of New Articles', 'NEW_ARTICLES_HOMEPAGE_NUMBER_ITEMS', '3', 'Home Page Module show number of items (default is 3).', 456, 31, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2601, 'Click Count', 'ENABLE_LINKS_COUNT', 'True', 'Enable links click count.', 901, 1, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''True'', ''False''),'),
(2602, 'Spider Friendly Links', 'ENABLE_SPIDER_FRIENDLY_LINKS', 'False', 'Enable spider friendly links (NOT! Recommended leave set as false).', 901, 2, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''True'', ''False''),'),
(2603, 'Link Image Width', 'LINKS_IMAGE_WIDTH', '120', 'Maximum width of the Link Image.', 901, 3, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2604, 'Link Image Height', 'LINKS_IMAGE_HEIGHT', '', 'Maximum height of the Link Image.', 901, 4, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2605, 'Display Link Image', 'LINK_LIST_IMAGE', '1', 'Do you want to display the Link Image?', 901, 5, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2606, 'Display Link URL', 'LINK_LIST_URL', '4', 'Do you want to display the Link URL?', 901, 6, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2607, 'Display Link Title', 'LINK_LIST_TITLE', '2', 'Do you want to display the Link Title?', 901, 7, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2608, 'Display Link Description', 'LINK_LIST_DESCRIPTION', '3', 'Do you want to display the Link Description?', 901, 8, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2609, 'Display Link Click Count', 'LINK_LIST_COUNT', '5', 'Do you want to display the Link Click Count?', 901, 9, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2610, 'Link Title Minimum Length', 'ENTRY_LINKS_TITLE_MIN_LENGTH', '2', 'Minimum length of Link Title.', 901, 10, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2611, 'Link URL Minimum Length', 'ENTRY_LINKS_URL_MIN_LENGTH', '10', 'Minimum length of Link URL.', 901, 11, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2612, 'Link Description Minimum Length', 'ENTRY_LINKS_DESCRIPTION_MIN_LENGTH', '10', 'Minimum length of link description.', 901, 12, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2613, 'Link Contact Name Minimum Length', 'ENTRY_LINKS_CONTACT_NAME_MIN_LENGTH', '2', 'Minimum length of link contact name.', 901, 13, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2614, 'Link Check Phrase', 'LINKS_CHECK_PHRASE', 'ChainReactionWeb', 'Phrase to look for when you perform a link check.', 901, 14, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2701, 'Enable Fraud Screener', 'FS_ENABLE', 'false', 'Enable AlgoZone Fraud Screen Tool', 500, 1, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(2702, 'License Key', 'FS_LICENSE', 'freetrialv1.0', 'AlgoZone Fraud Screen Tool License Key', 500, 2, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2703, 'Use Secure Connection', 'FS_SECURE', 'false', 'Use HTTPS to retrieve fraud reports from AlgoZone.<p> If true, must have curl installed.', 500, 3, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(2704, 'Requests Remaining', 'FS_REQREM', '0', 'Number of Fraud Screen requests remaining for your account<p>Note: Updating this value does not affect actual queries left', 500, 4, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(2705, 'Debug', 'FS_DEBUG', 'false', 'Enable AlgoZone Fraud Screen Tool', 500, 5, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(3201, 'Thumbnail Height', 'CDS_THUMBNAIL_HEIGHT', '', 'The pixel height of pages images', 480, 1, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3202, 'Thumbnail Width', 'CDS_THUMBNAIL_WIDTH', '', 'The pixel width of pages images', 480, 2, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3203, 'Default Page Status', 'CDS_DEFAULT_PAGE_STATUS', 'Active', 'Default status for new pages.', 480, 3, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Active'', ''Inactive''),'),
(3204, 'Default Category Status', 'CDS_DEFAULT_CATEGORY_STATUS', 'Active', 'Default status for new page categories.', 480, 4, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Active'', ''Inactive''),'),
(3205, 'Default Columns', 'CDS_DEFAULT_COLUMNS', '1', 'Default number of columns on pages.', 480, 5, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3206, 'Default Show Page Link in InfoBox Menu', 'CDS_DEFAULT_PAGE_IN_MENU', 'Off', 'InfoBox Menu link for Pages is checked by default.', 480, 6, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''On'', ''Off''),'),
(3207, 'Default Show Page Link in Listings', 'CDS_DEFAULT_PAGE_IN_LISTING', 'On', 'Link in Listings for Pages is checked by default.', 480, 7, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''On'', ''Off''),'),
(3208, 'Default Show Category Link In Menu', 'CDS_DEFAULT_CATEGORY_IN_MENU', 'On', 'InfoBox Menu link for Page Categories is checked by default..', 480, 8, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''On'', ''Off''),'),
(3209, 'Default Show Category Link Listing', 'CDS_DEFAULT_CATEGORY_IN_LISTING', 'On', 'Link in Listings for Page Categories is checked by default.', 480, 9, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''On'', ''Off''),'),
(3210, 'Flat View Page Indent Value', 'CDS_FLAT_VIEW_INDENT_VALUE', '10', 'When in Flat View, indent the page row to this value.', 480, 10, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3211, 'Default Top Level Mode', 'CDS_DEFAULT_TOP_LEVEL_MODE', 'Nested', 'Choose the default Top Level display mode.', 480, 11, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Nested'', ''Flat''),'),
(3212, 'Default Top Level Columns', 'CDS_DEFAULT_TOP_LEVEL_COLUMNS', '1 Normal', 'Number of columns to display in the Top Level.', 480, 12, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''1 with Description on Left'', ''1 Normal'', ''2'', ''3''),'),
(3213, 'Navigation Text for Related Pages', 'CDS_TEXT_PAGES', 'Related Pages', 'Enter the text used for Related Pages navigation.', 480, 13, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3214, 'Navigation Text for Back function', 'CDS_TEXT_BACK', '<<', 'Enter the text used for Back navigation.', 480, 14, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3215, 'Navigation Text for Next function', 'CDS_TEXT_NEXT', '>>', 'Enter the text used for Next navigation.', 480, 15, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3216, 'Navigation Text for Back to List function', 'CDS_TEXT_BACK_TO_LIST', '< Back to List >', 'Enter the text used for Back to List navigation.', 480, 16, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3217, 'Text for Sub Category Indicator in InfoBox Menu', 'CDS_TEXT_SUBS_INDICATOR', '->', 'Enter the text used in the Pages infoBox to indicate a Category having Sub Categories.', 480, 17, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3218, 'WYSIWYG Editor on Page Blurb', 'CDS_WYSIWYG_ON_PAGE_BLURB', 'Enabled', 'Enable the WYSIWYG editor for the Page Blurb.', 480, 18, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Enabled'', ''Disabled''),'),
(3219, 'WYSIWYG Editor on Page Body', 'CDS_WYSIWYG_ON_PAGE_BODY', 'Enabled', 'Enable the WYSIWYG editor for the Page Body.', 480, 19, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Enabled'', ''Disabled''),'),
(3220, 'WYSIWYG Editor on Page Category Blurb', 'CDS_WYSIWYG_ON_CATEGORY_BLURB', 'Enabled', 'Enable the WYSIWYG editor for the Page Category Blurb.', 480, 20, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Enabled'', ''Disabled''),'),
(3221, 'WYSIWYG Editor on Page Category Body', 'CDS_WYSIWYG_ON_CATEGORY_BODY', 'Enabled', 'Enable the WYSIWYG editor for the Page Category Body.', 480, 21, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''Enabled'', ''Disabled''),'),
(3222, 'Home Page Module: Show Number of Items', 'CDS_HOMEPAGE_NUMBER_ITEMS', '3', 'Home Page Module show number of items (default is 3).', 480, 22, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3223, 'Home Page Module: Rotate Items', 'CDS_HOMEPAGE_ROTATE', 'true', 'Home Page Module Rotate items on home page.', 480, 23, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(3224, 'Home Page Module: Show From This Category', 'CDS_HOMEPAGE_USE_CATEGORY', '0', 'Home Page Module show from this category.', 480, 24, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3225, 'Home Page Module: Show Title', 'CDS_HOMEPAGE_SHOW_TITLE', 'true', 'Home Page Module show item title.', 480, 25, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(3226, 'Home Page Module: Show Blurb', 'CDS_HOMEPAGE_SHOW_BLURB', 'false', 'Home Page Module show item blurb.', 480, 26, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(3227, 'Home Page Module: Show Body', 'CDS_HOMEPAGE_SHOW_BODY', 'true', 'Home Page Module show item body.', 480, 27, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(3228, 'Home Page Module: Show Thumb', 'CDS_HOMEPAGE_SHOW_THUMB', 'true', 'Home Page Module show item thumb.', 480, 28, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''true'', ''false''),'),
(3229, 'Home Page Module: Body Text Count', 'CDS_HOMEPAGE_BODY_COUNT', '200', 'Home Page Module set number of charecters displayed for item body text.', 480, 29, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3250, '', 'CONTENT_CDS', 'cds_index', '', 481, 1, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3251, '', 'CONTENT_CDS_LISTING_NESTED', 'cds_listing_nested', '', 481, 2, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3252, '', 'CONTENT_CDS_LISTING_LEFT', 'cds_listing_nested_left', '', 481, 3, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3253, '', 'CONTENT_CDS_LISTING_NESTED_TWO_COLUMNS', 'cds_listing_nested_two_columns', '', 481, 4, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3254, '', 'CONTENT_CDS_LISTING_NESTED_SUBCATEGORY_IMAGE', 'cds_listing_nested_subcategory_image', '', 481, 5, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3255, '', 'CONTENT_CDS_LISTING_FLAT_SUBCATEGORY_IMAGE', 'cds_listing_flat_subcategory_image', '', 481, 6, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3256, '', 'CONTENT_CDS_LISTING_FLAT', 'cds_listing_flat', '', 481, 7, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3257, '', 'CONTENT_CDS_LISTING_FLAT_IMAGE', 'cds_listing_flat_image', '', 481, 8, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3258, '', 'CONTENT_CDS_LISTING_DETAIL', 'cds_listing_detail', '', 481, 19, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3260, '', 'FILENAME_CDS_PAGE_MANAGER', 'pages.php', '', 481, 10, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3261, '', 'FILENAME_CDS_CONFIGURATION', 'cds_configuration.php', '', 481, 11, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3262, '', 'FILENAME_CDS_IMPORT_EXPORT', 'cds_import_export.php', '', 481, 13, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3263, '', 'FILENAME_CDS_POPUP', 'cds_popup.php', '', 481, 14, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3264, '', 'FILENAME_CDS_POPUP_PREVIEW', 'cds_popup_preview.php', '', 481, 15, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3265, '', 'FILENAME_CDS_FUNCTIONS', 'cds_functions.php', '', 481, 16, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3266, '', 'FILENAME_CDS_BACKUP_RESTORE', 'cds_backup_restore.php', '', 481, 17, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3267, '', 'FILENAME_CDS_INDEX', 'pages.php', '', 481, 18, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3268, '', 'FILENAME_CDS_ACF_PAGES', 'cds_acf_pages.php', '', 481, 20, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3270, '', 'TABLE_CDS_CATEGORIES', 'pages_categories', '', 481, 30, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3271, '', 'TABLE_CDS_CATEGORIES_DESCRIPTION', 'pages_categories_description', '', 481, 31, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3272, '', 'TABLE_CDS_PAGES', 'pages', '', 481, 32, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3273, '', 'TABLE_CDS_PAGES_DESCRIPTION', 'pages_description', '', 481, 33, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3274, '', 'TABLE_CDS_PAGES_TO_CATEGORIES', 'pages_to_categories', '', 481, 34, '0000-00-00 00:00:00', '[[regtime]]', '', ''),
(3275, 'Admin Theme Mode', 'ADMIN_THEME_MODE', 'light', 'Admin Theme Mode', 1, 5, '0000-00-00 00:00:00', '[[regtime]]', '', 'tep_cfg_select_option(array(''light'', ''dark''),'),
(3276, 'Products Listing View Image Width', 'PRODUCTS_LISTING_IMAGE_WIDTH', '', 'The pixel width of products listing images', 4, 16, '2019-12-26 02:00:19', '2019-12-20 04:41:12', '', ''),
(3277, 'Products Listing View Image Height', 'PRODUCTS_LISTING_IMAGE_HIEGHT', '120', 'The pixel height of products listing images', 4, 17, '2019-12-26 02:00:19', '2019-12-20 04:41:12', '', ''),
(3278, 'Homepage Modules Image Width (used in homepage modules)', 'HOMEPAGE_MODULES_IMAGE_WIDTH', '', 'The pixel width of Homepage Modules Image', 4, 11, '2019-12-26 02:00:19', '2019-12-26 02:00:19', '', ''),
(3279, 'Homepage Modules Image Height (used in homepage modules)', 'HOMEPAGE_MODULES_IMAGE_HEIGHT', '175', 'The pixel height of Homepage Modules Image', 4, 10, '2019-12-26 02:00:19', '2019-12-26 02:00:19', '', ''),
(3280, 'Installed Addons', 'ADDONS_INSTALLED', '', 'This is automatically updated. No need to edit.', 6, 0, '0000-00-00 00:00:00', '2020-09-10 17:46:41', '', ''),
(3281, 'Admin listing per page records', 'MAX_DISPLAY_ADMIN_RESULTS', '50', 'Number of records to list in admin listing pages', 3, 2, '0000-00-00 00:00:00', '[[regtime]]', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `configuration_group`
--

CREATE TABLE `configuration_group` (
  `configuration_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `configuration_group_title` varchar(255) NOT NULL DEFAULT '',
  `configuration_group_description` varchar(255) NOT NULL DEFAULT '',
  `sort_order` smallint(3) unsigned NOT NULL DEFAULT '9999',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`configuration_group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=5000 ;

--
-- Dumping data for table `configuration_group`
--

INSERT INTO `configuration_group` VALUES
(1, 'My Store', 'General information about my store', 1, 1),
(2, 'Minimum Values', 'The minimum values for functions / data', 2, 1),
(3, 'Maximum Values', 'The maximum values for functions / data', 3, 1),
(4, 'Images', 'Image parameters', 4, 1),
(5, 'Customer Details', 'Configuration details for customer account creation.', 5, 1),
(6, 'Module Options', 'Hidden from configuration', 6, 0),
(7, 'Shipping/Packaging', 'Shipping options available at my store', 7, 1),
(8, 'Product Listing', 'Configuration options for the product listing page.', 8, 1),
(9, 'Stock', 'Stock configuration options', 10, 1),
(10, 'Logging', 'Logging configuration options', 11, 1),
(11, 'Cache', 'Caching configuration options', 12, 1),
(12, 'E-Mail Options', 'General setting for E-Mail transport and HTML E-Mails', 13, 1),
(13, 'Download', 'Downloadable products options', 14, 1),
(14, 'GZip Compression', 'GZip compression options', 15, 1),
(15, 'Sessions', 'Session options', 16, 1),
(16, 'Site Maintenance', 'Site Maintenance Options', 16, 1),
(20, 'Checkout', 'Checkout configuration options.', 20, 1),
(21, 'cURL Proxy', 'Configuration of cURL to use proxy settings', 21, 1),
(23, 'Admin Blocks', 'Display configuration of the Admin home page information blocks.', 23, 1),
(112, 'Editor', 'WYSIWYG Editor Configuration', 112, 1),
(300, 'Design and layout', 'Design and layout congifuration', 300, 0),
(420, 'VVC Configuration', 'VVC Configuration ', 420, 1),
(456, 'Articles Management', 'Articles Management', 456, 1),
(480, 'CDS Configuration', 'Configuration Information for LC Content Director System (CDS)', 480, 1),
(481, 'CDS Hidden Configuration', 'CDS Configuration values needed by the system.', 481, 0),
(500, 'Fraud Screen Zone', 'AlgoZone Fraud Screen tool options', 500, 1),
(901, 'Links', 'Links Manager configuration options', 901, 1);

-- --------------------------------------------------------

--
-- Table structure for table `contact_us`
--

CREATE TABLE `contact_us` (
  `contact_id` int(40) NOT NULL AUTO_INCREMENT,
  `customer_name` varchar(50) DEFAULT NULL,
  `customer_email_address` varchar(50) DEFAULT NULL,
  `customer_topic` varchar(50) DEFAULT NULL,
  `customer_subject` varchar(50) DEFAULT NULL,
  `customer_enquiry` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`contact_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `counter`
--

CREATE TABLE `counter` (
  `startdate` char(8) DEFAULT NULL,
  `counter` int(12) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `counter_history`
--

CREATE TABLE `counter_history` (
  `month` char(8) DEFAULT NULL,
  `counter` int(12) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `countries`
--

CREATE TABLE `countries` (
  `countries_id` int(11) NOT NULL AUTO_INCREMENT,
  `countries_name` varchar(255) NOT NULL DEFAULT '',
  `countries_iso_code_2` char(2) NOT NULL DEFAULT '',
  `countries_iso_code_3` char(3) NOT NULL DEFAULT '',
  `address_format_id` int(11) NOT NULL DEFAULT '0',
  `country_status` int(11) NOT NULL DEFAULT '1',
  `country_allowed` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`countries_id`),
  KEY `IDX_COUNTRIES_NAME` (`countries_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=240 ;

--
-- Dumping data for table `countries`
--

INSERT INTO `countries` VALUES
(1, 'Afghanistan', 'AF', 'AFG', 1, 1, 1),
(2, 'Albania', 'AL', 'ALB', 1, 1, 1),
(3, 'Algeria', 'DZ', 'DZA', 1, 1, 1),
(4, 'American Samoa', 'AS', 'ASM', 1, 1, 1),
(5, 'Andorra', 'AD', 'AND', 1, 1, 1),
(6, 'Angola', 'AO', 'AGO', 1, 1, 1),
(7, 'Anguilla', 'AI', 'AIA', 1, 1, 1),
(8, 'Antarctica', 'AQ', 'ATA', 1, 1, 1),
(9, 'Antigua and Barbuda', 'AG', 'ATG', 1, 1, 1),
(10, 'Argentina', 'AR', 'ARG', 1, 1, 1),
(11, 'Armenia', 'AM', 'ARM', 1, 1, 1),
(12, 'Aruba', 'AW', 'ABW', 1, 1, 1),
(13, 'Australia', 'AU', 'AUS', 2, 1, 1),
(14, 'Austria', 'AT', 'AUT', 5, 1, 1),
(15, 'Azerbaijan', 'AZ', 'AZE', 1, 1, 1),
(16, 'Bahamas', 'BS', 'BHS', 1, 1, 1),
(17, 'Bahrain', 'BH', 'BHR', 1, 1, 1),
(18, 'Bangladesh', 'BD', 'BGD', 1, 1, 1),
(19, 'Barbados', 'BB', 'BRB', 1, 1, 1),
(20, 'Belarus', 'BY', 'BLR', 1, 1, 1),
(21, 'Belgium', 'BE', 'BEL', 5, 1, 1),
(22, 'Belize', 'BZ', 'BLZ', 1, 1, 1),
(23, 'Benin', 'BJ', 'BEN', 1, 1, 1),
(24, 'Bermuda', 'BM', 'BMU', 1, 1, 1),
(25, 'Bhutan', 'BT', 'BTN', 1, 1, 1),
(26, 'Bolivia', 'BO', 'BOL', 1, 1, 1),
(27, 'Bosnia and Herzegowina', 'BA', 'BIH', 1, 1, 1),
(28, 'Botswana', 'BW', 'BWA', 1, 1, 1),
(29, 'Bouvet Island', 'BV', 'BVT', 1, 1, 1),
(30, 'Brazil', 'BR', 'BRA', 6, 1, 1),
(31, 'British Indian Ocean Territory', 'IO', 'IOT', 1, 1, 1),
(32, 'Brunei Darussalam', 'BN', 'BRN', 1, 1, 1),
(33, 'Bulgaria', 'BG', 'BGR', 1, 1, 1),
(34, 'Burkina Faso', 'BF', 'BFA', 1, 1, 1),
(35, 'Burundi', 'BI', 'BDI', 1, 1, 1),
(36, 'Cambodia', 'KH', 'KHM', 1, 1, 1),
(37, 'Cameroon', 'CM', 'CMR', 1, 1, 1),
(38, 'Canada', 'CA', 'CAN', 2, 1, 1),
(39, 'Cape Verde', 'CV', 'CPV', 1, 1, 1),
(40, 'Cayman Islands', 'KY', 'CYM', 1, 1, 1),
(41, 'Central African Republic', 'CF', 'CAF', 1, 1, 1),
(42, 'Chad', 'TD', 'TCD', 1, 1, 1),
(43, 'Chile', 'CL', 'CHL', 1, 1, 1),
(44, 'China', 'CN', 'CHN', 5, 1, 1),
(45, 'Christmas Island', 'CX', 'CXR', 1, 1, 1),
(46, 'Cocos (Keeling) Islands', 'CC', 'CCK', 1, 1, 1),
(47, 'Colombia', 'CO', 'COL', 1, 1, 1),
(48, 'Comoros', 'KM', 'COM', 1, 1, 1),
(49, 'Congo', 'CG', 'COG', 1, 1, 1),
(50, 'Cook Islands', 'CK', 'COK', 1, 1, 1),
(51, 'Costa Rica', 'CR', 'CRI', 1, 1, 1),
(52, 'Cote D''Ivoire', 'CI', 'CIV', 1, 1, 1),
(53, 'Croatia', 'HR', 'HRV', 1, 1, 1),
(54, 'Cuba', 'CU', 'CUB', 1, 1, 1),
(55, 'Cyprus', 'CY', 'CYP', 1, 1, 1),
(56, 'Czech Republic', 'CZ', 'CZE', 1, 1, 1),
(57, 'Denmark', 'DK', 'DNK', 5, 1, 1),
(58, 'Djibouti', 'DJ', 'DJI', 1, 1, 1),
(59, 'Dominica', 'DM', 'DMA', 1, 1, 1),
(60, 'Dominican Republic', 'DO', 'DOM', 1, 1, 1),
(61, 'East Timor', 'TP', 'TMP', 1, 1, 1),
(62, 'Ecuador', 'EC', 'ECU', 1, 1, 1),
(63, 'Egypt', 'EG', 'EGY', 1, 1, 1),
(64, 'El Salvador', 'SV', 'SLV', 1, 1, 1),
(65, 'Equatorial Guinea', 'GQ', 'GNQ', 1, 1, 1),
(66, 'Eritrea', 'ER', 'ERI', 1, 1, 1),
(67, 'Estonia', 'EE', 'EST', 1, 1, 1),
(68, 'Ethiopia', 'ET', 'ETH', 1, 1, 1),
(69, 'Falkland Islands (Malvinas)', 'FK', 'FLK', 1, 1, 1),
(70, 'Faroe Islands', 'FO', 'FRO', 1, 1, 1),
(71, 'Fiji', 'FJ', 'FJI', 1, 1, 1),
(72, 'Finland', 'FI', 'FIN', 5, 1, 1),
(73, 'France', 'FR', 'FRA', 5, 1, 1),
(74, 'France, Metropolitan', 'FX', 'FXX', 1, 1, 1),
(75, 'French Guiana', 'GF', 'GUF', 1, 1, 1),
(76, 'French Polynesia', 'PF', 'PYF', 1, 1, 1),
(77, 'French Southern Territories', 'TF', 'ATF', 1, 1, 1),
(78, 'Gabon', 'GA', 'GAB', 1, 1, 1),
(79, 'Gambia', 'GM', 'GMB', 1, 1, 1),
(80, 'Georgia', 'GE', 'GEO', 1, 1, 1),
(81, 'Germany', 'DE', 'DEU', 5, 1, 1),
(82, 'Ghana', 'GH', 'GHA', 1, 1, 1),
(83, 'Gibraltar', 'GI', 'GIB', 1, 1, 1),
(84, 'Greece', 'GR', 'GRC', 1, 1, 1),
(85, 'Greenland', 'GL', 'GRL', 5, 1, 1),
(86, 'Grenada', 'GD', 'GRD', 1, 1, 1),
(87, 'Guadeloupe', 'GP', 'GLP', 1, 1, 1),
(88, 'Guam', 'GU', 'GUM', 1, 1, 1),
(89, 'Guatemala', 'GT', 'GTM', 1, 1, 1),
(90, 'Guinea', 'GN', 'GIN', 1, 1, 1),
(91, 'Guinea-bissau', 'GW', 'GNB', 1, 1, 1),
(92, 'Guyana', 'GY', 'GUY', 1, 1, 1),
(93, 'Haiti', 'HT', 'HTI', 1, 1, 1),
(94, 'Heard and Mc Donald Islands', 'HM', 'HMD', 1, 1, 1),
(95, 'Honduras', 'HN', 'HND', 1, 1, 1),
(96, 'Hong Kong', 'HK', 'HKG', 7, 1, 1),
(97, 'Hungary', 'HU', 'HUN', 1, 1, 1),
(98, 'Iceland', 'IS', 'ISL', 5, 1, 1),
(99, 'India', 'IN', 'IND', 8, 1, 1),
(100, 'Indonesia', 'ID', 'IDN', 8, 1, 1),
(101, 'Iran (Islamic Republic of)', 'IR', 'IRN', 1, 1, 1),
(102, 'Iraq', 'IQ', 'IRQ', 1, 1, 1),
(103, 'Ireland', 'IE', 'IRL', 8, 1, 1),
(104, 'Israel', 'IL', 'ISR', 5, 1, 1),
(105, 'Italy', 'IT', 'ITA', 9, 1, 1),
(106, 'Jamaica', 'JM', 'JAM', 1, 1, 1),
(107, 'Japan', 'JP', 'JPN', 2, 1, 1),
(108, 'Jordan', 'JO', 'JOR', 1, 1, 1),
(109, 'Kazakhstan', 'KZ', 'KAZ', 1, 1, 1),
(110, 'Kenya', 'KE', 'KEN', 1, 1, 1),
(111, 'Kiribati', 'KI', 'KIR', 1, 1, 1),
(112, 'Korea, Democratic People''s Republic of', 'KP', 'PRK', 8, 1, 1),
(113, 'Korea, Republic of', 'KR', 'KOR', 8, 1, 1),
(114, 'Kuwait', 'KW', 'KWT', 1, 1, 1),
(115, 'Kyrgyzstan', 'KG', 'KGZ', 1, 1, 1),
(116, 'Lao People''s Democratic Republic', 'LA', 'LAO', 1, 1, 1),
(117, 'Latvia', 'LV', 'LVA', 1, 1, 1),
(118, 'Lebanon', 'LB', 'LBN', 1, 1, 1),
(119, 'Lesotho', 'LS', 'LSO', 1, 1, 1),
(120, 'Liberia', 'LR', 'LBR', 1, 1, 1),
(121, 'Libyan Arab Jamahiriya', 'LY', 'LBY', 1, 1, 1),
(122, 'Liechtenstein', 'LI', 'LIE', 1, 1, 1),
(123, 'Lithuania', 'LT', 'LTU', 1, 1, 1),
(124, 'Luxembourg', 'LU', 'LUX', 5, 1, 1),
(125, 'Macau', 'MO', 'MAC', 1, 1, 1),
(126, 'Macedonia, The Former Yugoslav Republic of', 'MK', 'MKD', 1, 1, 1),
(127, 'Madagascar', 'MG', 'MDG', 1, 1, 1),
(128, 'Malawi', 'MW', 'MWI', 1, 1, 1),
(129, 'Malaysia', 'MY', 'MYS', 1, 1, 1),
(130, 'Maldives', 'MV', 'MDV', 1, 1, 1),
(131, 'Mali', 'ML', 'MLI', 1, 1, 1),
(132, 'Malta', 'MT', 'MLT', 1, 1, 1),
(133, 'Marshall Islands', 'MH', 'MHL', 1, 1, 1),
(134, 'Martinique', 'MQ', 'MTQ', 1, 1, 1),
(135, 'Mauritania', 'MR', 'MRT', 1, 1, 1),
(136, 'Mauritius', 'MU', 'MUS', 1, 1, 1),
(137, 'Mayotte', 'YT', 'MYT', 1, 1, 1),
(138, 'Mexico', 'MX', 'MEX', 9, 1, 1),
(139, 'Micronesia, Federated States of', 'FM', 'FSM', 1, 1, 1),
(140, 'Moldova, Republic of', 'MD', 'MDA', 1, 1, 1),
(141, 'Monaco', 'MC', 'MCO', 1, 1, 1),
(142, 'Mongolia', 'MN', 'MNG', 1, 1, 1),
(143, 'Montserrat', 'MS', 'MSR', 1, 1, 1),
(144, 'Morocco', 'MA', 'MAR', 1, 1, 1),
(145, 'Mozambique', 'MZ', 'MOZ', 1, 1, 1),
(146, 'Myanmar', 'MM', 'MMR', 1, 1, 1),
(147, 'Namibia', 'NA', 'NAM', 1, 1, 1),
(148, 'Nauru', 'NR', 'NRU', 1, 1, 1),
(149, 'Nepal', 'NP', 'NPL', 1, 1, 1),
(150, 'Netherlands', 'NL', 'NLD', 5, 1, 1),
(151, 'Netherlands Antilles', 'AN', 'ANT', 1, 1, 1),
(152, 'New Caledonia', 'NC', 'NCL', 1, 1, 1),
(153, 'New Zealand', 'NZ', 'NZL', 8, 1, 1),
(154, 'Nicaragua', 'NI', 'NIC', 1, 1, 1),
(155, 'Niger', 'NE', 'NER', 1, 1, 1),
(156, 'Nigeria', 'NG', 'NGA', 1, 1, 1),
(157, 'Niue', 'NU', 'NIU', 1, 1, 1),
(158, 'Norfolk Island', 'NF', 'NFK', 1, 1, 1),
(159, 'Northern Mariana Islands', 'MP', 'MNP', 1, 1, 1),
(160, 'Norway', 'NO', 'NOR', 5, 1, 1),
(161, 'Oman', 'OM', 'OMN', 1, 1, 1),
(162, 'Pakistan', 'PK', 'PAK', 1, 1, 1),
(163, 'Palau', 'PW', 'PLW', 1, 1, 1),
(164, 'Panama', 'PA', 'PAN', 1, 1, 1),
(165, 'Papua New Guinea', 'PG', 'PNG', 1, 1, 1),
(166, 'Paraguay', 'PY', 'PRY', 1, 1, 1),
(167, 'Peru', 'PE', 'PER', 1, 1, 1),
(168, 'Philippines', 'PH', 'PHL', 1, 1, 1),
(169, 'Pitcairn', 'PN', 'PCN', 1, 1, 1),
(170, 'Poland', 'PL', 'POL', 5, 1, 1),
(171, 'Portugal', 'PT', 'PRT', 5, 1, 1),
(172, 'Puerto Rico', 'PR', 'PRI', 1, 1, 1),
(173, 'Qatar', 'QA', 'QAT', 1, 1, 1),
(174, 'Reunion', 'RE', 'REU', 1, 1, 1),
(175, 'Romania', 'RO', 'ROM', 1, 1, 1),
(176, 'Russian Federation', 'RU', 'RUS', 5, 1, 1),
(177, 'Rwanda', 'RW', 'RWA', 1, 1, 1),
(178, 'Saint Kitts and Nevis', 'KN', 'KNA', 1, 1, 1),
(179, 'Saint Lucia', 'LC', 'LCA', 1, 1, 1),
(180, 'Saint Vincent and the Grenadines', 'VC', 'VCT', 1, 1, 1),
(181, 'Samoa', 'WS', 'WSM', 1, 1, 1),
(182, 'San Marino', 'SM', 'SMR', 1, 1, 1),
(183, 'Sao Tome and Principe', 'ST', 'STP', 1, 1, 1),
(184, 'Saudi Arabia', 'SA', 'SAU', 1, 1, 1),
(185, 'Senegal', 'SN', 'SEN', 1, 1, 1),
(186, 'Seychelles', 'SC', 'SYC', 1, 1, 1),
(187, 'Sierra Leone', 'SL', 'SLE', 1, 1, 1),
(188, 'Singapore', 'SG', 'SGP', 12, 1, 1),
(189, 'Slovakia (Slovak Republic)', 'SK', 'SVK', 1, 1, 1),
(190, 'Slovenia', 'SI', 'SVN', 1, 1, 1),
(191, 'Solomon Islands', 'SB', 'SLB', 1, 1, 1),
(192, 'Somalia', 'SO', 'SOM', 1, 1, 1),
(193, 'South Africa', 'ZA', 'ZAF', 10, 1, 1),
(194, 'South Georgia and the South Sandwich Islands', 'GS', 'SGS', 1, 1, 1),
(195, 'Spain', 'ES', 'ESP', 3, 1, 1),
(196, 'Sri Lanka', 'LK', 'LKA', 1, 1, 1),
(197, 'St. Helena', 'SH', 'SHN', 1, 1, 1),
(198, 'St. Pierre and Miquelon', 'PM', 'SPM', 1, 1, 1),
(199, 'Sudan', 'SD', 'SDN', 1, 1, 1),
(200, 'Suriname', 'SR', 'SUR', 1, 1, 1),
(201, 'Svalbard and Jan Mayen Islands', 'SJ', 'SJM', 1, 1, 1),
(202, 'Swaziland', 'SZ', 'SWZ', 1, 1, 1),
(203, 'Sweden', 'SE', 'SWE', 5, 1, 1),
(204, 'Switzerland', 'CH', 'CHE', 5, 1, 1),
(205, 'Syrian Arab Republic', 'SY', 'SYR', 1, 1, 1),
(206, 'Taiwan', 'TW', 'TWN', 8, 1, 1),
(207, 'Tajikistan', 'TJ', 'TJK', 1, 1, 1),
(208, 'Tanzania, United Republic of', 'TZ', 'TZA', 1, 1, 1),
(209, 'Thailand', 'TH', 'THA', 1, 1, 1),
(210, 'Togo', 'TG', 'TGO', 1, 1, 1),
(211, 'Tokelau', 'TK', 'TKL', 1, 1, 1),
(212, 'Tonga', 'TO', 'TON', 1, 1, 1),
(213, 'Trinidad and Tobago', 'TT', 'TTO', 1, 1, 1),
(214, 'Tunisia', 'TN', 'TUN', 1, 1, 1),
(215, 'Turkey', 'TR', 'TUR', 1, 1, 1),
(216, 'Turkmenistan', 'TM', 'TKM', 1, 1, 1),
(217, 'Turks and Caicos Islands', 'TC', 'TCA', 1, 1, 1),
(218, 'Tuvalu', 'TV', 'TUV', 1, 1, 1),
(219, 'Uganda', 'UG', 'UGA', 1, 1, 1),
(220, 'Ukraine', 'UA', 'UKR', 1, 1, 1),
(221, 'United Arab Emirates', 'AE', 'ARE', 1, 1, 1),
(222, 'United Kingdom', 'GB', 'GBR', 11, 1, 1),
(223, 'United States', 'US', 'USA', 2, 1, 1),
(224, 'United States Minor Outlying Islands', 'UM', 'UMI', 1, 1, 1),
(225, 'Uruguay', 'UY', 'URY', 1, 1, 1),
(226, 'Uzbekistan', 'UZ', 'UZB', 1, 1, 1),
(227, 'Vanuatu', 'VU', 'VUT', 1, 1, 1),
(228, 'Vatican City State (Holy See)', 'VA', 'VAT', 1, 1, 1),
(229, 'Venezuela', 'VE', 'VEN', 1, 1, 1),
(230, 'Viet Nam', 'VN', 'VNM', 1, 1, 1),
(231, 'Virgin Islands (British)', 'VG', 'VGB', 1, 1, 1),
(232, 'Virgin Islands (U.S.)', 'VI', 'VIR', 1, 1, 1),
(233, 'Wallis and Futuna Islands', 'WF', 'WLF', 1, 1, 1),
(234, 'Western Sahara', 'EH', 'ESH', 1, 1, 1),
(235, 'Yemen', 'YE', 'YEM', 1, 1, 1),
(236, 'Yugoslavia', 'YU', 'YUG', 1, 1, 1),
(237, 'Zaire', 'ZR', 'ZAR', 1, 1, 1),
(238, 'Zambia', 'ZM', 'ZMB', 1, 1, 1),
(239, 'Zimbabwe', 'ZW', 'ZWE', 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `coupons`
--

CREATE TABLE `coupons` (
  `coupon_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupon_type` char(1) NOT NULL DEFAULT 'F',
  `coupon_code` varchar(100) NOT NULL DEFAULT '',
  `coupon_amount` decimal(8,4) NOT NULL DEFAULT '0.0000',
  `coupon_minimum_order` decimal(8,4) NOT NULL DEFAULT '0.0000',
  `coupon_start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `coupon_expire_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `uses_per_coupon` int(5) NOT NULL DEFAULT '1',
  `uses_per_user` int(5) NOT NULL DEFAULT '0',
  `restrict_to_products` varchar(255) DEFAULT NULL,
  `restrict_to_categories` varchar(255) DEFAULT NULL,
  `restrict_to_customers` text,
  `coupon_active` char(1) NOT NULL DEFAULT 'Y',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `coupon_sale_exclude` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`coupon_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `coupons_description`
--

CREATE TABLE `coupons_description` (
  `coupon_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '0',
  `coupon_name` varchar(100) NOT NULL DEFAULT '',
  `coupon_description` text,
  PRIMARY KEY (`coupon_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `coupon_email_track`
--

CREATE TABLE `coupon_email_track` (
  `unique_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupon_id` int(11) NOT NULL DEFAULT '0',
  `customer_id_sent` int(11) NOT NULL DEFAULT '0',
  `sent_firstname` varchar(100) DEFAULT NULL,
  `sent_lastname` varchar(100) DEFAULT NULL,
  `emailed_to` varchar(100) DEFAULT NULL,
  `date_sent` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`unique_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `coupon_gv_customer`
--

CREATE TABLE `coupon_gv_customer` (
  `customer_id` int(5) NOT NULL DEFAULT '0',
  `amount` decimal(8,4) NOT NULL DEFAULT '0.0000',
  KEY `idx_customer_id` (`customer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `coupon_gv_queue`
--

CREATE TABLE `coupon_gv_queue` (
  `unique_id` int(5) NOT NULL AUTO_INCREMENT,
  `customer_id` int(5) NOT NULL DEFAULT '0',
  `order_id` int(5) NOT NULL DEFAULT '0',
  `amount` decimal(8,4) NOT NULL DEFAULT '0.0000',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ipaddr` varchar(100) NOT NULL DEFAULT '',
  `release_flag` char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`unique_id`),
  KEY `uid` (`unique_id`,`customer_id`,`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `coupon_redeem_track`
--

CREATE TABLE `coupon_redeem_track` (
  `unique_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupon_id` int(11) NOT NULL DEFAULT '0',
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `redeem_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `redeem_ip` varchar(100) NOT NULL DEFAULT '',
  `order_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`unique_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `currencies`
--

CREATE TABLE `currencies` (
  `currencies_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL DEFAULT '',
  `code` char(3) NOT NULL DEFAULT '',
  `symbol_left` varchar(12) DEFAULT NULL,
  `symbol_right` varchar(12) DEFAULT NULL,
  `decimal_point` char(1) DEFAULT NULL,
  `thousands_point` char(1) DEFAULT NULL,
  `decimal_places` char(1) DEFAULT NULL,
  `value` float(13,8) DEFAULT NULL,
  `last_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`currencies_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `currencies`
--

INSERT INTO `currencies` VALUES
(1, 'US Dollar', 'USD', '$', '', '.', ',', '2', 1.00000000, '2004-04-05 08:33:25'),
(2, 'Euro', 'EUR', '&euro;', '', '.', ',', '2', 0.82529998, '2004-04-05 08:33:25'),
(3, 'British Pound', 'GBP', '&pound;', '', '.', ',', '2', 0.54670000, '2004-04-05 08:33:25');

-- --------------------------------------------------------

--
-- Table structure for table `customers`
--

CREATE TABLE `customers` (
  `customers_id` int(11) NOT NULL AUTO_INCREMENT,
  `purchased_without_account` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `customers_gender` char(1) NOT NULL DEFAULT '',
  `customers_firstname` varchar(100) NOT NULL DEFAULT '',
  `customers_lastname` varchar(100) NOT NULL DEFAULT '',
  `customers_dob` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `customers_email_address` varchar(96) NOT NULL DEFAULT '',
  `customers_default_address_id` int(11) NOT NULL DEFAULT '0',
  `customers_password` varchar(40) NOT NULL DEFAULT '',
  `customers_newsletter` char(1) DEFAULT NULL,
  `customers_selected_template` varchar(20) DEFAULT NULL,
  `customers_validation_code` varchar(48) NOT NULL DEFAULT '',
  `customers_validation` char(1) NOT NULL DEFAULT '0',
  `customers_email_registered` varchar(100) NOT NULL DEFAULT '',
  `secret_id` varchar(100) NOT NULL DEFAULT '',
  `is_complete` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`customers_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `customers`
--

INSERT INTO `customers` VALUES
(1, 0, 'm', 'Sal', 'Iozzia', '0000-00-00 00:00:00', 'sal@loadedcommerce.com', 1, 'f6ffd4179cb5a2dff4781fc366529738:52', '1', NULL, '', '1', '', '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `customers_basket`
--

CREATE TABLE `customers_basket` (
  `customers_basket_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `products_id` tinytext NOT NULL,
  `customers_basket_quantity` int(2) NOT NULL DEFAULT '0',
  `final_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `customers_basket_date_added` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`customers_basket_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `customers_basket_attributes`
--

CREATE TABLE `customers_basket_attributes` (
  `customers_basket_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `products_id` tinytext NOT NULL,
  `products_options_id` int(11) NOT NULL DEFAULT '0',
  `products_options_value_id` int(11) NOT NULL DEFAULT '0',
  `products_options_value_text` text NOT NULL,
  PRIMARY KEY (`customers_basket_attributes_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `customers_cc_info`
--

CREATE TABLE `customers_cc_info` (
  `customers_cc_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) DEFAULT NULL,
  `card_number` varchar(50) DEFAULT NULL,
  `exp_month` varchar(50) DEFAULT NULL,
  `exp_year` varchar(10) NOT NULL,
  `card_type` varchar(50) DEFAULT NULL,
  `cc_type` varchar(20) DEFAULT NULL,
  `meta_data` text NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `email_address` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`customers_cc_id`),
  KEY `idx_customers_id` (`customers_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `customers_info`
--

CREATE TABLE `customers_info` (
  `customers_info_id` int(11) NOT NULL DEFAULT '0',
  `customers_info_date_of_last_logon` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `customers_info_number_of_logons` int(5) NOT NULL DEFAULT '0',
  `customers_info_date_account_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `customers_info_date_account_last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `global_product_notifications` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`customers_info_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `customers_info`
--

INSERT INTO `customers_info` VALUES
(1, '2012-07-05 15:30:38', 1, '2012-07-05 15:25:10', '2012-07-05 15:31:23', 0);

-- --------------------------------------------------------

--
-- Table structure for table `customers_wishlist`
--

CREATE TABLE `customers_wishlist` (
  `products_id` int(13) NOT NULL DEFAULT '0',
  `customers_id` int(13) NOT NULL DEFAULT '0',
  `products_model` varchar(25) DEFAULT NULL,
  `products_name` varchar(255) NOT NULL DEFAULT '',
  `products_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `final_price` decimal(13,2) NOT NULL DEFAULT '0.00',
  `products_quantity` int(2) NOT NULL DEFAULT '0',
  `wishlist_name` varchar(255) DEFAULT NULL,
  KEY `idx_customers_products_id` (`customers_id`,`products_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `customers_wishlist_attributes`
--

CREATE TABLE `customers_wishlist_attributes` (
  `customers_wishlist_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `products_id` int(11) NOT NULL DEFAULT '0',
  `products_options_id` int(11) NOT NULL DEFAULT '0',
  `products_options_value_id` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`customers_wishlist_attributes_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `data_cat`
--

CREATE TABLE `data_cat` (
  `cat_id` int(11) NOT NULL DEFAULT '0',
  `cat_tree` varchar(254) DEFAULT NULL,
  PRIMARY KEY (`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `data_files`
--

CREATE TABLE `data_files` (
  `data_files_id` int(11) NOT NULL AUTO_INCREMENT,
  `data_name` varchar(15) NOT NULL DEFAULT 'No Name',
  `data_files_type` varchar(11) NOT NULL DEFAULT 'basic',
  `data_files_disc` varchar(100) NOT NULL DEFAULT 'not configured',
  `data_files_type1` varchar(10) NOT NULL DEFAULT 'product',
  `data_files_service` varchar(10) DEFAULT 'froogle',
  `data_status` int(1) NOT NULL DEFAULT '0',
  `data_files_name` varchar(255) NOT NULL DEFAULT 'Not configured',
  `data_image_url` varchar(255) DEFAULT NULL,
  `data_product_url` varchar(255) DEFAULT NULL,
  `data_ftp_server` varchar(100) DEFAULT 'hedwig.google.com',
  `data_ftp_user_name` varchar(100) DEFAULT NULL,
  `data_ftp_user_pass` varchar(100) DEFAULT NULL,
  `data_ftp_directory` varchar(255) DEFAULT NULL,
  `data_tax_class_id` int(11) NOT NULL DEFAULT '0',
  `data_convert_cur` varchar(5) DEFAULT 'false',
  `data_cur_use` varchar(5) NOT NULL DEFAULT 'true',
  `data_cur` char(3) DEFAULT 'USD',
  `data_lang_use` varchar(5) NOT NULL DEFAULT 'true',
  `data_lang_char` char(2) DEFAULT 'en',
  PRIMARY KEY (`data_files_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `default_permalink`
--

CREATE TABLE `default_permalink` (
  `default_id` int(11) NOT NULL AUTO_INCREMENT,
  `page_name` varchar(256) DEFAULT NULL,
  `permalink_name` varchar(256) NOT NULL,
  `php_page_name` varchar(100) NOT NULL,
  `pages_friendly_name` varchar(255) NOT NULL,
  `is_menu_list` tinyint(1) NOT NULL DEFAULT '1',
  `route` varchar(100) NOT NULL,
  PRIMARY KEY (`default_id`,`permalink_name`),
  UNIQUE KEY `UNIQ` (`permalink_name`),
  KEY `idx_page_name` (`page_name`),
  KEY `idx_permalink_name` (`permalink_name`),
  KEY `idx_php_page_name` (`php_page_name`),
  KEY `idx_is_menu_list` (`is_menu_list`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=112 ;

--
-- Dumping data for table `default_permalink`
--

INSERT INTO `default_permalink` VALUES
(1, 'product-on-sale', 'specials', 'specials.php', 'Special Products', 3, 'core/specials'),
(2, 'new-products', 'new-products', 'products_new.php', 'New Products', 3, 'core/products_new'),
(3, 'featured-products', 'featured-products', 'featured_products.php', 'Featured Products', 3, 'core/featured_products'),
(4, 'home', 'home', 'index.php', 'Home Page', 1, 'core/index'),
(5, 'login', 'login', 'login.php', 'Login', 2, 'core/login'),
(6, 'create-account', 'create-account', 'create_account.php', 'Create Account', 2, 'core/create_account'),
(7, 'advanced-search', 'advanced-search', 'advanced_search.php', 'Advance Search', 3, 'core/advanced_search'),
(8, 'contact', 'contact', 'contact_us.php', 'Contact Us', 1, 'core/contact_us'),
(9, 'account', 'account', 'account.php', 'My Account', 2, 'core/account'),
(10, 'account-password', 'account-password', 'account_password.php', 'Change Password', 0, 'core/account_password'),
(11, 'account-history', 'account-history', 'account_history.php', 'Order History', 0, 'core/account_history'),
(12, 'address-book-process', 'address-book-process', 'address_book_process.php', 'Address Book Process', 0, 'core/address_book_process'),
(13, 'address-book', 'address-book', 'address_book.php', 'Address Book', 0, 'core/address_book'),
(14, 'cart', 'cart', 'shopping_cart.php', 'Shopping Cart', 1, 'core/shopping_cart'),
(15, 'account-edit', 'account-edit', 'account_edit.php', 'Edit Account', 0, 'core/account_edit'),
(16, 'account-newsletters', 'account-newsletters', 'account_newsletters.php', 'Newsletter Settings', 0, 'core/account_newsletters'),
(17, 'account-notifications', 'account-notifications', 'account_notifications.php', 'Notification Settings', 0, 'core/account_notifications'),
(18, 'logoff', 'logoff', 'logoff.php', 'Logout', 0, 'core/logoff'),
(19, 'wishlist', 'wishlist', 'wishlist.php', 'Wishlist', 0, 'core/wishlist'),
(20, 'wishlist-email', 'wishlist-email', 'wishlist_email.php', 'Email WIshlist', 0, 'core/wishlist_email'),
(21, 'checkout-shipping', 'checkout-shipping', 'checkout_shipping.php', 'Checkout Shipping', 0, 'core/checkout_shipping'),
(22, 'checkout-shipping-address', 'checkout-shipping-address', 'checkout_shipping_address.php', 'Checkout Shipping Address', 0, 'core/checkout_shipping_address'),
(23, 'checkout-payment', 'checkout-payment', 'checkout_payment.php', 'Checkout Payment', 0, 'core/checkout_payment'),
(24, 'checkout-confirmation', 'checkout-confirmation', 'checkout_confirmation.php', 'Checkout Confirmation', 0, 'core/checkout_confirmation'),
(25, 'advanced-search-result', 'advanced-search-result', 'advanced_search_result.php', 'Advance Search Result', 0, 'core/advanced_search_result'),
(26, 'checkout-success', 'checkout-success', 'checkout_success.php', 'Checkout Success', 0, 'core/checkout_success'),
(27, 'order-checkout', 'order-checkout', 'order_checkout.php', 'One Page Checkout', 0, 'opc/order_checkout'),
(28, 'order-info', 'order-info', 'Order_Info.php', 'Guest Checkout', 0, 'core/Order_Info'),
(29, 'password-forgotten', 'password-forgotten', 'password_forgotten.php', 'Password Receovery', 2, 'core/password_forgotten'),
(30, 'order-info-process', 'order-info-process', 'order_info_process.php', 'Guest Checkout Process', 0, 'core/order_info_process'),
(31, 'wishlist-help', 'wishlist-help', 'wishlist_help.php', 'Wishlist Help', 0, 'core/wishlist_help'),
(33, 'checkout-payment-address', 'checkout-payment-address', 'checkout_payment_address.php', 'Checkout Payment Address', 0, 'core/checkout_payment_address'),
(34, 'faq', 'faq', 'faq.php', 'Faq', 1, 'core/faq'),
(35, 'links', 'links', 'links.php', 'Links', 1, 'core/links'),
(36, 'links-submit', 'links-submit', 'links_submit.php', 'Submit Link', 0, 'core/links_submit'),
(37, 'pw', 'pw', 'pw.php', 'Account Activation', 0, 'core/pw'),
(38, 'customer-testimonials', 'customer-testimonials', 'customer_testimonials.php', 'Customer Testimonials', 1, 'ctm/customer_testimonials'),
(39, 'sitemap', 'sitemap', 'sitemap.php', 'Sitemap', 1, 'core/sitemap'),
(40, 'checkout-processing', 'checkout-processing', 'checkout_processing.php', 'Checkout Processing', 0, 'opc/checkout_processing'),
(45, 'product-info', 'product-info', 'product_info.php', 'Product Details Page', 3, 'core/product_info'),
(46, 'tell-a-friend', 'tell-a-friend', 'tell_a_friend.php', 'Tell a Friend', 1, 'core/tell_a_friend'),
(47, 'affiliate-central', 'affiliate-central', 'affiliate_central.php', 'Affiliate Home', 0, 'afl/affiliate_central'),
(48, 'affiliate-banners', 'affiliate-banners', 'affiliate_banners.php', 'Affiliate Banners', 0, 'afl/affiliate_banners'),
(49, 'affiliate-banners-build', 'affiliate-banners-build', 'affiliate_banners_build.php', 'Affiliate Build Banners', 0, 'afl/affiliate_banners_build'),
(50, 'affiliate-details', 'affiliate-details', 'affiliate_details.php', 'Affiliate Details', 0, 'afl/affiliate_details'),
(51, 'affiliate-details-success', 'affiliate-details-success', 'affiliate_details_ok.php', 'Affiliate Details Ok', 0, 'afl/affiliate_details_ok'),
(52, 'affiliate-banners-category', 'affiliate-banners-category', 'affiliate_banners_category.php', 'Affiliate Banners Category', 0, 'afl/affiliate_banners_category'),
(53, 'affiliate-banners-banners', 'affiliate-banners-banners', 'affiliate_banners_banners.php', 'Affiliate Banners Information', 0, 'afl/affiliate_banners_banners'),
(54, 'affiliate-banners-build-cat', 'affiliate-banners-build-cat', 'affiliate_banners_build_cat.php', 'Affiliate Category Banners', 0, 'afl/affiliate_banners_build_cat'),
(55, 'affiliate-banners-product', 'affiliate-banners-product', 'affiliate_banners_product.php', 'Affiliate Product Banners', 0, 'afl/affiliate_banners_product'),
(56, 'affiliate-banners-text', 'affiliate-banners-text', 'affiliate_banners_text.php', 'Affiliate Text Banners', 0, 'afl/affiliate_banners_text'),
(57, 'affiliate-clicks', 'affiliate-clicks', 'affiliate_clicks.php', 'Affiliate Clicks', 0, 'afl/affiliate_clicks'),
(58, 'affiliate-contact', 'affiliate-contact', 'affiliate_contact.php', 'Affiliate Contact', 0, 'afl/affiliate_contact'),
(59, 'affiliate-faq', 'affiliate-faq', 'affiliate_faq.php', 'Affiliate Faq', 0, 'afl/affiliate_faq'),
(60, 'affiliate-info', 'affiliate-info', 'affiliate_info.php', 'Affiliate Information', 0, 'afl/affiliate_info'),
(61, 'affiliate-news', 'affiliate-news', 'affiliate_news.php', 'Affiliate News', 0, 'afl/affiliate_news'),
(62, 'affiliate-newsletter', 'affiliate-newsletter', 'affiliate_newsletter.php', 'Affiliate Newsletter', 0, 'afl/affiliate_newsletter'),
(63, 'affiliate-payment', 'affiliate-payment', 'affiliate_payment.php', 'Affiliate Payment', 0, 'afl/affiliate_payment'),
(64, 'affiliate-reports', 'affiliate-reports', 'affiliate_reports.php', 'Affiliate Reports', 0, 'afl/affiliate_reports'),
(65, 'affiliate-sales', 'affiliate-sales', 'affiliate_sales.php', 'Affiliate Sales', 0, 'afl/affiliate_sales'),
(66, 'affiliate-summary', 'affiliate-summary', 'affiliate_summary.php', 'Affiliate Summary', 0, 'afl/affiliate_summary'),
(67, 'affiliate-terms', 'affiliate-terms', 'affiliate_terms.php', 'Affiliate Terms', 0, 'afl/affiliate_terms'),
(68, 'affiliate-login', 'affiliate-login', 'affiliate_affiliate.php', 'Affiliate Login', 4, 'afl/affiliate_affiliate'),
(69, 'affiliate-logout', 'affiliate-logout', 'affiliate_logout.php', 'Affiliate Logout', 0, 'afl/affiliate_logout'),
(70, 'affiliate-signup', 'affiliate-signup', 'affiliate_signup.php', 'Affiliate Signup', 4, 'afl/affiliate_signup'),
(71, 'affiliate-signup-success', 'affiliate-signup-success', 'affiliate_signup_ok.php', 'Affiliate Signup Confirmation', 0, 'afl/affiliate_signup_ok'),
(72, 'affiliate-password', 'affiliate-password', 'affiliate_password.php', 'Affiliate Password', 0, 'afl/affiliate_password'),
(73, 'affiliate-password-forgotten', 'affiliate-password-forgotten', 'affiliate_password_forgotten.php', 'Affiliate Recovery Password', 4, 'afl/affiliate_password_forgotten'),
(74, 'my-points', 'my-points', 'my_points.php', 'Reward Points', 0, 'pnr/my_points'),
(75, 'my-points-help', 'my-points-help', 'my_points_help.php', 'Reward Points Help', 0, 'pnr/my_points_help'),
(76, 'private-messages', 'private-messages', 'private_messages.php', 'Customer Private Message', 0, 'csmm/private_messages'),
(81, 'additional-information', 'additional-information', 'fss_additional_information.php', 'Forms - Additional Information', 0, 'fss/fss_additional_information'),
(82, 'completed-surveys', 'completed-surveys', 'fss_completed_surveys.php', 'Forms - Completed Surveys', 0, 'fss/fss_completed_surveys'),
(83, 'forms', 'forms', 'fss_forms_detail.php', 'Forms - Form Details', 0, 'fss/fss_forms_detail'),
(84, 'forms-index', 'forms-index', 'fss_forms_index.php', 'Forms - Home', 0, 'fss/fss_forms_index'),
(85, 'forms-post-success', 'forms-post-success', 'fss_forms_post_success.php', 'Forms - Post Sucess ', 0, 'fss/fss_forms_post_success'),
(86, 'fp-contact-us', 'fp-contact-us', 'fss_fp_contact_us.php', 'Forms - Contact Us', 1, 'fss/fss_fp_contact_us'),
(87, 'surveys-info', 'surveys-info', 'fss_surveys_info.php', 'Forms - Surveys Info', 1, 'fss/fss_surveys_info'),
(88, 'uncompleted-surveys', 'uncompleted-surveys', 'fss_uncompleted_surveys.php', 'Forms - Uncompleted Surveys', 1, 'fss/fss_uncompleted_surveys'),
(90, 'reviews', 'reviews', 'reviews.php', 'Reviews', 3, 'core/reviews'),
(91, 'product-reviews-info', 'product-reviews-info', 'product_reviews_info.php', 'Product Reviews Details', 3, 'core/product_reviews_info'),
(93, 'articles', 'articles', 'articles.php', 'Articles', 0, 'core/articles'),
(94, 'article-info', 'article-info', 'article_info.php', 'Article Details', 0, 'core/article_info'),
(95, 'article-reviews-write', 'article-reviews-write', 'article_reviews_write.php', 'Write Article Review', 0, 'core/article_reviews_write'),
(96, 'article-reviews', 'article-reviews', 'article_reviews.php', 'Article Reviews', 0, 'core/article_reviews'),
(100, '404-page-not-found', '404-page-not-found', 'page-not-found.php', '404 Page Not Found', 0, 'core/page-not-found'),
(102, 'affiliate-product', 'affiliate-product', 'affiliate_product.php', 'Affiliate Product', 0, 'afl/affiliate_product'),
(103, 'affiliate-categories', 'affiliate-categories', 'affiliate_categories.php', 'Affiliate Categories', 0, 'afl/affiliate_categories'),
(104, 'article-print', 'article-print', 'article_print.php', 'Print Article', 0, 'core/article_print'),
(105, 'product-reviews', 'product-reviews', 'product_reviews.php', 'Product Reviews', 3, 'core/product_reviews'),
(106, 'ticket-create', 'ticket-create', 'ticket_create.php', 'Create Ticket', 1, 'csmm/ticket_create'),
(108, 'ticket-support', 'ticket-support', 'ticket_support.php', 'Support Ticket Home', 1, 'csmm/ticket_support'),
(109, 'ticket', 'ticket', 'ticket_view.php', 'Ticket Details', 1, 'csmm/ticket_view'),
(110, 'products-write-your-review', 'products-write-your-review', 'product_reviews_write.php', 'Write Product Review', 0, 'core/product_reviews_write'),
(111, 'write-your-review', 'write-your-review', 'article_reviews_write.php', 'Write Article Review', 1, 'core/article_reviews_write');

-- --------------------------------------------------------

--
-- Table structure for table `email_subjects`
--

CREATE TABLE `email_subjects` (
  `email_subjects_id` int(11) NOT NULL AUTO_INCREMENT,
  `email_subjects_name` varchar(255) NOT NULL DEFAULT '',
  `email_subjects_category` int(1) DEFAULT NULL,
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`email_subjects_id`),
  KEY `IDX_EMAIL_SUBJECTS_NAME` (`email_subjects_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `faq`
--

CREATE TABLE `faq` (
  `faq_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `visible` enum('1','0') NOT NULL DEFAULT '1',
  `v_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `date` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`faq_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `faq_categories`
--

CREATE TABLE `faq_categories` (
  `categories_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `categories_image` varchar(255) DEFAULT NULL,
  `categories_sort_order` smallint(3) unsigned NOT NULL DEFAULT '9999',
  `categories_date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `categories_last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `categories_status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`categories_id`),
  KEY `idx_categories_date_added` (`categories_date_added`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `faq_categories`
--

INSERT INTO `faq_categories` VALUES
(1, '', 0, '2011-09-26 21:58:06', '0000-00-00 00:00:00', 1),
(2, '', 1, '2011-09-26 22:05:15', '0000-00-00 00:00:00', 1),
(3, '', 2, '2011-09-26 22:06:09', '0000-00-00 00:00:00', 1);

-- --------------------------------------------------------

--
-- Table structure for table `faq_categories_description`
--

CREATE TABLE `faq_categories_description` (
  `categories_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `categories_name` varchar(100) NOT NULL DEFAULT '',
  `categories_description` text,
  PRIMARY KEY (`categories_id`,`language_id`),
  KEY `idx_categories_name` (`categories_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `faq_categories_description`
--

INSERT INTO `faq_categories_description` VALUES
(1, 1, 'General FAQs', 'You can create many FAQ categories and control group access to them.'),
(2, 1, 'Shipping FAQs', 'This is a generic description of a Shipping FAQ''s category.'),
(3, 1, 'Returns FAQs', 'This is a generic description of a Product Returns FAQ''s category.');

-- --------------------------------------------------------

--
-- Table structure for table `faq_description`
--

CREATE TABLE `faq_description` (
  `faq_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `language_id` int(10) NOT NULL DEFAULT '1',
  `question` text NOT NULL,
  `answer` text NOT NULL,
  PRIMARY KEY (`faq_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `faq_to_categories`
--

CREATE TABLE `faq_to_categories` (
  `faq_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `categories_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`faq_id`,`categories_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `faq_to_categories`
--

INSERT INTO `faq_to_categories` VALUES
(1, 1),
(3, 3),
(4, 2);

-- --------------------------------------------------------

--
-- Table structure for table `featured`
--

CREATE TABLE `featured` (
  `featured_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL DEFAULT '0',
  `featured_date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `featured_last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_status_change` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`featured_id`),
  KEY `idx_products_id` (`products_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `featured`
--

INSERT INTO `featured` VALUES
(2, 41, '2018-09-01 05:56:02', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3, 28, '2018-09-01 05:56:08', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4, 24, '2018-09-01 05:56:13', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5, 51, '2018-09-01 05:56:19', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6, 30, '2018-09-01 05:56:26', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7, 36, '2018-09-01 05:56:34', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);

-- --------------------------------------------------------

--
-- Table structure for table `geo_zones`
--

CREATE TABLE `geo_zones` (
  `geo_zone_id` int(11) NOT NULL AUTO_INCREMENT,
  `geo_zone_name` varchar(100) NOT NULL DEFAULT '',
  `geo_zone_description` varchar(255) NOT NULL DEFAULT '',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`geo_zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `infobox_configuration`
--

CREATE TABLE `infobox_configuration` (
  `template_id` int(11) NOT NULL DEFAULT '0',
  `infobox_id` int(11) NOT NULL AUTO_INCREMENT,
  `infobox_file_name` varchar(255) NOT NULL DEFAULT '',
  `infobox_define` varchar(255) NOT NULL DEFAULT 'BOX_HEADING_',
  `infobox_display` varchar(5) NOT NULL DEFAULT '',
  `display_in_column` varchar(255) NOT NULL DEFAULT 'left',
  `location` int(3) NOT NULL DEFAULT '0',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `box_heading` varchar(255) NOT NULL DEFAULT '',
  `box_template` varchar(255) NOT NULL DEFAULT 'infobox',
  `box_heading_font_color` varchar(10) NOT NULL DEFAULT '#000000',
  `addon_name` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`infobox_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=40 ;

--
-- Dumping data for table `infobox_configuration`
--

INSERT INTO `infobox_configuration` VALUES
(1, 1, 'downloads.php', 'BOX_HEADING_DOWNLOADS', 'no', 'right', 7, '0000-00-00 00:00:00', '[[regtime]]', 'You Have a Download', 'infobox', '#F39800', ''),
(1, 2, 'currencies.php', 'BOX_HEADING_CURRENCIES', 'no', 'right', 6, '0000-00-00 00:00:00', '[[regtime]]', 'Currencies', 'infobox', '#F39800', ''),
(1, 3, 'order_history.php', 'BOX_HEADING_CUSTOMER_ORDERS', 'no', 'right', 4, '0000-00-00 00:00:00', '[[regtime]]', 'Order History', 'infobox', '#F39800', ''),
(1, 4, 'languages.php', 'BOX_HEADING_LANGUAGES', 'no', 'right', 5, '0000-00-00 00:00:00', '[[regtime]]', 'Languages', 'infobox', '#F39800', ''),
(1, 5, 'best_sellers.php', 'BOX_HEADING_BESTSELLERS', 'no', 'right', 3, '0000-00-00 00:00:00', '[[regtime]]', 'Best Sellers', 'infobox', '#F39800', ''),
(1, 6, 'customer_gv.php', 'BOX_HEADING_GIFT_VOUCHER', 'no', 'right', 1, '0000-00-00 00:00:00', '[[regtime]]', 'Gift Voucher', 'infobox', '#F39800', ''),
(1, 7, 'loginbox.php', 'BOX_HEADING_LOGIN', 'yes', 'right', 2, '0000-00-00 00:00:00', '[[regtime]]', 'Your Account', 'infobox', '#F39800', ''),
(1, 8, 'shopping_cart.php', 'BOX_HEADING_SHOPPING_CART', 'yes', 'right', 1, '0000-00-00 00:00:00', '[[regtime]]', 'Shopping Cart', 'infobox', '#F39800', ''),
(1, 9, 'googlead.php', 'BOX_GOOGLE_AD_BANNER_HEADING', 'no', 'left', 26, '0000-00-00 00:00:00', '[[regtime]]', 'Google Ad', 'infobox', '#F39800', ''),
(1, 10, 'whos_online.php', 'BOX_HEADING_WHOS_ONLINE', 'no', 'left', 25, '0000-00-00 00:00:00', '[[regtime]]', 'Who''s Online', 'infobox', '#F39800', ''),
(1, 11, 'links.php', 'BOX_HEADING_LINKS', 'yes', 'left', 24, '0000-00-00 00:00:00', '[[regtime]]', 'Links', 'infobox', '#F39800', ''),
(1, 12, 'featured.php', 'BOX_HEADING_FEATURED', 'no', 'left', 22, '0000-00-00 00:00:00', '[[regtime]]', 'Featured', 'infobox', '#F39800', ''),
(1, 13, 'affiliate.php', 'BOX_HEADING_AFFILIATE', 'no', 'left', 23, '0000-00-00 00:00:00', '[[regtime]]', 'Affiliate Info', 'infobox', '#F39800', ''),
(1, 14, 'shop_by_price.php', 'BOX_HEADING_SHOP_BY_PRICE', 'no', 'left', 21, '0000-00-00 00:00:00', '[[regtime]]', 'Shop by Price', 'infobox', '#F39800', ''),
(1, 15, 'whats_new.php', 'BOX_HEADING_WHATS_NEW', 'no', 'left', 20, '0000-00-00 00:00:00', '[[regtime]]', 'Latest products', 'infobox', '#F39800', ''),
(1, 16, 'tell_a_friend.php', 'BOX_HEADING_TELL_A_FRIEND', 'no', 'left', 19, '0000-00-00 00:00:00', '[[regtime]]', 'Tell A Friend', 'infobox', '#F39800', ''),
(1, 17, 'product_notifications.php', 'BOX_HEADING_NOTIFICATIONS', 'no', 'left', 18, '0000-00-00 00:00:00', '[[regtime]]', 'Notifications', 'infobox', '#F39800', ''),
(1, 18, 'manufacturer_info.php', 'BOX_HEADING_MANUFACTURER_INFO', 'no', 'left', 17, '0000-00-00 00:00:00', '[[regtime]]', 'Manufacturers Info', 'infobox', '#F39800', ''),
(1, 19, 'manufacturers.php', 'BOX_HEADING_MANUFACTURERS', 'yes', 'left', 16, '0000-00-00 00:00:00', '[[regtime]]', 'Manufacturers', 'infobox', '#F39800', ''),
(1, 20, 'search.php', 'BOX_HEADING_SEARCH', 'no', 'left', 15, '0000-00-00 00:00:00', '[[regtime]]', 'Quick Find', 'infobox', '#F39800', ''),
(1, 21, 'reviews.php', 'BOX_HEADING_REVIEWS', 'no', 'left', 9, '0000-00-00 00:00:00', '[[regtime]]', 'Reviews', 'infobox', '#F39800', ''),
(1, 22, 'specials.php', 'BOX_HEADING_SPECIALS', 'yes', 'left', 10, '0000-00-00 00:00:00', '[[regtime]]', 'Specials', 'infobox', '#F39800', ''),
(1, 23, 'categories3.php', 'BOX_HEADING_CATEGORIES3', 'no', 'left', 7, '0000-00-00 00:00:00', '[[regtime]]', 'Categories', 'infobox', '#F39800', ''),
(1, 24, 'categories4.php', 'BOX_HEADING_CATEGORIES4', 'no', 'left', 8, '0000-00-00 00:00:00', '[[regtime]]', 'Categories', 'infobox', '#F39800', ''),
(1, 25, 'categories1.php', 'BOX_HEADING_CATEGORIES1', 'no', 'left', 5, '0000-00-00 00:00:00', '[[regtime]]', 'Categories', 'infobox', '#F39800', ''),
(1, 26, 'categories2.php', 'BOX_HEADING_CATEGORIES2', 'no', 'left', 6, '0000-00-00 00:00:00', '[[regtime]]', 'Categories', 'infobox', '#F39800', ''),
(1, 27, 'categories.php', 'BOX_HEADING_CATEGORIES', 'yes', 'left', 1, '0000-00-00 00:00:00', '[[regtime]]', 'Categories', 'infobox', '#F39800', ''),
(1, 28, 'articles.php', 'BOX_HEADING_ARTICLES', 'yes', 'right', 27, '0000-00-00 00:00:00', '[[regtime]]', 'Articles', 'infobox', '#F39800', ''),
(1, 30, 'faq.php', 'BOX_HEADING_FAQ', 'yes', 'right', 30, '0000-00-00 00:00:00', '[[regtime]]', 'Faq', 'infobox', '#F39800', ''),
(1, 31, 'authors.php', 'BOX_HEADING_AUTHORS', 'yes', 'right', 29, '0000-00-00 00:00:00', '[[regtime]]', 'Authors', 'infobox', '#F39800', ''),
(1, 32, 'asearch.php', 'BOX_HEADING_ASEARCH', 'no', 'left', 31, '0000-00-00 00:00:00', '[[regtime]]', 'Article Search', 'infobox', '#F39800', ''),
(1, 33, 'wishlist.php', 'BOX_HEADING_WISHLIST', 'no', 'right', 9, '0000-00-00 00:00:00', '[[regtime]]', 'Wishlist', 'infobox', '#F39800', ''),
(1, 34, 'boxad.php', 'BOX_AD_LP_HEADING', 'yes', 'left', 10, '0000-00-00 00:00:00', '[[regtime]]', 'Loaded Payments', 'infobox', '#F39800', ''),
(1, 35, 'search1.php', 'BOX_HEADING_SEARCH1', 'no', 'right', 8, '0000-00-00 00:00:00', '[[regtime]]', 'Advanced Search', 'infobox', '#F39800', ''),
(1, 36, 'buysafe.php', 'BOX_HEADING_BUYSAFE', 'no', 'left', 14, '0000-00-00 00:00:00', '[[regtime]]', '', 'infobox', '#F39800', ''),
(1, 37, 'example.php', 'BOX_HEADING_EXAMPLE', 'no', 'left', 13, '0000-00-00 00:00:00', '[[regtime]]', 'Example', 'infobox', '#F39800', ''),
(1, 38, 'we_accept.php', 'BOX_HEADING_WE_ACCEPT', 'no', 'left', 12, '0000-00-00 00:00:00', '[[regtime]]', 'Cards We Accept', 'infobox', '#F39800', ''),
(1, 39, 'pages.php', 'BOX_HEADING_PAGES', 'yes', 'left', 11, '0000-00-00 00:00:00', '[[regtime]]', 'Information', 'infobox', '#F39800', '');

-- --------------------------------------------------------

--
-- Table structure for table `infobox_heading`
--

CREATE TABLE `infobox_heading` (
  `infobox_id` int(11) NOT NULL DEFAULT '0',
  `languages_id` int(11) NOT NULL DEFAULT '0',
  `box_heading` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`infobox_id`,`languages_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `infobox_heading`
--

INSERT INTO `infobox_heading` VALUES
(1, 1, 'You Have a Download'),
(2, 1, 'Currencies'),
(3, 1, 'Order History'),
(4, 1, 'Languages'),
(5, 1, 'Best Sellers'),
(6, 1, 'Gift Voucher'),
(7, 1, 'Your Account'),
(8, 1, 'Shopping Cart'),
(9, 1, 'Google Ad'),
(10, 1, 'Who''s Online'),
(11, 1, 'Links'),
(12, 1, 'Featured'),
(13, 1, 'Affiliate Info'),
(14, 1, 'Shop by Price'),
(15, 1, 'Latest products'),
(16, 1, 'Tell A Friend'),
(17, 1, 'Notifications'),
(18, 1, 'Manufacturers Info'),
(19, 1, 'Manufacturers'),
(20, 1, 'Quick Find'),
(21, 1, 'Reviews'),
(22, 1, 'Specials'),
(23, 1, 'Categories'),
(24, 1, 'Categories'),
(25, 1, 'Categories'),
(26, 1, 'Categories'),
(27, 1, 'Categories'),
(28, 1, 'Articles'),
(30, 1, 'Faq'),
(31, 1, 'Authors'),
(32, 1, 'Article Search'),
(33, 1, 'Wishlist'),
(34, 1, 'Loaded Payments'),
(35, 1, 'Advanced Search'),
(36, 1, ''),
(37, 1, 'Example'),
(38, 1, 'Cards We Accept'),
(39, 1, 'Information');

-- --------------------------------------------------------

--
-- Table structure for table `languages`
--

CREATE TABLE `languages` (
  `languages_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `code` char(2) NOT NULL DEFAULT '',
  `image` varchar(255) DEFAULT NULL,
  `directory` varchar(100) DEFAULT NULL,
  `sort_order` smallint(3) unsigned NOT NULL DEFAULT '9999',
  PRIMARY KEY (`languages_id`),
  KEY `IDX_LANGUAGES_NAME` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `languages`
--

INSERT INTO `languages` VALUES
(1, 'English', 'en', 'icon.gif', 'english', 1);

-- --------------------------------------------------------

--
-- Table structure for table `lcaddons`
--

CREATE TABLE `lcaddons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(100) NOT NULL,
  `serial_key` text NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `date_installed` date NOT NULL,
  `last_checked` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `links`
--

CREATE TABLE `links` (
  `links_id` int(11) NOT NULL AUTO_INCREMENT,
  `links_url` varchar(255) DEFAULT NULL,
  `links_reciprocal_url` varchar(255) DEFAULT NULL,
  `links_image_url` varchar(255) DEFAULT NULL,
  `links_contact_name` varchar(255) DEFAULT NULL,
  `links_contact_email` varchar(96) DEFAULT NULL,
  `links_date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `links_last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `links_status` int(11) NOT NULL DEFAULT '0',
  `links_clicked` int(11) NOT NULL DEFAULT '0',
  `links_rating` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`links_id`),
  KEY `idx_links_date_added` (`links_date_added`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `links`
--

INSERT INTO `links` VALUES
(1, 'http://www.adobe.com/', 'http://www.adobe.com/', '', 'Daquan Bentley', 'sodales.at.velit@arcuSedet.ca', '2011-09-11 03:20:39', '0000-00-00 00:00:00', 2, 1, 4),
(2, 'http://www.lycos.com/', 'http://www.lycos.com/', '', 'Emerald B. Foster', 'iaculis@Maecenasiaculis.edu', '2011-09-11 03:22:40', '0000-00-00 00:00:00', 2, 0, 3),
(3, 'http://www.microsoft.com/', 'http://www.microsoft.com/', '', 'Sonia I. Davis', 'convallis@consectetuer.ca', '2011-09-11 03:23:45', '0000-00-00 00:00:00', 1, 0, 0),
(4, 'http://www.cakewalk.com/', 'http://www.cakewalk.com/', '', 'Madeson V. Herring', 'ornare.Fusce@nonleo.com', '2011-09-11 03:25:15', '0000-00-00 00:00:00', 2, 0, 5),
(5, 'http://www.jquery.com/', 'http://www.jquery.com/', '', 'Joelle S. Knox', 'varius.ultrices@vulputatemauris.ca', '2011-09-11 03:27:19', '0000-00-00 00:00:00', 2, 0, 2),
(6, 'http://www.apple.com/', 'http://www.apple.com/', '', 'Paula K. Figueroa', 'at@molestieSedid.com', '2011-09-11 03:29:52', '0000-00-00 00:00:00', 3, 0, 4);

-- --------------------------------------------------------

--
-- Table structure for table `links_description`
--

CREATE TABLE `links_description` (
  `links_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `links_title` varchar(255) NOT NULL DEFAULT '',
  `links_description` text,
  PRIMARY KEY (`links_id`,`language_id`),
  KEY `links_title` (`links_title`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `links_description`
--

INSERT INTO `links_description` VALUES
(1, 1, 'Vestibulum ante ipsum primis in', 'Suspendisse non leo. Vivamus nibh dolor, nonummy ac, feugiat non, lobortis quis, pede. Suspendisse dui. Fusce diam nunc, ullamcorper eu, euismod ac, fermentum vel, mauris. Integer sem elit, pharetra.'),
(2, 1, 'Suspendisse tristique neque venenatis', 'Pellentesque ultricies dignissim lacus. Aliquam rutrum lorem ac risus. Morbi metus. Vivamus euismod urna. Nullam lobortis quam a felis ullamcorper viverra. Maecenas iaculis aliquet diam. Sed diam lorem, auctor quis, tristique ac, eleifend vitae.'),
(3, 1, 'Maecenas malesuada fringilla est', 'Proin mi. Aliquam gravida mauris ut mi. Duis risus odio, auctor vitae, aliquet nec, imperdiet nec, leo. Morbi neque tellus, imperdiet non, vestibulum nec, euismod in, dolor. Fusce feugiat. Lorem ipsum dolor sit amet, consectetuer.'),
(4, 1, 'Semper dui lectus rutrum urn nec', 'Nunc ullamcorper, velit in aliquet lobortis, nisi nibh lacinia orci, consectetuer euismod est arcu ac orci. Ut semper pretium neque. Morbi quis urna. Nunc quis arcu vel quam dignissim pharetra. Nam ac nulla.'),
(5, 1, 'Nullam feugiat placerat velit', 'Phasellus vitae mauris sit amet lorem semper auctor. Mauris vel turpis. Aliquam adipiscing lobortis risus. In mi pede, nonummy ut, molestie in, tempus eu.'),
(6, 1, 'Nisi sem semper   morbi neque tellus imperdiet non.', 'Morbi neque tellus, imperdiet non, vestibulum nec, euismod in, dolor. Fusce feugiat. Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aliquam auctor, velit eget laoreet posuere, enim nisl.');

-- --------------------------------------------------------

--
-- Table structure for table `links_status`
--

CREATE TABLE `links_status` (
  `links_status_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `links_status_name` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`links_status_id`,`language_id`),
  KEY `idx_links_status_name` (`links_status_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `links_status`
--

INSERT INTO `links_status` VALUES
(1, 1, 'Pending'),
(2, 1, 'Approved'),
(3, 1, 'Disabled');

-- --------------------------------------------------------

--
-- Table structure for table `links_to_link_categories`
--

CREATE TABLE `links_to_link_categories` (
  `links_id` int(11) NOT NULL DEFAULT '0',
  `link_categories_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`links_id`,`link_categories_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `links_to_link_categories`
--

INSERT INTO `links_to_link_categories` VALUES
(1, 4),
(2, 1),
(3, 2),
(4, 3),
(5, 3),
(6, 3);

-- --------------------------------------------------------

--
-- Table structure for table `link_categories`
--

CREATE TABLE `link_categories` (
  `link_categories_id` int(11) NOT NULL AUTO_INCREMENT,
  `link_categories_image` varchar(255) DEFAULT NULL,
  `link_categories_sort_order` smallint(3) unsigned NOT NULL DEFAULT '9999',
  `link_categories_date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_categories_last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_categories_status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`link_categories_id`),
  KEY `idx_link_categories_date_added` (`link_categories_date_added`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `link_categories`
--

INSERT INTO `link_categories` VALUES
(1, NULL, 10, '2011-09-11 03:13:03', '0000-00-00 00:00:00', 1),
(2, NULL, 20, '2011-09-11 03:13:52', '0000-00-00 00:00:00', 1),
(3, NULL, 30, '2011-09-11 03:14:18', '0000-00-00 00:00:00', 1),
(4, NULL, 40, '2011-09-11 03:14:40', '0000-00-00 00:00:00', 1),
(5, NULL, 50, '2011-09-11 03:15:14', '0000-00-00 00:00:00', 1);

-- --------------------------------------------------------

--
-- Table structure for table `link_categories_description`
--

CREATE TABLE `link_categories_description` (
  `link_categories_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `link_categories_name` varchar(100) NOT NULL DEFAULT '',
  `link_categories_description` text,
  PRIMARY KEY (`link_categories_id`,`language_id`),
  KEY `idx_link_categories_name` (`link_categories_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `link_categories_description`
--

INSERT INTO `link_categories_description` VALUES
(1, 1, 'Partners', 'Suspendisse sed dolor. Fusce mi lorem, vehicula et, rutrum eu, ultrices sit amet, risus.'),
(2, 1, 'Product Vendors', 'Maecenas mi felis, adipiscing fringilla, porttitor vulputate, posuere vulputate, lacus. Cras interdum. Nunc sollicitudin commodo ipsum. Suspendisse non leo. Vivamus nibh dolor, nonummy ac, feugiat.'),
(3, 1, 'Wholesale Suppliers', 'Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Donec tincidunt. Donec vitae erat vel pede blandit congue. In scelerisque scelerisque dui.'),
(4, 1, 'Buyers', 'Phasellus dapibus quam quis diam. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Fusce aliquet magna a neque.'),
(5, 1, 'Employees', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Etiam laoreet, libero et tristique pellentesque, tellus sem mollis dui, in sodales elit erat vitae risus. Duis a venenatis a, magna.');

-- --------------------------------------------------------

--
-- Table structure for table `manufacturers`
--

CREATE TABLE `manufacturers` (
  `manufacturers_id` int(11) NOT NULL AUTO_INCREMENT,
  `manufacturers_name` varchar(100) NOT NULL DEFAULT '',
  `manufacturers_image` varchar(255) DEFAULT NULL,
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`manufacturers_id`),
  KEY `IDX_MANUFACTURERS_NAME` (`manufacturers_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `manufacturers`
--

INSERT INTO `manufacturers` VALUES
(1, 'Matrox', '', '2012-07-06 10:14:59', '2012-07-06 10:14:59'),
(2, 'Warner', '', '2012-07-06 10:14:59', '2012-07-06 10:14:59'),
(3, 'Microsoft', '', '2012-07-06 10:14:59', '2012-07-06 10:14:59'),
(4, 'Fox', '', '2012-07-06 10:14:59', '2012-07-06 10:14:59'),
(5, 'Sierra', '', '2012-07-06 10:14:59', '2012-07-06 10:14:59'),
(6, 'GT Interactive', '', '2012-07-06 10:14:59', '2012-07-06 10:14:59'),
(7, 'Hewlett Packard', '', '2012-07-06 10:14:59', '2012-07-06 10:14:59'),
(8, 'The Shopping Cart', '', '2012-07-06 10:14:59', '2012-07-06 10:14:59');

-- --------------------------------------------------------

--
-- Table structure for table `manufacturers_info`
--

CREATE TABLE `manufacturers_info` (
  `manufacturers_id` int(11) NOT NULL DEFAULT '0',
  `languages_id` int(11) NOT NULL DEFAULT '0',
  `manufacturers_url` varchar(255) NOT NULL DEFAULT '',
  `url_clicked` int(5) NOT NULL DEFAULT '0',
  `date_last_click` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `manufacturers_htc_title_tag` varchar(80) DEFAULT NULL,
  `manufacturers_htc_desc_tag` longtext,
  `manufacturers_htc_keywords_tag` longtext,
  PRIMARY KEY (`manufacturers_id`,`languages_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `manufacturers_info`
--

INSERT INTO `manufacturers_info` VALUES
(1, 1, 'http://www.matrox.com/', 0, '0000-00-00 00:00:00', 'Matrox', 'Matrox', 'matrox'),
(2, 1, 'http://www.warner.com/', 0, '0000-00-00 00:00:00', 'Warner', 'Warner', 'warner'),
(3, 1, 'http://www.microsoft.com/', 0, '0000-00-00 00:00:00', 'Microsoft', 'Microsoft', 'microsoft'),
(4, 1, 'http://www.fox.com/', 0, '0000-00-00 00:00:00', 'Fox', 'Fox', 'fox'),
(5, 1, 'http://www.sierra.com/', 0, '0000-00-00 00:00:00', 'Sierra', 'Sierra', 'sierra'),
(6, 1, 'http://www.gtinteractive.com/', 0, '0000-00-00 00:00:00', 'GT Interactive', 'GT Interactive', 'gt interactive'),
(7, 1, 'http://www.hp.com/', 0, '0000-00-00 00:00:00', 'Hewlett Packard', 'Hewlett Packard', 'hp'),
(8, 1, 'http://www.theshoppingcart.com/', 0, '0000-00-00 00:00:00', 'The Shopping Cart', 'The Shopping Cart', 'the shopping cart');

-- --------------------------------------------------------

--
-- Table structure for table `monthly_sales_tax_report`
--

CREATE TABLE `monthly_sales_tax_report` (
  `id` int(11) NOT NULL,
  `month_name` varchar(50) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `gross_income` decimal(10,4) NOT NULL,
  `tax` decimal(10,4) NOT NULL,
  `nontaxed_sales` decimal(10,4) NOT NULL,
  `taxed_sales` decimal(10,4) NOT NULL,
  `tax_collected` decimal(10,4) NOT NULL,
  `shipping_handling` decimal(10,4) NOT NULL,
  `loworder` decimal(10,4) NOT NULL,
  `other` decimal(10,4) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `newsletters`
--

CREATE TABLE `newsletters` (
  `newsletters_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `module` varchar(255) NOT NULL DEFAULT '',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_sent` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`newsletters_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `orders`
--

CREATE TABLE `orders` (
  `orders_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `customers_name` varchar(255) NOT NULL DEFAULT '',
  `customers_company` varchar(100) DEFAULT NULL,
  `customers_street_address` varchar(255) NOT NULL DEFAULT '',
  `customers_suburb` varchar(100) DEFAULT NULL,
  `customers_city` varchar(100) NOT NULL DEFAULT '',
  `customers_postcode` varchar(10) NOT NULL DEFAULT '',
  `customers_state` varchar(100) DEFAULT NULL,
  `customers_country` varchar(100) NOT NULL DEFAULT '',
  `customers_telephone` varchar(100) NOT NULL DEFAULT '',
  `customers_email_address` varchar(96) NOT NULL DEFAULT '',
  `customers_address_format_id` int(5) NOT NULL DEFAULT '0',
  `delivery_name` varchar(255) NOT NULL DEFAULT '',
  `delivery_company` varchar(100) DEFAULT NULL,
  `delivery_telephone` varchar(100) NOT NULL DEFAULT '',
  `delivery_fax` varchar(100) NOT NULL DEFAULT '',
  `delivery_email_address` varchar(96) NOT NULL DEFAULT '',
  `delivery_street_address` varchar(255) NOT NULL DEFAULT '',
  `delivery_suburb` varchar(100) DEFAULT NULL,
  `delivery_city` varchar(100) NOT NULL DEFAULT '',
  `delivery_postcode` varchar(10) NOT NULL DEFAULT '',
  `delivery_state` varchar(100) DEFAULT NULL,
  `delivery_country` varchar(100) NOT NULL DEFAULT '',
  `delivery_address_format_id` int(5) NOT NULL DEFAULT '0',
  `billing_name` varchar(255) NOT NULL DEFAULT '',
  `billing_company` varchar(100) DEFAULT NULL,
  `billing_telephone` varchar(100) NOT NULL DEFAULT '',
  `billing_fax` varchar(100) NOT NULL DEFAULT '',
  `billing_email_address` varchar(96) NOT NULL DEFAULT '',
  `billing_street_address` varchar(255) NOT NULL DEFAULT '',
  `billing_suburb` varchar(100) DEFAULT NULL,
  `billing_city` varchar(100) NOT NULL DEFAULT '',
  `billing_postcode` varchar(10) NOT NULL DEFAULT '',
  `billing_state` varchar(100) DEFAULT NULL,
  `billing_country` varchar(100) NOT NULL DEFAULT '',
  `billing_address_format_id` int(5) NOT NULL DEFAULT '0',
  `payment_module_name` varchar(255) NOT NULL DEFAULT '',
  `payment_method` varchar(100) NOT NULL DEFAULT '',
  `payment_info` text,
  `payment_id` int(11) NOT NULL DEFAULT '0',
  `cc_type` varchar(20) DEFAULT NULL,
  `cc_owner` varchar(255) DEFAULT NULL,
  `cc_number` varchar(90) DEFAULT NULL,
  `cc_expires` varchar(90) DEFAULT NULL,
  `cc_start` varchar(4) DEFAULT NULL,
  `cc_issue` char(3) DEFAULT NULL,
  `cc_bank_phone` varchar(100) NOT NULL DEFAULT '',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_purchased` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `orders_status` int(5) NOT NULL DEFAULT '0',
  `orders_date_finished` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `currency` char(3) DEFAULT NULL,
  `currency_value` decimal(14,6) DEFAULT NULL,
  `account_name` varchar(255) DEFAULT NULL,
  `account_number` varchar(100) DEFAULT NULL,
  `po_number` varchar(12) DEFAULT NULL,
  `purchased_without_account` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `paypal_ipn_id` int(11) NOT NULL DEFAULT '0',
  `transaction_id` varchar(100) NOT NULL DEFAULT '',
  `approval_code` varchar(100) NOT NULL DEFAULT '',
  `shipping_carrier` varchar(100) NOT NULL DEFAULT '',
  `shipping_method` varchar(100) NOT NULL DEFAULT '',
  `shipment_track_num` varchar(100) NOT NULL DEFAULT '',
  `shipment_method` varchar(100) NOT NULL DEFAULT '',
  `is_capture` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ipaddy` varchar(15) NOT NULL DEFAULT '',
  `ipisp` varchar(255) NOT NULL DEFAULT '',
  `admin_id` int(11) NOT NULL DEFAULT '0',
  `debug_data` text,
  PRIMARY KEY (`orders_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `orders_pay_methods`
--

CREATE TABLE `orders_pay_methods` (
  `pay_methods_id` int(11) NOT NULL AUTO_INCREMENT,
  `pay_method_language` int(11) NOT NULL DEFAULT '1',
  `pay_method_sort` smallint(3) unsigned NOT NULL DEFAULT '9999',
  `pay_method` varchar(255) NOT NULL DEFAULT '',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`pay_methods_id`,`pay_method_language`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `orders_products`
--

CREATE TABLE `orders_products` (
  `orders_products_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `products_id` int(11) NOT NULL DEFAULT '0',
  `products_model` varchar(25) DEFAULT NULL,
  `products_name` varchar(255) NOT NULL DEFAULT '',
  `products_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `final_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_tax` decimal(7,4) NOT NULL DEFAULT '0.0000',
  `products_quantity` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`orders_products_id`),
  KEY `idx_orders_id` (`orders_id`),
  KEY `idx_products_id` (`products_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `orders_products_attributes`
--

CREATE TABLE `orders_products_attributes` (
  `orders_products_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `orders_products_id` int(11) NOT NULL DEFAULT '0',
  `products_options` varchar(100) NOT NULL DEFAULT '',
  `products_options_values` varchar(255) NOT NULL DEFAULT '',
  `options_values_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `price_prefix` char(1) NOT NULL DEFAULT '',
  `products_options_id` int(11) NOT NULL DEFAULT '0',
  `products_options_values_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`orders_products_attributes_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `orders_products_download`
--

CREATE TABLE `orders_products_download` (
  `orders_products_download_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `orders_products_id` int(11) NOT NULL DEFAULT '0',
  `orders_products_filename` varchar(255) NOT NULL DEFAULT '',
  `download_maxdays` int(2) NOT NULL DEFAULT '0',
  `download_count` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`orders_products_download_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `orders_session_info`
--

CREATE TABLE `orders_session_info` (
  `txn_signature` varchar(100) NOT NULL DEFAULT '',
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `payment` varchar(100) NOT NULL DEFAULT '',
  `payment_title` varchar(100) NOT NULL DEFAULT '',
  `payment_amount` decimal(7,2) NOT NULL DEFAULT '0.00',
  `payment_currency` char(3) NOT NULL DEFAULT '',
  `payment_currency_val` float(13,8) DEFAULT NULL,
  `sendto` int(11) NOT NULL DEFAULT '1',
  `billto` int(11) NOT NULL DEFAULT '1',
  `language` varchar(100) NOT NULL DEFAULT '',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `currency` char(3) NOT NULL DEFAULT '',
  `currency_value` float(13,8) DEFAULT NULL,
  `firstname` varchar(100) NOT NULL DEFAULT '',
  `lastname` varchar(100) NOT NULL DEFAULT '',
  `content_type` varchar(100) NOT NULL DEFAULT '',
  `affiliate_id` int(11) DEFAULT '0',
  `affiliate_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `affiliate_browser` varchar(100) DEFAULT NULL,
  `affiliate_ipaddress` varchar(20) DEFAULT NULL,
  `affiliate_clickthroughs_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`txn_signature`,`orders_id`),
  KEY `idx_orders_session_info_txn_signature` (`txn_signature`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `orders_ship_methods`
--

CREATE TABLE `orders_ship_methods` (
  `ship_methods_id` int(11) NOT NULL AUTO_INCREMENT,
  `ship_method_language` int(11) NOT NULL DEFAULT '1',
  `ship_method_sort` smallint(3) unsigned NOT NULL DEFAULT '9999',
  `ship_method` varchar(255) NOT NULL DEFAULT '',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`ship_methods_id`,`ship_method_language`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `orders_status`
--

CREATE TABLE `orders_status` (
  `orders_status_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `orders_status_name` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`orders_status_id`,`language_id`),
  KEY `idx_orders_status_name` (`orders_status_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `orders_status`
--

INSERT INTO `orders_status` VALUES
(1, 1, 'Pending'),
(2, 1, 'Processing'),
(3, 1, 'Shipped'),
(4, 1, 'Delivered'),
(5, 1, 'Allow Download'),
(6, 1, 'On Hold'),
(7, 1, 'Canceled'),
(8, 1, 'Awaiting CC Processing'),
(88888, 1, 'Abandoned Shopping Cart'),
(99999, 1, 'Paypal Processing');

-- --------------------------------------------------------

--
-- Table structure for table `orders_status_history`
--

CREATE TABLE `orders_status_history` (
  `orders_status_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `orders_status_id` int(5) NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `customer_notified` tinyint(1) NOT NULL DEFAULT '0',
  `comments` text,
  `admin_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`orders_status_history_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `orders_total`
--

CREATE TABLE `orders_total` (
  `orders_total_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `text` varchar(255) NOT NULL DEFAULT '',
  `value` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `class` varchar(100) NOT NULL DEFAULT '',
  `sort_order` smallint(3) unsigned NOT NULL DEFAULT '9999',
  PRIMARY KEY (`orders_total_id`),
  KEY `idx_orders_total_orders_id` (`orders_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `pages`
--

CREATE TABLE `pages` (
  `pages_id` int(11) NOT NULL AUTO_INCREMENT,
  `pages_image` varchar(255) DEFAULT NULL,
  `pages_header_banner` varchar(255) DEFAULT NULL,
  `pages_date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `pages_date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `pages_author` varchar(255) NOT NULL DEFAULT '',
  `pages_status` tinyint(1) NOT NULL DEFAULT '1',
  `pages_sort_order` smallint(3) unsigned NOT NULL DEFAULT '9999',
  `pages_in_menu` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `pages_in_page_listing` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `pages_url` varchar(255) NOT NULL DEFAULT '',
  `pages_append_cdpath` varchar(255) NOT NULL DEFAULT '',
  `pages_url_target` varchar(255) NOT NULL DEFAULT '',
  `pages_attach_product` int(11) NOT NULL DEFAULT '0',
  `pages_group_access` varchar(255) NOT NULL DEFAULT 'G,0',
  PRIMARY KEY (`pages_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=22 ;

--
-- Dumping data for table `pages`
--

INSERT INTO `pages` VALUES
(5, NULL, NULL, '2010-09-04 15:14:55', '2018-08-17 07:44:46', '', 1, 10, 1, 2, '', '', '', 0, 'G,0'),
(3, NULL, NULL, '2010-09-04 14:04:40', '2018-08-17 07:34:20', '', 1, 20, 1, 2, '', '', '', 0, 'G,0'),
(6, NULL, NULL, '2010-09-04 18:43:47', '0000-00-00 00:00:00', '', 0, 40, 0, 0, '', '', '', 0, 'G,0'),
(7, NULL, NULL, '2012-10-26 12:07:55', '2018-08-17 07:33:06', '', 1, 10, 1, 2, '', '', '', 0, 'G,0'),
(11, NULL, NULL, '2017-12-16 04:08:23', '2018-08-17 07:27:07', '', 1, 40, 1, 2, '', '', '', 0, 'G,0'),
(12, NULL, NULL, '2017-12-16 04:09:41', '2018-08-17 07:35:14', '', 1, 30, 1, 2, '', '', '', 0, 'G,0'),
(13, NULL, NULL, '2017-12-16 04:40:18', '2018-08-17 07:28:32', '', 1, 60, 1, 2, '', '', '', 0, 'G,0'),
(21, NULL, NULL, '2018-01-29 13:12:03', '0000-00-00 00:00:00', '', 0, 60, 1, 2, '', '', '', 0, 'G,0'),
(19, NULL, NULL, '2018-01-29 10:47:16', '2018-08-17 07:35:38', '', 1, 40, 1, 2, '', '', '', 0, 'G,0'),
(17, NULL, NULL, '2018-01-22 09:02:53', '2018-08-17 08:07:13', '', 1, 50, 1, 2, '', '', '', 0, 'G,0'),
(18, NULL, NULL, '2018-01-29 10:17:52', '2018-08-17 07:35:56', '', 1, 50, 1, 2, '', '', '', 0, 'G,0');

-- --------------------------------------------------------

--
-- Table structure for table `pages_categories`
--

CREATE TABLE `pages_categories` (
  `categories_id` int(11) NOT NULL AUTO_INCREMENT,
  `categories_image` varchar(255) DEFAULT NULL,
  `categories_sort_order` smallint(3) unsigned NOT NULL DEFAULT '9999',
  `categories_date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `categories_last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `categories_status` tinyint(1) NOT NULL DEFAULT '0',
  `categories_parent_id` int(11) NOT NULL DEFAULT '0',
  `category_append_cdpath` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `categories_url_override` varchar(255) NOT NULL DEFAULT '',
  `categories_url_override_target` varchar(255) NOT NULL DEFAULT '',
  `category_heading_title_image` varchar(255) NOT NULL DEFAULT '',
  `category_header_banner` varchar(255) NOT NULL DEFAULT '',
  `categories_sub_category_view` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `categories_listing_content_mode` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `categories_listing_columns` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `categories_in_menu` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `categories_in_pages_listing` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `categories_language_saving_option` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `categories_template` varchar(100) DEFAULT NULL,
  `categories_attach_product` int(11) NOT NULL DEFAULT '0',
  `pages_group_access` varchar(255) NOT NULL DEFAULT 'G,0',
  PRIMARY KEY (`categories_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=16 ;

--
-- Dumping data for table `pages_categories`
--

INSERT INTO `pages_categories` VALUES
(1, 'header_acouunt.gif', 10, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0, 0, '', '', '', '', 0, 0, 0, 1, 1, 0, '', 0, 'G,0'),
(2, '', 20, '2008-07-08 21:00:51', '2008-07-08 21:07:44', 1, 0, 1, 'contact_us.php', '', '', '', 1, 0, 2, 1, 0, 0, '', 0, 'G,0'),
(4, NULL, 80, '[[regtime]]', '[[regtime]]', 1, 2, 1, 'https://loadedcommerce.com', '_blank', '', '', 1, 0, 2, 1, 2, 0, '', 0, 'G,0'),
(5, NULL, 50, '[[regtime]]', '[[regtime]]', 1, 0, 1, '', '', '', '', 1, 0, 2, 1, 2, 0, '', 0, 'G,0'),
(6, NULL, 60, '[[regtime]]', '[[regtime]]', 1, 0, 1, '', '', '', '', 1, 0, 2, 0, 0, 0, '', 0, 'G,0'),
(7, NULL, 70, '[[regtime]]', '[[regtime]]', 1, 0, 1, '', '', '', '', 1, 0, 2, 0, 0, 0, '', 0, 'G,0'),
(8, NULL, 20, '[[regtime]]', '[[regtime]]', 1, 6, 1, 'index.php?rt=core/contact_us', '', '', '', 1, 0, 2, 1, 2, 0, '', 0, 'G,0'),
(9, NULL, 45, '[[regtime]]', '[[regtime]]', 1, 6, 1, 'https://www.facebook.com/loadedcommerce/', '_blank', '', '', 1, 0, 2, 1, 2, 0, '', 0, 'G,0'),
(10, '216x150.png', 20, '[[regtime]]', '[[regtime]]', 1, 7, 0, '#', '_blank', '', '', 1, 0, 2, 1, 0, 0, '', 0, 'G,0'),
(11, '216x120.png', 10, '[[regtime]]', '[[regtime]]', 1, 7, 1, '#', '_blank', '', '', 1, 0, 2, 1, 2, 0, '', 0, 'G,0'),
(14, NULL, 10, '[[regtime]]', '[[regtime]]', 1, 2, 0, 'index.php?rt=core/specials', '', '', '', 1, 0, 2, 1, 2, 0, '', 0, 'G,0'),
(15, NULL, 90, '[[regtime]]', '[[regtime]]', 1, 2, 0, 'articles.php?tPath=1', '', '', '', 1, 0, 2, 1, 2, 0, '', 0, 'G,0');

-- --------------------------------------------------------

--
-- Table structure for table `pages_categories_description`
--

CREATE TABLE `pages_categories_description` (
  `categories_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `categories_name` varchar(255) DEFAULT NULL,
  `categories_description` text,
  `categories_heading` varchar(255) NOT NULL DEFAULT '',
  `categories_blurb` text NOT NULL,
  `categories_tag_keywords` varchar(96) NOT NULL DEFAULT '',
  `categories_meta_title` varchar(96) NOT NULL DEFAULT '',
  `categories_meta_keywords` text NOT NULL,
  `categories_meta_description` text NOT NULL,
  PRIMARY KEY (`categories_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `pages_categories_description`
--

INSERT INTO `pages_categories_description` VALUES
(1, 1, 'Information Pages', 'Information Pages', 'Information Pages', 'Information Pages', 'Information Pages', 'Information Pages', 'Information Pages', 'Information Pages'),
(2, 1, 'Contact Us', '', 'Contact Us', '', '', '', '', ''),
(4, 1, 'Easy Financing', '', 'Easy Financing', '', '', '', '', ''),
(5, 1, 'Terms and Conditions', '', 'Terms and Conditions', '', '', '', '', ''),
(6, 1, 'Loaded Commerce Store', '', 'Loaded Commerce Store', '', '', '', '', ''),
(7, 1, NULL, '', 'Footer column 1', '', '', '', '', ''),
(8, 1, 'Contact Us', '', 'Contact Us', '', '', '', '', ''),
(9, 1, '<i class="fa fa-facebook fa-lg" aria-hidden="true"></i> Our Facebook Page', '', '<i class="fa fa-facebook fa-lg" aria-hidden="true"></i>Our Fa', '', '', '', '', ''),
(10, 1, NULL, '', 'Equipment Leasing', '', '', '', '', ''),
(11, 1, NULL, '', 'Paypal Financing', '', '', '', '', ''),
(14, 1, 'Specials', '', 'Specials', '', '', '', '', ''),
(15, 1, 'Blog - New Additions', '', 'Blog - New Additions', '', '', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `pages_description`
--

CREATE TABLE `pages_description` (
  `pages_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `pages_title` varchar(255) NOT NULL DEFAULT '',
  `pages_meta_title` varchar(80) DEFAULT NULL,
  `pages_meta_keywords` varchar(255) DEFAULT NULL,
  `pages_meta_description` varchar(255) DEFAULT NULL,
  `pages_blurb` text,
  `pages_body` text,
  `pages_menu_name` varchar(255) NOT NULL DEFAULT '',
  `pages_file` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`pages_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `pages_description`
--

INSERT INTO `pages_description` VALUES
(1, 1, 'Terms and Conditions', 'Terms and Conditions', 'Terms and Conditions', 'Terms and Conditions', 'This is the terms and conditions blurb.', 'This is the terms and conditions description.', 'Terms and Conditions', ''),
(2, 1, 'Privacy Policy', 'Privacy Policy', 'Privacy Policy', 'Privacy Policy', 'This is the privacy policy blurb.', 'This is the privacy policy description.', 'Privacy Policy', ''),
(3, 1, 'Shipping Policy', 'Shipping Policy', 'Shipping Policy', 'Shipping Policy', 'This is the shipping policy blurb.', 'This is the shipping policy description.', 'Shipping Policy', ''),
(21, 1, 'Purchase Orders', '', '', '', '', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent ac erat est. Sed bibendum nisi vel nibh feugiat posuere. In tempor nisi sit amet quam gravida tincidunt. Quisque tempor massa ut elit lacinia maximus. Nunc suscipit enim congue consectetur venenatis. Cras urna lectus, sodales vel semper non, porta sit amet erat. Integer quis vehicula urna, id porttitor justo. Integer eleifend dui sapien, vitae porttitor neque egestas in. In erat mi, porttitor non malesuada et, posuere a risus. Duis eget risus dui. Vestibulum quis massa nec lectus interdum dictum. Curabitur et nisl dolor. In eu facilisis ligula.</p>', 'Purchase Orders', '_terms_and_conditions_purchase_orders_21.php'),
(5, 1, 'About The Loaded Store', '', '', '', '<p>About Us</p>', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent ac erat est. Sed bibendum nisi vel nibh feugiat posuere. In tempor nisi sit amet quam gravida tincidunt. Quisque tempor massa ut elit lacinia maximus. Nunc suscipit enim congue consectetur venenatis. Cras urna lectus, sodales vel semper non, porta sit amet erat. Integer quis vehicula urna, id porttitor justo. Integer eleifend dui sapien, vitae porttitor neque egestas in. In erat mi, porttitor non malesuada et, posuere a risus. Duis eget risus dui. Vestibulum quis massa nec lectus interdum dictum. Curabitur et nisl dolor. In eu facilisis ligula.</p>', 'About Us', 'about_us_5.php'),
(7, 1, 'Terms of service', '', '', '', '', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent ac erat est. Sed bibendum nisi vel nibh feugiat posuere. In tempor nisi sit amet quam gravida tincidunt. Quisque tempor massa ut elit lacinia maximus. Nunc suscipit enim congue consectetur venenatis. Cras urna lectus, sodales vel semper non, porta sit amet erat. Integer quis vehicula urna, id porttitor justo. Integer eleifend dui sapien, vitae porttitor neque egestas in. In erat mi, porttitor non malesuada et, posuere a risus. Duis eget risus dui. Vestibulum quis massa nec lectus interdum dictum. Curabitur et nisl dolor. In eu facilisis ligula.</p><h3>CONTACT INFORMATION</h3><p>Questions about the Terms of Service should be sent to us at info@example.com</p><p><b>123-456-7890 (Toll Free)</b><br />Office Hours: Mon-Fri from 9am - 5pm</p>', 'Terms of service', 'conditions_of_use_7.php'),
(11, 1, 'Price Match Guarantee', 'Price Match Guarantee', '', '', '', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent ac erat est. Sed bibendum nisi vel nibh feugiat posuere. In tempor nisi sit amet quam gravida tincidunt. Quisque tempor massa ut elit lacinia maximus. Nunc suscipit enim congue consectetur venenatis. Cras urna lectus, sodales vel semper non, porta sit amet erat. Integer quis vehicula urna, id porttitor justo. Integer eleifend dui sapien, vitae porttitor neque egestas in. In erat mi, porttitor non malesuada et, posuere a risus. Duis eget risus dui. Vestibulum quis massa nec lectus interdum dictum. Curabitur et nisl dolor. In eu facilisis ligula.</p>', 'Price Match Guarantee', '_info_price_match_guarantee_11.php'),
(12, 1, 'Delivery and Installation', 'Delivery and Installation', '', '', '', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent ac erat est. Sed bibendum nisi vel nibh feugiat posuere. In tempor nisi sit amet quam gravida tincidunt. Quisque tempor massa ut elit lacinia maximus. Nunc suscipit enim congue consectetur venenatis. Cras urna lectus, sodales vel semper non, porta sit amet erat. Integer quis vehicula urna, id porttitor justo. Integer eleifend dui sapien, vitae porttitor neque egestas in. In erat mi, porttitor non malesuada et, posuere a risus. Duis eget risus dui. Vestibulum quis massa nec lectus interdum dictum. Curabitur et nisl dolor. In eu facilisis ligula.</p>', 'Delivery and Installation', '_info_delivery_and_installation_12.php'),
(13, 1, 'Can''t find what you''re looking for?', '', '', '', 'Can''t find what you''re looking for? Let us find it for you', '<h2>Let us find it for you!</h2><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent ac erat est. Sed bibendum nisi vel nibh feugiat posuere. In tempor nisi sit amet quam gravida tincidunt. Quisque tempor massa ut elit lacinia maximus. Nunc suscipit enim congue consectetur venenatis. Cras urna lectus, sodales vel semper non, porta sit amet erat. Integer quis vehicula urna, id porttitor justo. Integer eleifend dui sapien, vitae porttitor neque egestas in. In erat mi, porttitor non malesuada et, posuere a risus. Duis eget risus dui. Vestibulum quis massa nec lectus interdum dictum. Curabitur et nisl dolor. In eu facilisis ligula.</p>', 'Can''t find what you''re looking for?', '_info_can_t_find_what_you_re_looking_for__13.php'),
(18, 1, 'Privacy Policy', '', '', '', '', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent ac erat est. Sed bibendum nisi vel nibh feugiat posuere. In tempor nisi sit amet quam gravida tincidunt. Quisque tempor massa ut elit lacinia maximus. Nunc suscipit enim congue consectetur venenatis. Cras urna lectus, sodales vel semper non, porta sit amet erat. Integer quis vehicula urna, id porttitor justo. Integer eleifend dui sapien, vitae porttitor neque egestas in. In erat mi, porttitor non malesuada et, posuere a risus. Duis eget risus dui. Vestibulum quis massa nec lectus interdum dictum. Curabitur et nisl dolor. In eu facilisis ligula.</p>', 'Privacy Policy', '_terms_and_conditions_privacy_policy_18.php'),
(17, 1, 'Address Block', '', '', '', '<div><br />LOADED COMMERCE STORE.</div><div>sales@example.com</div><div>Call Toll Free: 123-456- 7890<br />Monday thru Friday: 9am - 5pm</div>', '', 'Address Block', '_the_bench_press_address_block_17.php'),
(19, 1, 'Returns', '', '', '', '', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent ac erat est. Sed bibendum nisi vel nibh feugiat posuere. In tempor nisi sit amet quam gravida tincidunt. Quisque tempor massa ut elit lacinia maximus. Nunc suscipit enim congue consectetur venenatis. Cras urna lectus, sodales vel semper non, porta sit amet erat. Integer quis vehicula urna, id porttitor justo. Integer eleifend dui sapien, vitae porttitor neque egestas in. In erat mi, porttitor non malesuada et, posuere a risus. Duis eget risus dui. Vestibulum quis massa nec lectus interdum dictum. Curabitur et nisl dolor. In eu facilisis ligula.</p>', 'Returns', '_terms_and_conditions_returns_19.php');

-- --------------------------------------------------------

--
-- Table structure for table `pages_to_categories`
--

CREATE TABLE `pages_to_categories` (
  `pages_id` int(11) NOT NULL DEFAULT '0',
  `categories_id` int(11) NOT NULL DEFAULT '0',
  `page_sort_order` smallint(3) unsigned NOT NULL DEFAULT '9999',
  PRIMARY KEY (`pages_id`,`categories_id`),
  KEY `idx_categories_id` (`categories_id`,`pages_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `pages_to_categories`
--

INSERT INTO `pages_to_categories` VALUES
(1, 1, 10),
(2, 1, 20),
(3, 1, 30),
(5, 6, 10),
(3, 5, 20),
(6, 0, 20),
(7, 5, 10),
(11, 2, 40),
(12, 5, 30),
(13, 2, 60),
(19, 5, 40),
(18, 5, 50),
(17, 6, 50);

-- --------------------------------------------------------

--
-- Table structure for table `paypal`
--

CREATE TABLE `paypal` (
  `paypal_id` int(11) NOT NULL AUTO_INCREMENT,
  `txn_type` varchar(10) NOT NULL DEFAULT '',
  `reason_code` varchar(15) DEFAULT NULL,
  `payment_type` varchar(7) NOT NULL DEFAULT '',
  `payment_status` varchar(17) NOT NULL DEFAULT '',
  `pending_reason` varchar(14) DEFAULT NULL,
  `invoice` varchar(255) DEFAULT NULL,
  `mc_currency` char(3) NOT NULL DEFAULT '',
  `first_name` varchar(100) NOT NULL DEFAULT '',
  `last_name` varchar(100) NOT NULL DEFAULT '',
  `payer_business_name` varchar(255) DEFAULT NULL,
  `address_name` varchar(100) DEFAULT NULL,
  `address_street` varchar(255) DEFAULT NULL,
  `address_city` varchar(100) DEFAULT NULL,
  `address_state` varchar(100) DEFAULT NULL,
  `address_zip` varchar(10) DEFAULT NULL,
  `address_country` varchar(255) DEFAULT NULL,
  `address_status` varchar(11) DEFAULT NULL,
  `payer_email` varchar(96) NOT NULL DEFAULT '',
  `payer_id` varchar(100) NOT NULL DEFAULT '',
  `payer_status` varchar(10) NOT NULL DEFAULT '',
  `payment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `payment_time_zone` varchar(4) NOT NULL DEFAULT '',
  `business` varchar(96) NOT NULL DEFAULT '',
  `receiver_email` varchar(96) NOT NULL DEFAULT '',
  `receiver_id` varchar(100) NOT NULL DEFAULT '',
  `txn_id` varchar(17) NOT NULL DEFAULT '',
  `parent_txn_id` varchar(17) DEFAULT NULL,
  `num_cart_items` tinyint(4) unsigned NOT NULL DEFAULT '1',
  `mc_gross` decimal(7,2) NOT NULL DEFAULT '0.00',
  `mc_fee` decimal(7,2) NOT NULL DEFAULT '0.00',
  `payment_gross` decimal(7,2) DEFAULT NULL,
  `payment_fee` decimal(7,2) DEFAULT NULL,
  `settle_amount` decimal(7,2) DEFAULT NULL,
  `settle_currency` char(3) DEFAULT NULL,
  `exchange_rate` decimal(4,2) DEFAULT NULL,
  `for_auction` varchar(5) NOT NULL DEFAULT 'false',
  `auction_buyer_id` varchar(255) NOT NULL DEFAULT '',
  `auction_closing_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `auction_multi_item` tinyint(4) NOT NULL DEFAULT '0',
  `quantity` int(11) NOT NULL DEFAULT '0',
  `tax` decimal(7,2) DEFAULT NULL,
  `notify_version` decimal(2,1) NOT NULL DEFAULT '0.0',
  `verify_sign` varchar(128) NOT NULL DEFAULT '',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `memo` text,
  PRIMARY KEY (`paypal_id`,`txn_id`),
  KEY `idx_paypal_paypal_id` (`paypal_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `paypal_payment_status_history`
--

CREATE TABLE `paypal_payment_status_history` (
  `payment_status_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `paypal_id` int(11) NOT NULL DEFAULT '0',
  `payment_status` varchar(17) NOT NULL DEFAULT '',
  `pending_reason` varchar(14) DEFAULT NULL,
  `reason_code` varchar(15) DEFAULT NULL,
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`payment_status_history_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `permalinks`
--

CREATE TABLE `permalinks` (
  `permalink_id` int(11) NOT NULL AUTO_INCREMENT,
  `categories_id` int(11) NOT NULL DEFAULT '0',
  `products_id` int(11) NOT NULL DEFAULT '0',
  `pages_id` int(11) NOT NULL DEFAULT '0',
  `pages_categories_id` int(11) NOT NULL DEFAULT '0',
  `manufacturers_id` int(11) NOT NULL DEFAULT '0',
  `testimonial_cat_id` int(11) NOT NULL DEFAULT '0',
  `link_categories_id` int(11) NOT NULL DEFAULT '0',
  `links_id` int(11) NOT NULL DEFAULT '0',
  `faq_categories_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `permalink_name` varchar(256) DEFAULT NULL,
  `permalink_type` varchar(100) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `form_id` int(11) NOT NULL,
  `topics_id` int(11) NOT NULL,
  `articles_id` int(11) NOT NULL,
  `filename` varchar(100) NOT NULL,
  `route` varchar(100) NOT NULL,
  PRIMARY KEY (`permalink_id`),
  UNIQUE KEY `language_id` (`language_id`,`permalink_name`),
  KEY `idx_articles_id` (`articles_id`),
  KEY `idx_forms_id` (`form_id`),
  KEY `idx_cat_id` (`categories_id`),
  KEY `idx_products_id` (`products_id`),
  KEY `idx_pages_id` (`pages_id`),
  KEY `idx_page_cat_id` (`pages_categories_id`),
  KEY `idx_mfg_id` (`manufacturers_id`),
  KEY `idx_link_cat_id` (`link_categories_id`),
  KEY `idx_links_id` (`links_id`),
  KEY `idx_faq_cat_id` (`faq_categories_id`),
  KEY `idx_perm_name` (`permalink_name`),
  KEY `idx_perm_type` (`permalink_type`),
  KEY `idx_cat_web` (`categories_id`,`language_id`),
  KEY `idx_prod_web` (`products_id`,`language_id`),
  KEY `idx_page_web` (`pages_id`,`language_id`),
  KEY `idx_pagecat_web` (`pages_categories_id`,`language_id`),
  KEY `idx_manuf_web` (`manufacturers_id`,`language_id`),
  KEY `idx_testimonial_web` (`testimonial_cat_id`,`language_id`),
  KEY `idx_linkcat_web` (`link_categories_id`,`language_id`),
  KEY `idx_link_web` (`links_id`,`language_id`),
  KEY `idx_faq_web` (`faq_categories_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `products`
--

CREATE TABLE `products` (
  `products_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_quantity` int(4) NOT NULL DEFAULT '0',
  `products_model` varchar(100) DEFAULT NULL,
  `products_image` varchar(255) DEFAULT NULL,
  `products_image_med` varchar(255) DEFAULT NULL,
  `products_image_lrg` varchar(255) DEFAULT NULL,
  `products_image_sm_1` varchar(255) DEFAULT NULL,
  `products_image_xl_1` varchar(255) DEFAULT NULL,
  `products_image_sm_2` varchar(255) DEFAULT NULL,
  `products_image_xl_2` varchar(255) DEFAULT NULL,
  `products_image_sm_3` varchar(255) DEFAULT NULL,
  `products_image_xl_3` varchar(255) DEFAULT NULL,
  `products_image_sm_4` varchar(255) DEFAULT NULL,
  `products_image_xl_4` varchar(255) DEFAULT NULL,
  `products_image_sm_5` varchar(255) DEFAULT NULL,
  `products_image_xl_5` varchar(255) DEFAULT NULL,
  `products_image_sm_6` varchar(255) DEFAULT NULL,
  `products_image_xl_6` varchar(255) DEFAULT NULL,
  `products_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_map` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `products_last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `products_date_available` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `products_weight` decimal(5,2) NOT NULL DEFAULT '0.00',
  `products_status` tinyint(1) NOT NULL DEFAULT '0',
  `products_tax_class_id` int(11) NOT NULL DEFAULT '0',
  `manufacturers_id` int(11) DEFAULT NULL,
  `products_ordered` int(11) NOT NULL DEFAULT '0',
  `products_parent_id` int(11) NOT NULL DEFAULT '0',
  `products_price1` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_price2` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_price3` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_price4` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_price5` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_price6` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_price7` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_price8` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_price9` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_price10` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_price11` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_price1_qty` int(11) NOT NULL DEFAULT '0',
  `products_price2_qty` int(11) NOT NULL DEFAULT '0',
  `products_price3_qty` int(11) NOT NULL DEFAULT '0',
  `products_price4_qty` int(11) NOT NULL DEFAULT '0',
  `products_price5_qty` int(11) NOT NULL DEFAULT '0',
  `products_price6_qty` int(11) NOT NULL DEFAULT '0',
  `products_price7_qty` int(11) NOT NULL DEFAULT '0',
  `products_price8_qty` int(11) NOT NULL DEFAULT '0',
  `products_price9_qty` int(11) NOT NULL DEFAULT '0',
  `products_price10_qty` int(11) NOT NULL DEFAULT '0',
  `products_price11_qty` int(11) NOT NULL DEFAULT '0',
  `products_qty_blocks` int(11) NOT NULL DEFAULT '1',
  `products_sku` varchar(255) DEFAULT NULL,
  `products_cost` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_msrp` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `featured_expires` datetime DEFAULT NULL,
  `featured_sort` int(11) NOT NULL DEFAULT '0',
  `products_group_access` varchar(50) NOT NULL DEFAULT 'G,0',
  `products_nav_access` varchar(255) NOT NULL DEFAULT 'G,0',
  `vendors_id` int(11) DEFAULT '1',
  `vendors_product_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `vendors_prod_id` varchar(24) NOT NULL DEFAULT '',
  `vendors_prod_comments` text,
  `products_qty_days` int(11) NOT NULL DEFAULT '0',
  `products_qty_years` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`products_id`),
  KEY `idx_products_date_added` (`products_date_added`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=54 ;

--
-- Dumping data for table `products`
--

INSERT INTO `products` VALUES
(1, 100, '', '3.jpg', '3.jpg', 'hhf.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 250.0000, 0.0000, '[[regtime]]', '2016-07-16 07:09:40', '2018-09-25 00:00:00', 0.00, 1, 0, 12, 0, 0, 250.0000, 250.0000, 250.0000, 250.0000, 250.0000, 250.0000, 250.0000, 250.0000, 250.0000, 250.0000, 250.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 0.0000, 0.0000, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(2, 100, '', '15-330x330.jpg', '15-330x330.jpg', 'lgg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 200.0000, 0.0000, '[[regtime]]', '2016-07-16 07:08:20', '2018-09-25 00:00:00', 0.00, 1, 0, 12, 0, 0, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 0.0000, 0.0000, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(3, 100, '', 'nikkon2md.jpg', 'nikkon2sm.jpg', 'nikkon2lg.jpg', NULL, 'large2.jpg', NULL, 'cam11large.jpg', NULL, 'nikkon3lg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, 498.0000, 0.0000, '[[regtime]]', '2016-07-13 05:51:23', '2018-09-25 00:00:00', 0.00, 1, 0, 11, 0, 0, 498.0000, 498.0000, 498.0000, 498.0000, 498.0000, 498.0000, 498.0000, 498.0000, 498.0000, 498.0000, 498.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 356.0000, 387.0000, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(4, 500, '', 'cam1Small.jpg', 'cam1mid.jpg', 'cam1large.jpg', NULL, 'cam1large2.jpg', NULL, 'cam111large.jpg', NULL, 'cam11large.jpg', NULL, NULL, NULL, NULL, NULL, NULL, 200.0000, 0.0000, '[[regtime]]', '2016-07-13 06:41:17', '2018-09-25 00:00:00', 0.00, 1, 0, 9, 0, 0, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 0.0000, 0.0000, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(5, 99, '', 'f7.jpg', 'hol.jpg', 'lagcase.jpg', 'hol.jpg', 'lagcase.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 25.0000, 0.0000, '[[regtime]]', '2016-07-16 06:52:53', '2018-09-25 00:00:00', 0.00, 1, 0, 10, 1, 0, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 0.0000, 0.0000, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(6, 0, '', '8-330x330.jpg', 'headgo.jpg', 'headlg.jpg', 'headgo.jpg', 'headlg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 35.0000, 0.0000, '[[regtime]]', '2016-07-16 06:57:56', '2018-09-25 00:00:00', 0.00, 1, 0, 12, 0, 0, 35.0000, 35.0000, 35.0000, 35.0000, 35.0000, 35.0000, 35.0000, 35.0000, 35.0000, 35.0000, 35.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 0.0000, 0.0000, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(7, 100, '', 'nikkon3sm.jpg', 'nikkon3mid.jpg', 'nikkon3lg.jpg', NULL, 'cam1large.jpg', NULL, 'cam1large2.jpg', NULL, 'cam111large.jpg', NULL, 'cam11large.jpg', NULL, 'nikkon2lg.jpg', NULL, NULL, 200.0000, 0.0000, '[[regtime]]', '2016-07-13 05:41:06', '2018-09-25 00:00:00', 0.00, 1, 0, 11, 0, 0, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 0.0000, 0.0000, 0, 0, NULL, 0, '0,G', '', 0, 0.0000, '', '', 0, 0),
(8, 25, '', 'f8.jpg', 'headfdd.jpg', 'headfdd.jpg', 'headfon.jpg', 'headfdd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 36.0000, 0.0000, '[[regtime]]', '2016-07-16 06:57:12', '2018-09-25 00:00:00', 0.00, 1, 0, 4, 0, 0, 36.0000, 36.0000, 36.0000, 36.0000, 36.0000, 36.0000, 36.0000, 36.0000, 36.0000, 36.0000, 36.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 0.0000, 0.0000, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(9, 0, '100', 'nikkon3sm.jpg', 'nikkon3mid.jpg', 'nikkon3lg.jpg', 'cam1sm.jpeg', 'cam1large.jpg', 'nikkon2sm.jpg', 'nikkon2lg.jpg', 'nikkon3sm.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 200.0000, 0.0000, '[[regtime]]', '2016-07-16 07:06:09', '2016-07-11 00:00:00', 0.00, 1, 0, 0, 0, 0, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 0.0000, 0.0000, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(12, -2, '100', 'asusSm.jpg', 'asusMd.jpg', 'asusLg.jpg', 'asusoriginal2.jpeg', 'asuslarge21.jpg', 'asusoriginal1.jpeg', 'asuslarge22.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 400.0000, 0.0000, '[[regtime]]', '2016-07-13 06:16:43', '2016-07-11 00:00:00', 0.00, 1, 0, 10, 2, 0, 400.0000, 400.0000, 400.0000, 400.0000, 400.0000, 400.0000, 400.0000, 400.0000, 400.0000, 400.0000, 400.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 0.0000, 0.0000, 10, 0, NULL, 0, '0,G', '', 0, 0.0000, '', '', 0, 0),
(16, 100, '', 'samSM.jpg', 'samMD.jpg', 'samLG.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 250.0000, 0.0000, '[[regtime]]', '2016-07-13 06:12:25', '2016-07-11 00:00:00', 0.00, 1, 0, 17, 0, 0, 250.0000, 250.0000, 250.0000, 250.0000, 250.0000, 250.0000, 250.0000, 250.0000, 250.0000, 250.0000, 250.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 0.0000, 0.0000, 10, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(14, 100, '', 'intel_cloud-sml.jpg', 'lggj.jpg', 'gontt.jpg', 'intel_cloud-sml.jpg', 'intel_cloud-lrg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 300.0000, 0.0000, '[[regtime]]', '2016-07-16 07:16:48', '2016-07-11 00:00:00', 0.00, 1, 0, 19, 0, 0, 300.0000, 300.0000, 300.0000, 300.0000, 300.0000, 300.0000, 300.0000, 300.0000, 300.0000, 300.0000, 300.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 0.0000, 0.0000, 20, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(15, 100, '', 'motoSM1.jpg', 'motoMD1.jpg', 'motoLG1.jpg', NULL, 'motoLG1.jpg', NULL, 'motoLG2.jpg', NULL, 'lll.jpg', NULL, 'llll.jpg', NULL, NULL, NULL, NULL, 200.0000, 0.0000, '[[regtime]]', '2016-07-13 06:29:16', '2016-07-11 00:00:00', 0.00, 1, 0, 18, 0, 0, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 0.0000, 0.0000, 40, 0, NULL, 0, '0,G', '', 0, 0.0000, '', '', 0, 0),
(17, 100, '', 'xiaomi-4i-sml.jpg', 'xiaomi-4i-mdm.jpg', 'xiaomi-4i-lrg.JPG', 'xiaomi-4i-sml.jpg', 'xiaomi-4i-lrg.JPG', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 200.0000, 0.0000, '[[regtime]]', '2016-07-15 03:23:36', '2016-07-11 00:00:00', 0.00, 1, 0, 0, 0, 0, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 0.0000, 0.0000, 50, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(18, 0, '100', 'Sony-ericn-sml.jpg', 'Sony-ericn-mdm.jpg', 'Sony-ericn-lrg.JPG', 'Sony-ericn-sml.jpg', 'Sony-ericn-lrg.JPG', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 200.0000, 0.0000, '[[regtime]]', '2016-07-15 03:13:03', '2016-07-11 00:00:00', 0.00, 1, 0, 12, 0, 0, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 0.0000, 0.0000, 30, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(44, 340, '', 'hp-laptops-sml.jpg', 'hp-laptops-mdm.jpg', 'hp-laptops-lrg.jpeg', 'hp-laptops-sml.jpg', 'hp-laptops-lrg.jpeg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 498.9000, 0.0000, '[[regtime]]', '2016-07-14 10:14:11', '2016-07-12 00:00:00', 0.00, 1, 0, 0, 0, 0, 498.9000, 498.9000, 498.9000, 498.9000, 498.9000, 498.9000, 498.9000, 498.9000, 498.9000, 498.9000, 498.9000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 279.0000, 305.1380, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(20, 100, '', 'fetr4.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 365.0000, 0.0000, '[[regtime]]', '2016-07-13 10:44:41', '2016-07-11 00:00:00', 0.00, 1, 0, 12, 0, 0, 365.0000, 365.0000, 365.0000, 365.0000, 365.0000, 365.0000, 365.0000, 365.0000, 365.0000, 365.0000, 365.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 0.0000, 0.0000, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(21, -1, '', 'asus1.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 320.0000, 0.0000, '[[regtime]]', '2016-07-13 09:55:49', '2016-07-11 00:00:00', 0.00, 1, 0, 10, 1, 0, 320.0000, 320.0000, 320.0000, 320.0000, 320.0000, 320.0000, 320.0000, 320.0000, 320.0000, 320.0000, 320.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 0.0000, 650.0000, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(45, 200, '', 'micromax-laptops-sml.jpg', 'micromax-laptops-mdm.jpg', 'micromax-laptops-lrg.jpeg', 'micromax-laptops-sml.jpg', 'micromax-laptops-lrg.jpeg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 200.0000, 0.0000, '[[regtime]]', '2016-07-16 07:11:36', '2016-07-12 00:00:00', 0.00, 1, 0, 0, 0, 0, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 200.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 170.0000, 186.1300, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(23, 100, '', 'adidas-sml.jpg', 'adidas-mdm.jpg', 'adidas-lrg.jpeg', 'adidas-sml.jpg', 'adidas-lrg.jpeg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5.0000, 0.0000, '[[regtime]]', '2016-07-18 08:42:43', '2016-07-12 00:00:00', 0.00, 1, 0, 0, 0, 0, 5.0000, 5.0000, 5.0000, 5.0000, 5.0000, 5.0000, 5.0000, 5.0000, 5.0000, 5.0000, 5.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 4.4500, 5.0000, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(24, 250, '', 'bldlg.jpg', 'bldlg.jpg', 'bldlg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1.0000, 0.0000, '[[regtime]]', '2016-07-16 07:26:04', '2016-07-12 00:00:00', 0.00, 1, 0, 0, 0, 0, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 0.7100, 1.1200, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(25, 450, '', 'cream.jpg', 'cream.jpg', 'cream.jpg', 'cream.jpg', 'cream.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 25.0000, 0.0000, '[[regtime]]', '2016-07-16 07:28:45', '2016-07-12 00:00:00', 0.00, 1, 0, 0, 0, 0, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 0.0000, 0.0000, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(26, 350, '', 'download-pu-adi-shower-Gel.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2.5000, 0.0000, '[[regtime]]', '2016-07-16 07:29:48', '2016-07-12 00:00:00', 0.00, 0, 0, 0, 0, 0, 2.5000, 2.5000, 2.5000, 2.5000, 2.5000, 2.5000, 2.5000, 2.5000, 2.5000, 2.5000, 2.5000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 2.1200, 2.2200, 0, 0, NULL, 0, '0,G,1', 'G,0', 0, 0.0000, '', '', 0, 0),
(27, 280, '', 'download-VLCC Insta Glow Facial Kit.jpg', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 8.0000, 0.0000, '[[regtime]]', '2016-07-16 07:29:44', '2016-07-12 00:00:00', 0.00, 0, 0, 0, 0, 0, 8.0000, 8.0000, 8.0000, 8.0000, 8.0000, 8.0000, 8.0000, 8.0000, 8.0000, 8.0000, 8.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 8.0000, 8.3250, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(28, 269, '', 'BCrepair-sml.jpg', 'BCrepair-mdm.jpg', 'BCrepair-lrg.jpeg', 'BCrepair-sml.jpg', 'BCrepair-lrg.jpeg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 9.5000, 0.0000, '[[regtime]]', '2016-07-15 05:21:25', '2016-07-12 00:00:00', 0.00, 1, 0, 0, 1, 0, 9.5000, 9.5000, 9.5000, 9.5000, 9.5000, 9.5000, 9.5000, 9.5000, 9.5000, 9.5000, 9.5000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 9.0000, 9.3800, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(29, 340, '', 'lakmesunexpt-sml.jpg', 'lakmesunexpt-mdm.jpg', 'lakmesunexpt-lrg.jpg', 'lakmesunexpt-sml.jpg', 'lakmesunexpt-lrg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 5.7500, 0.0000, '[[regtime]]', '2016-07-18 09:45:51', '2016-07-12 00:00:00', 0.00, 1, 0, 0, 0, 0, 5.7500, 5.7500, 5.7500, 5.7500, 5.7500, 5.7500, 5.7500, 5.7500, 5.7500, 5.7500, 5.7500, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 5.0000, 5.6000, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(30, 240, '', 'lakme-sml.jpg', 'lakme-mdm.jpg', 'lakme-lrg.jpeg', 'lakme-sml.jpg', 'lakme-lrg.jpeg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 4.1800, 0.0000, '[[regtime]]', '2016-07-18 09:14:23', '2016-07-12 00:00:00', 0.00, 1, 0, 0, 0, 0, 4.1800, 4.1800, 4.1800, 4.1800, 4.1800, 4.1800, 4.1800, 4.1800, 4.1800, 4.1800, 4.1800, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 4.1500, 4.1700, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(31, 435, '', 'WhiteMakeup-sml.jpg', 'WhiteMakeup-mdm.jpg', 'WhiteMakeup-lrg.jpeg', 'WhiteMakeup-sml.jpg', 'WhiteMakeup-lrg.jpeg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 27.0000, 0.0000, '[[regtime]]', '2016-07-18 10:17:15', '2016-07-12 00:00:00', 0.00, 1, 0, 0, 0, 0, 27.0000, 27.0000, 27.0000, 27.0000, 27.0000, 27.0000, 27.0000, 27.0000, 27.0000, 27.0000, 27.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 24.5000, 25.3100, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(32, 0, '128', 'Makeupkit-sml.jpg', 'Makeupkit-mdm.jpg', 'Makeupkit-lrg.jpeg', 'Makeupkit-sml.jpg', 'Makeupkit-lrg.jpeg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2.8500, 0.0000, '[[regtime]]', '2016-07-18 09:57:34', '2016-07-12 00:00:00', 0.00, 1, 0, 0, 0, 0, 2.8500, 2.8500, 2.8500, 2.8500, 2.8500, 2.8500, 2.8500, 2.8500, 2.8500, 2.8500, 2.8500, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 2.5000, 2.7500, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(33, 270, '', 'lakpinkpwd-sml.jpg', 'lakpinkpwd-mdm.jpg', 'lakpinkpwd-lrg.jpg', 'lakpinkpwd-sml.jpg', 'lakpinkpwd-lrg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2.5000, 0.0000, '[[regtime]]', '2016-07-18 09:26:36', '2016-07-12 00:00:00', 0.00, 1, 0, 0, 0, 0, 2.5000, 2.5000, 2.5000, 2.5000, 2.5000, 2.5000, 2.5000, 2.5000, 2.5000, 2.5000, 2.5000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 1.5000, 1.6800, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(34, 346, '', 'MUA-wvblsh-sml.jpg', 'MUA-wvblsh-mdm.jpg', 'MUA-wvblsh-lrg.jpg', 'MUA-wvblsh-sml.jpg', 'MUA-wvblsh-lrg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 11.0000, 0.0000, '[[regtime]]', '2016-07-18 10:03:15', '2016-07-12 00:00:00', 0.00, 1, 0, 0, 0, 0, 11.0000, 11.0000, 11.0000, 11.0000, 11.0000, 11.0000, 11.0000, 11.0000, 11.0000, 11.0000, 11.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 10.0000, 10.3500, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(35, 180, '', 'mameup-brushes-sml.jpg', 'mameup-brushes-mdm.jpg', 'mameup-brushes-lrg.jpg', 'mameup-brushes-sml.jpg', 'mameup-brushes-lrg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1.5000, 0.0000, '[[regtime]]', '2016-07-18 10:09:53', '2016-07-12 00:00:00', 0.00, 1, 0, 0, 0, 0, 1.5000, 1.5000, 1.5000, 1.5000, 1.5000, 1.5000, 1.5000, 1.5000, 1.5000, 1.5000, 1.5000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 1.0000, 1.1200, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(36, 450, '', 'jmd-desk-sml.jpg', 'jmd-desk-mdm.jpg', 'jmd-desk-lrg.jpeg', 'jmd-desk-sml.jpg', 'hp-laptops-lrg.jpeg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 12.0000, 0.0000, '[[regtime]]', '2016-07-14 10:42:09', '2016-07-12 00:00:00', 0.00, 1, 0, 0, 0, 0, 12.0000, 12.0000, 12.0000, 12.0000, 12.0000, 12.0000, 12.0000, 12.0000, 12.0000, 12.0000, 12.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 11.8000, 11.8400, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(37, 280, '', 'tabsm.jpg', 'tabmid.jpg', 'tablr.jpeg', 'tabsm.jpg', 'tablr.jpeg', 'tab2smm.jpg', 'table2lg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 120.0000, 0.0000, '[[regtime]]', '2016-07-16 06:32:49', '2016-07-12 00:00:00', 0.00, 1, 0, 0, 0, 0, 120.0000, 120.0000, 120.0000, 120.0000, 120.0000, 120.0000, 120.0000, 120.0000, 120.0000, 120.0000, 120.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 120.0000, 120.0000, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(38, 237, '', 'creative-speakr-sml.jpg', 'creative-speakr-mdm.jpg', 'creative-speakr-lrg.jpeg', 'creative-speakr-sml.jpg', 'creative-speakr-lrg.jpeg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 12.5000, 0.0000, '[[regtime]]', '2016-07-14 10:33:25', '2016-07-12 00:00:00', 0.00, 1, 0, 0, 3, 0, 12.5000, 12.5000, 12.5000, 12.5000, 12.5000, 12.5000, 12.5000, 12.5000, 12.5000, 12.5000, 12.5000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 12.0000, 12.2900, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(39, 345, '', '31ZVVuLltQL-sml.jpg', '31ZVVuLltQL-mdm.jpg', '31ZVVuLltQL-lrg.jpg', '31ZVVuLltQL-sml.jpg', '31ZVVuLltQL-lrg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 3.7000, 0.0000, '[[regtime]]', '2016-07-18 08:24:54', '2016-07-12 00:00:00', 0.00, 1, 0, 0, 0, 0, 3.7000, 3.7000, 3.7000, 3.7000, 3.7000, 3.7000, 3.7000, 3.7000, 3.7000, 3.7000, 3.7000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 3.0000, 3.2600, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(40, 100, '', '71aVqmPOh-L._SL1000_1.jpg', NULL, 'gh.jpg', 'gh.jpg', 'gh.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 345.0000, 0.0000, '[[regtime]]', '2016-07-16 06:36:55', '2016-07-12 00:00:00', 0.00, 1, 0, 0, 0, 0, 345.0000, 345.0000, 345.0000, 345.0000, 345.0000, 345.0000, 345.0000, 345.0000, 345.0000, 345.0000, 345.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 1000.0000, 999.0000, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(41, 250, '', '41Aw2Ke9tpL._AC_UL320_SR238,320_.jpg', 'coverlg.jpg', 'coverlg.jpg', 'dff.jpg', 'coverlg.jpg', 'dff.jpg', 'coverlg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 25.0000, 0.0000, '[[regtime]]', '2016-07-16 06:56:14', '2016-07-12 00:00:00', 0.00, 1, 0, 0, 0, 0, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 0.0000, 0.0000, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(42, 350, '', 'holdersm.jpg', 'holdermid.jpg', 'holderlarger.jpg', 'holdersm.jpg', 'holderlarger.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 25.0000, 0.0000, '[[regtime]]', '2016-07-16 06:50:48', '2016-07-12 00:00:00', 0.00, 1, 0, 0, 0, 0, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 25.0000, 25.0000, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(43, 370, '', 'asus-sml.jpg', 'asus-mdm.jpg', 'asus-lrg.jpg', 'asus-sml.jpg', 'asus-lrg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 458.9000, 0.0000, '[[regtime]]', '2016-07-14 08:30:33', '2016-07-12 00:00:00', 0.00, 1, 0, 10, 0, 0, 458.9000, 458.9000, 458.9000, 458.9000, 458.9000, 458.9000, 458.9000, 458.9000, 458.9000, 458.9000, 458.9000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 358.0000, 379.5900, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(46, 299, '', 'Dell-laptp-sml.jpg', 'Dell-laptp-mdm.jpg', 'Dell-laptp-lrg.jpg', 'Dell-laptp-sml.jpg', 'Dell-laptp-lrg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 317.0000, 0.0000, '[[regtime]]', '2016-07-14 10:03:29', '2016-07-13 00:00:00', 0.00, 1, 0, 0, 1, 0, 317.0000, 317.0000, 317.0000, 317.0000, 317.0000, 317.0000, 317.0000, 317.0000, 317.0000, 317.0000, 317.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 300.0000, 316.3960, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(47, 350, '', 'Apple-pro-sml.jpg', 'Apple-pro-mdm.jpg', 'Apple-pro-lrg.jpeg', 'Apple-pro-sml.jpg', 'Apple-pro-lrg.jpeg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 870.0000, 0.0000, '[[regtime]]', '2016-07-14 09:43:21', '2016-07-13 00:00:00', 0.00, 1, 0, 14, 0, 0, 870.0000, 870.0000, 870.0000, 870.0000, 870.0000, 870.0000, 870.0000, 870.0000, 870.0000, 870.0000, 870.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 860.0000, 862.9800, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(48, 348, '', 'Apple-mac-book-sml-lrg.jpg', 'Apple-mac-book-mdm-lrg.jpg', 'Apple-mac-book-lrg.jpeg', 'Apple-mac-book-sml-lrg.jpg', 'Apple-mac-book-lrg.jpeg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 879.0000, 0.0000, '[[regtime]]', '2016-07-14 09:44:51', '2016-07-13 00:00:00', 0.00, 1, 0, 14, 2, 0, 879.0000, 879.0000, 879.0000, 879.0000, 879.0000, 879.0000, 879.0000, 879.0000, 879.0000, 879.0000, 879.0000, 10, 20, 30, 40, 50, 60, 60, 60, 60, 60, 60, 1, '', 865.0000, 875.5000, 0, 0, NULL, 0, '0,G,1', '', 0, 0.0000, '', '', 0, 0),
(49, 300, '', 'extra.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 65.0000, 0.0000, '[[regtime]]', '2016-07-13 06:41:17', '2016-07-11 00:00:00', 0.00, 0, 0, 9, 0, 4, 65.0000, 65.0000, 65.0000, 65.0000, 65.0000, 65.0000, 65.0000, 65.0000, 65.0000, 65.0000, 65.0000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, '', 0.0000, 0.0000, 0, 0, NULL, 0, 'G,0', 'G,0', 1, 0.0000, '', NULL, 0, 0),
(50, 200, '', 'extra1.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 62.0000, 0.0000, '[[regtime]]', '2016-07-13 06:41:17', '2016-07-11 00:00:00', 0.00, 0, 0, 9, 0, 4, 62.0000, 62.0000, 62.0000, 62.0000, 62.0000, 62.0000, 62.0000, 62.0000, 62.0000, 62.0000, 62.0000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, '', 0.0000, 0.0000, 0, 0, NULL, 0, 'G,0', 'G,0', 1, 0.0000, '', NULL, 0, 0),
(51, 20, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 20.0000, 0.0000, '[[regtime]]', '0000-00-00 00:00:00', '2016-07-11 00:00:00', 0.00, 0, 0, 18, 0, 15, 20.0000, 20.0000, 20.0000, 20.0000, 20.0000, 20.0000, 20.0000, 20.0000, 20.0000, 20.0000, 20.0000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, '', 0.0000, 0.0000, 0, 0, NULL, 0, 'G,0', 'G,0', 1, 0.0000, '', NULL, 0, 0),
(52, 100, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 12.0000, 0.0000, '[[regtime]]', '0000-00-00 00:00:00', '2016-07-11 00:00:00', 0.00, 0, 0, 18, 0, 15, 12.0000, 12.0000, 12.0000, 12.0000, 12.0000, 12.0000, 12.0000, 12.0000, 12.0000, 12.0000, 12.0000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, '', 0.0000, 0.0000, 0, 0, NULL, 0, 'G,0', 'G,0', 1, 0.0000, '', NULL, 0, 0),
(53, 100, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 25.0000, 0.0000, '[[regtime]]', '0000-00-00 00:00:00', '2016-07-11 00:00:00', 0.00, 0, 0, 18, 0, 15, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 25.0000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, '', 0.0000, 0.0000, 0, 0, NULL, 0, 'G,0', 'G,0', 1, 0.0000, '', NULL, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `products_attributes`
--

CREATE TABLE `products_attributes` (
  `products_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL DEFAULT '0',
  `options_id` int(11) NOT NULL DEFAULT '0',
  `options_values_id` int(11) NOT NULL DEFAULT '0',
  `options_values_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `price_prefix` char(1) NOT NULL DEFAULT '',
  `options_default` tinyint(4) NOT NULL DEFAULT '0',
  `products_options_sort_order` smallint(3) unsigned NOT NULL DEFAULT '9999',
  `main_options_sorting` smallint(3) unsigned NOT NULL DEFAULT '9999',
  PRIMARY KEY (`products_attributes_id`),
  KEY `idx_products_id` (`products_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `products_attributes`
--

INSERT INTO `products_attributes` VALUES
(1, 12, 1, 1, 10.0000, '+', 0, 0, 9999),
(2, 12, 1, 2, 20.0000, '+', 0, 0, 9999),
(3, 12, 1, 3, 30.0000, '+', 0, 0, 9999),
(4, 12, 2, 6, 10.0000, '+', 0, 0, 9999),
(5, 12, 2, 4, 20.0000, '+', 0, 0, 9999),
(6, 12, 2, 5, 30.0000, '+', 0, 0, 9999);

-- --------------------------------------------------------

--
-- Table structure for table `products_attributes_download`
--

CREATE TABLE `products_attributes_download` (
  `products_attributes_id` int(11) NOT NULL DEFAULT '0',
  `products_attributes_filename` varchar(255) NOT NULL DEFAULT '',
  `products_attributes_maxdays` int(2) DEFAULT '0',
  `products_attributes_maxcount` int(2) DEFAULT '0',
  PRIMARY KEY (`products_attributes_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `products_description`
--

CREATE TABLE `products_description` (
  `products_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_name` varchar(255) NOT NULL DEFAULT '',
  `products_blurb` text,
  `products_description` text,
  `products_url` varchar(255) DEFAULT NULL,
  `products_viewed` int(5) DEFAULT '0',
  `products_head_title_tag` varchar(80) DEFAULT NULL,
  `products_head_desc_tag` longtext NOT NULL,
  `products_head_keywords_tag` longtext NOT NULL,
  `permalink_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`products_id`,`language_id`),
  KEY `products_name` (`products_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=54 ;

--
-- Dumping data for table `products_description`
--

INSERT INTO `products_description` VALUES
(1, 1, 'Sony shot', '', '<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Specifications of Sony Cyber-shot DSC-W830/VC Point &amp; Shoot Camera (Violet)</h3>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				SHUTTER SPEED</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Shutter Speed in other Modes</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				iAuto: 2 inch - 1/1, 600, Program Auto (1 inch - 1/1, 600)</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				PIXELS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Total Pixel/Gross Pixel</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				20.5</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Optical Sensor Resolution (in MegaPixel)</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				20.1 MP</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				LENS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Lens Type</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Vario-Tessar</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Auto Focus</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focus Mode</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Multi-point AF, Center Weighted AF, Spot AF, Flexible Spot AF (Tracking Focus and Face Tracking Focus)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				other Lens Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				F Number: F3.3 (W) - F6.3 (T), Focal Lenght (35 mm Conversion): 28 - 224 mm Still Image (16:9), 25 - 200 mm Still Image (4:3), 28 - 224 mm (SteadyShot Standrad), 28 - 314 mm (SteadyShot Active) Movie (16:9), 34 - 272 mm (SteadyShot Standrad), 34 - 381 mm (SteadyShot Active) Movie (4:3)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focal Length</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				4.5 - 36 mm</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Lens Construction</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				8 Elements, 7 Groups (5 Aspheric Elements)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Other Focus Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Auto Focus Illuminator: Auto / Off, Face Detectin Mode: Auto / Off, Face Detection: Maximum 8 Faces</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focus Range</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				iAuto and Program Auto: 5 cm (W) - 150 cm (T)</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				ZOOM</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Optical Zoom</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				8</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focus</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Auto</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Digital Zoom</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				32x</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				DIMENSION</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Weight</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				104 g</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Dimensions</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				93.1 (W) x 52.5 (H) x 22.5 (D)</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				WARRANTY</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Warranty Summary</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				2 Years Sony India Warranty and Free Transit Insurance.</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				LCD</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				LCD Display</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				ClearPhoto TFT LCD</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				LCD Screen Size</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				2.7 inch</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Other Display Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Playback (Slide Show): SD Video Out, Movie, Simple, Nostalgic, Stylish, Active (Effects), 4 Slde Show Music Tunes, Automatic Image Rotation, 3D Viewing Mode</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Image Display Resolution</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				230,400 dots</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Exposure Compensation</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				1/3 EV Steps +/- 2.0 EV</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Supported Aspect Ratio</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				4:3, 16:9<br />\r\n				&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '', 6, '', '', '', ''),
(2, 1, 'Sony Cyber Shot', '', '', '', 14, '', '', '', '');
INSERT INTO `products_description` VALUES
(3, 1, 'Nikon D3200 24-2 MP Digital SLR Camera(Black)', '', '<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Key Features of Canon EOS 1200D (Kit with 8 GB Card &amp; Bag EF S18-55 IS II+55-250mm IS II) DSLR Camera</h3>\r\n<ul class="keyFeaturesList" style="margin: 0px; padding: 0px 0px 0px 20px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		18 Megapixel Camera</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		Full HD Recording</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		CMOS Image Sensor</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		3 inch TFT LCD Screen</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		ISO 100 - 6400</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		f/3.5 - f/5.6</li>\r\n</ul>\r\n<p style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n	&nbsp;</p>\r\n<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Specifications of Canon EOS 1200D (Kit with 8 GB Card &amp; Bag EF S18-55 IS II+55-250mm IS II) DSLR Camera (Black)</h3>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				SHUTTER SPEED</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Maximum Shutter Speed</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				1/4000 sec</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Shutter Type</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Electronically-controlled, Focal-plane Shutter</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Minimum Shutter Speed</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				30 sec</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Shutter Speed in other Modes</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Bulb, X-sync at 1/200 sec</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				PIXELS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Optical Sensor Resolution (in MegaPixel)</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				18 MP</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Other Resolution</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				<div class="dummy-content" style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n					Recording Size and Frame Rate (Full HD 1920 x 1080 at (30 fps, 25 fps, 24 fps), HD 1280 x 720 at (60 fps, 50 fps), SD 640 x 480 at (30 fps, 25 fps), File size), File Size (1920 x 1080 at (30 fps, 25 fps, 24 fps) 330 MB/min, 1280 x 720 at (60 fps, 50 fps) 330 MB/min, 640 x 480 at (30 fps, 25 fps) 82....<a style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline; color: rgb(102, 102, 102); cursor: pointer;">View More</a></div>\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				LENS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Lens Type</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Canon EF Mount</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focus Mode</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				One Shot AF, AI Servo AF, AI Focus AF</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Auto Focus</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				other Lens Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Lens Peripheral Illumination Correction, Single Lens Reflex,</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focus Points</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				9 Points (Cross Type AF Sensitive to f/5.6 with Center AF Point)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Manual Focus</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focusing Screen</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Fixed, Precision Matte</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Other Focus Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				<div class="dummy-content" style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n					AF Operation: One-shot AF, AI Servo AF, AI Focus AF, AF Assist Beam: Small Series of Flashes Fired by Built-in Flash, Focusing Methods: Contrast Detection (FlexiZone Single, Face Detection Live Mode), Phase-difference Detection (Quick Mode), Manual Focus (5x / 10x Magnification Possible), Zoom Magni...<a style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline; color: rgb(102, 102, 102); cursor: pointer;">View More</a></div>\r\n			</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focus Range</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Focusing Brightness Range (EV 0 - 18 (Center AF Point), EV 1 - 18 (other AF Points) with One-shot AF at Room Temperature, ISO 100), Brightness Metering Range: EV 1 - 20 (at Room Temperature, ISO 100)</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				ZOOM</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focus</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Auto / Manual</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focusing Sysetm</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Auto Focus, Manual Focus</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				DIMENSION</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Weight without Battery</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				435 g</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Weight</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				480 g</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Dimensions</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				5.10 (W) x 3.93 (H) x 3.07 (D) inch</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				WARRANTY</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Warranty Summary</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				2 Years Canon India Warranty and Free Transit Insurance.</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				LCD</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Viewpoint Dioptric Adjustment</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				-2.5 to +0.5 m-1</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				LCD Screen Size</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				3 inch</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Image Display Resolution</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				460,000 dots</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Manual Exposure</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Other Viewfinder Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Focusing Screen: Fixed, Precision Matte, Viewfinder Mirror: Quick-return Type, Depth of Field Preview: Enabled with Custom Function Setting</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Viewfinder Type</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Eye-level Pentamirror</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Supported Aspect Ratio</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				3:2, 4:3, 16:9, 1:1</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Other Exposure Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Exposure Control: Program AE (Scene Intelligent Auto, Flash Off, Creative Auto, Portrait, Landscape, Close-up, Sports, Night Portrait, Program), Shutter-priority AE, Aperture-priority AE, Auto Exposure</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Brightness Adjustment</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				7 Level Manual Adjustment</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Viewfinder Magnification</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				0.8x (-1 m-1 with 50 mm Lens at Infinity)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				LCD Display</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				TFT LCD</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Video Display Resolution</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				1920 x 1080</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Viewfinder Eye Point</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				21</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Other Display Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				<div class="dummy-content" style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n					Feature Guide Displayable, Two Grid Display, Playback (Image Display Formats: Basic Info, Basic Info + Image Quality / Playback Number, Shooting Info, Display, Histogram, Image Index (4 / 9)), Slide Show: All Images, Date, Folder, Movies, Stills, Rating, Five Transition Effects Selectable, Backgroun...<a style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline; color: rgb(102, 102, 102); cursor: pointer;">View More</a></div>\r\n			</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Exposure Compensation</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				1/3 or 1/2 Stop Increments +/- 5 EV (Manual), 1/3 or 1/2 Stop Increments +/- 2 (AEB), 1/3 Stop Increments +/- 3 Stops Increments (+/- Stops Still Photos)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				View Magnification</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				0.8x (-1m-1 with 50mm Lens at Infinity)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Viewfinder Coverage</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Vertical / Horizontal 95% (with Eye Point 21 mm)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				AE Lock/Exposure Lock</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, Applied in One-shot AF with Evaluative Metering when Focus is Achieved (Auto), AE Lock Button (Manual)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Viewfinder</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				ViewFinder</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes<br />\r\n				&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '', 34, '', '', '', '');
INSERT INTO `products_description` VALUES
(4, 1, 'Canon PowerShot', '', '<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Key Features of Sony Cyber-shot DSC-H300 Point &amp; Shoot Camera</h3>\r\n<ul class="keyFeaturesList" style="margin: 0px; padding: 0px 0px 0px 20px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		35 mm Equivalent Focal Length: 25 - 875 mm</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		HD Recording</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		3 inch Clear Photo / TFT LCD Display</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		f/3.0 - f/5.9 Aperture</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		Super HAD CCD Image Sensor</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		20.1 Megapixel Camera</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		35x Optical Zoom</li>\r\n</ul>\r\n<p style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n	&nbsp;</p>\r\n<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Specifications of Sony Cyber-shot DSC-H300 Point &amp; Shoot Camera (Black)</h3>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				SHUTTER SPEED</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Smile Shutter</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Shutter Speed in other Modes</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				iAuto: 2 inch - 1/1500, Program Auto: 1 inch - 1/1500, Manual: 30 inch -1/1500)</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				PIXELS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Total Pixel/Gross Pixel</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				20.4</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Optical Sensor Resolution (in MegaPixel)</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				20.1 MP</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Other Resolution</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				5152 x 2896 (15 M), 3648 x 2736 (10 M), 2592 x 1944 (5 M), 1920 x 1080 (2 M), Sweep Panorama 360: 11520 x 1080, Sweep Panorama Wide: 7152 x 1080 / 4912 x 1920, Sweep Panorama Standard: 4912 x 1080 / 3424 x 1920</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				LENS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Lens Type</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Sony Lens</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Color Filter</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				ND Filter</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Auto Focus</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focus Mode</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Multi Point AF, Center Weighted AF, Spot AF, Tracking Focus, Face Tracking Focus</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focal Length</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				4.5 - 157.5 mm (35 mm Equivalent to 25 - 875 mm)</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				ZOOM</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Optical Zoom</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				35</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focus</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Auto</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focusing Sysetm</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Auto Focus</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Digital Zoom</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				70x</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				DIMENSION</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Weight without Battery</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				495 g</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Weight</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				590 g</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Dimensions</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				127.5 (W) x 89.0 (H) x 91.7 (D) mm</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				WARRANTY</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Warranty Summary</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				2 Years Sony India Warranty and Free Transit Insurance.</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				LCD</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				LCD Display</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Clear Photo / TFT LCD</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Video Display Resolution</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				1280 x 720, 30 fps</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				LCD Screen Size</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				3 inch</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Other Display Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Beauty Effect, Date view, Slideshow with Music, Automatic Image Rotation, Image Processor, Optical Steady Shot</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Image Display Resolution</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				460,800 dots</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Manual Exposure</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Exposure Compensation</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				1/3 EV Steps +/- 2.0 EV</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Supported Aspect Ratio</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				4:3, 16:9</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Brightness Adjustment</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				5 Level Manual Adjustment</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				INTERFACE</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Microphone</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Built-in Mono</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				USB Cable</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Hi-speed USB</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Wi-Fi Connectivity</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Audio Video Interface</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				NTSC</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Wireless Connectivity</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				IN THE BOX</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Sales Package</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				AA Battery, Lens Strap, Multi USB Cable, Shoulder Strap, Lens Cap, Instruction Manual</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				GENERAL</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Brand</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Sony</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Type</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Point &amp; Shoot</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Series</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Cyber-shot</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Model ID</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				DSC-H300</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Color</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Black</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				FLASH</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Flash Modes</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Auto, Flash On, Slow Sync, Flash Off, Advanced Flash</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Flash Range</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				0.4 - 6.8 m (W, ISO Auto), 1.5 - 3.6 m (T, ISO Auto), 13.7 m (W) - 7.2 m (T) ISO 3200</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				SENSOR</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Sensor Size</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				1/2.3</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Other Sensor Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Super HAD CCD</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Sensor Type</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				CCD</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n	</tbody>\r\n</table>', '', 56, '', '', '', '');
INSERT INTO `products_description` VALUES
(5, 1, 'Asus Covers', '', '<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Specifications of Fly Accessories Mini Mobile Holder</h3>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				GENERAL</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Brand</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Fly Accessories</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Foldable</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				No</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Model Number</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Mini</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Material</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Plastic</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Compatible With</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				IPhone 6, IPhone 6 Plus, IPhone 5, IPhone 5s, IPhone 5c, IPhone 4s, Moto X2, Samsung Galaxy, Samsung S5, Samsung S4, One Plus, Yureka, Micromax, Nokia, Motorola, Nexus, Xolo, Lava, Lenovo</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Color</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Black</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				DIMENSIONS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Weight</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				100</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Height</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				9</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Width</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				4</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', 'Asus Covers', 13, '', '', '', ''),
(6, 1, 'Headset', '', '<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Specifications of Jo Jo Pouch for Apple iPhone SE 64GB (White, Orange)</h3>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				GENERAL</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Brand</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Jo Jo</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Shade</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				White, Orange</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Material</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Artificial Leather</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Designed for</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Apple iPhone SE 64GB</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Model ID</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Jojo764859</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Color</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				White</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				DIMENSIONS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Weight</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				250 g</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Width x Height x Depth</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				20 x 9 x 2 cm</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				WARRANTY</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Warranty Summary</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				No Warranty</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				IN THE BOX</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Sales Package</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				1 Pouch COVER</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', 'Headset', 13, '', '', '', '');
INSERT INTO `products_description` VALUES
(7, 1, 'Nikon D3200 (Body with AF-S DX_', '', '<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Key Features of Nikon D3200 (Body with AF-S DX NIKKOR 18-55mm f/3.5-5.6G VR II Lens) DSLR Camera</h3>\r\n<ul class="keyFeaturesList" style="margin: 0px; padding: 0px 0px 0px 20px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		Full HD Recording</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		3 inch TFT LCD</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		24.2 Megapixel Camera</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		CMOS Image Sensor</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		ISO 100 - ISO 6400 Sensitivity</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		35 mm Equivalent Focal Length: 27 - 82.5 mm</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		f/3.0 - f/5.6 Aperture</li>\r\n</ul>\r\n<p style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n	&nbsp;</p>\r\n<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Specifications of Nikon D3200 (Body with AF-S DX NIKKOR 18-55mm f/3.5-5.6G VR II Lens) DSLR Camera (Black)</h3>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				SHUTTER SPEED</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Shutter Release Modes</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Single Frame, Continuous, Self-timer, Delayed Remote, Quick-response Remote, Quiet Shutter Release</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Maximum Shutter Speed</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				1/4000 sec</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Minimum Shutter Speed</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				30 sec</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Shutter Flash Sync Speed</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				X=1/200 sec</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				PIXELS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Total Pixel/Gross Pixel</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				24.7</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Optical Sensor Resolution (in MegaPixel)</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				24.2 MP</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Other Resolution</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				4512 x 3000 (M), 3008 x 2000 (S), 1920 x 1080, 1280 x 720, 640 x 424</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				LENS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focus Mode</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Single-point AF, Dynamic-area AF, Auto-area AF, 3D-tracking (11 Points)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Auto Focus</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				other Lens Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				<div class="dummy-content" style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n					Nikon F Lens Mount (with AF Contact), 1.5x Lens Focal Length (35 mm Format Equivalent, Nikon DX Format), Quick Return Reflex Mirror, Lens Aperture: Instant Return, Electronically Controlled, Compatible Lenses: Autofocus is Available with AF-S and AF-I Lenses, Autofocus is not Available with Other Ty...<a style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline; color: rgb(102, 102, 102); cursor: pointer;">View More</a></div>\r\n			</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focus Points</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				11 Focus Point</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focal Length</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				18 - 55 mm (35 mm Equivalent to 27 - 82.5 mm)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Manual Focus</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focusing Screen</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Type B BriteView Clear Matte Mark VII Focusing Screen</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Other Focus Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Manual Focus (MF): Electronic Rangefinder, Focus Lock</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Lens Servo</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Autofocus (AF), Single-servo AF (AF-S), Continuous-servo AF (AF-C), Auto AF-S/AF-C Selection (AF-A); Predictive Focus Tracking Activated Automatically According to Subject Status</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focus Range</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Detection Range: -1 - EV (ISO 100, 20&deg;C)</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				ZOOM</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focus</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Auto / Manual</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				DIMENSION</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Weight without Battery</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				455 g</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Weight</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				505 g</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Dimensions</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				125 (W) x 96 (H) x 76.5 (D) mm</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				WARRANTY</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Covered in Warranty</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Warranty of the product is limited to only manufacturing defect on camera body &amp; lens</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Warranty Summary</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				2 Years Nikon India Warranty and Free Transit Insurance.</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Warranty Service Type</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Carry in</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				LCD</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Viewpoint Dioptric Adjustment</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Diopter Adjustment: -1.7 - 0.5 m-1</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Exposure Modes</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Auto Modes (Auto, Auto (Flash Off), Scene Modes (Portrait, Landscape, Child, Sports, Close Up, Night Portrait), Programmed Auto with Flexible Program (P), Shutter-priority Auto (S), Aperture-priority Auto (A), Manual (M)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				LCD Screen Size</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				3 inch</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				No. of Multiple Exposures</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				1</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Image Display Resolution</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				921,000 dots</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Exposure Meter Coupling</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				CPU</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Viewfinder Type</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Eye-level Pentamirror</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Other Exposure Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Metering: TTL Exposure Metering using 420-pixel RGB Sensor, Range (ISO 100, f/1.4 Lens, 20C/68F): Matrix or Center-weighted Metering: 0 - 20 EV Spot Metering: 2 - 20 EV, Exposure Lock: Luminosity Locked at Detected Value with AE-L/AF-L Button</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Viewfinder Magnification</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				0.8 x (50 mm f/1.4 Lens at infinity, -1.0 m-1)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				LCD Display</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				TFT LCD</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Video Display Resolution</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				1920 x 1080, 30p</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Viewfinder Eye Point</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				18</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Exposure Compensation</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				5 EV in increments of 1/3 EV</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Viewfinder Coverage</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				95% Horizontal and 95% Vertical</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				AE Lock/Exposure Lock</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Viewfinder</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				ViewFinder</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				INTERFACE</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Microphone</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Monaural</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				USB Cable</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Hi-speed USB</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				PictBridge</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Accessory Shoe</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				ISO 518 Hot-shoe with Sync and Data Contacts and Safety Lock</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Audio Video Interface</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Video Output (NTSC, PAL)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		</tr>\r\n	</tbody>\r\n</table>', '', 9, '', '', '', '');
INSERT INTO `products_description` VALUES
(8, 1, 'Bluetooth Eaybud', '', '<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Specifications of Jo Jo Pouch for Apple iPhone SE 64GB (White, Orange)</h3>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				GENERAL</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Brand</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Jo Jo</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Shade</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				White, Orange</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Material</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Artificial Leather</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Designed for</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Apple iPhone SE 64GB</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Model ID</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Jojo764859</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Color</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				White</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				DIMENSIONS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Weight</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				250 g</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Width x Height x Depth</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				20 x 9 x 2 cm</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				WARRANTY</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Warranty Summary</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				No Warranty</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				IN THE BOX</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Sales Package</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				1 Pouch COVER</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', 'Bluetooth Eaybud', 10, '', '', '', '');
INSERT INTO `products_description` VALUES
(9, 1, 'cp plus cp qac', '', '<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Specifications of Sony Cyber-shot DSC-W830/VC Point &amp; Shoot Camera (Violet)</h3>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				SHUTTER SPEED</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Shutter Speed in other Modes</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				iAuto: 2 inch - 1/1, 600, Program Auto (1 inch - 1/1, 600)</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				PIXELS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Total Pixel/Gross Pixel</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				20.5</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Optical Sensor Resolution (in MegaPixel)</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				20.1 MP</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				LENS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Lens Type</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Vario-Tessar</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Auto Focus</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focus Mode</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Multi-point AF, Center Weighted AF, Spot AF, Flexible Spot AF (Tracking Focus and Face Tracking Focus)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				other Lens Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				F Number: F3.3 (W) - F6.3 (T), Focal Lenght (35 mm Conversion): 28 - 224 mm Still Image (16:9), 25 - 200 mm Still Image (4:3), 28 - 224 mm (SteadyShot Standrad), 28 - 314 mm (SteadyShot Active) Movie (16:9), 34 - 272 mm (SteadyShot Standrad), 34 - 381 mm (SteadyShot Active) Movie (4:3)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focal Length</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				4.5 - 36 mm</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Lens Construction</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				8 Elements, 7 Groups (5 Aspheric Elements)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Other Focus Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Auto Focus Illuminator: Auto / Off, Face Detectin Mode: Auto / Off, Face Detection: Maximum 8 Faces</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focus Range</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				iAuto and Program Auto: 5 cm (W) - 150 cm (T)</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				ZOOM</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Optical Zoom</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				8</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Focus</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Auto</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Digital Zoom</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				32x</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				DIMENSION</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Weight</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				104 g</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Dimensions</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				93.1 (W) x 52.5 (H) x 22.5 (D)</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				WARRANTY</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Warranty Summary</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				2 Years Sony India Warranty and Free Transit Insurance.</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				LCD</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				LCD Display</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				ClearPhoto TFT LCD</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				LCD Screen Size</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				2.7 inch</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Other Display Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Playback (Slide Show): SD Video Out, Movie, Simple, Nostalgic, Stylish, Active (Effects), 4 Slde Show Music Tunes, Automatic Image Rotation, 3D Viewing Mode</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Image Display Resolution</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				230,400 dots</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Exposure Compensation</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				1/3 EV Steps +/- 2.0 EV</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Supported Aspect Ratio</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				4:3, 16:9<br />\r\n				&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '', 22, '', '', '', '');
INSERT INTO `products_description` VALUES
(12, 1, 'Asus Zenfone 2 Laser ZE550KL', '', '<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Key Features of Asus Zenfone 2 Laser ZE550KL</h3>\r\n<ul class="keyFeaturesList" style="margin: 0px; padding: 0px 0px 0px 20px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		Android v5 (Lollipop) OS</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		13 MP Primary Camera</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		5 MP Secondary Camera</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		Dual Sim (LTE + LTE)</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		5.5 inch Capacitive Touchscreen</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		1.2 GHz Qualcomm Snapdragon 410 MSM8916 Quad Core Processor</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		Expandable Storage Capacity of 128 GB</li>\r\n</ul>\r\n<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Specifications of Asus Zenfone 2 Laser ZE550KL (Black, 16 GB)</h3>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				GENERAL FEATURES</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Brand</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Asus</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Handset Color</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Black</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Form</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Bar</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				SIM Size</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Micro SIM</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Call Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Loudspeaker</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Model Name</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Zenfone 2 Laser ZE550KL</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Touch Screen</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, Capacitive</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				SIM Type</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Dual Sim, LTE + LTE</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Model ID</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				ZE550KL-1A017WW/ ZE550KL-1A111IN</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				In the Box</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Handset, Standard USB Cable, Adapter, User Manual, Warranty Card</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				IMPORTANT NOTE</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsValue" colspan="2" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: none; border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				4G Connectivity and Phone Features Depend on the Carrier and the Location of the User</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				MULTIMEDIA</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Video Player</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Music Player</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, Supports MP3</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				CAMERA</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Video Recording</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, 1920 x 1080</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Flash</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				LED</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Secondary Camera Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				f/2.0 Aperture, 85 Degree Wide Angle, Auto Focus, Pixel Master, Low Light Mode, Real Time Beautification, Night Mode, Photo Effects, Time Lapse, Selfie Panorama (Upto 140 Degree), HDR Mode, GIF Animation, Selfie Mode</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Rear Camera</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, 13 MP</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Front Facing Camera</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, 5 MP</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Primary Camera Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				<div class="dummy-content" style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n					f/2.0 Aperture, 5-element Lens, Auto Focus, Dual Color Flash, Wide View, LED Flash, PixelMaster, Dual-color Real Tone Flash, Blue Glass IR Filter, Zero Shutter Lag, Back Light (HDR) Mode with ASUS PixelEnhancing Technology for up to 400% Brighter and Evenly Exposed Photos, Low Light Mode, Manual Mod...<a style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline; color: rgb(102, 102, 102); cursor: pointer;">View More</a></div>\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				INTERNET &amp; CONNECTIVITY</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Network Type</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				4G, 3G</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Preinstalled Browser</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Android</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Bluetooth</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, v4</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Navigation Technology</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				A-GPS, GLONASS, with Google Maps</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Wifi</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, 802.11 b/g/n</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Internet Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Email<br />\r\n				&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '', 31, '', '', '', '');
INSERT INTO `products_description` VALUES
(16, 1, 'SAMSUNG Galaxy J7 6 (New 2016 Edition)(Gold, 16 GB)', '', '<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Key Features of SAMSUNG Galaxy J7 - 6 (New 2016 Edition)</h3>\r\n<ul class="keyFeaturesList" style="margin: 0px; padding: 0px 0px 0px 20px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		5.5 inch Super AMOLED Capacitive HD Touchscreen</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		2GB RAM|16 GB ROM</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		13 MP Primary Camera</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		5 MP Secondary Camera</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		1.6 GHz S5E7870 (Exynos 7870) Octa Core Processor</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		3300 mAh Battery</li>\r\n	<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		Android v6 (Marshmallow) OS</li>\r\n</ul>\r\n<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Specifications of SAMSUNG Galaxy J7 - 6 (New 2016 Edition) (Gold, 16 GB)</h3>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				GENERAL FEATURES</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Brand</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				SAMSUNG</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Handset Color</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Gold</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Form</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Bar</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				SIM Size</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Micro SIM</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Call Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Conference Call, Speed Dialing, Loudspeaker, Call Divert</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Model Name</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Galaxy J7 - 6 (New 2016 Edition)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Touch Screen</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, Capacitive</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				SIM Type</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Dual Sim, GSM + WCDMA, (Dual Standby)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Model ID</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				SM-J710FZKUINS/ SM-J710FZWUINS/ SM- J710FZDUINS</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				In the Box</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Handset, Charger, Battery, Hands-free Earphone, User Manual</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				CAMERA</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Video Recording</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, 1920 x 1080, 30 fps</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Flash</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				LED</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Secondary Camera Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Wide Selfie, Pro Selfie</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				HD Recording</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				HD, Full HD</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Rear Camera</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, 13 MP</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Front Facing Camera</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, 5 MP</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Primary Camera Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				CMOS, f/1.9, Auto Focus, Beauty Face, Continuous Shot, Interval Shot, Panorama, Sports Mode, Sound and Shot Mode, Zoom Support</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				MULTIMEDIA</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Video Player</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, Supports MP4, M4V, 3GP, 3G2, WMV, ASF, AVI, FLV, MKV, WEBM, Full HD</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Sound Enhancement</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Integrated Hands-free Speakers, Noise Cancellation</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Music Player</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, Supports MP3, M4A, 3GA, AAC, OGG, OGA, WAV, WMA, AMR, AWB, FLAC, MID, MIDI, XMF, MXMF, IMY, RTTTL, RTX, OTA</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				FM</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '', 11, '', '', '', '');
INSERT INTO `products_description` VALUES
(14, 1, 'HTC  cloud 3g gem+android mobile phone(GUR)', '', '<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Specifications of LeEco Le 2 (Rose Gold, 32 GB)</h3>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				GENERAL FEATURES</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Brand</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				LeEco</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Handset Color</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Rose Gold</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Form</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Bar</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				SIM Size</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Nano SIM</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Call Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Loudspeaker</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Model Name</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Le 2</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Touch Screen</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				SIM Type</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Dual Sim, LTE + LTE, (Dual Standby)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Model ID</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Le X526</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				In the Box</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Handset, Charging Adapter, USB Type-C Cable, Quick Start Guide, SIM Tray Pin, Quick Start Guide, Protective Cover Case, USB Type-C to 3.5 mm Adapter</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				IMPORTANT NOTE</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsValue" colspan="2" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: none; border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				As this phone does not have a 3.5 mm jack, a converter (USB Type C to 3.5 mm) is provided in the box. Using this converter, a 3.5 mm audio jack can be connected through the USB Type C port, 4G Connectivity and Phone Features Depend on the Carrier and the Location of the User</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				MULTIMEDIA</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Sound Enhancement</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Dolby Atmos, 2 Microphones, 1 Bottom Speaker, Smart PA</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Video Player</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, Supports MP4, TS, ASF, WMV, MKV, WEBM, AVI, DivX, 3GP, 3G2, Full HD, 4K - Ultra HD</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Music Player</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, Supports AAC, AAC+, AAC++, AMR, AWB, MIDI, MP3, WAV, RAW, WMA, FLAC, DD, DD+, DTS-LBR, DTS-HD</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				CAMERA</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Video Recording</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, 3840 x 2160, 30 fps</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Secondary Camera Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				F2.2 Aperture, Beauty Mode, FOV 76.5 Degree</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Flash</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Dual LED</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Zoom</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				HD Recording</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				HD, Full HD</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Rear Camera</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, 16 MP</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Front Facing Camera</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, 8 MP</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Primary Camera Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				F2.0 Aperture, 1/3.1 inch Sensor Size, PDAF, Close Loop, Auto Focus, Manual Focus, HDR, Scene Mode, 4K Recording, Slow Motion Recording (720p at 120 fps), BSI, FOV 78.6<br />\r\n				&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '', 15, '', '', '', '');
INSERT INTO `products_description` VALUES
(15, 1, 'Moto X Play(With Turbo Charger)', '', '<div class="keyFeatures specSection viewmoreSpec " id="veiwMoreSpecifications" style="margin: 0px; padding: 0px 0px 14px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline;">\r\n		Key Features of Moto X Play(With Turbo Charger)</h3>\r\n	<ul class="keyFeaturesList" style="margin: 0px; padding: 0px 0px 0px 20px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			Android v5.1.1 (Lollipop) OS</li>\r\n		<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			21 MP Primary Camera</li>\r\n		<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			5 MP Secondary Camera</li>\r\n		<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			5.5 inch Touchscreen</li>\r\n		<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			1.7 GHz Qualcomm Snapdragon 615 Octa Core Processor</li>\r\n		<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			3630 mAh Li-Ion Battery</li>\r\n		<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			Expandable Storage Capacity of 128 GB</li>\r\n	</ul>\r\n</div>\r\n<div class="hsame-alt-reco" style="margin: 0px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; position: relative; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	&nbsp;</div>\r\n<div class="noteSection" style="margin: 0px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline;">\r\n		Notes for Moto X Play(With Turbo Charger) (Black, 16 GB)</h3>\r\n	<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px;">\r\n		<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<th class="groupHead" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n					IMPORTANT NOTE</th>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: none; border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 718px;">\r\n					<ul class="keyFeaturesList" style="margin: 0px; padding: 0px 0px 0px 20px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n						<li style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n							4G Connectivity and Phone Features Depend on the Carrier and the Location of the User</li>\r\n					</ul>\r\n				</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</div>\r\n<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Specifications of Moto X Play(With Turbo Charger) (Black, 16 GB)</h3>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				GENERAL FEATURES</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Brand</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Motorola</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Handset Color</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Black</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Form</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Bar</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				SIM Size</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Nano SIM</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Call Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Loudspeaker</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Model Name</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Moto X Play(With Turbo Charger)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Touch Screen</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				SIM Type</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Dual Sim, LTE + LTE</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Model ID</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				XT1562</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				In the Box</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Handset, Turbo Charger, Headset, Guides</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				IMPORTANT NOTE</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsValue" colspan="2" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: none; border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				4G Connectivity and Phone Features Depend on the Carrier and the Location of the User</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				CAMERA</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Video Recording</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, 1920 x 1080, 30 fps</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Flash</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Dynamic CCT Dual LED</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Zoom</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Digital Zoom - 4x</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				HD Recording</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				HD, Full HD</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Rear Camera</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, 21 MP</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Front Facing Camera</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, 5 MP</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Primary Camera Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				f/2.0 Aperture, Quick Capture, Tap Anywhere to Capture, Slow Motion Video, Burst Mode, Night Mode, Auto HDR, Panorama, Drag to Focus and Exposure, Closed Loop Processing</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				MULTIMEDIA</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Video Player</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, Supports MPEG4, H.264, Full HD</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Sound Enhancement</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				3-mic Support</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Music Player</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, Supports MP3</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				FM</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				INTERNET &amp; CONNECTIVITY</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Network Type</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				4G, 3G</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Audio Jack</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				3.5 mm</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Preinstalled Browser</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Android</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Bluetooth</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, v4, Supported Profiles (LE)</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Navigation Technology</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				A-GPS, GLONASS, BeiDou, with Google Maps</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				NFC</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Internet Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Email</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Wifi</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, 802.11 a/g/b/n</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				GPRS</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				USB Connectivity</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes, micro USB, v2</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Tethering</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				USB, Wi-fi Hotspot</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '', 21, '', '', '', ''),
(17, 1, 'xiaomi Mi 4i Mobile 16 GB', '', '', '', 61, '', '', '', ''),
(18, 1, 'Refurbished Sony Ericsson Mobile Phone', '', '', '', 8, '', '', '', '');
INSERT INTO `products_description` VALUES
(44, 1, 'HP 250 G3 M3M69PA 15.6-inch Laptop(Celetron) Dual Core/2 GB/500', '', '<div class="keyFeatures specSection viewmoreSpec " id="veiwMoreSpecifications">\r\n	<h3 class="sectionTitle">\r\n		Key Features of HP 250 G3- Series 250 G3 Celeron Dual Core - (2 GB/500 GB HDD/Windows 8.1) Notebook M3M69PA</h3>\r\n	<ul class="keyFeaturesList">\r\n		<li>\r\n			Celeron Dual Core</li>\r\n		<li>\r\n			2 GB RAM</li>\r\n		<li>\r\n			500 GB HDD</li>\r\n		<li>\r\n			Windows 8.1</li>\r\n	</ul>\r\n</div>\r\n<div class="hsame-alt-reco">\r\n	&nbsp;</div>\r\n<div class="description specSection">\r\n	<h3 class="sectionTitle">\r\n		HP 250 G3- Series 250 G3 Celeron Dual Core - (2 GB/500 GB HDD/Windows 8.1) Notebook M3M69PA (14 inch, Black, 2.1 kg) Price: Rs. 20,500</h3>\r\n	<div class="description-text">\r\n		The notebook features a slightly wedge shaped base unit, seems study and quite suitable for daily use. The painted surfaces feel nice</div>\r\n</div>\r\n<div class="ugcFeedbackTooltip-container" data-ctrl="UGCFeedbackTooltipController" data-origin="pd">\r\n	<div class="rate">\r\n		<div class="quest">\r\n			Was this product information helpful?</div>\r\n		<div class="ans positive" data-item-id="ITME7NQEYKNDGDPN#yes">\r\n			<div class="label">\r\n				Yes</div>\r\n		</div>\r\n		<div class="ans negative" data-item-id="ITME7NQEYKNDGDPN#no">\r\n			<div class="label">\r\n				No</div>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class="hcross-reco">\r\n	&nbsp;</div>\r\n<h3 class="sectionTitle">\r\n	Specifications of HP 250 G3- Series 250 G3 Celeron Dual Core - (2 GB/500 GB HDD/Windows 8.1) Notebook M3M69PA (14 inch, Black, 2.1 kg)</h3>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Input</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Web Camera</td>\r\n			<td class="specsValue">\r\n				HD Webcam</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Power</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Power Supply</td>\r\n			<td class="specsValue">\r\n				45W Smart AC Adapter</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Battery Backup</td>\r\n			<td class="specsValue">\r\n				Up to 4.3 hours</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Warranty</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Warranty Summary</td>\r\n			<td class="specsValue">\r\n				1 Year Manufacturer Warranty</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Warranty Service Type</td>\r\n			<td class="specsValue">\r\n				On site Service. Customer needs to call the near by Authorized Service Center service engineer will come to the site to get the product repaired or inspected.</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Display</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Resolution</td>\r\n			<td class="specsValue">\r\n				1366 X 768 pixel</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Screen Size</td>\r\n			<td class="specsValue">\r\n				14 inch</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Screen Type</td>\r\n			<td class="specsValue">\r\n				TFT Colour Display</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Communication</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Ethernet</td>\r\n			<td class="specsValue">\r\n				Realtek Ethernet (10/100/)</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Bluetooth</td>\r\n			<td class="specsValue">\r\n				v4.0</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Wireless LAN</td>\r\n			<td class="specsValue">\r\n				IEEE 802.11b/g/n</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Ports/Slots</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Multi Card Slot</td>\r\n			<td class="specsValue">\r\n				1 Media Card Reader</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				HDMI Port</td>\r\n			<td class="specsValue">\r\n				1 HDMI</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				USB Port</td>\r\n			<td class="specsValue">\r\n				2 x USB 2.0</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Storage</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				HDD Capacity</td>\r\n			<td class="specsValue">\r\n				500 GB</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				General</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Brand</td>\r\n			<td class="specsValue">\r\n				HP</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Series</td>\r\n			<td class="specsValue">\r\n				G3- Series</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Model Name</td>\r\n			<td class="specsValue">\r\n				250</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Part Number</td>\r\n			<td class="specsValue">\r\n				M3M69PA</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Model ID</td>\r\n			<td class="specsValue">\r\n				250 G3</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Color</td>\r\n			<td class="specsValue">\r\n				Black</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Lifestyle</td>\r\n			<td class="specsValue">\r\n				Everyday Use</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Memory</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Expandable Memory</td>\r\n			<td class="specsValue">\r\n				Upgradeable to 8 GB</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				System Memory</td>\r\n			<td class="specsValue">\r\n				2 GB</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Optical Disk Drive</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Optical Drive</td>\r\n			<td class="specsValue">\r\n				CD/DVD writer</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Read/Write Speed</td>\r\n			<td class="specsValue">\r\n				8x</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Machine Dimensions</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Weight</td>\r\n			<td class="specsValue">\r\n				2.1 kg</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Dimension</td>\r\n			<td class="specsValue">\r\n				376 x 247 x 35.8 mm</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Color</td>\r\n			<td class="specsValue">\r\n				Black</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Graphics</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Dedicated Graphics Memory Capacity</td>\r\n			<td class="specsValue">\r\n				NA</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Graphic Processor</td>\r\n			<td class="specsValue">\r\n				Intel HD Graphics</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Dedicated Graphics Memory Type</td>\r\n			<td class="specsValue">\r\n				NA</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Audio</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Speakers</td>\r\n			<td class="specsValue">\r\n				Integrated Stereo Speakers</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Platform</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Operating System</td>\r\n			<td class="specsValue">\r\n				Windows 8.1</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				OS Architecture</td>\r\n			<td class="specsValue">\r\n				64 bit</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				In the Box</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Sales Package</td>\r\n			<td class="specsValue">\r\n				Laptop, Charger, Battery</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Processor</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Brand</td>\r\n			<td class="specsValue">\r\n				Intel</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Chipset</td>\r\n			<td class="specsValue">\r\n				Intel BAY Trail</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Variant</td>\r\n			<td class="specsValue">\r\n				N2815</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Clock Speed</td>\r\n			<td class="specsValue">\r\n				1.86 GHz with Turbo Boost Upto 2.13 GHz</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Processor</td>\r\n			<td class="specsValue">\r\n				Celeron Dual Core</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<h2>\r\n	HP 250 G3 M3M69PA 15.6-inch Laptop Information</h2>\r\n<div class="secHeader">\r\n	<span>Technical Details</span></div>\r\n<table border="0" cellpadding="0" cellspacing="0">\r\n	<tbody>\r\n		<tr>\r\n			<td class="label">\r\n				Brand</td>\r\n			<td class="value">\r\n				HP</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Colour</td>\r\n			<td class="value">\r\n				BLACK</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Item Height</td>\r\n			<td class="value">\r\n				6.4 Centimeters</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Item Width</td>\r\n			<td class="value">\r\n				61.5 Centimeters</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Screen Size</td>\r\n			<td class="value">\r\n				15.60 Inches</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Maximum Display Resolution</td>\r\n			<td class="value">\r\n				1366 X 768</td>\r\n		</tr>\r\n		<tr class="size-weight">\r\n			<td class="label">\r\n				Item Weight</td>\r\n			<td class="value">\r\n				2.2 Kg</td>\r\n		</tr>\r\n		<tr class="size-weight">\r\n			<td class="label">\r\n				Product Dimensions</td>\r\n			<td class="value">\r\n				87.1 x 61.5 x 6.4 cm</td>\r\n		</tr>\r\n		<tr class="item-model-number">\r\n			<td class="label">\r\n				Item model number</td>\r\n			<td class="value">\r\n				M3M69PA</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Processor Brand</td>\r\n			<td class="value">\r\n				Intel</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Processor Speed</td>\r\n			<td class="value">\r\n				1.86 GHz</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				RAM Size</td>\r\n			<td class="value">\r\n				2 GB</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Computer Memory Type</td>\r\n			<td class="value">\r\n				DDR3 SDRAM</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Hard Drive Size</td>\r\n			<td class="value">\r\n				500 GB</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Hard Disk Technology</td>\r\n			<td class="value">\r\n				Mechanical Hard Drive</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Hard Drive Interface</td>\r\n			<td class="value">\r\n				ATA100</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Graphics Coprocessor</td>\r\n			<td class="value">\r\n				Intel Integrated Graphics</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Graphics Card Description</td>\r\n			<td class="value">\r\n				Integrated Graphics Card</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Optical Drive Type</td>\r\n			<td class="value">\r\n				DVD/CD</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Power Source</td>\r\n			<td class="value">\r\n				Battery</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Hardware Platform</td>\r\n			<td class="value">\r\n				PC</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Operating System</td>\r\n			<td class="value">\r\n				Windows 8 Pro</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Number of Batteries</td>\r\n			<td class="value">\r\n				1</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Included Components</td>\r\n			<td class="value">\r\n				laptop , Charger, Battery &amp; Manual</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '', 14, '', '', '', ''),
(20, 1, 'LCD Sony', '', '<p>\r\n	<span style="font-size:22px;">Wide veiwing angle</span></p>\r\n<h2>\r\n	Technical Details</h2>\r\n<ul>\r\n	<li>\r\n		<b>Brand Name</b>: Sony</li>\r\n	<li>\r\n		<b>Model Number</b>: KDL-32BX300</li>\r\n	<li>\r\n		<b>Display Technology</b>: LCD</li>\r\n	<li>\r\n		<b>Display Size</b>: 31.5 inches</li>\r\n	<li>\r\n		<b>Image Aspect Ratio</b>: 16:9</li>\r\n</ul>\r\n<p>\r\n	<strong><span style="font-size:22px;">&nbsp;Key Features</span></strong></p>\r\n<ul>\r\n	<li>\r\n		<p>\r\n			<strong>HD 720p Resolution Panel:</strong> Enjoy crisp, detailed and vibrant images in 720p picture quality while watching movies, sports and primetime HD television broadcasts via the 16:9 wide screen panel (1366 x 768).</p>\r\n		<p>\r\n			<strong>5 HD Inputs:</strong> Get versatile HD connection options with 5 HD inputs, including 2 HDMI inputs to connect a Blu-ray Disc player, PlayStation3 gaming console or any other HDMI-capable equipment. Two HD component inputs provide added HD-capable connectivity, while a PC input (HD-15 pin) lets you use your HDTV as a computer monitor.</p>\r\n		<p>\r\n			<strong>BRAVIA Engine 2:</strong> Enjoy sharp, vibrant, life-like images while optimizing color and contrast and significantly reducing noise with the BRAVIA Engine 2 fully digital processor.</p>\r\n		<p>\r\n			<strong>24p True Cinema:</strong> Movies consist of 24 images per second, and cannot be faithfully reproduced on conventional televisions, resulting in unnatural, jerky movements. But 24p True Cinema displays the 24 progressive images as they should be, in the same sequence as the original film source. Now, you can recreate the visual clarity of cinema-quality movies in the comfort of your own home.</p>\r\n		<p>\r\n			<strong>BRAVIA Sync Compatible:</strong> Conveniently operate and control other BRAVIA Sync compatible devices--including BRAVIA HDTVs, Blu-ray Disc Players, surround sound systems, Handycam camcorders and Cyber-shot digital still cameras, all with one remote control.</p>\r\n		<p>\r\n			<strong>VESA-compatible hole spacing</strong> uses an industry-standard mounting-hole pattern that can be used with VESA-compliant mounting brackets, taking the guesswork out of selecting the proper hardware for hanging your TV on the wall.</p>\r\n	</li>\r\n</ul>\r\n<p>\r\n	<strong><span style="font-size:22px;">Key Specifications</span></strong></p>\r\n<ul>\r\n	<li>\r\n		Screen size: 32 inches</li>\r\n	<li>\r\n		CineMotion Reverse 3:2 Pulldown Technology: Yes</li>\r\n	<li>\r\n		24p True Cinema Technology: Yes</li>\r\n	<li>\r\n		3D Comb Filter: Yes</li>\r\n	<li>\r\n		Live Color Technology: Yes</li>\r\n	<li>\r\n		Auto Picture Setting w/ HDMI: Cinema, Photo, Graphics, Game</li>\r\n	<li>\r\n		Speakers: 2x 10W (20 watts of total power)</li>\r\n	<li>\r\n		5.1 Channel Audio Out: Yes</li>\r\n	<li>\r\n		Dolby: Dolby Digital</li>\r\n	<li>\r\n		Tuners: ATSC, NTSC, Clear QAM</li>\r\n	<li>\r\n		VESA wall mounting pattern: 200 x 200</li>\r\n	<li>\r\n		Warranty: 1 year labor and parts</li>\r\n</ul>\r\n<p>\r\n	<span style="font-size:24px;"><b>Dimensions</b></span></p>\r\n<ul>\r\n	<li>\r\n		TV with stand: 31.75 x 21 x 8.75 inches (WxHxD); 24.2 pounds</li>\r\n	<li>\r\n		TV without stand: 31.75 x 19.6 x 3.9 inches (WxHxD); 19.36 pounds</li>\r\n	<li>\r\n		<a href="https://www.amazon.com/Sony-BRAVIA-32-Inch-Black-Model/dp/B0035ER1GO#size">What size TV should you get?</a></li>\r\n</ul>\r\n<p>\r\n	<span style="font-size:26px;"><b>Connections</b></span></p>\r\n<br />\r\n<ul>\r\n	<li>\r\n		HDMI: 2 (rear; HDMI PC input capability)</li>\r\n	<li>\r\n		Component: 2 (rear)</li>\r\n	<li>\r\n		Composite A/V: 2 (rear)</li>\r\n	<li>\r\n		RF: 2 (rear)</li>\r\n	<li>\r\n		USB 2.0: 1 (for service only)</li>\r\n	<li>\r\n		PC input (15-pin, D-Sub): 1 (rear)</li>\r\n	<li>\r\n		Analog audio inputs: 3 (rear)</li>\r\n	<li>\r\n		Digital audio output: 1 optical</li>\r\n</ul>', '', 14, '', '', '', ''),
(21, 1, 'Asus ultra wide LED', '', '<h4 style="color: red;">\r\n	<span style="font-family:arial,helvetica,sans-serif;"><span style="font-size: 16px;"><span style="color: rgb(0, 0, 0);"><var><big>Features:<br />\r\n	- 34&quot;, 21:9 aspect ratio monitor with 3440x1440 resolution IPS panel for excellent visual performance<br />\r\n	- NVIDIA G-SYNC technology and fast 100Hz refresh rate reduce tearing, stutter and lag during gameplay<br />\r\n	- Frameless curved design for immersive gaming experience<br />\r\n	- Asus exclusive 5-way OSD navigation joystick, GamePlus, GameVisualand Turbo hotkey for an in-game advantage<br />\r\n	- Ergonomic design with tilt, swivel and height adjustment. VESA mount compatible<br />\r\n	- Features a signature mysterious pattern with the illuminated LED light-in-motion on the chassis for ROG brand synergy.<br />\r\n	- Built in 2W Stereo speakers<br />\r\n	- DisplayPort, HDMI and USB 3.0 Hub<br />\r\n	<br />\r\n	<ins>Specification:-</ins><br />\r\n	- Screen Size Class (diagonal): 34&quot; Curved<br />\r\n	- Panel Type: IPS<br />\r\n	- Aspect Ratio: 21:9<br />\r\n	- Resolution: 3440x1440<br />\r\n	- Refresh rate: 100Hz (G-SYNC)<br />\r\n	- Brightness (typical): 300 cd/m2<br />\r\n	- Contrast Ratio(Original): 100M:1<br />\r\n	- Response Time: 4ms<br />\r\n	- Viewing Angle (CR&gt;10): 178/178<br />\r\n	- Connectivity: 1x HDMI &amp; 1x DisplayPort<br />\r\n	- Speakers: 2x 2W<br />\r\n	- Tilt: Yes<br />\r\n	- Height Adjust: Yes<br />\r\n	- USB 3.0 Hub<br />\r\n	- VESA: 100 x 100<br />\r\n	- Warranty: 3yr </big></var></span></span></span></h4>', '', 57, '', '', '', '');
INSERT INTO `products_description` VALUES
(45, 1, 'Micromax Canvas Lapbook L1161 Laptop(intel  Quad Core processor', '', '<div id="phoneH">\r\n	<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n		Specifications of HP 15-af114AU APU Quad Core A8 - (4 GB/1 TB HDD/Windows 10) Notebook P3C92PA#ACJ (15.6 inch, Turbo SIlver Color With Diamond &amp; Cross Brush Pattern, 2.19 kg)</h3>\r\n	<h2>\r\n		&nbsp;</h2>\r\n	<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n		<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n					INPUT</th>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					Pointer Device</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					Touchpad with Windows 10 Multi-touch Gesture Support</td>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					Keyboard</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					Full-size Textured Island Style Keyboard With Numeric Keypad</td>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					Web Camera</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					HP TrueVision HD Webcam</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n	<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n		<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n					POWER</th>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					Power Supply</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					65 W AC Adapter</td>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					Battery Cell</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					4 cells, 41 Wh Li-Ion Battery</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n	<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n		<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n					WARRANTY</th>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					Warranty Summary</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					1 Year Onsite Warranty</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n	<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n		<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n					DISPLAY</th>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					Resolution</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					1366 x 768 pixel</td>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					Screen Size</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					15.6 inch</td>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					Screen Type</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					HD LED Backlit Widescreen BrightView Display</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n	<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n		<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n					COMMUNICATION</th>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					Ethernet</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					10/100 BaseT</td>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					Bluetooth</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					v4.0</td>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					Wireless LAN</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					IEEE 802.11b/g/n</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n	<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n		<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n					PORTS/SLOTS</th>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					Mic In</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					Yes</td>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					Multi Card Slot</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					3-in-1 Card Reader</td>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					HDMI Port</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					Yes, v1.4</td>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					USB Port</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					1 x USB 3.0, 2 x USB 2.0</td>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					RJ45 LAN</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					Yes</td>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					Other Ports</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					1 x Headphone Out / Microphone In Combo Jack</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n	<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n		<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n					STORAGE</th>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					HDD Capacity</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					1 TB</td>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					RPM</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					5400</td>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					Hardware Interface</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					SATA</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n	<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n		<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n					SECURITY</th>\r\n			</tr>\r\n			<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n				<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n					Lock Port</td>\r\n				<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n					Kensington Lock Slot</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '', 20, '', '', '', ''),
(23, 1, 'Purple Adidas Men Ice Dive EDT(100 ml)', '', '<p>\r\n	Fragrance Men Perfumes,Men Perfumes at Purplle Best Beauty Products at amazon nykaa snapdeal paytm ebay.</p>', '', 6, '', '', '', ''),
(24, 1, 'gillette BODY DISPOSABLE Razor', '', '<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Specifications of gillette BODY DISPOSABLE Razor</h3>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				SHAVING RAZOR TRAITS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Lubricating Strip</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Handle Features</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Anti-slip Grip</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				GENERAL TRAITS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Ideal For</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Men</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				IN THE BOX</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsValue" colspan="2" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: none; border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Shaving Razor</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				ADDITIONAL TRAITS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				&nbsp;</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Rounded Head, Maximized Glide, Power Glide Blades, Feels Less Irritation</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '', 10, '', '', '', '');
INSERT INTO `products_description` VALUES
(25, 1, 'Nivea Men Grooming Kit', '', '<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Specifications of Nivea Oil Control Moisturiser (50 ml)</h3>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				GENERAL TRAITS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Applied For</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Moisturization &amp; Nourishment</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Quantity</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				50 ml</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Application Area</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Face and Neck</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Skin Type</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Oily Skin</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Type</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Cream</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Ideal Usage</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Day</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Ideal For</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Men</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				MOISTURIZER &amp; CREAM TRAITS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Dermatologist Tested</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				UV Protection</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Yes</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Container Type</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Tube</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				ADDITIONAL TRAITS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				&nbsp;</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Fast Absorbing, Contains Whitanat Vita Complex Plus, Whiten Dull and Damaged Skin, Long-lasting Skin Care, Calms Skin after Shaving, Controls Oiliness and Regeneration of Skin, Eliminates Acne Causing Bacteria upto 99% for Clear Skin, 10X Whitening</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '', 7, '', '', '', ''),
(26, 1, 'Purple Adidas Shower Gel Ice Dive(250 ml)', '', '<p>\r\n	At Purple Based Beauty Products</p>', '', 2, '', '', '', ''),
(27, 1, 'VLCC Insta Glow Facial Kit-200 g(New Package)', '', '', '', 1, '', '', '', ''),
(28, 1, 'BC Repair Rescue Treatment', '', '<p>\r\n	For Damaged Hair New Packaging(200 ml/6)</p>', '', 13, '', '', '', ''),
(29, 1, 'Lakme Sun Expert Fairness + UV Lotion SPF 30 PA++', '', '<p>\r\n	At Nykaa,Best Beauty Products Online</p>', '', 3, '', '', '', ''),
(30, 1, 'Lakme Face Magic Skin Tints Cream', '', '<p>\r\n	Pearl At Nykaa,Best Beauty Products Online</p>', '', 5, '', '', '', ''),
(31, 1, 'White Colour Makeup Cosmetic Organiser', '', '<p>\r\n	Storage Case Box 360 Degree Rotating Revolving.Gift For Girl Women,Female,Sister,Wife</p>', '', 3, '', '', '', ''),
(32, 1, 'Make Up Kits Ads 4 in 1', '', '', '', 4, '', '', '', ''),
(33, 1, 'Lakme Pink Rose Powder At Nykaa', '', '<p>\r\n	Best Beauty Products Online</p>', '', 5, '', '', '', ''),
(34, 1, 'MUA luxe Whipped Velvet Blush At NYKAA', '', '<p>\r\n	Best Beauty Products Online</p>', '', 8, '', '', '', ''),
(35, 1, 'Set Of 5 Make Up Brushes', '', '', '', 2, '', '', '', ''),
(36, 1, 'JMD Creation Desk Organiser', '', '<h3 class="sectionTitle">\r\n	<span style="font-size:22px;"><u><strong>Specifications of JMD Creation 7 Compartments Nylon Desk Organizer (Black)</strong></u></span></h3>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				<span style="font-size:22px;">General</span></th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Model Name</td>\r\n			<td class="specsValue">\r\n				&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; JMD21450</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				<span style="font-size:22px;">Body Features</span></th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Body Material</td>\r\n			<td class="specsValue">\r\n				&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Nylon</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Number of Compartments</td>\r\n			<td class="specsValue">\r\n				&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 7 Compartments</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" height="50" width="325">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				<span style="font-size:22px;">In the Box</span></th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsValue" colspan="2">\r\n				One Desk Organizer&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	<span style="font-family:georgia,serif;"><strong><span style="font-size: 20px;"><u>Product Information</u></span></strong></span></p>\r\n<p class="secHeader">\r\n	<span style="font-family:georgia,serif;"><strong><span style="font-size: 20px;"><u><span>Technical Details</span></u></span></strong></span></p>\r\n<table border="0" cellpadding="0" cellspacing="0">\r\n	<tbody>\r\n		<tr>\r\n			<td class="label">\r\n				Color</td>\r\n			<td class="value">\r\n				Cream</td>\r\n		</tr>\r\n		<tr class="size-weight">\r\n			<td class="label">\r\n				Item Weight</td>\r\n			<td class="value">\r\n				798 g</td>\r\n		</tr>\r\n		<tr class="size-weight">\r\n			<td class="label">\r\n				Product Dimensions</td>\r\n			<td class="value">\r\n				25.4 x 25.4 x 25.4 cm</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Shipping Weight</td>\r\n			<td class="value">\r\n				800 Grams</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Item Model Number</td>\r\n			<td class="value">\r\n				A471</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Item Part Number</td>\r\n			<td class="value">\r\n				5214</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Primary material</td>\r\n			<td class="value">\r\n				Fabric</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Capacity</td>\r\n			<td class="value">\r\n				8 x 12</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '', 20, '', '', '', ''),
(37, 1, 'Urban Living Rack Office Computer Desk Supply', '', '<h2>\r\n	PRODUCT DETAILS: Urban Living Rack Office Computer Desk Supply Caddy Tray Board Desktop Organizer - Green</h2>\r\n<p>\r\n	<a name="Description"></a></p>\r\n<h2>\r\n	<a name="Description">Product Description</a></h2>\r\n<p>\r\n	Multi-compartment Design - Articles classification, Neat appearance. Home, Office, Multi-function Desk Stationery Organizer Storage Box Convenient &amp; Concise - Hold commonly used items, Office Supplies. Spend less time looking for what you need and more time focusing on what matters Format Storage Space, Removable, Waterproof - Keep desktop neatly &amp; Hold nice Anti dust atmosphere.</p>\r\n<div id="content_block_features">\r\n	<div class="product-features-list">\r\n		<a name="Features"></a>\r\n		<h2>\r\n			<a name="Features">Product FEATURES</a></h2>\r\n		<h3 class="subheader">\r\n			Key Feature</h3>\r\n		<div>\r\n			<label>Brand:</label> <span> Urban Living </span></div>\r\n		<h3 class="subheader">\r\n			Home Color Option</h3>\r\n		<div>\r\n			<label>Color:</label> <span> </span>\r\n			<ul class="no-markers no-margin">\r\n				<li>\r\n					<span>Green</span></li>\r\n			</ul>\r\n		</div>\r\n		<h3 class="subheader">\r\n			Organisers Specification</h3>\r\n		<div>\r\n			<label>Types:</label> <span> Organiser </span></div>\r\n	</div>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '', 14, '', '', '', ''),
(38, 1, 'Creative A50 Portable Laptop/Desktop Speaker', '', '<h3 class="sectionTitle">\r\n	<u><strong>Specifications of Creative A50 Portable Laptop/Desktop Speaker (Black, 2.0 Channel)</strong></u></h3>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				<u>General</u></th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Brand</td>\r\n			<td class="specsValue">\r\n				Creative</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Wired/Wireless</td>\r\n			<td class="specsValue">\r\n				Wired</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Compatible Devices</td>\r\n			<td class="specsValue">\r\n				Notebook, Desktop PC</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Type</td>\r\n			<td class="specsValue">\r\n				Laptop/Desktop Speaker</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Configuration</td>\r\n			<td class="specsValue">\r\n				2.0 Channel</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Model ID</td>\r\n			<td class="specsValue">\r\n				A50</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Color</td>\r\n			<td class="specsValue">\r\n				Black</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				<u>Power</u></th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Power Output</td>\r\n			<td class="specsValue">\r\n				1.6 W (Satellite)</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Power Source</td>\r\n			<td class="specsValue">\r\n				USB Powered</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				<u>Audio Features</u></th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Impedance</td>\r\n			<td class="specsValue">\r\n				0 Ohms (Subwoofer)</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Total Power Output RMS (W)</td>\r\n			<td class="specsValue">\r\n				1.6 W (Satellite)</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Frequency Response</td>\r\n			<td class="specsValue">\r\n				100 - 15 KHz</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				<u>Connectivity</u></th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Memory Card Slot</td>\r\n			<td class="specsValue">\r\n				No</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<div class="keyFeatures specSection viewmoreSpec " id="veiwMoreSpecifications">\r\n	<h3 class="sectionTitle">\r\n		<u>Key Features of Creative A50 Portable Laptop/Desktop Speaker</u></h3>\r\n	<ul class="keyFeaturesList">\r\n		<li>\r\n			Type - Laptop/Desktop Speaker</li>\r\n		<li>\r\n			Configuration - 2.0</li>\r\n		<li>\r\n			Power Output - 1.6 W (Satellite)</li>\r\n		<li>\r\n			Frequency Response - 100 - 15 KHz</li>\r\n		<li>\r\n			Wired</li>\r\n		<li>\r\n			<div class="description specSection">\r\n				<h3 class="sectionTitle">\r\n					Creative A50 Portable Laptop/Desktop Speaker (Black, 2.0 Channel) Price: Rs. 825</h3>\r\n				<div class="description-text">\r\n					<p>\r\n						Easy to use, sleek and designed with many innovative features, this magnetically shielded speaker set from Creative will not only enhance your entertainment room&rsquo;s decor but also deliver you a rich audio experience.</p>\r\n					<p>\r\n						<strong>USB-powered speaker set</strong></p>\r\n					<p>\r\n						All you need is a USB port to power up this speaker set. Just connect it with the help of the USB cable to your computer or laptop for an immersive playback experience.</p>\r\n					<p>\r\n						<strong>Connectivity</strong></p>\r\n					<p>\r\n						The 3.5mm stereo jack of this speaker set ensures easy connectivity with almost any kind of audio device.</p>\r\n					<p>\r\n						<strong>Built-in bass port</strong></p>\r\n					<p>\r\n						Featuring an inbuilt bass port, this speaker set offers you rich bass while taking up minimum space on your computer desk.</p>\r\n					<p>\r\n						<strong>Convenient controls</strong></p>\r\n					<p>\r\n						The volume control knob and the on/off switch are conveniently located on the right speaker to give you easy access to them.</p>\r\n				</div>\r\n			</div>\r\n		</li>\r\n	</ul>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '', 24, '', '', '', ''),
(39, 1, 'Quantum 4 Port USB Hub with Switch and LED Indicator', '', '<h2 class="default">\r\n	Product Description</h2>\r\n<div class="a-section a-spacing-small" id="productDescription">\r\n	<h3>\r\n		Product Description</h3>\r\n	<p>\r\n		4 PORT-MAC LINUX WINDOWS SUITABLE-LED INDICATOR-ON/OFF SWITCH-USB BASED</p>\r\n	<h3>\r\n		From the Manufacturer</h3>\r\n	<div class="aplus">\r\n		<h5>\r\n			Stylish &amp; Efficient</h5>\r\n		Stylish designed with sleek lines in white, the compact and lightweight Quantum USB HUB features a switch and LED indicator and four ports for enhanced convenience and more organized space. The Quantum 4 port USB hub is a great choice to extend USB capabilities to your PC. With this handy USB Hub, you can connect various USB devices for enhanced interface data transfer. With this port hub, upgrade your PC or laptop and get additional utility, specially when you use multiple peripherals like a microphone, mouse, keyboard, printer and webcam that run on USBs. Simply connect the hub into your computer and then plug in the remaining peripherals to the hub for use.\r\n		<h5>\r\n			Power Packed Performance</h5>\r\n		The 4 port USB hub can support up to 127 USB devices and offers full over current protection. It is compatible with low-speed, high-speed, full-speed signalling rates. It has one USB Mini B type female input connector and features Standard A type up to 100mA current per port. While USB 1.0 runs at low speed, USB 1.1 uses full speed and USB 2.0 size ensures faster transfer of data for enhanced performance. This USB powered hub also comes with a power option to connect heavy devices like printers, fax machines, scanners, and webcams. With this USB port multiplier, its so much easier to set up your device along with peripherals conveniently in different locations. A simple On/Off switch makes it easy to identify when in use and not.\r\n		<ul>\r\n			<li>\r\n				Connectivity: Low-Speed USB1.0, Full-Speed USB 1.1, High-Speed USB 2.0</li>\r\n			<li>\r\n				Colour: White</li>\r\n			<li>\r\n				Ports: 4 Ports, one USB Mini B type female input connector</li>\r\n			<li>\r\n				LED indicator, Switch On/Off</li>\r\n			<li>\r\n				100mA current per port</li>\r\n		</ul>\r\n	</div>\r\n</div>\r\n<div class="feature" data-feature-name="aplus" id="aplus_feature_div">\r\n	&nbsp;</div>\r\n<hr class="bucketDivider" noshade="noshade" size="1" />\r\n<p>\r\n	<a id="productDetails" name="productDetails"></a></p>\r\n<h2>\r\n	Product Information</h2>\r\n<div class="wrapper INlocale">\r\n	<div class="column col1 ">\r\n		<div class="section techD">\r\n			<div class="secHeader">\r\n				<span>Technical Details</span></div>\r\n			<div class="content pdClearfix">\r\n				<div class="attrG" style="border:none">\r\n					<div class="pdTab" style="display:block;">\r\n						<table border="0" cellpadding="0" cellspacing="0">\r\n							<tbody>\r\n								<tr>\r\n									<td class="label">\r\n										Brand</td>\r\n									<td class="value">\r\n										Quantum</td>\r\n								</tr>\r\n								<tr>\r\n									<td class="label">\r\n										Colour</td>\r\n									<td class="value">\r\n										white/Black</td>\r\n								</tr>\r\n								<tr>\r\n									<td class="label">\r\n										Item Height</td>\r\n									<td class="value">\r\n										30 Millimeters</td>\r\n								</tr>\r\n								<tr>\r\n									<td class="label">\r\n										Item Width</td>\r\n									<td class="value">\r\n										12.3 Centimeters</td>\r\n								</tr>\r\n								<tr class="size-weight">\r\n									<td class="label">\r\n										Item Weight</td>\r\n									<td class="value">\r\n										50 g</td>\r\n								</tr>\r\n								<tr class="size-weight">\r\n									<td class="label">\r\n										Product Dimensions</td>\r\n									<td class="value">\r\n										18.2 x 12.3 x 3 cm</td>\r\n								</tr>\r\n								<tr class="item-model-number">\r\n									<td class="label">\r\n										Item model number</td>\r\n									<td class="value">\r\n										QHMPL-LINE1</td>\r\n								</tr>\r\n								<tr>\r\n									<td class="lAttr">\r\n										&nbsp;</td>\r\n									<td class="lAttr">\r\n										&nbsp;</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n	<div class="column col2 ">\r\n		<div class="section techD">\r\n			<div class="secHeader">\r\n				<span>Additional Information</span></div>\r\n			<div class="content pdClearfix">\r\n				<div class="attrG" style="border:none">\r\n					<div class="pdTab" style="display:block;">\r\n						<table border="0" cellpadding="0" cellspacing="0">\r\n							<tbody>\r\n								<tr>\r\n									<td class="label">\r\n										ASIN</td>\r\n									<td class="value">\r\n										B00F178GKS</td>\r\n								</tr>\r\n								<tr class="average_customer_reviews">\r\n									<td class="label">\r\n										Customer Reviews</td>\r\n									<td class="value">\r\n										<div class="reviews txtsmall inlineblock" id="averageCustomerReview-dpProductDetail-B00F178GKS">\r\n											<div class="fl acr-popover" id="averageCustomerReviewStars" name="B00F178GKS" style="cursor:pointer;">\r\n												<span class="swSprite s_star_3_5 " style="position:static;" title="3.5 out of 5 stars"><span>3.5 out of 5 stars</span></span> <span style="margin-left:3px;"><span class="swSprite s_chevron " style="position:static;"><span>See all reviews</span></span></span></div>\r\n											<div class="fl gl5 txtnormal" id="averageCustomerReviewCount">\r\n												<a class="noTextDecoration" href="http://www.amazon.in/product-reviews/B00F178GKS/ref=dp_db_cm_cr_see_all_top?ie=UTF8&amp;showViewpoints=1&amp;sortBy=recent">877 reviews</a></div>\r\n											<div class="txtnormal clearboth" id="averageCustomerReviewRating">\r\n												3.5 out of 5 stars</div>\r\n										</div>\r\n									</td>\r\n								</tr>\r\n								<tr id="SalesRank">\r\n									<td class="label">\r\n										Best Sellers Rank</td>\r\n									<td class="value">\r\n										#236 in Computers &amp; Accessories (<a href="http://www.amazon.in/gp/bestsellers/computers/ref=pd_dp_ts_pc_1">See top 100</a>)\r\n										<ul class="zg_hrsr">\r\n											<li class="zg_hrsr_item">\r\n												<span class="zg_hrsr_rank">#2</span> <span class="zg_hrsr_ladder">in&nbsp;<a href="http://www.amazon.in/gp/bestsellers/computers/ref=pd_zg_hrsr_pc_1_1">Computers &amp; Accessories</a> &gt; <a href="http://www.amazon.in/gp/bestsellers/computers/1375248031/ref=pd_zg_hrsr_pc_1_2">Computer Accessories</a> &gt; <a href="http://www.amazon.in/gp/bestsellers/computers/1375342031/ref=pd_zg_hrsr_pc_1_3_last">USB Hubs</a></span></li>\r\n											<li class="zg_hrsr_item">\r\n												<span class="zg_hrsr_rank">#247</span> <span class="zg_hrsr_ladder">in&nbsp;<a href="http://www.amazon.in/gp/bestsellers/electronics/ref=pd_zg_hrsr_e_2_1">Electronics</a> &gt; <a href="http://www.amazon.in/gp/bestsellers/electronics/1458204031/ref=pd_zg_hrsr_e_2_2_last">Computers &amp; Accessories</a></span></li>\r\n										</ul>\r\n									</td>\r\n								</tr>\r\n								<tr class="date-first-available">\r\n									<td class="label">\r\n										Date First Available</td>\r\n									<td class="value">\r\n										7 September 2013</td>\r\n								</tr>\r\n								<tr>\r\n									<td class="lAttr">\r\n										&nbsp;</td>\r\n									<td class="lAttr">\r\n										&nbsp;</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class="section techD">\r\n			<div class="secHeader">\r\n				<span>Feedback</span></div>\r\n			<div class="content pdClearfix">\r\n				&nbsp;Would you like to <b><a href="https://www.amazon.in/gp/gfix/welcome.html/ref=gfix-product-details-catalog?ie=UTF8&amp;ASIN=B00F178GKS&amp;merchantID=A3BRC8NXE5RTB7&amp;storeID=computers">update product info</a></b> or <b><a href="https://www.amazon.in/gp/gfix/imageCorrection.html/ref=gfix-product-details-image?ie=UTF8&amp;ASIN=B00F178GKS&amp;merchantID=A3BRC8NXE5RTB7&amp;storeID=computers">give feedback on images</a></b>?</div>\r\n		</div>\r\n	</div>\r\n	<div style="height:0;clear:left;">\r\n		&nbsp;</div>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '', 30, '', '', '', ''),
(40, 1, 'SDO universal 100% waterproof pouch for all smartphone', '', '<h1 class="a-size-large a-spacing-none" id="title" style="box-sizing: border-box; padding: 0px; margin-top: 0px; margin-right: 0px; margin-left: 0px; font-family: Arial, sans-serif; text-rendering: optimizeLegibility; font-weight: 400; color: rgb(17, 17, 17); margin-bottom: 0px !important; font-size: 21px !important; line-height: 1.3 !important; background-color: rgb(255, 255, 255);">\r\n	<span class="a-size-large" id="productTitle" style="box-sizing: border-box; text-rendering: optimizeLegibility; font-size: 19px !important; line-height: 1.3 !important;">SDO Universal 100% Waterproof Pouch for All SmartPhone, </span></h1>\r\n<h1 class="a-size-large a-spacing-none" style="box-sizing: border-box; padding: 0px; margin-top: 0px; margin-right: 0px; margin-left: 0px; font-family: Arial, sans-serif; text-rendering: optimizeLegibility; font-weight: 400; color: rgb(17, 17, 17); margin-bottom: 0px !important; font-size: 21px !important; line-height: 1.3 !important; background-color: rgb(255, 255, 255);">\r\n	<span class="a-size-large" style="box-sizing: border-box; text-rendering: optimizeLegibility; font-size: 19px !important; line-height: 1.3 !important;">New Waterproof Pouch With Band Special Waterproof Case (Black) for All Mobiles,</span></h1>\r\n<h1 class="a-size-large a-spacing-none" style="box-sizing: border-box; padding: 0px; margin-top: 0px; margin-right: 0px; margin-left: 0px; font-family: Arial, sans-serif; text-rendering: optimizeLegibility; font-weight: 400; color: rgb(17, 17, 17); margin-bottom: 0px !important; font-size: 21px !important; line-height: 1.3 !important; background-color: rgb(255, 255, 255);">\r\n	<span class="a-size-large" style="box-sizing: border-box; text-rendering: optimizeLegibility; font-size: 19px !important; line-height: 1.3 !important;">Universal Pouch with Touch Sensor for Using Touch Screen for iPhone 5S 6,6 plus, </span></h1>\r\n<h1 class="a-size-large a-spacing-none" style="box-sizing: border-box; padding: 0px; margin-top: 0px; margin-right: 0px; margin-left: 0px; font-family: Arial, sans-serif; text-rendering: optimizeLegibility; font-weight: 400; color: rgb(17, 17, 17); margin-bottom: 0px !important; font-size: 21px !important; line-height: 1.3 !important; background-color: rgb(255, 255, 255);">\r\n	<span class="a-size-large" style="box-sizing: border-box; text-rendering: optimizeLegibility; font-size: 19px !important; line-height: 1.3 !important;">Samsung Galaxy S4 S5 S6 S7 Edge S6 Edge Plus Moto G Plus, 4th Gen, Lenovo Vibe K4 Note, </span></h1>\r\n<h1 class="a-size-large a-spacing-none" style="box-sizing: border-box; padding: 0px; margin-top: 0px; margin-right: 0px; margin-left: 0px; font-family: Arial, sans-serif; text-rendering: optimizeLegibility; font-weight: 400; color: rgb(17, 17, 17); margin-bottom: 0px !important; font-size: 21px !important; line-height: 1.3 !important; background-color: rgb(255, 255, 255);">\r\n	<span class="a-size-large" style="box-sizing: border-box; text-rendering: optimizeLegibility; font-size: 19px !important; line-height: 1.3 !important;">Meizu M3 Note, Lenovo Zuk Z1,</span><span style="font-size: 19px; line-height: 1.3;">Coolpad Note 3 Plus, Xiaomi Redmi Note 3,lenovo k5</span></h1>\r\n<h1 class="a-size-large a-spacing-none" style="box-sizing: border-box; padding: 0px; margin-top: 0px; margin-right: 0px; margin-left: 0px; font-family: Arial, sans-serif; text-rendering: optimizeLegibility; font-weight: 400; color: rgb(17, 17, 17); margin-bottom: 0px !important; font-size: 21px !important; line-height: 1.3 !important; background-color: rgb(255, 255, 255);">\r\n	<span class="a-size-large" style="box-sizing: border-box; text-rendering: optimizeLegibility; font-size: 19px !important; line-height: 1.3 !important;">,lenovo k5 plus and All other Cell Phones</span></h1>', '', 20, '', '', '', '');
INSERT INTO `products_description` VALUES
(41, 1, '100% water/dust proof touch sensitive transparent universal', '', '<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Specifications of Jo Jo Pouch for Apple iPhone SE 64GB (White, Orange)</h3>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				GENERAL</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Brand</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Jo Jo</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Shade</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				White, Orange</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Material</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Artificial Leather</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Designed for</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Apple iPhone SE 64GB</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Model ID</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Jojo764859</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Color</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				White</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				DIMENSIONS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Weight</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				250 g</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Width x Height x Depth</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				20 x 9 x 2 cm</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				WARRANTY</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Warranty Summary</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				No Warranty</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				IN THE BOX</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Sales Package</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				1 Pouch COVER</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '', 17, '', '', '', ''),
(42, 1, 'ANT VR Headset (Black) for Lenovo vibe k5 k4 note', '', '<h3 class="sectionTitle" style="margin: 0px; padding: 7px 0px 10px; border-width: 2px 0px 0px; border-top-style: solid; border-top-color: rgb(51, 51, 51); font-stretch: inherit; font-size: 17px; line-height: inherit; font-family: Museo, Helvetica, arial, san-serif; vertical-align: baseline; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	Specifications of Fly Accessories Mini Mobile Holder</h3>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				GENERAL</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Brand</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Fly Accessories</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Foldable</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				No</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Model Number</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Mini</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Material</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Plastic</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Compatible With</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				IPhone 6, IPhone 6 Plus, IPhone 5, IPhone 5s, IPhone 5c, IPhone 4s, Moto X2, Samsung Galaxy, Samsung S5, Samsung S4, One Plus, Yureka, Micromax, Nokia, Motorola, Nexus, Xolo, Lava, Lenovo</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Color</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				Black</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable" style="margin: 0px 0px 30px; padding: 0px; border: 0px; font-stretch: inherit; font-size: 13px; line-height: 16.9px; font-family: arial, tahoma, verdana, sans-serif; vertical-align: baseline; border-collapse: collapse; border-spacing: 0px; width: 730px; color: rgb(51, 51, 51); background-color: rgb(255, 255, 255);">\r\n	<tbody style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<th class="groupHead" colspan="2" style="margin: 0px; padding: 6px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; text-transform: uppercase; background-color: rgb(242, 242, 242);">\r\n				DIMENSIONS</th>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Weight</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				100</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Height</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				9</td>\r\n		</tr>\r\n		<tr style="margin: 0px; padding: 0px; border: 0px; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: baseline;">\r\n			<td class="specsKey" style="margin: 0px; padding: 6px; border-top-width: 0px; border-left-width: 0px; border-right-style: solid; border-right-color: rgb(201, 201, 201); border-bottom-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top; width: 170px;">\r\n				Width</td>\r\n			<td class="specsValue" style="margin: 0px; padding: 6px; border-top-width: 0px; border-right-width: 0px; border-left-style: solid; border-bottom-color: rgb(201, 201, 201); border-left-color: rgb(201, 201, 201); font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; vertical-align: top;">\r\n				4</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '', 16, '', '', '', ''),
(43, 1, 'ASUS X555LA-XX172D 15.6-inch Laptop(core i3-4030 U/4GB/500GB/', '', '<h3 class="sectionTitle">\r\n	Specifications of Asus X555LA-XX172D Notebook (Core i3 4th Gen/ 4GB/ 500GB/ Free Dos) (9ONB0652-MO7120) (15.6 inch, Black, 2.3 kg)</h3>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Input</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Pointer Device</td>\r\n			<td class="specsValue">\r\n				Touchpad with Multi-touch Gesture Support</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Web Camera</td>\r\n			<td class="specsValue">\r\n				Yes</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Keyboard</td>\r\n			<td class="specsValue">\r\n				Chiclet Keyboard</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Power</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Power Supply</td>\r\n			<td class="specsValue">\r\n				65 W AC Adapter</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Battery Backup</td>\r\n			<td class="specsValue">\r\n				Upto 4 hours</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Battery Cell</td>\r\n			<td class="specsValue">\r\n				2 cell</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Warranty</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Warranty Summary</td>\r\n			<td class="specsValue">\r\n				1 Year of Warranty from Asus</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Display</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Resolution</td>\r\n			<td class="specsValue">\r\n				1366 X 768 pixel</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Screen Size</td>\r\n			<td class="specsValue">\r\n				15.6 inch</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Screen Type</td>\r\n			<td class="specsValue">\r\n				HD LED Display</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Communication</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Ethernet</td>\r\n			<td class="specsValue">\r\n				10/100/1000 BASE-T</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Bluetooth</td>\r\n			<td class="specsValue">\r\n				v4.0</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Wireless LAN</td>\r\n			<td class="specsValue">\r\n				IEEE 802.11b/g/n</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Ports/Slots</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Mic In</td>\r\n			<td class="specsValue">\r\n				Yes</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				VGA Port</td>\r\n			<td class="specsValue">\r\n				Yes</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Multi Card Slot</td>\r\n			<td class="specsValue">\r\n				Digital Media Reader</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				USB Port</td>\r\n			<td class="specsValue">\r\n				1 x USB 2.0, 2 x USB 3.0</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				HDMI Port</td>\r\n			<td class="specsValue">\r\n				Yes</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				RJ45 LAN</td>\r\n			<td class="specsValue">\r\n				Yes</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Other Ports</td>\r\n			<td class="specsValue">\r\n				1 x Headphone Jack / Microphone Jack</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Storage</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				HDD Capacity</td>\r\n			<td class="specsValue">\r\n				500 GB</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				RPM</td>\r\n			<td class="specsValue">\r\n				5400</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Hardware Interface</td>\r\n			<td class="specsValue">\r\n				SATA</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Security</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Lock Port</td>\r\n			<td class="specsValue">\r\n				Yes</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				General</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Brand</td>\r\n			<td class="specsValue">\r\n				Asus</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Part Number</td>\r\n			<td class="specsValue">\r\n				9ONB0652-MO7120</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Model ID</td>\r\n			<td class="specsValue">\r\n				X555LA-XX172D</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Lifestyle</td>\r\n			<td class="specsValue">\r\n				Performance</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Color</td>\r\n			<td class="specsValue">\r\n				Black</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Memory</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Expandable Memory</td>\r\n			<td class="specsValue">\r\n				Upto 8 GB</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				System Memory</td>\r\n			<td class="specsValue">\r\n				4 GB</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Memory Slots</td>\r\n			<td class="specsValue">\r\n				2 Slots</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Optical Disk Drive</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Optical Drive</td>\r\n			<td class="specsValue">\r\n				CD/DVD writer</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Machine Dimensions</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Weight</td>\r\n			<td class="specsValue">\r\n				2.3 kg</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Dimension</td>\r\n			<td class="specsValue">\r\n				382 x 256 x 25.8 mm</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Color</td>\r\n			<td class="specsValue">\r\n				Black</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Graphics</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Graphic Processor</td>\r\n			<td class="specsValue">\r\n				Intel HD Graphics 4400</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Audio</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Internal Mic</td>\r\n			<td class="specsValue">\r\n				Yes</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Sound</td>\r\n			<td class="specsValue">\r\n				HD Audio Solution, Stereo Speakers, Sound Technologies: SonicMaster</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Platform</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Operating System</td>\r\n			<td class="specsValue">\r\n				Free DOS</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				System Architecture</td>\r\n			<td class="specsValue">\r\n				64 bit</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				OS Architecture</td>\r\n			<td class="specsValue">\r\n				64 bit</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Processor</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Brand</td>\r\n			<td class="specsValue">\r\n				Intel</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Chipset</td>\r\n			<td class="specsValue">\r\n				HM87</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Cache</td>\r\n			<td class="specsValue">\r\n				3 MB</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Variant</td>\r\n			<td class="specsValue">\r\n				4030U</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Processor</td>\r\n			<td class="specsValue">\r\n				Core i3</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Clock Speed</td>\r\n			<td class="specsValue">\r\n				1.9 GHz</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				In the Box</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Sales Package</td>\r\n			<td class="specsValue">\r\n				Laptop, Battery, AC Adapter, User Guide</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<h2>\r\n	Asus X555LA-XX172D 15.6-inch Laptop Information</h2>\r\n<div class="secHeader">\r\n	<span>Technical Details</span></div>\r\n<table border="0" cellpadding="0" cellspacing="0">\r\n	<tbody>\r\n		<tr>\r\n			<td class="label">\r\n				Brand</td>\r\n			<td class="value">\r\n				Asus</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Colour</td>\r\n			<td class="value">\r\n				Silver Black</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Screen Size</td>\r\n			<td class="value">\r\n				15.6 Inches</td>\r\n		</tr>\r\n		<tr class="size-weight">\r\n			<td class="label">\r\n				Item Weight</td>\r\n			<td class="value">\r\n				2.4 Kg</td>\r\n		</tr>\r\n		<tr class="size-weight">\r\n			<td class="label">\r\n				Product Dimensions</td>\r\n			<td class="value">\r\n				50.6 x 30 x 6.4 cm</td>\r\n		</tr>\r\n		<tr class="item-model-number">\r\n			<td class="label">\r\n				Item model number</td>\r\n			<td class="value">\r\n				Asus X555LA-XX172D</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Processor Brand</td>\r\n			<td class="value">\r\n				Intel</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Processor Type</td>\r\n			<td class="value">\r\n				Core i3</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Processor Speed</td>\r\n			<td class="value">\r\n				1.9 GHz</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				RAM Size</td>\r\n			<td class="value">\r\n				4 GB</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Hard Drive Size</td>\r\n			<td class="value">\r\n				500 GB</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Hard Disk Technology</td>\r\n			<td class="value">\r\n				Mechanical Hard Drive</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Graphics Coprocessor</td>\r\n			<td class="value">\r\n				Intel Integrated Graphics</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Hardware Platform</td>\r\n			<td class="value">\r\n				Linux</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Operating System</td>\r\n			<td class="value">\r\n				DOS</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Average Battery Life (in hours)</td>\r\n			<td class="value">\r\n				5</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '', 19, '', '', '', '');
INSERT INTO `products_description` VALUES
(46, 1, 'Dell 3541 15.6-inch Laptop(A-Series-Quad-Core A6/4GB/500 GB HDD', '', '<div class="keyFeatures specSection viewmoreSpec " id="veiwMoreSpecifications">\r\n	<h3 class="sectionTitle">\r\n		Key Features of Dell Inspiron 15 3541 APU Quad Core A6 - (4 GB/500 GB HDD/Ubuntu/2 GB Graphics) Notebook 3541A645002BU</h3>\r\n	<ul class="keyFeaturesList">\r\n		<li>\r\n			APU Quad Core A6</li>\r\n		<li>\r\n			4 GB RAM</li>\r\n		<li>\r\n			500 GB HDD</li>\r\n		<li>\r\n			Ubuntu</li>\r\n	</ul>\r\n</div>\r\n<div class="hcross-reco">\r\n	<strong>Specifications of Dell Inspiron 15 3541 APU Quad Core A6 - (4 GB/500 GB HDD/Ubuntu/2 GB Graphics) Notebook 3541A645002BU (15.6 inch, Black, 2.4 kg)</strong></div>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Input</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Pointer Device</td>\r\n			<td class="specsValue">\r\n				Touchpad</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Web Camera</td>\r\n			<td class="specsValue">\r\n				HD Webcam</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Keyboard</td>\r\n			<td class="specsValue">\r\n				Standard Keyboard</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Power</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Power Supply</td>\r\n			<td class="specsValue">\r\n				65 W AC Adapter</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Battery Cell</td>\r\n			<td class="specsValue">\r\n				4 cell</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Warranty</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Warranty Summary</td>\r\n			<td class="specsValue">\r\n				To Check Warranty Status Please Visit - http://www.dell.com/support/home/in/en/indhs1/Products/?IsTag=True&amp;IsInvalidSelection=True</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Display</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Resolution</td>\r\n			<td class="specsValue">\r\n				1366 X 768 pixel</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Screen Size</td>\r\n			<td class="specsValue">\r\n				15.6 inch</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Screen Type</td>\r\n			<td class="specsValue">\r\n				HD LED Backlit Display with True Life</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Communication</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Ethernet</td>\r\n			<td class="specsValue">\r\n				10/100 Mbps</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Bluetooth</td>\r\n			<td class="specsValue">\r\n				v4.0</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Wireless LAN</td>\r\n			<td class="specsValue">\r\n				Dell Wireless - N 1705</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Ports/Slots</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Mic In</td>\r\n			<td class="specsValue">\r\n				Yes</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Multi Card Slot</td>\r\n			<td class="specsValue">\r\n				SD Card Reader</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				USB Port</td>\r\n			<td class="specsValue">\r\n				2 x USB 2.0, 1 x USB 3.0</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				RJ45 LAN</td>\r\n			<td class="specsValue">\r\n				Yes</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Storage</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				HDD Capacity</td>\r\n			<td class="specsValue">\r\n				500 GB</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				RPM</td>\r\n			<td class="specsValue">\r\n				5400</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Hardware Interface</td>\r\n			<td class="specsValue">\r\n				SATA</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				General</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Brand</td>\r\n			<td class="specsValue">\r\n				Dell</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Model Name</td>\r\n			<td class="specsValue">\r\n				Inspiron</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Series</td>\r\n			<td class="specsValue">\r\n				15</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Part Number</td>\r\n			<td class="specsValue">\r\n				3541A645002BU</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Model ID</td>\r\n			<td class="specsValue">\r\n				3541</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Lifestyle</td>\r\n			<td class="specsValue">\r\n				Entertainment</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Color</td>\r\n			<td class="specsValue">\r\n				Black</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Memory</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Expandable Memory</td>\r\n			<td class="specsValue">\r\n				Upto 8 GB</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				RAM Frequency</td>\r\n			<td class="specsValue">\r\n				1333 MHz</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				System Memory</td>\r\n			<td class="specsValue">\r\n				4 GB</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Optical Disk Drive</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Optical Drive</td>\r\n			<td class="specsValue">\r\n				CD/DVD writer</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Machine Dimensions</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Weight</td>\r\n			<td class="specsValue">\r\n				2.4 kg</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Dimension</td>\r\n			<td class="specsValue">\r\n				381.4 x 267.6 x 25.6 mm</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Color</td>\r\n			<td class="specsValue">\r\n				Black</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Graphics</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Dedicated Graphics Memory Capacity</td>\r\n			<td class="specsValue">\r\n				2 GB</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Graphic Processor</td>\r\n			<td class="specsValue">\r\n				AMD Radeon HD R5 M230</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Dedicated Graphics Memory Type</td>\r\n			<td class="specsValue">\r\n				DDR3</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Audio</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Internal Mic</td>\r\n			<td class="specsValue">\r\n				Yes</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Sound</td>\r\n			<td class="specsValue">\r\n				2 Tuned Speakers with Waves MaxxAudio</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Speakers</td>\r\n			<td class="specsValue">\r\n				Yes</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Platform</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Operating System</td>\r\n			<td class="specsValue">\r\n				Ubuntu</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Processor</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Brand</td>\r\n			<td class="specsValue">\r\n				AMD</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Variant</td>\r\n			<td class="specsValue">\r\n				A6-6310</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Processor</td>\r\n			<td class="specsValue">\r\n				APU Quad Core A6</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Clock Speed</td>\r\n			<td class="specsValue">\r\n				1.8 GHz to Turbo Boost upto&#65533;2.4 GHz</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				In the Box</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Sales Package</td>\r\n			<td class="specsValue">\r\n				Laptop, Battery, AC Adapter</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<h2>\r\n	Dell 3541 15.6-inch Laptop Information</h2>\r\n<div class="secHeader">\r\n	<strong><span>Technical Details</span></strong></div>\r\n<table border="0" cellpadding="0" cellspacing="0">\r\n	<tbody>\r\n		<tr>\r\n			<td class="label">\r\n				Brand</td>\r\n			<td class="value">\r\n				Dell</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Colour</td>\r\n			<td class="value">\r\n				Black</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Item Height</td>\r\n			<td class="value">\r\n				39 Millimeters</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Item Width</td>\r\n			<td class="value">\r\n				34 Centimeters</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Screen Size</td>\r\n			<td class="value">\r\n				15.6 Inches</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Notebook Display Technology</td>\r\n			<td class="value">\r\n				LED Backlit Display with HD</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Screen Resolution</td>\r\n			<td class="value">\r\n				1366*768</td>\r\n		</tr>\r\n		<tr class="size-weight">\r\n			<td class="label">\r\n				Item Weight</td>\r\n			<td class="value">\r\n				2.4 Kg</td>\r\n		</tr>\r\n		<tr class="size-weight">\r\n			<td class="label">\r\n				Product Dimensions</td>\r\n			<td class="value">\r\n				48 x 34 x 3.9 cm</td>\r\n		</tr>\r\n		<tr class="item-model-number">\r\n			<td class="label">\r\n				Item model number</td>\r\n			<td class="value">\r\n				Dell 3541</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Processor Brand</td>\r\n			<td class="value">\r\n				AMD</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Processor Type</td>\r\n			<td class="value">\r\n				A6-6310</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Processor Speed</td>\r\n			<td class="value">\r\n				1.8 GHz</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				RAM Size</td>\r\n			<td class="value">\r\n				4 GB</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Memory Technology</td>\r\n			<td class="value">\r\n				DDR3L</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Hard Drive Size</td>\r\n			<td class="value">\r\n				500 GB</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Hard Disk Technology</td>\r\n			<td class="value">\r\n				Mechanical Hard Drive</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Speaker Description</td>\r\n			<td class="value">\r\n				Built-In Speaker</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Graphics Coprocessor</td>\r\n			<td class="value">\r\n				ATI Radeon</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Graphics Card Description</td>\r\n			<td class="value">\r\n				ATI Radeon Graphics</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Wireless Type</td>\r\n			<td class="value">\r\n				802.11bgn</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Number of USB 2.0 Ports</td>\r\n			<td class="value">\r\n				2</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Number of USB 3.0 Ports</td>\r\n			<td class="value">\r\n				1</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Optical Drive Type</td>\r\n			<td class="value">\r\n				DVD/CD</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Hardware Platform</td>\r\n			<td class="value">\r\n				PC</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Operating System</td>\r\n			<td class="value">\r\n				Linux</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Average Battery Life (in hours)</td>\r\n			<td class="value">\r\n				4</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Number of Lithium Ion Cells</td>\r\n			<td class="value">\r\n				4</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="label">\r\n				Included Components</td>\r\n			<td class="value">\r\n				Laptop, Charger, Battery and User Manuals</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '', 10, '', '', '', ''),
(47, 1, 'Apple Macbook Pro MD101HN/A 13-inch Laptop', '', '<p>\r\n	<strong><u>Core i5/4GB/500GB/Mac OS Mavericks/intel HD Graphics),Silver.</u></strong></p>\r\n<h3 class="sectionTitle">\r\n	Specifications of Apple MD101HN/A Macbook Pro A1278 Core i5 - (4 GB/500 GB HDD/Mac OS) Notebook (13.3 inch, SIlver, 2.06 kg)</h3>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Input</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Pointer Device</td>\r\n			<td class="specsValue">\r\n				Multi-Touch trackpad for precise cursor control</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Web Camera</td>\r\n			<td class="specsValue">\r\n				720p FaceTime HD Camera</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Keyboard</td>\r\n			<td class="specsValue">\r\n				Full-size Backlit Keyboard</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Power</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Power Supply</td>\r\n			<td class="specsValue">\r\n				60W MagSafe Power Adapter</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Battery Backup</td>\r\n			<td class="specsValue">\r\n				Up to 7 hours</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Warranty</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Warranty Summary</td>\r\n			<td class="specsValue">\r\n				1 Year manufacturer warranty</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Display</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Resolution</td>\r\n			<td class="specsValue">\r\n				1280 x 800 pixels</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Screen Size</td>\r\n			<td class="specsValue">\r\n				13.3 inch</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Screen Type</td>\r\n			<td class="specsValue">\r\n				HD LED Backlit Glossy Widescreen Display</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Communication</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Ethernet</td>\r\n			<td class="specsValue">\r\n				10/100/1000BASE-T Gigabit Ethernet</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Bluetooth</td>\r\n			<td class="specsValue">\r\n				v4.0</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Wireless LAN</td>\r\n			<td class="specsValue">\r\n				IEEE 802.11a/b/g/n</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Ports/Slots</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Mic In</td>\r\n			<td class="specsValue">\r\n				Yes</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Multi Card Slot</td>\r\n			<td class="specsValue">\r\n				SDXC Card Slot</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				USB Port</td>\r\n			<td class="specsValue">\r\n				2 x USB 3.0</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				HDMI Port</td>\r\n			<td class="specsValue">\r\n				Yes</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Other Ports</td>\r\n			<td class="specsValue">\r\n				Thunderbolt Port, 3.5 mm Headphone Jack, Lithium Polymer Battery</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Firewire Port</td>\r\n			<td class="specsValue">\r\n				Yes</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Storage</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				HDD Capacity</td>\r\n			<td class="specsValue">\r\n				500 GB</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				RPM</td>\r\n			<td class="specsValue">\r\n				5400</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Security</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Lock Port</td>\r\n			<td class="specsValue">\r\n				Kensington Lock Slot</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				General</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Brand</td>\r\n			<td class="specsValue">\r\n				Apple</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Model Name</td>\r\n			<td class="specsValue">\r\n				MD101HN/A</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Series</td>\r\n			<td class="specsValue">\r\n				Macbook Pro</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Model ID</td>\r\n			<td class="specsValue">\r\n				A1278</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Color</td>\r\n			<td class="specsValue">\r\n				SIlver</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Memory</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				RAM Frequency</td>\r\n			<td class="specsValue">\r\n				1600 MHz</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				System Memory</td>\r\n			<td class="specsValue">\r\n				4 GB</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Machine Dimensions</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Weight</td>\r\n			<td class="specsValue">\r\n				2.06 kg</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Dimension</td>\r\n			<td class="specsValue">\r\n				325 x 227 x 24.1 mm</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Color</td>\r\n			<td class="specsValue">\r\n				SIlver</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Graphics</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Graphic Processor</td>\r\n			<td class="specsValue">\r\n				Intel HD Graphics 4000</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Audio</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Internal Mic</td>\r\n			<td class="specsValue">\r\n				Dual Microphones</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Sound</td>\r\n			<td class="specsValue">\r\n				Stereo Speakers with Subwoofer</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Speakers</td>\r\n			<td class="specsValue">\r\n				Yes</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Platform</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Operating System</td>\r\n			<td class="specsValue">\r\n				Mac OS X El Capitan</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Processor</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Brand</td>\r\n			<td class="specsValue">\r\n				Intel</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Cache</td>\r\n			<td class="specsValue">\r\n				3 MB</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Variant</td>\r\n			<td class="specsValue">\r\n				3210M</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Processor</td>\r\n			<td class="specsValue">\r\n				Core i5</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Clock Speed</td>\r\n			<td class="specsValue">\r\n				2.5 GHz Turbo boost upto 3.1 Ghz</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				In the Box</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Sales Package</td>\r\n			<td class="specsValue">\r\n				MacBook Pro, AC Wall Plug, Power Lead, Magsafe 2 Power Adapter</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '', 16, '', '', '', ''),
(48, 1, 'Apple Macbook Air MJVE2HN/A 13-inch Laptop', '', '<h3 class="sectionTitle">\r\n	Specifications of Apple MacBook Air MJVG2HN/A Core i5 - (4 GB/256 GB SSD/Mac OS) Ultrabook MJVG2HN/A (13.17 inch, SIlver, 1.35 kg)</h3>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Software</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Included Software</td>\r\n			<td class="specsValue">\r\n				iPhoto, iMovie, GarageBand, Pages, Numbers, Keynote, Maps, iBooks, Safari, Mail, FaceTime, Messages, Calendar, Contacts, Reminders, Time Machine, Photo Booth, iTunes, Game Center, Preview, Notes, Mac App Store</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Input</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Pointer Device</td>\r\n			<td class="specsValue">\r\n				Multi-touch Trackpad (Scrolling, Pinch, Rotate, Swipe, Three-finger Swipe, Four-finger Swipe, Tap, Double-tap and Drag Capabilities)</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Keyboard</td>\r\n			<td class="specsValue">\r\n				Full-size Backlit Keyboard with Ambient Light Sensor</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Web Camera</td>\r\n			<td class="specsValue">\r\n				FaceTime HD Webcam</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Power</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Power Supply</td>\r\n			<td class="specsValue">\r\n				45 W MagSafe 2 Power Adapter</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Battery Backup</td>\r\n			<td class="specsValue">\r\n				Upto 12 hours</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Warranty</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Warranty Summary</td>\r\n			<td class="specsValue">\r\n				1 Year Limited Warranty from Apple</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Display</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Resolution</td>\r\n			<td class="specsValue">\r\n				1440 X 900 pixel</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Screen Size</td>\r\n			<td class="specsValue">\r\n				13.17 inch</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Screen Type</td>\r\n			<td class="specsValue">\r\n				LED Backlit Glossy Wide Screen Display with Support for Millions of Colors</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Communication</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Bluetooth</td>\r\n			<td class="specsValue">\r\n				v4.0</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Wireless LAN</td>\r\n			<td class="specsValue">\r\n				IEEE 802.11a/b/g/n/ac</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Ports/Slots</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Mic In</td>\r\n			<td class="specsValue">\r\n				Yes</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Multi Card Slot</td>\r\n			<td class="specsValue">\r\n				SDXC Card Slot</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				VGA Port</td>\r\n			<td class="specsValue">\r\n				Yes</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				USB Port</td>\r\n			<td class="specsValue">\r\n				2 x USB 3.0</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Other Ports</td>\r\n			<td class="specsValue">\r\n				1 x Headphone Port, 1 x Thunderbolt 2 Port, MagSafe 2 Power Port, Support for Apple iPhone Headset with Remote and Microphone</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Storage</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				SSD Capacity</td>\r\n			<td class="specsValue">\r\n				Yes, 256 GB</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				General</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Brand</td>\r\n			<td class="specsValue">\r\n				Apple</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Model Name</td>\r\n			<td class="specsValue">\r\n				MacBook Air</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Part Number</td>\r\n			<td class="specsValue">\r\n				MJVG2HN/A</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Model ID</td>\r\n			<td class="specsValue">\r\n				MJVG2HN/A</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Color</td>\r\n			<td class="specsValue">\r\n				SIlver</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Lifestyle</td>\r\n			<td class="specsValue">\r\n				Everyday Use</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Memory</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				RAM Frequency</td>\r\n			<td class="specsValue">\r\n				1600 MHz</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				System Memory</td>\r\n			<td class="specsValue">\r\n				4 GB</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Memory Slots</td>\r\n			<td class="specsValue">\r\n				1 Slot</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Machine Dimensions</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Weight</td>\r\n			<td class="specsValue">\r\n				1.35 kg</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Dimension</td>\r\n			<td class="specsValue">\r\n				325 x 227 x 17 mm</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Color</td>\r\n			<td class="specsValue">\r\n				SIlver</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Graphics</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Graphic Processor</td>\r\n			<td class="specsValue">\r\n				Intel HD Graphics 6000</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Audio</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Internal Mic</td>\r\n			<td class="specsValue">\r\n				Dual Microphones</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Sound</td>\r\n			<td class="specsValue">\r\n				Stereo speakers</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Speakers</td>\r\n			<td class="specsValue">\r\n				Yes</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Platform</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Operating System</td>\r\n			<td class="specsValue">\r\n				Mac OS X Yosemite</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				System Architecture</td>\r\n			<td class="specsValue">\r\n				64 bit</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				In the Box</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Sales Package</td>\r\n			<td class="specsValue">\r\n				MacBook Air, Power Adapter, AC Wall Plug and Power Lead</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table cellspacing="0" class="specTable">\r\n	<tbody>\r\n		<tr>\r\n			<th class="groupHead" colspan="2">\r\n				Processor</th>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Brand</td>\r\n			<td class="specsValue">\r\n				Intel</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Chipset</td>\r\n			<td class="specsValue">\r\n				Z77 Express</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Cache</td>\r\n			<td class="specsValue">\r\n				6 MB</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Variant</td>\r\n			<td class="specsValue">\r\n				3330S</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Clock Speed</td>\r\n			<td class="specsValue">\r\n				2.7 GHz With Turbo Boost Upto 3.2 GHz</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="specsKey">\r\n				Processor</td>\r\n			<td class="specsValue">\r\n				Core i5</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<hr class="bucketDivider" noshade="noshade" size="1" />\r\n<h2>\r\n	Apple MacBook Air MJVE2HN/A 13-inch Laptop Information</h2>\r\n<div class="disclaim">\r\n	Size: <strong>128GB</strong></div>\r\n<div class="wrapper INlocale">\r\n	<div class="column col1 ">\r\n		<div class="section techD">\r\n			<div class="secHeader">\r\n				<span>Technical Details</span></div>\r\n			<div class="content pdClearfix">\r\n				<div class="attrG" style="border:none">\r\n					<div class="pdTab" style="display:block;">\r\n						<table border="0" cellpadding="0" cellspacing="0">\r\n							<tbody>\r\n								<tr>\r\n									<td class="label">\r\n										Brand</td>\r\n									<td class="value">\r\n										Apple</td>\r\n								</tr>\r\n								<tr>\r\n									<td class="label">\r\n										Item Height</td>\r\n									<td class="value">\r\n										12.3 Centimeters</td>\r\n								</tr>\r\n								<tr>\r\n									<td class="label">\r\n										Item Width</td>\r\n									<td class="value">\r\n										34.1 Centimeters</td>\r\n								</tr>\r\n								<tr>\r\n									<td class="label">\r\n										Screen Size</td>\r\n									<td class="value">\r\n										13 Inches</td>\r\n								</tr>\r\n								<tr class="size-weight">\r\n									<td class="label">\r\n										Item Weight</td>\r\n									<td class="value">\r\n										1.4 Kg</td>\r\n								</tr>\r\n								<tr class="size-weight">\r\n									<td class="label">\r\n										Product Dimensions</td>\r\n									<td class="value">\r\n										44.6 x 34.1 x 12.3 cm</td>\r\n								</tr>\r\n								<tr class="item-model-number">\r\n									<td class="label">\r\n										Item model number</td>\r\n									<td class="value">\r\n										MJVE2HN/A</td>\r\n								</tr>\r\n								<tr>\r\n									<td class="label">\r\n										Processor Brand</td>\r\n									<td class="value">\r\n										Intel</td>\r\n								</tr>\r\n								<tr>\r\n									<td class="label">\r\n										Processor Type</td>\r\n									<td class="value">\r\n										Core i5</td>\r\n								</tr>\r\n								<tr>\r\n									<td class="label">\r\n										Processor Speed</td>\r\n									<td class="value">\r\n										1.6 GHz</td>\r\n								</tr>\r\n								<tr>\r\n									<td class="label">\r\n										RAM Size</td>\r\n									<td class="value">\r\n										4 GB</td>\r\n								</tr>\r\n								<tr>\r\n									<td class="label">\r\n										Hard Drive Size</td>\r\n									<td class="value">\r\n										128 GB</td>\r\n								</tr>\r\n								<tr>\r\n									<td class="label">\r\n										Hard Disk Technology</td>\r\n									<td class="value">\r\n										Solid State Drive</td>\r\n								</tr>\r\n								<tr>\r\n									<td class="label">\r\n										Graphics Coprocessor</td>\r\n									<td class="value">\r\n										Intel Integrated Graphics</td>\r\n								</tr>\r\n								<tr>\r\n									<td class="label">\r\n										Graphics Card Description</td>\r\n									<td class="value">\r\n										Integrated Graphics Card</td>\r\n								</tr>\r\n								<tr>\r\n									<td class="label">\r\n										Hardware Platform</td>\r\n									<td class="value">\r\n										Mac</td>\r\n								</tr>\r\n								<tr>\r\n									<td class="label">\r\n										Operating System</td>\r\n									<td class="value">\r\n										Mac OS</td>\r\n								</tr>\r\n								<tr>\r\n									<td class="label">\r\n										Average Battery Life (in hours)</td>\r\n									<td class="value">\r\n										9</td>\r\n								</tr>\r\n								<tr>\r\n									<td class="lAttr">\r\n										&nbsp;</td>\r\n									<td class="lAttr">\r\n										&nbsp;</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '', 32, '', '', '', ''),
(49, 1, 'Canon PowerShot - Digitek Five in One Digital Care', NULL, 'Digitek Five in One Digital Care', NULL, 0, NULL, '', '', ''),
(50, 1, 'Canon PowerShot - JJC Camera Lens Cleaning Kit CL-3D', NULL, 'JJC Camera Lens Cleaning Kit CL-3D', NULL, 0, NULL, '', '', ''),
(51, 1, 'Moto X Play(With Turbo Charger) - Turbo Charger', NULL, 'Turbo Charger', NULL, 0, NULL, '', '', ''),
(52, 1, 'Moto X Play(With Turbo Charger) - Cleaner', NULL, 'Cleaner', NULL, 0, NULL, '', '', ''),
(53, 1, 'Moto X Play(With Turbo Charger) - Cover', NULL, 'Cover', NULL, 0, NULL, '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `products_extra_fields`
--

CREATE TABLE `products_extra_fields` (
  `products_extra_fields_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_extra_fields_name` varchar(255) NOT NULL DEFAULT '',
  `products_extra_fields_order` int(3) NOT NULL DEFAULT '0',
  `products_extra_fields_status` tinyint(1) NOT NULL DEFAULT '0',
  `languages_id` int(11) NOT NULL DEFAULT '0',
  `products_extra_fields_type` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`products_extra_fields_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `products_extra_fields_values`
--

CREATE TABLE `products_extra_fields_values` (
  `pe_value_id` int(11) NOT NULL AUTO_INCREMENT,
  `pe_id` int(11) NOT NULL DEFAULT '0',
  `pe_text` varchar(255) NOT NULL,
  `pe_value` varchar(255) NOT NULL,
  `pe_sortorder` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pe_value_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `products_notifications`
--

CREATE TABLE `products_notifications` (
  `products_id` int(11) NOT NULL DEFAULT '0',
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`products_id`,`customers_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `products_options`
--

CREATE TABLE `products_options` (
  `products_options_id` int(11) NOT NULL DEFAULT '0',
  `products_options_sort_order` smallint(3) unsigned NOT NULL DEFAULT '9999',
  `options_type` int(5) NOT NULL DEFAULT '0',
  `options_length` smallint(2) NOT NULL DEFAULT '32',
  `options_date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `options_last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`products_options_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `products_options`
--

INSERT INTO `products_options` VALUES
(1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(2, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `products_options_text`
--

CREATE TABLE `products_options_text` (
  `products_options_text_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_options_name` varchar(100) NOT NULL DEFAULT '',
  `products_options_instruct` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`products_options_text_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `products_options_text`
--

INSERT INTO `products_options_text` VALUES
(1, 1, 'Color', ''),
(2, 1, 'Size', '');

-- --------------------------------------------------------

--
-- Table structure for table `products_options_validation`
--

CREATE TABLE `products_options_validation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `option_id` int(11) NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `products_options_values`
--

CREATE TABLE `products_options_values` (
  `products_options_values_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_options_values_name` varchar(255) NOT NULL DEFAULT '',
  `options_values_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  PRIMARY KEY (`products_options_values_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `products_options_values`
--

INSERT INTO `products_options_values` VALUES
(1, 1, 'Black', 0.0000),
(2, 1, 'Red', 0.0000),
(3, 1, 'White', 0.0000),
(4, 1, 'Large', 0.0000),
(5, 1, 'Medium', 0.0000),
(6, 1, 'Extra Large', 0.0000);

-- --------------------------------------------------------

--
-- Table structure for table `products_options_values_to_products_options`
--

CREATE TABLE `products_options_values_to_products_options` (
  `products_options_values_to_products_options_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_options_id` int(11) NOT NULL DEFAULT '0',
  `products_options_values_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`products_options_values_to_products_options_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `products_options_values_to_products_options`
--

INSERT INTO `products_options_values_to_products_options` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 2, 4),
(5, 2, 5),
(6, 2, 6);

-- --------------------------------------------------------

--
-- Table structure for table `products_to_categories`
--

CREATE TABLE `products_to_categories` (
  `products_id` int(11) NOT NULL DEFAULT '0',
  `categories_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`products_id`,`categories_id`),
  KEY `idx_categories_id` (`categories_id`,`products_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `products_to_categories`
--

INSERT INTO `products_to_categories` VALUES
(1, 1, 0),
(2, 1, 0),
(3, 1, 0),
(4, 1, 0),
(5, 4, 0),
(6, 4, 0),
(7, 1, 0),
(8, 4, 0),
(9, 1, 0),
(12, 2, 0),
(14, 2, 0),
(15, 2, 0),
(16, 2, 0),
(17, 2, 0),
(18, 2, 0),
(20, 5, 0),
(21, 5, 0),
(23, 8, 0),
(24, 8, 0),
(25, 8, 0),
(26, 8, 0),
(27, 8, 0),
(28, 8, 0),
(29, 9, 0),
(30, 9, 0),
(31, 9, 0),
(32, 9, 0),
(33, 9, 0),
(34, 9, 0),
(35, 9, 0),
(36, 5, 0),
(37, 5, 0),
(38, 5, 0),
(39, 5, 0),
(40, 4, 0),
(41, 4, 0),
(42, 4, 0),
(43, 6, 0),
(44, 6, 0),
(45, 6, 0),
(46, 6, 0),
(47, 6, 0),
(48, 6, 0),
(49, 1, 0),
(50, 1, 0),
(51, 2, 0),
(52, 2, 0),
(53, 2, 0);

-- --------------------------------------------------------

--
-- Table structure for table `products_to_products_extra_fields`
--

CREATE TABLE `products_to_products_extra_fields` (
  `products_id` int(11) NOT NULL DEFAULT '0',
  `products_extra_fields_id` int(11) NOT NULL DEFAULT '0',
  `products_extra_fields_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`products_id`,`products_extra_fields_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `products_xsell`
--

CREATE TABLE `products_xsell` (
  `ID` int(10) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL DEFAULT '0',
  `xsell_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` smallint(3) unsigned NOT NULL DEFAULT '9999',
  PRIMARY KEY (`ID`),
  KEY `idx_products_id` (`products_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `products_xsell`
--

INSERT INTO `products_xsell` VALUES
(1, 21, 1, 1),
(2, 21, 2, 2),
(3, 21, 3, 3),
(4, 21, 4, 4),
(5, 21, 5, 5);

-- --------------------------------------------------------

--
-- Table structure for table `reviews`
--

CREATE TABLE `reviews` (
  `reviews_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL DEFAULT '0',
  `customers_id` int(11) DEFAULT NULL,
  `customers_name` varchar(255) NOT NULL DEFAULT '',
  `reviews_rating` int(1) DEFAULT NULL,
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reviews_read` int(5) NOT NULL DEFAULT '0',
  `customers_email` varchar(255) NOT NULL DEFAULT '',
  `isapproved` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`reviews_id`),
  KEY `idx_products_id` (`products_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `reviews_description`
--

CREATE TABLE `reviews_description` (
  `reviews_id` int(11) NOT NULL DEFAULT '0',
  `languages_id` int(11) NOT NULL DEFAULT '0',
  `reviews_text` text NOT NULL,
  PRIMARY KEY (`reviews_id`,`languages_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sessions`
--

CREATE TABLE `sessions` (
  `sesskey` varchar(255) NOT NULL DEFAULT '',
  `expiry` int(11) unsigned NOT NULL DEFAULT '0',
  `value` mediumtext NOT NULL,
  PRIMARY KEY (`sesskey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `specials`
--

CREATE TABLE `specials` (
  `specials_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL DEFAULT '0',
  `special_percentage` decimal(15,2) NOT NULL DEFAULT '0.00',
  `specials_new_products_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `specials_date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `specials_last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_status_change` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `specials_sort` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`specials_id`),
  KEY `idx_products_id` (`products_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `specials`
--

INSERT INTO `specials` VALUES
(2, 41, 0.00, 20.0000, '2018-09-01 06:03:29', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(3, 21, 0.00, 300.0000, '2018-09-01 06:03:38', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(4, 50, 0.00, 55.0000, '2018-09-01 06:03:50', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(5, 46, 0.00, 300.0000, '2018-09-01 06:04:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(6, 45, 0.00, 100.0000, '2018-09-01 06:04:10', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `tax_class`
--

CREATE TABLE `tax_class` (
  `tax_class_id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_class_title` varchar(100) NOT NULL DEFAULT '',
  `tax_class_description` varchar(255) NOT NULL DEFAULT '',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`tax_class_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tax_rates`
--

CREATE TABLE `tax_rates` (
  `tax_rates_id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_zone_id` int(11) NOT NULL DEFAULT '0',
  `tax_class_id` int(11) NOT NULL DEFAULT '0',
  `tax_priority` int(5) DEFAULT '1',
  `tax_rate` decimal(7,4) NOT NULL DEFAULT '0.0000',
  `tax_description` varchar(255) NOT NULL DEFAULT '',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`tax_rates_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `template`
--

CREATE TABLE `template` (
  `template_id` int(11) NOT NULL AUTO_INCREMENT,
  `template_name` varchar(255) NOT NULL DEFAULT '',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `template_image` varchar(255) DEFAULT NULL,
  `template_cellpadding_main` char(3) NOT NULL DEFAULT '0',
  `template_cellpadding_sub` char(3) NOT NULL DEFAULT '0',
  `template_cellpadding_left` char(3) NOT NULL DEFAULT '0',
  `template_cellpadding_right` char(3) NOT NULL DEFAULT '0',
  `site_width` varchar(5) NOT NULL DEFAULT '100%',
  `include_column_left` varchar(255) NOT NULL DEFAULT 'yes',
  `include_column_right` varchar(255) NOT NULL DEFAULT 'yes',
  `box_width_left` varchar(4) NOT NULL DEFAULT '125',
  `box_width_right` varchar(4) NOT NULL DEFAULT '125',
  `main_table_border` varchar(6) NOT NULL DEFAULT 'no',
  `active` char(1) NOT NULL DEFAULT '1',
  `show_heading_title_original` varchar(6) NOT NULL DEFAULT 'yes',
  `languages_in_header` char(3) DEFAULT 'no',
  `cart_in_header` char(3) NOT NULL DEFAULT 'no',
  `show_header_link_buttons` char(3) NOT NULL DEFAULT 'no',
  `module_one` varchar(255) NOT NULL DEFAULT '',
  `module_two` varchar(255) NOT NULL DEFAULT '',
  `module_three` varchar(255) NOT NULL DEFAULT '',
  `module_four` varchar(255) NOT NULL DEFAULT '',
  `module_five` varchar(255) NOT NULL DEFAULT '',
  `module_six` varchar(255) NOT NULL DEFAULT '',
  `customer_greeting` char(3) NOT NULL DEFAULT 'yes',
  `edit_customer_greeting_personal` text NOT NULL,
  `edit_customer_greeting_personal_relogon` text NOT NULL,
  `edit_greeting_guest` text NOT NULL,
  `side_box_left_width` int(10) DEFAULT '1',
  `side_box_right_width` int(10) DEFAULT '1',
  PRIMARY KEY (`template_id`),
  KEY `IDX_TEMPLATE_NAME` (`template_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `template`
--

INSERT INTO `template` VALUES
(1, 'sevenofsix', '[[regtime]]', '0000-00-00 00:00:00', 'sevenofsix.gif', '0', '5', '0', '0', '980', 'yes', 'yes', '2', '2', 'yes', '1', 'yes', 'no', 'no', 'yes', 'banner_slider.php', 'main_categories.php', 'new_products.php', '', '', '', 'yes', '', '', '', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `topics`
--

CREATE TABLE `topics` (
  `topics_id` int(11) NOT NULL AUTO_INCREMENT,
  `topics_image` varchar(255) DEFAULT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` smallint(3) unsigned NOT NULL DEFAULT '9999',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`topics_id`),
  KEY `idx_topics_parent_id` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `topics`
--

INSERT INTO `topics` VALUES
(1, NULL, 0, 10, '2011-09-11 02:00:33', '0000-00-00 00:00:00'),
(2, NULL, 0, 20, '2011-09-11 02:01:47', '2011-09-11 02:01:58'),
(3, NULL, 0, 30, '2011-09-11 02:02:40', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `topics_description`
--

CREATE TABLE `topics_description` (
  `topics_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `topics_name` varchar(255) NOT NULL DEFAULT '',
  `topics_heading_title` varchar(255) DEFAULT NULL,
  `topics_description` text,
  PRIMARY KEY (`topics_id`,`language_id`),
  KEY `idx_topics_name` (`topics_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `topics_description`
--

INSERT INTO `topics_description` VALUES
(1, 1, 'Mauris quis turpis vitae', 'In fringilla purus mauris a nunc.', '<p>\r\n  Curabitur consequat, lectus sit amet luctus vulputate, nisi euismod et, commodo at, libero. Morbi accumsan laoreet ipsum.</p>'),
(2, 1, 'Quisque ac libero nec', 'Etiam bibendum fermentum metus aenean sed pede nec', '<p>\r\n  Duis iaculis enim, sit amet ornare lectus justo eu arcu. Morbi sit amet massa. Quisque porttitor eros nec tellus. Nunc lectus pede, ultrices a, auctor non, feugiat nec, diam.</p>'),
(3, 1, 'Etiam vestibulum', 'En sociis natoque penatibus et magnis dis parturient', '<p>\r\n  Vestibulum ut dictum augue malesuada malesuada. Integer id magna et ipsum cursus vestibulum. Mauris magna. Duis dignissim tempor arcu.</p>');

-- --------------------------------------------------------

--
-- Table structure for table `transaction_log`
--

CREATE TABLE `transaction_log` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(128) NOT NULL DEFAULT '',
  `transaction_id` varchar(255) NOT NULL DEFAULT '',
  `order_id` int(11) NOT NULL DEFAULT '0',
  `created_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`,`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `visual_verify_code`
--

CREATE TABLE `visual_verify_code` (
  `oscsid` varchar(255) NOT NULL DEFAULT '',
  `code` varchar(6) NOT NULL DEFAULT '',
  `dt` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`oscsid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `whos_online`
--

CREATE TABLE `whos_online` (
  `customer_id` int(11) DEFAULT NULL,
  `full_name` varchar(255) NOT NULL DEFAULT '',
  `session_id` varchar(128) NOT NULL DEFAULT '',
  `ip_address` varchar(15) NOT NULL DEFAULT '',
  `time_entry` varchar(14) NOT NULL DEFAULT '',
  `time_last_click` varchar(14) NOT NULL DEFAULT '',
  `last_page_url` varchar(255) NOT NULL DEFAULT '',
  `http_referer` varchar(255) NOT NULL DEFAULT '',
  `user_agent` varchar(255) NOT NULL DEFAULT '',
  KEY `idx_customer_ID` (`customer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `zones`
--

CREATE TABLE `zones` (
  `zone_id` int(11) NOT NULL AUTO_INCREMENT,
  `zone_country_id` int(11) NOT NULL DEFAULT '0',
  `zone_code` varchar(100) NOT NULL DEFAULT '',
  `zone_name` varchar(100) NOT NULL DEFAULT '',
  `zone_status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=549 ;

--
-- Dumping data for table `zones`
--

INSERT INTO `zones` VALUES
(1, 223, 'AL', 'Alabama', 1),
(2, 223, 'AK', 'Alaska', 1),
(3, 223, 'AS', 'American Samoa', 1),
(4, 223, 'AZ', 'Arizona', 1),
(5, 223, 'AR', 'Arkansas', 1),
(6, 223, 'AF', 'Armed Forces Africa', 1),
(7, 223, 'AA', 'Armed Forces Americas', 1),
(8, 223, 'AC', 'Armed Forces Canada', 1),
(9, 223, 'AE', 'Armed Forces Europe', 1),
(10, 223, 'AM', 'Armed Forces Middle East', 1),
(11, 223, 'AP', 'Armed Forces Pacific', 1),
(12, 223, 'CA', 'California', 1),
(13, 223, 'CO', 'Colorado', 1),
(14, 223, 'CT', 'Connecticut', 1),
(15, 223, 'DE', 'Delaware', 1),
(16, 223, 'DC', 'District of Columbia', 1),
(17, 223, 'FM', 'Federated States Of Micronesia', 1),
(18, 223, 'FL', 'Florida', 1),
(19, 223, 'GA', 'Georgia', 1),
(20, 223, 'GU', 'Guam', 1),
(21, 223, 'HI', 'Hawaii', 1),
(22, 223, 'ID', 'Idaho', 1),
(23, 223, 'IL', 'Illinois', 1),
(24, 223, 'IN', 'Indiana', 1),
(25, 223, 'IA', 'Iowa', 1),
(26, 223, 'KS', 'Kansas', 1),
(27, 223, 'KY', 'Kentucky', 1),
(28, 223, 'LA', 'Louisiana', 1),
(29, 223, 'ME', 'Maine', 1),
(30, 223, 'MH', 'Marshall Islands', 1),
(31, 223, 'MD', 'Maryland', 1),
(32, 223, 'MA', 'Massachusetts', 1),
(33, 223, 'MI', 'Michigan', 1),
(34, 223, 'MN', 'Minnesota', 1),
(35, 223, 'MS', 'Mississippi', 1),
(36, 223, 'MO', 'Missouri', 1),
(37, 223, 'MT', 'Montana', 1),
(38, 223, 'NE', 'Nebraska', 1),
(39, 223, 'NV', 'Nevada', 1),
(40, 223, 'NH', 'New Hampshire', 1),
(41, 223, 'NJ', 'New Jersey', 1),
(42, 223, 'NM', 'New Mexico', 1),
(43, 223, 'NY', 'New York', 1),
(44, 223, 'NC', 'North Carolina', 1),
(45, 223, 'ND', 'North Dakota', 1),
(46, 223, 'MP', 'Northern Mariana Islands', 1),
(47, 223, 'OH', 'Ohio', 1),
(48, 223, 'OK', 'Oklahoma', 1),
(49, 223, 'OR', 'Oregon', 1),
(50, 223, 'PW', 'Palau', 1),
(51, 223, 'PA', 'Pennsylvania', 1),
(52, 223, 'PR', 'Puerto Rico', 1),
(53, 223, 'RI', 'Rhode Island', 1),
(54, 223, 'SC', 'South Carolina', 1),
(55, 223, 'SD', 'South Dakota', 1),
(56, 223, 'TN', 'Tennessee', 1),
(57, 223, 'TX', 'Texas', 1),
(58, 223, 'UT', 'Utah', 1),
(59, 223, 'VT', 'Vermont', 1),
(60, 223, 'VI', 'Virgin Islands', 1),
(61, 223, 'VA', 'Virginia', 1),
(62, 223, 'WA', 'Washington', 1),
(63, 223, 'WV', 'West Virginia', 1),
(64, 223, 'WI', 'Wisconsin', 1),
(65, 223, 'WY', 'Wyoming', 1),
(66, 38, 'AB', 'Alberta', 1),
(67, 38, 'BC', 'British Columbia', 1),
(68, 38, 'MB', 'Manitoba', 1),
(69, 38, 'NF', 'Newfoundland', 1),
(70, 38, 'NB', 'New Brunswick', 1),
(71, 38, 'NS', 'Nova Scotia', 1),
(72, 38, 'NT', 'Northwest Territories', 1),
(73, 38, 'NU', 'Nunavut', 1),
(74, 38, 'ON', 'Ontario', 1),
(75, 38, 'PE', 'Prince Edward Island', 1),
(76, 38, 'QC', 'Quebec', 1),
(77, 38, 'SK', 'Saskatchewan', 1),
(78, 38, 'YT', 'Yukon Territory', 1),
(79, 81, 'NDS', 'Niedersachsen', 1),
(80, 81, 'BAW', 'Baden-W&uuml;rttemberg', 1),
(81, 81, 'BAY', 'Bayern', 1),
(82, 81, 'BER', 'Berlin', 1),
(83, 81, 'BRG', 'Brandenburg', 1),
(84, 81, 'BRE', 'Bremen', 1),
(85, 81, 'HAM', 'Hamburg', 1),
(86, 81, 'HES', 'Hessen', 1),
(87, 81, 'MEC', 'Mecklenburg-Vorpommern', 1),
(88, 81, 'NRW', 'Nordrhein-Westfalen', 1),
(89, 81, 'RHE', 'Rheinland-Pfalz', 1),
(90, 81, 'SAR', 'Saarland', 1),
(91, 81, 'SAS', 'Sachsen', 1),
(92, 81, 'SAC', 'Sachsen-Anhalt', 1),
(93, 81, 'SCN', 'Schleswig-Holstein', 1),
(94, 81, 'THE', 'Th&uuml;ringen', 1),
(95, 14, 'WI', 'Wien', 1),
(96, 14, 'NO', 'Nieder&ouml;sterreich', 1),
(97, 14, 'OO', 'Ober&ouml;sterreich', 1),
(98, 14, 'SB', 'Salzburg', 1),
(99, 14, 'KN', 'K&auml;rnten', 1),
(100, 14, 'ST', 'Steiermark', 1),
(101, 14, 'TI', 'Tirol', 1),
(102, 14, 'BL', 'Burgenland', 1),
(103, 14, 'VB', 'Voralberg', 1),
(104, 204, 'AG', 'Aargau', 1),
(105, 204, 'AI', 'Appenzell Innerrhoden', 1),
(106, 204, 'AR', 'Appenzell Ausserrhoden', 1),
(107, 204, 'BE', 'Bern', 1),
(108, 204, 'BL', 'Basel-Landschaft', 1),
(109, 204, 'BS', 'Basel-Stadt', 1),
(110, 204, 'FR', 'Freiburg', 1),
(111, 204, 'GE', 'Genf', 1),
(112, 204, 'GL', 'Glarus', 1),
(113, 204, 'JU', 'Graub&uuml;nden', 1),
(114, 204, 'JU', 'Jura', 1),
(115, 204, 'LU', 'Luzern', 1),
(116, 204, 'NE', 'Neuenburg', 1),
(117, 204, 'NW', 'Nidwalden', 1),
(118, 204, 'OW', 'Obwalden', 1),
(119, 204, 'SG', 'St. Gallen', 1),
(120, 204, 'SH', 'Schaffhausen', 1),
(121, 204, 'SO', 'Solothurn', 1),
(122, 204, 'SZ', 'Schwyz', 1),
(123, 204, 'TG', 'Thurgau', 1),
(124, 204, 'TI', 'Tessin', 1),
(125, 204, 'UR', 'Uri', 1),
(126, 204, 'VD', 'Waadt', 1),
(127, 204, 'VS', 'Wallis', 1),
(128, 204, 'ZG', 'Zug', 1),
(129, 204, 'ZH', 'Z&uuml;rich', 1),
(130, 195, 'A Coru?a', 'A Coru&ntilde;a', 1),
(131, 195, 'Alava', 'Alava', 1),
(132, 195, 'Albacete', 'Albacete', 1),
(133, 195, 'Alicante', 'Alicante', 1),
(134, 195, 'Almeria', 'Almeria', 1),
(135, 195, 'Asturias', 'Asturias', 1),
(136, 195, 'Avila', 'Avila', 1),
(137, 195, 'Badajoz', 'Badajoz', 1),
(138, 195, 'Baleares', 'Baleares', 1),
(139, 195, 'Barcelona', 'Barcelona', 1),
(140, 195, 'Burgos', 'Burgos', 1),
(141, 195, 'Caceres', 'Caceres', 1),
(142, 195, 'Cadiz', 'Cadiz', 1),
(143, 195, 'Cantabria', 'Cantabria', 1),
(144, 195, 'Castellon', 'Castellon', 1),
(145, 195, 'Ceuta', 'Ceuta', 1),
(146, 195, 'Ciudad Real', 'Ciudad Real', 1),
(147, 195, 'Cordoba', 'Cordoba', 1),
(148, 195, 'Cuenca', 'Cuenca', 1),
(149, 195, 'Girona', 'Girona', 1),
(150, 195, 'Granada', 'Granada', 1),
(151, 195, 'Guadalajara', 'Guadalajara', 1),
(152, 195, 'Guipuzcoa', 'Guipuzcoa', 1),
(153, 195, 'Huelva', 'Huelva', 1),
(154, 195, 'Huesca', 'Huesca', 1),
(155, 195, 'Jaen', 'Jaen', 1),
(156, 195, 'La Rioja', 'La Rioja', 1),
(157, 195, 'Las Palmas', 'Las Palmas', 1),
(158, 195, 'Leon', 'Leon', 1),
(159, 195, 'Lleida', 'Lleida', 1),
(160, 195, 'Lugo', 'Lugo', 1),
(161, 195, 'Madrid', 'Madrid', 1),
(162, 195, 'Malaga', 'Malaga', 1),
(163, 195, 'Melilla', 'Melilla', 1),
(164, 195, 'Murcia', 'Murcia', 1),
(165, 195, 'Navarra', 'Navarra', 1),
(166, 195, 'Ourense', 'Ourense', 1),
(167, 195, 'Palencia', 'Palencia', 1),
(168, 195, 'Pontevedra', 'Pontevedra', 1),
(169, 195, 'Salamanca', 'Salamanca', 1),
(170, 195, 'Santa Cruz de Tenerife', 'Santa Cruz de Tenerife', 1),
(171, 195, 'Segovia', 'Segovia', 1),
(172, 195, 'Sevilla', 'Sevilla', 1),
(173, 195, 'Soria', 'Soria', 1),
(174, 195, 'Tarragona', 'Tarragona', 1),
(175, 195, 'Teruel', 'Teruel', 1),
(176, 195, 'Toledo', 'Toledo', 1),
(177, 195, 'Valencia', 'Valencia', 1),
(178, 195, 'Valladolid', 'Valladolid', 1),
(179, 195, 'Vizcaya', 'Vizcaya', 1),
(180, 195, 'Zamora', 'Zamora', 1),
(181, 195, 'Zaragoza', 'Zaragoza', 1),
(182, 222, 'ALD', 'Alderney', 1),
(183, 222, 'ANT', 'County Antrim', 1),
(184, 222, 'ARM', 'County Armagh', 1),
(185, 222, 'BSTL', 'Bristol', 1),
(186, 222, 'BEDS', 'Bedfordshire', 1),
(187, 222, 'BERK', 'Berkshire', 1),
(188, 222, 'WMID', 'West Midlands', 1),
(189, 222, 'BLGW', 'Blaenau Gwent', 1),
(190, 222, 'BORD', 'Borders', 1),
(191, 222, 'BRID', 'Bridgend', 1),
(192, 222, 'BUCK', 'Buckinghamshire', 1),
(193, 222, 'CAER', 'Caerphilly', 1),
(194, 222, 'CAIT', 'Caithness', 1),
(195, 222, 'CAMB', 'Cambridgeshire', 1),
(196, 222, 'CARD', 'Cardiff', 1),
(197, 222, 'CARM', 'Carmarthenshire', 1),
(198, 222, 'CENT', 'Central', 1),
(199, 222, 'CERE', 'Ceredigion', 1),
(200, 222, 'CHES', 'Cheshire', 1),
(201, 222, 'CHI', 'Channel Islands', 1),
(202, 222, 'CLWY', 'Clwyd', 1),
(203, 222, 'CONW', 'Conway', 1),
(204, 222, 'CORN', 'Cornwall', 1),
(205, 222, 'CUMB', 'Cumbria', 1),
(206, 222, 'DENB', 'Denbighshire', 1),
(207, 222, 'DERB', 'Derbyshire', 1),
(208, 222, 'DEVO', 'Devon', 1),
(209, 222, 'DORS', 'Dorset', 1),
(210, 222, 'DOW', 'County Down', 1),
(211, 222, 'DUMF', 'Dumfries & Galloway', 1),
(212, 222, 'DURH', 'County Durham', 1),
(213, 222, 'DYFE', 'Dyfed', 1),
(214, 222, 'ESSE', 'Essex', 1),
(215, 222, 'ESUS', 'East Sussex', 1),
(216, 222, 'FER', 'Fermanagh', 1),
(217, 222, 'FIFE', 'Fife', 1),
(218, 222, 'FLIN', 'Flintshire', 1),
(219, 222, 'GLAM', 'Glamorgan', 1),
(220, 222, 'GLOU', 'Gloucestershire', 1),
(221, 222, 'GRAM', 'Grampian', 1),
(222, 222, 'GSY', 'Guernsey', 1),
(223, 222, 'GWEN', 'Gwent', 1),
(224, 222, 'GWYN', 'Gwynedd', 1),
(225, 222, 'HAMP', 'Hampshire', 1),
(226, 222, 'HERE', 'Herefordshire', 1),
(227, 222, 'HERT', 'Hertfordshire', 1),
(228, 222, 'EYOR', 'East Riding of Yorkshire', 1),
(229, 222, 'IOAN', 'Isle of Anglesey', 1),
(230, 222, 'IOMN', 'Isle of Man', 1),
(231, 222, 'IOWT', 'Isle of Wight', 1),
(232, 222, 'JSY', 'Jersey', 1),
(233, 222, 'KENT', 'Kent', 1),
(234, 222, 'LANC', 'Lancashire', 1),
(235, 222, 'LDY', 'Londonderry', 1),
(236, 222, 'LEIC', 'Leicestershire', 1),
(237, 222, 'LINC', 'Lincolnshire', 1),
(238, 222, 'LOND', 'London', 1),
(239, 222, 'LOTH', 'Lothian', 1),
(240, 222, 'MANC', 'Manchester', 1),
(241, 222, 'MERS', 'Merseyside', 1),
(242, 222, 'MDSX', 'Middlesex', 1),
(243, 222, 'MERT', 'Merthyr Tydfil', 1),
(244, 222, 'MONM', 'Monmouthshire', 1),
(245, 222, 'NEAT', 'Neath Port Talbot', 1),
(246, 222, 'NEWP', 'Newport', 1),
(247, 222, 'NHAM', 'Northamptonshire', 1),
(248, 222, 'NORF', 'Norfolk', 1),
(249, 222, 'NOTT', 'Nottinghamshire', 1),
(250, 222, 'NUMB', 'Northumberland', 1),
(251, 222, 'NWHI', 'North west Highlands', 1),
(252, 222, 'NYOR', 'North Yorkshire', 1),
(253, 222, 'OXFO', 'Oxfordshire', 1),
(254, 222, 'PEMB', 'Pembrokeshire', 1),
(255, 222, 'POWY', 'Powys', 1),
(256, 222, 'SHRO', 'Shropshire', 1),
(257, 222, 'SOME', 'Somerset', 1),
(258, 222, 'STAF', 'Staffordshire', 1),
(259, 222, 'STRA', 'Strathclyde', 1),
(260, 222, 'SUFF', 'Suffolk', 1),
(261, 222, 'SURR', 'Surrey', 1),
(262, 222, 'SWAN', 'Swansea', 1),
(263, 222, 'SYOR', 'South Yorkshire', 1),
(264, 222, 'SAYR', 'South Ayrshire', 1),
(265, 222, 'TAFF', 'Rhondda Cynon Taff', 1),
(266, 222, 'TAYS', 'Tayside', 1),
(267, 222, 'TORF', 'Torfaen', 1),
(268, 222, 'TYR', 'County Tyrone', 1),
(269, 222, 'TYWE', 'Tyne & Wear', 1),
(270, 222, 'VALE', 'Vale of Glamorgan', 1),
(271, 222, 'WORC', 'Worcestershire', 1),
(272, 222, 'WARW', 'Warwickshire', 1),
(273, 222, 'WILT', 'Wiltshire', 1),
(274, 222, 'WISL', 'West Isles', 1),
(275, 222, 'WREX', 'Wrexham', 1),
(276, 222, 'WSUS', 'West Sussex', 1),
(277, 222, 'WYOR', 'West Yorkshire', 1),
(278, 153, 'Akaroa', 'Akaroa', 1),
(279, 153, 'Albert', 'Albert', 1),
(280, 153, 'Albury', 'Albury', 1),
(281, 153, 'Alexandra', 'Alexandra', 1),
(282, 153, 'Amberley', 'Amberley', 1),
(283, 153, 'Arrowtown', 'Arrowtown', 1),
(284, 153, 'Ashburton', 'Ashburton', 1),
(285, 153, 'Auckland', 'Auckland', 1),
(286, 153, 'Balclutha', 'Balclutha', 1),
(287, 153, 'Balfour', 'Balfour', 1),
(288, 153, 'Beachlands', 'Beachlands', 1),
(289, 153, 'Beaumont', 'Beaumont', 1),
(290, 153, 'Blackball', 'Blackball', 1),
(291, 153, 'Blenheim', 'Blenheim', 1),
(292, 153, 'Bluff', 'Bluff', 1),
(293, 153, 'Brighton', 'Brighton', 1),
(294, 153, 'Brightwater', 'Brightwater', 1),
(295, 153, 'Bulls', 'Bulls', 1),
(296, 153, 'Cambridge', 'Cambridge', 1),
(297, 153, 'Carterton', 'Carterton', 1),
(298, 153, 'Cheviot', 'Cheviot', 1),
(299, 153, 'Christchurch', 'Christchurch', 1),
(300, 153, 'Clarksville', 'Clarksville', 1),
(301, 153, 'Coromandel', 'Coromandel', 1),
(302, 153, 'Cromwell', 'Cromwell', 1),
(303, 153, 'Dannevirke', 'Dannevirke', 1),
(304, 153, 'Darfield', 'Darfield', 1),
(305, 153, 'Dargaville', 'Dargaville', 1),
(306, 153, 'Drury', 'Drury', 1),
(307, 153, 'Dunedin', 'Dunedin', 1),
(308, 153, 'Duntroon', 'Duntroon', 1),
(309, 153, 'Edgecumbe', 'Edgecumbe', 1),
(310, 153, 'Eltham', 'Eltham', 1),
(311, 153, 'Eketahuna', 'Eketahuna', 1),
(312, 153, 'Fairlie', 'Fairlie', 1),
(313, 153, 'Featherston', 'Featherston', 1),
(314, 153, 'Feilding', 'Feilding', 1),
(315, 153, 'Flaxmere', 'Flaxmere', 1),
(316, 153, 'Foxton', 'Foxton', 1),
(317, 153, 'Foxton Beach', 'Foxton Beach', 1),
(318, 153, 'Frankton, Otago', 'Frankton, Otago', 1),
(319, 153, 'Frankton, Waikato', 'Frankton, Waikato', 1),
(320, 153, 'Franz Josef', 'Franz Josef', 1),
(321, 153, 'Geraldine', 'Geraldine', 1),
(322, 153, 'Gisborne', 'Gisborne', 1),
(323, 153, 'Glenorchy', 'Glenorchy', 1),
(324, 153, 'Gore', 'Gore', 1),
(325, 153, 'Granity', 'Granity', 1),
(326, 153, 'Greymouth', 'Greymouth', 1),
(327, 153, 'Greytown', 'Greytown', 1),
(328, 153, 'Haast', 'Haast', 1),
(329, 153, 'Hakataramea', 'Hakataramea', 1),
(330, 153, 'Hamilton', 'Hamilton', 1),
(331, 153, 'Hanmer Springs', 'Hanmer Springs', 1),
(332, 153, 'Hastings', 'Hastings', 1),
(333, 153, 'Havelock', 'Havelock', 1),
(334, 153, 'Havelock North', 'Havelock North', 1),
(335, 153, 'Hawea', 'Hawea', 1),
(336, 153, 'Hawera', 'Hawera', 1),
(337, 153, 'Helensville', 'Helensville', 1),
(338, 153, 'Henley', 'Henley', 1),
(339, 153, 'Hinuera', 'Hinuera', 1),
(340, 153, 'Hokitika', 'Hokitika', 1),
(341, 153, 'Howick', 'Howick', 1),
(342, 153, 'Huntly', 'Huntly', 1),
(343, 153, 'Inangahua Junction', 'Inangahua Junction', 1),
(344, 153, 'Inglewood', 'Inglewood', 1),
(345, 153, 'Invercargill', 'Invercargill', 1),
(346, 153, 'Kaiapoi', 'Kaiapoi', 1),
(347, 153, 'Kaikohe', 'Kaikohe', 1),
(348, 153, 'Kaikoura', 'Kaikoura', 1),
(349, 153, 'Kaitaia', 'Kaitaia', 1),
(350, 153, 'Kaitangata', 'Kaitangata', 1),
(351, 153, 'Karamea', 'Karamea', 1),
(352, 153, 'Katikati', 'Katikati', 1),
(353, 153, 'Kawakawa', 'Kawakawa', 1),
(354, 153, 'Kawerau', 'Kawerau', 1),
(355, 153, 'Kerikeri', 'Kerikeri', 1),
(356, 153, 'Kihikihi', 'Kihikihi', 1),
(357, 153, 'Kinloch', 'Kinloch', 1),
(358, 153, 'Kumara', 'Kumara', 1),
(359, 153, 'Kumeu', 'Kumeu', 1),
(360, 153, 'Kurow', 'Kurow', 1),
(361, 153, 'Kawhia', 'Kawhia', 1),
(362, 153, 'King Country', 'King Country', 1),
(363, 153, 'Lawrence', 'Lawrence', 1),
(364, 153, 'Leeston', 'Leeston', 1),
(365, 153, 'Leigh', 'Leigh', 1),
(366, 153, 'Levin', 'Levin', 1),
(367, 153, 'Lincoln', 'Lincoln', 1),
(368, 153, 'Little River', 'Little River', 1),
(369, 153, 'Lower Hutt', 'Lower Hutt', 1),
(370, 153, 'Lumsden', 'Lumsden', 1),
(371, 153, 'Lyttelton', 'Lyttelton', 1),
(372, 153, 'Manaia', 'Manaia', 1),
(373, 153, 'Mangakino', 'Mangakino', 1),
(374, 153, 'Manukau', 'Manukau', 1),
(375, 153, 'Maraetai', 'Maraetai', 1),
(376, 153, 'Martinborough', 'Martinborough', 1),
(377, 153, 'Marton', 'Marton', 1),
(378, 153, 'Masterton', 'Masterton', 1),
(379, 153, 'Matamata', 'Matamata', 1),
(380, 153, 'Maungaturoto', 'Maungaturoto', 1),
(381, 153, 'Mayfield', 'Mayfield', 1),
(382, 153, 'Methven', 'Methven', 1),
(383, 153, 'Middlemarch', 'Middlemarch', 1),
(384, 153, 'Millers Flat', 'Millers Flat', 1),
(385, 153, 'Milton', 'Milton', 1),
(386, 153, 'Moeraki', 'Moeraki', 1),
(387, 153, 'Moerewa', 'Moerewa', 1),
(388, 153, 'Mokau', 'Mokau', 1),
(389, 153, 'Morrinsville', 'Morrinsville', 1),
(390, 153, 'Mosgiel', 'Mosgiel', 1),
(391, 153, 'Mossburn', 'Mossburn', 1),
(392, 153, 'Motueka', 'Motueka', 1),
(393, 153, 'Mount Maunganui', 'Mount Maunganui', 1),
(394, 153, 'Mount Somers', 'Mount Somers', 1),
(395, 153, 'Murchison', 'Murchison', 1),
(396, 153, 'Murupara', 'Murupara', 1),
(397, 153, 'Napier', 'Napier', 1),
(398, 153, 'Naseby', 'Naseby', 1),
(399, 153, 'Nelson', 'Nelson', 1),
(400, 153, 'New Brighton', 'New Brighton', 1),
(401, 153, 'New Plymouth', 'New Plymouth', 1),
(402, 153, 'Ngapara', 'Ngapara', 1),
(403, 153, 'Ngaruawahia', 'Ngaruawahia', 1),
(404, 153, 'Ngongotaha', 'Ngongotaha', 1),
(405, 153, 'North Shore City', 'North Shore City', 1),
(406, 153, 'Oakura', 'Oakura', 1),
(407, 153, 'Oamaru', 'Oamaru', 1),
(408, 153, 'Oban', 'Oban', 1),
(409, 153, 'Ohakune', 'Ohakune', 1),
(410, 153, 'Ohoka', 'Ohoka', 1),
(411, 153, 'Ohope Beach', 'Ohope Beach', 1),
(412, 153, 'Ohura', 'Ohura', 1),
(413, 153, 'Okato', 'Okato', 1),
(414, 153, 'Omokoroa', 'Omokoroa', 1),
(415, 153, 'Opotiki', 'Opotiki', 1),
(416, 153, 'Opunake', 'Opunake', 1),
(417, 153, 'Oratia', 'Oratia', 1),
(418, 153, 'Orewa', 'Orewa', 1),
(419, 153, 'Otaki', 'Otaki', 1),
(420, 153, 'Otakou', 'Otakou', 1),
(421, 153, 'Otorohanga', 'Otorohanga', 1),
(422, 153, 'Oxford', 'Oxford', 1),
(423, 153, 'Paekakariki', 'Paekakariki', 1),
(424, 153, 'Paeroa', 'Paeroa', 1),
(425, 153, 'Pahiatua', 'Pahiatua', 1),
(426, 153, 'Paihia', 'Paihia', 1),
(427, 153, 'Palmerston', 'Palmerston', 1),
(428, 153, 'Palmerston North', 'Palmerston North', 1),
(429, 153, 'Papakura', 'Papakura', 1),
(430, 153, 'Papamoa', 'Papamoa', 1),
(431, 153, 'Papatoetoe', 'Papatoetoe', 1),
(432, 153, 'Paraparaumu', 'Paraparaumu', 1),
(433, 153, 'Patea', 'Patea', 1),
(434, 153, 'Pauanui', 'Pauanui', 1),
(435, 153, 'Pauatahanui', 'Pauatahanui', 1),
(436, 153, 'Petone', 'Petone', 1),
(437, 153, 'Picton', 'Picton', 1),
(438, 153, 'Piopio', 'Piopio', 1),
(439, 153, 'Pirongia', 'Pirongia', 1),
(440, 153, 'Pleasant Point', 'Pleasant Point', 1),
(441, 153, 'Plimmerton', 'Plimmerton', 1),
(442, 153, 'Porirua', 'Porirua', 1),
(443, 153, 'Port Chalmers', 'Port Chalmers', 1),
(444, 153, 'Portobello', 'Portobello', 1),
(445, 153, 'Pukekohe', 'Pukekohe', 1),
(446, 153, 'Pukerua Bay', 'Pukerua Bay', 1),
(447, 153, 'Pukeuri', 'Pukeuri', 1),
(448, 153, 'Putaruru', 'Putaruru', 1),
(449, 153, 'Queenstown', 'Queenstown', 1),
(450, 153, 'Raetihi', 'Raetihi', 1),
(451, 153, 'Raglan', 'Raglan', 1),
(452, 153, 'Ramarama', 'Ramarama', 1),
(453, 153, 'Ranfurly', 'Ranfurly', 1),
(454, 153, 'Rangiora', 'Rangiora', 1),
(455, 153, 'Raumati', 'Raumati', 1),
(456, 153, 'Reefton', 'Reefton', 1),
(457, 153, 'Renwick', 'Renwick', 1),
(458, 153, 'Richmond', 'Richmond', 1),
(459, 153, 'Riverhead', 'Riverhead', 1),
(460, 153, 'Riverton', 'Riverton', 1),
(461, 153, 'Rolleston', 'Rolleston', 1),
(462, 153, 'Ross', 'Ross', 1),
(463, 153, 'Rotorua', 'Rotorua', 1),
(464, 153, 'Roxburgh', 'Roxburgh', 1),
(465, 153, 'Ruatoria', 'Ruatoria', 1),
(466, 153, 'Runanga', 'Runanga', 1),
(467, 153, 'Russell', 'Russell', 1),
(468, 153, 'Sanson', 'Sanson', 1),
(469, 153, 'Seddon', 'Seddon', 1),
(470, 153, 'Sheffield', 'Sheffield', 1),
(471, 153, 'Shannon', 'Shannon', 1),
(472, 153, 'Snells Beach', 'Snells Beach', 1),
(473, 153, 'Springfield', 'Springfield', 1),
(474, 153, 'Stratford', 'Stratford', 1),
(475, 153, 'Silverdale', 'Silverdale', 1),
(476, 153, 'Taihape', 'Taihape', 1),
(477, 153, 'Taipa-Mangonui', 'Taipa-Mangonui', 1),
(478, 153, 'Tairua', 'Tairua', 1),
(479, 153, 'Takaka', 'Takaka', 1),
(480, 153, 'Tapanui', 'Tapanui', 1),
(481, 153, 'Taradale', 'Taradale', 1),
(482, 153, 'Taumarunui', 'Taumarunui', 1),
(483, 153, 'Taupo', 'Taupo', 1),
(484, 153, 'Tauranga', 'Tauranga', 1),
(485, 153, 'Te Anau', 'Te Anau', 1),
(486, 153, 'Te Arai', 'Te Arai', 1),
(487, 153, 'Te Aroha', 'Te Aroha', 1),
(488, 153, 'Te Awamutu', 'Te Awamutu', 1),
(489, 153, 'Te Kuiti', 'Te Kuiti', 1),
(490, 153, 'Te Puke', 'Te Puke', 1),
(491, 153, 'Temuka', 'Temuka', 1),
(492, 153, 'Thames', 'Thames', 1),
(493, 153, 'Timaru', 'Timaru', 1),
(494, 153, 'Tinwald', 'Tinwald', 1),
(495, 153, 'Tirau', 'Tirau', 1),
(496, 153, 'Tokarahi', 'Tokarahi', 1),
(497, 153, 'Tokoroa', 'Tokoroa', 1),
(498, 153, 'Tolaga Bay', 'Tolaga Bay', 1),
(499, 153, 'Tuakau', 'Tuakau', 1),
(500, 153, 'Turangi', 'Turangi', 1),
(501, 153, 'Twizel', 'Twizel', 1),
(502, 153, 'Upper Hutt', 'Upper Hutt', 1),
(503, 153, 'Waiheke Island', 'Waiheke Island', 1),
(504, 153, 'Waharoa', 'Waharoa', 1),
(505, 153, 'Waihi', 'Waihi', 1),
(506, 153, 'Waihi Beach', 'Waihi Beach', 1),
(507, 153, 'Waikanae', 'Waikanae', 1),
(508, 153, 'Waimate', 'Waimate', 1),
(509, 153, 'Waiouru', 'Waiouru', 1),
(510, 153, 'Wainuiomata', 'Wainuiomata', 1),
(511, 153, 'Waipawa', 'Waipawa', 1),
(512, 153, 'Waipukurau', 'Waipukurau', 1),
(513, 153, 'Wairakei', 'Wairakei', 1),
(514, 153, 'Wairoa', 'Wairoa', 1),
(515, 153, 'Waitahuna', 'Waitahuna', 1),
(516, 153, 'Waikouaiti', 'Waikouaiti', 1),
(517, 153, 'Waitakere', 'Waitakere', 1),
(518, 153, 'Waitara', 'Waitara', 1),
(519, 153, 'Waitoa', 'Waitoa', 1),
(520, 153, 'Waitotara', 'Waitotara', 1),
(521, 153, 'Waiuku', 'Waiuku', 1),
(522, 153, 'Wakefield', 'Wakefield', 1),
(523, 153, 'Wallacetown', 'Wallacetown', 1),
(524, 153, 'Walton', 'Walton', 1),
(525, 153, 'Waverley', 'Waverley', 1),
(526, 153, 'Wanaka', 'Wanaka', 1),
(527, 153, 'Wanganui', 'Wanganui', 1),
(528, 153, 'Ward', 'Ward', 1),
(529, 153, 'Wardville', 'Wardville', 1),
(530, 153, 'Warkworth', 'Warkworth', 1),
(531, 153, 'Wellington', 'Wellington', 1),
(532, 153, 'Wellsford', 'Wellsford', 1),
(533, 153, 'Westport', 'Westport', 1),
(534, 153, 'Whakatane', 'Whakatane', 1),
(535, 153, 'Whakamaru', 'Whakamaru', 1),
(536, 153, 'Whangamata', 'Whangamata', 1),
(537, 153, 'Whangamomona', 'Whangamomona', 1),
(538, 153, 'Whangarei', 'Whangarei', 1),
(539, 153, 'Whiritoa', 'Whiritoa', 1),
(540, 153, 'Whitford', 'Whitford', 1),
(541, 153, 'Whitby', 'Whitby', 1),
(542, 153, 'Whitianga', 'Whitianga', 1),
(543, 153, 'Willowby', 'Willowby', 1),
(544, 153, 'Winscombe', 'Winscombe', 1),
(545, 153, 'Winton', 'Winton', 1),
(546, 153, 'Woodend', 'Woodend', 1),
(547, 153, 'Woodville', 'Woodville', 1),
(548, 153, 'Wyndham', 'Wyndham', 1);

-- --------------------------------------------------------

--
-- Table structure for table `zones_to_geo_zones`
--

CREATE TABLE `zones_to_geo_zones` (
  `association_id` int(11) NOT NULL AUTO_INCREMENT,
  `zone_country_id` int(11) NOT NULL DEFAULT '0',
  `zone_id` int(11) DEFAULT NULL,
  `geo_zone_id` int(11) DEFAULT NULL,
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`association_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
