<?php
/*
  $Id: stats_sales_report2.php,v 1.00 2003/03/08 19:02:22 Exp $

  Charly Wilhelm  charly@yoshi.ch
  
  Released under the GNU General Public License

  Copyright (c) 2003 osCommerce
  
  possible views (srView):
  1 yearly
  2 monthly
  3 weekly
  4 daily
  
  possible options (srDetail):
  0 no detail
  1 show details (products)
  2 show details only (products)
  
  export
  0 normal view
  1 html view without left and right
  2 csv
  
  sort
  0 no sorting
  1 product description asc
  2 product description desc
  3 #product asc, product descr asc
  4 #product desc, product descr desc
  5 revenue asc, product descr asc
  6 revenue desc, product descr desc
  
*/
  
  require('includes/application_top.php');

  require(DIR_WS_CLASSES . 'currencies.php');
  $currencies = new currencies();

  // default detail no detail
  $srDefaultDetail = 0;
  // default view (daily)
  $srDefaultView = 2;
  // default export
  $srDefaultExp = 0;
  // default sort
  $srDefaultSort = 4;
  $report = (isset($_GET['report']) ? $_GET['report'] : '');
  $detail = (isset($_GET['detail']) ? $_GET['detail'] : '');
  $export = (isset($_GET['export']) ? $_GET['export'] : '');
  $max = (isset($_GET['max']) ? $_GET['max'] : '');
  $status = (isset($_GET['status']) ? $_GET['status'] : '');
  $sort = (isset($_GET['sort']) ? $_GET['sort'] : '');
  $srView = (isset($_GET['report']) ? $_GET['report'] : '');
  $srDetail = (isset($_GET['detail']) ? $_GET['detail'] : '');
  $srExp = (isset($_GET['export']) ? $_GET['export'] : '');
  $srMax = (isset($_GET['max']) ? $_GET['max'] : '');
  $srStatus = (isset($_GET['status']) ? $_GET['status'] : '');
  $srSort = (isset($_GET['sort']) ? $_GET['sort'] : '');
  $startD = (isset($_GET['startD']) ? $_GET['startD'] : '');
  $startM = (isset($_GET['startM']) ? $_GET['startM'] : '');
  $startY = (isset($_GET['startY']) ? $_GET['startY'] : '');

  $endD = (isset($_GET['endD']) ? $_GET['endD'] : '');
  $endM = (isset($_GET['endM']) ? $_GET['endM'] : '');
  $endY = (isset($_GET['endY']) ? $_GET['endY'] : '');
  $srFilter = (isset($srFilter) ? $srFilter : '');
  // report views (1: yearly 2: monthly 3: weekly 4: daily)
  if ( ($report) && (tep_not_null($report)) ) {
  $srView = $report;
  }
  if ($srView < 1 || $srView > 4) {
    $srView = $srDefaultView;
  }

  // detail
  if ( isset($detail) && (tep_not_null($detail)) ) 
{    $srDetail = $_GET['detail'];
  }
  if ($srDetail < 0 || $srDetail > 2) {
    $srDetail = $srDefaultDetail;
  }
  
  // report views (1: yearly 2: monthly 3: weekly 4: daily)
  if ( ($export) && (tep_not_null($export)) ) 
{    $srExp = $_GET['export'];
  }
  if ($srExp < 0 || $srExp > 2) {
    $srExp = $srDefaultExp;
  }
  
  // item_level
  if ( ($max) && (tep_not_null($max)) ) {
    $srMax = $max;
  }
  if (!is_numeric($srMax)) {
    $srMax = 0;
  }
      
  // order status
  if ( ($status) && (tep_not_null($status)) ) 
{    $srStatus = $status;
  }
  if (!is_numeric($srStatus)) {
    $srStatus = 0;
  }
  
  // sort
  if ( ($sort) && (tep_not_null($sort)) ) {
    $srSort = $sort;
  }
  if ($srSort < 1 || $srSort > 6) {
    $srSort = $srDefaultSort;
  }
    
  // check start and end Date
  $startDate = "";
  $startDateG = 0;
  if ( ($startD) && (tep_not_null($startD)) ) 
{    $sDay = $startD;
    $startDateG = 1;
  } else {
    $sDay = 1;
  }
  if ( ($startM) && (tep_not_null($startM)) ) 
{    $sMon = $startM;
    $startDateG = 1;
  } else {
    $sMon = 1;
  }
  if ( ($startY) && (tep_not_null($startY)) ) 
{    $sYear = $startY;
    $startDateG = 1;
  } else {
    $sYear = date("Y");
  }
  if ($startDateG) {
    $startDate = mktime(0, 0, 0, $sMon, $sDay, $sYear);
  } else {
    $startDate = mktime(0, 0, 0, date("m"), 1, date("Y"));
  }
    
  $endDate = "";
  $endDateG = 0;
  if ( ($endD) && (tep_not_null($endD)) ) {
    $eDay = $endD;
    $endDateG = 1;
  } else {
    $eDay = 1;
  }
  if ( ($endM) && (tep_not_null($endM)) ) {
    $eMon = $endM;
    $endDateG = 1;
  } else {
    $eMon = 1;
  }
  if ( ($endY) && (tep_not_null($endY)) ) {
    $eYear = $endY;
    $endDateG = 1;
  } else {
    $eYear = date("Y");
  }
  if ($endDateG) {
    $endDate = mktime(0, 0, 0, $eMon, $eDay + 1, $eYear);
  } else {
    $endDate = mktime(0, 0, 0, date("m"), date("d") + 1, date("Y"));
  }
  
  require(DIR_WS_CLASSES . 'sales_report2.php');
  $sr = new sales_report($srView, $startDate, $endDate, $srSort, $srStatus, 
$srFilter);  $startDate = $sr->startDate;
  $endDate = $sr->endDate;  
  
  $file_str = '';
  
if ($srExp < 2) {
// not for csv export

include(DIR_WS_INCLUDES . 'html_top.php');
include(DIR_WS_INCLUDES . 'header.php');
include(DIR_WS_INCLUDES . 'column_left.php');
?>
<div id="content" class="content p-relative">
  <h1 class="page-header"><i class="fa fa-laptop"></i> <?php echo HEADING_TITLE . $date; ?></h1>
  <?php if (file_exists(DIR_WS_INCLUDES . 'toolbar.php')) include(DIR_WS_INCLUDES . 'toolbar.php'); ?>

<?php
    if ($srExp < 1) {
?>
<div class="col main-col">
  <div class="row">
	<div class="col-12 pr-0 mb-2">

      <table border="0" width="100%" cellspacing="0" cellpadding="0">
        <tr>
          <td colspan="2">
            <form action="" method="get">
            <?php
              if (isset($_GET[tep_session_name()])) {
                echo tep_draw_hidden_field(tep_session_name(), $_GET[tep_session_name()]);
              }
            ?>
              <table border="0" width="100%" cellspacing="0" cellpadding="0">
                <tr>
                  <td align="left" rowspan="2">
                    <input type="radio" name="report" value="1" <?php if ($srView == 1) echo "checked"; ?>><?php echo REPORT_TYPE_YEARLY; ?><br>
                    <input type="radio" name="report" value="2" <?php if ($srView == 2) echo "checked"; ?>><?php echo REPORT_TYPE_MONTHLY; ?><br>
                    <input type="radio" name="report" value="3" <?php if ($srView == 3) echo "checked"; ?>><?php echo REPORT_TYPE_WEEKLY; ?><br>
                    <input type="radio" name="report" value="4" <?php if ($srView == 4) echo "checked"; ?>><?php echo REPORT_TYPE_DAILY; ?><br>
                  </td>
                  <td>
<?php echo REPORT_START_DATE; ?><br>
                    <select name="startD" size="1">
<?php
      if ($startDate) {
        $j = date("j", $startDate);
      } else {
        $j = 1;
      }
      for ($i = 1; $i < 32; $i++) {
?>
                        <option<?php if ($j == $i) echo " selected"; ?>><?php echo $i; ?></option>
<?php
      }
?>
                    </select>
                    <select name="startM" size="1">
<?php
      if ($startDate) {
        $m = date("n", $startDate);
      } else {
        $m = 1;
      }
      for ($i = 1; $i < 13; $i++) {
?>
                      <option<?php if ($m == $i) echo " selected"; ?> value="<?php echo $i; ?>"><?php echo strftime("%B", mktime(0, 0, 0, $i, 1)); ?></option>
<?php
      }
?>
                    </select>
                    <select name="startY" size="1">
<?php
      if ($startDate) {
        $y = date("Y") - date("Y", $startDate);
      } else {
        $y = 0;
      }
      for ($i = 10; $i >= 0; $i--) {
?>
                      <option<?php if ($y == $i) echo " selected"; ?>><?php echo date("Y") - $i; ?></option>
<?php
    }
?>
                    </select>
                  </td>
                  <td rowspan="2" align="left">
                    <?php echo REPORT_DETAIL; ?><br>
                    <select name="detail" size="1">
                      <option value="0"<?php if ($srDetail == 0) echo "selected"; ?>><?php echo DET_HEAD_ONLY; ?></option>
                      <option value="1"<?php if ($srDetail == 1) echo " selected"; ?>><?php echo DET_DETAIL; ?></option>
                      <option value="2"<?php if ($srDetail == 2) echo " selected"; ?>><?php echo DET_DETAIL_ONLY; ?></option>
                    </select><br>
<?php echo REPORT_MAX; ?><br>
                    <select name="max" size="1">
                      <option value="0"><?php echo REPORT_ALL; ?></option>
                      <option<?php if ($srMax == 1) echo " selected"; ?>>1</option>
                      <option<?php if ($srMax == 3) echo " selected"; ?>>3</option>
                      <option<?php if ($srMax == 5) echo " selected"; ?>>5</option>
                      <option<?php if ($srMax == 10) echo " selected"; ?>>10</option>
                      <option<?php if ($srMax == 25) echo " selected"; ?>>25</option>
                      <option<?php if ($srMax == 50) echo " selected"; ?>>50</option>
                    </select>
                  </td>
                  <td rowspan="2" align="left">
                    <?php echo REPORT_STATUS_FILTER; ?><br>
                    <select name="status" size="1">
                      <option value="0"><?php echo REPORT_ALL; ?></option>
<?php
                        foreach ($sr->status as $value) {
?>
                      <option value="<?php echo $value["orders_status_id"]?>"<?php if ($srStatus == $value["orders_status_id"]) echo " selected"; ?>><?php echo $value["orders_status_name"] ; ?></option>
<?php
                         }
?>
                    </select><br>
                  </td>
                  <td rowspan="2" align="left">
                    <?php echo REPORT_EXP; ?><br>
                    <select name="export" size="1">
                      <option value="0" selected><?php echo EXP_NORMAL; ?></option>
                      <option value="1"><?php echo EXP_HTML; ?></option>
                      <option value="2"><?php echo EXP_CSV; ?></option>
                    </select><br>
                    <?php echo REPORT_SORT; ?><br>
                    <select name="sort" size="1">
                      <option value="0"<?php if ($srSort == 0) echo " selected"; ?>><?php echo SORT_VAL0; ?></option>
                      <option value="1"<?php if ($srSort == 1) echo " selected"; ?>><?php echo SORT_VAL1; ?></option>
                      <option value="2"<?php if ($srSort == 2) echo " selected"; ?>><?php echo SORT_VAL2; ?></option>
                      <option value="3"<?php if ($srSort == 3) echo " selected"; ?>><?php echo SORT_VAL3; ?></option>
                      <option value="4"<?php if ($srSort == 4) echo " selected"; ?>><?php echo SORT_VAL4; ?></option>
                      <option value="5"<?php if ($srSort == 5) echo " selected"; ?>><?php echo SORT_VAL5; ?></option>
                      <option value="6"<?php if ($srSort == 6) echo " selected"; ?>><?php echo SORT_VAL6; ?></option>
                    </select><br>
                  </td>
                </tr>
                <tr>
                  <td>
<?php echo REPORT_END_DATE; ?><br>
                    <select name="endD" size="1">
<?php
    if ($endDate) {
      $j = date("j", $endDate - 60* 60 * 24);
    } else {
      $j = date("j");
    }
    for ($i = 1; $i < 32; $i++) {
?>
                      <option<?php if ($j == $i) echo " selected"; ?>><?php echo $i; ?></option>
<?php
    }
?>
                    </select>
                    <select name="endM" size="1">
<?php
    if ($endDate) {
      $m = date("n", $endDate - 60* 60 * 24);
    } else {
      $m = date("n");
    }
    for ($i = 1; $i < 13; $i++) {
?>
                      <option<?php if ($m == $i) echo " selected"; ?> value="<?php echo $i; ?>"><?php echo strftime("%B", mktime(0, 0, 0, $i, 1)); ?></option>
<?php
    }
?>
                    </select>
                    <select name="endY" size="1">
<?php
    if ($endDate) {
      $y = date("Y") - date("Y", $endDate - 60* 60 * 24);
    } else {
      $y = 0;
    }
    for ($i = 10; $i >= 0; $i--) {
?>
                      <option<?php if ($y == $i) echo " selected"; ?>><?php echo
date("Y") - $i; ?></option><?php
    }
?>
                    </select>
                  </td>
                </tr>
              </table>
              <table border="0" cellpadding="0" cellspacing="0" width="100%" style="margin-top: .5em;">
                <tr>
                  <td colspan="5" align="right">
                    <?php echo '<button class="btn btn-success btn-sm" type="submit">' . REPORT_SEND . '</button>'; ?>                    
                  </td>
              </table>
            </form>
          </td>
        </tr>
       </table>

	</div>
  </div>
</div>
<?php
  } // end of ($srExp < 1)
?>
  <div class="col">
    <!-- begin panel -->
    <div class="dark">
      <!-- body_text //-->
      <div id="table-statsproductspurchased" class="table-statsproductspurchased">
        <div class="row">
          <div class="col-md-12 col-xl-12 dark panel-left rounded">

				<table class="table table-hover w-100 mt-2">
				  <thead>
					<tr class="th-row">
					  <th scope="col" class="th-col dark text-right"><?php echo TABLE_HEADING_DATE; ?></th>
                      <th scope="col" class="th-col dark text-right"><?php echo TABLE_HEADING_ORDERS;?></th>
                      <th scope="col" class="th-col dark text-right"><?php echo TABLE_HEADING_ITEMS; ?></th>
                      <th scope="col" class="th-col dark text-right"><?php echo TABLE_HEADING_REVENUE;?></th>
                      <th scope="col" class="th-col dark text-right"><?php echo  TABLE_HEADING_SHIPPING;?></th>
                      <th scope="col" class="th-col dark text-right"><?php echo  TABLE_HEADING_DISCOUNT;?></th>
                    </tr>
				  </thead>
<?php
} // end of if $srExp < 2 csv export
$sum = 0;
while ($sr->actDate < $sr->endDate) {
  $info = $sr->getNext();
  $last = sizeof($info) - 1;
  if ($srExp < 2) {
?>
                    <tr>
<?php
    switch ($srView) {
      case '3':
?>
                      <td class="table-col dark text-right"><?php echo tep_date_long(date("Y-m-d\ H:i:s", $sr->showDate)) . " - " . tep_date_short(date("Y-m-d\ H:i:s", $sr->showDateEnd)); ?></td>
<?php
        break;
      case '4':
?>
                      <td class="table-col dark text-right"><?php echo tep_date_long(date("Y-m-d\ H:i:s", $sr->showDate)); ?></td>
<?php
        break;
      default;
?>
                      <td class="table-col dark text-right"><?php echo tep_date_short(date("Y-m-d\ H:i:s", $sr->showDate)) . " - " . tep_date_short(date("Y-m-d\ H:i:s", $sr->showDateEnd)); ?></td>
<?php
    }
?>
                      <td class="table-col dark text-right"><?php echo $info[0]['order']; ?></td>
                      <td class="table-col dark text-right"><?php echo (isset($info[$last - 1]['totitem']) ? $info[$last - 1]['totitem'] : ''); ?></td>
                      <td class="table-col dark text-right"><?php echo (isset($info[$last - 1]['totsum']) ? $currencies->format($info[$last - 1]['totsum']) : '');?></td>
                      <td class="table-col dark text-right"><?php echo $currencies->format($info[0]['shipping']);?></td>
                      <td class="table-col dark text-right"><?php echo $currencies->format($info[0]['discount']);?></td>
                    </tr>
<?php
  } else {
    // csv export
    $file_str .= date(DATE_FORMAT, $sr->showDate) . SR_SEPARATOR1 . date(DATE_FORMAT, $sr->showDateEnd) . SR_SEPARATOR1;
    $file_str .= $info[0]['order'] . SR_SEPARATOR1;
    $file_str .= $info[$last - 1]['totitem'] . SR_SEPARATOR1;
    $file_str .= $currencies->format($info[$last - 1]['totsum']) . SR_SEPARATOR1;
    $file_str .= $currencies->format($info[0]['shipping']) . SR_NEWLINE;
  }
  if ($srDetail) {
    for ($i = 0; $i < $last; $i++) {
      if ($srMax == 0 or $i < $srMax) {
        if ($srExp < 2) {
?>
                    <tr>
                    <td class="table-col dark text-left">&nbsp;</td>
                    <td class="table-col dark text-left"><a href="<?php echo tep_catalog_href_link("product_info.php?products_id=" . $info[$i]['pid']) ?>" target="_blank"><?php echo $info[$i]['pname']; ?></a>
<?php
  if (is_array($info[$i]['attr'])) {
    $attr_info = $info[$i]['attr'];
    foreach ($attr_info as $attr) {
      echo '<div style="font-style:italic;">&nbsp;' . $attr['quant'] . 'x ' ;
      //  $attr['options'] . ': '
      $flag = 0;
      foreach ($attr['options_values'] as $value) {
        if ($flag > 0) {
          echo "," . $value;
        } else {
          echo $value;
          $flag = 1;
        }
      }
      $price = 0;
      foreach ($attr['price'] as $value) {
        $price += $value;
      }
      if ($price != 0) {
        echo ' (';
        if ($price > 0) {
          echo "+";
        }
        echo $currencies->format($price). ')';
      }
      echo '</div>';
    }
  }
?>                    </td>
                    <td class="table-col dark text-right"><?php echo $info[$i]['pquant']; ?></td>
<?php
          if ($srDetail == 2) {?>
                    <td class="table-col dark text-right"><?php echo $currencies->format($info[$i]['psum']); ?></td>
<?php
          } else { ?>
                    <td class="table-col dark text-right">&nbsp;</td>
<?php
          }
?>
                    <td class="table-col dark text-right">&nbsp;</td>
                    <td claclass="table-col dark text-right">&nbsp;</td>
                  </tr>
<?php
        } else {
        // csv export
          if (is_array($info[$i]['attr'])) {
            $attr_info = $info[$i]['attr'];
            foreach ($attr_info as $attr) {
              $file_str .= $info[$i]['pname'] . "(";
              $flag = 0;
              foreach ($attr['options_values'] as $value) {
                if ($flag > 0) {
                  $file_str .= "," . $value;
                } else {
                  $file_str .= $value;
                  $flag = 1;
                }
              }
              $price = 0;
              foreach ($attr['price'] as $value) {
                $price += $value;
              }
              if ($price != 0) {
                $file_str .= ' (';
                if ($price > 0) {
                  $file_str .= "+";
                } else {
                  $file_str .= " ";
                }
                $file_str .= $currencies->format($price). ')';
              }
              $file_str .= ")" . SR_SEPARATOR2;
              if ($srDetail == 2) {
                $file_str .= $attr['quant'] . SR_SEPARATOR2;
                $file_str .= $currencies->format( $attr['quant'] * ($info[$i]['price'] + $price)) . SR_NEWLINE;
              } else {
                $file_str .= $attr['quant'] . SR_NEWLINE;
              }
              $info[$i]['pquant'] = $info[$i]['pquant'] - $attr['quant'];
            }
          }
          if ($info[$i]['pquant'] > 0) {
            $file_str .= $info[$i]['pname'] . SR_SEPARATOR2;
            if ($srDetail == 2) {
              $file_str .= $info[$i]['pquant'] . SR_SEPARATOR2;
              $file_str .= $currencies->format($info[$i]['pquant'] * $info[$i]['price']) . SR_NEWLINE;
            } else {
              $file_str .= $info[$i]['pquant'] . SR_NEWLINE;
            }
          }
        }
      }
    }
  }
}
if ($srExp < 2) {
?>
		  </table>

			<div class="mb-1">&nbsp;</div>
		 </div>
        </div>
      </div>   
      <!-- end body_text //-->
    </div>
    <!-- end panel -->
  </div>
</div>
<!-- body_eof //-->
<?php 
	if ($srExp < 1) {
		include(DIR_WS_INCLUDES . 'html_bottom.php');
	}
	require(DIR_WS_INCLUDES . 'application_bottom.php'); 
}

if ($srExp == 2) {
  if (preg_match('/MSIE/', $_SERVER['HTTP_USER_AGENT'])) {
    header('Content-Type: application/octetstream');
    header('Cache-Control: no-store, no-cache, must-revalidate' );
    header('Cache-Control: post-check=0, pre-check=0', false );
    header("Pragma: public");
    header("Cache-control: private");
    header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
    header('Content-Transfer-Encoding: Binary');
    header("Content-length: " . strlen($file_str));
    header('Content-Disposition: attachment; filename=sales_report.csv');
  } else {
    header('Content-Type: application/octet-stream');
    header('Cache-Control: no-store, no-cache, must-revalidate' );
    header('Cache-Control: post-check=0, pre-check=0', false );
    header("Pragma: no-cache");
    header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
    header('Content-Transfer-Encoding: Binary');
    header("Content-length: " . strlen($file_str));
    header('Content-Disposition: attachment; filename=sales_report.csv');
  }
  echo $file_str;
  die;
} elseif ($srExp == 1) {
  echo '<br><p align="right"><a href="' . tep_href_link(FILENAME_STATS_SALES_REPORT2, tep_get_all_get_params(array('export'))) . '">' . tep_image_button('back.png', IMAGE_BACK) . '</a></p>';
}
?>