<?php
/*
  $Id: ckmerchantpartners.php,v 1.47 2004/02/06 05:51:31 hpdl Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
----- Tony Cun tcun@merchantpartners.com ------
*/

  class ckmerchantpartners {
    var $code, $title, $description, $enabled;

// class constructor
    function __construct() {
      global $order;

      $this->code = 'ckmerchantpartners';
      $this->title = MODULE_PAYMENT_CKMERCHANTPARTNERS_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_CKMERCHANTPARTNERS_TEXT_DESCRIPTION;
      if (defined('MODULE_PAYMENT_CKMERCHANTPARTNERS_SORT_ORDER')) {
        $this->sort_order = (int)MODULE_PAYMENT_CKMERCHANTPARTNERS_SORT_ORDER;
      } else {
        $this->sort_order = '';
      }

      if (defined('MODULE_PAYMENT_CKMERCHANTPARTNERS_STATUS')) {
        $this->enabled = ((MODULE_PAYMENT_CKMERCHANTPARTNERS_STATUS == 'True') ? true : false);
      } else {
        $this->enabled = false;
      }

      if (defined('MODULE_PAYMENT_CKMERCHANTPARTNERS_ORDER_STATUS_ID')) {
        if ((int)MODULE_PAYMENT_CKMERCHANTPARTNERS_ORDER_STATUS_ID > 0) {
          $this->order_status = MODULE_PAYMENT_CKMERCHANTPARTNERS_ORDER_STATUS_ID;
        }
      } else {
        $this->order_status = 0;
      }


      if (is_object($order)) $this->update_status();

      $this->form_action_url = 'https://trans.atsbank.com/cgi-bin/trans.cgi';

    }

// class methods
    function update_status() {
      global $order;

      if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_CKMERCHANTPARTNERS_ZONE > 0) ) {
        $check_flag = false;
        $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_CKMERCHANTPARTNERS_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
        while ($check = tep_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->billing['zone_id']) {
            $check_flag = true;
            break;
          }
        }

        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
    }

    function javascript_validation() {
      $js = '  if (payment_value == "' . $this->code . '") {' . "\n" .
            '    var ck_owner = document.checkout_payment.ckmerchantpartners_ck_owner.value;' . "\n" .
            '    var ck_number = document.checkout_payment.ckmerchantpartners_ck_number.value;' . "\n" .
            '    if (ck_owner == "") { ' . "\n" .
            '      error_message = error_message + "' . MODULE_PAYMENT_CKMERCHANTPARTNERS_TEXT_JS_CK_OWNER . '";' . "\n" .
            '      error = 1;' . "\n" .
            '    }' . "\n" .
            '    if (ck_number == "") {' . "\n" .
            '      error_message = error_message + "' . MODULE_PAYMENT_CKMERCHANTPARTNERS_TEXT_JS_CK_NUMBER . '";' . "\n" .
            '      error = 1;' . "\n" .
            '    }' . "\n" .
            '  }' . "\n";

      return $js;
    }

    function selection() {
      global $order;

      for ($i=1; $i < 13; $i++) {
        $expires_month[] = array('id' => sprintf('%02d', $i), 'text' => strftime('%B',mktime(0,0,0,$i,1,2000)));
      }

      $today = getdate();
      for ($i=$today['year']; $i < $today['year']+10; $i++) {
        $expires_year[] = array('id' => strftime('%y',mktime(0,0,0,1,1,$i)), 'text' => strftime('%Y',mktime(0,0,0,1,1,$i)));
      }

      $selection = array('id' => $this->code,
                         'module' => $this->title,
                         'fields' => array(array('title' => MODULE_PAYMENT_CKMERCHANTPARTNERS_TEXT_CHECK_OWNER,
                                                 'field' => tep_draw_input_field('ckmerchantpartners_ck_owner', $order->billing['firstname'] . ' ' . $order->billing['lastname'], 'class="form-control"')),
                                           array('title' => MODULE_PAYMENT_CKMERCHANTPARTNERS_TEXT_CHECK_NUMBER,
                                                 'field' => tep_draw_input_field('ckmerchantpartners_ck_number', '', 'class="form-control"')),
                                           array('title' => MODULE_PAYMENT_CKMERCHANTPARTNERS_TEXT_CHECK_ABA,
                                                 'field' => tep_draw_input_field('ckmerchantpartners_ck_aba', '', 'class="form-control"'))));

      return $selection;
    }


    function pre_confirmation_check() {
      include(DIR_WS_CLASSES . 'cc_validation.php');

      $cc_validation = new cc_validation();
      $result = '1';

      $error = '';
      switch ($result) {
        case -1:
          $error = sprintf(TEXT_CCVAL_ERROR_UNKNOWN_CARD, substr($cc_validation->ck_number, 0, 4));
          break;
        case -2:
        case -3:
        case -4:
          $error = TEXT_CCVAL_ERROR_INVALID_DATE;
          break;
        case false:
          $error = TEXT_CCVAL_ERROR_INVALID_NUMBER;
          break;
      }

      if ( ($result == false) || ($result < 1) ) {
        $payment_error_return = 'payment_error=' . $this->code . '&error=' . urlencode($error) . '&ckmerchantpartners_cc_owner=' . urlencode($_POST['ckmerchantpartners_cc_owner']) . '&ckmerchantpartners_cc_expires_month=' . $_POST['ckmerchantpartners_cc_expires_month'] . '&ckmerchantpartners_cc_expires_year=' . $_POST['ckmerchantpartners_cc_expires_year'] . '&ckmerchantpartners_cc_checkcode=' . $_POST['ckmerchantpartners_cc_checkcode'];

        tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
      }

      $this->cc_card_type = 'CK'; // $cc_validation->cc_type;
      $this->ck_number = $_POST['ckmerchantpartners_ck_number'];   // $cc_validation->ck_number;
      $this->ck_aba = $_POST['ckmerchantpartners_ck_aba']; // $cc_validation->cc_expiry_month;
      $this->cc_expiry_year = $cc_validation->cc_expiry_year;
    }

    function confirmation() {
      $confirmation = array('title' => $this->title . ': ' . $this->cc_card_type,
                            'fields' => array(array('title' => MODULE_PAYMENT_CKMERCHANTPARTNERS_TEXT_CHECK_OWNER,
                                                    'field' => $_POST['ckmerchantpartners_ck_owner']),
                                              array('title' => MODULE_PAYMENT_CKMERCHANTPARTNERS_TEXT_CHECK_NUMBER,
                                                    'field' => $_POST['ckmerchantpartners_ck_number']),
                                              array('title' => MODULE_PAYMENT_CKMERCHANTPARTNERS_TEXT_CHECK_ABA,
                                                    'field' => $_POST['ckmerchantpartners_ck_aba'])));


      return $confirmation;
    }


   function process_button() {
    global $order,  $session_id;
    $ns_quicksale = 'ns_quicksale_check';

    $declineurl = 'http://trans.atsbank.com/cgi-bin/redirect.cgi?' . tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL', true) . '?' .  'payment_error=' . $this->code . '&ckmerchantpartners_ck_owner=' . urlencode($_POST['ckmerchantpartners_ck_owner']);

    $accepturl = 'http://trans.atsbank.com/cgi-bin/redirect.cgi?' . tep_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL', false) . '?';

    $process_button_string =   tep_draw_hidden_field('action', $ns_quicksale) .
                               tep_draw_hidden_field('acctid', MODULE_PAYMENT_CKMERCHANTPARTNERS_ACCTID) .
                               tep_draw_hidden_field('subid', MODULE_PAYMENT_CKMERCHANTPARTNERS_SUBID) .
                               tep_draw_hidden_field('ckname', $_POST['ckmerchantpartners_ck_owner']) .
                               tep_draw_hidden_field('ckacct', $_POST['ckmerchantpartners_ck_number']) .
                               tep_draw_hidden_field('ckaba', $_POST['ckmerchantpartners_ck_aba']) .
                         tep_draw_hidden_field('ci_memo', $_POST['comments']) .
                               tep_draw_hidden_field('amount', number_format($order->info['total'], 2 )) .
                               tep_draw_hidden_field('ci_email', $order->customer['email_address']) .
                               tep_draw_hidden_field('ci_billaddr1', $order->customer['street_address']) .
                               tep_draw_hidden_field('ci_billaddr2', $order->customer['suburb']) .
                               tep_draw_hidden_field('ci_billcity', $order->customer['city']) .
                               tep_draw_hidden_field('ci_billstate', $order->customer['state']) .
                               tep_draw_hidden_field('ci_billzip', $order->customer['postcode']) .
                               tep_draw_hidden_field('ci_billcountry', $order->customer['country']['title']) .
                               tep_draw_hidden_field('ship_name', $order->delivery['firstname'] . ' ' . $order->delivery['lastname']) .
                               tep_draw_hidden_field('ship_addr_1', $order->delivery['street_address']) .
                               tep_draw_hidden_field('ship_addr_2', $order->delivery['suburb']) .
                               tep_draw_hidden_field('ship_city', $order->delivery['city']) .
                               tep_draw_hidden_field('ship_state', $order->delivery['state']) .
                               tep_draw_hidden_field('ship_post_code', $order->delivery['postcode']) .
                               tep_draw_hidden_field('ship_country', $order->delivery['country']['title']) .
                               tep_draw_hidden_field('Session_ID', $_SESSION['customer_id']) .
                               tep_draw_hidden_field('declineurl', $declineurl, '', 'SSL', false) .
                               tep_draw_hidden_field('accepturl', $accepturl, '', 'SSL', false) .
                               tep_draw_hidden_field('ci_phone', $order->customer['telephone']);

      return $process_button_string;
    }

    function before_process() {

    }



    function after_process() {
      return false;
    }

    function get_error() {
      if (isset($_GET['Status'])) {
         $error = array('title' => CKMERCHANTPARTNERS_ERROR_HEADING,
                     'error' => stripslashes(urldecode($_GET['Status'])) . ': ' .  stripslashes(urldecode($_GET['Reason'])));
      }
      else {
      $error = array('title' => CKMERCHANTPARTNERS_ERROR_HEADING,
                     'error' => stripslashes(urldecode($_GET['error'])));
      }
      return $error;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_CKMERCHANTPARTNERS_STATUS'");
        $this->_check = tep_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Enable merchantPartners Check Module', 'MODULE_PAYMENT_CKMERCHANTPARTNERS_STATUS', 'True', 'Do you want to accept merchantPartners payments?', '6', '1', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('AcctID', 'MODULE_PAYMENT_CKMERCHANTPARTNERS_ACCTID', 'TEST0', 'The acctID used for the merchantPartners service', '6', '2', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('SubID', 'MODULE_PAYMENT_CKMERCHANTPARTNERS_SUBID', '', 'The subID for the merchantPartners service', '6', '3', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Payment Zone', 'MODULE_PAYMENT_CKMERCHANTPARTNERS_ZONE', '0', 'If a zone is selected, enable this payment method for that zone only.', '6', '2', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Sort order of display.', 'MODULE_PAYMENT_CKMERCHANTPARTNERS_SORT_ORDER', '0', 'Sort order of display. Lowest is displayed first.', '6', '0', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) values ('Set Order Status', 'MODULE_PAYMENT_CKMERCHANTPARTNERS_ORDER_STATUS_ID', '0', 'Set the status of orders made with this payment module to this value', '6', '0', 'tep_cfg_pull_down_order_statuses(', 'tep_get_order_status_name', now())");
    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_PAYMENT_CKMERCHANTPARTNERS_STATUS', 'MODULE_PAYMENT_CKMERCHANTPARTNERS_ACCTID', 'MODULE_PAYMENT_CKMERCHANTPARTNERS_SUBID', 'MODULE_PAYMENT_CKMERCHANTPARTNERS_ZONE', 'MODULE_PAYMENT_CKMERCHANTPARTNERS_ORDER_STATUS_ID', 'MODULE_PAYMENT_CKMERCHANTPARTNERS_SORT_ORDER');
    }
  }
?>
