
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `life1212`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]articles`
--

CREATE TABLE `[[dbprefix]]articles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `modification_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `blog_id` int(10) unsigned NOT NULL DEFAULT '0',
  `status` int(5) NOT NULL DEFAULT '1',
  `num_reads` int(10) DEFAULT '0',
  `properties` text NOT NULL,
  `slug` varchar(255) NOT NULL,
  `num_comments` int(10) NOT NULL DEFAULT '0',
  `num_nonspam_comments` int(10) NOT NULL DEFAULT '0',
  `num_trackbacks` int(10) NOT NULL DEFAULT '0',
  `num_nonspam_trackbacks` int(10) NOT NULL DEFAULT '0',
  `global_category_id` int(10) NOT NULL DEFAULT '0',
  `in_summary_page` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `num_reads` (`num_reads`),
  KEY `user_id` (`user_id`),
  KEY `slug` (`slug`),
  KEY `blog_id_status_date` (`blog_id`,`status`,`date`),
  KEY `global_category_status` (`global_category_id`,`status`),
  KEY `date` (`date`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]articles`
--

INSERT INTO `[[dbprefix]]articles` VALUES
(1, '[[regtime]]', '[[regtime]]', 1, 1, 1, 0, 'a:0:{}', 'welcome', 0, 0, 0, 0, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]articles_categories`
--

CREATE TABLE `[[dbprefix]]articles_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL,
  `blog_id` int(10) unsigned NOT NULL DEFAULT '0',
  `last_modification` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `in_main_page` tinyint(1) NOT NULL DEFAULT '1',
  `parent_id` int(10) NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `properties` text NOT NULL,
  `mangled_name` varchar(255) NOT NULL,
  `num_articles` int(10) NOT NULL DEFAULT '0',
  `num_published_articles` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `blog_id` (`blog_id`),
  KEY `mangled_name` (`mangled_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]articles_categories`
--

INSERT INTO `[[dbprefix]]articles_categories` VALUES
(1, 'General', 'General', 1, '[[regtime]]', 1, 0, '', 'a:0:{}', 'general', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]articles_comments`
--

CREATE TABLE `[[dbprefix]]articles_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `article_id` int(10) unsigned NOT NULL DEFAULT '0',
  `blog_id` int(10) unsigned NOT NULL DEFAULT '0',
  `topic` text NOT NULL,
  `text` text,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `user_id` int(10) DEFAULT '0',
  `user_email` varchar(255) DEFAULT NULL,
  `user_url` varchar(255) DEFAULT NULL,
  `user_name` varchar(255) NOT NULL DEFAULT 'Anonymous',
  `parent_id` int(10) unsigned DEFAULT '0',
  `client_ip` varchar(15) DEFAULT '0.0.0.0',
  `send_notification` tinyint(1) DEFAULT '0',
  `status` tinyint(2) DEFAULT '1',
  `spam_rate` float DEFAULT '0',
  `properties` text NOT NULL,
  `normalized_text` text NOT NULL,
  `normalized_topic` text NOT NULL,
  `type` int(3) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`),
  KEY `article_id_blog_id` (`article_id`,`blog_id`),
  KEY `article_id_type` (`article_id`,`type`),
  KEY `blog_id_type` (`blog_id`,`type`),
  FULLTEXT KEY `normalized_fields` (`normalized_text`,`normalized_topic`),
  FULLTEXT KEY `normalized_text` (`normalized_text`),
  FULLTEXT KEY `normalized_topic` (`normalized_topic`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]articles_notifications`
--

CREATE TABLE `[[dbprefix]]articles_notifications` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `blog_id` int(10) NOT NULL DEFAULT '0',
  `user_id` int(10) NOT NULL DEFAULT '0',
  `article_id` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `article_id` (`article_id`),
  KEY `user_id` (`user_id`),
  KEY `blog_id` (`blog_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]articles_text`
--

CREATE TABLE `[[dbprefix]]articles_text` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `article_id` int(10) NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  `topic` text NOT NULL,
  `normalized_text` text NOT NULL,
  `normalized_topic` text NOT NULL,
  `mangled_topic` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `article_id` (`article_id`),
  FULLTEXT KEY `normalized_text` (`normalized_text`),
  FULLTEXT KEY `normalized_topic` (`normalized_topic`),
  FULLTEXT KEY `normalized_fields` (`normalized_text`,`normalized_topic`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]articles_text`
--

INSERT INTO `[[dbprefix]]articles_text` VALUES
(1, 1, 'If you can read this post, it means that the registration process was successful and that you can start blogging', 'Congratulations!', 'If you can read this post it means that the registration process was successful and that you can start blogging', 'Congratulations ', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]article_categories_link`
--

CREATE TABLE `[[dbprefix]]article_categories_link` (
  `article_id` int(10) NOT NULL,
  `category_id` int(10) NOT NULL,
  PRIMARY KEY (`article_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]article_categories_link`
--

INSERT INTO `[[dbprefix]]article_categories_link` VALUES
(1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bayesian_filter_info`
--

CREATE TABLE `[[dbprefix]]bayesian_filter_info` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `blog_id` int(10) unsigned DEFAULT NULL,
  `total_spam` int(10) unsigned DEFAULT NULL,
  `total_nonspam` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blog_id` (`blog_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]bayesian_filter_info`
--

INSERT INTO `[[dbprefix]]bayesian_filter_info` VALUES
(1, 1, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bayesian_tokens`
--

CREATE TABLE `[[dbprefix]]bayesian_tokens` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `blog_id` int(10) unsigned DEFAULT NULL,
  `token` char(100) DEFAULT NULL,
  `spam_occurrences` int(10) unsigned DEFAULT NULL,
  `nonspam_occurrences` int(10) unsigned DEFAULT NULL,
  `prob` float DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blog_id` (`blog_id`),
  KEY `token` (`token`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blogs`
--

CREATE TABLE `[[dbprefix]]blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `blog` varchar(50) NOT NULL,
  `owner_id` int(10) unsigned NOT NULL DEFAULT '0',
  `blog_category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `about` text,
  `settings` text NOT NULL,
  `mangled_blog` varchar(50) NOT NULL,
  `status` int(4) NOT NULL DEFAULT '1',
  `show_in_summary` int(4) NOT NULL DEFAULT '1',
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `last_update_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_posts` int(10) NOT NULL DEFAULT '0',
  `num_comments` int(10) NOT NULL DEFAULT '0',
  `num_trackbacks` int(10) NOT NULL DEFAULT '0',
  `custom_domain` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `owner_id` (`owner_id`),
  KEY `mangled_blog` (`mangled_blog`),
  KEY `blog_category_id` (`blog_category_id`),
  KEY `custom_domain` (`custom_domain`),
  KEY `create_date` (`create_date`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]blogs`
--

INSERT INTO `[[dbprefix]]blogs` VALUES
(1, '[[site_name]]', 1, 1, '', 'O:12:"BlogSettings":2:{s:6:"_props";a:14:{s:6:"locale";s:5:"[[language]]";s:14:"show_posts_max";s:2:"15";s:8:"template";s:8:"standard";s:17:"show_more_enabled";s:1:"1";s:16:"recent_posts_max";s:2:"10";s:17:"show_comments_max";s:2:"20";s:17:"xmlrpc_ping_hosts";a:2:{i:0;s:27:"http://rpc.weblogs.com/RPC2";i:1;s:0:"";}s:16:"htmlarea_enabled";s:1:"1";s:22:"pull_down_menu_enabled";N;s:16:"comments_enabled";s:1:"1";s:16:"categories_order";i:0;s:14:"comments_order";s:1:"1";s:11:"time_offset";s:1:"0";s:14:"articles_order";i:2;}s:11:"_keyFilters";a:0:{}}', '[[mangledblog]]', 1, 1, '[[regtime]]', '[[regtime]]', 1, 0, 0, '[[mangledblog]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blog_categories`
--

CREATE TABLE `[[dbprefix]]blog_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `mangled_name` varchar(255) NOT NULL,
  `properties` text NOT NULL,
  `num_blogs` int(10) NOT NULL DEFAULT '0',
  `num_active_blogs` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mangled_name` (`mangled_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]blog_categories`
--

INSERT INTO `[[dbprefix]]blog_categories` VALUES
(1, 'General', 'General', 'general', 'a:0:{}', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `config_key` varchar(255) NOT NULL,
  `config_value` text NOT NULL,
  `value_type` int(3) DEFAULT '0',
  PRIMARY KEY (`config_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
('comments_enabled', '1', 1),
('rdf_enabled', '1', 1),
('temp_folder', './tmp', 3),
('base_url', '[[softurl]]', 3),
('show_posts_max', '15', 1),
('recent_posts_max', '10', 1),
('default_template', 'standard', 3),
('template_folder', './templates', 3),
('default_blog_id', '1', 1),
('default_locale', '[[language]]', 3),
('html_allowed_tags_in_comments', '<a><i><br><br/><b>', 3),
('referer_tracker_enabled', '1', 1),
('rss_parser_enabled', '1', 1),
('show_more_enabled', '1', 1),
('show_more_threshold', '150', 1),
('update_article_reads', '1', 1),
('email_service_enabled', '1', 1),
('post_notification_source_address', 'noreply@your.host.com', 3),
('request_format_mode', '1', 1),
('xmlrpc_ping_hosts', 'a:2:{i:0;s:27:"http://rpc.weblogs.com/RPC2";i:1;s:0:"";}', 5),
('trackback_server_enabled', '1', 1),
('htmlarea_enabled', '1', 1),
('default_pull_down_menu_enabled', '0', 1),
('plugin_manager_enabled', '1', 1),
('check_email_address_validity', '0', 1),
('summary_page_show_max', '15', 1),
('minimum_password_length', '4', 1),
('templates', 'a:1:{i:0;s:8:"standard";}', 5),
('locales', 'a:20:{i:0;s:5:"it_IT";i:1;s:5:"zh_TW";i:2;s:5:"de_DE";i:3;s:5:"ru_RU";i:4;s:5:"zh_CN";i:5;s:5:"nl_NL";i:6;s:5:"en_UK";i:7;s:5:"pt_BR";i:8;s:5:"es_ES";i:9;s:5:"hu_HU";i:10;s:5:"gl_ES";i:11;s:5:"pl_PL";i:12;s:5:"ja_JP";i:13;s:5:"vi_VN";i:14;s:5:"ua_UA";i:15;s:5:"ca_ES";i:16;s:5:"fr_FR";i:17;s:5:"tt_RU";i:18;s:5:"en_US";i:19;s:5:"id_ID";}', 5),
('email_service_type', 'php', 3),
('smtp_host', 'your.smtp.host.com', 3),
('smtp_port', '25', 1),
('smtp_use_authentication', '0', 1),
('smtp_username', '', 3),
('smtp_password', '', 3),
('locale_folder', './locale', 3),
('xmlrpc_ping_enabled', '0', 1),
('path_to_tar', '/bin/tar', 3),
('path_to_gzip', '/bin/gzip', 3),
('path_to_bz2', '/usr/bin/bzip2', 3),
('path_to_unzip', '/usr/bin/unzip', 3),
('users_can_add_templates', '1', 1),
('maximum_file_upload_size', '2000000', 1),
('upload_forbidden_files', '*.php *.php3 *.php4 *.phtml *.htm *.html *.exe *.com *.bat .htaccess *.sh', 3),
('comments_order', '1', 1),
('security_pipeline_enabled', '1', 1),
('maximum_comment_size', '0', 1),
('resources_enabled', '1', 1),
('thumbnail_method', 'gd', 3),
('path_to_convert', '', 3),
('thumbnail_height', '120', 1),
('thumbnail_width', '120', 1),
('thumbnails_keep_aspect_ratio', '1', 1),
('xmlrpc_api_enabled', '1', 1),
('uploads_enabled', '1', 1),
('default_rss_profile', 'rss090', 3),
('bayesian_filter_enabled', '1', 2),
('bayesian_filter_spam_probability_treshold', '0.9', 6),
('bayesian_filter_nonspam_probability_treshold', '0.2', 6),
('bayesian_filter_min_length_token', '3', 1),
('bayesian_filter_max_length_token', '100', 1),
('bayesian_filter_number_significant_tokens', '15', 1),
('bayesian_filter_spam_comments_action', '0', 1),
('thumbnail_format', 'same', 3),
('resources_folder', './gallery/', 3),
('beautify_comments_text', '1', 1),
('disable_apache_error_handler', '0', 1),
('show_future_posts_in_calendar', '0', 1),
('xhtml_converter_enabled', '1', 1),
('xhtml_converter_aggresive_mode_enabled', '0', 1),
('search_engine_enabled', '1', 1),
('search_in_custom_fields', '1', 1),
('search_in_comments', '1', 1),
('resources_quota', '0', 1),
('category_link_format', '/blog/{blogname}/{catname}$', 3),
('blog_link_format', '/blog/{blogname}$', 3),
('archive_link_format', '/blog/{blogname}/archives/{year}/?{month}/?{day}', 3),
('user_posts_link_format', '/blog/{blogname}/user/{username}$', 3),
('post_trackbacks_link_format', '/blog/{blogname}/post/trackbacks/{postname}$', 3),
('template_link_format', '/blog/{blogname}/content/{templatename}$', 3),
('album_link_format', '/blog/{blogname}/album/{albumname}$', 3),
('resource_link_format', '/blog/{blogname}/resource/{albumname}/{resourcename}$', 3),
('resource_preview_link_format', '/blog/{blogname}/resource/{albumname}/preview/{resourcename}$', 3),
('resource_medium_size_preview_link_format', '/blog/{blogname}/resource/{albumname}/preview-med/{resourcename}$', 3),
('resource_download_link_format', '/blog/{blogname}/resource/{albumname}/download/{resourcename}$', 3),
('permalink_format', '/blog/{blogname}/{catname}/{year}/{month}/{day}/{postname}$', 3),
('script_name', 'index.php', 3),
('resource_server_http_cache_enabled', '1', 1),
('medium_size_thumbnail_width', '640', 1),
('medium_size_thumbnail_height', '480', 1),
('subdomains_enabled', '0', 1),
('include_blog_id_in_url', '1', 1),
('send_xmlrpc_pings_enabled_by_default', '1', 1),
('forbidden_usernames', 'admin www blog ftp wiki forums', 3),
('force_registration_confirmation', '0', 1),
('summary_items_per_page', '25', 3),
('subdomains_base_url', '', 3),
('autosave_new_drafts_time_millis', '300000', 3),
('save_drafts_via_xmlhttprequest_enabled', '1', 1),
('need_email_confirm_registration', '1', 1),
('force_one_blog_per_email_account', '0', 1),
('summary_show_agreement', '1', 1),
('default_time_offset', '0', 3),
('template_cache_enabled', '1', 1),
('template_http_cache_enabled', '1', 1),
('template_compile_check', '1', 1),
('update_cached_article_reads', '1', 1),
('allow_php_code_in_templates', '0', 1),
('thumbnail_generator_use_smoothing_algorithm', '1', 1),
('template_cache_lifetime', '-1', 3),
('use_http_accept_language_detection', '0', 1),
('session_save_path', '', 3),
('skip_dashboard', '0', 1),
('use_captcha_auth', '0', 1),
('page_suffix_format', '/page/{page}', 3),
('urlize_word_separator', '-', 3),
('summary_template_cache_lifetime', '0', 1),
('http_cache_lifetime', '1800', 1),
('blog_does_not_exist_url', '[[softurl]]', 3),
('default_global_article_category_id', '1', 1),
('hard_show_posts_max', '50', 1),
('hard_recent_posts_max', '25', 1),
('show_comments_max', '20', 1),
('hard_show_comments_max', '50', 1),
('upload_allowed_files', '', 3),
('template_load_order', '2', 1),
('summary_service_name', 'Your Service Name', 3),
('allow_javascript_blocks_in_posts', '0', 1),
('trim_whitespace_output', '1', 1),
('summary_disable_registration', '1', 1),
('bb2_log_table', 'bad_behavior', 3),
('bb2_display_stats', '1', 2),
('bb2_strict', '', 2),
('bb2_verbose', '', 2),
('bb2_httpbl_key', '', 3),
('bb2_httpbl_threat', '25', 3),
('bb2_httpbl_maxage', '30', 3),
('bb2_offsite_forms', '', 2),
('bb2_reverse_proxy', '', 2),
('bb2_reverse_proxy_header', 'X-Forwarded-For', 3),
('bb2_installed', '1', 2);
-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]custom_fields_definition`
--

CREATE TABLE `[[dbprefix]]custom_fields_definition` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `field_name` varchar(255) NOT NULL,
  `field_description` text NOT NULL,
  `field_type` int(2) NOT NULL DEFAULT '1',
  `field_values` text NOT NULL,
  `blog_id` int(10) NOT NULL DEFAULT '0',
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `searchable` tinyint(1) DEFAULT '1',
  `hidden` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`,`field_name`),
  KEY `blog_id` (`blog_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]custom_fields_values`
--

CREATE TABLE `[[dbprefix]]custom_fields_values` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `field_id` int(10) NOT NULL DEFAULT '0',
  `field_value` text NOT NULL,
  `normalized_value` text NOT NULL,
  `blog_id` int(10) DEFAULT NULL,
  `article_id` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `article_id` (`article_id`),
  KEY `field_id` (`field_id`),
  KEY `blog_id_article_id` (`blog_id`,`article_id`),
  FULLTEXT KEY `normalized_value` (`normalized_value`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]filtered_content`
--

CREATE TABLE `[[dbprefix]]filtered_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `reg_exp` text,
  `blog_id` int(10) NOT NULL DEFAULT '0',
  `reason` text,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `blog_id` (`blog_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gallery_albums`
--

CREATE TABLE `[[dbprefix]]gallery_albums` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `owner_id` int(10) NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `name` varchar(255) NOT NULL,
  `flags` int(10) NOT NULL DEFAULT '0',
  `parent_id` int(10) NOT NULL DEFAULT '0',
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `properties` text NOT NULL,
  `show_album` tinyint(1) DEFAULT '1',
  `normalized_description` text NOT NULL,
  `normalized_name` varchar(255) NOT NULL,
  `mangled_name` varchar(255) NOT NULL,
  `num_resources` int(10) NOT NULL DEFAULT '0',
  `num_children` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`),
  KEY `mangled_name` (`mangled_name`),
  KEY `owner_id_mangled_name` (`owner_id`,`mangled_name`),
  FULLTEXT KEY `normalized_name` (`normalized_name`),
  FULLTEXT KEY `normalized_description` (`normalized_description`),
  FULLTEXT KEY `normalized_fields` (`normalized_name`,`normalized_description`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]gallery_albums`
--

INSERT INTO `[[dbprefix]]gallery_albums` VALUES
(1, 1, 'General', 'General', 1, 0, '[[regtime]]', 'a:0:{}', 1, 'General', 'General', 'general', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gallery_resources`
--

CREATE TABLE `[[dbprefix]]gallery_resources` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `owner_id` int(10) NOT NULL DEFAULT '0',
  `album_id` int(10) NOT NULL DEFAULT '0',
  `description` text,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `flags` int(10) DEFAULT '0',
  `resource_type` int(3) DEFAULT NULL,
  `file_path` varchar(255) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `file_size` int(20) NOT NULL DEFAULT '0',
  `metadata` text,
  `thumbnail_format` varchar(4) NOT NULL DEFAULT 'same',
  `normalized_description` text NOT NULL,
  `properties` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `owner_id` (`owner_id`),
  KEY `file_name` (`file_name`),
  KEY `album_id_owner_id` (`album_id`,`owner_id`),
  KEY `resource_type` (`resource_type`),
  FULLTEXT KEY `normalized_description` (`normalized_description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]global_articles_categories`
--

CREATE TABLE `[[dbprefix]]global_articles_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `mangled_name` varchar(255) NOT NULL,
  `properties` text NOT NULL,
  `num_articles` int(10) NOT NULL DEFAULT '0',
  `num_active_articles` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mangled_name` (`mangled_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]global_articles_categories`
--

INSERT INTO `[[dbprefix]]global_articles_categories` VALUES
(1, 'General', 'General', 'general', 'a:0:{}', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]host_blocking_rules`
--

CREATE TABLE `[[dbprefix]]host_blocking_rules` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `reason` text,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` int(10) NOT NULL DEFAULT '0',
  `block_type` int(1) DEFAULT '1',
  `list_type` int(1) DEFAULT '1',
  `mask` int(2) DEFAULT '0',
  `host` varchar(15) DEFAULT '0.0.0.0',
  PRIMARY KEY (`id`),
  KEY `block_type` (`block_type`),
  KEY `blog_id_block_type` (`blog_id`,`block_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mylinks`
--

CREATE TABLE `[[dbprefix]]mylinks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `url` varchar(255) NOT NULL,
  `name` varchar(100) DEFAULT NULL,
  `description` text NOT NULL,
  `blog_id` int(10) unsigned NOT NULL DEFAULT '0',
  `rss_feed` varchar(255) NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `properties` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `blog_id` (`blog_id`),
  KEY `category_id` (`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mylinks_categories`
--

CREATE TABLE `[[dbprefix]]mylinks_categories` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `blog_id` int(10) NOT NULL DEFAULT '0',
  `last_modification` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `properties` text NOT NULL,
  `num_links` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `blog_id` (`blog_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]mylinks_categories`
--

INSERT INTO `[[dbprefix]]mylinks_categories` VALUES
(1, 'General', 1, '[[regtime]]', 'a:0:{}', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]permissions`
--

CREATE TABLE `[[dbprefix]]permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `permission` varchar(25) NOT NULL,
  `description` varchar(100) NOT NULL,
  `admin_only` int(1) NOT NULL DEFAULT '1',
  `core_perm` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=67 ;

--
-- Dumping data for table `[[dbprefix]]permissions`
--

INSERT INTO `[[dbprefix]]permissions` VALUES
(1, 'login_perm', 'login_perm_desc', 1, 1),
(2, 'blog_access', 'blog_access_desc', 0, 1),
(3, 'add_post', 'add_post_desc', 0, 1),
(4, 'update_post', 'update_post_desc', 0, 1),
(5, 'view_posts', 'view_posts_desc', 0, 1),
(6, 'add_category', 'add_category_desc', 0, 1),
(7, 'update_category', 'update_category_desc', 0, 1),
(8, 'view_categories', 'view_categories_desc', 0, 1),
(9, 'add_link', 'add_link_desc', 0, 1),
(10, 'update_link', 'update_link_desc', 0, 1),
(11, 'view_links', 'view_links_desc', 0, 1),
(12, 'add_link_category', 'add_link_category_desc', 0, 1),
(13, 'update_link_category', 'update_link_category_desc', 0, 1),
(14, 'view_link_categories', 'view_link_categories_desc', 0, 1),
(15, 'update_comment', 'update_comment_desc', 0, 1),
(16, 'view_comments', 'view_comments_desc', 0, 1),
(17, 'update_trackback', 'update_trackback_desc', 0, 1),
(18, 'view_trackbacks', 'view_trackbacks_desc', 0, 1),
(19, 'add_custom_field', 'add_custom_field_desc', 0, 1),
(20, 'update_custom_field', 'update_custom_field_desc', 0, 1),
(21, 'view_custom_fields', 'view_custom_fields_desc', 0, 1),
(22, 'add_resource', 'add_resource_desc', 0, 1),
(23, 'update_resource', 'update_resource_desc', 0, 1),
(24, 'add_album', 'add_album_desc', 0, 1),
(25, 'update_album', 'update_album_desc', 0, 1),
(26, 'view_resources', 'view_resources_desc', 0, 1),
(27, 'update_blog', 'update_blog_desc', 0, 1),
(28, 'add_blog_user', 'add_blog_user_desc', 0, 1),
(29, 'update_blog_user', 'update_blog_user_desc', 0, 1),
(30, 'view_blog_users', 'view_blog_users_desc', 0, 1),
(31, 'add_blog_template', 'add_blog_template_desc', 0, 1),
(32, 'update_blog_template', 'update_blog_template_desc', 0, 1),
(33, 'view_blog_templates', 'view_blog_templates_desc', 0, 1),
(34, 'view_blog_stats', 'view_blog_stats_desc', 0, 1),
(35, 'update_blog_stats', 'update_blog_stats_desc', 0, 1),
(36, 'view_all_user_articles', 'view_all_user_articles_desc', 0, 1),
(37, 'update_all_user_articles', 'update_all_user_articles_desc', 0, 1),
(38, 'manage_plugins', 'manage_plugins_desc', 0, 1),
(39, 'add_user', 'add_user_desc', 1, 1),
(40, 'view_users', 'view_users_desc', 1, 1),
(41, 'edit_blog_admin_mode', 'edit_blog_admin_mode_desc', 1, 1),
(42, 'update_user', 'update_user_desc', 1, 1),
(43, 'add_permission', 'add_permission_desc', 1, 1),
(44, 'view_permissions', 'view_permissions_desc', 1, 1),
(45, 'update_permission', 'update_permission_desc', 1, 1),
(46, 'add_site_blog', 'add_site_blog_desc', 1, 1),
(47, 'view_site_blogs', 'view_site_blogs_desc', 1, 1),
(48, 'update_site_blog', 'update_site_blog_desc', 1, 1),
(49, 'add_blog_category', 'add_blog_category_desc', 1, 1),
(50, 'view_blog_categories', 'view_blog_categories', 1, 1),
(51, 'update_blog_category', 'update_blog_category_desc', 1, 1),
(52, 'add_locale', 'add_locale_desc', 1, 1),
(53, 'view_locales', 'view_locales_desc', 1, 1),
(54, 'update_locale', 'update_locale_desc', 1, 1),
(55, 'add_template', 'add_template_desc', 1, 1),
(56, 'view_templates', 'view_templates_desc', 1, 1),
(57, 'update_template', 'update_template_desc', 1, 1),
(58, 'add_global_category', 'add_global_article_category_desc', 1, 1),
(59, 'view_global_categories', 'view_global_article_categories_desc', 1, 1),
(60, 'update_global_category', 'update_global_article_category_desc', 1, 1),
(61, 'view_global_settings', 'view_global_settings_desc', 1, 1),
(62, 'update_global_settings', 'update_global_settings_desc', 1, 1),
(63, 'view_plugins', 'view_plugins_desc', 1, 1),
(64, 'update_plugin_settings', 'update_plugin_settings_desc', 1, 1),
(65, 'purge_data', 'purge_data_desc', 1, 1),
(66, 'manage_admin_plugins', 'manage_admin_plugins_desc', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpbb2_users`
--

CREATE TABLE `[[dbprefix]]phpbb2_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `phpbb_id` int(10) unsigned NOT NULL,
  `full_name` varchar(255) NOT NULL,
  `about` text,
  `properties` text NOT NULL,
  `resource_picture_id` int(10) NOT NULL DEFAULT '0',
  `status` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `phpbb_id` (`phpbb_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]referers`
--

CREATE TABLE `[[dbprefix]]referers` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `url` text NOT NULL,
  `article_id` int(10) NOT NULL DEFAULT '0',
  `blog_id` int(10) NOT NULL DEFAULT '0',
  `hits` int(10) DEFAULT '1',
  `last_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `article_id` (`article_id`),
  KEY `blog_id_article_id` (`blog_id`,`article_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tmp_users_permissions`
--

CREATE TABLE `[[dbprefix]]tmp_users_permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `blog_id` int(10) unsigned NOT NULL DEFAULT '0',
  `permission_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `blog_id` (`blog_id`),
  KEY `user_id_permission_id` (`user_id`,`permission_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user` varchar(15) NOT NULL,
  `password` varchar(32) NOT NULL,
  `email` varchar(255) NOT NULL,
  `full_name` varchar(255) NOT NULL,
  `about` text,
  `properties` text NOT NULL,
  `status` int(4) NOT NULL DEFAULT '1',
  `resource_picture_id` int(10) NOT NULL DEFAULT '0',
  `site_admin` int(10) NOT NULL DEFAULT '0',
  `last_login` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user` (`user`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, '[[admin_username]]', '[[admin_pass]]', '[[admin_email]]', '[[admin_realname]]', '', 'a:0:{}', 1, 0, 1, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users_permissions`
--

CREATE TABLE `[[dbprefix]]users_permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `blog_id` int(10) unsigned NOT NULL DEFAULT '0',
  `permission_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `blog_id` (`blog_id`),
  KEY `user_id_permission_id` (`user_id`,`permission_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=30 ;

--
-- Dumping data for table `[[dbprefix]]users_permissions`
--

INSERT INTO `[[dbprefix]]users_permissions` VALUES
(1, 1, 0, 49),
(2, 1, 0, 58),
(3, 1, 0, 52),
(4, 1, 0, 43),
(5, 1, 0, 46),
(6, 1, 0, 55),
(7, 1, 0, 39),
(8, 1, 0, 41),
(9, 1, 0, 1),
(10, 1, 0, 66),
(11, 1, 0, 65),
(12, 1, 0, 51),
(13, 1, 0, 60),
(14, 1, 0, 62),
(15, 1, 0, 54),
(16, 1, 0, 45),
(17, 1, 0, 64),
(18, 1, 0, 48),
(19, 1, 0, 57),
(20, 1, 0, 42),
(21, 1, 0, 50),
(22, 1, 0, 59),
(23, 1, 0, 61),
(24, 1, 0, 53),
(25, 1, 0, 44),
(26, 1, 0, 63),
(27, 1, 0, 47),
(28, 1, 0, 56),
(29, 1, 0, 40);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
