<?php
#
# database settings
#
# Installation instructions:
#   NEW INSTALL
#   Leave these values blank,
#   and go to the URL where you installed LifeType
#   and look at /wizard.php and type the appropriate
#   values in there.
#
#   This file needs to be writable
#   by whatever user your php scripts run as.
#   The easiest thing to do is to make this file
#   writable by everyone, and then after the wizard
#   completes, remove write privileges from everyone
#   except yourself.
#
#   UPGRADE
#   remove all files from your old plog directory
#   (back them up somewhere, also backup your current
#    database)
#   Upload new pLog files into the same directory,
#   and then copy your old config.properties.php
#   over this file, and then run the wizard.
#   (note, if upgrading between minor releases:
#   1.0 to 1.0.1, etc. you shouldn't run the wizard)

$config["db_host"] = "";
$config["db_username"] = "";
$config["db_password"] = "";
$config["db_database"] = "";
$config["db_persistent"] = true;
$config["db_character_set"] = "default";

#
# the database prefix will be appended to the name of each database tables in case you want
# to have more than one version of plog running at the same time, such as the stable and
# unstable one for testing. Each one could use a different prefix and therefore they could
# coexist in the same unique database. If you change this after the initial configuration done
# with the installation wizard, please make sure that you also rename the tables.
#
$config["db_prefix"] = "";

#
# This array is used to pass driver-specific parameters. Currently the only supported
# one is enable_fulltext_search, that informs the MySQL driver that FULLTEXT indexes
# can be used to speed up searches. It's disabled by default as it does not work with
# languages such as Chinese or Japanese. In all other cases, you probably want to enable
# this for performance reasons (searches are lot faster if using the FULLTEXT indexes)
#
$config["db_options"] = Array( "enable_mysql_fulltext_search" => false );
?>