<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."class/view/admin/admintemplatedview.class.php" );
	lt_include( PLOG_CLASS_PATH."class/misc/integritychecker.class.php" );
	lt_include( PLOG_CLASS_PATH."class/xml/rssparser/rssparser.class.php" );	
	
    /**
     * \ingroup Action
     * @private
     *
     * Checks that all files have got the right version
     */
    class AdminVersionCheckAction extends AdminAction
	{
		function AdminVersionCheckAction( $actionInfo, $request )
		{
			$this->AdminAction( $actionInfo, $request );

			$this->requireAdminPermission( "view_global_settings" );
		}

		function perform()
		{
			$result = false;
			
			$this->_view = new AdminTemplatedView( $this->_blogInfo, "versions" );
			
			// decide what we're going to do...
			if( $this->_request->getValue( "doFileVersionCheck" ) != "" ) {
				// here we have to check the files and display the result
				
				// load the file with the reference checksums, as generated by the development
				// team prior to the release
				include( PLOG_CLASS_PATH."install/files.properties.php");
				
				// now check the reference data agains the current data. The default folders are
				// "class", "templates/admin", "templates/wizard", "templates/rss", "templates/summary", "templates/default"
				$result = IntegrityChecker::checkIntegrity( 
					$data
				);
				
				if( empty( $result )) 
					$this->_view->setSuccessMessage( $this->_locale->tr( "all_files_ok" ));
				else {
					$fileList = implode( "<br/>", array_keys( $result ));
					$message = $this->_locale->tr( "incorrect_file_version_error" )."<br/>".$fileList;
					$this->_view->setErrorMessage( $message );
				}
			}
			elseif( $this->_request->getValue( "doLTVersionCheck" ) != "" ) {
				$rss = new RssParser();
				if( $rss->parse( Version::getLifetypeVersionFeed() )) {					
					$items = $rss->getItems();
					
					// there is only one item tag in the feed, the one containing the latest stable
					// version only
					if( isset( $items[0] )) {
						$version = $items[0]->getTitle();
						if( Version::isNewer( $version )) {
							$message = $this->_locale->tr( "lt_version_error" )."<b>$version</b>";
							$message .= "<br/><a href=\"".$items[0]->getLink()."\">".$this->_locale->tr("download")."</a>";
							$message .= "<br/><a href=\"".$items[0]->_item["lt"]["relnotes"]."\">".$this->_locale->tr("release_notes")."</a>";							
							$this->_view->setErrorMessage( $message );
						}
						else  {
							$this->_view->setSuccessMessage( $this->_locale->tr( "lt_version_ok" ));
						}
					}
				}
			}

			lt_include( PLOG_CLASS_PATH."class/misc/version.class.php" );
			$this->_view->setValue( "version", Version::getVersion());

			$this->setCommonData();

			return true;
		}
	}
?>