"""Helpers for yaml parsing"""

import yaml


class DumbYamlConstructor(yaml.constructor.SafeConstructor):
    """Subclass of SafeYamlConstructor that leaves bool/null/int as strs"""

    ignored_tags = [
        'tag:yaml.org,2002:bool',
        'tag:yaml.org,2002:null',
        'tag:yaml.org,2002:int',
    ]

    def __init__(self):
        super().__init__()
        for tag in self.ignored_tags:
            self.add_constructor(tag, DumbYamlConstructor.return_unchanged)

    def return_unchanged(self, node):
        """Handler for scalars that shouldn't be converted"""
        return self.construct_scalar(node)


class DumbYamlLoader(
    yaml.reader.Reader,
    yaml.scanner.Scanner,
    yaml.parser.Parser,
    yaml.composer.Composer,
    DumbYamlConstructor,
    yaml.resolver.Resolver,
):
    """Custom YAML loader that leaves bool/null/int as strs, for use
    parsing cPanel's /etc/ YAML files

    Example:
        yaml.load(file_handle, rads.DumbYamlLoader)
    """

    __module__ = 'rads'

    def __init__(self, stream):
        yaml.reader.Reader.__init__(self, stream)
        yaml.scanner.Scanner.__init__(self)
        yaml.parser.Parser.__init__(self)
        yaml.composer.Composer.__init__(self)
        DumbYamlConstructor.__init__(self)
        yaml.resolver.Resolver.__init__(self)
