"""cpapi3 functions"""
from typing import Union
from ._base import CpAPIBase


class Cpapi3(CpAPIBase):
    """cpapi3 functions"""

    __module__ = 'cpapis'

    def __init__(self):
        if self._can_exec('/usr/bin/cpapi3'):
            super().__init__('/usr/bin/cpapi3')
        else:
            super().__init__('/usr/local/cpanel/bin/cpapi3')

    def __call__(
        self,
        module: str,
        user: Union[str, None] = None,
        args: Union[dict, None] = None,
        timeout: Union[float, None] = None,
    ):
        """Query cpapi3

        Args:
            module: the cpapi3 module to use in format x::y
            user: ``--user`` arg to use
            args: key-vals to send to cpapi3
            timeout: timeout for the cpapi3 command in secs
        """
        return self._exec(
            module_args=module.split('::'),
            user=user,
            args=args,
            timeout=timeout,
        )
