"""TypedDict typehints for Backup Authority API replies"""

from typing import TypedDict, Union, Literal
from restic import ResticRepo

# https://www.python.org/dev/peps/pep-0589/


class SharedFailoverLocks(TypedDict):
    """Return format of get_shared_failover_locks"""

    server_lock: Union[int, None]  # timestamp
    user_locks: list[str]  # snapshot IDs


class AgentClientLookup(TypedDict):
    """Reply dict format for support agent bucket lookups for v/ded servers"""

    wans: dict[str, str]
    repo: ResticRepo
    svr_class: str


class AgentCpuserLookup(TypedDict):
    """Reply dict format for support agent bucket lookups for cPanel users"""

    wans: dict[str, str]
    repo: ResticRepo


class VznodeBackupLookup(TypedDict):
    """Reply dict format for ``BakAuth.vzclient_backup``"""

    endpoints: dict[str, str]
    node_keys: ResticRepo
    vps_keys: dict[int, ResticRepo]
    # task_ids is sent by bakauth but not stored in this dict
    changed: dict[int, str]


class VznodeRestoreLookup(TypedDict):
    """Reply dict format for ``BakAuth.vzclient_restore``"""

    this_endpoint: str
    key_info: ResticRepo
    all_endpoints: dict[str, str]


class UserBuckets(TypedDict):
    """Reply dict format for ``BakAuth.get_user_buckets``"""

    copy_users: list[str]
    quotas_gb: dict[str, int]
    repos: dict[str, ResticRepo]
    missing: list[str]


class RegCopy(TypedDict):
    """Info on a cross-coast cluster"""

    name: str
    location: str
    endpoint: str


class RegDetails(TypedDict):
    """Reply dict format for ``BakAuth.get_reg_details``"""

    name: str  # cluster name
    location: str
    svr_class: Literal[
        'imh_vps',
        'imh_ded',
        'imh_reseller',
        'imh_ngx',
        'imh_shared',
        'hub_shared',
    ]
    client_host: str  # short hostname bakauth knows this client as
    endpoint: str  # url such as https://backups.lax1.imhcloud.net
    wans: dict[str, str]  # name -> urls for all clusters' wans
    copy: RegCopy
    repo: ResticRepo
