<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006-2008 Malcolm Cowe
//    Copyright (C) 2010 Matteo Lucarelli
//    Copyright (C) 2011-2013 Uwe Steinmann
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//    Translators: Admin (1748), archonwang (3), dgrutsch (9), netixw (14)

$text = array(
'2_factor_auth' => '2-factor authentication',
'2_factor_auth_info' => 'This system enforces 2 factor authentication. You will need the Google Authenticator on your mobile phone. Below you see two QR codes. The right one is your current secret. On the left you can set a new secret. If you set a new secret make sure to rescan it with Google Authenticator.',
'2_fact_auth_secret' => 'Secret',
'accept' => 'Accept',
'access_control' => 'Access control',
'access_control_is_off' => 'Advanced access control is turned off',
'access_denied' => 'Access denied.',
'access_inheritance' => 'Access Inheritance',
'access_mode' => 'Access mode',
'access_mode_all' => 'All permissions',
'access_mode_none' => 'No access',
'access_mode_read' => 'Read permissions',
'access_mode_readwrite' => 'Read-Write permissions',
'access_permission_changed_email' => 'Permission changed',
'access_permission_changed_email_body' => 'Permission changed
Document: [name]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'access_permission_changed_email_subject' => '[sitename]: [name] - Permission changed',
'according_settings' => 'according settings',
'action' => 'Action',
'actions' => 'Actions',
'action_approve' => 'Approve',
'action_complete' => 'Complete',
'action_is_complete' => 'Is complete',
'action_is_not_complete' => 'Is not complete',
'action_reject' => 'Reject',
'action_review' => 'Review',
'action_revise' => 'Revise',
'add' => 'Add',
'add_approval' => 'Add approval',
'add_attrdefgroup' => 'Add new attribute group',
'add_document' => 'Add document',
'add_document_link' => 'Add link',
'add_document_notify' => 'Assign notification',
'add_doc_reviewer_approver_warning' => 'N.B. Documents are automatically marked as released if no reviewer or approver is assigned.',
'add_doc_workflow_warning' => 'N.B. Documents are automatically marked as released if no workflow is assigned.',
'add_event' => 'Add event',
'add_group' => 'Add new group',
'add_member' => 'Add a member',
'add_multiple_documents' => 'Add multiple documents',
'add_multiple_files' => 'Add multiple files (will use filename as document name)',
'add_receipt' => 'Acknowledge reception',
'add_review' => 'Add review',
'add_revision' => 'Add revision',
'add_role' => 'Add new role',
'add_subfolder' => 'Add subfolder',
'add_task' => 'Add new task for this class',
'add_to_clipboard' => 'Add to clipboard',
'add_to_transmittal' => 'Add to transmittal',
'add_transmittal' => 'Add transmittal',
'add_user' => 'Add new user',
'add_user_to_group' => 'Add user to group',
'add_workflow' => 'Add new workflow',
'add_workflow_action' => 'Add new workflow action',
'add_workflow_state' => 'Add new workflow state',
'admin' => 'Administrator',
'admin_tools' => 'Admin-Tools',
'all' => 'All',
'all_categories' => 'All categories',
'all_documents' => 'All Documents',
'all_pages' => 'All',
'all_users' => 'All users',
'already_subscribed' => 'Already subscribed',
'and' => 'and',
'apply' => 'Apply',
'approvals_accepted' => '[no_approvals] approvals already accepted',
'approvals_and_reviews_accepted' => '[no_approvals] approvals and [no_reviews] reviews already accepted',
'approvals_and_reviews_not_touched' => '[no_approvals] approvals and [no_reviews] reviews not being touched',
'approvals_and_reviews_rejected' => '[no_approvals] approvals and [no_reviews] reviews already rejected',
'approvals_not_touched' => '[no_approvals] approvals not being touched',
'approvals_rejected' => '[no_approvals] approvals already rejected',
'approvals_without_group' => 'Approvals without group',
'approvals_without_user' => 'Approvals without user',
'approval_deletion_email' => 'Approval request deleted',
'approval_deletion_email_body' => 'Approval request deleted
Document: [name]
Version: [version]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'approval_deletion_email_subject' => '[sitename]: [name] - Approval request deleted',
'approval_file' => 'File',
'approval_group' => 'Approval Group',
'approval_log' => 'Approval Log',
'approval_request_email' => 'Approval request',
'approval_request_email_body' => 'Approval request
Document: [name]
Version: [version]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'approval_request_email_subject' => '[sitename]: [name] - Approval request',
'approval_status' => 'Approval Status',
'approval_submit_email' => '',
'approval_submit_email_body' => 'Approval of document
Document: [name]
Version: [version]
Parent folder: [folder_path]
Status: [status]
Comment: [comment]
User: [username]
URL: [url]',
'approval_submit_email_subject' => '[sitename]: [name] - Submitted approval',
'approval_summary' => 'Approval Summary',
'approval_update_failed' => 'Error updating approval status. Update failed.',
'approvers' => 'Approvers',
'approver_already_assigned' => 'User is already assigned as an approver.',
'approver_already_removed' => 'Approver has already been removed from approval process or has already submitted an approval.',
'april' => 'April',
'archive' => 'Archive',
'archive_creation' => 'Archive creation',
'archive_creation_warning' => 'With this operation you can create archive containing the files of entire DMS folders. After the creation the archive will be saved in the data folder of your server.<br>WARNING: an archive created as human readable will be unusable as server backup.',
'ar_EG' => 'Arabic',
'assign_approvers' => 'Assign Approvers',
'assign_recipients' => 'Assign Recipients',
'assign_reviewers' => 'Assign Reviewers',
'assign_user_property_to' => 'Assign user\'s properties to',
'assumed_released' => 'Assumed released',
'attrdefgroup_management' => 'Attribute groups managament',
'attrdefgrp_show_detail' => 'Details',
'attrdefgrp_show_list' => 'List',
'attrdefgrp_show_search' => 'Search',
'attrdefgrp_show_searchlist' => 'Search result',
'attrdef_exists' => 'Attribute definition already exists',
'attrdef_info' => 'Information',
'attrdef_in_use' => 'Attribute definition still in use',
'attrdef_management' => 'Attribute definition management',
'attrdef_maxvalues' => 'Max. number of values',
'attrdef_minvalues' => 'Min. number of values',
'attrdef_min_greater_max' => 'Minimum number of values is larger than maximum number of values',
'attrdef_multiple' => 'Allow multiple values',
'attrdef_multiple_needs_valueset' => 'Attribute definition with multiple values needs value set.',
'attrdef_must_be_multiple' => 'Attribute must have more than one value, but is not set multiple value',
'attrdef_name' => 'Name',
'attrdef_noname' => 'Missing name for attribute definition',
'attrdef_objtype' => 'Object type',
'attrdef_regex' => 'Regular expression',
'attrdef_type' => 'Type',
'attrdef_type_boolean' => 'Boolean',
'attrdef_type_date' => 'Date',
'attrdef_type_email' => 'Email',
'attrdef_type_float' => 'Float',
'attrdef_type_int' => 'Integer',
'attrdef_type_string' => 'String',
'attrdef_type_url' => 'URL',
'attrdef_valueset' => 'Set of values',
'attributes' => 'Attributes',
'attribute_changed_email_body' => 'Attribute changed
Document: [name]
Version: [version]
Attribute: [attribute_name]
Old value: [attribute_old_value]
New value: [attribute_new_value]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'attribute_changed_email_subject' => '[sitename]: [name] - Attribute changed',
'attribute_count' => 'Number of uses',
'attribute_value' => 'Value of attribute',
'attribute_value_not_in_valueset' => 'Value not in value set',
'attr_malformed_boolean' => 'The attribute value \'[value]\' of attribute \'[attrname]\' is not a valid boolean.',
'attr_malformed_date' => 'The attribute value \'[value]\' of attribute \'[attrname]\' is not a valid date.',
'attr_malformed_email' => 'The attribute value \'[value]\' of attribute \'[attrname]\' is not a valid URL.',
'attr_malformed_float' => 'The attribute value \'[value]\' of attribute \'[attrname]\' is not a valid float.',
'attr_malformed_int' => 'The attribute value \'[value]\' of attribute \'[attrname]\' is not a valid integer.',
'attr_malformed_url' => 'The attribute value \'[value]\' of attribute \'[attrname]\' is not a valid URL.',
'attr_max_values' => 'The maximum number of required values for attribute [attrname] is exceeded.',
'attr_min_values' => 'The minimum number of required values for attribute [attrname] is not reached.',
'attr_not_in_valueset' => 'The attribute value \'[value]\' for attribute \'[attrname]\' is not contained in the valueset.',
'attr_no_regex_match' => 'The attribute value \'[value]\' for attribute \'[attrname]\' does not match the regular expression \'[regex]\'',
'attr_validation_error' => 'The value \'[value]\' of attribute \'[attrname]\' is invalid.',
'at_least_n_users_of_group' => 'At least [number_of_users] users of [group]',
'august' => 'August',
'authentication' => 'Authentication',
'author' => 'Author',
'automatic_status_update' => 'Automatic status change',
'back' => 'Go back',
'backup_list' => 'Existing backups',
'backup_log_management' => 'Backup/Logging',
'backup_remove' => 'Remove backup file',
'backup_tools' => 'Backup tools',
'between' => 'between',
'bg_BG' => 'Bulgarian',
'browse' => 'Browse',
'calendar' => 'Calendar',
'calendar_week' => 'Calendar week',
'cancel' => 'Cancel',
'cannot_assign_invalid_state' => 'Cannot modify an obsolete or rejected document',
'cannot_change_final_states' => 'Warning: You cannot alter status for document rejected, expired or with pending review or approval',
'cannot_delete_user' => 'Cannot delete user',
'cannot_delete_yourself' => 'Cannot delete yourself',
'cannot_move_root' => 'Error: Cannot move root folder.',
'cannot_retrieve_approval_snapshot' => 'Unable to retrieve approval status snapshot for this document version.',
'cannot_retrieve_review_snapshot' => 'Unable to retrieve review status snapshot for this document version.',
'cannot_rm_root' => 'Error: Cannot delete root folder.',
'categories' => 'Categories',
'categories_loading' => 'Please wait, until category list is loaded …',
'category' => 'Category',
'category_exists' => 'Category already exists.',
'category_filter' => 'Only categories',
'category_info' => 'Information',
'category_in_use' => 'This category is currently used by documents.',
'category_noname' => 'No category name given.',
'ca_ES' => 'Catalan',
'change_assignments' => 'Set reviewer/approver',
'change_password' => 'Change password',
'change_password_message' => 'Your password has been changed.',
'change_recipients' => 'Set recipients',
'change_revisors' => 'Set revisors',
'change_status' => 'Change Status',
'charts' => 'Charts',
'chart_docsaccumulated_title' => 'Number of documents',
'chart_docspercategory_title' => 'Documents per category',
'chart_docspermimetype_title' => 'Documents per mime-type',
'chart_docspermonth_title' => 'New documents per month',
'chart_docsperstatus_title' => 'Documents per status',
'chart_docsperuser_title' => 'Documents per user',
'chart_selection' => 'Select chart',
'chart_sizeperuser_title' => 'Diskspace per user',
'checkedout_file_has_different_version' => 'The checked out version is not identical to the current version. Check in will not update the document.',
'checkedout_file_has_disappeared' => 'The file of the checked out document has disappeared. Check in will not be possible.',
'checkedout_file_is_unchanged' => 'The file of the checked out document is still unchanged. Check in will not be possible. If do not plan any modifications, you can reset the check out status.',
'checkin_document' => 'Check In',
'checkoutpath_does_not_exist' => 'Checkout path does not exists',
'checkout_document' => 'Check out',
'checkout_is_disabled' => 'Check out of documents is disabled in the configuration.',
'choose_attrdef' => 'Please choose attribute definition',
'choose_attrdefgroup' => 'Choose attribute group',
'choose_category' => 'Please choose',
'choose_group' => 'Choose group',
'choose_role' => 'Choose role',
'choose_target_category' => 'Choose category',
'choose_target_document' => 'Choose document',
'choose_target_file' => 'Choose file',
'choose_target_folder' => 'Choose folder',
'choose_user' => 'Choose user',
'choose_workflow' => 'Choose workflow',
'choose_workflow_action' => 'Choose workflow action',
'choose_workflow_state' => 'Choose workflow state',
'class_name' => 'Name of class',
'clear_cache' => 'Clear cache',
'clear_clipboard' => 'Clear clipboard',
'clear_password' => 'Clear password',
'clipboard' => 'Clipboard',
'close' => 'Close',
'command' => 'Command',
'comment' => 'Comment',
'comment_changed_email' => '',
'comment_for_current_version' => 'Version comment',
'configure_extension' => 'Configure extension',
'confirm_clear_cache' => 'Would you really like to clear the cache? This will remove all precalculated preview images.',
'confirm_create_fulltext_index' => 'Yes, I would like to recreate the fulltext index!',
'confirm_move_document' => 'Please confirm moving the document.',
'confirm_move_folder' => 'Please confirm moving the folder.',
'confirm_pwd' => 'Confirm Password',
'confirm_rm_attr_value' => 'Do you really want to delete the attribute value?',
'confirm_rm_backup' => 'Do you really want to remove the file "[arkname]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_document' => 'Do you really want to remove the document \'[documentname]\'?<br>Be careful: This action cannot be undone.',
'confirm_rm_dump' => 'Do you really want to remove the file "[dumpname]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_event' => 'Do you really want to remove event "[name]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_file' => 'Do you really want to remove file "[name]" of document "[documentname]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_folder' => 'Do you really want to remove the folder \'[foldername]\' and its content?<br>Be careful: This action cannot be undone.',
'confirm_rm_folder_files' => 'Do you really want to remove all the files of the folder "[foldername]" and of its subfolders?<br>Be careful: This action cannot be undone.',
'confirm_rm_group' => 'Do you really want to remove the group "[groupname]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_log' => 'Do you really want to remove log file "[logname]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_transmittal' => 'Please confirm the deletion of the transmittal.',
'confirm_rm_transmittalitem' => 'Confirm removal',
'confirm_rm_user' => 'Do you really want to remove the user "[username]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_user_from_processes' => 'Do you really want to remove the user "[username]" from all processes?<br>Be careful: This action can lead to the release of documents if the user was the only or last approver.',
'confirm_rm_version' => 'Do you really want to remove version [version] of document "[documentname]"?<br>Be careful: This action cannot be undone.',
'confirm_transfer_objects' => 'Do you really want to transfer the documents, folders, etc. of the user "[username]"?<br>Be careful: This action cannot be undone.',
'confirm_update_transmittalitem' => 'Confirm update',
'content' => 'Content',
'continue' => 'Continue',
'converter_new_cmd' => 'Command',
'converter_new_mimetype' => 'New mimetype',
'copied_to_checkout_as' => 'File copied to checkout space as \'[filename]\' on [date]',
'create_download_link' => 'Create download link',
'create_fulltext_index' => 'Create fulltext index',
'create_fulltext_index_warning' => 'You are about to recreate the fulltext index. This can take a considerable amount of time and reduce your overall system performance. If you really want to recreate the index, please confirm your operation.',
'creation_date' => 'Created',
'cs_CZ' => 'Czech',
'current_password' => 'Current Password',
'current_quota' => 'The current system wide quota is set [quota].',
'current_state' => 'Current state',
'current_version' => 'Current version',
'daily' => 'Daily',
'databasesearch' => 'Database search',
'date' => 'Date',
'days' => 'days',
'debug' => 'Debug',
'december' => 'December',
'default_access' => 'Default Access Mode',
'default_keywords' => 'Available keywords',
'definitions' => 'Definitions',
'delete' => 'Delete',
'details' => 'Details',
'details_version' => 'Details for version: [version]',
'de_DE' => 'German',
'disclaimer' => 'This is a classified area. Access is permitted only to authorized personnel. Any violation will be prosecuted according to the national and international laws.',
'discspace' => 'Disc space',
'docs_in_reception_no_access' => 'Documents with reception without access by recipient',
'docs_in_revision_no_access' => 'Documents in revision without access by revisor',
'document' => 'Document',
'documentcontent' => 'Document content',
'documents' => 'Documents',
'documents_checked_out_by_you' => 'Documents checked out by you',
'documents_expired' => 'Expired documents',
'documents_in_process' => 'Documents In Process',
'documents_locked' => 'Locked documents',
'documents_locked_by_you' => 'Documents locked by you',
'documents_only' => 'Documents only',
'documents_to_approve' => 'Documents awaiting your approval',
'documents_to_correct' => 'Documents that need correction',
'documents_to_process' => 'Documents that need processing',
'documents_to_receipt' => 'Documents awaiting to confirm the receipt',
'documents_to_review' => 'Documents awaiting your review',
'documents_to_revise' => 'Documents awaiting your revision',
'documents_to_trigger_workflow' => 'Documents in workflow',
'documents_user_draft' => 'Drafts',
'documents_user_expiration' => 'Expired documents',
'documents_user_needs_correction' => 'Documents that need to be corrected',
'documents_user_no_reception' => 'Documents without reception',
'documents_user_obsolete' => 'Obsolete documents',
'documents_user_reception' => 'Documents awaiting reception',
'documents_user_rejected' => 'Rejected documents',
'documents_user_requiring_attention' => 'Documents owned by you that require attention',
'documents_with_notification' => 'Documents with notification',
'document_already_checkedout' => 'This document is already checked out',
'document_already_locked' => 'This document is already locked',
'document_attribute_changed_email_body' => 'Attribute changed
Document: [name]
Attribute: [attribute_name]
Old value: [attribute_old_value]
New value: [attribute_new_value]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'document_attribute_changed_email_subject' => '[sitename]: [name] - Attribute changed',
'document_comment_changed_email' => 'Comment changed',
'document_comment_changed_email_body' => 'Comment changed
Document: [name]
Old comment: [old_comment]
New Comment: [new_comment]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'document_comment_changed_email_subject' => '[sitename]: [name] - Comment changed',
'document_count' => 'Number of documents',
'document_deleted' => 'Document deleted',
'document_deleted_email' => 'Document deleted',
'document_deleted_email_body' => 'Document deleted
Document: [name]
Parent folder: [folder_path]
User: [username]',
'document_deleted_email_subject' => '[sitename]: [name] - Document deleted',
'document_duplicate_name' => 'Duplicate document name',
'document_has_no_workflow' => 'Document has no workflow',
'document_infos' => 'Document Information',
'document_is_checked_out' => 'Document is currently checked out. If you upload a new version, then the checked out version cannot be checked back in anymore.',
'document_is_not_locked' => 'This document is not locked',
'document_link_by' => 'Linked by',
'document_link_public' => 'Public',
'document_moved_email' => 'Document moved',
'document_moved_email_body' => 'Document moved
Document: [name]
Old folder: [old_folder_path]
New folder: [new_folder_path]
User: [username]
URL: [url]',
'document_moved_email_subject' => '[sitename]: [name] - Document moved',
'document_not_checkedout' => 'Document is not checked out.',
'document_renamed_email' => 'Document renamed',
'document_renamed_email_body' => 'Document name changed
Document: [name]
Parent folder: [folder_path]
Old name: [old_name]
User: [username]
URL: [url]',
'document_renamed_email_subject' => '[sitename]: [name] - Document renamed',
'document_status_changed_email' => 'Document status changed',
'document_status_changed_email_body' => 'Document status changed
Document: [name]
Status: [status]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'document_status_changed_email_subject' => '[sitename]: [name] - Document status changed',
'document_title' => 'Document \'[documentname]\'',
'document_transfered_email_body' => 'Document transfer to other user
Document: [name]
New owner: [newuser]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'document_transfered_email_subject' => '[sitename]: [name] - Transfer Dokument',
'document_updated_email' => 'Document updated',
'document_updated_email_body' => 'Document updated
Document: [name]
Parent folder: [folder_path]
User: [username]
Comment: [comment]
Version comment: [version_comment]
URL: [url]',
'document_updated_email_subject' => '[sitename]: [name] - Document updated',
'does_not_expire' => 'Does not expire',
'does_not_inherit_access_msg' => 'Inherit access',
'download' => 'Download',
'download_extension' => 'Download extension as zip file',
'download_links' => 'Download links',
'download_link_email_body' => 'Click on the link below to download the version [version] of document
\'[docname]\'.

[url]

The link is valid until [valid].

[comment]',
'download_link_email_subject' => 'Download link',
'do_object_repair' => 'Repair all folders and documents.',
'do_object_setchecksum' => 'Set checksum',
'do_object_setfilesize' => 'Set file size',
'do_object_unlink' => 'Delete document version',
'draft' => 'Draft',
'draft_pending_approval' => 'Draft - pending approval',
'draft_pending_review' => 'Draft - pending review',
'drag_icon_here' => 'Drag icon of folder or document here!',
'dropfolderdir_missing' => 'Your personal drop folder does not exist on the server! Please ask your administrator to create it.',
'dropfolder_file' => 'File from drop folder',
'dropfolder_folder' => 'Folder from drop folder',
'dropupload' => 'Fast upload',
'drop_files_here' => 'Drop files here!',
'dump_creation' => 'DB dump creation',
'dump_creation_warning' => 'With this operation you can create a dump file of your database content. After the creation the dump file will be saved in the data folder of your server.',
'dump_list' => 'Existings dump files',
'dump_remove' => 'Remove dump file',
'duplicates' => 'Duplicates',
'duplicate_content' => 'Duplicate Content',
'edit' => 'Edit',
'edit_attributes' => 'Edit attributes',
'edit_comment' => 'Edit comment',
'edit_default_keywords' => 'Edit keywords',
'edit_document_access' => 'Edit Access',
'edit_document_notify' => 'Document Notification List',
'edit_document_props' => 'Edit document',
'edit_event' => 'Edit event',
'edit_existing_access' => 'Edit Access List',
'edit_existing_attribute_groups' => 'Edit attribute groups',
'edit_existing_notify' => 'Edit notification list',
'edit_folder_access' => 'Edit access',
'edit_folder_attrdefgrp' => 'Edit attribute groups',
'edit_folder_notify' => 'Folder Notification List',
'edit_folder_props' => 'Edit folder',
'edit_group' => 'Edit group',
'edit_online' => 'Edit online',
'edit_task' => 'Edit task',
'edit_transmittal_props' => 'Edit transmittal properties',
'edit_user' => 'Edit user',
'edit_user_details' => 'Edit User Details',
'edit_version' => 'Edit version',
'el_GR' => 'Greek',
'email' => 'Email',
'email_error_title' => 'No email entered',
'email_footer' => 'You can always change your e-mail settings using \'My Account\' functions',
'email_header' => 'This is an automatic message from the DMS server.',
'email_not_given' => 'Please enter a valid email address.',
'empty_attribute_group_list' => 'No attribute groups',
'empty_folder_list' => 'No documents or folders',
'empty_list' => 'No entries',
'empty_notify_list' => 'No entries',
'en_GB' => 'English (GB)',
'equal_transition_states' => 'Start and end state are equal',
'error' => 'Error',
'error_add_aro' => 'Error while adding access request object',
'error_add_permission' => 'Error while add permission',
'error_cleared_cache' => 'Error while clearing cache',
'error_extension_getlist' => 'Error getting extension list from repository',
'error_importfs' => 'Error while importing form file system',
'error_no_document_selected' => 'No document selected',
'error_no_folder_selected' => 'No folder selected',
'error_occured' => 'An error has occurred',
'error_remove_document' => 'Error while deleting document',
'error_remove_folder' => 'Error while deleting folder',
'error_remove_permission' => 'Error while remove permission',
'error_toogle_permission' => 'Error while changing permission',
'error_transfer_document' => 'Error while transfering document',
'error_update_document' => 'Error while updating document',
'error_uploading_reviewer_only' => 'Error when creating the document. The document has a reviewer, but no approver.',
'es_ES' => 'Spanish',
'event_details' => 'Event details',
'exclude_items' => 'Exclude items',
'expired' => 'Expired',
'expired_at_date' => 'Expired at [datetime]',
'expired_documents' => 'Expired documents',
'expires' => 'Expires',
'expire_by_date' => 'Expires by date',
'expire_in_1d' => 'Expires in 1 day',
'expire_in_1h' => 'Expires in 1h',
'expire_in_1m' => 'Expires in 1 month',
'expire_in_1w' => 'Expires in 1 week',
'expire_in_1y' => 'Expires in 1 year',
'expire_in_2h' => 'Expires in 2h',
'expire_in_2y' => 'Expires in 2 years',
'expire_today' => 'Expires today',
'expire_tomorrow' => 'Expires tomorrow',
'expiry_changed_email' => 'Expiry date changed',
'expiry_changed_email_body' => 'Expiry date changed
Document: [name]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'expiry_changed_email_subject' => '[sitename]: [name] - Expiry date changed',
'export' => 'Export',
'extension_archive' => 'Extension',
'extension_changelog' => 'Changelog',
'extension_loading' => 'Loading extensions ...',
'extension_manager' => 'Manage extensions',
'extension_mgr_installed' => 'Installed',
'extension_mgr_no_upload' => 'Uploading new extensions is not possible because the extentension directory is not writable.',
'extension_mgr_repository' => 'Available',
'extension_version_list' => 'Versions',
'february' => 'February',
'file' => 'File',
'files' => 'Files',
'files_deletion' => 'Files deletion',
'files_deletion_warning' => 'With this option you can delete all files of entire DMS folders. The versioning information will remain visible.',
'files_loading' => 'Please wait, until file list is loaded …',
'file_size' => 'Filesize',
'filter_for_documents' => 'Additional filter for documents',
'filter_for_folders' => 'Additional filter for folders',
'folder' => 'Folder',
'folders' => 'Folders',
'folders_and_documents_statistic' => 'Contents overview',
'folders_with_notification' => 'Folders with notification',
'folder_attribute_changed_email_body' => 'Attribute changed
Folder: [name]
Attribute: [attribute_name]
Old value: [attribute_old_value]
New value: [attribute_new_value]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'folder_attribute_changed_email_subject' => '[sitename]: [name] - Attribute changed',
'folder_comment_changed_email' => 'Comment changed',
'folder_comment_changed_email_body' => 'Comment changed
Folder: [name]
Old comment: [old_comment]
New Comment: [new_comment]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'folder_comment_changed_email_subject' => '[sitename]: [name] - Comment changed',
'folder_contents' => 'Folder Contents',
'folder_deleted_email' => 'Folder deleted',
'folder_deleted_email_body' => 'Folder deleted
Folder: [name]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'folder_deleted_email_subject' => '[sitename]: [name] - Folder deleted',
'folder_infos' => 'Folder Information',
'folder_moved_email' => 'Folder moved',
'folder_moved_email_body' => 'Folder move
Folder: [name]
Old folder: [old_folder_path]
New folder: [new_folder_path]
User: [username]
URL: [url]',
'folder_moved_email_subject' => '[sitename]: [name] - Folder moved',
'folder_renamed_email' => 'Folder renamed',
'folder_renamed_email_body' => 'Folder renamed
Folder: [name]
Parent folder: [folder_path]
Old name: [old_name]
User: [username]
URL: [url]',
'folder_renamed_email_subject' => '[sitename]: [name] - Folder renamed',
'folder_title' => 'Folder \'[foldername]\'',
'force_update' => 'Update',
'friday' => 'Friday',
'friday_abbr' => 'Fr',
'from' => 'From',
'fr_FR' => 'French',
'fullsearch' => 'Full text search',
'fullsearch_hint' => 'Use fulltext index',
'fulltextsearch_disabled' => 'Fulltext index is disabled',
'fulltext_converters' => 'Index document conversion',
'fulltext_info' => 'Fulltext index info',
'global_attributedefinitiongroups' => 'Attribute groups',
'global_attributedefinitions' => 'Attributes',
'global_default_keywords' => 'Global keywords',
'global_document_categories' => 'Categories',
'global_workflows' => 'Workflows',
'global_workflow_actions' => 'Workflow Actions',
'global_workflow_states' => 'Workflow States',
'group' => 'Group',
'groups' => 'Groups',
'group_approval_summary' => 'Group approval summary',
'group_exists' => 'Group already exists.',
'group_info' => 'Group information',
'group_management' => 'Groups management',
'group_members' => 'Group members',
'group_receipt_summary' => 'Group receipt summary',
'group_review_summary' => 'Group review summary',
'guest_login' => 'Login as guest',
'guest_login_disabled' => 'Guest login is disabled.',
'hash' => 'Hash',
'help' => 'Help',
'home_folder' => 'Home folder',
'hook_name' => 'Name of hook',
'hourly' => 'Hourly',
'hours' => 'hours',
'hr_HR' => 'Croatian',
'human_readable' => 'Human readable archive',
'hu_HU' => 'Hungarian',
'id' => 'ID',
'identical_version' => 'New version is identical to current version.',
'import' => 'Import',
'importfs' => 'Import from Filesystem',
'import_extension' => 'Import extension',
'import_fs' => 'Import from filesystem',
'import_fs_warning' => 'This will only work for folders in the drop folder. The operation recursively imports all folders and files. Files will be released immediately.',
'include_content' => 'Include content',
'include_documents' => 'Include documents',
'include_subdirectories' => 'Include subdirectories',
'indexing_tasks_in_queue' => 'Indexing tasks in queue',
'index_converters' => '',
'index_done' => 'Done',
'index_error' => 'Error',
'index_folder' => 'Index folder',
'index_no_content' => 'Did not index content',
'index_pending' => 'Pending',
'index_waiting' => 'Waiting',
'individuals' => 'Individuals',
'individuals_in_groups' => 'Members of a group',
'indivіduals_in_groups' => '',
'info_recipients_tab_not_released' => 'Acknowledgement of reception for this document version is not possible, because the version is not released.',
'inherited' => 'inherited',
'inherits_access_copy_msg' => 'Copy inherited access list',
'inherits_access_empty_msg' => 'Start with empty access list',
'inherits_access_msg' => 'Access is being inherited.',
'internal_error' => 'Internal error',
'internal_error_exit' => 'Internal error. Unable to complete request.',
'invalid_access_mode' => 'Invalid Access Mode',
'invalid_action' => 'Invalid Action',
'invalid_approval_status' => 'Invalid Approval Status',
'invalid_create_date_end' => 'Invalid end date for creation date range.',
'invalid_create_date_start' => 'Invalid start date for creation date range.',
'invalid_doc_id' => 'Invalid Document ID',
'invalid_dropfolder_folder' => 'Invalid folder in drop folder',
'invalid_expiration_date_end' => 'Invalid end date for expiration date range.',
'invalid_expiration_date_start' => 'Invalid start date for expiration date range.',
'invalid_file_id' => 'Invalid file ID',
'invalid_folder_id' => 'Invalid Folder ID',
'invalid_group_id' => 'Invalid Group ID',
'invalid_link_id' => 'Invalid link identifier',
'invalid_request_token' => 'Invalid Request Token',
'invalid_review_status' => 'Invalid Review Status',
'invalid_sequence' => 'Invalid sequence value',
'invalid_status' => 'Invalid Document Status',
'invalid_target_doc_id' => 'Invalid Target Document ID',
'invalid_target_folder' => 'Invalid Target Folder ID',
'invalid_user_id' => 'Invalid User ID',
'invalid_version' => 'Invalid Document Version',
'in_folder' => 'In',
'in_revision' => 'In revision',
'in_workflow' => 'In workflow',
'is_disabled' => 'Disable account',
'is_hidden' => 'Hide from users list',
'it_IT' => 'Italian',
'january' => 'January',
'js_form_error' => 'The form still contains # error.',
'js_form_errors' => 'The form still contains # errors.',
'js_invalid_email' => 'The email address is invalid',
'js_no_approval_group' => 'Please select a approval group',
'js_no_approval_status' => 'Please select the approval status',
'js_no_comment' => 'There is no comment',
'js_no_currentpwd' => 'Please enter your current password',
'js_no_email' => 'Type in your Email-address',
'js_no_file' => 'Please select a file',
'js_no_keywords' => 'Specify some keywords',
'js_no_login' => 'Please type in a username',
'js_no_name' => 'Please type in a name',
'js_no_override_status' => 'Please select the new [override] status',
'js_no_pwd' => 'You need to type in your password',
'js_no_query' => 'Type in a query',
'js_no_review_group' => 'Please select a review group',
'js_no_review_status' => 'Please select the review status',
'js_pwd_not_conf' => 'Password and passwords-confirmation are not equal',
'js_select_user' => 'Please select an user',
'js_select_user_or_group' => 'Select at least a user or a group',
'js_unequal_passwords' => 'The passwords are not equal',
'july' => 'July',
'june' => 'June',
'keep' => 'Do not change',
'keep_doc_status' => 'Keep document status',
'keywords' => 'Keywords',
'keywords_loading' => 'Please wait, until keyword list is loaded …',
'keyword_exists' => 'Keyword already exists',
'ko_KR' => 'Korean',
'language' => 'Language',
'lastaccess' => 'Last access',
'last_update' => 'Last Update',
'legend' => 'Legend',
'librarydoc' => 'Document from library',
'linked_documents' => 'Related Documents',
'linked_files' => 'Attachments',
'linked_to_current_version' => 'Linked to current version',
'linked_to_document' => 'Linked to document',
'linked_to_this_version' => 'Linked to this version',
'link_alt_updatedocument' => 'If you would like to upload files bigger than the current maximum upload size, please use the alternative <a href="%s">upload page</a>.',
'link_to_version' => 'Attach to version',
'list_access_rights' => 'List all access rights ...',
'list_contains_no_access_docs' => 'The list contains more documents you have no access to and are not displayed.',
'list_hooks' => 'List hooks',
'list_tasks' => 'List tasks',
'local_file' => 'Local file',
'locked_by' => 'Locked by',
'lock_document' => 'Lock',
'lock_message' => 'This document is locked by [username]. Only authorized users can unlock this document.',
'lock_status' => 'Status',
'login' => 'Login',
'login_disabled_text' => 'Your account is disabled, probably because of too many failed logins.',
'login_disabled_title' => 'Account is disabled',
'login_error_text' => 'Error signing in. User ID or password incorrect.',
'login_error_title' => 'Sign in error',
'login_not_given' => 'No username has been supplied',
'login_ok' => 'Sign in successful',
'logout' => 'Logout',
'log_management' => 'Log files management',
'lo_LA' => 'Laotian',
'manager' => 'Manager',
'manager_of_group' => 'You are the manager of this group',
'mandatory_approvergroups' => 'Mandatory Groups of approvers',
'mandatory_approvergroup_no_access' => 'Mandatory group of approvers \'[group]\' has insufficient access rights.',
'mandatory_approvers' => 'Mandatory approvers',
'mandatory_approver_no_access' => 'Mandatory approver \'[user]\' has insufficient access rights.',
'mandatory_reviewergroups' => 'Mandatory group of reviewers',
'mandatory_reviewergroup_no_access' => 'Mandatory group of reviewers \'[group]\' has insufficient access rights.',
'mandatory_reviewers' => 'Mandatory reviewers',
'mandatory_reviewer_no_access' => 'Mandatory reviewer \'[user]\' has insufficient access rights.',
'march' => 'March',
'max_upload_size' => 'Maximum upload size',
'may' => 'May',
'menu_dropfolder' => 'Drop folder',
'mimetype' => 'Mime type',
'minutes' => 'minutes',
'misc' => 'Misc',
'missing_checksum' => 'Missing checksum',
'missing_file' => 'Missing file',
'missing_filesize' => 'Missing filesize',
'missing_reception' => 'Missing reception',
'missing_request_object' => 'Missing request object',
'missing_transition_user_group' => 'Missing user/group for transition',
'monday' => 'Monday',
'monday_abbr' => 'Mo',
'monthly' => 'Monthly',
'month_view' => 'Month view',
'more_objects_loading' => 'More objects loading ...',
'move' => 'Move',
'move_clipboard' => 'Move clipboard',
'move_document' => 'Move document',
'move_folder' => 'Move Folder',
'my_account' => 'My Account',
'my_documents' => 'My Documents',
'my_transmittals' => 'My Transmittals',
'name' => 'Name',
'needs_correction' => 'Needs correction',
'needs_workflow_action' => 'This document requires your attention. Please check the workflow tab.',
'network_drive' => 'Network drive',
'never' => 'never',
'new' => 'New',
'new_attrdef' => 'Add attribute definition',
'new_default_keywords' => 'Add keywords',
'new_default_keyword_category' => 'Add category',
'new_document_category' => 'Add category',
'new_document_email' => 'New document',
'new_document_email_body' => 'New document
Name: [name]
Parent folder: [folder_path]
Comment: [comment]
Version comment: [version_comment]
User: [username]
URL: [url]',
'new_document_email_subject' => '[sitename]: [folder_name] - New document',
'new_file_email' => 'New attachment',
'new_file_email_body' => 'New attachment
Name: [name]
Document: [document]
Comment: [comment]
User: [username]
URL: [url]',
'new_file_email_subject' => '[sitename]: [document] - New attachment',
'new_folder' => 'New folder',
'new_password' => 'New password',
'new_subfolder_email' => 'New folder',
'new_subfolder_email_body' => 'New folder
Name: [name]
Parent folder: [folder_path]
Comment: [comment]
User: [username]
URL: [url]',
'new_subfolder_email_subject' => '[sitename]: [name] - New folder',
'new_user_image' => 'New image',
'next_state' => 'New state',
'nl_NL' => 'Dutch',
'no' => 'No',
'notify_added_email' => 'You\'ve been added to notify list',
'notify_added_email_body' => 'Added to notification list
Name: [name]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'notify_added_email_subject' => '[sitename]: [name] - Added to notification list',
'notify_deleted_email' => 'You\'ve been removed from notify list',
'notify_deleted_email_body' => 'Removed from notification list
Name: [name]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'notify_deleted_email_subject' => '[sitename]: [name] - Removed from notification list',
'november' => 'November',
'now' => 'now',
'no_action' => 'No action required',
'no_approval_needed' => 'No approval pending.',
'no_attached_files' => 'No attached files',
'no_current_version' => 'You are running an old version of LetoDMS. The latest available version is [latestversion].',
'no_default_keywords' => 'No keywords available',
'no_docs_checked_out' => 'No documents checked out',
'no_docs_locked' => 'No documents locked.',
'no_docs_needs_correction' => 'No documents, that need to be corrected',
'no_docs_rejected' => 'No documents rejected.',
'no_docs_to_approve' => 'There are currently no documents that require approval.',
'no_docs_to_look_at' => 'No documents that need attention.',
'no_docs_to_receipt' => 'No document receipts required',
'no_docs_to_review' => 'There are currently no documents that require review.',
'no_docs_to_revise' => 'There are currently no documents that need to be revised.',
'no_email_or_login' => 'Login and email must be entered',
'no_fulltextindex' => 'No fulltext index available',
'no_groups' => 'No groups',
'no_group_members' => 'This group has no members',
'no_linked_files' => 'No linked files',
'no_previous_versions' => 'No other versions found',
'no_receipt_needed' => 'There are currently no documents requiring a receipt confirmation.',
'no_review_needed' => 'No review pending.',
'no_revision_needed' => 'No revision pending.',
'no_revision_planed' => 'No revision of document scheduled',
'no_update_cause_locked' => 'You can therefore not update this document. Please contact the locking user.',
'no_user_image' => 'No image found',
'no_version_check' => 'Checking for a new version of LetoDMS has failed! This could be caused by allow_url_fopen being set to 0 in your php configuration.',
'no_version_modification' => 'No version modification',
'no_workflow_available' => 'No workflow available',
'objectcheck' => 'Folder/Document check',
'object_check_critical' => 'Critical errors',
'object_check_warning' => 'Warnings',
'obsolete' => 'Obsolete',
'october' => 'October',
'old' => 'Old',
'only_jpg_user_images' => 'Only .jpg-images may be used as user-images',
'order_by_sequence_off' => 'Ordering by sequence is turned off in the settings. If you want this parameter to have effect, you will have to turn it back on.',
'original_filename' => 'Original filename',
'overall_indexing_progress' => 'Overall indexing progress',
'owner' => 'Owner',
'ownership_changed_email' => 'Owner changed',
'ownership_changed_email_body' => 'Owner changed
Document: [name]
Parent folder: [folder_path]
Old owner: [old_owner]
New owner: [new_owner]
User: [username]
URL: [url]',
'ownership_changed_email_subject' => '[sitename]: [name] - Owner changed',
'password' => 'Password',
'password_already_used' => 'Password already used',
'password_expiration' => 'Password expiration',
'password_expiration_text' => 'Your password has expired. Please choose a new one before you can proceed using LetoDMS.',
'password_expired' => 'Password expired',
'password_expires_in_days' => 'Password expires in %s days.',
'password_forgotten' => 'Password forgotten',
'password_forgotten_email_body' => 'Dear user of LetoDMS,

we have received a request to change your password.

This can be done by clicking on the following link:

[url_prefix]out/out.ChangePassword.php?hash=[hash]

If you have still problems to login, then please contact your administrator.',
'password_forgotten_email_subject' => '[sitename]: Password forgotten',
'password_forgotten_send_hash' => 'Instructions on how to proceed has been send to the user\'s email address',
'password_forgotten_text' => 'Fill out the form below and follow the instructions in the email, which will be sent to you.',
'password_forgotten_title' => 'Password sent',
'password_repeat' => 'Repeat password',
'password_send' => 'Password send',
'password_send_text' => 'Your new password has been send to the given email address, if the login and email matches an existing user. If you do not receive an email within the next minutes, then make sure both login and email are correct and restart the process again.',
'password_strength' => 'Password strength',
'password_strength_insuffient' => 'Insufficient password strength',
'password_wrong' => 'Wrong password',
'pdf_converters' => 'PDF converters',
'pending_approvals' => 'Pending approvals',
'pending_receipt' => 'Pending receipts',
'pending_reviews' => 'Pending reviews',
'pending_revision' => 'Pending revisions',
'pending_workflows' => 'Pending workflows',
'personal_default_keywords' => 'Personal keywordlists',
'pl_PL' => 'Polish',
'possible_substitutes' => 'Substitutes',
'preset_expires' => 'Preset expiration',
'preview' => 'Preview',
'preview_converters' => 'Preview document conversion',
'preview_images' => 'Preview images',
'preview_markdown' => 'Markdown',
'preview_pdf' => 'Preview as PDF',
'preview_plain' => 'Text',
'previous_state' => 'Previous state',
'previous_versions' => 'Previous versions',
'process' => 'Process',
'process_without_user_group' => 'Processes without user/group',
'pt_BR' => 'Portugese (BR)',
'quota' => 'Quota',
'quota_exceeded' => 'Your disk quota is exceeded by [bytes].',
'quota_is_disabled' => 'Quota support is currently disabled in the settings. Setting a user quota will have no effect until it is enabled again.',
'quota_warning' => 'Your maximum disc usage is exceeded by [bytes]. Please remove documents or previous versions.',
'receipts_accepted' => '[no_receipts] receipts already accepted',
'receipts_not_touched' => '[no_receipts] receipts not being touched',
'receipts_rejected' => '[no_receipts] receipts already rejected',
'receipts_without_group' => 'Receipts without group',
'receipts_without_user' => 'Receipts without user',
'receipt_deletion_email_body' => 'User has been removed from the list of recipients
Document: [name]
Version: [version]
Parent folder: [folder_path]
Recipient: [recipient]
User: [username]
URL: [url]',
'receipt_deletion_email_subject' => '[sitename]: [name] - Recipient removed',
'receipt_log' => 'Reception Log',
'receipt_request_email_body' => 'Reception request
Document: [name]
Version: [version]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'receipt_request_email_subject' => '[sitename]: [name] - Reception request',
'receipt_status' => 'Status',
'receipt_summary' => 'Receipt summary',
'receipt_update_failed' => 'Acknowledging reception failed',
'reception' => 'Reception',
'reception_acknowleged' => 'Reception acknowledged',
'reception_noaction' => 'No action',
'reception_rejected' => 'Reception rejected',
'recipients' => 'Recipients',
'redraw' => 'Redraw',
'refresh' => 'Refresh',
'rejected' => 'Rejected',
'released' => 'Released',
'removed_approver' => 'has been removed from the list of approvers.',
'removed_file_email' => 'Removed attachment',
'removed_file_email_body' => 'Removed attachment
Document: [document]
User: [username]
URL: [url]',
'removed_file_email_subject' => '[sitename]: [document] - Removed attachment',
'removed_recipient' => 'has been removed from the list of recipients.',
'removed_reviewer' => 'has been removed from the list of reviewers.',
'removed_revisor' => 'has been removed from the list of revisors.',
'removed_workflow_email_body' => 'Removed workflow from document version
Document: [name]
Version: [version]
Workflow: [workflow]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'removed_workflow_email_subject' => '[sitename]: [name] - Removed workflow from document version',
'removeFolderFromDropFolder' => 'Remove folder after import',
'remove_marked_files' => 'Remove marked files',
'repaired' => 'repaired',
'repairing_objects' => 'Repairing documents and folders.',
'request_workflow_action_email_body' => 'The workflow has reached a state which requires your action.
Document: [name]
Version: [version]
Workflow: [workflow]
Current state: [current_state]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'request_workflow_action_email_subject' => '[sitename]: [name] - Workflow action required',
'reset_checkout' => 'Finish Check out',
'restrict_access' => 'No access to',
'results_page' => 'Results Page',
'return_from_subworkflow' => 'Return from sub workflow',
'return_from_subworkflow_email_body' => 'Return from subworkflow
Document: [name]
Version: [version]
Workflow: [workflow]
Subworkflow: [subworkflow]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'return_from_subworkflow_email_subject' => '[sitename]: [name] - Return from subworkflow',
'reverse_links' => 'Documents, which have a link to the current document',
'reviewers' => 'Reviewers',
'reviewer_already_assigned' => 'User is already assigned as a reviewer',
'reviewer_already_removed' => 'Reviewer has already been removed from review process or has already submitted a review',
'reviews_accepted' => '[no_reviews] reviews already accepted',
'reviews_not_touched' => '[no_reviews] reviews not being touched',
'reviews_rejected' => '[no_reviews] reviews already rejected',
'reviews_without_group' => 'Reviews without group',
'reviews_without_user' => 'Reviews without user',
'review_deletion_email' => 'Review request deleted',
'review_deletion_email_body' => 'Review request deleted
Document: [name]
Version: [version]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'review_deletion_email_subject' => '[sitename]: [name] - Review request deleted',
'review_file' => 'File',
'review_group' => 'Review group',
'review_log' => 'Review log',
'review_request_email' => 'Review request',
'review_request_email_body' => 'Review request
Document: [name]
Version: [version]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'review_request_email_subject' => '[sitename]: [name] - Review request',
'review_status' => 'Review status',
'review_submit_email' => 'Submitted review',
'review_submit_email_body' => 'Submitted review
Document: [name]
Version: [version]
Status: [status]
Comment: [comment]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'review_submit_email_subject' => '[sitename]: [name] - Submitted review',
'review_summary' => 'Review Summary',
'review_update_failed' => 'Error updating review status. Update failed.',
'revise_document' => 'Revise document',
'revise_document_on' => 'Next revision of document version on [date]',
'revisions_accepted' => '[no_revisions] revisions already accepted',
'revisions_not_touched' => '[no_revisions] revisions not being touched',
'revisions_pending' => '[no_revisions] revisions due in future',
'revisions_rejected' => '[no_revisions] revisions already rejected',
'revisions_without_group' => 'Revisions without group',
'revisions_without_user' => 'Revisions without user',
'revision_date' => 'Date of revision',
'revision_log' => 'Revision log',
'revision_request_email_body' => 'Revision request
Document: [name]
Version: [version]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'revision_request_email_subject' => '[sitename]: [name] - Revision request',
'revision_status' => 'Status',
'revision_submit_email_body' => '',
'revision_submit_email_subject' => '',
'revisors' => 'Revisors',
'revisor_already_assigned' => 'User is already assigned as an revisor.',
'revisor_already_removed' => 'Revisor has already been removed from revision process or has already revised the document.',
'rewind_workflow' => 'Rewind workflow',
'rewind_workflow_email_body' => 'Workflow was rewinded
Document: [name]
Version: [version]
Workflow: [workflow]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'rewind_workflow_email_subject' => '[sitename]: [name] - Workflow was rewinded',
'rewind_workflow_warning' => 'If you rewind a workflow to its initial state, then the whole workflow log for this document will be deleted and cannot be recovered.',
'rm_attrdef' => 'Remove attribute definition',
'rm_attrdefgroup' => 'Remove this attribute group',
'rm_attr_value' => 'Remove value',
'rm_default_keyword_category' => 'Remove category',
'rm_document' => 'Remove document',
'rm_document_category' => 'Remove category',
'rm_event' => 'Remove event',
'rm_file' => 'Remove file',
'rm_folder' => 'Remove folder',
'rm_from_clipboard' => 'Remove from clipboard',
'rm_group' => 'Remove this group',
'rm_role' => 'Delete this role',
'rm_transmittal' => 'Remove transmittal',
'rm_transmittalitem' => 'Remove item',
'rm_user' => 'Remove user',
'rm_user_from_processes' => 'Remove user from processes',
'rm_version' => 'Remove version',
'rm_workflow' => 'Remove Workflow',
'rm_workflow_action' => 'Remove Workflow Action',
'rm_workflow_state' => 'Remove Workflow State',
'rm_workflow_warning' => 'You are about to remove the workflow from the document. This cannot be undone.',
'role' => 'Role',
'role_admin' => 'Administrator',
'role_guest' => 'Guest',
'role_info' => 'Information',
'role_management' => 'Role management',
'role_name' => 'Name',
'role_type' => 'Type of role',
'role_user' => 'User',
'ro_RO' => 'Romanian',
'run_subworkflow' => 'Run sub workflow',
'run_subworkflow_email_body' => 'Subworkflow was started
Document: [name]
Version: [version]
Workflow: [workflow]
Subworkflow: [subworkflow]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'run_subworkflow_email_subject' => '[sitename]: [name] - Subworkflow was started',
'ru_RU' => 'Russian',
'saturday' => 'Saturday',
'saturday_abbr' => 'Sa',
'save' => 'Save',
'scheduler_class' => 'Class',
'scheduler_class_description' => 'Description',
'scheduler_class_parameter' => 'Parameter',
'scheduler_class_tasks' => 'Tasks of class',
'scheduler_task_mgr' => 'Scheduler',
'search' => 'Search',
'search_fulltext' => 'Search in fulltext',
'search_in' => 'Search in',
'search_mode_and' => 'all words',
'search_mode_documents' => 'Documents only',
'search_mode_folders' => 'Folders only',
'search_mode_or' => 'at least one word',
'search_no_results' => 'There are no documents that match your search',
'search_query' => 'Search for',
'search_report' => 'Found [doccount] documents and [foldercount] folders in [searchtime] sec.',
'search_report_fulltext' => 'Found [doccount] documents',
'search_resultmode' => 'Search result',
'search_resultmode_both' => 'Documents and folders',
'search_results' => 'Search results',
'search_results_access_filtered' => 'Search results may contain content to which access has been denied.',
'search_time' => 'Elapsed time: [time] sec.',
'seconds' => 'seconds',
'selection' => 'Selection',
'select_attrdefgrp_show' => 'Choose when to show',
'select_attribute_value' => 'Select attribute value',
'select_category' => 'Click to select category',
'select_group' => 'Select group',
'select_groups' => 'Click to select groups',
'select_grp_approvers' => 'Click to select group approver',
'select_grp_ind_approvers' => 'Click to select group',
'select_grp_ind_notification' => 'Click to select group',
'select_grp_ind_recipients' => 'Click to select group',
'select_grp_ind_reviewers' => 'Click to select group',
'select_grp_ind_revisors' => 'Click to select group',
'select_grp_notification' => 'Click to select group notification',
'select_grp_recipients' => 'Click to select group of recipients',
'select_grp_reviewers' => 'Click to select group reviewer',
'select_grp_revisors' => 'Click to select group of revisors',
'select_ind_approvers' => 'Click to select individual approver',
'select_ind_notification' => 'Click to select individual notification',
'select_ind_recipients' => 'Click to select individual recipients',
'select_ind_reviewers' => 'Click to select individual reviewer',
'select_ind_revisors' => 'Click to select individual revisors',
'select_one' => 'Select one',
'select_user' => 'Select user',
'select_users' => 'Click to select users',
'select_value' => 'Select value',
'select_workflow' => 'Select workflow',
'send_email' => 'Send email',
'send_login_data' => 'Send login data',
'send_login_data_body' => 'Login data

Login: [login]
Name: [username]

[comment]',
'send_login_data_subject' => '[sitename]: [login] - Your login data',
'send_test_mail' => 'Send test mail',
'september' => 'September',
'sequence' => 'Sequence',
'seq_after' => 'After "[prevname]"',
'seq_end' => 'At the end',
'seq_keep' => 'Keep Position',
'seq_start' => 'First position',
'sessions' => 'Users online',
'setDateFromFile' => 'Take over date from imported file',
'setDateFromFolder' => '',
'settings' => 'Settings',
'settings_activate_module' => 'Activate module',
'settings_activate_php_extension' => 'Activate PHP extension',
'settings_adminIP' => 'Admin IP',
'settings_adminIP_desc' => 'If set, admin can login only by specified IP address. Leave empty to avoid lose of access. NOTE: works only with local authentication (no LDAP)',
'settings_Advanced' => 'Advanced',
'settings_advancedAcl' => 'Advanced Access control',
'settings_advancedAcl_desc' => 'Advanced access controll will allow to turn on/off certain modules of the software. It can not be used for access rights on documents and folders.',
'settings_allowReviewerOnly' => 'Allow to set reviewer only',
'settings_allowReviewerOnly_desc' => 'Enable this, if it shall be allow to set just a reviewer but no approver in traditional workflow mode.',
'settings_apache_mod_rewrite' => 'Apache - Module Rewrite',
'settings_Authentication' => 'Authentication settings',
'settings_autoLoginUser' => 'Automatic login',
'settings_autoLoginUser_desc' => 'Use this user id for accesses if the user is not already logged in. Such an access will not create a session.',
'settings_available_languages' => 'Available languages',
'settings_available_languages_desc' => 'Only the selected languages will be loaded and show up in the language selector. The default language will always be loaded.',
'settings_backupDir' => 'Backup directory',
'settings_backupDir_desc' => 'Directory where the backup tool saves backups. If this directory is not set or cannot be accessed, then the backups will be saved in the content directory.',
'settings_cacheDir' => 'Cache directory',
'settings_cacheDir_desc' => 'Where the preview images are stored (best to choose a directory that is not accessible through your web-server)',
'settings_Calendar' => 'Calendar settings',
'settings_calendarDefaultView' => 'Calendar Default View',
'settings_calendarDefaultView_desc' => 'Calendar default view',
'settings_cannot_disable' => 'File ENABLE_INSTALL_TOOL could not deleted',
'settings_checkOutDir' => 'Directory for checked out documents',
'settings_checkOutDir_desc' => 'This is the directory where the latest content of a document is copied if the document is checked out. If you make this directory accessible for users, they can edit the file and check it back in when finished.',
'settings_cmdTimeout' => 'Timeout for external commands',
'settings_cmdTimeout_desc' => 'This duration in seconds determines when an external command (e.g. for creating the full text index) will be terminated.',
'settings_contentDir' => 'Content directory',
'settings_contentDir_desc' => 'Where the uploaded files are stored (best to choose a directory that is not accessible through your web-server)',
'settings_contentOffsetDir' => 'Content Offset Directory',
'settings_contentOffsetDir_desc' => 'To work around limitations in the underlying file system, a new directory structure has been devised that exists within the content directory (Content Directory). This requires a base directory from which to begin. Usually leave this to the default setting, 1048576, but can be any number or string that does not already exist within (Content Directory)',
'settings_convertToPdf' => 'Convert document to PDF for preview',
'settings_convertToPdf_desc' => 'If a document cannot be natively displayed by the browser, a converted version to pdf will be shown.',
'settings_cookieLifetime' => 'Cookie Life time',
'settings_cookieLifetime_desc' => 'The life time of a cookie in seconds. If set to 0 the cookie will be removed when the browser is closed.',
'settings_coreDir' => 'Core LetoDMS directory',
'settings_coreDir_desc' => 'Path to LetoDMS_Core (optional). Leave this empty if you have installed LetoDMS_Core at a place where it can be found by PHP, e.g. Extra PHP Include-Path',
'settings_createCheckOutDir' => 'Create check out directory',
'settings_createCheckOutDir_desc' => 'Create checkout dir if it does not exists',
'settings_createdatabase' => 'Create database tables',
'settings_createdirectory' => 'Create directory',
'settings_currentvalue' => 'Current value',
'settings_Database' => 'Database settings',
'settings_dbDatabase' => 'Database',
'settings_dbDatabase_desc' => 'The name for your database entered during the installation process. Do not edit this field unless necessary, if for example the database has been moved.',
'settings_dbDriver' => 'Database Type',
'settings_dbDriver_desc' => 'The type of database in use entered during the installation process. Do not edit this field unless you are having to migrate to a different type of database perhaps due to changing hosts. Type of DB-Driver used by adodb (see adodb-readme)',
'settings_dbHostname' => 'Server name',
'settings_dbHostname_desc' => 'The hostname for your database entered during the installation process. Do not edit field unless absolutely necessary, for example transfer of the database to a new Host.',
'settings_dbPass' => 'Password',
'settings_dbPass_desc' => 'The password for access to your database entered during the installation process.',
'settings_dbUser' => 'Username',
'settings_dbUser_desc' => 'The username for access to your database entered during the installation process. Do not edit field unless absolutely necessary, for example transfer of the database to a new Host.',
'settings_dbVersion' => 'Database schema too old',
'settings_defaultAccessDocs' => 'Default access for new documents',
'settings_defaultAccessDocs_desc' => 'When a new document is created, this will be the default access right.',
'settings_defaultDocPosition' => 'Position of document when created',
'settings_defaultDocPosition_desc' => 'This is the default position within a folder when a document is created.',
'settings_defaultDocPosition_val_end' => 'end',
'settings_defaultDocPosition_val_start' => 'start',
'settings_defaultSearchMethod' => 'Default search method',
'settings_defaultSearchMethod_desc' => 'Default search method, when a search is started by the search form in the main menu.',
'settings_defaultSearchMethod_valdatabase' => 'database',
'settings_defaultSearchMethod_valfulltext' => 'fulltext',
'settings_delete_install_folder' => 'In order to use LetoDMS, you must delete the file ENABLE_INSTALL_TOOL in the configuration directory',
'settings_disableSelfEdit' => 'Disable Self Edit',
'settings_disableSelfEdit_desc' => 'If checked user cannot edit his own profile',
'settings_disable_install' => 'Delete file ENABLE_INSTALL_TOOL if possible',
'settings_Display' => 'Display settings',
'settings_dropFolderDir' => 'Directory for drop folder',
'settings_dropFolderDir_desc' => 'This directory can be used for dropping files on the server\'s file system and importing them from there instead of uploading via the browser. The directory must contain a sub directory for each user who is allowed to import files this way.',
'settings_Edition' => 'Edition settings',
'settings_editOnlineFileTypes' => 'Edit Online File Types',
'settings_editOnlineFileTypes_desc' => 'Files with one of the following endings can be edited online (USE ONLY LOWER CASE CHARACTERS)',
'settings_enable2FactorAuthentication' => 'Enable 2-factor authentication',
'settings_enable2FactorAuthentication_desc' => 'Enable/disable 2 factor authentication. The users will need the Google Authenticator on its mobile phone.',
'settings_enableAcknowledgeWorkflow' => '',
'settings_enableAcknowledgeWorkflow_desc' => '',
'settings_enableAdminReceipt' => 'Allow reception of documents for admins',
'settings_enableAdminReceipt_desc' => 'Enable this if you want administrators to be listed as recipients of documents.',
'settings_enableAdminRevApp' => 'Allow review/approval for admins',
'settings_enableAdminRevApp_desc' => 'Enable this if you want administrators to be listed as reviewers/approvers and for workflow transitions.',
'settings_enableCalendar' => 'Enable Calendar',
'settings_enableCalendar_desc' => 'Enable/disable calendar',
'settings_enableClipboard' => 'Enable Clipboard',
'settings_enableClipboard_desc' => 'Enable/disable the clipboard on the \'View Folder\' page',
'settings_enableConverting' => 'Enable Converting',
'settings_enableConverting_desc' => 'Enable/disable converting of files',
'settings_enableDropFolderList' => 'Enable list of files in drop folder in menu',
'settings_enableDropFolderList_desc' => 'Turn on a list of files in the drop folder. The list is shown in the main menu.',
'settings_enableDropUpload' => 'Enable Fast Upload',
'settings_enableDropUpload_desc' => 'Enable/Disable the drop area on the \'View Folder\' page for uploading files by Drag&Drop.',
'settings_enableDuplicateDocNames' => 'Allow duplicate document names',
'settings_enableDuplicateDocNames_desc' => 'Allows to have duplicate document names in a folder.',
'settings_enableEmail' => 'Enable E-mail',
'settings_enableEmail_desc' => 'Enable/disable automatic email notification',
'settings_enableFilterReceipt' => 'Filter out owner, reviewer, ... from reception list',
'settings_enableFilterReceipt_desc' => 'Enable, in order to filter out some recipients from a reception list if members of a group are selected.',
'settings_enableFolderTree' => 'Enable Folder Tree',
'settings_enableFolderTree_desc' => 'Enable/Disable the folder tree on the \'View Folder\' page',
'settings_enableFullSearch' => 'Enable Full text search',
'settings_enableFullSearch_desc' => 'Enable Full text search',
'settings_enableGuestAutoLogin' => 'Enable auto login for guest',
'settings_enableGuestAutoLogin_desc' => 'If a guest login and auto login is enabled, the guest will be logged in automatically.',
'settings_enableGuestLogin' => 'Enable Guest Login',
'settings_enableGuestLogin_desc' => 'If you want anybody to login as guest, check this option. Note: guest login should be used only in a trusted environment',
'settings_enableHelp' => 'Enable Help',
'settings_enableHelp_desc' => 'Enable/disable the link to the help screens in the menu',
'settings_enableLanguageSelector' => 'Enable Language Selector',
'settings_enableLanguageSelector_desc' => 'Show selector for user interface language after being logged in.',
'settings_enableLargeFileUpload' => 'Enable large file upload',
'settings_enableLargeFileUpload_desc' => 'If set, file upload is also available through a java applet called jumploader without a file size limit set by the browser. It also allows to upload several files in one step. Turning this on will turn off http only cookies.',
'settings_enableMenuTasks' => 'Enable task list in menu',
'settings_enableMenuTasks_desc' => 'Enable/Disable the menu item which contains all tasks for the user. This contains documents, that need to be reviewed, approved, etc.',
'settings_enableMultiUpload' => 'Allow upload of multiple files',
'settings_enableMultiUpload_desc' => 'When creating a new document, multiple files can be uploaded. Each will create a new document.',
'settings_enableNotificationAppRev' => 'Enable reviewer/approver notification',
'settings_enableNotificationAppRev_desc' => 'Check to send a notification to the reviewer/approver when a new document version is added',
'settings_enableNotificationWorkflow' => 'Send notification to users in next workflow transition',
'settings_enableNotificationWorkflow_desc' => 'If this option is enabled, the users and groups which need to take action in the next workflow transition will be notified. Even if they have not added a notification for the document.',
'settings_enableOwnerNotification' => 'Enable owner notification by default',
'settings_enableOwnerNotification_desc' => 'Check for adding a notification for the owner if a document when it is added.',
'settings_enableOwnerReceipt' => 'Allow reception of documents by owner',
'settings_enableOwnerReceipt_desc' => 'Enable this if you want the owner of a document to be listed as a recipient.',
'settings_enableOwnerRevApp' => 'Allow review/approval for owner',
'settings_enableOwnerRevApp_desc' => 'Enable this if you want the owner of a document to be listed as reviewers/approvers and for workflow transitions.',
'settings_enablePasswordForgotten' => 'Enable Password forgotten',
'settings_enablePasswordForgotten_desc' => 'If you want to allow user to set a new password and send it by mail, check this option.',
'settings_enableReceiptWorkflow' => 'Enable acknowledge of document reception',
'settings_enableReceiptWorkflow_desc' => 'Enable, to turn on the workflow to acknowledge document reception.',
'settings_enableRecursiveCount' => 'Enable recursive document/folder count',
'settings_enableRecursiveCount_desc' => 'If turned on, the number of documents and folders in the folder view will be determined by counting all objects by recursively processing the folders and counting those documents and folders the user is allowed to access.',
'settings_enableRevisionOnVoteReject' => 'Reject by one revisor',
'settings_enableRevisionOnVoteReject_desc' => 'If set the document will be reject if one revisor rejects the document.',
'settings_enableRevisionWorkflow' => 'Enable revision of documents',
'settings_enableRevisionWorkflow_desc' => 'Enable, to be able to run the workflow for revising a document after a given period of time.',
'settings_enableSelfReceipt' => 'Allow reception of documents for logged in user',
'settings_enableSelfReceipt_desc' => 'Enable this if you want the currently logged in user to be listed as recipient for a document.',
'settings_enableSelfRevApp' => 'Allow review/approval for logged in user',
'settings_enableSelfRevApp_desc' => 'Enable this if you want the currently logged in user to be listed as reviewers/approvers and for workflow transitions.',
'settings_enableSessionList' => 'Enable list of users online in menu',
'settings_enableSessionList_desc' => 'Enable list of currently logged in users in menu.',
'settings_enableThemeSelector' => 'Theme selection',
'settings_enableThemeSelector_desc' => 'Turns on/off the theme selector on the login page.',
'settings_enableUpdateReceipt' => 'Allow editing of existing reception',
'settings_enableUpdateReceipt_desc' => 'Enable this, if the user who has made a reception may change the decission.',
'settings_enableUpdateRevApp' => 'Allow editing of exting review/approval',
'settings_enableUpdateRevApp_desc' => 'Enable this, if the user who has made a review/approval may change the decission as long as the current workflow step has not been finished.',
'settings_enableUserImage' => 'Enable User Image',
'settings_enableUserImage_desc' => 'Enable users images',
'settings_enableUsersView' => 'Enable Users View',
'settings_enableUsersView_desc' => 'Enable/disable group and user view for all users',
'settings_enableVersionDeletion' => 'Enable deletion of previous versions',
'settings_enableVersionDeletion_desc' => 'Enable/disable deletion of previous document versions by regular users. Admin may always delete old versions.',
'settings_enableVersionModification' => 'Enable modification of versions',
'settings_enableVersionModification_desc' => 'Enable/disable modification of a document versions by regular users after a version was uploaded. Admin may always modify the version after upload.',
'settings_enableWebdavReplaceDoc' => 'Replace document when saving',
'settings_enableWebdavReplaceDoc_desc' => 'If enabled, saving a new version of a document will replace the old document instead of creating a new version. This will only apply if the user, mimetype and filename are equal to the last version. This can be usefull when applications are auto saving a document in fixed intervals.',
'settings_encryptionKey' => 'Encryption key',
'settings_encryptionKey_desc' => 'This string is used for creating a unique identifier being added as a hidden field to a form in order to prevent CSRF attacks.',
'settings_error' => 'Error',
'settings_expandFolderTree' => 'Expand Folder Tree',
'settings_expandFolderTree_desc' => 'Expand Folder Tree',
'settings_expandFolderTree_val0' => 'start with tree hidden',
'settings_expandFolderTree_val1' => 'start with tree shown and first level expanded',
'settings_expandFolderTree_val2' => 'start with tree shown fully expanded',
'settings_Extensions' => 'Extensions',
'settings_extraPath' => 'Extra PHP include Path',
'settings_extraPath_desc' => 'Path to additional software. This is the directory containing e.g. the adodb directory or additional pear packages',
'settings_firstDayOfWeek' => 'First day of the week',
'settings_firstDayOfWeek_desc' => 'First day of the week',
'settings_footNote' => 'Foot Note',
'settings_footNote_desc' => 'Message to display at the bottom of every page',
'settings_fullSearchEngine' => 'Fulltext engine',
'settings_fullSearchEngine_desc' => 'Set the method used for the fulltext search.',
'settings_fullSearchEngine_vallucene' => 'Zend Lucene',
'settings_fullSearchEngine_valsqlitefts' => 'SQLiteFTS',
'settings_guestID' => 'Guest ID',
'settings_guestID_desc' => 'ID of guest-user used when logged in as guest (mostly no need to change)',
'settings_httpRoot' => 'Http Root',
'settings_httpRoot_desc' => 'The relative path in the URL, after the domain part. Do not include the http:// prefix or the web host name. e.g. If the full URL is http://www.example.com/LetoDMS/, set \'/LetoDMS/\'. If the URL is http://www.example.com/, set \'/\'',
'settings_incItemsPerPage' => 'Number of entries loaded at end of page',
'settings_incItemsPerPage_desc' => 'If the number of folders and documents is limited, this will set the number of additionally loaded objects, when scrolling down to the bottom of the view folder page. Setting this to 0, will load the same number of objects as has been loaded initially.',
'settings_initialDocumentStatus' => 'Initial document status',
'settings_initialDocumentStatus_desc' => 'This status will be set when a document is added.',
'settings_initialDocumentStatus_draft' => 'Draft',
'settings_initialDocumentStatus_released' => 'released',
'settings_installADOdb' => 'Install ADOdb',
'settings_install_disabled' => 'File ENABLE_INSTALL_TOOL was deleted. You can now log into LetoDMS and do further configuration.',
'settings_install_pear_package_log' => 'Install Pear package \'Log\'',
'settings_install_pear_package_webdav' => 'Install Pear package \'HTTP_WebDAV_Server\', if you intend to use the webdav interface',
'settings_install_success' => 'The installation has been successfully completed.',
'settings_install_welcome_text' => '<p>Before you start to install LetoDMS make sure you have created a file \'ENABLE_INSTALL_TOOL\' in your configuration directory, otherwise the installation will not work. On Unix-System this can easily be done with \'touch conf/ENABLE_INSTALL_TOOL\'. After you have finished the installation delete the file.</p><p>LetoDMS has very minimal requirements. You will need a mysql database or sqlite support and a php enabled web server. The pear package Log has to be installed too. For the lucene full text search, you will also need the Zend framework installed on disc where it can be found by php. For the WebDAV server you will also need the HTTP_WebDAV_Server. The path to it can later be set during installation.</p><p>If you like to create the database before you start installation, then just create it manually with your favorite tool, optionally create a database user with access on the database and import one of the database dumps in the configuration directory. The installation script can do that for you as well, but it will need database access with sufficient rights to create databases.</p>',
'settings_install_welcome_title' => 'Welcome to the installation of LetoDMS',
'settings_install_zendframework' => 'Install Zend Framework, if you intend to use the zend based full text search engine. Otherwise, ignore this message and continue the installation.',
'settings_language' => 'Default language',
'settings_language_desc' => 'Default language (name of a subfolder in folder "languages")',
'settings_libraryFolder' => 'Library folder',
'settings_libraryFolder_desc' => 'Folder where documents can be copied to create new documents.',
'settings_logFileEnable' => 'Log File Enable',
'settings_logFileEnable_desc' => 'Enable/disable log file',
'settings_logFileRotation' => 'Log File Rotation',
'settings_logFileRotation_desc' => 'The log file rotation',
'settings_loginFailure' => 'Login failure',
'settings_loginFailure_desc' => 'Disable account after n login failures.',
'settings_luceneClassDir' => 'Lucene LetoDMS directory',
'settings_luceneClassDir_desc' => 'Path to LetoDMS_Lucene (optional). Leave this empty if you have installed LetoDMS_Lucene at a place where it can be found by PHP, e.g. Extra PHP Include-Path',
'settings_luceneDir' => 'Directory for full text index',
'settings_luceneDir_desc' => 'Path to Lucene index',
'settings_maxDirID' => 'Max Directory ID',
'settings_maxDirID_desc' => 'Maximum number of sub-directories per parent directory. Do not change this value unless you know what you do! Default: 0.',
'settings_maxExecutionTime' => 'Max Execution Time (s)',
'settings_maxExecutionTime_desc' => 'This sets the maximum time in seconds a script is allowed to run before it is terminated by the parse',
'settings_maxItemsPerPage' => 'Max. number of entries on a page',
'settings_maxItemsPerPage_desc' => 'Restricts the number of folders and documents shown on the view folder page. Further objects will be loaded when scrolling to the end of the page. Set to 0 to always show all objects.',
'settings_maxRecursiveCount' => 'Max. number of recursive document/folder count',
'settings_maxRecursiveCount_desc' => 'This is the maximum number of documents or folders that will be checked for access rights, when recursively counting objects. If this number is exceeded, the number of documents and folders in the folder view will be estimated.',
'settings_maxSizeForFullText' => 'Maximum filesize for instant indexing',
'settings_maxSizeForFullText_desc' => 'All new document version smaller than the configured size will be fully indexed right after uploading. In all other cases only the metadata will be indexed.',
'settings_maxUploadSize' => 'Maxium size for uploaded files',
'settings_maxUploadSize_desc' => 'This is the maximum size for uploaded files. It will take affect for document versions and attachments.',
'settings_more_settings' => 'Configure more settings. Default login: admin/admin',
'settings_notfound' => 'Not found',
'settings_Notification' => 'Notification settings',
'settings_notwritable' => 'The configuration cannot be saved because the configuration file is not writable.',
'settings_no_content_dir' => 'Content directory',
'settings_overrideMimeType' => 'Override MimeType',
'settings_overrideMimeType_desc' => 'Override the MimeType delivered by the browser, if a file is uploaded. The new MimeType is determined by LetoDMS itself.',
'settings_partitionSize' => 'Partial filesize',
'settings_partitionSize_desc' => 'Size of partial files in bytes, uploaded by jumploader. Do not set a value larger than the maximum upload size set by the server.',
'settings_passwordExpiration' => 'Password expiration',
'settings_passwordExpiration_desc' => 'The number of days after which a password expireѕ and must be reset. 0 turns password expiration off.',
'settings_passwordHistory' => 'Password history',
'settings_passwordHistory_desc' => 'The number of passwords a user must have been used before a password can be reused. 0 turns the password history off.',
'settings_passwordStrength' => 'Min. password strength',
'settings_passwordStrengthAlgorithm' => 'Algorithm for password strength',
'settings_passwordStrengthAlgorithm_desc' => 'The algorithm used for calculating the password strength. The \'simple\' algorithm just checks for at least eight chars total, a lower case letter, an upper case letter, a number and a special char. If those conditions are met the returned score is 100 otherwise 0.',
'settings_passwordStrengthAlgorithm_valadvanced' => 'advanced',
'settings_passwordStrengthAlgorithm_valsimple' => 'simple',
'settings_passwordStrength_desc' => 'The minimum password strength is an integer value from 0 to 100. Setting it to 0 will turn off checking for the minimum password strength.',
'settings_pear_log' => 'Pear package : Log',
'settings_pear_webdav' => 'Pear package : HTTP_WebDAV_Server',
'settings_perms' => 'Permissions',
'settings_php_dbDriver' => 'PHP extension : php_\'see current value\'',
'settings_php_gd2' => 'PHP extension : php_gd2',
'settings_php_mbstring' => 'PHP extension : php_mbstring',
'settings_php_version' => 'PHP version',
'settings_presetExpirationDate' => 'Preset expiration date',
'settings_presetExpirationDate_desc' => 'All new uploaded documents will have an expiration date set to this value. The date entered can be specified as understood by PHP\'s strtotime() function, e.g. +5 weeks.',
'settings_previewWidthDetail' => 'Width of preview images (detail)',
'settings_previewWidthDetail_desc' => 'Width of preview image shown on details page',
'settings_previewWidthDropFolderList' => 'Width of preview images (dropfolder list)',
'settings_previewWidthDropFolderList_desc' => 'Width of preview images shown in list when selecting a file from the drop folder.',
'settings_previewWidthList' => 'Width of preview images (list)',
'settings_previewWidthList_desc' => 'Width of preview images shown in lists',
'settings_previewWidthMenuList' => 'Width of preview images (menu list)',
'settings_previewWidthMenuList_desc' => 'Width of preview images shown as items in drop folder menu.',
'settings_printDisclaimer' => 'Print Disclaimer',
'settings_printDisclaimer_desc' => 'If enabled, the disclaimer message will be printed on the bottom of every page',
'settings_quota' => 'User\'s quota',
'settings_quota_desc' => 'The maximum number of bytes a user may use on disk. Set this to 0 for unlimited disk space. This value can be overridden for each user in his profile.',
'settings_removeFromDropFolder' => 'Remove file from drop folder after successful upload',
'settings_removeFromDropFolder_desc' => 'Enable this, if a file taken from the drop folder shall be deleted after successful upload.',
'settings_repositoryUrl' => 'URL of repository',
'settings_repositoryUrl_desc' => 'URL of repository for extensions',
'settings_restricted' => 'Restricted access',
'settings_restricted_desc' => 'Only allow users to log in if they have an entry in the local database (irrespective of successful authentication with LDAP)',
'settings_rootDir' => 'Root directory',
'settings_rootDir_desc' => 'Path to where LetoDMS is located',
'settings_rootFolderID' => 'Root Folder ID',
'settings_rootFolderID_desc' => 'ID of root-folder (mostly no need to change)',
'settings_SaveError' => 'Configuration file save error',
'settings_Server' => 'Server settings',
'settings_showFullPreview' => 'Show complete document',
'settings_showFullPreview_desc' => 'Enable/disable a full preview of the document on the details page, if the browser is capable to do so.',
'settings_showMissingTranslations' => 'Show missing translations',
'settings_showMissingTranslations_desc' => 'List all missing translations on the page at the bottom of the page. The logged in user will be able to submit a proposal for a missing translation which will be saved in a csv file. Do not turn this function on if in a production environment!',
'settings_showSingleSearchHit' => 'Jump straight to a single search hit',
'settings_showSingleSearchHit_desc' => 'If the search results into just one hit, then it will be displayed right away instead of the result list.',
'settings_Site' => 'Site',
'settings_siteDefaultPage' => 'Site Default Page',
'settings_siteDefaultPage_desc' => 'Default page on login. If empty defaults to out/out.ViewFolder.php',
'settings_siteName' => 'Site Name',
'settings_siteName_desc' => 'Name of site used in the page titles. Default: LetoDMS',
'settings_SMTP' => 'SMTP Server settings',
'settings_smtpPassword' => 'SMTP Server password',
'settings_smtpPassword_desc' => 'SMTP Server password',
'settings_smtpPort' => 'SMTP Server port',
'settings_smtpPort_desc' => 'SMTP Server port, default 25',
'settings_smtpSendFrom' => 'Send from',
'settings_smtpSendFrom_desc' => 'Send from',
'settings_smtpSendTestMail' => 'Send test mail',
'settings_smtpSendTestMail_desc' => 'Sends a test mail, for checking the current email configuration.',
'settings_smtpServer' => 'SMTP Server hostname',
'settings_smtpServer_desc' => 'SMTP Server hostname',
'settings_smtpUser' => 'SMTP Server user',
'settings_smtpUser_desc' => 'SMTP Server user',
'settings_sortFoldersDefault' => 'Default sort method',
'settings_sortFoldersDefault_desc' => 'This sets the sort methods for folders and documents in the folder view.',
'settings_sortFoldersDefault_val_name' => 'by name',
'settings_sortFoldersDefault_val_sequence' => 'by sequence',
'settings_sortFoldersDefault_val_unsorted' => 'unsorted',
'settings_sortUsersInList' => 'Sort users in list',
'settings_sortUsersInList_desc' => 'Sets if users in selection menus are ordered by login or by its full name',
'settings_sortUsersInList_val_fullname' => 'Sort by full name',
'settings_sortUsersInList_val_login' => 'Sort by login',
'settings_stagingDir' => 'Directory for partial uploads',
'settings_stagingDir_desc' => 'The directory where jumploader places the parts of a file upload before it is put back together.',
'settings_start_install' => 'Start installation',
'settings_stopWordsFile' => 'Path to stop words file',
'settings_stopWordsFile_desc' => 'If fulltext search is enabled, this file will contain stop words not being indexed',
'settings_strictFormCheck' => 'Strict Form Check',
'settings_strictFormCheck_desc' => 'Strict form checking. If set to true, then all fields in the form will be checked for a value. If set to false, then (most) comments and keyword fields become optional. Comments are always required when submitting a review or overriding document status',
'settings_suggestionvalue' => 'Suggestion value',
'settings_System' => 'System',
'settings_tasksInMenu' => 'Selected tasks',
'settings_tasksInMenu_approval' => 'Approvals',
'settings_tasksInMenu_desc' => 'Select those tasks which are to be counted. If none is selected, then all tasks will be counted.',
'settings_tasksInMenu_needscorrection' => 'Correction needed',
'settings_tasksInMenu_receipt' => 'Reviews',
'settings_tasksInMenu_review' => 'Receipts',
'settings_tasksInMenu_revision' => 'Revisions',
'settings_tasksInMenu_workflow' => 'Workflow',
'settings_theme' => 'Default theme',
'settings_theme_desc' => 'Default style (name of a subfolder in folder "styles")',
'settings_titleDisplayHack' => 'Title Display Hack',
'settings_titleDisplayHack_desc' => 'Workaround for page titles that go over more than 2 lines.',
'settings_undelUserIds' => 'Undeletable User IDs',
'settings_undelUserIds_desc' => 'Comma separated list of user ids, that cannot be deleted.',
'settings_updateDatabase' => 'Run schema update scripts on database',
'settings_updateNotifyTime' => 'Update Notify Time',
'settings_updateNotifyTime_desc' => 'Users are notified about document-changes that took place within the last \'Update Notify Time\' seconds',
'settings_upgrade_php' => 'Upgrade PHP to at least version 5.2.0',
'settings_versioningFileName' => 'Versioning FileName',
'settings_versioningFileName_desc' => 'The name of the versioning info file created by the backup tool',
'settings_versiontolow' => 'Version to low',
'settings_viewOnlineFileTypes' => 'View Online File Types',
'settings_viewOnlineFileTypes_desc' => 'Files with one of the following endings can be viewed online (USE ONLY LOWER CASE CHARACTERS)',
'settings_webdav' => 'WebDAV',
'settings_workflowMode' => 'Workflow mode',
'settings_workflowMode_desc' => 'The advanced workflow allows to specify your own release workflow for document versions.',
'settings_workflowMode_valadvanced' => 'advanced',
'settings_workflowMode_valtraditional' => 'traditional',
'settings_workflowMode_valtraditional_only_approval' => 'traditional (without review)',
'settings_zendframework' => 'Zend Framework',
'set_expiry' => 'Set Expiration',
'set_owner' => 'Set Owner',
'set_owner_error' => 'Error setting owner',
'set_password' => 'Set Password',
'set_workflow' => 'Set Workflow',
'show_extension_changelog' => 'Show Changelog',
'show_extension_version_list' => 'Show list of versions',
'signed_in_as' => 'Signed in as',
'sign_in' => 'Sign in',
'sign_out' => 'Sign out',
'sign_out_user' => 'Sign out user',
'sk_SK' => 'Slovak',
'space_used_on_data_folder' => 'Space used on data folder',
'splash_added_to_clipboard' => 'Added to clipboard',
'splash_add_access' => 'Access right added',
'splash_add_attribute' => 'New attribute added',
'splash_add_group' => 'New group added',
'splash_add_group_member' => 'New group member added',
'splash_add_role' => 'Added new role',
'splash_add_to_transmittal' => 'Add to transmittal',
'splash_add_transmittal' => 'Added transmittal',
'splash_add_user' => 'New user added',
'splash_cleared_cache' => 'Cache cleared',
'splash_cleared_clipboard' => 'Clipboard cleared',
'splash_delete_access' => 'Access right deleted',
'splash_document_added' => 'Document added',
'splash_document_checkedout' => 'Document checked out',
'splash_document_edited' => 'Document saved',
'splash_document_indexed' => 'Document \'[name]\' indexed.',
'splash_document_locked' => 'Document locked',
'splash_document_unlocked' => 'Document unlocked',
'splash_edit_access' => 'Access right changed',
'splash_edit_attribute' => 'Attribute saved',
'splash_edit_event' => 'Event saved',
'splash_edit_group' => 'Group saved',
'splash_edit_role' => 'Role saved',
'splash_edit_user' => 'User saved',
'splash_error_add_to_transmittal' => 'Error while adding document to transmittal',
'splash_error_rm_download_link' => 'Error when removing download link',
'splash_error_send_download_link' => 'Error while sending download link',
'splash_extension_getlist' => 'Updated list of extensions from repository',
'splash_extension_import' => 'Extensition installed',
'splash_extension_refresh' => 'Refreshed list of extensions',
'splash_extension_upload' => 'Extension installed',
'splash_folder_edited' => 'Save folder changes',
'splash_importfs' => 'Imported [docs] documents and [folders] folders',
'splash_inherit_access' => 'Access right will be inherited',
'splash_invalid_folder_id' => 'Invalid folder ID',
'splash_invalid_searchterm' => 'Invalid search term',
'splash_moved_clipboard' => 'Clipboard moved into current folder',
'splash_move_document' => 'Document moved',
'splash_move_folder' => 'Folder moved',
'splash_notinherit_access' => 'Access rights no longer inherited',
'splash_receipt_update_success' => 'Reception added successfully',
'splash_removed_from_clipboard' => 'Removed from clipboard',
'splash_rm_attribute' => 'Attribute removed',
'splash_rm_attr_value' => 'Attribute value removed',
'splash_rm_document' => 'Document removed',
'splash_rm_download_link' => 'Removed download link',
'splash_rm_folder' => 'Folder deleted',
'splash_rm_group' => 'Group removed',
'splash_rm_group_member' => 'Member of group removed',
'splash_rm_role' => 'Role deleted',
'splash_rm_transmittal' => 'Transmittal deleted',
'splash_rm_user' => 'User removed',
'splash_rm_user_processes' => 'User removed from all processes',
'splash_saved_file' => 'Version saved',
'splash_save_user_data' => 'User data saved',
'splash_send_download_link' => 'Download link sent by email.',
'splash_send_login_data' => 'Login data sent',
'splash_setowner' => 'Set new owner',
'splash_settings_saved' => 'Settings saved',
'splash_set_default_access' => 'Default access right set',
'splash_substituted_user' => 'Substituted user',
'splash_switched_back_user' => 'Switched back to original user',
'splash_toogle_group_manager' => 'Group manager toogled',
'splash_transfer_document' => 'Document transfered',
'splash_transfer_objects' => 'Objects transfered',
'state_and_next_state' => 'State/Next state',
'statistic' => 'Statistic',
'status' => 'Status',
'status_approval_rejected' => 'Draft rejected',
'status_approved' => 'Approved',
'status_approver_removed' => 'Approver removed from process',
'status_needs_correction' => 'Needs correction',
'status_not_approved' => 'Not approved',
'status_not_receipted' => 'Not receipted yet',
'status_not_reviewed' => 'Not reviewed',
'status_not_revised' => 'not revised',
'status_receipted' => 'Receipted',
'status_receipt_rejected' => 'Rejected',
'status_recipient_removed' => 'Recipient removed from list',
'status_reviewed' => 'Reviewed',
'status_reviewer_rejected' => 'Draft rejected',
'status_reviewer_removed' => 'Reviewer removed from process',
'status_revised' => 'revised',
'status_revision_rejected' => 'Rejected',
'status_revision_sleeping' => 'pending',
'status_revisor_removed' => 'Revisor removed from list',
'status_unknown' => 'Unknown',
'storage_size' => 'Storage size',
'submit_2_fact_auth' => 'Save secret',
'submit_approval' => 'Submit approval',
'submit_login' => 'Sign in',
'submit_password' => 'Set new password',
'submit_password_forgotten' => 'Start process',
'submit_receipt' => 'Submit receipt',
'submit_review' => 'Submit review',
'submit_revision' => 'Add Revision',
'submit_userinfo' => 'Submit info',
'subsribe_timelinefeed' => 'Subscribe to time line feed',
'substitute_to_user' => 'Switch to \'[username]\'',
'substitute_user' => 'Substitute User',
'success_add_aro' => 'Access request object added',
'success_add_permission' => 'Added permission',
'success_remove_permission' => 'Removed permission',
'success_toogle_permission' => 'Permission changed',
'sunday' => 'Sunday',
'sunday_abbr' => 'Su',
'sv_SE' => 'Swedish',
'switched_to' => 'Switched to',
'takeOverAttributeValue' => 'Take over attribute value from last version',
'takeOverGrpApprover' => 'Take over group of approvers from last version.',
'takeOverGrpReviewer' => 'Take over group of reviewers from last version.',
'takeOverIndApprover' => 'Take over individual approver from last version.',
'takeOverIndReviewer' => 'Take over individual reviewer from last version.',
'tasks' => 'Tasks',
'task_description' => 'Description',
'task_disabled' => 'Disabled',
'task_frequency' => 'Frequency',
'task_last_run' => 'Last run',
'task_name' => 'Name',
'task_next_run' => 'Next run',
'temp_jscode' => 'Temporary javascript code',
'testmail_body' => 'This mail is just for testing the mail configuration of LetoDMS',
'testmail_subject' => 'Test mail',
'theme' => 'Theme',
'thursday' => 'Thursday',
'thursday_abbr' => 'Th',
'timeline' => 'Timeline',
'timeline_add_file' => 'New Attachment',
'timeline_add_version' => 'New version [version]',
'timeline_full_add_file' => '[document]<br />New Attachment',
'timeline_full_add_version' => '[document]<br />New version [version]',
'timeline_full_scheduled_revision' => '[document]<br />Revision of version [version]',
'timeline_full_status_change' => '[document]<br />Version [version]: [status]',
'timeline_scheduled_revision' => 'Revision of version [version]',
'timeline_selected_item' => 'Selected document',
'timeline_skip_add_file' => 'attachment added',
'timeline_skip_scheduled_revision' => 'Scheduled revision',
'timeline_skip_status_change_-1' => 'rejected',
'timeline_skip_status_change_-3' => 'expired',
'timeline_skip_status_change_0' => 'pending review',
'timeline_skip_status_change_1' => 'pending approval',
'timeline_skip_status_change_2' => 'released',
'timeline_skip_status_change_3' => 'in workflow',
'timeline_skip_status_change_4' => 'in revision',
'timeline_skip_status_change_5' => 'draft',
'timeline_status_change' => 'Version [version]: [status]',
'to' => 'To',
'toggle_manager' => 'Toggle manager',
'toggle_qrcode' => 'Show/hide QR code',
'to_before_from' => 'End date may not be before start date',
'transfer_document' => 'Transfer document',
'transfer_no_read_access' => 'The user does not have read access in the folder',
'transfer_no_write_access' => 'The user does not have write access in the folder',
'transfer_objects' => 'Transfer objects',
'transfer_objects_to_user' => 'New owner',
'transfer_to_user' => 'Transfer to user',
'transition_triggered_email' => 'Workflow transition triggered',
'transition_triggered_email_body' => 'Workflow transition triggered
Document: [name]
Version: [version]
Comment: [comment]
Workflow: [workflow]
Previous state: [previous_state]
Current state: [current_state]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'transition_triggered_email_subject' => '[sitename]: [name] - Workflow transition triggered',
'transmittal' => 'Transmittal',
'transmittalitem_removed' => 'Transmittal item removed',
'transmittalitem_updated' => 'Document updated to latest version',
'transmittal_comment' => 'Comment',
'transmittal_name' => 'Name',
'transmittal_size' => 'Size',
'tree_loading' => 'Please wait, until document tree is loaded …',
'trigger_workflow' => 'Workflow',
'tr_TR' => 'Turkish',
'tuesday' => 'Tuesday',
'tuesday_abbr' => 'Tu',
'type_of_hook' => 'Type',
'type_to_search' => 'Type to search',
'uk_UA' => 'Ukrainian',
'under_folder' => 'In Folder',
'unknown_attrdef' => 'Unknown attribute definition',
'unknown_command' => 'Command not recognized.',
'unknown_document_category' => 'Unknown category',
'unknown_group' => 'Unknown group id',
'unknown_id' => 'unknown id',
'unknown_keyword_category' => 'Unknown category',
'unknown_owner' => 'Unknown owner id',
'unknown_user' => 'Unknown user id',
'unlinked_content' => 'Unlinked content',
'unlinked_documents' => 'Unlinked documents',
'unlinked_folders' => 'Unlinked folders',
'unlinking_objects' => 'Unlinking content',
'unlock_cause_access_mode_all' => 'You can still update it because you have access-mode "all". Locking will automatically be removed.',
'unlock_cause_locking_user' => 'You can still update it because you are also the one that locked it. Locking will automatically be removed.',
'unlock_document' => 'Unlock',
'update' => 'Update',
'update_approvers' => 'Update List of Approvers',
'update_document' => 'Update document',
'update_fulltext_index' => 'Update fulltext index',
'update_info' => 'Update Information',
'update_locked_msg' => 'This document is locked.',
'update_recipients' => 'Update list of recipients',
'update_reviewers' => 'Update List of Reviewers',
'update_revisors' => 'Update list of resubmitters',
'update_transmittalitem' => 'Update to latest document version',
'uploaded_by' => 'Uploaded by',
'uploading_failed' => 'Uploading one of your files failed. Please check your maximum upload file size.',
'uploading_maxsize' => 'The uploaded file exceeds the maximum upload file size.',
'uploading_zerosize' => 'Uploading an empty file. Upload is canceled.',
'used_discspace' => 'Used disk space',
'user' => 'User',
'userid_groupid' => 'User id/Group id',
'users' => 'Users',
'users_and_groups' => 'Users/Groups',
'users_done_work' => 'Users done work',
'user_exists' => 'User already exists.',
'user_group' => 'User/Group',
'user_group_management' => 'Users/Groups management',
'user_image' => 'Image',
'user_info' => 'User Information',
'user_list' => 'List of Users',
'user_login' => 'User ID',
'user_management' => 'Users management',
'user_name' => 'Full name',
'use_comment_of_document' => 'Use comment of document',
'use_default_categories' => 'Use predefined categories',
'use_default_keywords' => 'Use predefined keywords',
'valid_till' => 'Valid till',
'version' => 'Version',
'versioning_file_creation' => 'Versioning file creation',
'versioning_file_creation_warning' => 'With this operation you can create a file for each document containing the versioning information of that document. After the creation every file will be saved inside the document folder. Those files are not needed for the regular operation of the dms, but could be of value if the complete repository shall be transferred to an other system.',
'versioning_info' => 'Versioning info',
'versiontolow' => 'Version to low',
'version_deleted_email' => 'Version deleted',
'version_deleted_email_body' => 'Version deleted
Document: [name]
Version: [version]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'version_deleted_email_subject' => '[sitename]: [name] - Version deleted',
'version_info' => 'Version Information',
'view' => 'View',
'view_online' => 'View online',
'warning' => 'Warning',
'wednesday' => 'Wednesday',
'wednesday_abbr' => 'We',
'weeks' => 'weeks',
'week_view' => 'Week view',
'workflow' => 'Workflow',
'workflows_involded' => 'Involved in workflow',
'workflow_actions_management' => 'Workflow actions management',
'workflow_action_in_use' => 'This action is currently used by workflows.',
'workflow_action_name' => 'Name',
'workflow_editor' => 'Workflow Editor',
'workflow_group_summary' => 'Group summary',
'workflow_has_cycle' => 'Workflow has cycle',
'workflow_initstate' => 'Initial state',
'workflow_in_use' => 'This workflow is currently used by documents.',
'workflow_layoutdata_saved' => 'Layout data saved',
'workflow_management' => 'Workflow management',
'workflow_name' => 'Name',
'workflow_no_doc_rejected_state' => 'The document will not be rejected in a workflow state!',
'workflow_no_doc_released_state' => 'The document will not be released in a workflow state!',
'workflow_no_initial_state' => 'None of the transitions starts with the initial state of the workflow!',
'workflow_no_states' => 'You must first define workflow states, before adding a workflow.',
'workflow_save_layout' => 'Save layout',
'workflow_state' => 'workflow state',
'workflow_states_management' => 'Workflow states management',
'workflow_state_docstatus' => 'Document status',
'workflow_state_in_use' => 'This state is currently used by workflows.',
'workflow_state_name' => 'Name',
'workflow_summary' => 'Workflow summary',
'workflow_transition_without_user_group' => 'At least one of the transitions has neither a user nor a group!',
'workflow_user_summary' => 'User summary',
'x_more_objects' => '[number] more objects',
'year_view' => 'Year View',
'yes' => 'Yes',
'zh_CN' => 'Chinese (CN)',
'zh_TW' => 'Chinese (TW)',
);
?>
