#!/bin/bash
# Shared RADS Tools, written by Erik Soroka (eriks@imhadmin.net, ext 834)
# this script gets executed by crontab to collect sa accounting data for use by RADS tools

#####################################################################
### COLLECT AND ARCHIVE PROCESS ACCOUNTING DATA HERE
#####################################################################

if [ -d /opt/sharedrads ]; then
    RECENTCP=/opt/sharedrads/recent-cp
else
    RECENTCP=/opt/dedrads/recent-cp
fi

if [ -f /var/log/sa/rads/.lastcomm.lock ]; then
        CHECKLOCK=$(find /var/log/sa/rads/.lastcomm.lock -mmin +2 -name "*" -print)

	if [ "$CHECKLOCK" == "" ]; then
                exit 0
        else
            	rm -f /var/log/sa/rads/.lastcomm.lock
        fi

fi

	touch /var/log/sa/rads/.lastcomm.lock
        echo -e "\033[40;37;2mCPU seconds for last 15m\033[0m" > /var/log/sa/rads/.lastcomm.cache
        $RECENTCP -n 10 2>/dev/null | grep -Ev 'root|total' | awk '{print $2,$9,$10,"("$11")"}' | sed s/\|//g | grep "%" | sort -r -nk2 >> /var/log/sa/rads/.lastcomm.cache
	mv -f /var/log/sa/rads/.lastcomm.cache /var/log/sa/rads/lastcomm.cache
	LINES=$(wc -l /var/log/sa/rads/lastcomm.cache | awk '{print $1}')

if [ "$LINES" == "1" ]; then
	echo -e "[\033[31;1m PSACCT IS DISABLED\033[0m ]" >> /var/log/sa/rads/lastcomm.cache
fi

rm -f /var/log/sa/rads/.lastcomm.lock

## EOF ##
