<?php
// Version: 2.1.3; Admin

global $settings, $scripturl;

$txt['settings_saved'] = 'As configurações foram salvas com sucesso';
$txt['settings_not_saved'] = 'Suas mudanças não foram salvas pelo seguinte motivo: %1$s';

$txt['admin_boards'] = 'Seções e Categorias';
$txt['admin_users'] = 'Usuários';
$txt['admin_newsletters'] = 'Boletins informativos';
$txt['admin_edit_news'] = 'Notícias';
$txt['admin_groups'] = 'Grupos de Usuários';
$txt['admin_members'] = 'Gerenciar Usuários';
$txt['admin_members_list'] = 'Abaixo está uma lista de todos os usuários atualmente registrados em seu fórum.';
$txt['admin_next'] = 'Próximo';
$txt['admin_censored_words'] = 'Palavras censuradas';
$txt['admin_censored_where'] = 'Coloque a palavra a ser censurada à esquerda e o que deve aparecer em seu lugar à direita.';
$txt['admin_censored_desc'] = 'Devido à própria natureza pública dos fóruns, você pode querer proibir que alguns tipos de palavras sejam usadas. Você pode adicionar quaisquer palavras que queira que sejam censuradas sempre que forem usadas por um membro na caixa abaixo.<br>Limpe uma caixa para remover aquela palavra da censura.';
$txt['admin_reserved_names'] = 'Nomes reservados';
$txt['admin_modifications'] = 'Configurações de Modificações';
$txt['admin_server_settings'] = 'Configurações do Servidor';
$txt['admin_reserved_set'] = 'Definir nomes reservados';
$txt['admin_reserved_line'] = 'Uma palavra reservada por linha.';
$txt['admin_basic_settings'] = 'Esta página lhe permite modificar as configurações básicas do fórum. Tenha muito cuidado com estas configurações, pois podem fazer com que o fórum deixe de funcionar corretamente.';
$txt['admin_maintain'] = 'Habilitar modo de manutenção';
$txt['admin_title'] = 'Nome do Fórum';
$txt['cookie_name'] = 'Nome do Cookie';
$txt['admin_webmaster_email'] = 'Email do Webmaster';
$txt['cachedir'] = 'Diretório do cache';
$txt['admin_news'] = 'Ativar Notícias';
$txt['admin_manage_members'] = 'Membros';
$txt['admin_main'] = 'Principal';
$txt['admin_config'] = 'Configuração';
$txt['admin_version_check'] = 'Verificação detalhada da versão';
$txt['admin_smffile'] = 'Arquivo do SMF';
$txt['admin_smfpackage'] = 'Pacote do SMF';
$txt['admin_logoff'] = 'Encerrar sessão de administração';
$txt['admin_maintenance'] = 'Manutenção';
$txt['admin_credits'] = 'Créditos';
$txt['admin_agreement'] = 'Exigir que novos membros aceitem o termo de registro';
$txt['admin_agreement_minor_edit'] = 'Esta é uma pequena edição';
$txt['reset_agreement_desc'] = 'Isso exigirá que todos os membros leiam novamente e aceitem o termo de registro para continuar usando o fórum.';
$txt['admin_privacy_policy'] = 'Exigir que novos membros aceitem a política de privacidade';
$txt['reset_privacy_policy_desc'] = 'Isso exigirá que todos os membros leiam novamente e aceitem a política de privacidade para poderem continuar usando o fórum.';
$txt['admin_agreement_info'] = 'Última atualização: %1$s.';
$txt['admin_agreement_default'] = 'Padrão';
$txt['admin_agreement_select_language'] = 'Idioma para editar';
$txt['admin_agreement_select_language_change'] = 'Mudar';
$txt['admin_agreement_not_saved'] = 'As mudanças no acordo não foram salvas. Talvez as permissões no arquivo não tenham sido configuradas corretamente.';
$txt['admin_delete_members'] = 'Excluir os usuários selecionados';
$txt['admin_repair'] = 'Reparar todas as seções e tópicos';
$txt['admin_main_welcome'] = 'Este é o seu &quot;%1$s&quot;. A partir daqui você pode editar as configurações, fazer a manutenção do fórum, ver os logs, instalar pacotes, administrar temas, entre muitas outras coisas.
<br><br>Se tiver alguma dificuldade, por favor leia o painel de &quot;Suporte e créditos&quot;. Se a informação no painel de suporte não o ajudar, visite o <a href="http://www.simplemachines.org/community/index.php?board=18.0" target="_blank" class"new_win">Fórum de Suporte</a> e indique-nos o seu problema.<br>
Você também pode encontrar respostas para as suas perguntas ou problemas clicando nos símbolos <span class="generic_icons help" title="%3$s"></span> para obter mais informações nas funções correspondentes.';
$txt['admin_news_desc'] = 'Coloque uma notícia por caixa. As tags <abbr title="Bulletin Board Code">BBC</abbr> <span title="Porque todo mundo adora colchetes!"></span> como <span class="monospace">[b]</span>, <span class="monospace">[i]</span> e <span class="monospace">[u]</span>, são permitidas em suas notícias, assim como smileys. Apague a caixa de texto de uma notícia para removê-la.';
$txt['administrators'] = 'Administradores do fórum';
$txt['admin_reserved_desc'] = 'Os nomes reservados servem para impedir que os usuários registrem alguns nomes ou usem algumas palavras no seu nome. Selecione as opções que deseja usar abaixo antes de enviar.';
$txt['admin_match_whole'] = 'Corresponder apenas ao nome inteiro. Se estiver desmarcado, procurar entre os nomes.';
$txt['admin_match_case'] = 'Sensível a maiúsculas. Se estiver desmarcado, a busca não será sensível às maiúsculas/minúsculas.';
$txt['admin_check_user'] = 'Checar nome do usuário.';
$txt['admin_check_display'] = 'Checar nome visível.';
$txt['admin_fader_delay'] = 'Tempo em milissegundos para mostrar cada item das notícias';
$txt['additional_options_collapsable'] = 'Habilitar opções de postagem adicionais minimizáveis';
$txt['guest_post_no_email'] = 'Não mostrar o campo de e-mail para postagens de visitantes';
$txt['zero_for_no_limit'] = '(0 para sem limite)';
$txt['zero_to_disable'] = '(0 para desativar)';
$txt['dont_show_attach_under_post'] = 'Não mostrar anexos abaixo da postagem se eles já estiverem incorporados nela.';
$txt['dont_show_attach_under_post_sub'] = 'Habilite isto se você não quiser que os anexos apareçam duas vezes. Anexos que estejam dentro das postagens ainda contam para os limites de anexos e ainda podem ser tratados como anexos normais.';

$txt['admin_backup_fail'] = 'Falha ao fazer o backup do arquivo settings.php - certifique-se que o arquivo Settings_bak.php existe e tem permissões de escrita.';
$txt['registration_agreement'] = 'Editar o Acordo de Registro';
$txt['registration_agreement_desc'] = 'Este acordo é mostrado quando um usuário se registra no fórum. O usuário tem de aceitar os termos do acordo antes de poder confirmar o seu registro.';
$txt['privacy_policy'] = 'Política de Privacidade';
$txt['privacy_policy_desc'] = 'Esta política de privacidade descreve as promessas que você faz aos seus usuários sobre como usará seus dados pessoais. É mostrado quando um usuário registra uma conta neste fórum e deve ser aceito antes que o usuário possa continuar o registro.';
$txt['errors_list'] = 'Listagem dos erros do fórum';
$txt['errors_found'] = 'Os seguintes erros estão atrapalhando o fórum';
$txt['errors_fix'] = 'Deseja tentar corrigir estes erros?';
$txt['errors_do_recount'] = 'Todos os erros corrigidos e foi criada uma área de resgate. Por favor clique no botão abaixo para recalcular algumas estatísticas fundamentais.';
$txt['errors_recount_now'] = 'Recontar Estatísticas';
$txt['errors_fixing'] = 'Corrigindo erros do fórum';
$txt['errors_fixed'] = 'Todos os erros foram corrigidos! Verifique todas as categorias, seções ou tópicos criados para decidir o que fazer com eles.';
$txt['attachments_avatars'] = 'Anexos e Avatares';
$txt['attachments_desc'] = 'Daqui você pode administrar todos os anexos. Você pode excluir anexos por tamanho e data. Você pode também visualizar as estatísticas dos anexos.';
$txt['attachment_stats'] = 'Estatísticas dos Anexos';
$txt['attachment_integrity_check'] = 'Verificação de integridade de anexos';
$txt['attachment_integrity_check_desc'] = 'Esta função irá verificar a integridade e tamanhos de anexos e nomes de arquivos listados no sistema e, se necessário, corrigir os erros que encontrar.';
$txt['attachment_check_now'] = 'Executar a verificação agora';
$txt['attachment_pruning'] = 'Aparamento de Anexos';
$txt['attachment_pruning_message'] = 'Mensagem para adicionar à postagem';
$txt['attachment_pruning_warning'] = 'Você tem certeza que quer excluir esses anexos? Isso não pode ser desfeito!';

$txt['attachment_total'] = 'Total de anexos';
$txt['attachmentdir_size'] = 'Tamanho total de todos os diretórios de anexos';
$txt['attachmentdir_size_current'] = 'Tamanho total do diretório de anexos atual';
$txt['attachmentdir_files_current'] = 'Total de arquivos no diretório de anexos atual';
$txt['attachment_space'] = 'Espaço total disponível';
$txt['attachment_files'] = 'Total de arquivos remanescentes';

$txt['attachment_log'] = 'Log de Anexos';
$txt['attachment_remove_old'] = 'Remover anexos mais velhos que';
$txt['attachment_remove_size'] = 'Remover anexos maiores que';
$txt['attachment_name'] = 'Nome do anexo';
$txt['attachment_file_size'] = 'Tamanho do arquivo';
$txt['attachmentdir_size_not_set'] = 'Nenhum limite de tamanho do diretório está definido no momento';
$txt['attachmentdir_files_not_set'] = 'Nenhum limite de número de arquivos no diretório está definido no momento';
$txt['attachment_delete_admin'] = '[anexo excluído pelo administrador]';
$txt['live'] = 'Ao vivo do Simple Machines...';
$txt['remove_all'] = 'Limpar o log';
$txt['agreement_not_writable'] = 'Aviso - o arquivo agreement.txt não tem permissão de escrita, qualquer alteração que faça NÃO será salva.';

$txt['version_check_desc'] = 'Isto mostra as versões dos arquivos da sua instalação em comparação aos da versão mais recente. Se algum destes arquivos estiver desatualizado, você deve baixar a última versão no <a href="https://www.simplemachines.org/" target="_blank" class="new_win">www.simplemachines.org</a> e fazer a atualização.';
$txt['version_check_more'] = '(mais detalhado)';

$txt['smf_news_cant_connect'] = 'Não foi possível se conectar ao arquivo de notícias mais recente do simplemachines.org.';

$txt['manage_calendar'] = 'Calendário';
$txt['manage_search'] = 'Busca';

$txt['smileys_manage'] = 'Smileys e ícones de mensagem';
$txt['theme_admin'] = 'Temas e Layout';
$txt['registration_center'] = 'Cadastros';

$txt['viewmembers_online'] = 'Última vez online';
$txt['viewmembers_today'] = 'Hoje';
$txt['viewmembers_day_ago'] = 'dia atrás';
$txt['viewmembers_days_ago'] = 'dias atrás';

$txt['display_name'] = 'Nome visível';
$txt['email_address'] = 'Endereço de email';
$txt['ip_address'] = 'Endereço de IP';
$txt['member_id'] = 'ID';

$txt['unknown'] = 'desconhecido';

// argument(s): HTTP_REFERER (if applicable), HTTP_USER_AGENT, ip address
$txt['security_wrong'] = 'Tentativa de login da administração!
Referenciador: %1$s
Agente do usuário: %2$s
IP: %3$s';

$txt['email_as_html'] = 'Enviar em formato HTML. (Com isto você pode enviar HTML nos emails normalmente)';
$txt['email_parsed_html'] = 'Adicionar &lt;br /&gt;s e &amp;nbsp;s a esta mensagem.';
// argument(s): $scripturl
$txt['email_variables'] = 'Nesta mensagem é possível usar algumas &quot;variáveis&quot;. Clique <a href="%1$s?action=helpadmin;help=email_members" onclick="return reqOverlayDiv(this.href);" class="help">aqui</a> para mais informações.';
$txt['email_force'] = 'Envie esta mensagem aos membros mesmo que eles tenham optado por não receber anúncios.<br><span class="alert">Isso só deve ser usado em circunstâncias excepcionais. Usar isso para enviar mensagens de e-mail promocionais ou outras mensagens não essenciais viola as leis de privacidade e anti-spam de muitos países.</span>';
$txt['email_as_pms'] = 'Enviar para estes grupos usando mensagens pessoais.';
$txt['email_continue'] = 'Continuar';
$txt['email_done'] = 'concluído.';

$txt['warnings'] = 'Avisos';
$txt['warnings_desc'] = 'Este sistema permite que administradores e moderadores emitam avisos aos usuários, e pode automaticamente remover suas permissões à medida que o nível de aviso aumenta. Para fazer uso completo deste sistema a &quot;Moderação de Postagens&quot; deve estar ativa.';

$txt['ban_title'] = 'Lista de banimentos';

$txt['ban_errors_detected'] = 'O seguinte erro (ou erros) ocorreu ao salvar ou editar o banimento';
$txt['ban_description'] = 'Aqui você pode banir usuários problemáticos por IP, servidor, nome de usuário ou email.';
$txt['ban_add_new'] = 'Adicionar novo banimento';
$txt['ban_banned_entity'] = 'Entidade banida';
$txt['ban_on_ip'] = 'Banir por IP (ex. 192.168.10-20.*)';
$txt['ban_on_hostname'] = 'Banir por servidor (ex. *.mil)';
$txt['ban_on_email'] = 'Banir por email (ex. *@mausite.com)';
$txt['ban_on_username'] = 'Banir por nome de usuário';
$txt['ban_notes'] = 'Notas';
$txt['ban_restriction'] = 'Restrição';
$txt['ban_full_ban'] = 'Banimento total';
$txt['ban_partial_ban'] = 'Banimento parcial';
$txt['ban_cannot_post'] = 'Não pode postar';
$txt['ban_cannot_register'] = 'Não pode se cadastrar';
$txt['ban_cannot_login'] = 'Não pode fazer login';
$txt['ban_add'] = 'Adicionar';
$txt['ban_edit_list'] = 'Lista de banimentos';
$txt['ban_type'] = 'Tipo de banimento';
$txt['ban_days'] = 'dia(s)';
$txt['ban_will_expire_within'] = 'O banimento irá expirar depois de';
$txt['ban_added'] = 'Adicionado';
$txt['ban_expires'] = 'Expira';
$txt['ban_hits'] = 'Acertos';
$txt['ban_actions'] = 'Ações';
$txt['ban_expiration'] = 'Vencimento';
$txt['ban_reason_desc'] = 'Motivo do banimento, para ser exibido ao membro banido.';
$txt['ban_notes_desc'] = 'Notas que podem ajudar os outros membros da equipe.';
$txt['ban_remove_selected'] = 'Remover selecionados';
// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['ban_remove_selected_confirm'] = 'Tem certeza que deseja remover os banimentos selecionados?';
$txt['ban_modify'] = 'Alterar';
$txt['ban_name'] = 'Nome do banimento';
// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['ban_edit'] = 'Editar banimento';
$txt['ban_add_notes'] = '<strong>Nota</strong>: Após criar o banimento acima, você pode adicionar mais regras que ativam o banimento, como IP, servidores e endereço de e-mail.';
$txt['ban_expired'] = 'Expirado/desativado';
// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['ban_restriction_empty'] = 'Nenhuma restrição selecionada';

$txt['ban_triggers'] = 'Gatilhos';
$txt['ban_add_trigger'] = 'Adicionar gatilho de banimento';
$txt['ban_add_trigger_submit'] = 'Adicionar';
$txt['ban_edit_trigger'] = 'Modificar';
$txt['ban_edit_trigger_title'] = 'Editar gatilho';
$txt['ban_edit_trigger_submit'] = 'Modificar';
$txt['ban_remove_selected_triggers'] = 'Remover gatilhos selecionados';
$txt['ban_no_entries'] = 'Atualmente não há banimentos em vigor.';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['ban_remove_selected_triggers_confirm'] = 'Tem certeza que quer remover os gatilhos selecionados?';
$txt['ban_trigger_browse'] = 'Ver gatilhos';
$txt['ban_trigger_browse_description'] = 'Esta página mostra uma lista de todos os banimentos, agrupados por endereço de IP, servidores, endereço de email e nome de usuário.';

$txt['ban_log'] = 'Log de banimentos';
$txt['ban_log_description'] = 'O log de banimentos mostra todas as tentativas de entrar no fórum pelos usuários banidos (apenas para os que têm \'bloqueio total\' e os que \'não podem se registrar\').';
$txt['ban_log_no_entries'] = 'Atualmente não há entradas no log de banimentos.';
$txt['ban_log_ip'] = 'IP';
$txt['ban_log_email'] = 'Endereço de email';
$txt['ban_log_member'] = 'Membro';
$txt['ban_log_date'] = 'Data';
$txt['ban_log_remove_all'] = 'Limpar log';
$txt['ban_log_remove_all_confirm'] = 'Tem certeza que quer excluir todos os itens do log de banimentos?';
$txt['ban_log_remove_selected'] = 'Remover selecionados';
$txt['ban_log_remove_selected_confirm'] = 'Tem certeza que quer apagar todos os itens selecionados?';
$txt['ban_no_triggers'] = 'Não há gatilhos de banimento no momento.';

$txt['settings_not_writable'] = 'Estas configurações não podem ser alteradas porque o arquivo Settings.php não tem permissões de escrita.';

$txt['maintain_title'] = 'Manutenção do fórum';
$txt['maintain_info'] = 'Otimize tabelas, faça backups, verifique se há erros e melhore o desempenho do fórum com estas ferramentas.';
$txt['maintain_sub_database'] = 'Base de dados';
$txt['maintain_sub_routine'] = 'Rotina';
$txt['maintain_sub_members'] = 'Membros';
$txt['maintain_sub_topics'] = 'Tópicos';
$txt['maintain_done'] = 'A tarefa de manutenção \'%1$s\' foi executada com sucesso.';
$txt['maintain_no_errors'] = 'Parabéns, não foram encontrados erros! Obrigado por verificar.';

$txt['maintain_tasks'] = 'Tarefas agendadas';
$txt['maintain_tasks_desc'] = 'Gerencie todas as tarefas agendadas pelo SMF.';
$txt['scheduled_tasks_settings'] = 'Configurações';
$txt['scheduled_tasks_settings_desc'] = 'Configurações para controlar como as tarefas agendadas são executadas.';

$txt['scheduled_log'] = 'Log de Tarefas';
$txt['scheduled_log_desc'] = 'Este log exibe todas as tarefas agendadas que foram executadas no fórum.';
$txt['admin_log'] = 'Log de Administração';
$txt['admin_log_desc'] = 'Exibe as tarefas administrativas que foram executadas pelos administradores do seu fórum.';
$txt['moderation_log'] = 'Log de Moderação';
$txt['moderation_log_desc'] = 'Lista as atividades de moderação feitas pelos moderadores no seu fórum.';
$txt['spider_log_desc'] = 'Revisar as entradas relacionadas à atividade do mecanismo de pesquisa em seu fórum.';
$txt['log_settings_desc'] = 'Utilize estas opções para configurar como o log de atividade funciona em seu fórum.';
$txt['modlog_enabled'] = 'Habilitar o log de moderação';
$txt['adminlog_enabled'] = 'Habilitar o log de administração';
$txt['userlog_enabled'] = 'Habilitar o log de edições de perfil';

$txt['mailqueue_title'] = 'Email';

$txt['db_error_send'] = 'Envie e-mails sobre erros de conexão com o banco de dados';
$txt['db_persist'] = 'Utilizar uma conexão persistente';
$txt['ssi_db_user'] = 'Nome de usuário do banco de dados para usar em modo SSI';
$txt['ssi_db_passwd'] = 'Senha do banco de dados para usar em modo SSI';

$txt['default_language'] = 'Idioma padrão do fórum';

$txt['maintenance_subject'] = 'Assunto a exibir';
$txt['maintenance_message'] = 'Mensagem a exibir';

$txt['errorlog_desc'] = 'O log de erros rastreia todos os erros encontrados pelo seu fórum. Para apagar qualquer erro no banco de dados, marque a caixa de seleção e clique no botão %1$s na parte inferior da página.';
$txt['errorlog_no_entries'] = 'No momento, não há entradas de log de erros.';

$txt['theme_settings'] = 'Configurações de Tema';
$txt['theme_current_settings'] = 'Tema atual';

$txt['dvc_your'] = 'Sua versão';
$txt['dvc_current'] = 'Versão atual';
$txt['dvc_sources'] = 'Fontes';
$txt['dvc_default'] = 'Modelos padrão';
$txt['dvc_templates'] = 'Modelos atuais';
$txt['dvc_languages'] = 'Arquivos de idiomas';
$txt['dvc_tasks'] = 'Tarefas em segundo plano';

$txt['smileys_default_set_for_theme'] = 'Selecionar o conjunto de smileys padrão para este tema';
$txt['smileys_no_default'] = '(usar um conjunto de smileys global)';

$txt['censor_test'] = 'Testar palavras censuradas';
$txt['censor_test_save'] = 'Testar';
$txt['censor_case'] = 'Ignorar maiúsculas/minúsculas na censura.';
$txt['censor_whole_words'] = 'Verificar apenas palavras inteiras.';

$txt['admin_confirm_password'] = '(confirmar)';
$txt['admin_incorrect_password'] = 'Senha incorreta';

$txt['age'] = 'Idade';
$txt['activation_status'] = 'Estado da ativação';
$txt['activated'] = 'Ativado';
$txt['not_activated'] = 'Não ativado';
$txt['primary'] = 'Primário';
$txt['additional'] = 'Adicional';
$txt['wild_cards_allowed'] = 'caracteres especiais * e ? são permitidos';
$txt['search_for'] = 'Buscar por';
$txt['search_match'] = 'Encontrar';
$txt['member_part_of_these_membergroups'] = 'O usuário faz parte destes grupos';
$txt['membergroups'] = 'Grupos';
$txt['confirm_delete_members'] = 'Tem certeza que deseja excluir os usuários selecionados?';

$txt['support_credits_title'] = 'Suporte e créditos';
$txt['support_title'] = 'Informação de suporte';
$txt['support_versions_current'] = 'Versão atual do SMF';
$txt['support_versions_forum'] = 'Versão do fórum';
$txt['support_versions_db'] = 'Versão %1$s';
$txt['support_versions_db_engine'] = 'Motor %1$s';
$txt['support_versions_server'] = 'Versão do servidor';
$txt['support_versions_gd'] = 'Versão do GD';
$txt['support_versions_imagemagick'] = 'Versão do ImageMagick';
$txt['support_versions'] = 'Informação de Versão';
$txt['support_resources'] = 'Recursos de Suporte';
$txt['support_resources_p1'] = 'Nosso <a href="%1$s">Manual Online</a> fornece a documentação principal para o SMF. O Manual Online do SMF possui diversos documentos para ajudar a responder questões de suporte e explicar os <a href="%2$s">Recursos</a>, <a href="%3$s">Configurações</a>, <a href="%4$s">Temas</a>, <a href="%5$s">Pacotes</a> etc. O Manual Online documenta detalhadamente cada área do SMF e deve responder rapidamente à maioria das dúvidas.';
$txt['support_resources_p2'] = 'Se você não encontrar as respostas para suas perguntas no Manual Online, você poderá buscar na nossa <a href="%1$s">Comunidade de Suporte</a> ou pedir ajuda em uma das nossas seções de suporte em <a href="%2$s">Inglês</a> ou <a href="%3$s">internacionais</a>. A comunidade de suporte do SMF pode ser utilizada para <a href="%4$s">suporte</a>, <a href="%5$s">customização</a> e muitas outras coisas.';

$txt['membergroups_members'] = 'Usuários normais';
$txt['membergroups_guests'] = 'Visitantes';
$txt['membergroups_add_group'] = 'Adicionar grupo';
$txt['membergroups_permissions'] = 'Permissões';

$txt['permitgroups_restrict'] = 'Restritivo';
$txt['permitgroups_standard'] = 'Normal';
$txt['permitgroups_moderator'] = 'Moderador';
$txt['permitgroups_maintenance'] = 'Manutenção';
$txt['permitgroups_inherit'] = 'Herdar';

$txt['confirm_delete_attachments_all'] = 'Tem certeza que quer excluir todos os anexos?';
$txt['confirm_delete_attachments'] = 'Tem certeza que quer excluir os anexos selecionados?';
$txt['attachment_manager_browse_files'] = 'Navegar pelos arquivos';
$txt['attachment_manager_repair'] = 'Manutenção';
$txt['attachment_manager_avatars'] = 'Avatares';
$txt['attachment_manager_attachments'] = 'Anexos';
$txt['attachment_manager_thumbs'] = 'Miniaturas';
$txt['attachment_manager_last_active'] = 'Última vez ativo';
$txt['attachment_manager_member'] = 'Usuário';
$txt['attachment_manager_avatars_older'] = 'Excluir avatares dos usuários inativos há mais de';
$txt['attachment_manager_total_avatars'] = 'Total de avatares';

$txt['attachment_manager_avatars_no_entries'] = 'Não há avatares no momento.';
$txt['attachment_manager_attachments_no_entries'] = 'Não há anexos no momento.';
$txt['attachment_manager_thumbs_no_entries'] = 'Não há miniaturas no momento.';

$txt['attachment_manager_settings'] = 'Configurações de anexos';
$txt['attachment_manager_avatar_settings'] = 'Configurações de avatares';
$txt['attachment_manager_browse'] = 'Explorar arquivos';
$txt['attachment_manager_maintenance'] = 'Manutenção dos arquivos';
$txt['attachment_manager_save'] = 'Salvar';

$txt['attachmentEnable'] = 'Modo dos anexos';
$txt['attachmentEnable_deactivate'] = 'Desativar anexos';
$txt['attachmentEnable_enable_all'] = 'Habilitar todos os anexos';
$txt['attachmentEnable_disable_new'] = 'Desabilitar novos anexos';
$txt['attachmentCheckExtensions'] = 'Verificar tipo de arquivo dos anexos';
$txt['attachmentExtensions'] = 'Tipos de arquivos permitidos';
$txt['attachmentShowImages'] = 'Mostrar imagens anexadas como imagens abaixo da postagem';
$txt['attachmentUploadDir'] = 'Diretório de anexos';
$txt['attachmentUploadDir_multiple_configure'] = 'Gerenciar diretórios de anexos';
$txt['attachmentDirSizeLimit'] = 'Tamanho máximo do diretório dos anexos';
$txt['attachmentPostLimit'] = 'Tamanho máximo dos anexos por postagem';
$txt['attachmentSizeLimit'] = 'Tamanho máximo por anexo';
$txt['attachmentNumPerPostLimit'] = 'Máximo de anexos por mensagem';
$txt['attachment_img_enc_warning'] = 'Nem o módulo GD nem as extensões IMagick ou MagickWand estão instalados atualmente. Não é possível recodificar imagens.';
$txt['attachment_ini_max'] = 'Máximo permitido pelo php.ini: %1$s';
$txt['attachment_image_reencode'] = 'Recodificar imagens anexadas potencialmente perigosas.';
$txt['attachment_image_paranoid_warning'] = 'A verificação extensiva de segurança pode resultar num grande número de anexos sendo rejeitados.';
$txt['attachment_image_paranoid'] = 'Executar verificação extensiva de segurança nos anexos de imagens enviados';
$txt['attachmentThumbnails'] = 'Mostrar imagens como miniaturas quando exibidas abaixo da postagem';
$txt['attachment_thumb_png'] = 'Salvar miniaturas como PNG';
$txt['attachment_thumb_memory'] = 'Memória adaptativa de miniaturas';
$txt['attachment_thumb_memory_note'] = 'Se desativado, a memória será limitada a 128M';
$txt['attachmentThumbWidth'] = 'Largura máxima das miniaturas';
$txt['attachmentThumbHeight'] = 'Altura máxima das miniaturas';
$txt['attachment_thumbnail_settings'] = 'Configurações das miniaturas';
$txt['attachment_security_settings'] = 'Configurações de segurança de anexos';

$txt['attach_dir_does_not_exist'] = 'Não existe';
$txt['attach_dir_not_writable'] = 'Não tem permissão de escrita';
// argument(s): session_id, session_var, scripturl
$txt['attach_dir_files_missing'] = 'Arquivos ausentes (<a href="%3$s?action=admin;area=manageattachments;sa=repair;%2$s=%1$s">Reparar</a>)';
$txt['attach_dir_unused'] = 'Não usado';
$txt['attach_dir_empty'] = 'Vazio';
$txt['attach_dir_ok'] = 'Ok';
$txt['attach_dir_basedir'] = 'Diretório base';
$txt['attach_dir_desc'] = 'Crie novos diretórios ou altere o diretório atual abaixo.<br>Para criar um novo diretório na estrutura do diretório do fórum, utilize apenas o nome do diretório. <br>Para remover um diretório, deixe em branco sua caixa. Apenas diretórios vazios podem ser removidos. Para verificar se um diretório está vazio, procure por arquivos ou sub-diretórios entre parênteses ao lado do número de arquivos. <br>Para renomear um diretório, simplesmente mude o seu nome na caixa de texto. Somente os diretórios sem sub-diretórios podem ser renomeados. Diretórios podem ser renomeados desde que não contenham um sub-diretório.';
$txt['attach_dir_base_desc'] = 'Você pode usar a seguir para alterar o diretório base atual ou criar um novo. Novos diretórios base também são adicionados à lista de diretório de anexos. Você também pode designar um diretório existente para ser um diretório base.';
$txt['attach_dir_save_problem'] = 'Oops, parece que houve um problema.';
$txt['attachments_no_create'] = 'Não foi possível criar um novo diretório de anexos. Por favor, faça-o usando um cliente FTP ou o gerenciador de arquivos do seu site.';
$txt['attachments_no_write'] = 'O diretório foi criado, mas ele não tem permissão de escrita. Por favor, tente dar permissão de escrita usando um cliente FTP ou através do gerenciador de arquivos do seu site.';
$txt['attach_dir_duplicate_msg'] = 'Não foi possível adicionar. Este diretório já existe.';
$txt['attach_dir_exists_msg'] = 'Não foi possível mover. Um diretório já existe naquele caminho.';
$txt['attach_dir_base_dupe_msg'] = 'Não foi possível adicionar. Este diretório base já foi criado.';
$txt['attach_dir_base_no_create'] = 'Não foi possível criar. Por favor, verifique o caminho, ou crie este diretório usando um cliente FTP ou o gerenciador de arquivos do seu site.';
$txt['attach_dir_no_rename'] = 'Não foi possível mover ou renomear. Por favor, verifique se o caminho está correto ou que este diretório não contém sub-diretórios.';
$txt['attach_dir_no_delete'] = 'O diretório não está vazio e não pode ser excluído. Por favor, faça-o usando um cliente de FTP ou gerenciador de arquivos do seu site.';
$txt['attach_dir_no_remove'] = 'Ainda contém arquivos ou é um diretório base e não pode ser excluído.';
$txt['attach_dir_is_current'] = 'Não é possível remover enquanto ele estiver selecionado como o diretório atual.';
$txt['attach_dir_is_current_bd'] = 'Não é possível remover enquanto ele estiver selecionado como o diretório base atual.';
$txt['attach_dir_invalid'] = 'Diretório inválido';
$txt['attach_last_dir'] = 'Último diretório de anexos ativo';
$txt['attach_current_dir'] = 'Diretório de anexos atual';
$txt['attach_current'] = 'Atual';
$txt['attach_path_manage'] = 'Gerenciar caminhos de anexos';
$txt['attach_directories'] = 'Diretórios de anexo';
$txt['attach_paths'] = 'Caminhos dos Anexos';
$txt['attach_path'] = 'Caminho';
$txt['attach_current_size'] = 'Tamanho Atual (KB)';
$txt['attach_num_files'] = 'Arquivos';
$txt['attach_dir_status'] = 'Estado';
$txt['attach_add_path'] = 'Adicionar caminho';
$txt['attach_path_current_bad'] = 'Caminho de anexos atual inválido.';
$txt['attachmentDirFileLimit'] = 'Número máximo de arquivos por diretório';

$txt['attach_base_paths'] = 'Caminhos do diretório base';
$txt['attach_num_dirs'] = 'Diretórios';
$txt['max_image_width'] = 'Largura máxima de exibição de imagens de anexo postadas';
$txt['max_image_height'] = 'Altura máxima de exibição de imagens de anexo postadas';

$txt['automanage_attachments'] = 'Escolha o método para a gestão dos diretórios de anexos';
$txt['attachments_normal'] = '(Manual) Comportamento padrão do SMF';
$txt['attachments_auto_years'] = '(Auto) Subdividido por anos';
$txt['attachments_auto_months'] = '(Auto) Subdividido por anos e meses';
$txt['attachments_auto_days'] = '(Auto) Subdividido por anos, meses e dias';
$txt['attachments_auto_16'] = '(Auto) 16 diretórios aleatórios';
$txt['attachments_auto_16x16'] = '(Auto) 16 diretórios aleatórios com 16 sub-diretórios aleatórios';
$txt['attachments_auto_space'] = '(Auto) Quando o limite de espaço de qualquer diretório for atingido';

$txt['use_subdirectories_for_attachments'] = 'Criar novos diretórios dentro de um diretório base';
$txt['use_subdirectories_for_attachments_note'] = 'Caso contrário todos os novos diretórios serão criados dentro do diretório principal do fórum.';
$txt['basedirectory_for_attachments'] = 'Definir um diretório base para anexos';
$txt['basedirectory_for_attachments_current'] = 'Diretório base atual';
// argument(s): scripturl
$txt['basedirectory_for_attachments_warning'] = '<div class="smalltext">Observe que o diretório está errado.. <br>(<a href="%1$s?action=admin;area=manageattachments;sa=attachpaths">Tentar corrigir</a>)</div>';
// argument(s): scripturl
$txt['attach_current_dir_warning'] = '<div class="smalltext">Parece haver um problema neste diretório.<br>(<a href="%1$s?action=admin;area=manageattachments;sa=attachpaths">Tentar corrigir</a>)</div>';

$txt['attachment_transfer'] = 'Transferir anexos';
$txt['attachment_transfer_desc'] = 'Transferir arquivos entre diretórios.';
$txt['attachment_transfer_select'] = 'Selecionar diretório';
$txt['attachment_transfer_now'] = 'Transferir';
$txt['attachment_transfer_from'] = 'Transferir arquivos de';
$txt['attachment_transfer_auto'] = 'Automaticamente pelo espaço ou número de arquivos';
$txt['attachment_transfer_auto_select'] = 'Selecionar diretório base';
$txt['attachment_transfer_to'] = 'Ou para um diretório específico.';
$txt['attachment_transfer_empty'] = 'Esvaziar o diretório fonte';
$txt['attachment_transfer_no_base'] = 'Nenhum diretório base disponível.';
$txt['attachment_transfer_forum_root'] = 'Diretório raiz do fórum.';
$txt['attachment_transfer_no_room'] = 'Tamanho do diretório ou limite do número de arquivos alcançado.';
$txt['attachment_transfer_no_find'] = 'Não foram encontrados arquivos para transferir.';
$txt['attachments_transferred'] = '%1$d arquivos foram transferidos para %2$s';
$txt['attachments_not_transferred'] = '%1$d arquivos não foram transferidos.';
$txt['attachment_transfer_no_dir'] = 'O diretório de origem ou uma das opções do diretório alvo não foram selecionados.';
$txt['attachment_transfer_same_dir'] = 'Você não pode selecionar o mesmo diretório como origem e destino.';
$txt['attachment_transfer_progress'] = 'Por favor, aguarde. Transferência em progresso.';

$txt['mods_cat_avatars'] = 'Avatares';
$txt['avatar_directory'] = 'Diretório de avatares';
$txt['avatar_directory_wrong'] = 'O diretório de avatares não é válido. Isto causará diversos problemas com o fórum.';
$txt['avatar_url'] = 'URL dos avatares';
$txt['avatar_max_width_external'] = 'Largura máxima de avatares externos';
$txt['avatar_max_height_external'] = 'Altura máxima de avatares externos';
$txt['avatar_action_too_large'] = 'Se o avatar exceder o tamanho definido...';
$txt['option_refuse'] = 'Recusar';
$txt['option_css_resize'] = 'Redimensionar no navegador do usuário';
$txt['option_download_and_resize'] = 'Baixar e redimensionar no servidor';
$txt['avatar_max_width_upload'] = 'Largura máxima para avatar enviado';
$txt['avatar_max_height_upload'] = 'Altura máxima para avatar enviado';
$txt['avatar_resize_upload'] = 'Redimensionar avatares que excedam o limite';
$txt['avatar_resize_upload_note'] = '(é necessário o módulo GD ou ImageMagick com extensão IMagick ou MagickWand)';
$txt['avatar_download_png'] = 'Usar PNG para avatares redimensionados';
$txt['avatar_img_enc_warning'] = 'Nem o módulo GD nem as extensões IMagick ou MagickWand estão instaladas no momento. Algumas funções de avatar estão desativadas.';
$txt['avatar_external'] = 'Avatares externos';
$txt['avatar_upload'] = 'Avatares enviados';
$txt['avatar_server_stored'] = 'Avatares guardados no servidor';
$txt['avatar_server_stored_groups'] = 'Grupos permitidos de selecionar um avatar guardado no servidor';
$txt['avatar_upload_groups'] = 'Grupos permitidos a fazer envio de um avatar para o servidor';
$txt['avatar_external_url_groups'] = 'Grupos permitidos a usar um avatar de URL externa';
$txt['avatar_select_permission'] = 'Selecionar permissões para cada grupo';
$txt['avatar_download_external'] = 'Baixar avatar da URL fornecida';
$txt['option_specified_dir'] = 'Diretório especifico...';
$txt['custom_avatar_dir_wrong'] = 'O diretório de envio não é válido. Isso impedirá que avatares personalizados funcionem corretamente.';
$txt['custom_avatar_dir'] = 'Diretório de envio';
$txt['custom_avatar_dir_desc'] = 'Isto deve ser um diretório válido e com permissões de escrita, e deve ser diferente do diretório de avatares guardados no servidor.';
$txt['custom_avatar_url'] = 'URL de envio';
$txt['custom_avatar_check_empty'] = 'O diretório de avatares personalizados especificado pode estar vazio ou inválido. Verifique se essas configurações estão corretas.';
$txt['avatar_reencode'] = 'Recodificar avatares potencialmente perigosos.';
$txt['avatar_paranoid_warning'] = 'A verificação extensiva de segurança pode resultar num grande número de avatares sendo rejeitados.';
$txt['avatar_paranoid'] = 'Executar verificação extensiva de segurança nos avatares enviados';
$txt['gravatar_settings'] = 'Gravatars (Avatares Reconhecidos Globalmente)';
$txt['gravatarEnabled'] = 'Habilitar Gravatar para os usuários do fórum?';
$txt['gravatarOverride'] = 'Forçar o uso de Gravatars em vez de avatares comuns?';
$txt['gravatarAllowExtraEmail'] = 'Permitir armazenamento de um email extra para Gravatars?';
$txt['gravatarMaxRating'] = 'Classificação máxima permitida?';
$txt['gravatar_maxG'] = 'Classificação G (geralmente aceitável)';
$txt['gravatar_maxPG'] = 'Classificação PG (acompanhamento dos pais)';
$txt['gravatar_maxR'] = 'Classificação R (restrita)';
$txt['gravatar_maxX'] = 'Classificação X (explícita)';
$txt['gravatarDefault'] = 'Imagem padrão para mostrar quando um endereço de e-mail não tem um Gravatar correspondente';
$txt['gravatar_mm'] = 'Uma silhueta simples, desenhada, de uma pessoa';
$txt['gravatar_identicon'] = 'Um padrão geométrico baseado em um hash do email';
$txt['gravatar_monsterid'] = 'Um \'monstro\' gerado com diferentes cores, faces etc.';
$txt['gravatar_wavatar'] = 'Faces geradas com diferentes aparências e fundos';
$txt['gravatar_retro'] = 'Faces muito legais pixeladas como jogos de 8 bits';
$txt['gravatar_blank'] = 'Uma imagem PNG transparente';

$txt['repair_attachments'] = 'Manutenção dos Anexos';
$txt['repair_attachments_complete'] = 'Manutenção concluída';
$txt['repair_attachments_complete_desc'] = 'Todos os erros selecionados foram corrigidos';
$txt['repair_attachments_no_errors'] = 'Não foram encontrados erros';
$txt['repair_attachments_error_desc'] = 'Os seguintes erros foram encontrados. Selecione os erros que deseja reparar e clique em continuar.';
$txt['repair_attachments_continue'] = 'Continuar';
$txt['repair_attachments_cancel'] = 'Cancelar';
$txt['attach_repair_missing_thumbnail_parent'] = '%1$d imagens em miniatura não têm um anexo correspondente';
$txt['attach_repair_parent_missing_thumbnail'] = '%1$d anexos indicam que têm imagens em miniatura mas não têm';
$txt['attach_repair_file_missing_on_disk'] = '%1$d anexos/avatares têm uma entrada mas já não existem em disco';
$txt['attach_repair_file_wrong_size'] = '%1$d anexos/avatares têm indicação de tamanho errada';
$txt['attach_repair_file_size_of_zero'] = '%1$d anexos/avatares têm um tamanho zero em disco. (estes serão deletados)';
$txt['attach_repair_attachment_no_msg'] = '%1$d anexos já não têm nenhuma mensagem associada a eles';
$txt['attach_repair_avatar_no_member'] = '%1$d avatares já não têm nenhum usuário associado a eles';
$txt['attach_repair_wrong_folder'] = '%1$d anexos estão na pasta errada';
$txt['attach_repair_files_without_attachment'] = '%1$d arquivos não tem uma entrada correspondente no banco de dados. (estes serão deletados)';

$txt['news_title'] = 'Notícias e boletins informativos';
$txt['news_settings_desc'] = 'Aqui você pode alterar as configurações e permissões relacionadas com as notícias e boletins informativos.';
$txt['news_mailing_desc'] = 'A partir deste menu você pode enviar mensagens para todos os usuários que estão registrados. Você pode alterar a lista de distribuição, ou enviar mensagens para todos. Útil para atualizações ou notícias importantes.';
$txt['news_error_no_news'] = 'Nada escrito';
$txt['groups_edit_news'] = 'Grupos autorizados a alterar as notícias';
$txt['groups_send_mail'] = 'Grupos autorizados a enviar boletins informativos do fórum';
$txt['xmlnews_enable'] = 'Ativar notícias XML/RSS';
$txt['xmlnews_maxlen'] = 'Tamanho máximo das mensagens';
$txt['xmlnews_maxlen_note'] = '(0 para desabilitar, má idéia)';
$txt['xmlnews_attachments'] = 'Inclua anexos em feeds XML/RSS';
$txt['xmlnews_attachments_note'] = 'Nota: Alguns formatos de feed incluirão apenas um anexo por postagem.';
$txt['editnews_clickadd'] = 'Adicionar outro item';
$txt['editnews_remove_selected'] = 'Remover os selecionados';
$txt['editnews_remove_confirm'] = 'Tem certeza que quer apagar as notícias selecionadas?';
$txt['censor_clickadd'] = 'Adicionar outra palavra';

$txt['layout_controls'] = 'Fórum';
$txt['logs'] = 'Logs';
$txt['generate_reports'] = 'Relatórios';

$txt['update_available'] = 'Atualização disponível!';
$txt['update_message'] = 'Você está usando uma versão desatualizada do SMF, que contém alguns bugs que já foram corrigidos.
	É recomendado <a href="#" id="update-link" class="bbc_link strong">atualizar seu fórum</a> para a versão mais recente o mais rápido possível. Leva apenas um minuto!';

$txt['manageposts'] = 'Tópicos e Postagens';
$txt['manageposts_title'] = 'Gerenciar tópicos e postagens';
$txt['manageposts_description'] = 'Aqui você pode gerenciar todas as opções relacionados com tópicos e postagens.';

$txt['manageposts_seconds'] = 'segundos';
$txt['manageposts_minutes'] = 'minutos';
$txt['manageposts_characters'] = 'caracteres';
$txt['manageposts_days'] = 'dias';
$txt['manageposts_posts'] = 'publicações';
$txt['manageposts_topics'] = 'tópicos';

$txt['manageposts_settings'] = 'Configurações de Postagens';
$txt['manageposts_settings_description'] = 'Aqui você pode administrar tudo que esteja relacionado com as postagens.';

$txt['manageposts_bbc_settings'] = 'Código Bulletin Board';
$txt['manageposts_bbc_settings_description'] = 'O Código Bulletin Board (BBC) pode ser usado para formatar as mensagens do fórum. Por exemplo, para destacar a palavra \'casa\', você pode escrever [b]casa[/b]. Todas as tags BBC são separadas por colchetes (\'[\' e \']\').';
$txt['manageposts_bbc_settings_title'] = 'Configurações do BBC';

$txt['manageposts_topic_settings'] = 'Configurações dos tópicos';
$txt['manageposts_topic_settings_description'] = 'Aqui você pode mudar todas as configurações relacionadas a tópicos.';

$txt['managedrafts_settings'] = 'Configurações dos Rascunhos';
$txt['managedrafts_settings_description'] = 'Aqui você pode configurar todas as opções que envolvem rascunhos.';
$txt['manage_drafts'] = 'Rascunhos';

$txt['removeNestedQuotes'] = 'Remover citações aninhadas ao citar';
$txt['disable_wysiwyg'] = 'Desabilitar o editor WYSIWYG';
$txt['max_messageLength'] = 'Tamanho máximo permitido em postagens';
$txt['max_messageLength_zero'] = '0 para não ter limite.';
$txt['convert_to_mediumtext'] = 'Seu banco de dados não está configurado para aceitar mensagens com mais de 65535 caracteres. Por favor, use a página <a href="%1$s">manutenção do banco de dados</a> para converter o banco de dados e, em seguida, volte para aumentar o tamanho máximo permitido da mensagem.';
$txt['topicSummaryPosts'] = 'Postagens para mostrar no resumo do tópico';
$txt['spamWaitTime'] = 'Tempo necessário entre postagens do mesmo IP';
$txt['edit_wait_time'] = 'Tempo de cortesia para editar postagens';
$txt['edit_disable_time'] = 'Tempo máximo para permitir edição após postar';
$txt['preview_characters'] = 'Tamanho máximo da prévia da última/primeira postagem';
$txt['preview_characters_units'] = 'caracteres';
$txt['quote_expand'] = 'Altura mínima de citação para adicionar um link de expansão em citações grandes';
$txt['quote_expand_pixels_units'] = 'pixels';
$txt['message_index_preview_first'] = 'Quando utilizar pré-visualizações de mensagens, exibir o texto da primeira postagem';
$txt['message_index_preview_first_desc'] = 'Deixe desmarcado para mostrar o texto da última postagem';
$txt['show_user_images'] = 'Exibir avatar dos usuários na visualização de mensagens';
$txt['show_blurb'] = 'Exibir texto pessoal na visualização de mensagens';
$txt['hide_post_group'] = 'Esconder o título do grupo das postagens para membros agrupados';
$txt['hide_post_group_desc'] = 'Ativar isso não exibirá o título do grupo de postagem de um membro na visualização da mensagem se ele estiver atribuído a um grupo não baseado em postagem.';
$txt['subject_toggle'] = 'Exibir assuntos nos tópicos';
$txt['show_profile_buttons'] = 'Exibir botão de ver perfil abaixo da mensagem';
$txt['show_modify'] = 'Exibir data da última modificação em postagens editadas';

$txt['enableBBC'] = 'Ativar código bulletin board (BBC)';
$txt['enablePostHTML'] = 'Ativar HTML <em>básico</em> nas mensagens';
$txt['autoLinkUrls'] = 'Criar um link automaticamente para as URLs colocadas nas mensagens';
$txt['disabledBBC'] = 'Tags BBC habilitadas';
$txt['legacyBBC'] = 'Tags BBC legadas';
$txt['bbcTagsToUse'] = 'Ativar BBC tags';
$txt['enabled_bbc_select'] = 'Selecione as tags que podem ser usadas';
$txt['enabled_bbc_select_all'] = 'Selecionar todas as tags';
$txt['groups_can_use'] = 'Grupos de membros com permissão para usar %1$s';

$txt['enableParticipation'] = 'Ativar ícones de participação';
$txt['oldTopicDays'] = 'Tempo antes de avisar que o tópico é antigo ao responder';
$txt['defaultMaxTopics'] = 'Número de tópicos por página no índice de tópicos';
$txt['defaultMaxMessages'] = 'Número de postagens por página em cada tópico';
$txt['disable_print_topic'] = 'Desativar a função de imprimir o tópico';
$txt['enableAllMessages'] = 'Tamanho máximo do tópico para mostrar &quot;todas&quot; postagens';
$txt['enableAllMessages_zero'] = '0 para nunca mostrar &quot;todas&quot;';
$txt['disableCustomPerPage'] = 'Desativar contagem de tópicos/mensagens definidas pelo usuário por página';
$txt['enablePreviousNext'] = 'Habilitar links de anterior/seguinte nos tópicos';

$txt['not_done_title'] = 'Não acabou ainda';
$txt['not_done_reason'] = 'Para evitar sobrecarga do servidor, o processo foi parado temporariamente. Ele deverá continuar automaticamente em poucos segundos. Caso não continue, clique em continuar abaixo.';
$txt['not_done_continue'] = 'Continuar';

$txt['general_settings'] = 'Geral';
$txt['database_settings'] = 'Banco de dados';
$txt['cookies_sessions_settings'] = 'Cookies e Sessões';
$txt['security_settings'] = 'Segurança';
$txt['caching_settings'] = 'Cache';
$txt['export_settings'] = 'Exportar dados';
$txt['load_balancing_settings'] = 'Balanceamento de carga';
$txt['phpinfo_settings'] = 'Informações do PHP';
$txt['phpinfo_localsettings'] = 'Configurações locais';
$txt['phpinfo_defaultsettings'] = 'Configurações padrão';
$txt['phpinfo_itemsettings'] = 'Configurações';

$txt['language_configuration'] = 'Idiomas';
$txt['language_description'] = 'Esta seção permite que você edite os idiomas instalados no seu fórum ou baixe novos do site Simple Machines. Você pode também editar configurações relacionadas ao idioma aqui.';
$txt['language_edit'] = 'Editar Idiomas';
$txt['language_add'] = 'Adicionar Idioma';
$txt['language_settings'] = 'Configurações';
$txt['could_not_language_backup'] = 'Não foi possível efetuar um backup antes de remover este pacote de idiomas. Nenhuma alteração foi feita. Altere as permissões de forma que o diretório Pacotes/backup possa ser escrito ou desabilite os backups (não recomendado)';

$txt['advanced'] = 'Avançado';
$txt['simple'] = 'Simples';

$txt['admin_news_newsletter_queue_done'] = 'O boletim informativo foi adicionado à fila de e-mail com sucesso.';
$txt['admin_news_select_recipients'] = 'Selecione quem deve receber uma cópia do boletim informativo';
$txt['admin_news_select_group'] = 'Grupos de usuários';
$txt['admin_news_select_group_desc'] = 'Selecione os grupos que receberão este boletim informativo.';
$txt['admin_news_select_members'] = 'Usuários';
$txt['admin_news_select_members_desc'] = 'Membros adicionais para receber boletins informativos.';
$txt['admin_news_select_excluded_members'] = 'Membros excluídos';
$txt['admin_news_select_excluded_members_desc'] = 'Membros que não devem receber o boletim informativo.';
$txt['admin_news_select_excluded_groups'] = 'Grupos excluídos';
$txt['admin_news_select_excluded_groups_desc'] = 'Selecione os grupos que não devem receber o boletim informativo.';
$txt['admin_news_select_email'] = 'Endereços de email';
$txt['admin_news_select_email_desc'] = 'Uma lista separada por ponto e vírgula de endereços de e-mail aos quais deve ser enviado um boletim informativo (ou seja, endereço1; endereço2). Isso é adicional aos grupos listados acima.<br><span class="alert">Nota: você deve lidar manualmente com todas as solicitações de cancelamento de assinatura referentes a boletins informativos enviados a esses endereços de e-mail.</span>';
$txt['admin_news_select_override_notify'] = 'Sobrescrever configurações de notificação';
// Use entities in below.
$txt['admin_news_cannot_pm_emails_js'] = 'Você não pode enviar uma mensagem pessoal para um endereço de email. Se você continuar, todos os endereços de email serão ignorados.\n\n Você tem certeza que deseja fazer isso?';

$txt['mailqueue_browse'] = 'Fila de emails';
$txt['mailqueue_settings'] = 'Configurações';
$txt['mailqueue_test'] = 'Enviar teste';

$txt['admin_search'] = 'Busca rápida';
$txt['admin_search_type_internal'] = 'Tarefa/Configuração';
$txt['admin_search_type_member'] = 'Membro';
$txt['admin_search_type_online'] = 'Manual Online';
$txt['admin_search_go'] = 'Ir';
$txt['admin_search_results'] = 'Resultados da busca';
$txt['admin_search_results_desc'] = 'Resultados da busca: &quot;%1$s&quot;';
$txt['admin_search_results_again'] = 'Procurar novamente';
$txt['admin_search_results_none'] = 'Nenhum resultado encontrado.';

$txt['admin_search_section_sections'] = 'Seção';
$txt['admin_search_section_settings'] = 'Configuração';

$txt['mods_cat_features'] = 'Geral';
$txt['antispam_title'] = 'Anti-spam';
$txt['mods_cat_modifications_misc'] = 'Diversos';
$txt['mods_cat_layout'] = 'Layout';
$txt['moderation_settings_short'] = 'Moderação';
$txt['signature_settings_short'] = 'Assinaturas';
$txt['custom_profile_shorttitle'] = 'Campos de perfil';
$txt['pruning_title'] = 'Limpeza dos logs';
$txt['pruning_desc'] = 'As opções a seguir são úteis para evitar que seus logs fiquem muito grandes, já que a maior parte das entradas mais antigas não são muito úteis.';
$txt['log_settings'] = 'Configurações de logs';

$txt['boards_edit'] = 'Modificar Seções';
$txt['mboards_new_cat'] = 'Criar nova categoria';
$txt['manage_holidays'] = 'Gerenciar feriados';
$txt['calendar_settings'] = 'Configurações do calendário';
$txt['search_weights'] = 'Pesos';
$txt['search_method'] = 'Método de busca';

$txt['smiley_sets'] = 'Pacotes de smileys';
$txt['smileys_add'] = 'Adicionar smiley';
$txt['smileys_edit'] = 'Editar smileys';
$txt['smileys_set_order'] = 'Definir a ordem dos smileys';
$txt['icons_edit_message_icons'] = 'Ícones de mensagem';

$txt['membergroups_new_group'] = 'Adicionar Grupo';
$txt['membergroups_edit_groups'] = 'Editar Grupos';
$txt['permissions_groups'] = 'Permissões Gerais';
$txt['permissions_boards'] = 'Permissões por seção';
$txt['permissions_profiles'] = 'Editar Perfis';
$txt['permissions_post_moderation'] = 'Moderação de postagens';

$txt['browse_packages'] = 'Procurar pacotes';
$txt['download_packages'] = 'Adicionar pacotes';
$txt['installed_packages'] = 'Pacotes instalados';
$txt['package_file_perms'] = 'Permissões de arquivos';
$txt['package_settings'] = 'Opções';
$txt['themeadmin_admin_title'] = 'Gerenciar e Instalar';
$txt['themeadmin_list_title'] = 'Configurações de Tema';
$txt['themeadmin_reset_title'] = 'Opções dos Usuários';
$txt['themeadmin_edit_title'] = 'Modificar Temas';
$txt['admin_browse_register_new'] = 'Cadastrar novo usuário';

$txt['search_engines'] = 'Motores de Busca';
$txt['spiders'] = 'Mecanismos de pesquisa';
$txt['spider_logs'] = 'Log dos mecanismos de pesquisa';
$txt['spider_stats'] = 'Estatísticas';

$txt['paid_subscriptions'] = 'Assinaturas pagas';
$txt['paid_subs_view'] = 'Ver assinaturas';

$txt['hooks_title_list'] = 'Hooks de integração';
$txt['hooks_field_hook_name'] = 'Nome do hook';
$txt['hooks_field_function_name'] = 'Nome da função';
$txt['hooks_field_function_method'] = 'A função é um método e sua classe está instanciada';
$txt['hooks_field_function'] = 'Função';
$txt['hooks_field_included_file'] = 'Arquivo incluído';
$txt['hooks_field_file_name'] = 'Nome do arquivo';
$txt['hooks_field_hook_exists'] = 'SItuação';
$txt['hooks_active'] = 'Existe';
$txt['hooks_disabled'] = 'Desativado';
$txt['hooks_missing'] = 'Não encontrado';
$txt['hooks_temp'] = 'Temporário';
$txt['hooks_no_hooks'] = 'Atualmente não existem hooks no sistema.';
$txt['hooks_button_remove'] = 'Remover';
$txt['hooks_disable_instructions'] = 'Clique no ícone de estado para ativar ou desativar o hook';
$txt['hooks_disable_legend'] = 'Legenda';
$txt['hooks_disable_legend_exists'] = 'o hook existe e está ativo';
$txt['hooks_disable_legend_disabled'] = 'o hook existe, mas foi desativado';
$txt['hooks_disable_legend_missing'] = 'o hook não foi encontrado';
$txt['hooks_disable_legend_temp'] = 'o hook é temporário';
$txt['hooks_disable_legend_temp_missing'] = 'hook temporário não encontrado';
$txt['hooks_reset_filter'] = 'Sem filtro';

$txt['board_perms_allow'] = 'Permitir';
$txt['board_perms_ignore'] = 'Ignorar';
$txt['board_perms_deny'] = 'Negar';
$txt['all_boards_in_cat'] = 'Todas as seções nesta categoria';

$txt['likes_like'] = 'Grupos com permissão de curtir postagens';

$txt['mention'] = 'Grupos com permissão de mencionar usuários';

$txt['notifications'] = 'Notificações';
$txt['notify_settings'] = 'Configurações de Notificação';
$txt['notifications_desc'] = 'Esta página lhe permite configurar as opções padrão de notificação aos usuários';
 // The GDPR page of the EU exists in several languages; change the language code at the end of the url
$txt['notify_announcements_desc'] = 'Ativar esta opção padrão viola as regras do <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_en" target="_blank" rel ="noopener" class="bbc_link">GDPR</a> e leis de privacidade e anti-spam de muitos outros países.';

$txt['enable_sm_stats'] = 'Permitir Coleta de Estatísticas';

?>