<?php
// Version: 2.1.5; index

global $forum_copyright, $webmaster_email, $scripturl, $context, $boardurl;

// Native name, please use full HTML entities to write your language's name.
$txt['native_name'] = 'English';

// Locale (strftime, basename). For more information see:
//   - https://php.net/function.setlocale
$txt['lang_locale'] = 'en_US';
$txt['lang_dictionary'] = 'en';
//https://developers.google.com/recaptcha/docs/language
$txt['lang_recaptcha'] = 'en';

// Ensure you remember to use uppercase for character set strings.
$txt['lang_character_set'] = 'UTF-8';
// Character set right to left?  0 = ltr; 1 = rtl
$txt['lang_rtl'] = '0';
// Number format.
$txt['number_format'] = '1,234.00';

$txt['days_title'] = '日';
$txt['days'] = array('星期日', '星期一', '星期二', '星期三', '星期四', '星期五', '星期六');
$txt['days_short'] = array('週日', '週一', '週二', '週三', '週四', '週五', '週六');
// Months must start with 1 => 'January'. (or translated, of course.)
$txt['months_title'] = '月';
$txt['months'] = array(1 => '一月', 2 => '二月', 3 => '三月', 4 => '四月', 5 => '五月', 6 => '六月', 7 => '七月', 8 => '八月', 9 => '九月', 10 => '十月', 11 => '十一月', 12 => '十二月');
$txt['months_titles'] = array(1 => '一月', 2 => '二月', 3 => '三月', 4 => '四月', 5 => '五月', 6 => '六月', 7 => '七月', 8 => '八月', 9 => '九月', 10 => '十月', 11 => '十一月', 12 => '十二月');
$txt['months_short'] = array(1 => '三月', 2 => '二月', 3 => 'Mar', 4 => '四月', 5 => '五月', 6 => '六月', 7 => '七月', 8 => '八月', 9 => '九月', 10 => '十月', 11 => '十一月', 12 => '十二月');
$txt['prev_month'] = 'Previous month';
$txt['next_month'] = 'Next month';
$txt['start'] = 'Start';
$txt['end'] = 'End';
$txt['starts'] = 'Starts';
$txt['ends'] = 'Ends';
$txt['none'] = '停用';

$txt['minutes_label'] = 'Minutes';
$txt['hours_label'] = 'Hours';
$txt['years_title'] = '年';

$txt['time_am'] = 'am';
$txt['time_pm'] = 'pm';

// Short form of minutes
$txt['minutes_short'] = 'mins';
// Short form of hour
$txt['hour_short'] = 'hr';
// Short form of hours
$txt['hours_short'] = 'hrs';
// Decimal sign
$txt['decimal_sign'] = '.';

$txt['admin'] = '管理';
$txt['moderate'] = '板務';

$txt['save'] = '儲存';
$txt['reset'] = 'Reset';
$txt['upload'] = 'Upload';
$txt['upload_all'] = 'Upload all';
$txt['processing'] = 'Processing...';

$txt['modify'] = '修改';
$txt['forum_index'] = '%1$s - 論壇首頁';
$txt['members'] = '會員';
$txt['board_name'] = '看板名稱';
$txt['posts'] = '文章數';

$txt['member_postcount'] = '文章';
$txt['no_subject'] = '(無標題)';
$txt['view_profile'] = '檢視個人資料';
$txt['guest_title'] = '訪客';
$txt['author'] = '作者';
$txt['on'] = '於';
$txt['remove'] = '移除';
$txt['start_new_topic'] = '發表文章';

$txt['login'] = 'Log in';
// Use numeric entities in the below string.
$txt['username'] = '帳號';
$txt['password'] = '密碼';

$txt['username_no_exist'] = '這個帳號不存在。';
$txt['no_user_with_email'] = '這封 Email 沒有對應的會員';

$txt['board_moderator'] = '板主';
$txt['remove_topic'] = '刪除主題';
$txt['topics'] = '主題';
$txt['modify_msg'] = '修改訊息';
$txt['name'] = '名稱';
$txt['email'] = 'Email';
$txt['user_email_address'] = 'Email';
$txt['subject'] = '標題';
$txt['message'] = '訊息';
$txt['redirects'] = '次點擊';
$txt['quick_modify'] = '即時修改';
$txt['quick_modify_message'] = 'You have successfully modified this message.';
$txt['reason_for_edit'] = 'Reason for editing';

$txt['choose_pass'] = 'Choose Password';
$txt['verify_pass'] = 'Verify Password';
$txt['notify_announcements'] = 'Allow the administrators to send me important news by email';

$txt['position'] = '群組';

// argument(s): username
$txt['view_profile_of_username'] = 'View the profile of %1$s';
$txt['total'] = '總共';
$txt['website'] = '個人網站';
$txt['register'] = 'Sign up';
$txt['warning_status'] = '警告狀態';
$txt['user_warn_watch'] = '會員在觀察名單';
$txt['user_warn_moderate'] = '會員的文章加入審核佇列';
$txt['user_warn_mute'] = '會員禁止發表文章';
$txt['warn_watch'] = '觀察';
$txt['warn_moderate'] = '監督';
$txt['warn_mute'] = '禁言';

$txt['message_index'] = '看板首頁';
$txt['news'] = '最新消息';
$txt['home'] = '首頁';
$txt['page'] = 'Page';
$txt['prev'] = 'Previous page';
$txt['next'] = 'Next page';

$txt['lock_unlock'] = '封鎖/解鎖主題';
$txt['post'] = '發表文章';
$txt['error_occured'] = '發生錯誤！';
$txt['at'] = '在';
$txt['by'] = '作者';
$txt['logout'] = 'Log out';
$txt['started_by'] = '作者';
$txt['topic_started_by'] = 'Started by <strong>%1$s</strong> in <em>%2$s</em>';
$txt['replies'] = '回覆';
$txt['last_post'] = '最新文章';
$txt['first_post'] = 'First post';
$txt['last_poster'] = 'Last post by';
$txt['last_post_message'] = '<strong>Last post: </strong>%3$s <span class="postby">%2$s by %1$s</span>';
$txt['last_post_topic'] = '%1$s<br>by %2$s';
$txt['post_by_member'] = '<strong>%1$s</strong> by <strong>%2$s</strong><br>';
$txt['boardindex_total_posts'] = '%1$s Posts in %2$s Topics by %3$s Members';
$txt['show'] = 'Show';
$txt['hide'] = 'Hide';

$txt['admin_login'] = '管理員登入';
// Use numeric entities in the below string.
$txt['topic'] = '主題';
$txt['help'] = '說明';
$txt['terms_and_rules'] = 'Terms and Rules';
$txt['watch_board'] = 'Watch this Board';
$txt['unwatch_board'] = 'Stop watching Board';
$txt['watch_topic'] = 'Watch this Topic';
$txt['unwatch_topic'] = 'Stop watching Topic';
$txt['watching_topic'] = 'Topic you are watching';
$txt['watching_this_topic'] = 'You are watching this topic, and will receive notifications about it.';
$txt['notify'] = '訂閱通知';
$txt['unnotify'] = '取消訂閱';

// Use numeric entities in the below string.
// argument(s): forum name
$txt['regards_team'] = 'Regards,
The %1$s Team.';

$txt['notify_replies'] = '訂閱';
$txt['move_topic'] = '移動文章';
$txt['move_to'] = '移動到';
$txt['pages'] = '頁';
$txt['users_active'] = '%1$d 分鐘內上線的會員';
$txt['personal_messages'] = '簡訊';
$txt['reply_quote'] = '轉寄';
$txt['reply'] = '回覆';
$txt['reply_noun'] = '回覆';
$txt['reply_number'] = 'Reply #%1$s%2$s';
$txt['approve'] = '核淮';
$txt['unapprove'] = 'Unapprove';
$txt['approve_all'] = '核淮全部';
$txt['issue_warning'] = 'Issue Warning';
$txt['awaiting_approval'] = '等待審核';
$txt['attach_awaiting_approve'] = '附件等待審核';
$txt['post_awaiting_approval'] = '注意: 這篇文章正在等待板主審核。';
$txt['there_are_unapproved_topics'] = '這個看板有 %1$s 主題和 %2$s 文章等待審核。<a href="%3$s">瀏覽這些文章</a>.';
$txt['send_message'] = 'Send message';

$txt['msg_alert_no_messages'] = 'you don\'t have any messages';
$txt['msg_alert_one_message'] = 'you have <a href="%1$s">1 message</a>';
$txt['msg_alert_many_message'] = 'you have <a href="%1$s">%2$d messages</a>';
$txt['msg_alert_one_new'] = '1 is new';
$txt['msg_alert_many_new'] = '%1$d are new';
$txt['new_alert'] = 'New alert';
$txt['remove_message'] = '刪除文章';
$txt['remove_message_question'] = '刪除文章?';

$txt['topic_alert_none'] = 'No messages...';
$txt['pm_alert_none'] = 'No messages...';
$txt['no_messages'] = 'No messages';

$txt['online_users'] = '線上人數';
$txt['jump_to'] = '前往';
$txt['go'] = '繼續！';
$txt['are_sure_remove_topic'] = '您確定要移除這篇主題嗎？';
$txt['yes'] = '確定';
$txt['no'] = '取消';

$txt['search_end_results'] = '最終結果';
$txt['search_on'] = '於';

$txt['search'] = '搜尋';
$txt['all'] = '顯示全部';
$txt['search_entireforum'] = 'Entire forum';
$txt['search_thisboard'] = 'This board';
$txt['search_thistopic'] = 'This topic';
$txt['search_members'] = '會員';

$txt['back'] = '回上一頁';
$txt['continue'] = '繼續';
$txt['password_reminder'] = '忘記密碼';
$txt['topic_started'] = '主題作者是';
$txt['title'] = '標題';
$txt['post_by'] = '作者';
$txt['memberlist_searchable'] = '瀏覽所有註冊會員。';
$txt['welcome_newest_member'] = 'Please welcome %1$s, our newest member.';
$txt['admin_center'] = '管理中心';
$txt['last_edit_by'] = '<span class="lastedit">Last Edit</span>: %1$s by %2$s';
$txt['last_edit_reason'] = '<span id="reason" class="lastedit">Reason</span>: %1$s';
$txt['notify_deactivate'] = '您要取消訂閱這篇主題嗎？';
$txt['modified_time'] = 'Last edited';
$txt['modified_by'] = 'Edited by';

$txt['recent_posts'] = '最新文章';

$txt['location'] = '位置';
$txt['location_desc'] = 'Geographic location.';
$txt['gender'] = '性別';
$txt['gender_0'] = 'None';
$txt['gender_1'] = 'Male';
$txt['gender_2'] = 'Female';
$txt['gender_desc'] = 'Your gender.';
$txt['icq'] = 'ICQ';
$txt['icq_desc'] = 'This is your ICQ number.';
$txt['skype'] = 'Skype';
$txt['skype_desc'] = 'Your Skype username';
$txt['personal_text'] = 'Personal text';
$txt['date_registered'] = '註冊日期';

$txt['recent_view'] = '檢視最新文章。';
$txt['recent_updated'] = '是最近更新的主題';
$txt['is_recent_updated'] = '%1$s is the most recently updated topic';

$txt['male'] = '男';
$txt['female'] = '女';

$txt['error_invalid_characters_username'] = '帳號名稱內含禁用的字元。';

// argument(s): forum name, login URL, login JavaScript snippet
$txt['welcome_guest'] = 'Welcome to <strong>%1$s</strong>. Please <a href="%2$s" onclick="%3$s">log in</a>.';

// argument(s): forum name, login URL, login JavaScript snippet, signup URL
$txt['welcome_guest_register'] = 'Welcome to <strong>%1$s</strong>. Please <a href="%2$s" onclick="%3$s">log in</a> or <a href="%4$s">sign up</a>.';

// argument(s): $scripturl
$txt['welcome_guest_activate'] = '<a href="%1$s?action=activate">Did you miss your activation email?</a>';

// argument(s): $scripturl
$txt['register_prompt'] = 'Don\'t have an account? <a href="%1$s?action=signup">Sign up</a>.';

// argument(s): forum name
$txt['welcome_to_forum'] = 'Welcome to <strong>%1$s</strong>.';

// @todo the following to sprintf
$txt['hello_member'] = '哈囉,';
// Use numeric entities in the below string.
$txt['hello_guest'] = '歡迎光臨,';
$txt['select_destination'] = '請選擇目的地';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['posted_by'] = '作者';

$txt['icon_smiley'] = '微笑';
$txt['icon_angry'] = '生氣';
$txt['icon_cheesy'] = '呵呵';
$txt['icon_laugh'] = '哈哈';
$txt['icon_sad'] = '難過';
$txt['icon_wink'] = '眨眼';
$txt['icon_grin'] = '賊賊地笑';
$txt['icon_shocked'] = '驚訝';
$txt['icon_cool'] = '酷';
$txt['icon_huh'] = '什麼?';
$txt['icon_rolleyes'] = '轉眼珠子';
$txt['icon_tongue'] = '吐舌';
$txt['icon_embarrassed'] = '害羞';
$txt['icon_lips'] = '不能說';
$txt['icon_undecided'] = '苦惱';
$txt['icon_kiss'] = '飛吻';
$txt['icon_cry'] = '哭泣';

$txt['moderator'] = '板主';
$txt['moderators'] = '板主';

$txt['views'] = '閱讀';
$txt['new'] = '新';

$txt['view_all_members'] = '會員名單';
$txt['view'] = '檢視';

$txt['viewing_members'] = '檢視會員 %1$s - %2$s';
$txt['of_total_members'] = '會員總數 %1$s ';

$txt['forgot_your_password'] = '您密碼忘記了嗎？';

$txt['date'] = '日期';
// Use numeric entities in the below string.
$txt['from'] = '寄件者';
$txt['check_new_messages'] = '檢查新簡訊';
$txt['to'] = '收件者';

$txt['board_topics'] = '主題';
$txt['members_title'] = '會員';
$txt['members_list'] = '會員名單';
$txt['new_posts'] = '新文章';
$txt['old_posts'] = '沒有新文章';
$txt['redirect_board'] = '轉址看板';

$txt['sendtopic_send'] = '送出';
$txt['report_sent'] = '您的回報已經成功傳送了。';
$txt['post_becomes_unapproved'] = 'Your message was not approved because it was posted in an unapproved topic. Once the topic is approved your message will be approved too.';

$txt['time_offset'] = '時區差值';
$txt['or'] = '或';

$txt['no_matches'] = '很抱歉, 沒有找到任何相符的資料';

$txt['notification'] = '通知';

$txt['your_ban'] = '抱歉, %1$s。本論壇禁止您進入！';
$txt['your_ban_expires'] = '黑名單的過期時間: %1$s。';
$txt['your_ban_expires_never'] = '您在永久黑名單中。';
$txt['ban_continue_browse'] = '您將以訪客身份瀏覽論壇。';

$txt['mark_as_read'] = '標示所有文章為已讀';

$txt['locked_topic'] = '封鎖主題';
$txt['normal_topic'] = '一般主題';
$txt['participation_caption'] = '您曾經參與的主題';
$txt['moved_topic'] = 'Moved Topic';

$txt['go_caps'] = '繼續';

$txt['print'] = '列印';
$txt['profile'] = '個人資料';
$txt['topic_summary'] = '文章總覽';
$txt['not_applicable'] = 'N/A';
$txt['name_in_use'] = '這個會員名稱已經有人使用了。';

$txt['total_members'] = '會員總數';
$txt['total_posts'] = '文章總數';
$txt['total_topics'] = '主題總數';

$txt['time_logged_in'] = 'Time to stay logged in';

$txt['preview'] = '預覽';
$txt['always_logged_in'] = '永遠';

$txt['logged'] = '記錄';
$txt['show_ip'] = 'Show IP address';
// Use numeric entities in the below string.
$txt['ip'] = 'IP';
$txt['url'] = '網址';
$txt['www'] = '個人網站/部落格';

$txt['hours'] = '小時';
$txt['minutes'] = '分';
$txt['seconds'] = '秒';

// Used upper case in Paid subscriptions management
$txt['hour'] = 'Hour';
$txt['days_word'] = '日';

$txt['search_for'] = '搜尋:';
$txt['search_match'] = 'Match';

$txt['forum_in_maintenance'] = 'Your forum is in Maintenance Mode. Only administrators can currently log in.';
$txt['maintenance_page'] = 'You can turn off Maintenance Mode from the <a href="%1$s">Server Settings</a> area.';

$txt['read_one_time'] = 'Read 1 time';
$txt['read_many_times'] = 'Read %1$d times';

$txt['forum_stats'] = '論壇統計資料';
$txt['latest_member'] = '最新會員';
$txt['total_cats'] = '類別總數';
$txt['latest_post'] = '最新文章';

$txt['total_boards'] = '看板總數';

$txt['print_page'] = '列印本頁';
$txt['print_page_text'] = 'Text only';
$txt['print_page_images'] = 'Text with Images';

$txt['valid_email'] = '必須是有效的 Email。';

$txt['geek'] = '我是天才！';
$txt['info_center_title'] = '%1$s - 資訊中心';

$txt['watch'] = 'Watch';
$txt['unwatch'] = 'Stop watching';

$txt['check_all'] = 'Select all';

// Use numeric entities in the below string.
$txt['database_error'] = '資料庫錯誤';
$txt['try_again'] = '請重新操作一次。如果這個問題持續發生, 請聯絡系統管理員。';
$txt['file'] = '檔案';
$txt['line'] = '行';
// Use numeric entities in the below string.
$txt['tried_to_repair'] = 'SMF 論壇系統發現資料庫有錯誤, 而且已經修復成功。如果問題還是持續存在, 請聯絡您的主機系統管理員。';
$txt['database_error_versions'] = '<strong>注意:</strong> 您的資料庫 <em>可能</em> 需要更新。您的論壇檔案版本是 %1$s, 而您的資料庫版本是 %2$s. 如果您執行最新版的 upgrade.php, 上面的問題可能會消失。';
$txt['template_parse_error'] = '佈景樣版有問題！';
$txt['template_parse_error_message'] = '論壇的佈景樣版發生錯誤, 這可能是暫時性的, 請稍後再進入論壇。如果問題還是持續存在, 請通知管理員。<br /><br />您也可以 <a href="javascript:location.reload();">重新整理本頁</a>。';
// argument(s): filename, $boardurl, $scripturl
$txt['template_parse_error_details'] = 'There was a problem loading the <pre><strong>%1$s</strong></pre> template or language file. Please check the syntax and try again - remember, single quotes (<pre>\'</pre>) often have to be escaped with a slash (<pre>\\</pre>). To see more specific error information from PHP, try <a href="%2$s%1$s">accessing the file directly</a>.<br><br>You may want to try to <a href="javascript:location.reload();">refresh this page</a> or <a href="%3$s?theme=1">use the default theme</a>.';
$txt['template_parse_errmsg'] = 'Unfortunately more information is not available at this time as to exactly what is wrong.';

$txt['today'] = '<strong>今天</strong>';
$txt['yesterday'] = '<strong>昨天</strong>';
$txt['new_poll'] = '舉辦投票';
$txt['poll_question'] = '題目';
$txt['poll_vote'] = '投票';
$txt['poll_total_voters'] = '投票人數';
$txt['poll_results'] = '檢視結果';
$txt['poll_lock'] = '封鎖投票';
$txt['poll_unlock'] = '解鎖投票';
$txt['poll_edit'] = '編輯投票';
$txt['poll'] = '投票';
$txt['one_hour'] = '一小時';
$txt['one_day'] = '一天';
$txt['one_week'] = '一週';
$txt['two_weeks'] = '2 Weeks';
$txt['one_month'] = '一個月';
$txt['two_months'] = '2 Months';
$txt['forever'] = '永遠';
$txt['moved'] = '移動';
$txt['move_why'] = 'Please enter a brief description as to<br>why this topic is being moved.';
$txt['board'] = '看板';
$txt['in'] = '在';
$txt['sticky_topic'] = '置頂文章';

$txt['delete'] = '刪除';
$txt['no_change'] = '不改變';

$txt['your_pms'] = '您的簡訊';

$txt['kilobyte'] = 'kB';
$txt['megabyte'] = 'MB';

$txt['more_stats'] = '[詳細統計資料]';

// Use numeric entities in the below three strings.
$txt['code'] = '代碼';
$txt['code_select'] = '[選擇]';
$txt['code_expand'] = 'Expand';
$txt['code_shrink'] = 'Shrink';
$txt['quote_from'] = '引述';
$txt['quote'] = '引用';
$txt['quote_action'] = '引用';
$txt['quote_selected_action'] = 'Quote selected text';
$txt['fulledit'] = 'Full&nbsp;edit';
$txt['edit'] = '編輯';
$txt['quick_edit'] = 'Quick Edit';
$txt['post_options'] = 'More...';

$txt['merge_to_topic_id'] = '目標主題的編號';
$txt['split'] = '分拆';
$txt['merge'] = '合併';
$txt['target_id'] = 'Select target by topic ID';
$txt['target_below'] = 'Select target from the list below';
$txt['subject_new_topic'] = '新主題的標題';
$txt['split_this_post'] = '只分拆這篇文章。';
$txt['split_after_and_this_post'] = '分拆的主題包含回覆的文章。';
$txt['select_split_posts'] = '選擇要分拆的文章。';
$txt['new_topic'] = '發表文章';
$txt['split_successful'] = '主題已經成功分拆為兩篇。';
$txt['origin_topic'] = '原始主題';
$txt['please_select_split'] = '選擇要分拆的文章。';
$txt['merge_successful'] = '主題已經合併成功。';
$txt['new_merged_topic'] = '合併後的新主題';
$txt['topic_to_merge'] = '您要合併的主題';
$txt['target_board'] = '目標看板';
$txt['target_topic'] = '目標主題';
$txt['merge_desc'] = 'This function will merge the messages of two topics into one topic. The messages will be sorted according to the time of posting. Therefore, the earliest posted message will be the first message of the merged topic.';

$txt['set_sticky'] = '置頂文章';
$txt['set_nonsticky'] = '取消置頂文章';
$txt['set_lock'] = '封鎖文章';
$txt['set_unlock'] = '解鎖文章';

$txt['search_advanced'] = '進階搜尋';

$txt['security_risk'] = '重大安全警告: ';
$txt['not_removed'] = '您並沒有移除 ';
$txt['not_removed_extra'] = '%1$s 是 %2$s 的備份，而且不是由 SMF 產生的。它可以被直接讀取而且可以未經您的授權讀取論壇。您應該直接刪除它。';
$txt['generic_warning'] = 'Warning';
$txt['agreement_missing'] = 'You are requiring new users to accept a registration agreement; however, the file (agreement.txt) does not exist.';
$txt['policy_agreement_missing'] = 'You are requiring new users to accept a privacy policy; however, the privacy policy is empty.';
$txt['auth_secret_missing'] = 'Unable to set authentication secret in Settings.php. This weakens the security of your forum and puts it at risk for attacks. Check the file permissions on Settings.php to make sure SMF can write to the file.';

$txt['cache_writable'] = '快取資料庫是唯讀的 - 這會影響論壇的效能。';

$txt['page_created_full'] = 'Page created in %1$.3f seconds with %2$d queries.';

$txt['report_to_mod_func'] = '這個功能是用來通知板主和管理員有辱罵或是違反規定的文章。<br /><em>請注意: 板主和管理員會知道是您使用這個功能的。</em>';
$txt['report_profile_func'] = 'Use this function to inform the administrators of abusive profile content, such as spam or inappropriate images.';

$txt['online'] = '線上';
$txt['member_is_online'] = '%1$s is online';
$txt['offline'] = '離線';
$txt['member_is_offline'] = '%1$s is offline';
$txt['pm_online'] = '傳送簡訊 (線上)';
$txt['pm_offline'] = '傳送簡訊 (離線)';
$txt['status'] = '狀態';

$txt['go_up'] = '向上';
$txt['go_down'] = '向下';

// argument(s): SMF_FULL_VERSION, SMF_SOFTWARE_YEAR, $scripturl
$forum_copyright = '<a href="%3$s?action=credits" title="License" target="_blank" rel="noopener">%1$s &copy; %2$s</a>, <a href="https://www.simplemachines.org" title="Simple Machines" target="_blank" rel="noopener">Simple Machines</a>';

$txt['birthdays'] = '壽星:';
$txt['events'] = '活動:';
$txt['birthdays_upcoming'] = '近期壽星:';
$txt['events_upcoming'] = '近期活動:';
// Prompt for holidays in the calendar, leave blank to just display the holiday's name.
$txt['calendar_prompt'] = 'Holidays:';
$txt['calendar_month'] = '月';
$txt['calendar_year'] = '年';
$txt['calendar_day'] = '日';
$txt['calendar_event_title'] = '活動名稱:';
$txt['calendar_event_options'] = '活動選項';
$txt['calendar_post_in'] = '相關文章:';
$txt['calendar_edit'] = '修改活動內容';
$txt['calendar_export'] = 'Export Event';
$txt['calendar_view_week'] = 'View Week';
$txt['event_delete_confirm'] = '刪除這個活動？';
$txt['event_delete'] = '刪除活動';
$txt['calendar_post_event'] = '建立事件';
$txt['calendar'] = '日曆';
$txt['calendar_link'] = '連結日曆';
$txt['calendar_upcoming'] = '近期活動';
$txt['calendar_today'] = '今天活動';
$txt['calendar_week'] = '星期';
$txt['calendar_week_title'] = 'Week %1$d of %2$d';
// %1$s is the month, %2$s is the day, %3$s is the year. Change to suit your language.
$txt['calendar_week_beginning'] = 'Week beginning %1$s %2$s, %3$s';
$txt['calendar_numb_days'] = '持續天數:';
$txt['calendar_how_edit'] = '如何編輯活動？';
$txt['calendar_link_event'] = '文章連結活動';
$txt['calendar_confirm_delete'] = '您確定要刪除這個活動嗎？';
$txt['calendar_linked_events'] = '日曆連結';
$txt['calendar_click_all'] = '瀏覽全部 %1$s';
$txt['calendar_allday'] = 'All day';
$txt['calendar_timezone'] = 'Time zone';
$txt['calendar_list'] = 'List';
$txt['calendar_empty'] = 'There are no events to display.';

$txt['movetopic_change_subject'] = 'Change the topic\'s subject';
$txt['movetopic_new_subject'] = 'New subject';
$txt['movetopic_change_all_subjects'] = 'Change every message\'s subject';
$txt['move_topic_unapproved_js'] = '警告！這篇文章還沒有審核。\n\n不建議您移動本文, 除非移動之後您打算審核。';
$txt['movetopic_auto_board'] = '[看板]';
$txt['movetopic_auto_topic'] = '[主題連結]';

// argument(s): $txt['movetopic_auto_board'], $txt['movetopic_auto_topic']
$txt['movetopic_default'] = 'This topic has been moved to %1$s.

%2$s';

$txt['movetopic_redirect'] = 'Redirect to the moved topic';

$txt['post_redirection'] = 'Post a redirection topic';
$txt['redirect_topic_expires'] = 'Automatically remove the redirection topic';
$txt['mergetopic_redirect'] = 'Redirect to the merged topic';
$txt['merge_topic_unapproved_js'] = 'Warning! This topic has not yet been approved.\n\nIt is not recommended that you create a redirection topic unless you intend to approve the post immediately following the merge.';

$txt['theme_template_error'] = '無法載入佈景 \'%1$s\'。
';
$txt['theme_language_error'] = '無法載入語系檔案 \'%1$s\'。';

$txt['sub_boards'] = 'Sub-Boards';
$txt['restricted_board'] = 'Restricted Board';

$txt['smtp_no_connect'] = '無法連線到郵件外寄主機 (SMTP)';
$txt['smtp_port_ssl'] = 'SMTP 連接埠的設定錯誤；SSL 的主機它必須是 465。';
$txt['smtp_bad_response'] = 'Could not get mail server response codes';
$txt['smtp_error'] = 'Ran into problems sending mail. Error: ';
$txt['mail_send_unable'] = '無法 Email 到 \'%1$s\'';

$txt['mlist_search'] = '搜尋會員';
$txt['mlist_search_again'] = '重新搜尋';
$txt['mlist_search_filter'] = 'Search options';
$txt['mlist_search_email'] = '搜尋 Email';
$txt['mlist_search_messenger'] = '搜尋即時通訊軟體的暱稱';
$txt['mlist_search_group'] = '搜尋群組';
$txt['mlist_search_name'] = '搜尋會員名稱';
$txt['mlist_search_website'] = '搜尋個人網站/部落格';
$txt['mlist_search_results'] = '搜尋結果';
$txt['mlist_search_by'] = '搜尋%1$s';
$txt['mlist_menu_view'] = '瀏覽會員名單';

$txt['attach_downloaded'] = '下載次數';
$txt['attach_viewed'] = '閱讀';

$txt['settings'] = '設定';
$txt['never'] = '不顯示';
$txt['more'] = '更多表情';
$txt['etc'] = 'etc.';

$txt['hostname'] = '網域';
$txt['you_are_post_banned'] = '%1$s 抱歉，您被禁止發表文章和傳送簡訊。';
$txt['ban_reason'] = '理由';
$txt['select_item_check'] = 'Please select at least one item in the list';

$txt['tables_optimized'] = '資料庫已經最佳化';

$txt['add_poll'] = '投票';
$txt['poll_options_limit'] = 'You may only select up to %1$s options.';
$txt['poll_remove'] = '移除投票';
$txt['poll_remove_warn'] = '您確定要移除這個投票嗎?';
$txt['poll_results_expire'] = '開票結果會在投票截止後顯示';
$txt['poll_expires_on'] = '投票截止日期';
$txt['poll_expired_on'] = '投票已經截止';
$txt['poll_change_vote'] = '移除投票';
$txt['poll_return_vote'] = '投票選項';
$txt['poll_cannot_see'] = '您現在不能看到投票結果';

$txt['quick_mod_approve'] = '核淮選擇';
$txt['quick_mod_remove'] = '移除選擇';
$txt['quick_mod_lock'] = '封/解鎖選擇';
$txt['quick_mod_sticky'] = '置頂/取消選擇';
$txt['quick_mod_move'] = '移動選擇到';
$txt['quick_mod_merge'] = '合併選擇';
$txt['quick_mod_markread'] = '標示選擇為已讀';
$txt['quick_mod_markunread'] = 'Mark selected unread';
$txt['quick_mod_selected'] = 'With the selected options do';
$txt['quick_mod_go'] = '繼續';
$txt['quickmod_confirm'] = '您確定要這麼做嗎？';

$txt['spell_check'] = '拼字檢查';

$txt['quick_reply'] = '快速回覆';
$txt['quick_reply_warning'] = '注意: 這篇文章已經被封鎖了！只有管理員和板主可以回覆。';
$txt['quick_reply_verification'] = '文章發表之後, 您會被引導到文章頁面驗證您的文章 %1$s。';
$txt['quick_reply_verification_guests'] = '(要求訪客)';
$txt['quick_reply_verification_posts'] = '(要求少於 %1$d 篇文章的使用者)';
$txt['wait_for_approval'] = 'Note: this post will not display until it has been approved by a moderator.';

$txt['notification_enable_board'] = '您確定要訂閱這個看板嗎？';
$txt['notification_disable_board'] = '您確定要取消訂閱這個看板嗎?';
$txt['notification_enable_topic'] = '您確定要訂閱這篇主題嗎？';
$txt['notification_disable_topic'] = '您確定要取消訂閱這篇主題嗎？';

// Mentions
$txt['mentions'] = 'Mentions';

// Likes
$txt['likes'] = 'Likes';
$txt['like'] = 'Like';
$txt['unlike'] = 'Unlike';
$txt['like_success'] = 'Your content was successfully liked.';
$txt['like_delete'] = 'Your content was successfully deleted.';
$txt['like_insert'] = 'Your content was successfully inserted.';
$txt['like_error'] = 'There was an error with your request.';
$txt['like_disable'] = 'Likes feature is disabled.';
$txt['not_valid_like_type'] = 'The liked type is not a valid type.';
// Translators, if you need to make more strings to suit your language, e.g. $txt['likes_2'] = 'Two people like this', please do so.
$txt['likes_1'] = '<a href="%1$s">%2$s person</a> likes this.';
$txt['likes_n'] = '<a href="%1$s">%2$s people</a> like this.';
$txt['you_likes_0'] = 'You like this.';
$txt['you_likes_1'] = 'You and <a href="%1$s">%2$s other person</a> like this.';
$txt['you_likes_n'] = 'You and <a href="%1$s">%2$s other people</a> like this.';

$txt['report_to_mod'] = '檢舉本文';
$txt['report_profile'] = 'Report profile of %1$s';

$txt['unread_topics_visit'] = '未讀文章';
// argument(s): scripturl
$txt['unread_topics_visit_none'] = 'No unread topics found since your last visit. <a href="%1$s?action=unread;all">Click here to try all unread topics</a>.';
$txt['updated_topics_visit_none'] = 'No updated topics found since your last visit.';
$txt['unread_topics_all'] = '所有未讀文章';
$txt['unread_replies'] = '未讀回覆';

$txt['who_title'] = '線上會員';
$txt['who_and'] = ' 與 ';
$txt['who_viewing_topic'] = ' 正在閱讀本文。';
$txt['who_viewing_board'] = ' 正在瀏覽本看板。';
$txt['who_member'] = '會員';

// No longer used by default theme, but for backwards compat
$txt['powered_by_php'] = 'Powered by PHP';
$txt['powered_by_mysql'] = 'Powered by MySQL';
$txt['valid_css'] = 'Valid CSS!';

$txt['rss'] = 'RSS';
$txt['atom'] = 'Atom';
$txt['html'] = 'HTML';

$txt['guest'] = '訪客';
$txt['guests'] = '訪客';
$txt['user'] = '會員';
$txt['users'] = '會員';
$txt['hidden'] = '隱藏';

// Plural form of hidden for languages other than English
$txt['hidden_s'] = '隱藏';
$txt['buddy'] = '好友';
$txt['buddies'] = '好友';
$txt['most_online_ever'] = '最多的線上人數';
$txt['most_online_today'] = '今日最多的線上人數';

$txt['merge_select_target_board'] = '選擇合併主題後的目標看板';
$txt['merge_select_poll'] = '選擇合併後要保留投票';
$txt['merge_topic_list'] = '選擇要合併的主題';
$txt['merge_select_subject'] = '選擇合併後主題的標題';
$txt['merge_custom_subject'] = '自訂標題';
$txt['merge_include_notifications'] = '包含文章通知？';
$txt['merge_check'] = '合併？';
$txt['merge_no_poll'] = '不保留投票';
$txt['merge_why'] = 'Please enter a brief description as to why these topics are being merged.';
$txt['merged_subject'] = '[MERGED] %1$s';
// argument(s): $txt['movetopic_auto_topic']
$txt['mergetopic_default'] = 'This topic has been merged into %2$s.';

$txt['response_prefix'] = 'Re: ';
$txt['current_icon'] = '目前圖示';
$txt['message_icon'] = '文章圖示';

$txt['smileys_current'] = '目前的表情套圖';
$txt['smileys_none'] = '不使用表情符號';
$txt['smileys_forum_board_default'] = '論壇/看板預設';

$txt['search_results'] = '搜尋結果';
$txt['search_no_results'] = '抱歉, 沒有找到任何符合的資料';

$txt['total_time_logged_days'] = ' days, ';
$txt['total_time_logged_hours'] = ' hours and ';
$txt['total_time_logged_minutes'] = ' minutes';
$txt['total_time_logged_d'] = 'd ';
$txt['total_time_logged_h'] = 'h ';
$txt['total_time_logged_m'] = 'm';

$txt['approve_members_waiting'] = '等待審核。';

$txt['activate_code'] = '您的啟用碼是';

$txt['find_members'] = '尋找會員';
$txt['find_username'] = '會員名稱(帳號, 暱稱)或 Email';
$txt['find_buddies'] = '只顯示好友？';
$txt['find_wildcards'] = '您可以使用的萬用字元: *, ?';
$txt['find_no_results'] = '沒有找到任何結果';
$txt['find_results'] = '結果';
$txt['find_close'] = '關閉';

$txt['unread_since_visit'] = '顯示上次離線後的新文章';
$txt['show_unread_replies'] = '顯示回覆我的新文章';

$txt['change_color'] = '變更顏色';

$txt['quickmod_delete_selected'] = '移除選擇';
$txt['quickmod_split_selected'] = 'Split selected';

$txt['show_personal_messages_heading'] = 'New messages';
$txt['show_personal_messages'] = '您有新簡訊。\n您要開啟新視窗閱讀簡訊嗎？';

$txt['help_popup'] = 'A little lost? Let me explain:';

$txt['previous_next_back'] = '&laquo; 上一篇';
$txt['previous_next_forward'] = '下一篇 &raquo;';

$txt['mark_unread'] = '標示未讀';

$txt['ssi_not_direct'] = 'Please do not access SSI.php by URL directly; you may want to use the path (%1$s) or add ?ssi_function=something.';
$txt['ssi_session_broken'] = 'SSI.php 無法載入工作階段！這可能會對登出或其他功能造成問題 - 請確定在其它的資料之前已經包括了 SSI.php！';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['preview_title'] = '預覽文章';
$txt['preview_fetch'] = '讀取預覽...';
$txt['preview_new'] = '新訊息';
$txt['pm_error_while_submitting'] = 'The following error or errors occurred while sending this personal message:';
$txt['error_while_submitting'] = '送出訊息時, 發生下面錯誤: ';
$txt['error_old_topic'] = '注意: 這個主題已經超過 %1$d 天沒有人回覆。<br />除非您真的想回覆, 否則請考慮另外發表文章。';

$txt['split_selected_posts'] = '選擇的文章';
$txt['split_selected_posts_desc'] = '分拆後下面的文章會變成新主題。';
$txt['split_reset_selection'] = '重設選擇';

$txt['modify_cancel'] = '取消';
$txt['modify_cancel_all'] = 'Cancel All';
$txt['mark_read_short'] = '標示已讀';

$txt['alerts'] = 'Alerts';

$txt['pm_short'] = '我的簡訊';
$txt['pm_menu_read'] = '閱讀簡訊';
$txt['pm_menu_send'] = '傳送簡訊';

$txt['unapproved_posts'] = '未審核的文章 (主題: %1$d, 文章: %2$d)';

$txt['ajax_in_progress'] = '讀取...';

$txt['mod_reports_waiting'] = '被檢舉的文章';

$txt['view_unread_category'] = 'Unread Posts';
$txt['new_posts_in_category'] = 'Click to see the new posts in %1$s';
$txt['verification'] = '驗證碼';
$txt['visual_verification_hidden'] = 'Please leave this box empty';
$txt['visual_verification_description'] = '輸入圖片上的文字';
$txt['visual_verification_sound'] = '播放文字聲音';
$txt['visual_verification_request_new'] = '換張圖片';

// Sub menu labels
$txt['summary'] = '個人名片';
$txt['account'] = '帳號設定';
$txt['theme'] = 'Look and Layout';
$txt['forumprofile'] = '論壇資料';
$txt['activate_changed_email_title'] = 'Email Address Changed';
$txt['activate_changed_email_desc'] = 'You\'ve changed your email address. In order to validate this address you will receive an email. Click the link in that email to reactivate your account.';
$txt['modSettings_title'] = '功能與選項';
$txt['package'] = '套件管理員';
$txt['errorlog'] = 'Error Log';
$txt['edit_permissions'] = '權限';
$txt['mc_unapproved_attachments'] = '未審核的附件';
$txt['mc_unapproved_poststopics'] = '未審核的文章';
$txt['mc_reported_posts'] = '目前有 %1$d 個檢舉。';
$txt['mc_reported_members'] = 'Reported Members';
$txt['modlog_view'] = '板務管理紀錄';
$txt['calendar_menu'] = '檢視日曆';

// @todo Send email strings - should move?
$txt['send_email'] = '傳送 Email';

$txt['ignoring_user'] = '您忽視這位會員。';
$txt['show_ignore_user_post'] = '顯示這篇文章。';

$txt['spider'] = '機器人';
$txt['spiders'] = '機器人';

$txt['downloads'] = '下載次數';
$txt['filesize'] = '檔案大小';

// Restore topic
$txt['restore_topic'] = '回復主題';
$txt['restore_message'] = '回復';
$txt['quick_mod_restore'] = '回復選擇';

// Editor prompt.
$txt['prompt_text_email'] = '請輸入 Email';
$txt['prompt_text_ftp'] = '請輸入 ftp 位址';
$txt['prompt_text_url'] = '請輸入網址。';
$txt['prompt_text_img'] = '輸入圖片網址';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['autosuggest_delete_item'] = '刪除項目';

// Debug related - when $db_show_debug is true.
$txt['debug_templates'] = '樣版: ';
$txt['debug_subtemplates'] = '子樣版: ';
$txt['debug_language_files'] = '語系檔案: ';
$txt['debug_stylesheets'] = '樣式表: ';
$txt['debug_files_included'] = '檔案含括: ';
$txt['debug_memory_use'] = 'Memory used: ';
$txt['debug_kb'] = 'kB.';
$txt['debug_show'] = '檢視';
$txt['debug_cache_hits'] = 'Cache hits: ';
$txt['debug_cache_misses'] = 'Cache misses: ';
$txt['debug_cache_seconds_bytes'] = '%1$ss - %2$s bytes';
$txt['debug_cache_seconds_bytes_total'] = '%1$ss for %2$s bytes';
$txt['debug_queries_used'] = 'Queries used: %1$d.';
$txt['debug_queries_used_and_warnings'] = 'Queries used: %1$d, %2$d warnings.';
$txt['debug_query_in_line'] = 'in <em>%1$s</em> line <em>%2$s</em>, ';
$txt['debug_query_which_took'] = 'which took %1$s seconds.';
$txt['debug_query_which_took_at'] = '它花了 %1$s 秒 at %2$s into request.';
$txt['debug_show_queries'] = '[Show Queries]';
$txt['debug_hide_queries'] = '[Hide Queries]';
$txt['debug_tokens'] = 'Tokens: ';
$txt['debug_browser'] = 'Browser ID: ';
$txt['debug_hooks'] = 'Hooks called: ';
$txt['debug_instances'] = 'Instances created: ';
$txt['are_sure_mark_read'] = 'Are you sure you want to mark messages as read?';

// Inline attachments messages.
$txt['attachments_not_enable'] = 'Attachments are disabled';
$txt['attachments_no_data_loaded'] = 'Not a valid attachment ID.';
$txt['attachments_not_allowed_to_see'] = 'You cannot view this attachment.';
$txt['attachments_no_msg_associated'] = 'No message is associated with this attachment.';
$txt['attachments_unapproved'] = 'Attachment is awaiting approval.';

// Accessibility
$txt['hide_category'] = 'Hide Category';
$txt['show_category'] = 'Show Category';
$txt['hide_infocenter'] = 'Hide Info Center';
$txt['show_infocenter'] = 'Show Info Center';

// Notification post control
$txt['notify_topic_0'] = 'Not Following';
$txt['notify_topic_1'] = 'No Alerts or Emails';
$txt['notify_topic_2'] = 'Receive Alerts';
$txt['notify_topic_3'] = 'Receive Emails and Alerts';
$txt['notify_topic_0_desc'] = 'You will not receive any emails or alerts for this topic and it will also not show up in your unread replies and topics list. You will still receive @mentions for this topic.';
$txt['notify_topic_1_desc'] = 'You will not receive any emails or alerts but only @mentions by other members.';
$txt['notify_topic_2_desc'] = 'You will receive alerts for this topic.';
$txt['notify_topic_3_desc'] = 'You will receive both alerts and e-mails for this topic.';
$txt['notify_board_1'] = 'No Alerts or Emails';
$txt['notify_board_2'] = 'Receive Alerts';
$txt['notify_board_3'] = 'Receive Emails and Alerts';
$txt['notify_board_1_desc'] = 'You will not receive any emails or alerts for new topics';
$txt['notify_board_2_desc'] = 'You will receive alerts for this board.';
$txt['notify_board_3_desc'] = 'You will receive both alerts and e-mails for this board.';

$txt['notify_board_prompt'] = '這個看板有新主題時, 需要 Email 通知您嗎？';
$txt['notify_board_subscribed'] = '%1$s has been subscribed to new topic notifications for this board.';
$txt['notify_board_unsubscribed'] = '%1$s has been unsubscribed from new topic notifications for this board.';

$txt['notify_topic_prompt'] = '訂閱通知: 這篇文章有人回覆時, 需要傳送 Email 通知您嗎？';
$txt['notify_topic_subscribed'] = '%1$s has been subscribed to new reply notifications for this topic.';
$txt['notify_topic_unsubscribed'] = '%1$s has been unsubscribed from new reply notifications for this topic.';

$txt['notify_announcements_prompt'] = 'Do you want to receive forum newsletters, announcements and important notifications by email?';
$txt['notify_announcements_subscribed'] = '%1$s has been subscribed to forum newsletters, announcements and important notifications.';
$txt['notify_announcements_unsubscribed'] = '%1$s has been unsubscribed from forum newsletters, announcements and important notifications.';

$txt['unsubscribe_announcements_plain'] = 'To unsubscribe from forum newsletters, announcements and important notifications, follow this link: %1$s';
$txt['unsubscribe_announcements_html'] = '<span style="font-size:small"><a href="%1$s">Unsubscribe</a> from forum newsletters, announcements and important notifications.</span>';
$txt['unsubscribe_announcements_manual'] = 'To unsubscribe from forum newsletters, announcements and important notifications, contact us at %1$s with your request.';

// Mobile Actions
$txt['mobile_action'] = 'User actions';
$txt['mobile_moderation'] = '板務管理';
$txt['mobile_user_menu'] = 'Main Menu';
$txt['mobile_generic_menu'] = '%1$s Menu';

// Formats for lists in a sentence (e.g. "Alice, Bob, and Charlie")
// Examples:
// 	$txt['sentence_list_format'][2] specifies a format for a list with two items
// 	$txt['sentence_list_format']['n'] specifies the default format
// Notes on placeholders:
// 	{1} = first item in the list, {2} = second item, etc.
// 	{-1} = last item in the list, {-2} = second last item, etc.
// 	{series} = concatenated string of the rest of the items in the list
$txt['sentence_list_format'][1] = '{1}';
$txt['sentence_list_format'][2] = '{1} and {-1}';
$txt['sentence_list_format'][3] = '{series}, and {-1}';
$txt['sentence_list_format'][4] = '{series}, and {-1}';
$txt['sentence_list_format'][5] = '{series}, and {-1}';
$txt['sentence_list_format']['n'] = '{series}, and {-1}';
// Separators used to build lists in a sentence
$txt['sentence_list_separator'] = ', ';
$txt['sentence_list_separator_alt'] = '; ';

?>