<?php
// Version: 2.1.5; index

global $forum_copyright, $webmaster_email, $scripturl, $context, $boardurl;

// Native name, please use full HTML entities to write your language's name.
$txt['native_name'] = 'Dansk';

// Locale (strftime, basename). For more information see:
//   - https://php.net/function.setlocale
$txt['lang_locale'] = 'da_DK';
$txt['lang_dictionary'] = 'da';
//https://developers.google.com/recaptcha/docs/language
$txt['lang_recaptcha'] = 'da';

// Ensure you remember to use uppercase for character set strings.
$txt['lang_character_set'] = 'UTF-8';
// Character set right to left?  0 = ltr; 1 = rtl
$txt['lang_rtl'] = '0';
// Number format.
$txt['number_format'] = '1.234,00';

$txt['days_title'] = 'Dage';
$txt['days'] = array('søndag', 'mandag', 'tirsdag', 'onsdag', 'torsdag', 'fredag', 'lørdag');
$txt['days_short'] = array('søn', 'man', 'tir', 'ons', 'tors', 'fre', 'lør');
// Months must start with 1 => 'January'. (or translated, of course.)
$txt['months_title'] = 'Måneder';
$txt['months'] = array(1 => 'Januar', 2 => 'Februar', 3 => 'Marts', 4 => 'April', 5 => 'Maj', 6 => 'Juni', 7 => 'Juli', 8 => 'August', 9 => 'September', 10 => 'Oktober', 11 => 'November', 12 => 'December');
$txt['months_titles'] = array(1 => 'Januar', 2 => 'Februar', 3 => 'Marts', 4 => 'April', 5 => 'Maj', 6 => 'Juni', 7 => 'Juli', 8 => 'August', 9 => 'September', 10 => 'Oktober', 11 => 'November', 12 => 'December');
$txt['months_short'] = array(1 => 'Mar', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr', 5 => 'Maj', 6 => 'Jun', 7 => 'Jul', 8 => 'Aug', 9 => 'Sep', 10 => 'Okt', 11 => 'Nov', 12 => 'Dec');
$txt['prev_month'] = 'Forrige måned';
$txt['next_month'] = 'Næste måned';
$txt['start'] = 'Start';
$txt['end'] = 'Slut';
$txt['starts'] = 'Begynder';
$txt['ends'] = 'Slutter';
$txt['none'] = 'Ingen';

$txt['minutes_label'] = 'Minutter';
$txt['hours_label'] = 'Timer';
$txt['years_title'] = 'År';

$txt['time_am'] = 'am';
$txt['time_pm'] = 'pm';

// Short form of minutes
$txt['minutes_short'] = 'min.';
// Short form of hour
$txt['hour_short'] = 'timer';
// Short form of hours
$txt['hours_short'] = 'timer';
// Decimal sign
$txt['decimal_sign'] = ',';

$txt['admin'] = 'Admin';
$txt['moderate'] = 'Moderér';

$txt['save'] = 'Gem';
$txt['reset'] = 'Nulstil';
$txt['upload'] = 'Upload';
$txt['upload_all'] = 'Upload alle';
$txt['processing'] = 'Behandler...';

$txt['modify'] = 'Redigér';
$txt['forum_index'] = '%1$s - indeks';
$txt['members'] = 'Brugere';
$txt['board_name'] = 'Tavlenavn';
$txt['posts'] = 'Indlæg';

$txt['member_postcount'] = 'Indlæg';
$txt['no_subject'] = '(Intet emne)';
$txt['view_profile'] = 'Vis profil';
$txt['guest_title'] = 'Gæst';
$txt['author'] = 'Forfatter';
$txt['on'] = 'den';
$txt['remove'] = 'Slet';
$txt['start_new_topic'] = 'Opret nyt emne';

$txt['login'] = 'Log ind';
// Use numeric entities in the below string.
$txt['username'] = 'Brugernavn';
$txt['password'] = 'Adgangskode';

$txt['username_no_exist'] = 'Det brugernavn eksisterer ikke.';
$txt['no_user_with_email'] = 'Der er ingen brugernavne tilknyttet denne email.';

$txt['board_moderator'] = 'Tavlemoderator';
$txt['remove_topic'] = 'Fjern emnet';
$txt['topics'] = 'Emner';
$txt['modify_msg'] = 'Redigér indlæg';
$txt['name'] = 'Navn';
$txt['email'] = 'Email';
$txt['user_email_address'] = 'Email adresse';
$txt['subject'] = 'Emne';
$txt['message'] = 'Besked';
$txt['redirects'] = 'Klik';
$txt['quick_modify'] = 'Redigér inline';
$txt['quick_modify_message'] = 'Du har med succes redigeret denne meddelelse.';
$txt['reason_for_edit'] = 'Årsag til redigering';

$txt['choose_pass'] = 'Vælg adgangskode';
$txt['verify_pass'] = 'Bekræft adgangskode';
$txt['notify_announcements'] = 'Tillad administratorer at sende mig vigtige nyheder via email';

$txt['position'] = 'Stilling';

// argument(s): username
$txt['view_profile_of_username'] = 'Se profilen for %1$s';
$txt['total'] = 'I alt';
$txt['website'] = 'Website';
$txt['register'] = 'Registrér';
$txt['warning_status'] = 'Advarselsstatus';
$txt['user_warn_watch'] = 'Brugeren er på moderator overvågningslisten';
$txt['user_warn_moderate'] = 'Brugerens indlæg bliver lagt i godkendelseskøen';
$txt['user_warn_mute'] = 'Brugeren er bandlyst fra at skrive indlæg';
$txt['warn_watch'] = 'Overvåget';
$txt['warn_moderate'] = 'Modereret';
$txt['warn_mute'] = 'Ignoreret';

$txt['message_index'] = 'Emneindeks';
$txt['news'] = 'Nyheder';
$txt['home'] = 'Hjem';
$txt['page'] = 'Side';
$txt['prev'] = 'Forrige side';
$txt['next'] = 'Næste side';

$txt['lock_unlock'] = 'Lås/oplås emne';
$txt['post'] = 'Gem';
$txt['error_occured'] = 'Der er opstået en fejl';
$txt['at'] = 'ved';
$txt['by'] = 'af';
$txt['logout'] = 'Log ud';
$txt['started_by'] = 'Startet af';
$txt['topic_started_by'] = 'Startet af <strong>%1$s</strong> i <em>%2$s</em>';
$txt['replies'] = 'Svar';
$txt['last_post'] = 'Seneste indlæg';
$txt['first_post'] = 'Første indlæg';
$txt['last_poster'] = 'Seneste indlæg af';
$txt['last_post_message'] = '<strong>Seneste indlæg: </strong>%3$s <br>%2$s af %1$s';
$txt['last_post_topic'] = '%1$s<br>af %2$s';
$txt['post_by_member'] = '<strong>%1$s</strong> af <strong>%2$s</strong><br>';
$txt['boardindex_total_posts'] = '%1$s indlæg i %2$s emner af %3$s brugere';
$txt['show'] = 'Vis';
$txt['hide'] = 'Skjul';

$txt['admin_login'] = 'Administrations-login';
// Use numeric entities in the below string.
$txt['topic'] = 'Emne';
$txt['help'] = 'Hjælp';
$txt['terms_and_rules'] = 'Vilkår og regler';
$txt['watch_board'] = 'Følg denne tavle';
$txt['unwatch_board'] = 'Følg ikke længere denne tavle';
$txt['watch_topic'] = 'Følg dette emne';
$txt['unwatch_topic'] = 'Følg ikke længere dette emne';
$txt['watching_topic'] = 'Emne du overvåger';
$txt['watching_this_topic'] = 'Du følger dette emne og modtager meldinger om det.';
$txt['notify'] = 'Abonnér';
$txt['unnotify'] = 'Fjern abonnement';

// Use numeric entities in the below string.
// argument(s): forum name
$txt['regards_team'] = 'Med venlig hilsen
%1$s-teamet.';

$txt['notify_replies'] = 'Besked ved svar';
$txt['move_topic'] = 'Flyt emnet';
$txt['move_to'] = 'Flyt til';
$txt['pages'] = 'Sider';
$txt['users_active'] = 'Brugere aktive i de seneste %1$d minutter';
$txt['personal_messages'] = 'Personlige beskeder';
$txt['reply_quote'] = 'Svar med citat';
$txt['reply'] = 'Svar';
$txt['reply_noun'] = 'Svar';
$txt['reply_number'] = 'Svar #%1$s%2$s';
$txt['approve'] = 'Godkend';
$txt['unapprove'] = 'Fjern godkendelse';
$txt['approve_all'] = 'godkend alle';
$txt['issue_warning'] = 'Udsted advarsel';
$txt['awaiting_approval'] = 'Afventer godkendelse';
$txt['attach_awaiting_approve'] = 'Vedhæftede filer, der afventer godkendelse';
$txt['post_awaiting_approval'] = 'Dette indlæg afventer godkendelse af en moderator.';
$txt['there_are_unapproved_topics'] = 'Der er %1$s emner og %2$s indlæg, der afventer godkendelse i denne tavle. Klik <a href="%3$s">her</a> for at se dem alle.';
$txt['send_message'] = 'Send besked';

$txt['msg_alert_no_messages'] = 'du har ingen beskeder';
$txt['msg_alert_one_message'] = 'du har <a href="%1$s">1 besked</a>';
$txt['msg_alert_many_message'] = 'du har <a href="%1$s">%2$d beskeder</a>';
$txt['msg_alert_one_new'] = '1 er ny';
$txt['msg_alert_many_new'] = '%1$d er nye';
$txt['new_alert'] = 'Ny melding';
$txt['remove_message'] = 'Fjern dette indlæg';
$txt['remove_message_question'] = 'Fjern dette indlæg?';

$txt['topic_alert_none'] = 'Ingen indlæg...';
$txt['pm_alert_none'] = 'Ingen beskeder...';
$txt['no_messages'] = 'Ingen meddelelser';

$txt['online_users'] = 'Brugere online';
$txt['jump_to'] = 'Gå til';
$txt['go'] = 'Gå';
$txt['are_sure_remove_topic'] = 'Er du sikker på, at du vil fjerne dette emne?';
$txt['yes'] = 'Ja';
$txt['no'] = 'Nej';

$txt['search_end_results'] = 'Slut på resultater';
$txt['search_on'] = 'Dato';

$txt['search'] = 'Søg';
$txt['all'] = 'Vis alle';
$txt['search_entireforum'] = 'Hele forummet';
$txt['search_thisboard'] = 'Denne tavle';
$txt['search_thistopic'] = 'Dette emne';
$txt['search_members'] = 'Brugere';

$txt['back'] = 'Tilbage';
$txt['continue'] = 'Fortsæt';
$txt['password_reminder'] = 'Adgangskode påmindelse';
$txt['topic_started'] = 'Emne startet af';
$txt['title'] = 'Titel';
$txt['post_by'] = 'Indlæg af';
$txt['memberlist_searchable'] = 'Søgbar liste over alle registrerede brugere.';
$txt['welcome_newest_member'] = 'Byd velkommen til %1$s, vores nyeste bruger.';
$txt['admin_center'] = 'Administrationscenter';
$txt['last_edit_by'] = '<span class="lastedit">Seneste redigering</span>: %1$s af %2$s';
$txt['last_edit_reason'] = '<span class="lastedit">Årsag</span>: %1$s ';
$txt['notify_deactivate'] = 'Vil du deaktivere meldinger om dette emne?';
$txt['modified_time'] = 'Seneste redigering';
$txt['modified_by'] = 'Redigeret af';

$txt['recent_posts'] = 'Nyeste indlæg';

$txt['location'] = 'Sted';
$txt['location_desc'] = 'Geografisk placering.';
$txt['gender'] = 'Køn';
$txt['gender_0'] = 'Ingen';
$txt['gender_1'] = 'Mand';
$txt['gender_2'] = 'Kvinde';
$txt['gender_desc'] = 'Dit køn.';
$txt['icq'] = 'ICQ';
$txt['icq_desc'] = 'Dette er dit ICQ-nummer.';
$txt['skype'] = 'Skype';
$txt['skype_desc'] = 'Dit Skype-brugernavn';
$txt['personal_text'] = 'Personlig tekst';
$txt['date_registered'] = 'Dato for registrering';

$txt['recent_view'] = 'Se de nyeste indlæg i forummet.';
$txt['recent_updated'] = 'er det senest opdaterede emne';
$txt['is_recent_updated'] = '%1$s er det senest opdaterede emne';

$txt['male'] = 'Mand';
$txt['female'] = 'Kvinde';

$txt['error_invalid_characters_username'] = 'Ugyldigt tegn anvendt i brugernavnet.';

// argument(s): forum name, login URL, login JavaScript snippet
$txt['welcome_guest'] = 'Velkommen til <strong>%1$s</strong>. <a href="%2$s" onclick="%3$s">Log venligst ind</a>.';

// argument(s): forum name, login URL, login JavaScript snippet, signup URL
$txt['welcome_guest_register'] = 'Velkommen til <strong>%1$s</strong>. <a href="%2$s" onclick="%3$s">Log venligst ind</a> eller <a href="%4$s">registrér dig</a>.';

// argument(s): $scripturl
$txt['welcome_guest_activate'] = '<a href="%1$s?action=activate">Fik du ikke en aktiverings email?</a>';

// argument(s): $scripturl
$txt['register_prompt'] = 'Har du ikke en forumkonto? <a href="%1$s?action=signup">Registrér dig</a>.';

// argument(s): forum name
$txt['welcome_to_forum'] = 'Velkommen til <strong>%1$s</strong>.';

// @todo the following to sprintf
$txt['hello_member'] = 'Hej';
// Use numeric entities in the below string.
$txt['hello_guest'] = 'Velkommen';
$txt['select_destination'] = 'Vælg venligst en destination';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['posted_by'] = 'Skrevet af';

$txt['icon_smiley'] = 'Smiley';
$txt['icon_angry'] = 'Vred';
$txt['icon_cheesy'] = 'Humørgrin';
$txt['icon_laugh'] = 'Griner';
$txt['icon_sad'] = 'Trist';
$txt['icon_wink'] = 'Blink';
$txt['icon_grin'] = 'Bredt grin';
$txt['icon_shocked'] = 'Chokeret';
$txt['icon_cool'] = 'Cool';
$txt['icon_huh'] = 'Spørgsmål';
$txt['icon_rolleyes'] = 'Rullende øjne';
$txt['icon_tongue'] = 'Tunge';
$txt['icon_embarrassed'] = 'Flov';
$txt['icon_lips'] = 'Forseglede læber';
$txt['icon_undecided'] = 'Uafklaret';
$txt['icon_kiss'] = 'Kys';
$txt['icon_cry'] = 'Græder';

$txt['moderator'] = 'Moderator';
$txt['moderators'] = 'Moderatorer';

$txt['views'] = 'Vist';
$txt['new'] = 'Ny';

$txt['view_all_members'] = 'Se alle brugere';
$txt['view'] = 'Vis';

$txt['viewing_members'] = 'Viser brugerne %1$s til %2$s';
$txt['of_total_members'] = 'af i alt %1$s brugere';

$txt['forgot_your_password'] = 'Glemt din adgangskode?';

$txt['date'] = 'Dato';
// Use numeric entities in the below string.
$txt['from'] = 'Fra';
$txt['check_new_messages'] = 'Se om der er nye beskeder';
$txt['to'] = 'Til';

$txt['board_topics'] = 'Emner';
$txt['members_title'] = 'Brugere';
$txt['members_list'] = 'Brugerliste';
$txt['new_posts'] = 'Nye indlæg';
$txt['old_posts'] = 'Ingen nye indlæg';
$txt['redirect_board'] = 'Omdirigeringstavle';

$txt['sendtopic_send'] = 'Send';
$txt['report_sent'] = 'Din anmeldelse er blevet indsendt.';
$txt['post_becomes_unapproved'] = 'Dit indlæg blev ikke godkendt, fordi det er skrevet i et ikke-godkendt emne. Når emnet er godkendt, vil dit indlæg også blive godkendt.';

$txt['time_offset'] = 'Tidsforskydning';
$txt['or'] = 'eller';

$txt['no_matches'] = 'Der blev ikke fundet nogen resultater';

$txt['notification'] = 'Meddelelse';

$txt['your_ban'] = 'Beklager %1$s, du er bandlyst fra at bruge dette forum!';
$txt['your_ban_expires'] = 'Denne bandlysning er sat til at udløbe %1$s.';
$txt['your_ban_expires_never'] = 'Denne bandlysning er ikke sat til at udløbe.';
$txt['ban_continue_browse'] = 'Du kan fortsætte med at bruge forummet som gæst.';

$txt['mark_as_read'] = 'Markér ALLE indlæg som læst';

$txt['locked_topic'] = 'Låst emne';
$txt['normal_topic'] = 'Normalt emne';
$txt['participation_caption'] = 'Emne du har skrevet indlæg i';
$txt['moved_topic'] = 'Flyttet emne';

$txt['go_caps'] = 'Gå';

$txt['print'] = 'Udskriv';
$txt['profile'] = 'Profil';
$txt['topic_summary'] = 'Emneresumé';
$txt['not_applicable'] = 'Ikke tilgængelig';
$txt['name_in_use'] = 'Dette navn benyttes allerede af en anden bruger.';

$txt['total_members'] = 'Samlet antal brugere';
$txt['total_posts'] = 'Samlet antal indlæg';
$txt['total_topics'] = 'Samlet antal emner';

$txt['time_logged_in'] = 'Login periode';

$txt['preview'] = 'Forhåndsvisning';
$txt['always_logged_in'] = 'Altid';

$txt['logged'] = 'Logget';
$txt['show_ip'] = 'Vis IP-adresse';
// Use numeric entities in the below string.
$txt['ip'] = 'IP';
$txt['url'] = 'URL';
$txt['www'] = 'WWW';

$txt['hours'] = 'timer';
$txt['minutes'] = 'minutter';
$txt['seconds'] = 'sekunder';

// Used upper case in Paid subscriptions management
$txt['hour'] = 'Time';
$txt['days_word'] = 'dage';

$txt['search_for'] = 'Søg efter';
$txt['search_match'] = 'Match';

$txt['forum_in_maintenance'] = 'Forummet er i vedligeholdelsestilstand. Kun administratorer kan i øjeblikket logge ind.';
$txt['maintenance_page'] = 'Du kan slå vedligeholdelsestilstand fra under <a href="%1$s">Server-indstillinger</a>.';

$txt['read_one_time'] = 'Læst 1 gang';
$txt['read_many_times'] = 'Læst %1$d gange';

$txt['forum_stats'] = 'Forumstatistik';
$txt['latest_member'] = 'Nyeste medlem';
$txt['total_cats'] = 'Kategorier i alt';
$txt['latest_post'] = 'Nyeste indlæg';

$txt['total_boards'] = 'Antal tavler';

$txt['print_page'] = 'Udskriv side';
$txt['print_page_text'] = 'Kun tekst';
$txt['print_page_images'] = 'Tekst med billeder';

$txt['valid_email'] = 'Dette skal være en gyldig email adresse.';

$txt['geek'] = 'Jeg er en nørd!!';
$txt['info_center_title'] = '%1$s - Infocenter';

$txt['watch'] = 'Overvåg';
$txt['unwatch'] = 'Stop overvågning';

$txt['check_all'] = 'Vælg alle';

// Use numeric entities in the below string.
$txt['database_error'] = 'Databasefejl';
$txt['try_again'] = 'Prøv venligst igen. Hvis du kommer tilbage til denne fejlmeddelelse, bedes du rapportere fejlen til en administrator.';
$txt['file'] = 'Fil';
$txt['line'] = 'Linie';
// Use numeric entities in the below string.
$txt['tried_to_repair'] = 'SMF har opdaget og automatisk forsøgt at reparere en fejl i din database. Hvis du fortsat har problemer eller fortsætter med at modtage disse emails, bedes du kontakte din databasehost.';
$txt['database_error_versions'] = '<strong>Bemærk:</strong> Det ser ud til, at din database <em>muligvis</em> kræver en opdatering. Dit forums filer er i øjeblikket på version %1$s, mens din database er på version %2$s. Ovenstående fejl forsvinder muligvis, hvis du starter den seneste version af upgrade.php.';
$txt['template_parse_error'] = 'Skabelon afviklingsfejl!';
$txt['template_parse_error_message'] = 'Det lader til, at noget er gået galt i forummet med skabelonsystemet. Dette problem bør kun være midlertidigt, så vend venligst tilbage senere og prøv igen. Hvis du fortsætter med at få denne meddelelse, bedes du kontakte administratoren.<br><br>Du kan også prøve at <a href="javascript:location.reload();">opdatere denne side</a>.';
// argument(s): filename, $boardurl, $scripturl
$txt['template_parse_error_details'] = 'Der var et problem med at indlæse <pre><strong>%1$s</strong></pre> skabelonen eller sprogfilen. Tjek venligst syntaksen og prøv igen - husk, enkelte anførselstegn (<pre>\'</pre>) skal ofte escapes med en skråstreg (<pre>\\</pre>). For at se mere specifik fejlinformation fra PHP, prøv <a href="%2$s%1$s">at få direkte adgang til filen</a>.<br><br>Du kan prøve at <a href= "javascript:location.reload();">opdater denne side</a> eller <a href="%3$s?theme=1">brug standardtemaet</a>.';
$txt['template_parse_errmsg'] = 'Desværre er der ikke mere information tilgængelig på nuværende tidspunkt om præcis, hvad der er galt.';

$txt['today'] = '<strong>I dag</strong> ';
$txt['yesterday'] = '<strong>I går</strong> ';
$txt['new_poll'] = 'Ny afstemning';
$txt['poll_question'] = 'Spørgsmål';
$txt['poll_vote'] = 'Afgiv stemme';
$txt['poll_total_voters'] = 'Samlet antal stemmeafgivere';
$txt['poll_results'] = 'Se resultater';
$txt['poll_lock'] = 'Lås afstemning';
$txt['poll_unlock'] = 'Oplås afstemning';
$txt['poll_edit'] = 'Redigér afstemning';
$txt['poll'] = 'Afstemning';
$txt['one_hour'] = '1 time';
$txt['one_day'] = '1 dag';
$txt['one_week'] = '1 uge';
$txt['two_weeks'] = '2 uger';
$txt['one_month'] = '1 måned';
$txt['two_months'] = '2 måneder';
$txt['forever'] = 'For evigt';
$txt['moved'] = 'FLYTTET';
$txt['move_why'] = 'Indtast venligst en kort beskrivelse af<br>hvorfor dette emne flyttes.';
$txt['board'] = 'Tavle';
$txt['in'] = 'i';
$txt['sticky_topic'] = 'Fastgjort emne';

$txt['delete'] = 'Slet';
$txt['no_change'] = 'Ingen ændring';

$txt['your_pms'] = 'Dine personlige beskeder';

$txt['kilobyte'] = 'kB';
$txt['megabyte'] = 'MB';

$txt['more_stats'] = '[Mere statistik]';

// Use numeric entities in the below three strings.
$txt['code'] = 'Kode';
$txt['code_select'] = 'Vælg';
$txt['code_expand'] = 'Udvid';
$txt['code_shrink'] = 'Formindsk';
$txt['quote_from'] = 'Citat fra';
$txt['quote'] = 'Citat';
$txt['quote_action'] = 'Citér';
$txt['quote_selected_action'] = 'Citér den valgte tekst';
$txt['fulledit'] = 'Fuld redigering';
$txt['edit'] = 'Gem';
$txt['quick_edit'] = 'Hurtig redigering';
$txt['post_options'] = 'Mere...';

$txt['merge_to_topic_id'] = 'ID på målemnet';
$txt['split'] = 'Opdel emnet';
$txt['merge'] = 'Flet emner';
$txt['target_id'] = 'Vælg mål efter emne-id';
$txt['target_below'] = 'Vælg mål fra listen nedenfor';
$txt['subject_new_topic'] = 'Titel for nyt emne';
$txt['split_this_post'] = 'Opdel kun dette indlæg.';
$txt['split_after_and_this_post'] = 'Opdel emnet fra og med dette indlæg.';
$txt['select_split_posts'] = 'Vælg de indlæg, der skal deles.';
$txt['new_topic'] = 'Nyt emne';
$txt['split_successful'] = 'Emnet blev med succes opdelt i to emner.';
$txt['origin_topic'] = 'Oprindeligt emne';
$txt['please_select_split'] = 'Vælg venligst, hvilke indlæg du ønsker at opdele.';
$txt['merge_successful'] = 'Emnerne er nu flettet sammen.';
$txt['new_merged_topic'] = 'Nyligt sammenflettet emne';
$txt['topic_to_merge'] = 'Emne der skal flettes';
$txt['target_board'] = 'Måltavle';
$txt['target_topic'] = 'Målemne';
$txt['merge_desc'] = 'Denne funktion fletter indlæg fra to emner til ét emne. Indlæggene bliver sorteret efter tidspunktet for opslag. Derfor vil det først skrevne indlæg være det første indlæg i det sammenflettede emne.';

$txt['set_sticky'] = 'Fastgør emnet';
$txt['set_nonsticky'] = 'Fastgør ikke længere emnet';
$txt['set_lock'] = 'Lås emnet';
$txt['set_unlock'] = 'Oplås emnet';

$txt['search_advanced'] = 'Avanceret søgning';

$txt['security_risk'] = 'STOR SIKKERHEDSRISIKO:';
$txt['not_removed'] = 'Du har ikke fjernet ';
$txt['not_removed_extra'] = '%1$s er en sikkerhedskopi af %2$s, der ikke blev genereret af SMF. Det kan tilgås direkte og bruges til at få uautoriseret adgang til forummet. Du bør slette den med det samme.';
$txt['generic_warning'] = 'Advarsel';
$txt['agreement_missing'] = 'Du kræver, at nye brugere accepterer en registreringsaftale; men filen (agreement.txt) eksisterer ikke.';
$txt['policy_agreement_missing'] = 'Du kræver, at nye brugere accepterer en privatlivspolitik men privatlivspolitikken er tom.';
$txt['auth_secret_missing'] = 'Kan ikke indstille godkendelseshemmeligheden i Settings.php. Dette svækker forummets sikkerhed og sætter det i fare for angreb. Tjek filtilladelserne på Settings.php for at sikre, at SMF kan skrive til filen.';

$txt['cache_writable'] = 'Den cachede mappe er ikke skrivbar - dette vil have betragtelig indflydelse på forummets ydeevne.';

$txt['page_created_full'] = 'Side oprettet på %1$.3f sekunder med %2$d forespørgsler.';

$txt['report_to_mod_func'] = 'Brug denne funktion til at informere moderatorer og administratorer om misbrug eller forkert placerede indlæg.';
$txt['report_profile_func'] = 'Brug denne funktion til at informere administratorerne om misbrug af profilindhold, såsom spam eller upassende billeder.';

$txt['online'] = 'Online';
$txt['member_is_online'] = '%1$s er online';
$txt['offline'] = 'Offline';
$txt['member_is_offline'] = '%1$s er offline';
$txt['pm_online'] = 'Personlig besked (Online)';
$txt['pm_offline'] = 'Personlig besked (Offline)';
$txt['status'] = 'Status';

$txt['go_up'] = 'Gå op';
$txt['go_down'] = 'Gå ned';

// argument(s): SMF_FULL_VERSION, SMF_SOFTWARE_YEAR, $scripturl
$forum_copyright = '<a href="%3$s?action=credits" title="License" target="_blank" rel="noopener">%1$s &copy; %2$s</a>, <a href="https://www.simplemachines.org" title="Simple Machines" target="_blank" rel="noopener">Simple Machines</a>';

$txt['birthdays'] = 'Fødselsdage:';
$txt['events'] = 'Begivenheder:';
$txt['birthdays_upcoming'] = 'Kommende fødselsdage:';
$txt['events_upcoming'] = 'Kommende begivenheder:';
// Prompt for holidays in the calendar, leave blank to just display the holiday's name.
$txt['calendar_prompt'] = 'Helligdage:';
$txt['calendar_month'] = 'Måned';
$txt['calendar_year'] = 'År';
$txt['calendar_day'] = 'Dag';
$txt['calendar_event_title'] = 'Titel på begivenhed';
$txt['calendar_event_options'] = 'Indstillinger for begivenheden';
$txt['calendar_post_in'] = 'Opret i';
$txt['calendar_edit'] = 'Redigér begivenhed';
$txt['calendar_export'] = 'Eksportér begivenhed';
$txt['calendar_view_week'] = 'Vis uge';
$txt['event_delete_confirm'] = 'Slet denne begivenhed?';
$txt['event_delete'] = 'Slet begivenhed';
$txt['calendar_post_event'] = 'Tilføj begivenhed';
$txt['calendar'] = 'Kalender';
$txt['calendar_link'] = 'Link til kalender';
$txt['calendar_upcoming'] = 'Kommende kalender';
$txt['calendar_today'] = 'Dagens kalender';
$txt['calendar_week'] = 'Uge';
$txt['calendar_week_title'] = 'Uge %1$d af %2$d';
// %1$s is the month, %2$s is the day, %3$s is the year. Change to suit your language.
$txt['calendar_week_beginning'] = 'Ugens start %2$s %1$s, %3$s';
$txt['calendar_numb_days'] = 'Antal dage';
$txt['calendar_how_edit'] = 'hvordan redigerer du disse begivenheder?';
$txt['calendar_link_event'] = 'Link begivenhed til indlæg';
$txt['calendar_confirm_delete'] = 'Er du sikker på, at du vil slette denne begivenhed?';
$txt['calendar_linked_events'] = 'Linkede begivenheder';
$txt['calendar_click_all'] = 'klik for at se alle %1$s';
$txt['calendar_allday'] = 'Hele dagen';
$txt['calendar_timezone'] = 'Tidszone';
$txt['calendar_list'] = 'Liste';
$txt['calendar_empty'] = 'Der er ingen begivenheder til at vise.';

$txt['movetopic_change_subject'] = 'Ændre emnets titel';
$txt['movetopic_new_subject'] = 'Ny titel';
$txt['movetopic_change_all_subjects'] = 'Ændre alle indlægs titler';
$txt['move_topic_unapproved_js'] = 'Advarsel! Dette emne er endnu ikke blevet godkendt.\n\nDet anbefales ikke, at du opretter et omdirigeringsemne, medmindre du har til hensigt, at godkende indlægget umiddelbart efter flytningen.';
$txt['movetopic_auto_board'] = '[BOARD]';
$txt['movetopic_auto_topic'] = '[TOPIC LINK]';

// argument(s): $txt['movetopic_auto_board'], $txt['movetopic_auto_topic']
$txt['movetopic_default'] = 'Dette emne er blevet flyttet til %1$s. %2$s';

$txt['movetopic_redirect'] = 'Viderestil til det flyttede emne';

$txt['post_redirection'] = 'Skriv et omdirigeringsemne';
$txt['redirect_topic_expires'] = 'Fjern automatisk omdirigeringsemnet';
$txt['mergetopic_redirect'] = 'Omdirigér til det flettede emne';
$txt['merge_topic_unapproved_js'] = 'Advarsel! Dette emne er endnu ikke blevet godkendt.\n\nDet anbefales ikke, at du opretter et omdirigeringsemne, medmindre du har til hensigt at godkende indlægget umiddelbart efter fletningen.';

$txt['theme_template_error'] = 'Kan ikke indlæse skabelonen \'%1$s\'.';
$txt['theme_language_error'] = 'Kan ikke indlæse sprogfilen \'%1$s\'.';

$txt['sub_boards'] = 'Undertavler';
$txt['restricted_board'] = 'Begrænset tavle';

$txt['smtp_no_connect'] = 'Kunne ikke forbinde til SMTP host';
$txt['smtp_port_ssl'] = 'SMTP-portindstilling forkert; det skal være 465 for SSL-servere. Hostnavn skal muligvis have ssl://-præfiks.';
$txt['smtp_bad_response'] = 'Kunne ikke hente mailserverens svarkoder';
$txt['smtp_error'] = 'Løb ind i problemer med at sende mail. Fejl: ';
$txt['mail_send_unable'] = 'Kan ikke sende mail til email adressen \'%1$s\'';

$txt['mlist_search'] = 'Søg efter brugere';
$txt['mlist_search_again'] = 'Søg igen';
$txt['mlist_search_filter'] = 'Søgeindstillinger';
$txt['mlist_search_email'] = 'Søg efter email adresse';
$txt['mlist_search_messenger'] = 'Søg efter Messenger kaldenavn';
$txt['mlist_search_group'] = 'Søg efter stilling';
$txt['mlist_search_name'] = 'Søg efter navn';
$txt['mlist_search_website'] = 'Søg efter webside';
$txt['mlist_search_results'] = 'Søgeresultater for';
$txt['mlist_search_by'] = 'Søg efter %1$s';
$txt['mlist_menu_view'] = 'Se brugerlisten';

$txt['attach_downloaded'] = 'downloadet %1$d gange';
$txt['attach_viewed'] = 'set %1$d gange';

$txt['settings'] = 'Indstillinger';
$txt['never'] = 'Aldrig';
$txt['more'] = 'mere';
$txt['etc'] = 'mv.';

$txt['hostname'] = 'Hostnavn';
$txt['you_are_post_banned'] = 'Beklager %1$s, du er bandlyst fra at skrive indlæg eller sende personlige beskeder i dette forum.';
$txt['ban_reason'] = 'Begrundelse';
$txt['select_item_check'] = 'Vælg venligst mindst ét element på listen';

$txt['tables_optimized'] = 'Databasetabellerne er optimeret';

$txt['add_poll'] = 'Tilføj afstemning';
$txt['poll_options_limit'] = 'Du kan kun vælge op til %1$s muligheder.';
$txt['poll_remove'] = 'Fjern afsteming';
$txt['poll_remove_warn'] = 'Er du sikker på, at du vil fjerne denne afsteming fra emnet?';
$txt['poll_results_expire'] = 'Resultatet vil blive vist, når afstemingen er lukket';
$txt['poll_expires_on'] = 'Afstemingen slutter';
$txt['poll_expired_on'] = 'Afstemingen er lukket';
$txt['poll_change_vote'] = 'Fjern stemme';
$txt['poll_return_vote'] = 'Indstillinger for afstemning';
$txt['poll_cannot_see'] = 'Du kan i øjeblikket ikke se resultatet af denne afstemning.';

$txt['quick_mod_approve'] = 'Godkend valgte';
$txt['quick_mod_remove'] = 'Fjern valgte';
$txt['quick_mod_lock'] = 'Lås/oplås valgte';
$txt['quick_mod_sticky'] = 'Fastgør/fjern fastgøring for valgte';
$txt['quick_mod_move'] = 'Flyt valgte til';
$txt['quick_mod_merge'] = 'Flet valgte';
$txt['quick_mod_markread'] = 'Markér valgte som læst';
$txt['quick_mod_markunread'] = 'Markér valgte som ulæst';
$txt['quick_mod_selected'] = 'Med de valgte muligheder gør';
$txt['quick_mod_go'] = 'Gå';
$txt['quickmod_confirm'] = 'Er du sikker på, at du vil gøre dette?';

$txt['spell_check'] = 'Stavekontrol';

$txt['quick_reply'] = 'Hurtig svar';
$txt['quick_reply_warning'] = 'Advarsel: Dette emne er i øjeblikket låst, kun administratorer og moderatorer kan svare.';
$txt['quick_reply_verification'] = 'Efter at have afsendt dit indlæg, vil du blive dirigeret til siden for indlæg, for at bekræfte dit indlæg %1$s.';
$txt['quick_reply_verification_guests'] = '(krævet for alle gæster)';
$txt['quick_reply_verification_posts'] = '(krævet for alle brugere med under %1$d indlæg)';
$txt['wait_for_approval'] = 'Bemærk: dette indlæg vises ikke før det er blevet godkendt af en moderator.';

$txt['notification_enable_board'] = 'Er du sikker på, at du vil aktivere meldinger om nye emner for denne tavle?';
$txt['notification_disable_board'] = 'Er du sikker på, at du vil deaktivere meldinger om nye emner for denne tavle?';
$txt['notification_enable_topic'] = 'Er du sikker på, at du vil aktivere meldinger om nye svar i dette emne?';
$txt['notification_disable_topic'] = 'Er du sikker på, at du vil deaktivere meldinger om nye svar i dette emne?';

// Mentions
$txt['mentions'] = 'Omtaler';

// Likes
$txt['likes'] = 'Synes godt om';
$txt['like'] = 'Synes godt om';
$txt['unlike'] = 'Synes ikke godt om';
$txt['like_success'] = 'Der blev syntes godt om dit indhold.';
$txt['like_delete'] = 'Dit indhold blev slettet.';
$txt['like_insert'] = 'Dit indhold blev indsat.';
$txt['like_error'] = 'Der opstod en fejl med din anmodning.';
$txt['like_disable'] = 'Synes godt om funktionen er deaktiveret.';
$txt['not_valid_like_type'] = 'Denne type er ikke gyldig.';
// Translators, if you need to make more strings to suit your language, e.g. $txt['likes_2'] = 'Two people like this', please do so.
$txt['likes_1'] = '<a href="%1$s">%2$s person</a> synes godt om dette.';
$txt['likes_n'] = '<a href="%1$s">%2$s personer</a> synes godt om dette.';
$txt['you_likes_0'] = 'Du synes godt om dette.';
$txt['you_likes_1'] = 'Du og <a href="%1$s">%2$s anden person</a> synes godt om dette.';
$txt['you_likes_n'] = 'Du og <a href="%1$s">%2$s andre personer</a> synes godt om dette.';

$txt['report_to_mod'] = 'Anmeld til moderator';
$txt['report_profile'] = 'Anmeld profil for %1$s';

$txt['unread_topics_visit'] = 'Nyeste ulæste emner';
// argument(s): scripturl
$txt['unread_topics_visit_none'] = 'Ingen ulæste emner fundet siden dit sidste besøg. <a href="%1$s?action=unread;all">Klik her for at prøve alle ulæste emner</a>.';
$txt['updated_topics_visit_none'] = 'Ingen opdaterede emner fundet siden dit sidste besøg.';
$txt['unread_topics_all'] = 'Alle ulæste emner';
$txt['unread_replies'] = 'Opdaterede emner';

$txt['who_title'] = 'Hvem er online';
$txt['who_and'] = ' og ';
$txt['who_viewing_topic'] = ' læser dette emne.';
$txt['who_viewing_board'] = ' læser denne tavle.';
$txt['who_member'] = 'Bruger';

// No longer used by default theme, but for backwards compat
$txt['powered_by_php'] = 'Drevet af PHP';
$txt['powered_by_mysql'] = 'Drevet af MySQL';
$txt['valid_css'] = 'Gyldig CSS';

$txt['rss'] = 'RSS';
$txt['atom'] = 'Atom';
$txt['html'] = 'HTML';

$txt['guest'] = 'Gæst';
$txt['guests'] = 'Gæster';
$txt['user'] = 'Bruger';
$txt['users'] = 'Brugere';
$txt['hidden'] = 'Skjult';

// Plural form of hidden for languages other than English
$txt['hidden_s'] = 'Skjult';
$txt['buddy'] = 'Ven';
$txt['buddies'] = 'Venner';
$txt['most_online_ever'] = 'Flest online';
$txt['most_online_today'] = 'Flest online i dag';

$txt['merge_select_target_board'] = 'Vælg måltavle for det sammenflettede emne';
$txt['merge_select_poll'] = 'Vælg hvilken afsteming det sammenflettede emne skal have';
$txt['merge_topic_list'] = 'Vælg emner, der skal sammenflettes';
$txt['merge_select_subject'] = 'Vælg overskriften til det sammenflettede emne';
$txt['merge_custom_subject'] = 'Ny overskrift';
$txt['merge_include_notifications'] = 'Inkludér abonnement på meddelelser?';
$txt['merge_check'] = 'Flet?';
$txt['merge_no_poll'] = 'Ingen afsteming';
$txt['merge_why'] = 'Indtast venligst en kort beskrivelse af, hvorfor disse emner bliver sammenflettet.';
$txt['merged_subject'] = '[MERGED] %1$s';
// argument(s): $txt['movetopic_auto_topic']
$txt['mergetopic_default'] = 'Dette emne er blevet flettet ind i %2$s.';

$txt['response_prefix'] = ' ';
$txt['current_icon'] = 'Nuværende ikon';
$txt['message_icon'] = 'Indlægsikon';

$txt['smileys_current'] = 'Nuværende smileysæt';
$txt['smileys_none'] = 'Ingen smileys';
$txt['smileys_forum_board_default'] = 'Forum/tavle-standard';

$txt['search_results'] = 'Søgeresultater';
$txt['search_no_results'] = 'Der blev desværre ikke fundet noget match';

$txt['total_time_logged_days'] = ' dage, ';
$txt['total_time_logged_hours'] = ' timer og ';
$txt['total_time_logged_minutes'] = ' minutter';
$txt['total_time_logged_d'] = 'd ';
$txt['total_time_logged_h'] = 'h ';
$txt['total_time_logged_m'] = 'm';

$txt['approve_members_waiting'] = 'Brugergodkendelser';

$txt['activate_code'] = 'Din aktiveringskode er';

$txt['find_members'] = 'Find brugere';
$txt['find_username'] = 'Navn, brugernavn eller email adresse';
$txt['find_buddies'] = 'Vis kun venner?';
$txt['find_wildcards'] = 'Tilladte jokertegn: *, ?';
$txt['find_no_results'] = 'Ingen resultater fundet';
$txt['find_results'] = 'Resultater';
$txt['find_close'] = 'Luk';

$txt['unread_since_visit'] = 'Vis ulæste indlæg siden sidste besøg.';
$txt['show_unread_replies'] = 'Vis nye svar på dine indlæg.';

$txt['change_color'] = 'Ændrer farve';

$txt['quickmod_delete_selected'] = 'Fjern valgte';
$txt['quickmod_split_selected'] = 'Opdel valgte';

$txt['show_personal_messages_heading'] = 'Nye beskeder';
$txt['show_personal_messages'] = 'Du har <strong>%1$s</strong> ulæste personlige beskeder i din indbakke.<br><br><a href="%2$s">Gå til din indbakke</a>';

$txt['help_popup'] = 'Lidt fortabt? Lad mig forklare:';

$txt['previous_next_back'] = 'Forrige emne';
$txt['previous_next_forward'] = 'Næste emne';

$txt['mark_unread'] = 'Markér som ulæst';

$txt['ssi_not_direct'] = 'Lav venligst ikke adgang til SSI.php via URL direkte. Brug hellere stien (%1$s) eller tilføj ?ssi_function=something.';
$txt['ssi_session_broken'] = 'SSI.php kunne ikke indlæse en session! Dette kan forårsage problemer med logout og andre funktioner - sørg venligst for, at SSI.php er inkluderet før *alt* andet i alle dine scripts!';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['preview_title'] = 'Forhåndsvis indlæg';
$txt['preview_fetch'] = 'Henter forhåndsvisning...';
$txt['preview_new'] = 'Ny besked';
$txt['pm_error_while_submitting'] = 'Følgende fejl opstod under afsendelse af denne personlige besked:';
$txt['error_while_submitting'] = 'Meddelelsen har følgende fejl, der skal rettes, før du fortsætter:';
$txt['error_old_topic'] = 'Advarsel: dette emne har ikke været aktivt i mindst %1$d dage.<br>Medmindre du er helt sikker på, at du vil svare, bør du overveje at starte et nyt emne.';

$txt['split_selected_posts'] = 'Valgte indlæg';
$txt['split_selected_posts_desc'] = 'Indlæggene herunder vil efter opdeling blive til et nyt emne.';
$txt['split_reset_selection'] = 'Nulstil valgene';

$txt['modify_cancel'] = 'Afbryd';
$txt['modify_cancel_all'] = 'Annullér alle';
$txt['mark_read_short'] = 'Markér som læst';

$txt['alerts'] = 'Meldinger';

$txt['pm_short'] = 'Beskeder';
$txt['pm_menu_read'] = 'Læs dine beskeder';
$txt['pm_menu_send'] = 'Send en besked';

$txt['unapproved_posts'] = 'Ikke-godkendte indlæg (Emner: %1$d, Indlæg: %2$d)';

$txt['ajax_in_progress'] = 'Indlæser...';

$txt['mod_reports_waiting'] = 'Anmeldte indlæg';

$txt['view_unread_category'] = 'Ulæste indlæg';
$txt['new_posts_in_category'] = 'Klik for at se de nye indlæg i %1$s';
$txt['verification'] = 'Bekræftigelse';
$txt['visual_verification_hidden'] = 'Lad venligst dette felt være tomt';
$txt['visual_verification_description'] = 'Skriv bogstaverne der vises i billedet';
$txt['visual_verification_sound'] = 'Lyt til bogstaverne';
$txt['visual_verification_request_new'] = 'Prøv et andet billede';

// Sub menu labels
$txt['summary'] = 'Resumé';
$txt['account'] = 'Kontoindstillinger';
$txt['theme'] = 'Udseende og layout';
$txt['forumprofile'] = 'Forumprofil';
$txt['activate_changed_email_title'] = 'Email adressen blev ændret';
$txt['activate_changed_email_desc'] = 'Du har ændret din email adresse. For at bekræfte denne adresse, vil du modtage en email. Klik på linket i den email for at genaktivere din konto.';
$txt['modSettings_title'] = 'Funktioner og indstillinger';
$txt['package'] = 'Pakkehåndtering';
$txt['errorlog'] = 'Fejllog';
$txt['edit_permissions'] = 'Tilladelser';
$txt['mc_unapproved_attachments'] = 'Ikke-godkendte vedhæftede filer';
$txt['mc_unapproved_poststopics'] = 'Ikke-godkendte indlæg og emner';
$txt['mc_reported_posts'] = 'Anmeldte indlæg';
$txt['mc_reported_members'] = 'Anmeldte brugere';
$txt['modlog_view'] = 'Moderationslog';
$txt['calendar_menu'] = 'Se kalender';

// @todo Send email strings - should move?
$txt['send_email'] = 'Send email';

$txt['ignoring_user'] = 'Du ignorerer denne bruger.';
$txt['show_ignore_user_post'] = 'Vis mig indlægget.';

$txt['spider'] = 'Søgerobot';
$txt['spiders'] = 'Søgerobotter';

$txt['downloads'] = 'Downloads';
$txt['filesize'] = 'Filstørrelse';

// Restore topic
$txt['restore_topic'] = 'Gendan emnet';
$txt['restore_message'] = 'Gendan';
$txt['quick_mod_restore'] = 'Gendan valgte';

// Editor prompt.
$txt['prompt_text_email'] = 'Angiv venligst email adressen.';
$txt['prompt_text_ftp'] = 'Angiv venligst ftp-adressen.';
$txt['prompt_text_url'] = 'Angiv venligst webadressen, du ønsker at linke til.';
$txt['prompt_text_img'] = 'Angiv lokationen for billedet';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['autosuggest_delete_item'] = 'Slet emnet';

// Debug related - when $db_show_debug is true.
$txt['debug_templates'] = 'Skabeloner:';
$txt['debug_subtemplates'] = 'Underskabeloner: ';
$txt['debug_language_files'] = 'Sprogfiler: ';
$txt['debug_stylesheets'] = 'Style-sheets: ';
$txt['debug_files_included'] = 'Filer inkluderet: ';
$txt['debug_memory_use'] = 'Hukommelse brugt: ';
$txt['debug_kb'] = 'kB.';
$txt['debug_show'] = 'vis';
$txt['debug_cache_hits'] = 'Cache hits: ';
$txt['debug_cache_misses'] = 'Cache mangler: ';
$txt['debug_cache_seconds_bytes'] = '%1$ss - %2$s bytes';
$txt['debug_cache_seconds_bytes_total'] = '%1$ss for %2$s bytes';
$txt['debug_queries_used'] = 'Forespørgsler brugt: %1$d. ';
$txt['debug_queries_used_and_warnings'] = 'Forespørgsler brugt: %1$d, %2$d advarsler.';
$txt['debug_query_in_line'] = 'i <em>%1$s</em> linie <em>%2$s</em>, ';
$txt['debug_query_which_took'] = 'hvilket tog %1$s sekunder.';
$txt['debug_query_which_took_at'] = 'hvilket tog %1$s sekunder ved %2$s til forespørgsler.';
$txt['debug_show_queries'] = '[Vis forespørgsler]';
$txt['debug_hide_queries'] = '[Skjul forespørgsler]';
$txt['debug_tokens'] = 'Tokens:';
$txt['debug_browser'] = 'Browser ID:';
$txt['debug_hooks'] = 'Hooks kaldt: ';
$txt['debug_instances'] = 'Forekomster oprettet:';
$txt['are_sure_mark_read'] = 'Er du sikker på, at du vil markere beskeder som læst?';

// Inline attachments messages.
$txt['attachments_not_enable'] = 'Vedhæftede filer er deaktiveret';
$txt['attachments_no_data_loaded'] = 'Ikke et gyldigt vedhæftet fil-id.';
$txt['attachments_not_allowed_to_see'] = 'Du kan ikke se denne vedhæftede fil.';
$txt['attachments_no_msg_associated'] = 'Ingen tekst er knyttet til denne vedhæftede fil.';
$txt['attachments_unapproved'] = 'Vedhæftet fil afventer godkendelse.';

// Accessibility
$txt['hide_category'] = 'Gem kategori';
$txt['show_category'] = 'Vis kategori';
$txt['hide_infocenter'] = 'Gem infocenter';
$txt['show_infocenter'] = 'Vis infocenter';

// Notification post control
$txt['notify_topic_0'] = 'Følger ikke';
$txt['notify_topic_1'] = 'Ingen meldinger eller emails';
$txt['notify_topic_2'] = 'Modtag meldinger';
$txt['notify_topic_3'] = 'Modtag emails og meldinger';
$txt['notify_topic_0_desc'] = 'Du modtager ingen emails eller meldinger om dette emne, og det vil heller ikke dukke op under ulæste svar eller emneliste. Du vil stadig modtage @omtaler fra dette emne.';
$txt['notify_topic_1_desc'] = 'Du modtager ikke emails eller meldinger, men kun @omtaler fra andre brugere.';
$txt['notify_topic_2_desc'] = 'Du modtager meldinger om dette emne.';
$txt['notify_topic_3_desc'] = 'Du modtager både emails og meldinger om dette emne.';
$txt['notify_board_1'] = 'Ingen emails eller meldinger';
$txt['notify_board_2'] = 'Modtag meldinger';
$txt['notify_board_3'] = 'Modtag emails og meldinger';
$txt['notify_board_1_desc'] = 'Du modtager ikke emails eller meldinger om nye emner';
$txt['notify_board_2_desc'] = 'Du modtager meldinger om denne tavle.';
$txt['notify_board_3_desc'] = 'Du modtager både emails og meldinger om denne tavle.';

$txt['notify_board_prompt'] = 'Vil du have en email, når nogen opretter et nyt emne i denne tavle?';
$txt['notify_board_subscribed'] = '%1$s er blevet abonnent på nye emnemeldinger i denne tavle.';
$txt['notify_board_unsubscribed'] = '%1$s er blevet afmeldt som abonnent på nye emnemeldinger i denne tavle.';

$txt['notify_topic_prompt'] = 'Vil du have en email, hvis nogen svarer på dette emne?';
$txt['notify_topic_subscribed'] = '%1$s er blevet abonnent på nye svarmeddelelser i denne kategori.';
$txt['notify_topic_unsubscribed'] = '%1$s er blevet afmeldt som abonnent på nye svarmeddelelser i denne kategori.';

$txt['notify_announcements_prompt'] = 'Ønsker du at modtage nyhedsbreve og vigtige meddelelser via email?';
$txt['notify_announcements_subscribed'] = '%1$s er blevet tilmeldt som abonnent på nyhedsbreve og vigtige meddelelser.';
$txt['notify_announcements_unsubscribed'] = '%1$s er blevet afmeldt som abonnent på nyhedsbreve og vigtige meddelelser.';

$txt['unsubscribe_announcements_plain'] = 'For at afmelde nyhedsbreve og vigtige meddelelser, følg venligst dette link: %1$s';
$txt['unsubscribe_announcements_html'] = '<span style="font-size:small"><a href="%1$s">Afmeld</a> nyhedsbreve og vigtige meddelelser.</span>';
$txt['unsubscribe_announcements_manual'] = 'For at afmelde forum nyhedsbreve og vigtige meddelelser, skal du kontakte os på %1$s med din anmodning.';

// Mobile Actions
$txt['mobile_action'] = 'Brugerhandlinger';
$txt['mobile_moderation'] = 'Moderering';
$txt['mobile_user_menu'] = 'Hovedmenu';
$txt['mobile_generic_menu'] = '%1$s Menu';

// Formats for lists in a sentence (e.g. "Alice, Bob, and Charlie")
// Examples:
// 	$txt['sentence_list_format'][2] specifies a format for a list with two items
// 	$txt['sentence_list_format']['n'] specifies the default format
// Notes on placeholders:
// 	{1} = first item in the list, {2} = second item, etc.
// 	{-1} = last item in the list, {-2} = second last item, etc.
// 	{series} = concatenated string of the rest of the items in the list
$txt['sentence_list_format'][1] = '{1}';
$txt['sentence_list_format'][2] = '{1} og {-1}';
$txt['sentence_list_format'][3] = '{series}, og {-1}';
$txt['sentence_list_format'][4] = '{series}, og {-1}';
$txt['sentence_list_format'][5] = '{series}, og {-1}';
$txt['sentence_list_format']['n'] = '{series}, og {-1}';
// Separators used to build lists in a sentence
$txt['sentence_list_separator'] = ', ';
$txt['sentence_list_separator_alt'] = '; ';

?>