<?php
// Version: 2.1.5; Help

global $helptxt, $scripturl;

$txt['close_window'] = 'Fermer la fenêtre';

$helptxt['manage_boards'] = '	<strong>Gestion des Sections et des Catégories</strong><br>
	Dans ce menu, vous pouvez créer/réorganiser/supprimer des sections et les catégories
	les concernant. Par exemple, si vous avez un gros site offrant des informations variées
	sur plusieurs sujets tels que &quot;Sports&quot; et &quot;Voitures&quot; et &quot;Musique&quot;, ces
	titres seraient ceux des catégories que vous créeriez. Sous chacune de ces catégories vous voudriez assurément insérer, de manière hiérarchique, des <em>sous-catégories</em>,
	ou &quot;sections&quot;, pour des sujets les concernant. C\'est une simple hiérarchie, avec cette structure&nbsp;: <br>
	<ul class="normallist">
		<li>
			<strong>Sports</strong>
			&nbsp;- Une &quot;catégorie&quot;
		</li>
		<ul class="normallist">
			<li>
				<strong>Baseball</strong>
				&nbsp;- Une section de la catégorie &quot;Sports&quot;
			</li>
			<ul class="normallist">
				<li>
					<strong>Stats</strong>
					&nbsp;- Une sous-section de la section &quot;Baseball&quot;
				</li>
			</ul>
			<li><strong>Football</strong>
			&nbsp;- Une section de la catégorie &quot;Sports&quot;</li>
		</ul>
	</ul>
	Les catégories vous permettent de séparer votre forum en différents sujets (&quot;Voitures,
	Sports&quot;), et les &quot;sections&quot; en dessous sont les sujets dans lesquels
	vos membres peuvent poster. Un utilisateur intéressé par les Twingo
	voudra poster un message dans &quot;Voitures->Twingo&quot;. Les catégories permettent aux gens
	de rapidement trouver ce qui les intéresse&nbsp;: au lieu d\'un &quot;Magasin&quot;, vous avez
	un &quot;Magasin d\'informatique&quot; et un &quot;Magasin de chaussures&quot; où vous pouvez aller. Cela simplifie
	votre recherche d\'un &quot;disque dur&quot;, parce que vous pouvez aller directement au &quot;Magasin d\'informatique&quot;
	plutôt qu\'au &quot;Magasin de chaussures&quot; (où vous ne trouverez sans doute pas votre disque dur ;) ).
	<br>
	Comme précisé plus haut, une section est un sujet clé sous une catégorie mère.
	Si vous voulez discuter de &quot;Twingo&quot;, vous irez à la catégorie &quot;Voitures&quot; et
	irez à la section &quot;Twingo&quot; pour y poster votre avis à propos de cette automobile.<br>
	Les fonctions administratives possibles ici sont de créer des nouvelles sections
	sous chaque catégorie, réordonner les sections (placer &quot;Twingo&quot; sous &quot;Renault&quot;), ou
	supprimer une section entièrement.';

$helptxt['edit_news'] = '	<ul class="normallist">
		<li>
			<strong>Nouvelles</strong><br>
			Cette partie vous permet de définir du contenu pour les news de la page d\'accueil.
			Mettez-y ce que vous voulez (par ex., &quot;Ne manquez pas la conférence de mardi prochain&quot;). Les news sont affichées de manière aléatoire et doivent être placées dans des boîtes séparées.
		</li>
		<li>
			<strong>Infolettres</strong><br>
			Cette partie vous permet d\'envoyer des newsletters (infolettres) aux membres du forum par message personnel ou e-mail. Choisissez d\'abord les groupes auxquels envoyer l\'infolettre, puis ceux dont vous ne voulez pas qu\'ils la reçoivent. Si vous le désirez, vous pouvez ajouter des membres et adresses e-mail individuellement. Enfin, mettez le contenu du message à envoyer, et choisissez le type d\'envoi (message personnel sur le forum, ou e-mail).
		</li>
		<li>
			<strong>Paramètres</strong><br>
				Cette partie contient des réglages liés aux news et aux infolettres, par exemple le choix des groupes qui peuvent modifier les news ou envoyer des infolettres. Vous pouvez également paramétrer l\'activation des flux RSS sur le forum, mais aussi choisir la longueur maximale des messages (en caractères) dans ces mêmes flux RSS.
		</li>
	</ul>';

$helptxt['view_members'] = '
	<ul class="normallist">
		<li>
			<strong>Voir tous les membres</strong><br>
			Affichez tous les membres du forum. Une liste hyperliée de noms de membres vous est présentée. Vous pouvez cliquer
			sur n\'importe lequel des noms pour trouver des détails sur les membres (page d\'accueil, âge, etc.), et en tant qu\'administrateur
			vous avez la possibilité de modifier ces paramètres. Vous avez un contrôle total sur les membres, y compris la
			possibilité de les supprimer du forum.<br><br>
		</li>
		<li>
			<strong>En attente d\'approbation</strong><br>
			Cette page ne s\'affiche que si vous avez activé l\'approbation par l\'administrateur de toutes les nouvelles inscriptions. Toute personne qui s\'inscrit pour rejoindre votre
			forum ne deviendra un membre à part entière que lorsqu\'il aura été approuvé par un administrateur. Cette page liste tous les membres qui
			qui sont toujours en attente d\'approbation, ainsi que leur adresse électronique et leur adresse IP. Vous pouvez choisir d\'accepter ou de rejeter (supprimer)
			tout membre de la liste en cochant la case à côté du membre et en choisissant l\'action dans la liste déroulante en bas de la page.
			de la page. Lors du rejet d\'un membre, vous pouvez choisir de supprimer le membre avec ou sans le notifier de votre décision.<br><br>
		</li>
		<li>
			<strong>Attente de l\'activation</strong><br>.
			Cette page ne sera visible que si vous avez activé l\'activation par email des comptes des nouveaux membres sur le forum. Cette page listera tous les
			membres qui n\'ont pas encore activé leur nouveau compte. À partir de cette page, vous pouvez choisir d\'accepter, de rejeter ou de rappeler
			les membres dont l\'inscription est en suspens. Comme ci-dessus, vous pouvez également choisir d\'envoyer un e-mail au membre pour l\'informer de la
			action que vous avez prise.<br><br>
		</li>
	</ul>';

$helptxt['ban_members'] = '<strong>Bannir des membres</strong><br>
	SMF offre la possibilité de &quot;bannir&quot; des utilisateurs, afin d\'empêcher le retour de personnes ayant dérangé
	l\'atmosphère de votre forum par du pollupostage (spamming), des déviations de sujets (trolling), etc. En tant qu\'administrateur,
	lorsque vous voyez un message, vous pouvez voir l\'adresse IP du posteur au moment de l\'envoi du message incriminé. Dans la liste de bannissement,
	vous entrez simplement cette adresse IP, sauvegardez, et l\'utilisateur banni ne pourra plus poster depuis son ordinateur. <br>Vous pouvez aussi
	bannir des gens par leur adresse e-mail.';

$helptxt['featuresettings'] = '<strong>Modifier les Options et Fonctionnalités</strong><br>
	Il y a plusieurs fonctionnalités dans cette section qui peuvent être changées à votre préférence.';

$helptxt['modsettings'] = '<strong>Modifier les Caractéristiques et les Options</strong><br>
	Plusieurs options peuvent être modifiées ici selon vos préférences. Les options pour les modifications (mods) installées vont généralement apparaître ici.';

$helptxt['time_format'] = '<strong>Format de l\'heure</strong><br>
	Vous avez la possibilité d\'ajuster la manière dont le temps et les dates seront affichés sur votre forum. Il y a beaucoup de lettres, mais c\'est relativement simple. La convention d\'écriture s\'accorde avec celle de la fonction strftime de PHP et est décrite ci-dessous (plus de détails peuvent être trouvés sur <a href="https://www.php.net/manual/fr/function.strftime.php" target="_blank" rel="noopener">php.net</a>).<br>
	<br>
	Les caractères suivants sont reconnus en tant qu\'entrées dans la chaîne du format de l\'heure&nbsp;: <br>
	<span class="smalltext">
	&nbsp;&nbsp;%a - Nom du jour (abrégé)<br>
	&nbsp;&nbsp;%A - Nom du jour (complet)<br>
	&nbsp;&nbsp;%b - Nom du mois (abrégé)<br>
	&nbsp;&nbsp;%B - Nom du mois (complet)<br>
	&nbsp;&nbsp;%d - Jour du mois (01 à 31)<br>
	&nbsp;&nbsp;%D - La même chose que %m/%d/%y *<br>
	&nbsp;&nbsp;%e - Jour du mois (1 à 31) *<br>
	&nbsp;&nbsp;%H - Heure au format 24 heures (de 00 à 23)<br>
	&nbsp;&nbsp;%I - Heure au format 12 heures (de 01 à 12)<br>
	&nbsp;&nbsp;%m - Numéro du mois (01 à 12)<br>
	&nbsp;&nbsp;%M - Minutes en chiffres<br>
	&nbsp;&nbsp;%p - Met &quot;am&quot; ou &quot;pm&quot; selon la période de la journée<br>
	&nbsp;&nbsp;%R - Heure au format 24 heures *<br>
	&nbsp;&nbsp;%S - Secondes en chiffres<br>
	&nbsp;&nbsp;%T - Temps en ce moment, la même chose que %H:%M:%S *<br>
	&nbsp;&nbsp;%y - Année au format 2 chiffres (00 to 99)<br>
	&nbsp;&nbsp;%Y - Année au format 4 chiffres<br>
	&nbsp;&nbsp;%% - Le symbole \'%\' en lui-même<br>
	<br />
	<em>* Ne fonctionnent pas sur les serveurs Windows.</em></span>';

$helptxt['live_news'] = '<strong>En direct de Simple Machines</strong><br />
	Cette boîte affiche les dernières dépêches en provenance de <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a>.
	Vous devriez y surveiller les annonces concernant les mises à jour, nouvelles versions de SMF et informations importantes de Simple Machines.';

$helptxt['registrations'] = '<strong>Gestion des inscriptions</strong><br>
	Cette section contient toutes les fonctions nécessaires pour la gestion des nouvelles inscriptions sur votre forum. Elle peut contenir jusqu\'à quatre
	rubriques, visibles selon vos paramètres de forum. Celles-ci sont détaillés ci-dessous&nbsp;:<br><br>
	<ul class="normallist">
		<li>
			<strong>Inscrire un nouveau membre</strong><br>
			À partir de cet écran, vous pouvez inscrire un nouveau membre à sa place. Cette option peut être utile lorsque les nouvelles inscriptions sur le forum sont désactivées,
			ou lorsque l\'administrateur souhaite se créer un compte de test. Si l\'activation du nouveau compte par le membre est sélectionnée,
			le nouveau membre recevra un e-mail contenant un lien d\'activation, sur lequel il devra cliquer avant de pouvoir utiliser son compte. De même, vous pouvez choisir d\'envoyer
			le nouveau mot de passe à l\'adresse e-mail spécifiée.
		</li>
			<strong>Modifier l\'accord d\'inscription</strong><br>
			Ceci vous permet de spécifier le texte de l\'accord d\'inscription affiché lors de l\'inscription d\'un membre sur votre forum.
			Vous pouvez ajouter ou enlever ce que vous souhaitez au contrat d\'enregistrement inclus dans SMF.<br><br>
		</li>
		<li>
			<strong>Choisir les noms réservés</strong><br>
			En utilisant cette interface, vous pouvez spécifier des mots ou des noms qui ne seront pas utilisés librement par vos membres comme identifiants ou pseudonymes.<br><br>
		</li>
		<li>
			<strong>Paramètres</strong><br>
			Cette section ne sera visible que si vous avez la permission d\'administrer le forum. Depuis cette interface, vous pouvez choisir la méthode d\'inscription
			en vigueur sur votre forum et configurer quelques autres réglages relatifs à l\'inscription.
		</li>
	</ul>';

$helptxt['modlog'] = '<strong>Journal de Modération</strong><br />
Cette section permet à l\'équipe de modération de suivre toutes les actions de modération effectuées par les modérateurs du forum. Notez que l\'effacement du journal sera enregistré pour éviter tout abus.';
$helptxt['adminlog'] = '<strong>Journal d\'Administration</strong><br>
Cette section permet aux membres de l\'équipe d\'administration de pister les actions effectuées par tout administrateur sur le forum. Afin que les administrateurs ne puissent enlever les références aux actions entreprises, les entrées ne pourront être supprimées que 24 heures après leur application.';
$helptxt['userlog'] = '<strong>Journal de Modifications du Profil</strong><br>Cette page permet aux membres de l\'équipe d\'administration de voir les changements apportés par les utilisateurs à leur profil, elle est accessible à partir de la gestion du profil de chaque utilisateur.';
$helptxt['warning_enable'] = '<strong>Système d\'avertissement utilisateur</strong><br>
Cette fonctionnalité permet aux membres des équipes d\'administration et de modération d\'envoyer des avertissements aux utilisateurs, et d\'utiliser un niveau d\'avertissement pour déterminer leurs actions possibles au niveau du forum. Après avoir activé cette fonctionnalité, un nouveau paramètre sera disponible dans les permissions par section pour définir quels groupes pourront assigner des avertissements aux utilisateurs. Les niveaux d\'avertissement pourront être ajustés à partir du profil des utilisateurs.';
$helptxt['warning_watch'] = 'Ce paramètre définit le niveau d\'avertissement en pourcentage qu\'un membre doit atteindre pour assigner automatiquement une &quot;surveillance&quot; au membre concerné. Tout membre qui est &quot;surveillé&quot; apparaîtra dans la liste des membres surveillés dans le centre de modération.';
$helptxt['warning_moderate'] = 'Tout membre qui dépasse la valeur de ce paramètre verra que tous ses messages nécessitent l\'approbation du modérateur avant d\'apparaître dans le forum. Ceci annulera toutes les permissions locales du forum qui pourraient exister en rapport avec la modération.';
$helptxt['warning_mute'] = 'Si ce niveau d\'alerte est dépassé par un membre, il se retrouvera banni. Le membre perdra tous ses droits lui permettant de poster des messages.';
$helptxt['user_limit'] = 'Ce paramètre limite le nombre de points qu\'un modérateur peut ajouter/supprimer à un membre sur une période de vingt-quatre heures. Ceci peut être utilisé pour limiter ce que peut faire un modérateur dans une petite période de temps. Cette fonction peut être désactivée en la mettant à zéro. Notez que les membres ayant des droits d\'administrateur ne sont pas affectés par cette valeur.';

$helptxt['error_log'] = '<strong>Journal d\'Erreurs</strong><br>
	Le journal d\'erreurs conserve des traces de toutes les erreurs sérieuses rencontrées lors de l\'utilisation de votre forum. Il liste toutes les erreurs par date, qui peuvent être récupérées
	en cliquant sur la flèche noire accompagnant chaque date. De plus, vous pouvez filtrer les erreurs en sélectionnant l\'image accompagnant les statistiques des erreurs. Ceci
	vous permet, par exemple, de filtrer les erreurs par nom de membre. Lorsqu\'un filtre est actif les seuls résultats affichés seront ceux correspondants aux critères du filtre.';
$helptxt['theme_settings'] = '<strong>Réglages du Thème</strong><br>
L\'écran des réglages vous permet de modifier certains réglages spécifiques à un thème. Ces réglages incluent des options telles que le répertoire du thàme et l\'URL du thème, mais aussi des options affectant le rendu à l\'écran de votre forum. La plupart des thèmes possédent une variété d\'options configurables par l\'utilisateur, vous permettant d\'adapter un thème à vos besoins individuels.';
$helptxt['smileys'] = '<strong>Gestionnaire de smileys</strong><br>
	Ici, vous pouvez ajouter et supprimer des smileys et des jeux de smileys. Note importante&nbsp;: si un smiley est présent dans un jeu, il l\'est aussi dans tous les autres - 		autrement, cela pourrait prêter à confusion pour les utilisateurs utilisant des jeux différents.<br><br>
	Vous pouvez aussi modifier les icônes de message depuis cette interface, si vous les avez activés sur la page des paramètres.';
$helptxt['calendar'] = '<strong>Gérer le calendrier</strong><br>
	Ici vous pouvez modifier les réglages courants du calendrier, ou ajouter et supprimer des fêtes qui apparaissent dans le calendrier.';
$helptxt['cal_export'] = 'Exporte un fichier texte au format iCal pour importer vers d\'autres applications de calendrier';
$helptxt['cal_highlight_events'] = 'Ce paramètre vous permet de mettre en surbrillance les événements sur les Mini-Calendriers, le Calendrier Principal, les deux ou de désactiver la mise en surbrillance de ces événements.
';
$helptxt['cal_highlight_holidays'] = 'Ce paramètre vous permet de mettre en surbrillance les jours de fêtes sur les Mini-calendriers, le Calendrier Principal, les deux ou de désactiver la mise en surbrillance de ces événements.
';
$helptxt['cal_highlight_birthdays'] = 'Ce paramètre vous permet de mettre en surbrillance les anniversaires sur les Mini-Calendriers, le Calendrier Principal, les deux ou de désactiver la mise en surbrillance de ces événements.
';
$helptxt['cal_disable_prev_next'] = 'Si ce paramètre est coché, les blocs de trois mois sur le côté gauche de la page seront désactivés.';
$helptxt['cal_display_type'] = 'Ce paramètre vous permet de changer le type d\'affichage du calendrier.<br><br><strong>Confortable :</strong> rend les lignes du calendrier grandes.<br><strong>Compacte :</strong> rend les lignes du calendrier petites.
';
$helptxt['cal_week_links'] = 'Si ce paramètre est coché, les liens seront ajoutés à côté de chaque semaine dans le calendrier.';
$helptxt['cal_prev_next_links'] = 'Si ce paramètre est coché, les liens du mois précédent et du mois suivant seront ajoutés en haut de chaque mois pour faciliter la navigation.';
// argument(s): $txt['months_short'][1], $txt['months_titles'][1]
$helptxt['cal_short_months'] = 'Si ce paramètre est coché, le nom de chaque mois dans le calendrier sera raccourcis.<br><br><strong>Activé :</strong> %1$s 1<br><strong>Désactivé :</strong> %2$s 1';
// argument(s): $txt['days_short'][1], $txt['days'][1]
$helptxt['cal_short_days'] = 'Si ce paramètre est coché, le nom de chaque jour dans le calendrier sera raccourcis.<br><br><strong>Activé&nbsp;:</strong> %1$s<br><strong>Désactivé&nbsp;:</strong> %2$s';

$helptxt['serversettings'] = '<strong>Paramètres Serveur</strong><br>
	Ici, vous pouvez régler la configuration de votre serveur. Cette section comprend la base de données et les chemins des dossiers, ainsi que d\'autres
	options de configuration importantes tels que les paramètres d\'e-mail et de cache. Faites attention lors de la modification de ces paramètres,
	ils pourraient rendre le forum inaccessible';
$helptxt['manage_files'] = '	<ul class="normallist">
		<li>
			<strong>Parcourir les Fichiers</strong><br>
			Parcourir à travers tous les fichiers joints, avatars et miniatures stockés par SMF.<br><br>
		</li><li>
			<strong>Réglages des Fichiers Joints</strong><br>
			Configurer où sont stockés les fichiers joints et mettre les restrictions sur les types de fichiers joints.<br><br>
		</li><li>
			<strong>Réglages des Avatars</strong><br>
			Configurer où sont stockés les avatars et gérer le redimensionnement des avatars.<br><br>
		</li><li>
			<strong>Maintenance des Fichiers</strong><br>
			Contrôler et réparer toute erreur dans le répertoire des fichiers joints et effacer les fichiers joints sélectionnés.<br><br>
		</li>
	</ul>';

$helptxt['topicSummaryPosts'] = 'Ceci vous permet de régler le nombre de messages précédemment postés affichés dans le sommaire du sujet sur l\'écran de réponse à un sujet.';
$helptxt['enableAllMessages'] = 'Mettez ici le nombre <em>maximum</em> de messages qu\'un sujet aura lors de l\'affichage par le lien &quot;Tous&quot;. Le régler au-dessous du &quot;Nombre de messages à afficher lors du visionnement d\'un sujet:&quot; signifiera simplement que le lien ne sera jamais affiché, et indiquer une valeur trop élevée peut ralentir votre forum.';
$helptxt['allow_guestAccess'] = 'Décocher cette option limitera les actions possibles des invités aux seules opérations de base - connexion, inscription, rappel du mot de passe, etc. - sur votre forum. Ce n\'est pas comme désactiver l\'accès aux sections pour les invités.';
$helptxt['userLanguage'] = 'Activer cette option permettra aux utilisateurs de sélectionner la langue dans laquelle le forum leur sera affiché.
Cela n\'affectera pas la langue par défaut.';
$helptxt['trackStats'] = 'Stats&nbsp;:<br>Ceci permettra aux visiteurs de voir les derniers messages postés et les sujets les plus populaires sur votre forum.
	Cela affichera aussi plusieurs autres statistiques, comme le record d\'utilisateurs en ligne au même moment, les nouveaux membres et les nouveaux sujets.<hr>
	Pages vues&nbsp;:<br>Ajoute une autre colonne à la page des statistiques contenant le nombre de pages vues sur votre forum.';
$helptxt['titlesEnable'] = 'Activer les titres personnels permettra aux membres possédant les permissions suffisantes de s\'attribuer un titre spécial pour eux-mêmes.
		Il sera affiché sous leur pseudonyme.<br><em>Par exemple :</em><br>Jeff<br>Oui, c\'est moi';
$helptxt['onlineEnable'] = 'Ceci affichera une image indiquant si l\'utilisateur est connecté ou non en ce moment.';
$helptxt['todayMod'] = 'Cette option affichera &quot;Aujourd\'hui&quot; ou &quot;Hier&quot; à la place de la date.<br><br>
		<strong>Exemples&nbsp;:</strong><br><br>
		<ul class="normallist">
			<li> <strong>Désactivé</strong><br> 3 Octobre 2009 à 00:59:18</li>
			<li><strong>Seulement Aujourd\'hui</strong><br> Aujourd\'hui à 00:59:18</strong></li>
			<li><strong>Aujourd\'hui &amp; Hier</strong><br> Hier à 21:36:55</li>
		</ul>';
$helptxt['disableCustomPerPage'] = 'Cocher cette option pour empêcher les utilisateurs de personnaliser le nombre de messages et de sujets par page à afficher, respectivement sur l\'index des messages et la page d\'affichage du sujet.';
$helptxt['enablePreviousNext'] = 'Cette option affichera un lien vers le sujet précédent et le sujet suivant.';
$helptxt['pollMode'] = 'Ceci détermine si les sondages sont activés ou non. Si les sondages sont désactivés, tous les sondages actuels sont cachés sur la liste des sujets. Vous pouvez choisir de continuer à afficher la partie sujet des sondages en sélectionnant &quot;Montrer les sondages existants comme des sujets&quot;.<br><br>Pour choisir qui peut poster et voir des sondages et similaires, vous pouvez autoriser ou refuser ces permissions. Rappelez-vous de ceci si les sondages sont désactivés.';
$helptxt['enableCompressedOutput'] = 'Cette option compressera les données envoyées, afin de diminuer la consommation de bande passante, mais requiert que zlib soit installé sur le serveur.';
$helptxt['httponlyCookies'] = 'Les cookies ne seront pas accessibles par des langages de script tels que JavaScript. Ce paramètre peut aider à réduire le vol d\'identité par le biais d\'attaques XSS. Cela peut causer des problèmes avec les scripts tiers mais devrait être activé dans la mesure du possible.
';
$helptxt['samesiteCookies'] = 'The SameSite attribute of the Set-Cookie HTTP response header allows you to declare if your cookie should be restricted to a first-party or same-site context. For further information, please refer to <a href="https://developer.mozilla.org/docs/Web/HTTP/Headers/Set-Cookie/SameSite">MDN</a>';
$helptxt['databaseSession_enable'] = 'Cette fonction utilise la base de données pour le stockage des sessions - c\'est mieux pour des serveurs à charge balancée, mais aide à régler tous les problèmes de fin de session indésirée et peut aider le forum à fonctionner plus rapidement.';
$helptxt['databaseSession_loose'] = 'Activer cette option diminuera la bande passante utilisée par le forum, et fait en sorte que lorsque l\'utilisateur revient sur ses pas, la page n\'est pas rechargée - le point négatif de cette option est que les (nouvelles) icônes ne seront pas mises à jour, ainsi que quelques autres choses. (Sauf si vous rechargez cette page plutôt que de retourner sur vos pas.)';
$helptxt['databaseSession_lifetime'] = 'Ceci est le temps en secondes au bout duquel la session se termine automatiquement après le dernier accès de l\'utilisateur. Si une session n\'a pas été accédée depuis trop longtemps, un message &quot;Session terminée&quot; est affiché. Tout ce qui est au-dessus de 2400 secondes est recommandé.';
$helptxt['tfa_mode'] = 'Vous pouvez ajouter un deuxième niveau de sécurité à votre forum en activant le <a href="https://en.wikipedia.org/wiki/Two_factor_authentication">Deuxième-Facteur d\'Authentication</a>. 2FA oblige vos utilisateurs à ajouter un code généré par un mobile après l\'ouverture de session régulière. Vous devez configurer 2FA pour vous-même avant de pouvoir le forcer à d\'autres utilisateurs&nbsp;!';
$helptxt['cache_enable'] = 'SMF gère plusieurs niveaux de cache. Plus le niveau de cache activé est élevé, plus le CPU prendra de temps pour récupérer les informations cachées. Si le cache est disponible sur votre machine, il est recommandé que vous essayiez le niveau 1 en premier.';
$helptxt['cache_memcached'] = 'Veuillez noter que l\'utilisation de memcached nécessite que vous donniez quelques indications sur votre serveur dans les réglages à effectuer ci-dessous. Elles doivent être entrées sous forme de liste, dont les éléments sont séparés par une virgule, comme dans l\'exemple suivant :
<br><br> &quot;"serveur1,serveur2,serveur3:port,serveur4"&quot;<br><br>
Notez que si aucun port n\'est spécifié, SMF utilisera le port 11211 à moins que l\'hôte ne contienne une barre oblique, alors il est supposé être un transport alternatif et le port sera mis à 0. SMF équilibrera de manière aléatoire la charge sur les serveurs. 

';
$helptxt['cache_cachedir'] = 'Ce paramètre n\'est valable que pour le système de cache à base de fichiers smf. Il spécifie le chemin d\'accès au répertoire du cache. Il est recommandé de placer ceux-ci dans le répertoire /tmp/ si vous désirez les utiliser, bien qu\'ils puissent fonctionner dans n\'importe quel répertoire
';
$helptxt['cache_sqlite_cachedir'] = 'Ce paramètre n\'est valable que pour le système de cache de la base de données SQLite. Il spécifie le chemin d\'accès au répertoire du cache. Il est recommandé de placer ceux-ci dans le répertoire /tmp/ si vous désirez les utiliser, bien qu\'ils puissent fonctionner dans n\'importe quel répertoire
';
$helptxt['enableErrorLogging'] = 'Ceci indexera toutes les erreurs rencontrées, comme les connexions non réussies, afin que vous puissiez les consulter lorsque quelque chose ne va pas.';
$helptxt['enableErrorQueryLogging'] = 'Ceci incluera la requête complète envoyée à la base de données lors d\'une erreur de cette dernière, dans le journal d\'erreurs. Requiert l\'activation du journal d\'erreurs.<br><br><strong>Attention, cela modifiera la capacité de filtrage du journal d\'erreurs par message d\'erreur.</strong>';
$helptxt['disallow_sendBody'] = 'Cette option supprime l\'option permettant de recevoir le texte des réponses et les messages dans les e-mails de notification.<br><br>Souvent, les membres vont répondre à l\'e-mail de notification, ce qui peut saturer, dans bien des cas, la boîte e-mail du webmestre.';
$helptxt['enable_ajax_alerts'] = 'Cette option permet à vos membres de recevoir des notifications AJAX. Cela signifie que les membres n\'ont pas besoin de rafraîchir la page pour obtenir de nouvelles notifications.<br><strong> REMARQUE :</strong> Cette option peut causer une charge importante sur votre serveur avec de nombreux utilisateurs en ligne.
';
$helptxt['alerts_auto_purge'] = 'Une fois qu\'une alerte a été lue, elle est rarement nécessaire à nouveau. Pour des raisons de performances, il est judicieux de les supprimer automatiquement après un certain temps.';
$helptxt['jquery_source'] = 'This will determine the source used to load the jQuery Library. <em>Google CDN, jQuery CDN</em> and <em>Microsoft CDN</em> will load the jQuery library from those respective CDN networks. <em>Local</em> will only use the local source. <em>Custom</em> allows you to specify a custom URL for the library.';
$helptxt['compactTopicPagesEnable'] = 'Ceci est le nombre de pages intermédiaires à afficher lors du visionnement d\'un sujet.<br><em>Exemple&nbsp;:</em>
		&quot;3&quot; pour afficher&nbsp;: 1 ... 4 [5] 6 ... 9 <br>
		&quot;5&quot; pour afficher&nbsp;: 1 ... 3 4 [5] 6 7 ... 9';
$helptxt['timeLoadPageEnable'] = 'Ceci affichera au bas du forum le temps en secondes utilisé par SMF pour générer la page en cours.';
$helptxt['removeNestedQuotes'] = 'Ceci effacera les citations imbriquées dans les messages que vous citez en cliquant sur le bouton Citer.';
$helptxt['max_image_width'] = 'Cette option vous permet de spécifier une taille maximale pour les images postées. Les images plus petites ne seront pas affectées.';
$helptxt['mail_type'] = 'Cette option vous permet d\'utiliser soit le réglage par défaut de PHP ou de l\'outrepasser en utilisant le protocole SMTP. PHP ne supporte pas l\'authentification (que plusieurs FAI requièrent maintenant) donc vous devriez vous renseigner avant d\'utiliser cette option. Notez que SMTP peut être plus lent et que certains serveurs ne prendront pas en compte les identifiants et mot de passe.<br><br>Vous n\'avez pas à renseigner les informations SMTP si vous utilisez la configuration par défaut de PHP.';
$helptxt['attachment_manager_settings'] = 'Les fichiers joints sont des fichiers que les membres peuvent télécharger et joindre à un message. Différents sites peuvent les utiliser de différentes manières, que vous pouvez configurer ici.';
$helptxt['attachmentCheckExtensions'] = 'Pour certaines communautés, vous pouvez limiter les types de fichiers que les utilisateurs peuvent télécharger en cochant leur extension. Par exemple&nbsp;: myphoto.jpg a une extension jpg.';
// References setting attachmentCheckExtensions
$helptxt['attachmentExtensions'] = 'Si l\'extension des fichiers joints ci-dessus est cochée, ce sont ces extensions qui seront autorisées pour les nouveaux fichiers joints.';
$helptxt['attachmentUploadDir'] = 'Le chemin vers le répertoire des fichiers joints se trouvant sur le serveur<br />(exemple&nbsp;: /home/sites/yoursite/www/forum/attachments)';
$helptxt['attachmentDirSizeLimit'] = 'Sélectionnez de quelle taille le répertoire des fichiers joints peut t\'il être, en incluant tous les fichiers contenus.';
$helptxt['attachmentPostLimit'] = 'Sélectionnez la taille maximale (en Ko) de toutes les fichiers joints par message. Si cette limite est inférieure à la limite par fichier joint, la limite sera atteinte.';
$helptxt['attachmentSizeLimit'] = 'Sélectionnez la taille maximale de chaque fichier joint séparément.';
$helptxt['attachmentNumPerPostLimit'] = 'Sélectionnez le nombre de fichiers joints qu\'une personne peut mettre par message.';
$helptxt['attachmentShowImages'] = 'Si le fichier uploadé est une image, elle sera affichée sous le message.';
$helptxt['attachmentThumbnails'] = 'Si l\'option au-dessus est sélectionnée, cela sauvegardera une copie (plus petite) du fichier joint pour la miniature afin d\'économiser la bande passante.';
$helptxt['attachmentThumbWidth'] = 'Seulement utilisé avec l\'option &quot;Redimensionner les images quand affichées sous les messages&quot;. Spécifie la largeur maximale des miniatures créées pour les fichiers joints. Elles seront redimensionnées proportionnellement.';
$helptxt['attachmentThumbHeight'] = 'Seulement utilisé avec l\'option &quot;Redimensionner les images quand affichées sous les messages&quot;. Spécifie la hauteur maximale des miniatures créées pour les fichiers joints. Elles seront redimensionnées proportionnellement.';
$helptxt['attachmentDirFileLimit'] = 'Nombre maximum de fichiers par répertoire';
$helptxt['attachmentEnable'] = 'Ce paramètre vous permet de configurer la façon dont les fichiers joints peuvent être créés.<br><br>
	<ul class="normallist">
		<li> <strong>Désactiver tous les fichiers joints</strong><br>
		Tous les fichiers joints sont désactivés. Les fichiers joints existants ne sont pas supprimés, mais ils sont masqués (même les administrateurs ne peuvent pas les voir). Les nouveaux fichiers joints ne peuvent pas non plus être créés, quelles que soient les permissions. <br><br> </li>
		<li><strong>Activer toutes les fichiers joints</strong><br>
		Tout fonctionne normalement, les utilisateurs autorisés à voir les fichiers joints peuvent le faire, les utilisateurs autorisés à les télécharger peuvent le faire.<br><br> </li>
		<li><strong>Désactiver les nouveaux fichiers joints</strong><br>
		Les fichiers joints existants sont toujours accessibles, mais aucun nouveau fichier joint ne peut être ajouté, indépendamment des permissions.</li> </ul>';
$helptxt['attachment_image_paranoid'] = 'Choisissez cette option pour mettre en place des contrôles de sécurité très stricts sur les images envoyées en fichier joint. <strong>Attention&nbsp;!</strong> Ces contrôles peuvent parfois échouer sur des images sans danger. Nous vous recommandons de ne l\'utiliser qu\'en association avec l\'option de réencodage, auquel cas SMF essaiera de recréer et de mettre en ligne des images saines si le contrôle échoue. Si le réencodage n\'est pas activé, les fichiers joints échouant au contrôle seront rejetés.';
$helptxt['attachment_image_reencode'] = 'Choisissez cette option pour permettre le réencodage des fichier joints envoyés par les utilisateurs. Le réencodage vous garantit une meilleure sécurité, mais il supprime également les animations des images animées.<br>Cette fonctionnalité n\'est disponible que si le module GD est installé sur votre serveur.';
$helptxt['attachment_thumb_memory'] = 'Plus l\'image source est grande (taille et largeur x hauteur), plus la mémoire requise est importante pour que le système réussisse à créer une image miniature. <br>Vérifier ce paramètre, car le système estimera la mémoire requise et demandera ensuite cette quantité. En cas de succès, ce n\'est qu\'à ce moment-là qu\'il tentera de créer la miniature.<br>Cela entraînera moins d\'erreurs dans les pages, mais peut entraîner la création de miniatures en moins. Si vous ne cochez pas cette case, le système essaiera toujours de créer la vignette (avec une quantité fixe de mémoire). Cela peut entraîner un plus grand nombre d\'erreurs dans les pages.';
$helptxt['attachmentRecodeLineEndings'] = 'Le script ré-encodera les fins de ligne en fonction de votre serveur.';
$helptxt['automanage_attachments'] = 'Par défaut, SMF place les nouveaux fichiers joints dans un dossier unique. Pour la plupart des sites, ce n\'est pas un problème, mais au fur et à mesure qu\'un site grandit, il peut être utile d\'avoir plusieurs dossiers pour y stocker les fichiers joints.<br><br> Ce paramètre vous permet de définir si vous devez gérer ces dossiers vous-même (ex. créer un deuxième dossier et y aller quand vous êtes prêt) ou laisser SMF le faire, selon des critères tels que l\'importance des dossiers actuels ou de les classer par années voire par mois, dans des sites très fréquentés.';
$helptxt['dont_show_attach_under_post'] = 'Si cette option est activée, les fichiers joints au message n\'apparaîtront pas sous le message, mais pourront quand même être supprimés.';
$helptxt['use_subdirectories_for_attachments'] = 'Créer de nouveaux répertoires.';
$helptxt['max_image_height'] = 'Comme pour la largeur maximale, ce paramètre indique la hauteur maximale qu\'une image publiée peut avoir.';
$helptxt['avatar_paranoid'] = 'Choisissez cette option pour mettre en place des contrôles de sécurité très stricts sur les avatars au moment où les utilisateurs les envoient. <strong>Attention&nbsp;!</strong> Ces contrôles peuvent parfois échouer sur des images sans danger. Nous vous recommandons de ne l\'utiliser qu\'en association avec l\'option de réencodage, auquel cas SMF essaiera de recréer et de mettre en ligne des images saines si le contrôle échoue. Si le réencodage n\'est pas activé, les avatars échouant au contrôle seront rejetés.';
$helptxt['avatar_reencode'] = 'Choisissez cette option pour permettre le réencodage des avatars envoyés par les utilisateurs. Le réencodage vous garantit une meilleure sécurité, mais il supprime également les animations des images animées.<br>Cette option n\'est disponible que si le module GD est installé sur votre serveur.';
$helptxt['cal_enabled'] = 'Le calendrier peut être utilisé pour montrer les anniversaires, ou pour montrer les événements importants qui se déroulent dans votre communauté. Ce paramètre permet d\'activer le calendrier et toutes ses fonctionnalités.';
$helptxt['cal_link_postevent'] = 'Ceci permettra à vos membres de poster des événements pour ce jour, lorsqu\'ils cliquent sur la date.';
$helptxt['cal_maxdays_advance'] = 'Si cette option est mise à 7, tous les événements de la semaine à venir seront montrés.';
$helptxt['cal_allow_unlinkedevents'] = 'Permet aux membres de poster des événements sans nécessiter la création d\'un nouveau sujet dans le forum.';
$helptxt['cal_min_year'] = 'Sélectionne la &quot;première&quot; année dans la liste du calendrier';
$helptxt['cal_max_year'] = 'Sélectionne la &quot;dernière&quot; année dans la liste du calendrier';
$helptxt['cal_maxevent_span'] = 'Sélectionnez le nombre maximal de jours pour la duré d\'un événement';
$helptxt['localCookies'] = 'SMF utilise des témoins (&quot;cookies&quot;) pour conserver les informations de connexion d\'un membre. Les témoins peuvent être stockés dans un dossier global (monserveur.com) ou localement (monserveur.com/chemin/vers/mon/forum).<br><br>
	Cochez cette option si vous constatez certains problèmes avec des utilisateurs déconnectés automatiquement.<hr>
	Les témoins stockés dans un dossier global sont moins sécurisés lorsqu\'ils sont utilisés sur un serveur mutualisé (comme Multimania/Lycos, Free, OVH, ...).<hr>
	Les témoins stockés localement ne fonctionnent pas à l\'extérieur du dossier du forum.<br>
	Donc, si votre forum est installé dans le répertoire www.monserveur.com/forum, les pages telles que www.monserveur.com/index.php ne pourront pas accéder aux témoins.<br><br>
	Lors de l\'utilisation de SSI.php, il est recommandé de stocker les témoins dans un dossier global.';
$helptxt['enableBBC'] = 'Activer cette fonction autorisera vos membres à utiliser les balises (BBCodes) sur votre forum, afin de permettre la mise en forme du texte, l\'insertion d\'images et plus.';
$helptxt['legacy_bbc'] = 'Les anciens BBCodes sont obsolètes et ne peuvent pas être utilisés dans les nouveaux messages. Cependant, ils seront analysés dans les messages existants s\'ils sont activés ici.<br><br>Activer les anciens BBCodes est seulement utile si votre forum a été mis à jour depuis une version précédente de SMF. A noter que même quand ils sont actifs, certains BBCodes ne seront plus affichés comme ils l`étaient auparavant. Par exemple, le BBCode[flash] affichera simplement un lien vers le contenu Flash au lieu de l\'intégrer.';
$helptxt['default_timezone'] = 'Il s\'agit du fuseau horaire par défaut utilisé pour l\'affichage des heures dans tout le forum.';
$helptxt['timezone_priority_countries'] = 'Ce paramètre vous permet de placer les fuseaux horaires d\'un ou plusieurs pays en haut de la liste des fuseaux horaires sélectionnables qui s\'affiche lorsque les utilisateurs configurent leurs profils, créent des événements dans le calendrier, etc.<br><br>Par exemple, si de nombreux membres de votre forum vivent en Nouvelle-Zélande ou aux Fidji, vous pouvez entrer "NZ,FJ" pour leur faciliter la recherche rapide des fuseaux horaires les plus pertinents.<br><br>Vous pouvez trouver la liste complète des codes pays ISO en recherchant sur Internet "<a href="//www.google.com/search?q=iso+3166-1+alpha-2" target="_blank rel="noopener">ISO 3166-1 alpha-2</a>".';
$helptxt['spamWaitTime'] = 'Ici vous pouvez spécifier le temps minimal requis entre deux envois de messages en provenance d\'un même utilisateur. Cette option peut être utilisée afin de contrer le pollupostage (&quot;spamming&quot;).';

$helptxt['enablePostHTML'] = 'Ceci permet l\'utilisation de quelques balises HTML basiques&nbsp;:
	<ul class="normallist">
		<li>&lt;b&gt;, &lt;u&gt;, &lt;i&gt;, &lt;s&gt;, &lt;em&gt;, &lt;strong&gt;, &lt;ins&gt;, &lt;del&gt;</li>
		<li>&lt;a href=&quot;&quot;&gt;</li>
		<li>&lt;img src=&quot;&quot; alt=&quot;&quot; /&gt;</li>
		<li>&lt;br /&gt;, &lt;hr /&gt;</li>
		<li>&lt;pre&gt;, &lt;blockquote&gt;</li>
	</ul>';

$helptxt['themes_manage'] = 'Vous pouvez y installer de nouveaux thèmes et sélectionner les thèmes que vos utilisateurs peuvent choisir, le thème par défaut que les nouveaux utilisateurs et les invités utiliseront, ainsi que d\'autres paramètres pour la sélection de thèmes.';
$helptxt['theme_install'] = 'Ceci vous permet d\'installer des nouveaux thèmes. Vous pouvez procéder en partant d\'un dossier déjà créé, en transférant une archive d\'un thème ou en copiant le thème par défaut.<br><br>Notez bien que les archives de thèmes doivent contenir un fichier de définition <pre>theme_info.xml</pre>.';
$helptxt['xmlnews_enable'] = 'Permet aux gens de faire référence aux <a href="%1$s?action=.xml;sa=news" target="_blank" rel="noopener">Nouvelles récentes</a>
	et autres données similaires. Il est recommandé de limiter la taille des messages puisque certains clients
	tels que Trillian préfèrent afficher des messages RSS tronqués.';
$helptxt['xmlnews_attachments'] = 'Permet d\'inclure des liens vers les fichiers joints dans vos flux XML/RSS. Activez cette option si vous voulez utiliser votre forum comme plateforme de podcasting, de diffusion de contenu ou de distribution de contenu similaire.<br><br> Les permissions "Voir les fichiers joints" ont une incidence sur ce paramètre. Les membres et les invités ne verront les fichiers joints d\'un message dans le flux que s\'ils peuvent également voir les fichiers joints sur la page Web du message. Gardez à l\'esprit que la plupart des lecteurs de flux accèderont à vos flux en tant qu\'invité. <br><br>Certains formats de flux ne permettent qu\'un seul fichier joint par message. Si un message a plusieurs fichiers joints, SMF inclura le plus grand dans ce flux.';
$helptxt['globalCookies'] = 'Permet l\'utilisation de témoins (<em>cookies</em>) indépendants du sous-domaine. Par exemple, si...<br>
	Votre site est situé sur https://www.exemple.com/,<br>
	Et votre forum est situé sur https://forum.exemple.com/,<br>
	Activer cette fonction vous permettra d\'utiliser les témoins de votre forum sur votre site.<br>
	N\'activez pas cette option s\'il existe d\'autres sous-domaines (comme hacker.example.com) qui ne sont pas contrôlés par vous même.<br><br>
	Ce paramètre ne fonctionne pas lorsque les cookies locaux sont activés. ';
$helptxt['globalCookiesDomain'] = 'Lorsque vous utilisez des cookies indépendants des sous-domaines (cookies globaux), vous pouvez spécifier quel domaine doit être utilisé par ceux-ci. Ceci devrait, bien sûr, être défini sur votre domaine principal - par exemple, si vous utilisez <em>forum.exemple.com</em> et <em>www.exemple.com</em>, le domaine est <em>exemple.com</em> dans ce cas. Vous ne devez pas mettre la partie <em>http://</em> ou <em>https://</em> devant votre nom de domaine.';
$helptxt['secureCookies'] = 'Activer cette option forcera la sécurisation des témoins (cookies) créés pour les utilisateurs de votre forum. Ne l\'activez que si vous utilisez le protocole HTTPS sur tout votre site, faute de quoi la gestion des témoins sera fortement perturbée&nbsp;!';
$helptxt['securityDisable'] = 'Ceci <em>désactive</em> la vérification supplémentaire du mot de passe pour accéder à la zone d\'administration. Ceci n\'est pas recommandé&nbsp;!';
$helptxt['securityDisable_why'] = 'Ceci est votre mot de passe courant. (Le même que vous utilisez pour vous connecter au forum.)<br><br>Avoir à le taper de nouveau permet de vérifier que vous voulez bien effectuer quelques opérations d\'administration, et que c\'est bien <strong>vous</strong> qui le faites.';
$helptxt['securityDisable_moderate'] = 'Ceci <em>désactive</em> la vérification supplémentaire du mot de passe pour accéder à la zone de modération. Ceci n\'est pas recommandé&nbsp;!';
$helptxt['securityDisable_moderate_why'] = 'Ceci est votre mot de passe courant. (Le même que vous utilisez pour vous connecter au forum quoi.)<br><br>Avoir à le taper de nouveau permet de vérifier que vous voulez bien effectuer quelques opérations de Modération, et que c\'est bien <strong>vous</strong> qui le faites.';
$helptxt['allow_cors'] = 'Le partage des ressources d\'origine croisée (Cross Origin Resource Sharing ou CORS) est une politique permettant aux navigateurs modernes de faire confiance aux ressources demandées par des domaines différents.  Si cette option est activée, elle tentera de résoudre la politique CORS pour les scripts accédant aux ressources du forum à partir de différents domaines.  Si les cookies indépendants des sous-domaines (cookies globaux) sont activés, des tentatives sont faites pour déterminer le bon domaine.  L\'ajout d\'une liste de domaines séparés par des virgules à l\'option Domaines CORS supplémentaires permet d\'ajouter des domaines supplémentaires.  Le format doit être {SCHEMA}://{DOMAIN}.  Si un caractère générique (*) est fourni dans le domaine, des tentatives sont faites pour résoudre le caractère générique.  Si un joker (*) est fourni comme seul domaine supplémentaire, tous les domaines sont autorisés, ce qui peut présenter un risque pour la sécurité de votre forum et ne devrait pas être utilisé, sauf dans des cas extrêmes.  Les en-têtes supplémentaires peuvent être fournis dans une liste séparée par des virgules et seront autorisés lors des requêtes contenant ces en-têtes et le caractère générique (*) est autorisé.';
$helptxt['frame_security'] = 'Les navigateurs modernes comprennent maintenant un en-tête de sécurité présenté par des serveurs appelés X-Frame-Options. En définissant cette option, vous spécifiez comment vous voulez que votre site soit encadré à l\'intérieur d\'un frame set ou d\'un iframe. La désactivation n\'enverra pas d\'en-tête et est la moins sécurisée, elle permet cependant le plus de liberté. Deny empêchera complètement tous les frames et est le plus restrictif et le plus sécuritaire. Autoriser Same Origin permettra uniquement à votre domaine d\'émettre des frames et fournira un compromis pour les deux options précédentes.';
$helptxt['proxy_ip_header'] = 'Il s\'agit de l\'en-tête du serveur auquel SMF fera confiance pour contenir l\'adresse IP des utilisateurs réels. La modification de ce paramètre peut entraîner des résultats inattendus pour les membres. Veuillez vérifier auprès de votre administrateur de serveur, de votre fournisseur CDN ou de votre administrateur proxy avant de modifier ces paramètres. La plupart des fournisseurs de services interpréteront et utiliseront HTTP_X_FORWARDED_FOR. Vous devez remplir la liste des Serveurs qui envoient les en-têtes inverses de proxy pour des raisons de sécurité afin de vous assurer que ces en-têtes proviennent uniquement de sources valides.';
$helptxt['email_members'] = 'Dans ce message, vous pouvez inclure certaines &quot;variables&quot;. Celles-ci sont&nbsp;:<br>
{$board_url} - L\'URL vers votre forum.<br> 
{$current_time} - L\'heure courante.<br>
{$member.email} - L\'adresse e-mail du membre.<br>
{$member.link} -  Le lien vers le membre actuel.<br>
{$member.id} - L\'ID du membre.<br>
{$member.name} - Le nom du membre. (pour un message plus personnalisé.)<br>
{$latest_member.link} - Le lien vers le membre le plus récemment inscrit.<br>
{$latest_member.id} -  L\'ID du membre le plus récemment inscrit.<br>
{$latest_member.name} - Le nom du membre le plus récemment inscrit.';

$helptxt['failed_login_threshold'] = 'Spécifiez le nombre maximal de tentatives de connexion avant de rediriger l\'utilisateur vers la fonction &quot;Rappel de Mot de Passe&quot;.';
$helptxt['loginHistoryDays'] = 'Le nombre de jours pour conserver l\'historique de connexion sous le profil du traçage de l\'utilisateur. Le délai par défaut est de 30 jours.';
$helptxt['oldTopicDays'] = 'Si cette option est activée, un avertissement sera affiché aux utilisateurs qui tenteront de répondre dans un sujet dans lequel il n\'y a eu aucune intervention après un certain laps de temps, en jours, spécifié par ce paramêtre. Réglez-la à 0 pour désactiver cette fonction.';
$helptxt['edit_wait_time'] = 'Temps en secondes permis pour la modification d\'un message avant que la mention Dernière édition apparaisse.';
$helptxt['edit_disable_time'] = 'Nombre de minutes accordées à un utilisateur pour qu\'il puisse modifier ses messages. Mettre sur 0 pour désactiver. <br><br><em>Note : Cela n\'affectera pas l\'utilisateur qui a la permission de modifier les messages des autres.</em>';
$helptxt['preview_characters'] = 'Ce paramètre définit le nombre de caractères disponibles pour la prévisualisation du premier et du dernier message.';
$helptxt['quote_expand'] = 'Ce paramètre permet de réduire les citations de grande taille, en donnant à l\'utilisateur la possibilité de les développer dans toute leur longueur. Les citations plus petites que ce paramètre ne seront pas affectées.';
$helptxt['posts_require_captcha'] = 'Ce réglage forcera les utilisateurs à rentrer un code affiché sur une image de vérification à chaque fois qu\'ils posteront un message. Seul les utilisateurs avec un compteur de messages en dessous du nombre choisi auront à entrer le code - Cela devrait aider à combattre les scripts automatiques de spam.';
$helptxt['disable_wysiwyg'] = 'Ce réglage désactivera l\'utilisation du WYSIWYG (acronyme de la locution anglaise &quot;What you see is what you get&quot;, signifiant littéralement en français &quot;vous aurez ce que vous voyez&quot;») sur la page de rédaction des messages chez tous les utilisateurs.';
$helptxt['lastActive'] = 'Sélectionnez le nombre de minutes à afficher dans &quot;Membres actifs dans les X dernières minutes&quot;, sur l\'accueil du forum. Par défaut, la valeur est 15 minutes.';

$helptxt['customoptions'] = 'Cette section définit les options qu\'un utilisateur peut choisir à partir d\'une liste déroulante. Il y a quelques points clés à noter pour cette section:
	<ul class="normallist">
		<li><strong>Option par défaut:</strong> L\'option que vous aurez choisie ici sera celle définie par défaut pour l\'utilisateur lorsqu\'il enregistrera son profil.</li>
		<li><strong>Options à retirer:</strong> Pour retirer une option, laisser simplement vide la boite de texte de cette option - celle-ci sera automatiquement supprimée pour tous les utilisateurs l\'ayant précédemment sélectionnée.</li>
		<li><strong>Réordonner les Options:</strong> Vous pouvez modifier l\'ordre des options en les déplacant. Remarque importante - Assurez-vous de ne <strong>pas</strong> modifier le texte de ces options lorsque vous en modifiez l\'ordre, sinon vous perdrez les données prélablement enregistrées par vos utilisateurs pour ces options.</li>
	</ul>';

$helptxt['autoFixDatabase'] = 'Ceci réparera automatiquement les tables présentant des erreurs et ainsi, le forum continuera de fonctionner comme si rien ne s\'était produit. Ceci peut être utile, car la seule façon de régler le problème est de RÉPARER la table en question, et grâce à cette option, le forum ne sera pas hors service en attendant que vous preniez les mesures nécessaires. Un e-mail vous est envoyé lorsqu\'un tel problème se présente.';
// argument(s): scripturl
$helptxt['pgFulltextSearch'] = 'Ce paramètre définit la langue à utiliser pour la recherche plein texte de PostgreSQL. Choisissez la langue qui correspond le mieux à la langue de votre forum. Si la langue de votre forum n\'est pas listée, ou si votre forum est multilingue, choisissez l\'option "simple". <br>
Ce paramètre est indépendant de vos principaux paramètres de langue SMF et n\'est pas lié à la langue installée pour SMF. <br>
Lorsque vous modifiez ce paramètre, vous avez besoin de [url=%1$s?action=admin;area=managesearch;sa=method]reconstruire l\'index de recherche plein texte[/url].<br>
Si une langue dont vous avez besoin n\'est pas répertoriée, demandez à l\'administrateur de votre base de données d\'installer la prise en charge du langage PostgreSQL pour cette langue.';

$helptxt['enableParticipation'] = 'Cette fonction affiche une icône spéciale sur les sujets dans lesquels un utilisateur est précédemment intervenu.';

$helptxt['db_persist'] = 'Ceci maintient la connexion active pour augmenter les performances. Si vous n\'êtes pas sur un serveur dédié, cela peut vous causer des problèmes avec votre hébergeur.<br> Si cette option est désactivée, vous devrez peut-être activer le paramètre mysqli.allow_persistent ou pgsql.allow_persistent dans votre fichier php.ini.';
$helptxt['ssi_db_user'] = 'Réglage optionnel pour utiliser un nom d\'utilisateur et un mot de passe de base de données différents quand vous utilisez SSI.php.';

// argument(s): either $helptxt['queryless_urls_supported'] or $helptxt['queryless_urls_unsupported'], depending on whether the server uses a supported webserver
$helptxt['queryless_urls'] = 'Ceci modifie un peu la structure des URLs afin que les moteurs de recherche les référencent mieux. Les URLs ressembleront à : index.php/topic,1.0.html.<br><br>%1$s';
// is conditionally used as part of $helptxt['queryless_urls']
$helptxt['queryless_urls_supported'] = '  Cette fonctionnalité fonctionnera correctement sur votre serveur.';
// is conditionally used as part of $helptxt['queryless_urls']
$helptxt['queryless_urls_unsupported'] = ' Cette fonction ne fonctionnera pas sur votre serveur.';
$helptxt['minimize_files'] = 'Cette option minimisera les fichiers CSS et JavaScript utilisés par votre forum, réduisant ainsi les appels de requêtes sur votre serveur et accélérant les temps de chargement pour vos utilisateurs. <br><br>Vous devriez normalement laisser cette option activée. La seule fois où vous voudrez peut-être la désactiver temporairement, c\'est lorsque vous êtes en train de modifier les fichiers CSS ou JavaScript utilisés sur votre site (par exemple, lorsque vous modifiez vos fichiers de thèmes ou que vous développez une modification).';
$helptxt['boardindex_max_depth'] = 'Ce paramètre contrôle le nombre de niveaux de sous-sections que SMF vérifiera lors de la recherche de nouveaux messages dans les sous-sections.<br><br>Par exemple, si cette valeur est réglée sur 1, une sous-section ne sera marquée "nouveau" sur la page d\'index que si la sous-section contient elle-même un nouveau message. S\'il est réglé sur 2, la sous-section sera marquée "nouveau" s\'il y a un nouveau message dans une sous-section ou dans une sous-sous-section. S\'il est réglé sur 10, la sous-section sera marquée "nouveau" s\'il y a un nouveau message dans la sous-section, d\'une sous-sous-sous-sous-section, etc., jusqu\'à 10 niveaux de profondeur.<br><br>Les plus grands forums voudront peut-être régler ce nombre à un faible niveau afin d\'économiser les ressources du serveur.';
$helptxt['countChildPosts'] = 'Si vous cochez cette option, les messages et les sujets dans les sous-sections seront pris en compte dans les totaux sur la page d\'index du forum.<br><br>Cela signifie qu\'une section parente sans messages n\'affichera pas \'0\' s\'il y a des messages dans ses sous-sections. ';
$helptxt['allow_ignore_boards'] = 'Cocher cette option permettra aux utilisateurs de sélectionner les sections qu\'ils veulent ignorer.';
$helptxt['deny_boards_access'] = 'Cocher cette case vous permettra de refuser l\'accès à certaines sections en fonction de l\'accès attribué aux groupes de membres.';

// argument(s): scripturl
$helptxt['who_enabled'] = 'Cette option vous permet d\'activer ou non la possibilité de voir qui est en ligne sur le forum et ce qu\'il y fait.';

$helptxt['recycle_enable'] = '&quot;Recycle&quot; les sujets et messages supprimés vers une section spécifique, souvent une section caché aux utilisateurs normaux.';

$helptxt['enableReportPM'] = 'Cette option permet aux utilisateurs de rapporter des messages personnels qu\'ils ont reçus à l\'équipe d\'administration. Ceci peut être pratique pour aider à traquer les abus effectués à l\'aide du système de messagerie personnelle.';
$helptxt['max_pm_recipients'] = 'Cette option vous permet de limiter la quantité maximale de messages privés envoyé par un membre du forum. Cette option permet de lutter contre le pollupostage (&quot;spam&quot;) du système de MP. Notez que les utilisateurs ayant la permission d\'envoyer des bulletins d\'informations ne sont pas concernés par cette restriction. Réglez-la à 0 pour désactiver la fonction.';
$helptxt['pm_posts_verification'] = 'Cette option forcera les utilisateurs à entrer un code affiché sur une image de vérification à chaque fois qu\'ils envoient un message personnel. Seuls les utilisateurs avec un compteur de messages en dessous de l\'ensemble de nombres auront besoin de saisir le code - Cela devrait aider à lutter contre les robots spammeurs.';
$helptxt['pm_posts_per_hour'] = 'Cette option limitera le nombre de messages personnels qui pourront être envoyés par un utilisateur en une heure de temps. Cela n\'affecte pas les admins ou modérateurs.';

$helptxt['default_personal_text'] = 'Choisit le &quot;texte personnel&quot; qu\'un nouvel utilisateur aura par défaut. Ce paramètre n\'est pas disponible lorsque le texte personnel est désactivé ou lorsque les utilisateurs peuvent définir leur propre texte personnel lors de l\'enregistrement.';

$helptxt['registration_method'] = 'Cette fonction détermine quelle méthode d\'inscription doit être adoptée pour les gens désirant rejoindre votre forum. Vous pouvez sélectionner un de ces choix&nbsp;:<br><br>
	<ul class="normallist">
		<li>
			<strong>Inscription désactivée</strong><br>
				Désactive les procédures d\'inscription, ce qui signifie que personne ne peut plus s\'inscrire sur votre forum.<br>
		</li><li>
			<strong>Inscription immédiate</strong><br>
				Les nouveaux membres peuvent se connecter et poster sur votre forum immédiatement après la procédure d\'inscription.<br>
		</li><li>
			<strong>Activation par e-mail</strong><br>
				Lorsque cette option est sélectionnée, tous les membres qui s\'inscrivent au forum recevront un e-mail contenant un lien pour activer leur compte. Ils ne pourront utiliser leur compte que lorsque celui-ci aura été activé.<br>
		</li><li>
			<strong>Approbation par un Admin</strong><br>
				Lorsque cette option est sélectionnée, l\'inscription de tous les nouveaux utilisateurs de votre forum devra d\'abord être approuvée par les administrateurs pour être ensuite effective et leur permettre ainsi de rejoindre votre communauté.
		</li>
	</ul>';

$helptxt['send_validation_onChange'] = 'Lorsque cette option est cochée, tous les membres qui modifient leur adresse e-mail dans leur profil devront réactiver leur compte grâce à un e-mail envoyé à leur nouvelle adresse';
$helptxt['approveAccountDeletion'] = 'Lorsque ce paramètre est coché, toute demande de suppression de son propre compte par un utilisateur doit être approuvée par un administrateur.';

$helptxt['send_welcomeEmail'] = 'Lorsque cette option est activée, tous les nouveaux membres recevront un e-mail leur souhaitant la bienvenue sur votre communauté.';
$helptxt['password_strength'] = 'Ce réglage détermine le niveau de sécurité requis pour les mots de passe sélectionnés par les membres de votre forum. Plus ce niveau est &quot;élevé&quot;, plus il devrait être difficile de découvrir le mot de passe et de pirater leurs comptes.
	Les niveaux possibles sont&nbsp;:
	<ul>
		<li><strong>Bas&nbsp;:</strong> Le mot de passe doit être composé d\'au moins quatre caractères.</li>
		<li><strong>Moyen&nbsp;:</strong> Le mot de passe doit être formé d\'au moins huit caractères, et ne peut contenir des parties de l\'identifiant ou de l\'adresse e-mail.</li>
		<li><strong>élevé&nbsp;:</strong> Comme pour le niveau précédent, et le mot de passe doit aussi contenir des lettres majuscules et minuscules et au moins un chiffre.</li>
	</ul>';
$helptxt['enable_password_conversion'] = 'En activant ce paramètre, SMF tentera de détecter les mots de passe stockés dans d\'autres formats et de les convertir au format utilisé par SMF. Typiquement ceci est utilisé pour les forums convertis en SMF, mais peut aussi avoir d\'autres utilisations. Désactiver cette fonction empêche un utilisateur de se connecter en utilisant son mot de passe après une conversion et il devra donc réinitialiser son mot de passe.';

$helptxt['coppaAge'] = 'The value specified in this box will determine the minimum age that new members must be in order to be granted immediate access to the forum.
	On registration they will be prompted to confirm whether they are over this age, and if not will either have their application rejected or suspended awaiting parental approval - dependent on the type of restriction chosen.
	If a value of 0 is chosen for this setting then all other age restriction settings shall be ignored.';
$helptxt['coppaType'] = 'Si la restriction d\'âge est active, ce paramètre définira ce qui se produit lorsqu\'un membre n\'ayant pas l\'âge minimum requis tente de s\'inscrire sur votre forum. Il existe deux choix possibles&nbsp;:
	<ul class="normallist">
		<li>
			<strong>Rejeter son inscription&nbsp;:</strong><br>
				N\'importe quel nouvel adhérent n\'ayant pas l\'âge requis verra son inscription rejetée immédiatement.<br>
		</li><li>
			<strong>Nécessiter l\'approbation d\'un parent/tuteur légal</strong><br>
				N\'importe quel nouvel adhérent n\'ayant pas l\'âge requis et qui tente de s\'inscrire sur votre forum verra son compte marqué en attente d\'approbation et il lui sera remis un formulaire à faire remplir par ses parents ou tuteurs avant de pouvoir devenir membre de votre forum.
				Il lui sera aussi présenté les informations de contact du forum enregistrées sur la page des paramètres, afin que le formulaire d\'approbation parentale soit envoyée à l\'administrateur par la poste ou par téléfax.
		</li>
	</ul>';
$helptxt['coppaPost'] = 'Les champs de contact doivent être completées afin que les formulaires d\'autorisation parentale pour les membres n\'ayant pas l\'âge requis soient envoyés à l\'administrateur. Ces détails seront affichés à tous les mineurs et il leur est nécessaire d\'obtenir une approbation parentale. Une adresse postale ou un numéro de téléfax est le minimum requis.';

$helptxt['allow_hideOnline'] = 'En activant cette option, les membres peuvent cacher leur statut de connexion au forum aux autres visiteurs (sauf aux administrateurs). Si elle est désactivée, seuls les utilisateurs qui peuvent modérer le forum entier peuvent cacher leur présence. Notez bien que désactiver cette option ne changera rien dans le statut des membres connectés en ce moment - cela ne leur empêchera la manœuvre que pour les futures connexions.';
$helptxt['meta_keywords'] = 'Ces mots-clés sont placés dans les entêtes de chaque page pour indiquer aux robots le type de contenu de votre site (mais cette technique n\'est plus très efficace de nos jours, NDT). Séparez les mots par des virgules, et n\'utilisez pas de HTML.';

$helptxt['latest_themes'] = 'Cette zone vous montre quelques-uns des derniers thèmes et les plus populaires en provenance de <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a>. Cela peut néanmoins ne pas s\'afficher correctement si votre ordinateur a du mal à se connecter à <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a>.';

$helptxt['secret_why_blank'] = 'Pour votre sécurité, la réponse à votre question (de même que votre mot de passe) est encryptée de telle manière que SMF ne peut que vérifier si vous entrez la bonne valeur, ainsi il ne peut jamais vous révéler (ni à vous ni à personne d\'autre, heureusement&nbsp;!) quelle est votre réponse ou votre mot de passe.';
$helptxt['moderator_why_missing'] = 'Puisque la modération est définie indépendamment pour chaque section, vous devrez assigner les membres en tant que modérateurs à partir de <a href="%1$s?action=admin;area=manageboards" target="_blank" rel="noopener">l\'interface de gestion des sections</a>.';

$helptxt['permissions'] = 'Les permissions permettent de définir les droits accordés (ou non) aux membres pour effectuer une action particulière. Ces droits sont définis sur la base des groupes de membres <br><br>Vous pouvez modifier ces droits sur plusieurs sections en même temps en utilisant les cases à cocher, ou modifier les permissions d\'un groupe particulier en cliquant sur le lien \'Modifier\'';
$helptxt['permissions_board'] = 'Si \'Global\' est sélectionné, cela signifie que cette section ne possèdera aucune permission particulière, et aura celles générales de votre forum. \'Local\' signifie qu\'elle aura ses propres permissions - indépendamment des permissions globales. Ceci vous permet d\'avoir des sections avec plus ou moins de permissions que d\'autres, sans navoir à régler toutes les permissions pour chaque section.';
$helptxt['permissions_quickgroups'] = 'Ceci vous permet d\'utiliser les réglages de permissions par &quot;défaut&quot; - <em>standard</em> signifie &quot;rien de spécial&quot;, restreint signifie &quot;comme un invité&quot;, modérateur signifie &quot;les mêmes droits qu\'un modérateur&quot;, et enfin <em>maintenance</em> signifie &quot;des permissions très proches de celles d\'un administrateur&quot;.';
$helptxt['permissions_deny'] = 'Interdire des permissions peut être utile quand vous voulez enlever des permissions à certains membres. Vous pouvez ajouter un groupe de membres avec une permission \'interdite\' pour les membres auxquels vous voulez interdire une permission.<br><br><strong>À utiliser avec précaution</strong>, une permission interdite restera interdite peu importe dans quels autres groupes de membres le membre fait partie.';
$helptxt['permissions_postgroups'] = 'Activer les permissions pour les groupes posteurs vous permettra d\'attribuer des permissions aux membres ayant posté un certain nombre de messages. Les permissions du groupe posteur sont <em>ajoutées</em> aux permissions des membres inscrits.';
$helptxt['membergroup_guests'] = 'Le groupe de membres Invités contient tous les utilisateurs qui ne sont pas connectés à un compte membre sur votre forum.';
$helptxt['membergroup_regular_members'] = 'Les membres inscrits correspondent à tous les utilisateurs ayant un compte membre sur votre forum, mais à qui aucun groupe permanent n\'a été assigné.';
$helptxt['membergroup_administrator'] = 'L\'administrateur peut, par définition, faire tout ce qu\'il veut et voir toutes les sections. Il n\'y a aucun réglage de permissions pour les administrateurs.';
$helptxt['membergroup_moderator'] = 'Le groupe Modérateur est un groupe spécial. Les permissions et réglages pour ce groupe s\'appliquent aux modérateurs mais uniquement <em>dans la (ou les) section(s) qu\'ils modèrent</em>. Au dehors de ces sections, ils sont considérés comme n\'importe quel autre membre régulier. Notez que les permissions pour ce groupe s\'appliquent également à tous les groupes affectés à la modération d\'une section.';
$helptxt['membergroups'] = 'Dans SMF il y a deux types de groupes auxquels vos membres peuvent appartenir. Ce sont&nbsp;:
	<ul class="normallist">
		<li><strong>Groupes permanents&nbsp;:</strong> Un groupe permanent est un groupe dans lequel un membre n\'est pas assigné automatiquement. Pour assigner un membre dans un groupe permanent, allez simplement dans son profil et cliquez sur &quot;Paramètres relatifs au compte&quot;. Ici vous pouvez paramétrer les différents groupes permanents auxquels les membres peuvent appartenir.</li>
		<li><strong>Groupes posteurs&nbsp;:</strong> Au contraire des groupes permanents, un membre ne peut être manuellement assigné à un groupe posteur, basé sur le nombre de message. Les membres sont plutôt assignés automatiquement à un groupe posteur lorsqu\'ils ont atteint le nombre minimum de messages requis pour faire partie de ce groupe.</li>
	</ul>';

$helptxt['calendar_how_edit'] = 'Vous pouvez modifier ces événements en cliquant sur l\'astérisque (*) rouge accompagnant leur nom.';

$helptxt['maintenance_backup'] = 'Cette section vous permettra de faire une copie de sauvegarde des messages, des réglages, des membres et autres informations utiles de votre forum dans un gros fichier.<br><br>Il est recommandé d\'effectuer cette opération souvent, par exemple hebdomadairement, pour plus de sécurité et de protection.';
$helptxt['maintenance_rot'] = 'Ceci vous permet de supprimer <strong>complètement</strong> et <strong>irrévocablement</strong> les vieux sujets. Vous devriez effectuer une copie de sauvegarde de votre base de données avant de procéder à cette action, au cas où vous enleveriez quelque chose que vous ne vouliez pas supprimer.<br><br><strong>À utiliser avec précaution.</strong>';
$helptxt['maintenance_members'] = 'Ceci vous permet d\'effacer <strong>complètement</strong> et <strong>irrévocablement</strong> des comptes de membres de votre forum. Vous devriez <strong>absolument</strong> faire une sauvegarde avant, juste au cas où vous effaceriez quelque chose que vous ne vouliez pas effacer.<br><br><strong>Utilisez cette option avec précaution.</strong>';

$helptxt['avatar_server_stored'] = 'Ceci permet à vos membres de choisir leur avatar parmi ceux préalablement installés sur votre serveur. Ils sont, généralement, au même endroit que votre forum Smf, dans le dossier des avatars.<br>Un conseil, si vous créez des répertoires dans ce dossier, vous pouvez faire des catégories d\'avatars.';
$helptxt['avatar_external'] = 'Quand cette option est activée elle permet à vos membres d\'insérer l\'adresse URL de leur propre avatar. L\'inconvénient est que, dans certains cas, ils pourraient utiliser des avatars beaucoup trop gros ou des images que vous ne voulez pas voir sur votre forum.';
$helptxt['avatar_download_external'] = 'Si ce paramètre est activé, les avatars externes seront téléchargés à partir des URL indiquées par les utilisateurs. En cas de succès, les avatars seront traités comme des avatars téléchargés.';
$helptxt['avatar_action_too_large'] = 'Ce paramètre vous permet donc de rejeter les images (d\'autres sites) qui sont trop grandes, ou demande au navigateur de les redimensionner, ou de les télécharger sur votre serveur.<br><br>Si les utilisateurs mettent de très grandes images comme avatars et les redimensionnent dans le navigateur, cela peut causer un chargement très lent pour vos utilisateurs - cela ne redimensionne pas le fichier, mais cela le montre plus petit. Ainsi, une photo numérique, par exemple, serait toujours chargée dans son intégralité, puis redimensionnée uniquement lorsqu\'elle est affichée - donc pour les utilisateurs, cela pourrait devenir assez lent et utiliser beaucoup de bande passante.<br><br>D\'autre part, les télécharger signifie aussi utiliser votre bande passante et l\'espace serveur, mais vous assurez également que les images sont plus petites, donc ça devrait être plus rapide pour les utilisateurs. (Note&nbsp;: le téléchargement et le redimensionnement nécessitent soit la bibliothèque GD, soit ImageMagick utilisant les extensions Imagick ou MagickWand)';
$helptxt['avatar_upload'] = 'Cette option est pratiquement la même chose que &quot;Permettre aux membres de sélectionner un avatar externe&quot;, sauf que vous avez un meilleur contrôle sur les avatars, plus de facilité pour les redimensionner, et vos membres n\'ont pas à avoir un endroit où mettre leurs avatars.<br><br>Mais l\'inconvénient est que cela peut prendre beaucoup d\'espace sur votre serveur.';
$helptxt['avatar_download_png'] = 'Les images au format PNG sont plus lourdes, mais offrent un rendu de meilleure qualité. Si la case est décochée, le format JPEG sera utilisé à la place - ce qui donne des fichiers moins lourds, mais de moindre qualité, surtout les dessins, lesquels peuvent devenir assez flous.';

$helptxt['disableHostnameLookup'] = 'Ceci désactive la recherche du nom de l\'hôte, fonction parfois lente sur certains serveurs. Notez que sa désactivation rend le système de bannissement moins efficace.';

$helptxt['smiley_sameall'] = 'Si vous cochez "Même image pour tous les ensembles", la même image sera ajoutée à tous vos ensembles de smileys. Si vous décochez la case, une image différente peut être téléchargée pour chaque jeu de smileys installé. Notez qu\'une image doit être fournie pour chaque jeu de smileys.';

$helptxt['search_weight_frequency'] = 'Des facteurs de pertinence sont utilisés pour déterminer l\'intêrêt des résultats de recherche. Changez ces facteurs pour les faire correspondre à des valeurs intéressantes pour votre forum. Par exemple, un forum d\'actualités aura un facteur d\'ancienneté du message relativement bas. Toutes les valeurs sont en relation avec les autres et doivent être des valeurs positives.<br><br>Ce facteur compte le nombre de messages correspondants et divise ce résultat par le nombre de messages dans un sujet.';
$helptxt['search_weight_age'] = 'Des facteurs de pertinence sont utilisés pour déterminer l\'intêrêt des résultats de recherche. Changez ces facteurs pour les faire correspondre à des valeurs intéressantes pour votre forum. Par exemple, un forum d\'actualités aura un relativement grand facteur de \'Âge du dernier message\'. Toutes les valeurs sont en relation avec les autres et doivent être des valeurs positives.<br><br>Ce facteur vérifie l\'âge des derniers messages d\'un sujet. Plus récent est le message, le plus haut dans la liste il est positionné.';
$helptxt['search_weight_length'] = 'Des facteurs de pertinence sont utilisés pour déterminer l\'intêrêt des résultats de recherche. Changez ces facteurs pour les faire correspondre à des valeurs intéressantes pour votre forum. Par exemple, un forum d\'actualités aura un relativement grand facteur de \'Âge du dernier message\'. Toutes les valeurs sont en relation avec les autres et doivent être des valeurs positives.<br><br>Ce facteur est basé sur la longueur du sujet. Plus le sujet contient de réponses, plus le pointage est élevé.';
$helptxt['search_weight_subject'] = 'Des facteurs de pertinence sont utilisés pour déterminer l\'intêrêt des résultats de recherche. Changez ces facteurs pour les faire correspondre à des valeurs intéressantes pour votre forum. Par exemple, un forum d\'actualités aura un relativement grand facteur de \'Âge du dernier message\'. Toutes les valeurs sont en relation avec les autres et doivent être des valeurs positives.<br><br>Ce facteur vérifie si le terme recherché peut être trouvé ou non dans le titre du sujet.';
$helptxt['search_weight_first_message'] = 'Des facteurs de pertinence sont utilisés pour déterminer l\'intêrêt des résultats de recherche. Changez ces facteurs pour les faire correspondre à des valeurs intéressantes pour votre forum. Par exemple, un forum d\'actualités aura un relativement grand facteur de \'Âge du dernier message\'. Toutes les valeurs sont en relation avec les autres et doivent être des valeurs positives.<br><br>Ce facteur vérifie si le terme recherché peut être trouvé ou non dans le premier message du sujet.';
$helptxt['search_weight_sticky'] = 'Des facteurs de pertinence sont utilisés pour déterminer l\'intêrêt des résultats de recherche. Changez ces facteurs pour les faire correspondre à des valeurs intéressantes pour votre forum. Par exemple, un forum d\'actualités aura un relativement grand facteur de \'Âge du dernier message\'. Toutes les valeurs sont en relation avec les autres et doivent être des valeurs positives.<br><br>Ce facteur vérifie si un sujet est populaire et augmente le score de pertinence si il l\'est.';
$helptxt['search'] = 'Ajustez ici tous les réglages de la fonction recherche.';
$helptxt['search_why_use_index'] = 'Un index de recherche peut considérablement améliorer l\'exécution des recherches sur votre forum. En particulier lorsque le nombre de messages sur un forum est de plus en plus grand, la recherche sans index peut prendre un bon moment et augmenter la pression sur votre base de données. Si votre forum a plus de 50.000 messages, vous devriez penser à créer un index de recherche pour assurer un fonctionnement optimal de votre forum.<br><br>À noter qu\'un index de recherche peut prendre un certain espace... Un index à texte intégral est un index géré par MySQL. C\'est relativement compact (approximativement la même taille que la table message), mais beaucoup de mots ne sont pas indexés et il se peut que quelques recherches s\'avèrent très lentes. L\'index personnalisé est souvent plus grand (selon votre configuration, cela peut ètre plus de 3 fois la taille de la table des messages) mais la performance est meilleure qu\'en texte intégral et relativement stable.';

$helptxt['see_admin_ip'] = 'Les adresses IP sont affichées aux administrateurs et aux modérateurs afin de faciliter la modération et de rendre plus efficace la surveillance des personnes se conduisant mal sur ce forum.  Rappelez-vous que les adresses IP ne peuvent pas toujours être identifiées, et que la plupart des adresses changent périodiquement.<br><br>Les membres sont aussi autorisés à voir leur adresse IP, mais pas celle des autres.';
$helptxt['see_member_ip'] = 'Votre adresse IP est affichée seulement à vous et aux modérateurs.  Rappelez-vous que cette information ne permet pas de vous identifier en tant qu\'individu, et que la plupart des adresses changent périodiquement.<br><br>Vous ne pouvez pas voir l\'adresse IP des autres, et les autres ne peuvent pas voir la vôtre.';
$helptxt['whytwoip'] = 'SMF utilise plusieurs méthodes pour détecter les adresses IP d\'un utilisateur. Habituellement ces deux méthodes donnent la même adresse mais dans certains cas plus d\'une adresse peut être détectée. Dans ce cas SMF conserve les adresses, et les utilise par exemple lors des contrôles de bannissement (etc). Vous pouvez cliquer sur chaque adresse pour traquer cette IP et la bannir si nécessaire.';

$helptxt['ban_cannot_post'] = 'La restriction \'Ne peut pas poster\' a pour conséquence que le forum n\'est accessible qu\'en lecture seule pour l\'utilisateur banni. L\'utilisateur ne peut pas créer de nouveaux sujets ou répondre à ceux existants, envoyer des messages personnels ou voter dans les sondages. L\'utilisateur banni peut toutefois encore lire ses messages personnels et les sujets.<br><br>Un message d\'avertissement est affiché aux utilisateurs qui sont bannis avec cette restriction.';

$helptxt['posts_and_topics'] = '	<ul>
		<li>
			<strong>Paramètres des messages</strong><br>
			Modifie les paramètres relatifs au postage des messages et la façon dont ceux-ci sont affichés. Vous pouvez aussi activer le correcteur orthographique ici.
		</li><li>
			<strong>Code d\'affichage</strong><br>
			Active le code montrant les messages dans un rendu correct. Ajuste aussi quels codes sont permis et ceux qui sont désactivés.
		</li><li>
			<strong>Mots censurés</strong>
			Afin de conserver un registre de langage convenable sur votre forum, vous pouvez censurer certains mots. Cette fonction vous permet de convertir des mots interdits en d\'autres mots innocents. D\'où une possibilité dérivée de remplacement de termes choisis.
		</li><li>
			<strong>Paramètres des sujets</strong>
			Modifie les paramètres relatifs aux sujets&nbsp;: le nombre de sujets par page, l\'impression des sujets par page pour autant que cette option soit activée, etc.
		</li>
	</ul>';

$helptxt['spider_mode'] = 'Règle le niveau de journalisation.<br> Standard - Le journal note l\'activité de base du robot.<br> Haute - Fournit des statistiques plus précises.<br> Très Haute - Comme pour &quot;Haute&quot;, mais le journal note chaque page visitée.';

$helptxt['spider_group'] = 'En sélectionnant un groupe restrictif, lorsqu\'un invité est identifié comme moteur de recherche, certaines permissions lui seront niées (autrement dit &quot;Interdites&quot;), par rapport aux permissions normales d\'un invité. Vous pouvez utiliser ceci pour donner moins d\'accès à un moteur de recherche par rapport à un invité normal. Vous pouvez par exemple vouloir créer un nouveau groupe appelé &quot;Robots&quot; et le sélectionner ici. Vous pourriez donc interdire à ce groupe la permission de voir les profils pour empêcher l\'indexation par les robots des profils de vos membres.<br>Note : La détection des robots n\'est pas parfaite et peut être simulée par les utilisateurs, donc cette fonctionnalité n\'est pas garantie pour restreindre le contenu aux seuls moteurs de recherche que vous avez ajoutés.';
$helptxt['show_spider_online'] = 'Ce paramètre vous permet de choisir si les robots seront montrés ou pas sur la liste des utilisateurs en ligne et la page &quot;Qui est en ligne&quot;. Les options&nbsp;:
	<ul class="normallist">
		<li>
			<strong>Pas du tout</strong><br>
			Les robots seront montrés en tant qu\'invités aux autres utilisateurs.
		</li><li>
			<strong>Montrer le nombre de robots</strong><br>
			L\'accueil du forum indiquera le nombre de robots visitant actuellement le forum.
		</li><li>
			<strong>Montrer le nom des robots</strong><br>
			Les noms des robots seront montrés, les utilisateurs sauront ainsi combien de chaque type de robot visite le forum - valable à la fois pour l\'accueil du forum et la page Qui est en ligne.
		</li><li>
			<strong>Montrer le nom des robots, mais juste à l\'administrateur</strong><br>
			Comme ci-dessus, mais seuls les Administrateurs pourront voir le statut des robots - pour les autres utilisateurs, les robots seront affichés comme étant des invités.
		</li>
	</ul>';

$helptxt['birthday_email'] = 'Choisissez le modèle du message d\'anniversaire par e-mail à utiliser. Une prévisualisation sera affichée dans le sujet de l\'e-mail et les champs du corps de l\'e-mail.<br><strong>Attention</strong>, régler cette option n\'active pas automatiquement les e-mails d\'anniversaire. Pour activer les e-mails d\'anniversaire, utilisez la page <a href="%1$s?action=admin;area=scheduledtasks;%3$s=%2$s" target="_blank" rel="noopener">Tâches Programmées</a> et activez la tâche E-mail d\'anniversaire.';
$helptxt['pm_bcc'] = 'Lorsque vous envoyez un message personnel vous pouvez choisir d\'ajouter comme destinataire un BCC (soit &quot;Blind Carbon Copy&quot;). L\'existence et l\'identité des destinataires BCC seront cachées aux autres destinataires du message.';

$helptxt['move_topics_maintenance'] = 'Ceci vous permet de déplacer tous les sujets d\'une section vers une autre.';
$helptxt['maintain_reattribute_posts'] = 'Vous pouvez utiliser cette fonction pour attribuer des messsages d\'invités de votre forum à un membre inscrit. Ceci est très utile par exemple si un utilisateur a effacé son compte, a changé d\'idée et veut récupérer les anciens messages associé à son compte.';
$helptxt['chmod_flags'] = 'Vous pouvez choisir manuellement les permissions que vous voulez appliquer aux fichiers sélectionnés. Pour ce faire, entrez la valeur du chmod en valeur numérique (en base 8). Note - ces indicateurs n\'auront aucun effet sur les systèmes d\'exploitation Microsoft Windows.';

$helptxt['postmod'] = 'Cette section permet aux membres de l\'équipe de modération disposant des permissions nécessaires, d\'approuver les messages et sujets avant leur apparition en ligne.';

$helptxt['field_show_enclosed'] = 'Enferme l\'entrée faite par l\'utilisateur entre du texte ou du html. Cela vous permettra d\'ajouter d\'autres fournisseurs de messages instantanés, des images ou un embed, etc. Par exemple :<br><br>
		&lt;a href="https://example.com/{INPUT}"&gt;&lt;img src="{DEFAULT_IMAGES_URL}/icon.png" alt="{INPUT}" /&gt;&lt;/a&gt;<br><br><br>
		Notez que vous pouvez utiliser les variables suivantes :<br>.
		<ul class="normallist">
			<li>{INPUT} - L\'entrée spécifiée par l\'utilisateur.</li>
			<li>{SCRIPTURL} - L\'adresse web du forum.</li>
			<li>{IMAGES_URL} - URL du répertoire des images dans le thème actuel des utilisateurs.</li>
			<li>{DEFAULT_IMAGES_URL} - URL du répertoire des images dans le thème par défaut.</li>
			<li>{KEY} - Utilisé lorsqu\'un champ a plusieurs options, c\'est l\'ID numérique unique utilisé pour l\'identifier.</li>
		</ul>';

$helptxt['custom_mask'] = 'Le masque d\'entrée est important pour la sécurité de votre forum. Valider le texte entré par un utilisateur peut vous permettre d\'éviter que ses données ne soient pas utilisées de manière inattendue. Vous pouvez utiliser des expressions régulières pour vous y aider.<br><br>
Des délimiteurs marquant le début et la fin du motif sont nécessaires ! Ce sont des tildes (~) dans les exemples ci-dessous.<br><br>.
	<div class="smalltext" style="margin: 0 2em">
		&quot;[A-Za-z]+&quot; - Correspond à toutes les lettres de l\'alphabet, minuscules et majuscules.<br>
		&quot;[0-9]+&quot; - Correspond à tous les chiffres.<br>
		&quot;[A-Za-z0-9]{7}&quot; - Correspond à une suite de sept chiffres et/ou lettres de l\'alphabet, minuscules ou majuscules.<br>
		&quot;[^0-9]?&quot; - Empêche la présence à cet endroit d\'un chiffre.<br>
		&quot;^([A-Fa-f0-9]{3}|[A-Fa-f0-9]{6})$&quot; - N\'autoriser que 3 ou 6 caractères hexadécimaux.<br>
	</div><br><br>
	De plus, vous pouvez utiliser les méta-caractères spéciaux ?+*^$ et {xx}.
	<div class="smalltext" style="margin: 0 2em">
		? - Rien, ou une occurrence de l\'expression qui précède.<br>
		+ - Au moins une occurrence de l\'expression qui précède.<br>
		* - Rien, ou au moins une occurrence de l\'expression qui précède.<br>
		{xx} - xx occurrences de l\'expression qui précède.<br>
		{xx,} - xx occurrences, ou plus, de l\'expression qui précède.<br>
		{,xx} - Jusqu\'à xx occurrences de l\'expression qui précède.<br>
		{xx,yy} - Entre xx et yy occurrences de l\'expression qui précède.<br>
		$ - Début de chaîne.<br>
		^ - Fin de chaîne.<br>
		\\ - Échappe le caractère suivant.<br>
	</div><br><br>
	Vous pourrez trouver plus d\'informations et d\'exemples sur le Net.';

$helptxt['topic_move_any'] = 'Si cette case est cochée, les utilisateurs seront autorisés à déplacer les sujets sur n\'importe quelle section qu\'ils peuvent voir. Sinon, ils ne pourront les déplacer que vers des sections où ils seront autorisés à poster de nouveaux sujets.';

$helptxt['alert_pm_new'] = 'Les notifications de nouveaux messages personnels n\'apparaissent pas dans le volet d\'Alertes, mais dans la liste intitulée "Mes messages".';
$helptxt['alert_event_new'] = 'Ceci enverra une alerte ou un e-mail comme demandé si un nouvel événement du calendrier est ajouté. Cependant, si cet événement est posté et qu\'un sujet est ajouté, vous n\'obtiendrez pas d\'alerte pour l\'événement si vous surveillez déjà cette section - l\'alerte pour la surveillance de cette section devrait la relayer.';

$helptxt['force_ssl'] = '<strong>Testez correctement le SSL et HTTPS sur votre serveur avant de l\'activer, car cela peut rendre votre forum inaccessible.</strong> Activez le mode maintenance si vous ne pouvez pas accéder à votre forum une fois ce paramètre activé.<br><br><strong>Changer ce paramètre met à jour l\'URL primaire de votre forum ainsi que les URLs des fichiers de vos thèmes, images, smileys et avatars en fonction de votre choix&nbsp;: http: ou https: basé sur votre sélection. Les URLs personnalisées ne seront pas affectées.</strong>';
$helptxt['image_proxy_enabled'] = 'Ceci permet d\'activer le proxy pour les images';
$helptxt['image_proxy_secret'] = 'Gardez ce secret, cela protège vos images contre le hotlinking. Changez-le pour rendre les images protégées par le hotlinking inutiles';
$helptxt['image_proxy_maxsize'] = 'Ceci est la taille maximale de l\'image qui est mise en cache par le proxy : les images plus grandes ne seront pas mises en cache. Les images en cache sont stockées dans votre dossier cache de SMF, alors assurez-vous qu\'il comporte assez d\'espace libre.';

$helptxt['enable_sm_stats'] = 'Si cette option est activée, cela permettra à Simple Machines de visiter votre site une fois par mois pour collecter des statistiques de base. Cela nous aidera à prendre des décisions quant aux configurations pour lesquelles optimiser le logiciel. Pour plus d\'informations, veuillez consulter nos <a href="https://www.simplemachines.org/about/stats.php" target="_blank" rel="noopener">pages d\'informations</a>.';

$helptxt['field_reg_require'] = 'Si ce champ est obligatoire lors de l\'inscription, il le sera également lors de changements dans le profil.';

$helptxt['translatable_fields'] = 'If you wish to provide multi-language support for your custom profile fields you can use translatable tokens on both the name and description fields.<br><br>
Anything enclosed with braces <span class="monospace">{}</span> will be considered as a token and will be matched against a $txt string. For example, the token <span class="monospace">{gender}</span> will be replaced by the value of $txt[\'gender\']<br><br>
It is <strong>very important</strong> to add the matched $txt string to <strong>ALL</strong> currently installed languages. To do this, go to the <a href="%1$s?action=admin;area=languages;sa=edit;%3$s=%2$s" class="bbc_link" target="_blank" rel="noopener">Edit Languages</a> page and complete the following steps for each installed language:
<ol class="bbc_list" style="list-style-type: decimal">
	<li>Click the "Edit" button next to the language name.</li>
	<li>In the "Select entries to edit" menu, choose "Modifications".</li>
	<li>Scroll to bottom and click the "Add Another Item" button.</li>
	<li>Follow the prompts to add your new string.</li>
</ol>';

// argument(s): $boarddir, $boardurl
$helptxt['cron_is_real_cron'] = 'Par défaut, SMF ajoute à chaque page un petit code JavaScript qui invite le navigateur de l\'utilisateur à déclencher le cron.php de SMF en arrière-plan. Cette approche permet à SMF d\'exécuter ses tâches planifiées sur une base régulière sans que l\'administrateur n\'ait à faire de configurations supplémentaires sur le serveur. Cependant, certains administrateurs peuvent préférer configurer leurs serveurs pour exécuter directement le cron.php sur une base régulière. Si vous l\'avez fait, vous pouvez désactiver la méthode JavaScript.<br><br><strong>Note&nbsp;:</strong> Configurer votre serveur pour exécuter des tâches planifiées de cette façon ne peut pas être fait depuis SMF. Vous devrez utiliser votre logiciel de configuration serveur pour le faire. Les outils Typiques à cette fin sont <code>cron</code> (pour les serveurs Linux), <code>schtasks.exe</code> (pour les serveurs Windows), et <code>launchd</code> (pour les serveurs MacOS). La plupart des hébergeurs web fournissent une interface qui permet à leurs clients d\'accéder à ces outils.<br><br>Le chemin et l\'URL de votre forum pour le cron.php sont&nbsp;:<br>Chemin&nbsp;: %1$s/cron.php<br>URL&nbsp;: %2$s/cron.php';

$helptxt['languages_txt'] = 'Ces entrées de langage sont utilisées partout dans SMF pour définir des versions localisées de texte pour différents langages.<br><br>Si vous voyez une valeur comme <code>&#37;1$s</code> dans une entrée, c\'est un caractère générique que SMF complète avec une vraie valeur au moment de son exécution. Veillez à conserver ces caractères de remplacement dans votre texte personnalisé.';
$helptxt['languages_helptxt'] = 'Ces entrées de langage sont utilisées pour afficher des fenêtres contextuelles d\'aide flottantes (comme celle-ci).';
$helptxt['languages_editortxt'] = 'Ces entrées de langue sont utilisées pour les éléments d\'interface utilisateur dans l\'éditeur de messages.';
$helptxt['languages_tztxt'] = 'Ces entrées linguistiques sont utilisées pour construire les descriptions des fuseaux horaires.<br><br>Par exemple, la chaîne <code>Europe_Western</code> peut être combinée avec la chaîne <code>daylight_saving_time_false</code> pour produire "l\'heure normale de l\'Europe de l\'Ouest".<br><br>Note : Si aucune description n\'est fournie pour un fuseau horaire donné, SMF générera une description en utilisant une liste de lieux dans ce fuseau horaire.';
$helptxt['languages_txt_for_timezones'] = 'Ces entrées linguistiques vous permettent de faire ce qui suit :<br><ol class="bbc_list" style="list-style-type: decimal ;"><li>Modifier les noms affichés pour les lieux individuels partout où ils pourraient être utilisés dans un contexte lié aux fuseaux horaires. Par exemple, vous pouvez dire à SMF d\'afficher "Qaanaaq" pour l\'emplacement "America/Thule" au lieu de "Thule".</li><li>Editer les noms affichés pour différents pays. Cela peut être fait en éditant la chaîne <code>iso3166[]</code> pertinente.</li></ol>';
$helptxt['languages_txt_for_email_templates'] = 'Ces entrées de langue sont utilisées pour créer les messages emails que SMF envoie à vos membres.';
$helptxt['languages_native_name'] = 'Le nom du langage de la langue, représenté dans sa langue maternelle.';
$helptxt['languages_character_set'] = 'Le jeu de caractères utilisé pour cette langue. A partir de la version 2.1 de SMF, il faudra toujours utiliser l\'encodage "UTF-8".';
$helptxt['languages_locale'] = 'Le code local est utilisé pour déterminer diverses conventions de formatage, etc...<br><br>Le code local prend généralement la forme d\'un code de langue à deux caractères, suivi éventuellement d\'un tiret bas et d\'un code pays à deux caractères. Par exemple&nbsp;: <code>en</code> identifierait l\'Anglais générique, tandis que <code>en_AU</code> identifierait l\'Anglais Australien en particulier.';
$helptxt['languages_rtl'] = 'Entrer un "1" ici si cette langue se lit de droite à gauche (ex: Hébreu, Arabe). Laisser à "0" pour les langues de gauche à droite.';
$helptxt['languages_dictionary'] = 'Définit le dictionnaire de langue principale qui sera utilisé par le correcteur orthographique <a href="https://php.net/function.pspell-new" target="_blank" rel="noopener">pSpell</a> (si installé).';
$helptxt['languages_recaptcha'] = 'Le code de langue à utiliser pour le widget de vérification reCAPTCHA.<br><br>Voir la documentation reCAPTCHA de Google pour sa <a href="https://developers.google.com/recaptcha/docs/language" target="_blank" rel="noopener" class="bbc_link">liste des langues supportées</a>.';
// The GDPR page of the EU exists in several languages; change the language code at the end of the url
$helptxt['requireAgreement'] = 'Ce paramètre doit être activé afin de respecter les règles de la <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_en" target="_blank" rel="noopener" class="bbc_link">RGPD</a>.';
// The GDPR page of the EU exists in several languages; change the language code at the end of the url
$helptxt['requirePolicyAgreement'] = 'Ce paramètre doit être activé afin de respecter les règles de la <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_en" target="_blank" rel="noopener" class="bbc_link">RGPD</a>.';
$helptxt['gravatar'] = 'Gravatar est un avatar reconnu dans le monde entier. Enregistrez un compte sur <a href="https://www.gravatar.com" target="_blank" rel="noopener">https://www.gravatar.com</a> pour sélectionner une image avatar. Cet avatar est ensuite disponible sur tous les sites qui prennent en charge les gravatars. Si vous n\'avez pas de compte gravatar, une image par défaut sera utilisée.';

?>