<?php
// Version: 2.1.0; EmailTemplates

// Since all of these strings are being used in emails, numeric entities should be used.

// Do not translate anything that is between {}, they are used as replacement variables and MUST remain exactly how they are.
//   Additionally, do not translate the @additional_params: line or the variable names in the lines that follow it. You may
//   translate the description of the variable. Do not translate @description:, however you may translate the rest of that line.

// Do not use block comments in this file, they will have special meaning.

global $txtBirthdayEmails;

/**
	@additional_params: resend_activate_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONCODE:  The code needed to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['resend_activate_message_subject'] = 'Welkom op {FORUMNAME}';
$txt['resend_activate_message_body'] = 'Bedankt voor het registreren op {FORUMNAME}. Je gebruikersnaam is {USERNAME}. Mocht je het wachtwoord vergeten, dan kun je dit hier {FORGOTPASSWORDLINK} opnieuw instellen. 

Voordat je kunt inloggen, dien je eerste je account te activeren met de volgende link: 

{ACTIVATIONLINK}

Mocht het niet lukken om te activeren, ga dan naar {ACTIVATIONLINKWITHOUTCODE} en gebruik deze code "{ACTIVATIONCODE}". 

{REGARDS}';

/**
	@additional_params: resend_pending_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
	@description:
*/
$txt['resend_pending_message_subject'] = 'Welkom op {FORUMNAME}';
$txt['resend_pending_message_body'] = 'Hallo {REALNAME}, je registratie-aanvraag op {FORUMNAME} is ontvangen. 

De gebruikersnaam waarmee je geregistreerd hebt is {USERNAME}. 

Voordat je kunt inloggen en het forum gebruiken moet je aanvraag worden beoordeeld en goedgekeurd. Zodra dat gebeurd is zul je een nieuwe email van dit adres ontvangen. 

{REGARDS}';

/**
	@additional_params: mc_group_approve
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was accepted into.
	@description: The request to join a particular membergroup has been accepted.
*/
$txt['mc_group_approve_subject'] = 'Goedkeuring groepslidmaatschap';
$txt['mc_group_approve_body'] = '{USERNAME}, 

Hierbij laten we je weten dat je aanvraag voor lidmaatschap van de "{GROUPNAME}" groep op {FORUMNAME} is geaccepteerd en dat je account is toegevoegd aan deze ledengroep. 

{REGARDS}';

/**
	@additional_params: mc_group_reject
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
	@description: The request to join a particular membergroup has been rejected.
*/
$txt['mc_group_reject_subject'] = 'Afwijzing groepslidmaatschap';
$txt['mc_group_reject_body'] = '{USERNAME}, 

Helaas moeten we je informeren dat je aanvraag voor lidmaatschap van de "{GROUPNAME}" groep op {FORUMNAME} is afgewezen. 

{REGARDS}';

/**
	@additional_params: mc_group_reject_reason
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
		REASON: Reason for the rejection.
	@description: The request to join a particular membergroup has been rejected with a reason given.
*/
$txt['mc_group_reject_reason_subject'] = 'Afwijzing groepslidmaatschap';
$txt['mc_group_reject_reason_body'] = '{USERNAME}, 

Helaas moeten we je informeren dat je aanvraag voor lidmaatschap van de "{GROUPNAME}" groep op {FORUMNAME} is afgewezen. 

De reden hiervoor is de volgende: {REASON} 

{REGARDS}';

/**
	@additional_params: admin_approve_accept
		NAME: The display name of the member.
		USERNAME: The user name for the member receiving the email.
		PROFILELINK: The URL of the profile page.
		FORGOTPASSWORDLINK: The URL of the "forgot password" page.
	@description:
*/
$txt['admin_approve_accept_subject'] = 'Welkom op {FORUMNAME}';
$txt['admin_approve_accept_body'] = 'Welkom, {NAME} 

Je account is handmatig geactiveerd door de beheerder en je kunt nu inloggen. Je gebruikersnaam is: {USERNAME}. Mocht je het wachtwoord vergeten, dan kun je dit hier wijzigen {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: admin_approve_activation
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_activation_subject'] = 'Welkom op {FORUMNAME}';
$txt['admin_approve_activation_body'] = 'Welkom, {USERNAME}! 

Je account op {FORUMNAME} is goedgekeurd door de forum beheerder. Voordat je kunt inloggen moet je eerst je account activeren middels deze link:

{ACTIVATIONLINK} 

Mocht je problemen ondervinden met de activatie, bezoek dan {ACTIVATIONLINKWITHOUTCODE} en gebruik deze code "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: admin_approve_reject
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_reject_subject'] = 'Registratie verworpen';
$txt['admin_approve_reject_body'] = '{USERNAME}, 

Helaas, je aanmelding voor lidmaatschap op {FORUMNAME} is afgewezen. 

{REGARDS}';

/**
	@additional_params: admin_approve_delete
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_delete_subject'] = 'Account verwijderd';
$txt['admin_approve_delete_body'] = '{USERNAME}, 

Je account op {FORUMNAME} is verwijderd. Dit kan zijn omdat je nooit je account hebt geactiveerd. In dat geval kun je opnieuw registreren. 

{REGARDS}';

/**
	@additional_params: admin_approve_remind
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_remind_subject'] = 'Registratieherinnering';
$txt['admin_approve_remind_body'] = '{USERNAME}, 
Je hebt je account op {FORUMNAME} nog niet geactiveerd. 

Gebruik deze link om je account te activeren: {ACTIVATIONLINK} 

Mocht het niet lukken om te activeren, bezoek dan deze link {ACTIVATIONLINKWITHOUTCODE} en gebruik de activatiecode "{ACTIVATIONCODE}". 

{REGARDS}';

/**
	@additional_params:
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_register_activate_subject'] = 'Welkom op {FORUMNAME}';
$txt['admin_register_activate_body'] = 'Bedankt voor je registratie op {FORUMNAME}. Je gebruikersnaam is {USERNAME} en je wachtwoord is {PASSWORD}.

Voordat je kunt inloggen moet je je account activeren middels de volgende link:

{ACTIVATIONLINK}

Mocht je problemen hebben met activeren, bezoek dan
{ACTIVATIONLINKWITHOUTCODE} en gebruik deze activatiecode "{ACTIVATIONCODE}".

{REGARDS}';

$txt['admin_register_immediate_subject'] = 'Welkom op {FORUMNAME}';
$txt['admin_register_immediate_body'] = 'Bedankt voor het registreren op {FORUMNAME}. Je gebruikersnaam is {USERNAME}, je wachtwoord is {PASSWORD} en de forum URL is: {SCRIPTURL}.

{REGARDS}';

/**
	@additional_params: new_announcement
		TOPICSUBJECT: The subject of the topic being announced.
		MESSAGE: The message body of the first post of the announced topic.
		TOPICLINK: A link to the topic being announced.
		UNSUBSCRIBELINK: Link to unsubscribe from announcements.
	@description:
*/
$txt['new_announcement_subject'] = 'Nieuwe aankondiging: {TOPICSUBJECT}';
$txt['new_announcement_body'] = '{MESSAGE}

Je kunt het volledige bericht bekijken door deze link te volgen:
{TOPICLINK}

Klik hier om je af te melden voor deze berichten:
{UNSUBSCRIBELINK}

Om instellingen voor het ontvangen van deze aankondigingen te veranderen, log in op het forum en verander de Notificatie-instellingen in je profiel.

{REGARDS}';

/**
	@additional_params: notify_boards_once_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_body_subject'] = 'Nieuw Topic: {TOPICSUBJECT}';
$txt['notify_boards_once_body_body'] = 'Een nieuw topic, \'{TOPICSUBJECT}\', is geplaatst op een board dat jij volgt.

Je kunt het zien op
{TOPICLINK}

Het kan zijn dat er meerdere topics geplaatst worden, maar je zult geen e-mail notificaties meer ontvangen tot je het board bezocht hebt.

De tekst van het topic vind je hieronder:
{MESSAGE} 

Klik hier om je af te melden voor notificaties van topics in dit board:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_subject'] = 'Nieuw Topic: {TOPICSUBJECT}';
$txt['notify_boards_once_body'] = 'Een nieuw topic, \'{TOPICSUBJECT}\', is geplaatst in een board dat jij momenteel volgt.

Je kunt het zien op
{TOPICLINK}

Het kan zijn dat er meerdere topics geplaatst worden, maar je zult geen e-mail notificaties meer ontvangen tot je het board bezocht hebt.

Klik hier om je af te melden voor notificaties van topics in dit board:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_body_subject'] = 'Nieuw Topic: {TOPICSUBJECT}';
$txt['notify_boards_body_body'] = 'Een nieuw topic, \'{TOPICSUBJECT}\', is geplaatst in een board dat jij momenteel volgt.

Je kunt het hier zien
{TOPICLINK}

De tekst van het topic is hieronder weergegeven:
{MESSAGE}

Klik hier om je af te melden voor notificaties van topics in dit board:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_subject'] = 'Nieuw Topic: {TOPICSUBJECT}';
$txt['notify_boards_body'] = 'Een nieuw topic, \'{TOPICSUBJECT}\', is geplaatst in een board dat jij momenteel volgt.

Je kunt het hier zien
{TOPICLINK}

Klik hier om je af te melden voor notificaties van topics in dit board:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_reply
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_reply_subject'] = 'Antwoord op topic: {SUBJECT}';
$txt['alert_unapproved_reply_body'] = 'Er is een antwoord geplaatst op \'{SUBJECT}\' door {POSTERNAME}.

Je kunt het hier bekijken:
{LINK}

{REGARDS}';

/**
	@additional_params: unapproved_attachment
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the message with the attachment.
	@description:
*/
$txt['unapproved_attachment_subject'] = 'Er is een nieuwe bijlage voor goedkeuring in: {SUBJECT}';
$txt['unapproved_attachment_body'] = 'Er is een nieuwe bijlage toegevoegd aan \'{SUBJECT}\' welke beoordeeld moet worden. 

Je kunt de bijlage goed- of afkeuren middels de link hieronder: deze brengt je meteen naar het juiste bericht voor de bijlage.

{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_post
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_post_subject'] = 'Nieuw goed te keuren bericht: {SUBJECT}';
$txt['alert_unapproved_post_body'] = 'Er is een nieuw bericht geplaatst dat moet worden beoordeeld: \'{SUBJECT}\' 

Je kunt dit bericht goed- of afkeuren door op de link hieronder te klikken: 
{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_topic
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_topic_subject'] = 'Nieuw goed te keuren topic: {SUBJECT}';
$txt['alert_unapproved_topic_body'] = 'Er is een nieuw topic geplaatst dat moet worden beoordeeld: \'{SUBJECT}\' 

Je kunt dit topic goed- of afkeuren door op de link hieronder te klikken: 
{LINK}

{REGARDS}';

/**
	@additional_params: request_membership
		RECPNAME: The name of the person receiving the email
		APPLYNAME: The name of the person applying for group membership
		GROUPNAME: The name of the group being applied to.
		REASON: The reason given by the applicant for wanting to join the group.
		MODLINK: Link to the group moderation page.
	@description:
*/
$txt['request_membership_subject'] = 'Nieuwe groepsaanvraag';
$txt['request_membership_body'] = '{RECPNAME},

{APPLYNAME} heeft lidmaatschap van de "{GROUPNAME}" groep aangevraagd. De deelnemer heeft volgende reden opgegeven:

{REASON}

Je kunt de aanvraag goedkeuren of afwijzen middels de link hieronder:

{MODLINK}

{REGARDS}';

/**
	@additional_params: paid_subscription
		REALNAME: The real (display) name of the person receiving the email.
		PROFILE_LINK: Link to profile of member receiving email where can renew.
		SUBSCRIPTION: Name of the subscription.
		END_DATE: Date it expires.
	@description:
*/
$txt['paid_subscription_reminder_subject'] = 'Je abonnement op {FORUMNAME} gaat verlopen';
$txt['paid_subscription_reminder_body'] = '{REALNAME},

Een abonnement op {FORUMNAME} zal binnenkort verlopen. Als je ten tijde van de inschrijving hebt gekozen voor automatisch vernieuwen hoef je niets te doen, is dat niet het geval dan kun je overwegen om je opnieuw te abonneren. Details vind je hieronder:

Naam van abonnement: {SUBSCRIPTION}
Verloopt: {END_DATE}

Om je abonnementen te wijzigen klik op de link hieronder:
{PROFILE_LINK}

{REGARDS}';

/**
	@additional_params: activate_reactivate
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
	@description:
*/
$txt['activate_reactivate_subject'] = 'Welkom terug op {FORUMNAME}';
$txt['activate_reactivate_body'] = 'Je account is gedeactiveerd zodat je het e-mailadres opnieuw kunt valideren. Klik op deze link om je account opnieuw te activeren: 
{ACTIVATIONLINK} 

Mocht je problemen ondervinden bij het activeren, bezoek dan deze link {ACTIVATIONLINKWITHOUTCODE} en gebruik deze code "{ACTIVATIONCODE}". 

{REGARDS}';

/**
	@additional_params: forgot_password
		REALNAME: The real (display) name of the person receiving the reminder.
		REMINDLINK: The link to reset the password.
		IP: The IP address of the requester.
		MEMBERNAME:
	@description:
*/
$txt['forgot_password_subject'] = 'Nieuw wachtwoord voor {FORUMNAME}';
$txt['forgot_password_body'] = 'Beste {REALNAME}, 
Je ontvangt deze mail omdat iemand een wachtwoord herinnering heeft aangevraagd voor jouw account. Om een nieuw wachtwoord in te stellen kun je volgende link gebruiken: {REMINDLINK} 

IP: {IP} 
Gebruikersnaam: {MEMBERNAME}

{REGARDS}';

/**
	@additional_params: send_email
		EMAILSUBJECT: The subject the user wants to email.
		EMAILBODY: The body the user wants to email.
		SENDERNAME: The name of the member sending the email.
		RECPNAME: The name of the person receiving the email.
	@description:
*/
$txt['send_email_subject'] = '{EMAILSUBJECT}';
$txt['send_email_body'] = '{EMAILBODY}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		REPORTERNAME: The name of the person reporting the post.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
		COMMENT: The comment left by the reporter, hopefully to explain why they are reporting the post.
	@description: When a user reports a post this email is sent out to moderators and admins of that board.
*/
$txt['report_to_moderator_subject'] = 'Gerapporteerd bericht: {TOPICSUBJECT} door {POSTERNAME}';
$txt['report_to_moderator_body'] = 'Het volgende bericht, "{TOPICSUBJECT}" van {POSTERNAME} is gemeld door {REPORTERNAME} op een board dat jij modereert:

Het topic: {TOPICLINK}
Moderatie centrum: {REPORTLINK}

De melder heeft de volgende opmerking toegevoegd:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		COMMENTERNAME: The name of the person who replied to the report.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
	@description: When a moderator replies to a moderation report, this can be sent to the other moderators who previously replied.
*/
$txt['reply_to_moderator_subject'] = 'Volg op het gerapporteerde bericht: {TOPICSUBJECT} van {POSTERNAME}';
$txt['reply_to_moderator_body'] = 'Dit bericht, "{TOPICSUBJECT}" is gerapporteerd aan de moderators.

Daarna heeft {COMMENTERNAME} een reactie gegeven op dit rapport. Meer informatie kun je vinden in het forum.

Het topic: {TOPICLINK}
Moderatie centrum: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		REPORTERNAME: The name of the person reporting the profile
		PROFILELINK: The link to the profile that was reported
		COMMENT: The comment left by the reporter.
 	@description: When a user's profile is reported
*/
$txt['report_member_profile_subject'] = 'Gerapporteerd profiel: {MEMBERNAME}';
$txt['report_member_profile_body'] = 'Het profiel van"{MEMBERNAME}" is gemeld door {REPORTERNAME}.

Het profiel: {PROFILELINK}
Moderatie centrum: {REPORTLINK}

De melder heeft de volgende opmerking toegevoegd:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		COMMENTERNAME: The name of the person who added the comment
		PROFILELINK: The link to the profile that was reported
 	@description: When someone replies to a report about a profile, this can be sent to others who replied
*/
$txt['reply_to_member_report_subject'] = 'Gerapporteerd profiel opvolgen: {MEMBERNAME}';
$txt['reply_to_member_report_body'] = 'Het profiel van {MEMBERNAME} is gemeld.

Sindsdien heeft, {COMMENTERNAME} een opmerking aan het rapport toegevoegd. Meer informatie kun je vinden in het forum.

Het profiel: {PROFILELINK}
Moderatie centrum: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: change_password
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
	@description:
*/
$txt['change_password_subject'] = 'Nieuwe wachtwoordgegevens';
$txt['change_password_body'] = 'Beste {USERNAME},

Je login gegevens op {FORUMNAME} zijn gewijzigd en je wachtwoord is opnieuw ingesteld. Hieronder vind je de nieuwe inlog gegevens.

Je gebruikersnaam is "{USERNAME}" en je wachtwoord is "{PASSWORD}".

Na inloggen kun je dit wijzigen op je profiel pagina, of door in te loggen en naar deze pagina te gaan:
{SCRIPTURL}?action=profile

{REGARDS}';

/**
	@additional_params: register_activate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_activate_subject'] = 'Welkom op {FORUMNAME}';
$txt['register_activate_body'] = 'Bedankt voor het registreren op {FORUMNAME}. Je gebruikersnaam is {USERNAME}. Mocht je het wachtwoord vergeten, dan kun je dit hier {FORGOTPASSWORDLINK} opnieuw instellen. 

Voordat je kunt inloggen, dien je eerste je account te activeren met de volgende link: 

{ACTIVATIONLINK}

Mocht het niet lukken om te activeren, ga dan naar {ACTIVATIONLINKWITHOUTCODE} en gebruik deze code "{ACTIVATIONCODE}". 

{REGARDS}';

/**
	@additional_params: register_coppa
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		COPPALINK:  The URL link to the coppa form.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_coppa_subject'] = 'Welkom op {FORUMNAME}';
$txt['register_coppa_body'] = 'Bedankt voor het registreren bij {FORUMNAME}. Je gebruikersnaam is {USERNAME}. Mocht je het wachtwoord vergeten, dan kun je dit hier {FORGOTPASSWORDLINK} opnieuw instellen. 

Voordat je kunt inloggen, heeft de beheerder toestemming van je ouder / voogd nodig om lid te worden van de community. Je kunt meer informatie vinden via de onderstaande link:

{COPPALINK}

{REGARDS}';

/**
	@additional_params: register_immediate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_immediate_subject'] = 'Welkom op {FORUMNAME}';
$txt['register_immediate_body'] = 'Bedankt voor je registratie op {FORUMNAME}. Je gebruikersnaam is {USERNAME}. Mocht je het wachtwoord vergeten, dan kun je dit hier opnieuw instellen {FORGOTPASSWORDLINK}. 

{REGARDS}';

/**
	@additional_params: register_pending
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_pending_subject'] = 'Welkom op {FORUMNAME}';
$txt['register_pending_body'] = 'Hallo {REALNAME}, je registratie aanvraag op {FORUMNAME} is ontvangen. 

De gebruikersnaam waarmee je geregistreerd hebt is {USERNAME}. Mocht je het wachtwoord vergeten, dan kun je dit hier {FORGOTPASSWORDLINK} opnieuw instellen. 

Voordat je kunt inloggen en het forum gebruiken moet je aanvraag worden beoordeeld en goedgekeurd. 

{REGARDS}';

/**
	@additional_params: notification_reply
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_subject'] = 'Antwoord op topic: {TOPICSUBJECT}';
$txt['notification_reply_body'] = 'Er is een reactie geplaatst door {POSTERNAME} in een topic dat je volgt.

Bekijk de reactie hier: {TOPICLINK}

Klik hier als je geen meldingen van dit topic meer wilt ontvangen: 
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_reply_body
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_subject'] = 'Antwoord op topic: {TOPICSUBJECT}';
$txt['notification_reply_body_body'] = 'Er is een reactie geplaatst door {POSTERNAME} in een topic dat je volgt.

Bekijk de reactie hier: {TOPICLINK}

Klik hier als je geen meldingen van dit topic meer wilt ontvangen: 
{UNSUBSCRIBELINK}

De tekst van de reactie staat hieronder:
{MESSAGE}

{REGARDS}';

/**
	@additional_params: notification_reply_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_once_subject'] = 'Antwoord op topic: {TOPICSUBJECT}';
$txt['notification_reply_once_body'] = 'Er is een reactie geplaatst door {POSTERNAME} in een topic dat je volgt.

Bekijk de reactie hier: {TOPICLINK}

Klik hier als je geen meldingen van dit topic meer wilt ontvangen: 
{UNSUBSCRIBELINK}

Als er meer reacties worden geplaatst zul je hier geen meldingen van ontvangen tot je het topic bezocht hebt.

{REGARDS}';

/**
	@additional_params: notification_reply_body_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_once_subject'] = 'Antwoord op topic: {TOPICSUBJECT}';
$txt['notification_reply_body_once_body'] = 'Er is een reactie geplaatst door {POSTERNAME} in een topic dat je volgt.

Bekijk de reactie hier: {TOPICLINK}

Klik hier als je geen meldingen van dit topic meer wilt ontvangen: 
{UNSUBSCRIBELINK}

De tekst van de reactie staat hieronder:
{MESSAGE}

Als er meer reacties worden geplaatst zul je hier geen meldingen van ontvangen tot je het topic bezocht hebt.

{REGARDS}';

/**
	@additional_params: notification_sticky
	@description:
*/
$txt['notification_sticky_subject'] = 'Topic sticky gemaakt: {TOPICSUBJECT}';
$txt['notification_sticky_body'] = 'Een topic dat je volgt is sticky gemaakt.

Bekijk het topic hier: {TOPICLINK}

Klik hier als je geen meldingen van dit topic meer wilt ontvangen: 
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_lock
	@description:
*/
$txt['notification_lock_subject'] = 'Topic gesloten: {TOPICSUBJECT}';
$txt['notification_lock_body'] = 'Een topic dat je volgt is gesloten.

Bekijk het topic hier: {TOPICLINK}

Klik hier als je geen meldingen van dit topic meer wilt ontvangen: 
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_unlock
	@description:
*/
$txt['notification_unlock_subject'] = 'Slot verwijderd van topic: {TOPICSUBJECT}';
$txt['notification_unlock_body'] = 'Een topic dat je volgt is heropend.

Bekijk het topic hier: {TOPICLINK}

Klik hier als je geen meldingen van dit topic meer wilt ontvangen: 
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_remove
	@description:
*/
$txt['notification_remove_subject'] = 'Topic verwijderd: {TOPICSUBJECT}';
$txt['notification_remove_body'] = 'Een topic dat jij volgde is verwijderd.

{REGARDS}';

/**
	@additional_params: notification_move
	@description:
*/
$txt['notification_move_subject'] = 'Topic verplaatst: {TOPICSUBJECT}';
$txt['notification_move_body'] = 'Een topic dat je volgt is verplaatst naar een ander board.

Bekijk het topic hier: {TOPICLINK}

Klik hier als je geen meldingen van dit topic meer wilt ontvangen: 
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_merged
	@description:
*/
$txt['notification_merge_subject'] = 'Topic samengevoegd: {TOPICSUBJECT}';
$txt['notification_merge_body'] = 'Een topic dat je volgt is samengevoegd met een ander topic.

Bekijk het nieuwe, samengevoegde, topic hier: {TOPICLINK}

Klik hier als je geen meldingen van dit topic meer wilt ontvangen: 
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_split
	@description:
*/
$txt['notification_split_subject'] = 'Topic gesplitst: {TOPICSUBJECT}';
$txt['notification_split_body'] = 'Een topic dat je volgt is gesplitst en twee of meer topics.

Bekijk het resterende topic hier: {TOPICLINK}

Klik hier als je geen meldingen van dit topic meer wilt ontvangen: 
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: admin_notify
		USERNAME:
		PROFILELINK:
	@description:
*/
$txt['admin_notify_subject'] = 'Een nieuw lid is aangemeld';
$txt['admin_notify_body'] = '{USERNAME} heeft zich net geregistreerd als nieuw lid op je forum. Klik op deze link om het profiel te bekijken. {PROFILELINK} 

{REGARDS}';

/**
	@additional_params: admin_notify_approval
		USERNAME:
		PROFILELINK:
		APPROVALLINK:
	@description:
*/
$txt['admin_notify_approval_subject'] = 'Een nieuw lid heeft zich geregistreerd';
$txt['admin_notify_approval_body'] = '{USERNAME} heeft zich net aangemeld als nieuw lid op je forum. Klik op de link hieronder om het profiel te bekijken.
{PROFILELINK}

Voordat dit lid berichten kan plaatsen moet zijn account eerst goedgekeurd worden. Klik op de link hieronder om de account goed te keuren.
{APPROVALLINK}

{REGARDS}';

/**
	@additional_params: admin_attachments_full
		REALNAME:
	@description:
*/
$txt['admin_attachments_full_subject'] = 'Belangrijk! De bijlagenmap is bijna vol';
$txt['admin_attachments_full_body'] = '{REALNAME},

De bijlagenmap op {FORUMNAME} is bijna vol. Bezoek het forum om dit probleem op te lossen.

Zodra de bijlagenmap zijn maximaal toegestane grootte bereikt heeft zullen gebruikers geen nieuwe bijlagen meer kunnen toevoegen of eigen avatars toevoegen (indien van toepassing).

{REGARDS}';

/**
	@additional_params: paid_subscription_refund
		NAME: Subscription title.
		REALNAME: Recipients name
		REFUNDUSER: Username who took out the subscription.
		REFUNDNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_refund_subject'] = 'Terugbetaald abonnement';
$txt['paid_subscription_refund_body'] = '{REALNAME},

Een lid heeft een terugbetaling ontvangen op zijn abonnement. Hieronder de details van het abonnement:

	Abonnement: {NAME}
	Gebruikersnaam: {REFUNDNAME} ({REFUNDUSER})
	Datum: {DATE}

Je kunt het profiel van dit lid hier bekijken:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_new
		NAME: Subscription title.
		REALNAME: Recipients name
		SUBEMAIL: Email address of the user who took out the subscription
		SUBUSER: Username who took out the subscription.
		SUBNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_new_subject'] = 'Nieuwe betaald abonnement';
$txt['paid_subscription_new_body'] = '{REALNAME},

Een lid heeft een nieuw betaald abonnement genomen. Hieronder de details van het abonnement:

	Abonnement: {NAME}
	Gebruikersnaam: {SUBNAME} ({SUBUSER})
	E-mail: {SUBEMAIL}
	Prijs: {PRICE}
	Datum: {DATE}

Je kunt het profiel van dit lid hier bekijken:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_error
		ERROR: Error message.
		REALNAME: Recipients name
	@description:
*/
$txt['paid_subscription_error_subject'] = 'Er is fout opgetreden met een betaald abonnement';
$txt['paid_subscription_error_body'] = 'Beste {REALNAME}, 

De volgende fout is opgetreden bij het verwerken van een betaald abonnement 
--------------------------------------------------------------- 
{ERROR} 

{REGARDS}';

/**
	@additional_params: new_pm
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_subject'] = 'Nieuw Persoonlijk Bericht: {SUBJECT}';
$txt['new_pm_body'] = 'Je hebt net een persoonlijk bericht ontvangen van {SENDER} op {FORUMNAME}.

BELANGRIJK: Dit is alleen een kennisgeving. Gelieve niet op deze mail te antwoorden.

Lees het persoonlijk bericht hier: {READLINK}

Beantwoord het persoonlijk bericht hier: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_subject'] = 'Nieuw Persoonlijk Bericht: {SUBJECT}';
$txt['new_pm_body_body'] = 'Je hebt net een persoonlijk bericht ontvangen van {SENDER} op {FORUMNAME}.

BELANGRIJK: Dit is alleen een kennisgeving. Gelieve niet op deze mail te antwoorden.

De tekst van het bericht:

{MESSAGE}

Beantwoord het persoonlijk bericht hier: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_tolist_subject'] = 'Nieuw Persoonlijk Bericht: {SUBJECT}';
$txt['new_pm_tolist_body'] = 'Jij en {TOLIST} hebben net een persoonlijk bericht ontvangen van {SENDER} op {FORUMNAME}.

BELANGRIJK: Dit is alleen een kennisgeving. Gelieve niet op deze mail te antwoorden.

Lees het persoonlijk bericht hier: {READLINK}

Beantwoord het persoonlijk bericht (alleen aan de afzender) hier: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_tolist_subject'] = 'Nieuw Persoonlijk Bericht: {SUBJECT}';
$txt['new_pm_body_tolist_body'] = 'Jij en {TOLIST} hebben net een persoonlijk bericht ontvangen van {SENDER} op {FORUMNAME}.

BELANGRIJK: Dit is alleen een kennisgeving. Gelieve niet op deze mail te antwoorden.

De tekst van het bericht:

{MESSAGE}

Beantwoord het persoonlijk bericht (alleen aan de afzender) hier: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: msg_quote
		CONTENTSUBJECT: The post subject.
		QUOTENAME:  The user name for the member creating the quote
		MEMBERNAME:  The user name for the member being quoted
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been quoted in a post
 */
$txt['msg_quote_subject'] = 'Iemand heeft je geciteerd in bericht: {CONTENTSUBJECT}';
$txt['msg_quote_body'] = 'Hallo {MEMBERNAME},

Je bent geciteerd in bericht getiteld "{CONTENTSUBJECT}" door {QUOTENAME}, je kunt het bericht hier bekijken:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: msg_mention
		CONTENTSUBJECT: The post subject.
		MENTIONNAME:  The user name for the member creating the mention
		MEMBERNAME:  The user name for the member being mentioned
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been mentioned in a post
 */
$txt['msg_mention_subject'] = 'Iemand heeft jou vermeld in bericht: {CONTENTSUBJECT}';
$txt['msg_mention_body'] = 'Hallo {MEMBERNAME},

Je bent vermeld in bericht getiteld "{CONTENTSUBJECT}" door {MENTIONNAME}, je kunt het bericht hier bekijken:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: happy_birthday
		REALNAME: The real (display) name of the person receiving the birthday message.
	@description: A message sent to members on their birthday.
*/
$txtBirthdayEmails['happy_birthday_subject'] = 'Fijne verjaardag van {FORUMNAME}.';
$txtBirthdayEmails['happy_birthday_body'] = 'Beste {REALNAME},

Wij van {FORUMNAME} willen je een fijne verjaardag wensen. Moge deze dag en dit jaar je veel plezier geven.

{REGARDS}';
$txtBirthdayEmails['happy_birthday_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=2676">Thantos</a>';

$txtBirthdayEmails['karlbenson1_subject'] = 'Op jouw verjaardag...';
$txtBirthdayEmails['karlbenson1_body'] = 'We hadden je een verjaardagskaart kunnen sturen. We hadden je bloemen of een taart kunnen sturen.

Maar dat hebben we niet gedaan.

We hadden je zelfs een van die automatisch gegenereerde berichten kunnen sturen om je een fijne verjaardag te wensen, waarbij we NAAM INVOEGEN niet eens hoeven te vervangen.

Maar dat hebben we niet gedaan.

We hebben deze verjaardagsgroet speciaal voor jou geschreven.

We willen je een heel speciale verjaardag wensen.

{REGARDS}

// :: Dit bericht is automatisch gegenereerd :: //';
$txtBirthdayEmails['karlbenson1_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

$txtBirthdayEmails['nite0859_subject'] = 'Fijne Verjaardag!';
$txtBirthdayEmails['nite0859_body'] = 'Je vrienden van {FORUMNAME} willen je graag een fijne verjaardag wensen, {REALNAME}. Mocht je een tijdje niet op het forum zijn geweest, kom dan gauw weer eens langs, zodat ook de andere leden je kunnen feliciteren.

Hoewel het jouw verjaardag is, {REALNAME}, is jouw deelname aan ons forum altijd een cadeautje geweest voor alle deelnemers van ons forum.

De beste wensen,
De beheerders van {FORUMNAME}';
$txtBirthdayEmails['nite0859_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=46625">nite0859</a>';

$txtBirthdayEmails['zwaldowski_subject'] = 'Beste verjaardagswensen aan {REALNAME}';
$txtBirthdayEmails['zwaldowski_body'] = 'Beste {REALNAME}, 

er is weer een jaar voorbij. Wij van {FORUMNAME} hopen dat het een gelukkig jaar is geweest en wensen je veel geluk in het jaar dat nu komt. 

{REGARDS}';
$txtBirthdayEmails['zwaldowski_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=72038">zwaldowski</a>';

$txtBirthdayEmails['geezmo_subject'] = 'Fijne verjaardag, {REALNAME}!';
$txtBirthdayEmails['geezmo_body'] = 'Weet jij wie er vandaag jarig is, {REALNAME}? 

Wij wel... JIJ! 

Van harte gefeliciteerd! 

Je bent nu een jaar ouder, maar we hopen dat je veel gelukkiger bent dan een jaar geleden. 

Geniet van vandaag, {REALNAME}! 

- Van je {FORUMNAME} familie';
$txtBirthdayEmails['geezmo_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=48671">geezmo</a>';

$txtBirthdayEmails['karlbenson2_subject'] = 'Jouw verjaardagsgroet';
$txtBirthdayEmails['karlbenson2_body'] = 'We wensen jou de beste verjaardag ooit; bewolkt, zonnig of wat voor weer het ook is.
Veel verjaardagstaart en plezier, en laat ons wat je hebt gedaan.

We hopen dat deze boodschap je vrolijk maakt en maak er wat van, tot volgend jaar op dezelfde tijd op dezelfde plaats.

{REGARDS}';
$txtBirthdayEmails['karlbenson2_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

?>