-- 
-- Database: `kplay`
-- 

-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]archive`
-- 

CREATE TABLE `[[dbprefix]]archive` (
  `aid` int(4) NOT NULL auto_increment,
  `uid` int(4) NOT NULL default '0',
  `utime` bigint(8) NOT NULL default '0',
  `fpath` mediumblob NOT NULL,
  PRIMARY KEY  (`aid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]archive`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]bulletin`
-- 

CREATE TABLE `[[dbprefix]]bulletin` (
  `bid` int(4) NOT NULL auto_increment,
  `u_id` int(4) NOT NULL default '0',
  `utime` int(4) NOT NULL default '0',
  `publish` int(4) NOT NULL default '0',
  `mesg` text NOT NULL,
  PRIMARY KEY  (`bid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]bulletin`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]cache`
-- 

CREATE TABLE `[[dbprefix]]cache` (
  `cacheid` int(4) NOT NULL auto_increment,
  `id` int(4) NOT NULL default '0',
  `value` text NOT NULL,
  PRIMARY KEY  (`cacheid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]cache`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]config`
-- 

CREATE TABLE `[[dbprefix]]config` (
  `id` int(4) NOT NULL auto_increment,
  `key` varchar(255) NOT NULL default '',
  `value` text NOT NULL,
  `vtype` int(2) NOT NULL default '0',
  UNIQUE KEY `id` (`id`,`key`),
  KEY `key` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]config`
-- 

INSERT INTO `[[dbprefix]]config` VALUES (1, 'windows', '1', 1);
INSERT INTO `[[dbprefix]]config` VALUES (2, 'includeheaders', '1', 1);
INSERT INTO `[[dbprefix]]config` VALUES (3, 'publicrssfeed', '0', 1);
INSERT INTO `[[dbprefix]]config` VALUES (4, 'externalcss', '', 0);
INSERT INTO `[[dbprefix]]config` VALUES (5, 'externaljavascript', '', 0);

-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]filetypes`
-- 

CREATE TABLE `[[dbprefix]]filetypes` (
  `id` int(4) NOT NULL auto_increment,
  `extension` varchar(32) NOT NULL default '',
  `mime` varchar(128) NOT NULL default '',
  `m3u` char(1) NOT NULL default '',
  `getid` int(4) NOT NULL default '0',
  `search` char(1) NOT NULL default '1',
  `logaccess` char(1) NOT NULL default '1',
  `enabled` char(1) NOT NULL default '1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]filetypes`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]iceradio`
-- 

CREATE TABLE `[[dbprefix]]iceradio` (
  `stationid` int(4) NOT NULL auto_increment,
  `name` varchar(64) NOT NULL default '',
  `playlistid` int(11) NOT NULL default '0',
  `lactive` int(4) NOT NULL default '0',
  `curseq` int(4) NOT NULL default '0',
  `nextseq` int(4) NOT NULL default '0',
  `pass` varchar(64) NOT NULL default '',
  `loop` char(1) NOT NULL default '0',
  PRIMARY KEY  (`stationid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]iceradio`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]kplayversion`
-- 

CREATE TABLE `[[dbprefix]]kplayversion` (
  `app_ver` varchar(6) NOT NULL default '',
  `app_build` varchar(6) NOT NULL default '',
  `app_finstall` int(4) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]kplayversion`
-- 

INSERT INTO `[[dbprefix]]kplayversion` VALUES ('1.8', '0', [[timestamp]]);

-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]message`
-- 

CREATE TABLE `[[dbprefix]]message` (
  `meid` int(4) NOT NULL auto_increment,
  `uid` int(4) NOT NULL default '0',
  `utime` bigint(8) NOT NULL default '0',
  `message` text NOT NULL,
  PRIMARY KEY  (`meid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]message`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]mhistory`
-- 

CREATE TABLE `[[dbprefix]]mhistory` (
  `h_id` int(4) NOT NULL auto_increment,
  `u_id` int(4) NOT NULL default '0',
  `s_id` int(4) NOT NULL default '0',
  `tid` tinyint(4) NOT NULL default '0',
  `utime` int(4) NOT NULL default '0',
  `dwritten` int(4) NOT NULL default '0',
  `dpercent` int(4) NOT NULL default '0',
  `cpercent` int(4) NOT NULL default '0',
  `active` tinyint(4) NOT NULL default '0',
  `mid` int(4) NOT NULL default '0',
  PRIMARY KEY  (`h_id`),
  KEY `s_id` (`s_id`),
  KEY `u_id` (`u_id`),
  KEY `utime` (`utime`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]mhistory`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]network`
-- 

CREATE TABLE `[[dbprefix]]network` (
  `nid` int(4) NOT NULL auto_increment,
  `enabled` char(1) NOT NULL default '1',
  `url` text NOT NULL,
  `username` varchar(64) NOT NULL default '0',
  `password` varchar(64) NOT NULL default '0',
  PRIMARY KEY  (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]network`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]playlist`
-- 

CREATE TABLE `[[dbprefix]]playlist` (
  `u_id` int(4) NOT NULL default '0',
  `name` varchar(32) NOT NULL default '',
  `public` char(1) NOT NULL default '0',
  `status` tinyint(1) NOT NULL default '0',
  `listid` int(11) NOT NULL auto_increment,
  PRIMARY KEY  (`listid`),
  UNIQUE KEY `u_login` (`u_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]playlist`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]playlist_list`
-- 

CREATE TABLE `[[dbprefix]]playlist_list` (
  `listid` int(11) NOT NULL default '0',
  `id` int(11) NOT NULL auto_increment,
  `sid` int(4) NOT NULL default '0',
  `seq` int(4) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `listid` (`listid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]playlist_list`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]search`
-- 

CREATE TABLE `[[dbprefix]]search` (
  `id` int(11) NOT NULL auto_increment,
  `xid` int(11) NOT NULL default '0',
  `f_stat` int(4) NOT NULL default '0',
  `track` int(4) NOT NULL default '0',
  `year` int(4) NOT NULL default '0',
  `title` varchar(255) NOT NULL default '',
  `comment` varchar(255) NOT NULL default '',
  `dirname` varchar(255) NOT NULL default '',
  `free` varchar(255) NOT NULL default '',
  `fpath` mediumblob NOT NULL,
  `fname` tinyblob NOT NULL,
  `album` varchar(255) NOT NULL default '',
  `artist` varchar(255) NOT NULL default '',
  `md5` varchar(32) NOT NULL default '',
  `hits` int(4) NOT NULL default '0',
  `mtime` int(4) NOT NULL default '0',
  `ltime` int(4) NOT NULL default '0',
  `date` int(4) NOT NULL default '0',
  `fsize` int(4) NOT NULL default '0',
  `genre` int(4) NOT NULL default '255',
  `bitrate` int(4) NOT NULL default '0',
  `ratemode` tinyint(4) default '0',
  `lengths` int(4) NOT NULL default '0',
  `drive` tinyint(4) default '0',
  `ftypeid` int(4) NOT NULL default '-1',
  `id3image` char(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `xid` (`xid`),
  KEY `dirname` (`dirname`),
  KEY `free` (`free`),
  KEY `artist` (`artist`),
  KEY `album` (`album`),
  KEY `title` (`title`),
  KEY `fsize` (`fsize`),
  KEY `date` (`date`),
  KEY `f_stat` (`f_stat`),
  KEY `drive` (`drive`),
  KEY `ftypeid` (`ftypeid`),
  KEY `fname` (`fname`(255)),
  KEY `fpath` (`fpath`(255))
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]search`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]session`
-- 

CREATE TABLE `[[dbprefix]]session` (
  `sessionid` bigint(16) NOT NULL auto_increment,
  `u_id` int(4) NOT NULL default '0',
  `ip` int(4) NOT NULL default '0',
  `login` int(4) NOT NULL default '0',
  `refreshed` int(4) NOT NULL default '0',
  `logout` int(4) NOT NULL default '0',
  `sstatus` int(4) NOT NULL default '0',
  PRIMARY KEY  (`sessionid`),
  KEY `u_id` (`u_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]session`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]templist`
-- 

CREATE TABLE `[[dbprefix]]templist` (
  `rid` int(4) NOT NULL auto_increment,
  `uid` int(4) NOT NULL default '0',
  `sid` int(4) NOT NULL default '0',
  PRIMARY KEY  (`rid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]templist`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]users`
-- 

CREATE TABLE `[[dbprefix]]users` (
  `u_name` varchar(64) NOT NULL default '',
  `u_pass` varchar(32) NOT NULL default '',
  `u_login` varchar(32) NOT NULL default '',
  `u_comment` varchar(64) default '',
  `u_id` int(4) NOT NULL auto_increment,
  `u_booted` tinyint(4) NOT NULL default '0',
  `u_status` tinyint(4) NOT NULL default '0',
  `u_access` tinyint(4) default '1',
  `u_allowdownload` char(1) NOT NULL default '1',
  `allowarchive` char(1) NOT NULL default '1',
  `archivesize` int(4) NOT NULL default '0',
  `extm3u` char(1) NOT NULL default '1',
  `defplaylist` int(4) NOT NULL default '0',
  `defshplaylist` int(4) NOT NULL default '0',
  `defaultid3` char(1) NOT NULL default '0',
  `defstationid` int(4) NOT NULL default '0',
  `defaultsearch` int(1) NOT NULL default '0',
  `partymode` char(1) NOT NULL default '0',
  `theme` int(4) NOT NULL default '1',
  `lockedtime` int(8) NOT NULL default '0',
  `hotrows` int(4) NOT NULL default '21',
  `searchrows` int(4) NOT NULL default '21',
  `detailrows` int(4) NOT NULL default '5',
  `lang` tinyint(4) NOT NULL default '0',
  `udlrate` int(4) NOT NULL default '0',
  `defgenre` int(4) NOT NULL default '0',
  `archer` char(1) NOT NULL default '0',
  `hitsas` tinyint(4) NOT NULL default '0',
  `lameperm` char(1) NOT NULL default '0',
  `lamerate` int(4) NOT NULL default '0',
  `allowemail` char(1) NOT NULL default '0',
  `email` varchar(128) NOT NULL default '',
  `plinline` char(1) NOT NULL default '1',
  `hotmode` int(4) NOT NULL default '0',
  `created` int(4) NOT NULL default '0',
  `laston` int(4) NOT NULL default '0',
  `pltype` int(4) NOT NULL default '1',
  `orsearch` char(1) NOT NULL default '0',
  `textcut` int(2) NOT NULL default '80',
  `dircolumn` int(2) NOT NULL default '1',
  `streamengine` char(1) NOT NULL default '1',
  `utemplate` char(1) NOT NULL default '0',
  `homedir` varchar(255) NOT NULL default '',
  `detailview` char(1) NOT NULL default '0',
  `forcelamerate` int(4) NOT NULL default '0',
  `network` char(1) NOT NULL default '0',
  PRIMARY KEY  (`u_id`),
  UNIQUE KEY `u_login` (`u_login`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]users`
-- 

INSERT INTO `[[dbprefix]]users` VALUES ('[[admin_username]]', '[[admin_pass]]', '[[admin_username]]', 'admin', 1, 0, 0, 0, '1', '1', 0, '1', 0, 0, '0', 0, 0, '0', 1, 0, 21, 21, 5, 0, 0, 0, '0', 0, '0', 0, '0', '[[admin_email]]', '1', 0, [[timestamp]], 0, 1, '0', 80, 1, '1', '0', '', '0', 0, '0');
